/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUI;
import com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUISelectorAdaptor;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ar.OtherBillTypeEnum;
import com.kingdee.eas.fi.ar.client.AbstractAccountBadDebtBackQueryUI;
import com.kingdee.eas.fi.ar.client.OtherBillQueryUI;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.client.util.ComBoxInfo;
import com.kingdee.eas.fi.ar.client.util.CommonClientUtils;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class AccountBadDebtBackQueryUI
extends AbstractAccountBadDebtBackQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(OtherBillQueryUI.class);
    private static final BigDecimal ZERO = new BigDecimal("0.0");
    private CompanyOrgUnitInfo currentCompany = null;
    private CurrencyInfo baseCurrency = null;
    private AsstActTypeInfo asstActTypeInfo = null;
    private boolean isMaterialBill = true;
    private boolean isPrepareCurrency = false;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        boolean bl = this.isPrepareCurrency = !CommonClientUtils.isDisplayLocalCurrency();
        if (this.currentCompany.getBaseCurrency() != null) {
            this.baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId()));
        } else {
            MsgBox.showInfo((String)ArApBillUIUtil.getStrResource("currentBaseCurrencyIsNull"));
            SysUtil.abort();
        }
        BaseDataUtil.makeBillAsstActType(this.kdComAsstActType);
        this.kDBizPrCompany.setData((Object)this.currentCompany);
        if (this.isPrepareCurrency()) {
            this.kDBizCurrency.setVisible(true);
            this.kDBizCurrency.setEditable(true);
            this.kDBizCurrency.setDisplayFormat("$name$");
            this.kDBizCurrency.setEditFormat("$number$");
            this.kDBizCurrency.setCommitFormat("$number$");
            this.kDBizCurrency.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
            this.kDBizCurrency.setValue((Object)this.baseCurrency);
        } else {
            this.kDBizCurrency.setEnabled(false);
            this.kDBizCurrency.setData((Object)ArClientUtils.getIntegrateLocalCurrency());
        }
        this.kdComSourceBillType.removeAllItems();
        this.kdComSourceBillType.addItem((Object)ArApBillUIUtil.getStrResource("itemAll"));
        this.kdComSourceBillType.addItem((Object)OtherBillTypeEnum.InvoiceBill);
        this.kdComSourceBillType.addItem((Object)OtherBillTypeEnum.ExpenseInvoice);
        this.kdComSourceBillType.addItem((Object)OtherBillTypeEnum.DebitAdjust);
        this.kdComSourceBillType.addItem((Object)OtherBillTypeEnum.OtherReceivable);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (this.kDBizPrCompany.getData() != null) {
            String companyId = ((CompanyOrgUnitInfo)this.kDBizPrCompany.getData()).getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
            filter.setMaskString(" #0");
        }
        viewInfo.setFilter(filter);
        this.kDBizBillNumFrom.setEntityViewInfo(viewInfo);
        this.kDBizBillNumTo.setEntityViewInfo(viewInfo);
        this.kDBizBillNumFrom.setVisible(true);
        this.kDBizBillNumFrom.setEditFormat("$number$");
        this.kDBizBillNumFrom.setDisplayFormat("$number$");
        this.kDBizBillNumFrom.setCommitFormat("$number$");
        this.kDBizBillNumFrom.setQueryInfo("com.kingdee.eas.fi.ar.app.F7OtherBillQuery");
        this.kDBizBillNumTo.setVisible(true);
        this.kDBizBillNumTo.setEditFormat("$number$");
        this.kDBizBillNumTo.setDisplayFormat("$number$");
        this.kDBizBillNumTo.setCommitFormat("$number$");
        this.kDBizBillNumTo.setQueryInfo("com.kingdee.eas.fi.ar.app.F7OtherBillQuery");
        this.kdBillDateFrom.setEditable(true);
        this.kdBillDateTo.setEditable(true);
        this.kdBillDateFrom.setRequired(true);
        this.kdBillDateTo.setRequired(true);
        this.setMaterialF7(this.prmtMaterialFrom);
        this.setMaterialF7(this.prmtMaterialTo);
        this.setExpenseItemF7(this.prmtExpenseItemFrom);
        this.setExpenseItemF7(this.prmtExpenseItemTo);
        BaseDataUtil.setSaleOrgUnit(this.prmtSaleOrgFrom);
        BaseDataUtil.setSaleOrgUnit(this.prmtSaleOrgTo);
    }

    public boolean verify() {
        if (this.kDBizCurrency.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("ar_bill_currencyIsNull"));
            this.kDBizCurrency.setFocusCycleRoot(true);
            SysUtil.abort();
        }
        return super.verify();
    }

    public FilterInfo getFilterInfo() {
        FilterItemInfo fromNumberFilter;
        String strNumber;
        this.filterInfo = new FilterInfo();
        Object cussInfo = null;
        if (this.kDBizPrCompany.getData() != null) {
            String companyId = this.currentCompany.getId().toString();
            FilterItemInfo companyFilter = new FilterItemInfo("company.fid", (Object)companyId, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(companyFilter);
        }
        if (this.kdComSourceBillType.getSelectedItem() != null && this.kdComSourceBillType.getSelectedItem() instanceof OtherBillTypeEnum) {
            OtherBillTypeEnum billType = (OtherBillTypeEnum)this.kdComSourceBillType.getSelectedItem();
            FilterItemInfo billTypeFilter = new FilterItemInfo("otherbill.FBillType", (Object)Integer.valueOf(String.valueOf(billType.getValue())), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(billTypeFilter);
        }
        if (this.kdBillDateFrom.getTimestamp() != null) {
            FilterItemInfo fromBillDateFilter = new FilterItemInfo("otherbill.FBillDate", (Object)BaseDataUtil.downTimestamp(this.kdBillDateFrom.getTimestamp()), CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(fromBillDateFilter);
        }
        if (this.kdBillDateTo.getTimestamp() != null) {
            FilterItemInfo toBillDateFilter = new FilterItemInfo("otherbill.FBillDate", (Object)BaseDataUtil.upTimestamp(this.kdBillDateTo.getTimestamp()), CompareType.LESS);
            this.filterInfo.getFilterItems().add(toBillDateFilter);
        }
        if (this.kDBizCurrency.getData() != null) {
            String currencyId = ((CurrencyInfo)this.kDBizCurrency.getData()).getId().toString();
            FilterItemInfo currencyFilter = null;
            if (this.isPrepareCurrency()) {
                currencyFilter = new FilterItemInfo("currency.Fid", (Object)currencyId, CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(currencyFilter);
            }
        }
        if (this.kdComAsstActType.getSelectedItem() != null) {
            Object asst = null;
            String assActTypeId = ((AsstActTypeInfo)((ComBoxInfo)this.kdComAsstActType.getSelectedItem()).getobjInfo()).getId().toString();
            FilterItemInfo asstActTypeFiter = new FilterItemInfo("asstActType.Fid", (Object)assActTypeId, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(asstActTypeFiter);
        }
        if (this.prmtAcctCussentFrom.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.prmtAcctCussentFrom);
            fromNumberFilter = new FilterItemInfo("otherbill.FAsstActNumber", (Object)strNumber, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(fromNumberFilter);
        }
        if (this.prmtAcctCussentTo.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.prmtAcctCussentTo);
            fromNumberFilter = new FilterItemInfo("otherbill.FAsstActNumber", (Object)strNumber, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(fromNumberFilter);
        }
        if (this.prmtMaterialFrom.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.prmtMaterialFrom);
            fromNumberFilter = new FilterItemInfo("material.Fnumber", (Object)strNumber, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(fromNumberFilter);
        }
        if (this.prmtMaterialTo.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.prmtMaterialTo);
            fromNumberFilter = new FilterItemInfo("material.Fnumber", (Object)strNumber, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(fromNumberFilter);
        }
        if (this.prmtExpenseItemFrom.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.prmtExpenseItemFrom);
            fromNumberFilter = new FilterItemInfo("expenseItem.Fnumber", (Object)strNumber, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(fromNumberFilter);
        }
        if (this.prmtExpenseItemTo.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.prmtExpenseItemTo);
            fromNumberFilter = new FilterItemInfo("expenseItem.Fnumber", (Object)strNumber, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(fromNumberFilter);
        }
        if (this.prmtSaleOrgFrom.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.prmtSaleOrgFrom);
            fromNumberFilter = new FilterItemInfo("saleOrg.FNumber", (Object)strNumber, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(fromNumberFilter);
        }
        if (this.prmtSaleOrgTo.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.prmtSaleOrgTo);
            fromNumberFilter = new FilterItemInfo("saleOrg.FNumber", (Object)strNumber, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(fromNumberFilter);
        }
        if (this.kDBizBillNumFrom.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.kDBizBillNumFrom);
            fromNumberFilter = new FilterItemInfo("otherbill.FNumber", (Object)strNumber, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(fromNumberFilter);
        }
        if (this.kDBizBillNumTo.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.kDBizBillNumTo);
            FilterItemInfo toNumberFilter = new FilterItemInfo("otherbill.FNumber", (Object)strNumber, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(toNumberFilter);
        }
        FilterItemInfo preparedDataFilter = null;
        preparedDataFilter = this.isPrepareCurrency() ? new FilterItemInfo("entry.FPreparedBadAmount", (Object)ZERO, CompareType.GREATER) : new FilterItemInfo("entry.FPreparedBadAmountLocal", (Object)ZERO, CompareType.GREATER);
        this.filterInfo.getFilterItems().add(preparedDataFilter);
        StringBuffer sbFormula = new StringBuffer();
        if (this.filterInfo.getFilterItems() != null && this.filterInfo.getFilterItems().size() > 0) {
            sbFormula.append("(").append(" ").append("#").append(0).append(" ").append(")").append(" ");
            int size = this.filterInfo.getFilterItems().size();
            for (int i = 1; i < size; ++i) {
                sbFormula.append("and").append(" ").append("(").append(" ").append("#").append(i).append(" ").append(")").append(" ");
            }
        }
        this.filterInfo.setMaskString(sbFormula.toString());
        return this.filterInfo;
    }

    private boolean isPrepareCurrency() {
        return this.isPrepareCurrency;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clear();
        super.loadData(entityViewInfo);
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter().getFilterItems();
        block0: for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            int j;
            int itemCount;
            String propName = currentFilterItemCollection.get(i).getPropertyName();
            Object compVal = currentFilterItemCollection.get(i).getCompareValue();
            CompareType comp = currentFilterItemCollection.get(i).getCompareType();
            if ("company.Fid".equalsIgnoreCase(propName)) {
                this.kDBizPrCompany.setData((Object)this.currentCompany);
                continue;
            }
            if ("currency.Fid".equalsIgnoreCase(propName)) {
                this.setBizPromptData(this.kDBizCurrency, compVal.toString());
                continue;
            }
            if ("otherbill.FbillDate".equalsIgnoreCase(propName)) {
                if (CompareType.GREATER_EQUALS.equals((Object)comp)) {
                    this.kdBillDateFrom.setValue(compVal);
                    continue;
                }
                if (!CompareType.LESS.equals((Object)comp)) continue;
                this.kdBillDateTo.setValue(compVal);
                continue;
            }
            if ("otherbill.Fnumber".equalsIgnoreCase(propName)) {
                if (CompareType.GREATER_EQUALS.equals((Object)comp)) {
                    this.kDBizBillNumFrom.setValue(compVal);
                    continue;
                }
                if (!CompareType.LESS_EQUALS.equals((Object)comp)) continue;
                this.kDBizBillNumTo.setValue(compVal);
                continue;
            }
            if ("otherbill.FBillType".equalsIgnoreCase(propName)) {
                itemCount = this.kdComSourceBillType.getItemCount();
                for (j = 0; j < itemCount; ++j) {
                    OtherBillTypeEnum billType;
                    if (!(this.kdComSourceBillType.getItemAt(j) instanceof OtherBillTypeEnum) || (billType = (OtherBillTypeEnum)this.kdComSourceBillType.getItemAt(j)).getValue() != Integer.parseInt(compVal.toString())) continue;
                    this.kdComSourceBillType.setSelectedIndex(j);
                    continue block0;
                }
                continue;
            }
            if ("asstActType.Fid".equalsIgnoreCase(propName)) {
                itemCount = this.kdComAsstActType.getItemCount();
                for (j = 0; j < itemCount; ++j) {
                    String assActTypeId = ((AsstActTypeInfo)((ComBoxInfo)this.kdComAsstActType.getItemAt(j)).getobjInfo()).getId().toString();
                    if (!assActTypeId.equals(compVal.toString())) continue;
                    this.kdComAsstActType.setSelectedIndex(j);
                    continue block0;
                }
                continue;
            }
            if ("otherbill.FasstActNumber".equalsIgnoreCase(propName)) {
                if (CompareType.GREATER_EQUALS.equals((Object)comp)) {
                    this.prmtAcctCussentFrom.setValue(compVal);
                    continue;
                }
                if (!CompareType.LESS_EQUALS.equals((Object)comp)) continue;
                this.prmtAcctCussentTo.setValue(compVal);
                continue;
            }
            if ("material.Fnumber".equalsIgnoreCase(propName)) {
                if (CompareType.GREATER_EQUALS.equals((Object)comp)) {
                    this.prmtMaterialFrom.setValue(compVal);
                    continue;
                }
                if (!CompareType.LESS_EQUALS.equals((Object)comp)) continue;
                this.prmtMaterialTo.setValue(compVal);
                continue;
            }
            if ("expenseItem.Fnumber".equalsIgnoreCase(propName)) {
                if (CompareType.GREATER_EQUALS.equals((Object)comp)) {
                    this.prmtExpenseItemFrom.setValue(compVal);
                    continue;
                }
                if (!CompareType.LESS_EQUALS.equals((Object)comp)) continue;
                this.prmtExpenseItemTo.setValue(compVal);
                continue;
            }
            if (!"saleOrg.FNumber".equalsIgnoreCase(propName)) continue;
            if (CompareType.GREATER_EQUALS.equals((Object)comp)) {
                this.prmtSaleOrgFrom.setValue(compVal);
                continue;
            }
            if (!CompareType.LESS_EQUALS.equals((Object)comp)) continue;
            this.prmtSaleOrgTo.setValue(compVal);
        }
    }

    public void clear() {
        this.kdBillDateFrom.setValue(null);
        this.kdBillDateTo.setValue(null);
        this.kDBizBillNumFrom.setValue(null);
        this.kDBizBillNumTo.setValue(null);
        this.kdComSourceBillType.setSelectedIndex(0);
        this.kdComAsstActType.setSelectedIndex(0);
        this.prmtAcctCussentFrom.setValue(null);
        this.prmtAcctCussentTo.setValue(null);
        this.prmtMaterialFrom.setValue(null);
        this.prmtMaterialTo.setValue(null);
        this.prmtExpenseItemFrom.setValue(null);
        this.prmtExpenseItemTo.setValue(null);
        this.prmtSaleOrgFrom.setValue(null);
        this.prmtSaleOrgTo.setValue(null);
    }

    private void setBizPromptData(KDBizPromptBox bizPrompt, String id) {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(id);
            IObjectValue objVal = DynamicObjectFactory.getRemoteInstance().getValue(pk.getObjectType(), (IObjectPK)pk);
            bizPrompt.setData((Object)objVal);
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
    }

    @Override
    protected void kdComAsstActType_itemStateChanged(ItemEvent e) throws Exception {
        this.prmtAcctCussentFrom.setValue(null);
        this.prmtAcctCussentTo.setValue(null);
        if (this.kdComAsstActType.getItemCount() == 0 || this.kdComAsstActType.getSelectedItem() == null) {
            this.prmtAcctCussentFrom.setEnabled(false);
            this.prmtAcctCussentTo.setEnabled(false);
            return;
        }
        this.asstActTypeInfo = (AsstActTypeInfo)((ComBoxInfo)this.kdComAsstActType.getSelectedItem()).getobjInfo();
        if (this.asstActTypeInfo == null) {
            this.prmtAcctCussentFrom.setEnabled(false);
            this.prmtAcctCussentTo.setEnabled(false);
            return;
        }
        ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmtAcctCussentFrom, this.asstActTypeInfo, this.currentCompany.getId().toString(), true);
        ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmtAcctCussentTo, this.asstActTypeInfo, this.currentCompany.getId().toString(), true);
        this.prmtAcctCussentFrom.setEnabled(true);
        this.prmtAcctCussentTo.setEnabled(true);
        super.kdComAsstActType_itemStateChanged(e);
    }

    @Override
    protected void kdComSourceBillType_itemStateChanged(ItemEvent e) throws Exception {
        super.kdComSourceBillType_itemStateChanged(e);
        if (this.kdComSourceBillType.getSelectedItem() instanceof VerificateBillTypeEnum) {
            this.prmtMaterialFrom.setEnabled(true);
            this.prmtMaterialTo.setEnabled(true);
            this.prmtExpenseItemFrom.setEnabled(true);
            this.prmtExpenseItemTo.setEnabled(true);
        } else {
            this.prmtMaterialFrom.setEnabled(false);
            this.prmtMaterialTo.setEnabled(false);
            this.prmtExpenseItemFrom.setEnabled(false);
            this.prmtExpenseItemTo.setEnabled(false);
        }
        this.isMaterialBill = this.kdComSourceBillType.getSelectedItem() == null || !this.kdComSourceBillType.getSelectedItem().equals(VerificateBillTypeEnum.OtherReceiveBill) && !this.kdComSourceBillType.getSelectedItem().equals(VerificateBillTypeEnum.SaleChargeInvoice);
        if (!this.isMaterialBill) {
            this.prmtMaterialFrom.setValue(null);
            this.prmtMaterialTo.setValue(null);
            this.kDLabelContainer5.setVisible(false);
            this.kDLabelContainer6.setVisible(false);
            this.kDLabelContainer9.setVisible(true);
            this.kDLabelContainer10.setVisible(true);
        } else {
            this.prmtExpenseItemFrom.setValue(null);
            this.prmtExpenseItemTo.setValue(null);
            this.kDLabelContainer5.setVisible(true);
            this.kDLabelContainer6.setVisible(true);
            this.kDLabelContainer9.setVisible(false);
            this.kDLabelContainer10.setVisible(false);
        }
    }

    private void setMaterialF7(KDBizPromptBox bizPrmtBox) {
        bizPrmtBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialSalesQuery");
        bizPrmtBox.setEditFormat("$number$");
        bizPrmtBox.setDisplayFormat("$number$");
        bizPrmtBox.setCommitFormat("$number$");
        try {
            F7MaterialMultiUISelectorAdaptor selectorLisenterMaterial = null;
            selectorLisenterMaterial = new F7MaterialMultiUISelectorAdaptor((KDPromptBox)bizPrmtBox, (Component)new F7MaterialMultiUI(), (Object)this, "C79FC042", "com.kingdee.eas.basedata.master.material.app.F7MaterialFIQuery", "materialGroup.id");
            bizPrmtBox.setSelector((KDPromptSelector)selectorLisenterMaterial);
            bizPrmtBox.addSelectorListener((SelectorListener)selectorLisenterMaterial);
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        bizPrmtBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialSalesQuery");
        this.setMaterialprmtEntityView(this.currentCompany, bizPrmtBox);
    }

    private void setMaterialprmtEntityView(CompanyOrgUnitInfo companyOrgInfo, KDBizPromptBox bizPrmtBox) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (companyOrgInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)companyOrgInfo.getId(), CompareType.EQUALS));
            viewInfo.setFilter(filter);
            bizPrmtBox.setEntityViewInfo(viewInfo);
        }
    }

    private void setExpenseItemF7(KDBizPromptBox bizPrmtBox) {
        bizPrmtBox.setSelector(null);
        bizPrmtBox.setEditFormat("$number$");
        bizPrmtBox.setDisplayFormat("$number$");
        bizPrmtBox.setCommitFormat("$number$");
        bizPrmtBox.setEditable(true);
        bizPrmtBox.setQueryInfo("com.kingdee.eas.cp.bc.app.ExpenseTypeQuery");
    }

    protected void assignSelector(KDPromptBox promptBox, KDPromptSelector selector) {
        promptBox.setSelector(selector);
    }

    private boolean isNeedChecked() {
        boolean arIsRltdAccunt = false;
        boolean glIsStart = false;
        try {
            arIsRltdAccunt = ArClientUtils.arIsRelatedAccount(this.currentCompany);
            glIsStart = CommonClientUtils.glIsStart(this.currentCompany);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return arIsRltdAccunt && glIsStart;
    }

    public String getStrResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)key);
    }
}

