/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUI;
import com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUISelectorAdaptor;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.OtherBillTypeEnum;
import com.kingdee.eas.fi.ar.client.AbstractAccountBadDebtBillAnalysisQueryUI;
import com.kingdee.eas.fi.ar.client.OtherBillQueryUI;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.client.util.ComBoxInfo;
import com.kingdee.eas.fi.ar.client.util.CommonClientUtils;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class AccountBadDebtBillAnalysisQueryUI
extends AbstractAccountBadDebtBillAnalysisQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(OtherBillQueryUI.class);
    private static final BigDecimal ZERO = new BigDecimal("0.0");
    private CompanyOrgUnitInfo currentCompany = null;
    private CurrencyInfo baseCurrency = null;
    private AsstActTypeInfo asstActTypeInfo = null;
    private boolean isMaterialBill = true;
    public boolean isPreparedData = false;
    private boolean isPrepareCurrency = false;
    private PeriodInfo currPeriod = null;
    protected transient ArApSysParamInfo sysInfo = null;
    protected transient HashMap map = new HashMap();
    protected transient IArApBillFacade iBillFacade = ArApBillFacadeFactory.getRemoteInstance();

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void getSysParams() throws EASBizException, BOSException {
        this.map.put("isSCM", Boolean.FALSE);
        this.map.put("sysEnum", SystemEnum.ACCOUNTSRECEIVABLE);
        this.sysInfo = this.iBillFacade.getSysParams(null, this.map);
    }

    private void setAsstActType() throws EASBizException, BOSException {
        this.getSysParams();
        ArApBillUIUtil.setAsstActType(this.kdComAsstActType, this.sysInfo, false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        if (this.currentCompany.getBaseCurrency() != null) {
            this.baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId()));
        } else {
            MsgBox.showInfo((String)ArApBillUIUtil.getStrResource("currentBaseCurrencyIsNull"));
            SysUtil.abort();
        }
        this.setAsstActType();
        this.kDBizPrCompany.setData((Object)this.currentCompany);
        this.isPrepareCurrency = !CommonClientUtils.isDisplayLocalCurrency();
        this.currPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)this.currentCompany);
        if (this.isPrepareCurrency()) {
            this.kDBizCurrency.setVisible(true);
            this.kDBizCurrency.setEditable(true);
            this.kDBizCurrency.setDisplayFormat("$name$");
            this.kDBizCurrency.setEditFormat("$number$");
            this.kDBizCurrency.setCommitFormat("$number$");
            this.kDBizCurrency.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
            this.kDBizCurrency.setValue((Object)this.baseCurrency);
        } else {
            this.kDBizCurrency.setEnabled(false);
            this.kDBizCurrency.setData((Object)ArClientUtils.getIntegrateLocalCurrency());
        }
        this.kdComSourceBillType.removeAllItems();
        this.kdComSourceBillType.addItem((Object)ArApBillUIUtil.getStrResource("itemAll"));
        this.kdComSourceBillType.addItem((Object)OtherBillTypeEnum.InvoiceBill);
        this.kdComSourceBillType.addItem((Object)OtherBillTypeEnum.ExpenseInvoice);
        this.kdComSourceBillType.addItem((Object)OtherBillTypeEnum.DebitAdjust);
        this.kdComSourceBillType.addItem((Object)OtherBillTypeEnum.OtherReceivable);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (this.kDBizPrCompany.getData() != null) {
            String companyId = ((CompanyOrgUnitInfo)this.kDBizPrCompany.getData()).getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
            filter.setMaskString(" #0");
        }
        viewInfo.setFilter(filter);
        this.kDBizBillNumFrom.setEntityViewInfo(viewInfo);
        this.kDBizBillNumTo.setEntityViewInfo(viewInfo);
        this.kDBizBillNumFrom.setVisible(true);
        this.kDBizBillNumFrom.setEditFormat("$number$");
        this.kDBizBillNumFrom.setDisplayFormat("$number$");
        this.kDBizBillNumFrom.setCommitFormat("$number$");
        this.kDBizBillNumFrom.setQueryInfo("com.kingdee.eas.fi.ar.app.F7OtherBillQuery");
        this.kDBizBillNumTo.setVisible(true);
        this.kDBizBillNumTo.setEditFormat("$number$");
        this.kDBizBillNumTo.setDisplayFormat("$number$");
        this.kDBizBillNumTo.setCommitFormat("$number$");
        this.kDBizBillNumTo.setQueryInfo("com.kingdee.eas.fi.ar.app.F7OtherBillQuery");
        this.kdBillDateFrom.setEditable(true);
        this.kdBillDateFrom.setRequired(true);
        this.kdBillDateTo.setEditable(true);
        this.kdBillDateTo.setRequired(true);
        Timestamp maxDate = this.currPeriod.getEndDate();
        Date curDate = (Date)this.kdBillDateFrom.getValue();
        if (curDate.after(maxDate)) {
            this.kdBillDateFrom.setValue((Object)maxDate);
        }
        this.kdBillDateFrom.setMaximumDate((Date)maxDate);
        Date curDate1 = (Date)this.kdBillDateTo.getValue();
        if (curDate1.after(maxDate)) {
            this.kdBillDateTo.setValue((Object)maxDate);
        }
        this.kdBillDateTo.setMaximumDate((Date)maxDate);
        this.setMaterialF7(this.prmtMaterialFrom);
        this.setMaterialF7(this.prmtMaterialTo);
        this.setExpenseItemF7(this.prmtExpenseItemFrom);
        this.setExpenseItemF7(this.prmtExpenseItemTo);
    }

    public boolean verify() {
        if (this.kDBizCurrency.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("ar_bill_currencyIsNull"));
            this.kDBizCurrency.setFocusCycleRoot(true);
            SysUtil.abort();
        }
        return super.verify();
    }

    private boolean isPrepareCurrency() {
        return this.isPrepareCurrency;
    }

    public FilterInfo getFilterInfo() {
        FilterItemInfo fromNumberFilter;
        String strNumber;
        this.filterInfo = new FilterInfo();
        Object cussInfo = null;
        if (this.kDBizPrCompany.getData() != null) {
            String companyId = this.currentCompany.getId().toString();
            FilterItemInfo companyFilter = new FilterItemInfo("COMPANY.FID", (Object)companyId, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(companyFilter);
        }
        if (this.kdComSourceBillType.getSelectedItem() != null && this.kdComSourceBillType.getSelectedItem() instanceof OtherBillTypeEnum) {
            OtherBillTypeEnum billType = (OtherBillTypeEnum)this.kdComSourceBillType.getSelectedItem();
            FilterItemInfo billTypeFilter = new FilterItemInfo("OTHERBILL.FBillType", (Object)Integer.valueOf(String.valueOf(billType.getValue())), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(billTypeFilter);
        }
        if (this.kdBillDateFrom.getTimestamp() != null) {
            FilterItemInfo fromBillDateFilter = new FilterItemInfo("OTHERBILL.FBillDate", (Object)BaseDataUtil.downTimestamp(this.kdBillDateFrom.getTimestamp()), CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(fromBillDateFilter);
        }
        if (this.kdBillDateTo.getTimestamp() != null) {
            FilterItemInfo toBillDateFilter = new FilterItemInfo("OTHERBILL.FBillDate", (Object)BaseDataUtil.upTimestamp(this.kdBillDateTo.getTimestamp()), CompareType.LESS);
            this.filterInfo.getFilterItems().add(toBillDateFilter);
        }
        if (this.kDBizCurrency.getData() != null) {
            String currencyId = ((CurrencyInfo)this.kDBizCurrency.getData()).getId().toString();
            FilterItemInfo currencyFilter = null;
            if (this.isPrepareCurrency()) {
                currencyFilter = new FilterItemInfo("CURRENCY.FID", (Object)currencyId, CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(currencyFilter);
            }
        }
        if (this.kdComAsstActType.getSelectedItem() != null) {
            Object asst = null;
            String assActTypeId = ((AsstActTypeInfo)((ComBoxInfo)this.kdComAsstActType.getSelectedItem()).getobjInfo()).getId().toString();
            FilterItemInfo asstActTypeFiter = new FilterItemInfo("ASSTACTTYPE.FID", (Object)assActTypeId, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(asstActTypeFiter);
        }
        if (this.prmtAcctCussentFrom.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.prmtAcctCussentFrom);
            fromNumberFilter = new FilterItemInfo("OTHERBILL.FAsstActNumber", (Object)strNumber, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(fromNumberFilter);
        }
        if (this.prmtAcctCussentTo.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.prmtAcctCussentTo);
            fromNumberFilter = new FilterItemInfo("OTHERBILL.FAsstActNumber", (Object)strNumber, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(fromNumberFilter);
        }
        if (this.prmtMaterialFrom.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.prmtMaterialFrom);
            fromNumberFilter = new FilterItemInfo("Material.FNumber", (Object)strNumber, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(fromNumberFilter);
        }
        if (this.prmtMaterialTo.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.prmtMaterialTo);
            fromNumberFilter = new FilterItemInfo("Material.FNumber", (Object)strNumber, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(fromNumberFilter);
        }
        if (this.prmtExpenseItemFrom.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.prmtExpenseItemFrom);
            fromNumberFilter = new FilterItemInfo("ExpenseType.FNumber", (Object)strNumber, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(fromNumberFilter);
        }
        if (this.prmtExpenseItemTo.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.prmtExpenseItemTo);
            fromNumberFilter = new FilterItemInfo("ExpenseType.FNumber", (Object)strNumber, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(fromNumberFilter);
        }
        if (this.kDBizBillNumFrom.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.kDBizBillNumFrom);
            fromNumberFilter = new FilterItemInfo("OTHERBILL.FNumber", (Object)strNumber, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(fromNumberFilter);
        }
        if (this.kDBizBillNumTo.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.kDBizBillNumTo);
            FilterItemInfo toNumberFilter = new FilterItemInfo("OTHERBILL.FNumber", (Object)strNumber, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(toNumberFilter);
        }
        FilterItemInfo lockUnVerifyAmtFilter = new FilterItemInfo("ENTRY.FLockUnVerifyAmt", (Object)ZERO, CompareType.GREATER);
        this.filterInfo.getFilterItems().add(lockUnVerifyAmtFilter);
        StringBuffer sbFormula = new StringBuffer();
        if (this.filterInfo.getFilterItems() != null && this.filterInfo.getFilterItems().size() > 0) {
            sbFormula.append("(").append(" ").append("#").append(0).append(" ").append(")").append(" ");
            int size = this.filterInfo.getFilterItems().size();
            for (int i = 1; i < size; ++i) {
                sbFormula.append("and").append(" ").append("(").append(" ").append("#").append(i).append(" ").append(")").append(" ");
            }
        }
        this.filterInfo.setMaskString(sbFormula.toString());
        return this.filterInfo;
    }

    public boolean isPreparedData() {
        return this.isPreparedData;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter().getFilterItems();
        for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            int j;
            int itemCount;
            String propName = currentFilterItemCollection.get(i).getPropertyName();
            Object compVal = currentFilterItemCollection.get(i).getCompareValue();
            CompareType comp = currentFilterItemCollection.get(i).getCompareType();
            if ("COMPANY.FID".equalsIgnoreCase(propName)) {
                this.kDBizPrCompany.setData((Object)this.currentCompany);
                continue;
            }
            if ("CURRENCY.FID".equalsIgnoreCase(propName)) {
                this.setBizPromptData(this.kDBizCurrency, compVal.toString());
                continue;
            }
            if ("OTHERBILL.FBillDate".equalsIgnoreCase(propName)) {
                if (CompareType.GREATER_EQUALS.equals((Object)comp)) {
                    this.kdBillDateFrom.setValue(compVal);
                    continue;
                }
                if (!CompareType.LESS.equals((Object)comp)) continue;
                this.kdBillDateTo.setValue(compVal);
                continue;
            }
            if ("OTHERBILL.FNumber".equalsIgnoreCase(propName)) {
                if (CompareType.GREATER_EQUALS.equals((Object)comp)) {
                    this.kDBizBillNumFrom.setValue(compVal);
                    continue;
                }
                if (!CompareType.LESS_EQUALS.equals((Object)comp)) continue;
                this.kDBizBillNumTo.setValue(compVal);
                continue;
            }
            if ("OTHERBILL.FBillType".equalsIgnoreCase(propName)) {
                itemCount = this.kdComSourceBillType.getItemCount();
                for (j = 0; j < itemCount; ++j) {
                    OtherBillTypeEnum billType;
                    if (!(this.kdComSourceBillType.getItemAt(j) instanceof OtherBillTypeEnum) || (billType = (OtherBillTypeEnum)this.kdComSourceBillType.getItemAt(j)).getValue() != ((Integer)compVal).intValue()) continue;
                    this.kdComSourceBillType.setSelectedIndex(j);
                }
                continue;
            }
            if ("ASSTACTTYPE.FID".equalsIgnoreCase(propName)) {
                itemCount = this.kdComAsstActType.getItemCount();
                for (j = 0; j < itemCount; ++j) {
                    String assActTypeId = ((AsstActTypeInfo)((ComBoxInfo)this.kdComAsstActType.getItemAt(j)).getobjInfo()).getId().toString();
                    if (!assActTypeId.equals(compVal.toString())) continue;
                    this.kdComAsstActType.setSelectedIndex(j);
                }
                continue;
            }
            if ("OTHERBILL.FAsstActNumber".equalsIgnoreCase(propName)) {
                if (CompareType.GREATER_EQUALS.equals((Object)comp)) {
                    this.prmtAcctCussentFrom.setValue(compVal);
                    continue;
                }
                if (!CompareType.LESS_EQUALS.equals((Object)comp)) continue;
                this.prmtAcctCussentTo.setValue(compVal);
                continue;
            }
            if ("ENTRY.FMaterialID".equalsIgnoreCase(propName)) {
                if (CompareType.GREATER_EQUALS.equals((Object)comp)) {
                    this.prmtMaterialFrom.setValue(compVal);
                    continue;
                }
                if (!CompareType.LESS_EQUALS.equals((Object)comp)) continue;
                this.prmtMaterialTo.setValue(compVal);
                continue;
            }
            if (!"ENTRY.FExpenseItemID".equalsIgnoreCase(propName)) continue;
            if (CompareType.GREATER_EQUALS.equals((Object)comp)) {
                this.prmtExpenseItemFrom.setValue(compVal);
                continue;
            }
            if (!CompareType.LESS_EQUALS.equals((Object)comp)) continue;
            this.prmtExpenseItemTo.setValue(compVal);
        }
    }

    private void setBizPromptData(KDBizPromptBox bizPrompt, String id) {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(id);
            IObjectValue objVal = DynamicObjectFactory.getRemoteInstance().getValue(pk.getObjectType(), (IObjectPK)pk);
            bizPrompt.setData((Object)objVal);
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
    }

    @Override
    protected void kdComAsstActType_itemStateChanged(ItemEvent e) throws Exception {
        this.prmtAcctCussentFrom.setValue(null);
        this.prmtAcctCussentTo.setValue(null);
        if (this.kdComAsstActType.getItemCount() == 0 || this.kdComAsstActType.getSelectedItem() == null) {
            this.prmtAcctCussentFrom.setEnabled(false);
            this.prmtAcctCussentTo.setEnabled(false);
            return;
        }
        this.asstActTypeInfo = (AsstActTypeInfo)((ComBoxInfo)this.kdComAsstActType.getSelectedItem()).getobjInfo();
        if (this.asstActTypeInfo == null) {
            this.prmtAcctCussentFrom.setEnabled(false);
            this.prmtAcctCussentTo.setEnabled(false);
            return;
        }
        ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmtAcctCussentFrom, this.asstActTypeInfo, true);
        ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmtAcctCussentTo, this.asstActTypeInfo, true);
        this.prmtAcctCussentFrom.setEnabled(true);
        this.prmtAcctCussentTo.setEnabled(true);
        super.kdComAsstActType_itemStateChanged(e);
    }

    @Override
    protected void kdComSourceBillType_itemStateChanged(ItemEvent e) throws Exception {
        super.kdComSourceBillType_itemStateChanged(e);
        if (this.kdComSourceBillType.getSelectedItem() instanceof OtherBillTypeEnum) {
            this.prmtMaterialFrom.setEnabled(true);
            this.prmtMaterialTo.setEnabled(true);
            this.prmtExpenseItemFrom.setEnabled(true);
            this.prmtExpenseItemTo.setEnabled(true);
        } else {
            this.prmtMaterialFrom.setEnabled(false);
            this.prmtMaterialTo.setEnabled(false);
            this.prmtExpenseItemFrom.setEnabled(false);
            this.prmtExpenseItemTo.setEnabled(false);
        }
        this.isMaterialBill = this.kdComSourceBillType.getSelectedItem() == null || !this.kdComSourceBillType.getSelectedItem().equals(OtherBillTypeEnum.OtherReceivable) && !this.kdComSourceBillType.getSelectedItem().equals(OtherBillTypeEnum.ExpenseInvoice);
        if (!this.isMaterialBill) {
            this.prmtMaterialFrom.setValue(null);
            this.prmtMaterialTo.setValue(null);
            this.kDLabelContainer5.setVisible(false);
            this.kDLabelContainer6.setVisible(false);
            this.kDLabelContainer9.setVisible(true);
            this.kDLabelContainer10.setVisible(true);
        } else {
            this.prmtExpenseItemFrom.setValue(null);
            this.prmtExpenseItemTo.setValue(null);
            this.kDLabelContainer5.setVisible(true);
            this.kDLabelContainer6.setVisible(true);
            this.kDLabelContainer9.setVisible(false);
            this.kDLabelContainer10.setVisible(false);
        }
    }

    private void setMaterialF7(KDBizPromptBox bizPrmtBox) {
        bizPrmtBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialSalesQuery");
        bizPrmtBox.setEditFormat("$number$");
        bizPrmtBox.setDisplayFormat("$number$");
        bizPrmtBox.setCommitFormat("$number$");
        try {
            F7MaterialMultiUISelectorAdaptor selectorLisenterMaterial = null;
            selectorLisenterMaterial = new F7MaterialMultiUISelectorAdaptor((KDPromptBox)bizPrmtBox, (Component)new F7MaterialMultiUI(), (Object)this, "C79FC042", "com.kingdee.eas.basedata.master.material.app.F7MaterialFIQuery", "materialGroup.id");
            bizPrmtBox.setSelector((KDPromptSelector)selectorLisenterMaterial);
            bizPrmtBox.addSelectorListener((SelectorListener)selectorLisenterMaterial);
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        bizPrmtBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialSalesQuery");
        this.setMaterialprmtEntityView(this.currentCompany, bizPrmtBox);
    }

    private void setMaterialprmtEntityView(CompanyOrgUnitInfo companyOrgInfo, KDBizPromptBox bizPrmtBox) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (companyOrgInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)companyOrgInfo.getId(), CompareType.EQUALS));
            viewInfo.setFilter(filter);
            bizPrmtBox.setEntityViewInfo(viewInfo);
        }
    }

    private void setExpenseItemF7(KDBizPromptBox bizPrmtBox) {
        bizPrmtBox.setSelector(null);
        bizPrmtBox.setEditFormat("$number$");
        bizPrmtBox.setDisplayFormat("$number$");
        bizPrmtBox.setCommitFormat("$number$");
        bizPrmtBox.setEditable(true);
        bizPrmtBox.setQueryInfo("com.kingdee.eas.cp.bc.app.ExpenseTypeQuery");
    }

    protected void assignSelector(KDPromptBox promptBox, KDPromptSelector selector) {
        promptBox.setSelector(selector);
    }

    private boolean isNeedChecked() {
        boolean arIsRltdAccunt = false;
        boolean glIsStart = false;
        try {
            arIsRltdAccunt = ArClientUtils.arIsRelatedAccount(this.currentCompany);
            glIsStart = CommonClientUtils.glIsStart(this.currentCompany);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return arIsRltdAccunt && glIsStart;
    }

    public String getStrResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)key);
    }

    public void clear() {
        this.kDBizPrCompany.setData((Object)this.currentCompany);
        this.kdComSourceBillType.setSelectedIndex(0);
        this.kdBillDateFrom.setValue((Object)this.currPeriod.getEndDate());
        this.kdBillDateTo.setValue((Object)this.currPeriod.getEndDate());
        if (this.isPrepareCurrency()) {
            this.kDBizCurrency.setValue((Object)this.baseCurrency);
        } else {
            try {
                this.kDBizCurrency.setData((Object)ArClientUtils.getIntegrateLocalCurrency());
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
        }
        this.kdComAsstActType.setSelectedIndex(0);
        this.prmtAcctCussentFrom.setValue(null);
        this.prmtAcctCussentTo.setValue(null);
        this.prmtMaterialFrom.setValue(null);
        this.prmtMaterialTo.setValue(null);
        this.prmtExpenseItemFrom.setValue(null);
        this.prmtExpenseItemTo.setValue(null);
        this.kDBizBillNumFrom.setValue(null);
        this.kDBizBillNumTo.setValue(null);
    }
}

