/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.fi.ar.AccountBadDebtCustDetailInfo;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillTypeEnum;
import com.kingdee.eas.fi.ar.client.AbstractAccountBadDebtCustDetailListUI;
import com.kingdee.eas.fi.ar.client.AccountBadDebt_BD_RecePerUI;
import com.kingdee.eas.fi.ar.client.OtherBillEditUI;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.framework.ICoreBase;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AccountBadDebtCustDetailListUI
extends AbstractAccountBadDebtCustDetailListUI {
    private static final long serialVersionUID = -889433452535769602L;
    private static final Logger logger = CoreUIObject.getLogger(AccountBadDebtCustDetailListUI.class);
    private boolean isBizDate = false;
    String[] bizDateFields = new String[]{"bizDate", "amountLocal", "verifyAmountLocal", "unVerifyAmountLocal"};
    String[] recievePayDateFields = new String[]{"recievePlan.recievePayDate", "recievePlan.recievePayAmountLocal", "recievePlan.verifyAmountLocal", "unVerifyAmtLocal"};

    protected String[] getQueryHideField() {
        return new String[]{"asstActId", "billType"};
    }

    protected boolean isLazyMode() {
        return true;
    }

    protected void execQuery() {
        super.execQuery();
    }

    public void mergeSelectorBeforeExcuteQuery(EntityViewInfo ev) {
        SorterItemCollection sortColl = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("asstActNumber");
        sortInfo.setSortType(SortType.ASCEND);
        sortColl.add(sortInfo);
        SorterItemInfo dateSortInfo = new SorterItemInfo(this.isBizDate ? "bizDate" : "recievePlan.recievePayDate");
        dateSortInfo.setSortType(SortType.DESCEND);
        sortColl.add(dateSortInfo);
        ev.setSorter(sortColl);
        super.mergeSelectorBeforeExcuteQuery(ev);
    }

    public List<String> getFieldSumList() {
        List sumList = super.getFieldSumList();
        String[] hideFields = this.isBizDate ? this.recievePayDateFields : this.bizDateFields;
        for (int i = 0; i < hideFields.length; ++i) {
            if (!sumList.contains(hideFields[i])) continue;
            sumList.remove(hideFields[i]);
        }
        return sumList;
    }

    public void onLoad() throws Exception {
        String companyId = String.valueOf(this.getUIContext().get("companyId"));
        HashMap paramMap = new HashMap();
        paramMap.put("AR_BadDebt_02", companyId);
        paramMap = ArApParamHelper.getParamHashMap(null, paramMap);
        int AR_BadDebt_02 = Integer.valueOf((String)paramMap.get("AR_BadDebt_02"));
        if (AR_BadDebt_02 == 1) {
            this.isBizDate = true;
        }
        this.setMergeColumn(new String[]{"companyNumber", "companyName", "asstActNumber", "asstActName", "number"});
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.getMainTable().getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    AccountBadDebtCustDetailListUI.this.tbl_afterDataFill(e);
                }
                catch (ParseException e1) {
                    AccountBadDebtCustDetailListUI.this.handUIExceptionAndAbort(e1);
                }
            }
        });
        if (this.isBizDate) {
            for (int i = 0; i < this.recievePayDateFields.length; ++i) {
                this.tblMain.getColumn(this.recievePayDateFields[i]).getStyleAttributes().setHided(true);
                this.tblMain.getColumn(this.recievePayDateFields[i]).setWidth(-1);
            }
        } else {
            for (int i = 0; i < this.bizDateFields.length; ++i) {
                this.tblMain.getColumn(this.bizDateFields[i]).getStyleAttributes().setHided(true);
                this.tblMain.getColumn(this.bizDateFields[i]).setWidth(-1);
            }
        }
        super.onLoad();
        this.tblMain.getColumn("jtRate").getStyleAttributes().setNumberFormat("%r-[=]{#,##0.00}f");
        this.tblMain.getColumn("unVerifyAmtLocal").getStyleAttributes().setNumberFormat(String.valueOf(this.getUIContext().get("currPrecision")));
        this.tblMain.getColumn("recievePlan.recievePayAmountLocal").getStyleAttributes().setNumberFormat(String.valueOf(this.getUIContext().get("currPrecision")));
        this.tblMain.getColumn("recievePlan.verifyAmountLocal").getStyleAttributes().setNumberFormat(String.valueOf(this.getUIContext().get("currPrecision")));
        this.tblMain.getColumn("amountLocal").getStyleAttributes().setNumberFormat(String.valueOf(this.getUIContext().get("currPrecision")));
        this.tblMain.getColumn("verifyAmountLocal").getStyleAttributes().setNumberFormat(String.valueOf(this.getUIContext().get("currPrecision")));
        this.tblMain.getColumn("unVerifyAmountLocal").getStyleAttributes().setNumberFormat(String.valueOf(this.getUIContext().get("currPrecision")));
        this.mainQuery.setFilter(this.getFilterInfo(0));
        this.refreshList();
    }

    public void tbl_afterDataFill(KDTDataRequestEvent e) throws ParseException {
        if (null == this.getUIContext().get("accountAgeMapList")) {
            return;
        }
        Map accountAgeMapList = (Map)this.getUIContext().get("accountAgeMapList");
        int first = e.getFirstRow();
        int last = e.getLastRow();
        AccountBadDebt_BD_RecePerUI.AccountAge accountAge2 = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date periodEndDate = df.parse(this.getUIContext().get("currPeriodEndDate").toString());
        block0: for (int i = first; i <= last; ++i) {
            long days = (periodEndDate.getTime() - df.parse(this.getMainTable().getCell(i, this.isBizDate ? "bizDate" : "recievePlan.recievePayDate").getValue().toString()).getTime()) / 86400000L + 1L;
            String customerId = this.getMainTable().getCell(i, "asstActId").getValue().toString();
            List list = (List)accountAgeMapList.get(customerId);
            if (null == list || list.size() == 0) continue;
            for (AccountBadDebt_BD_RecePerUI.AccountAge accountAge2 : list) {
                if (!(days <= 0L && accountAge2.getStartDays() == 0 && accountAge2.getEndDays() == 0 || days >= (long)accountAge2.getStartDays() && days <= (long)accountAge2.getEndDays()) && (accountAge2.getStartDays() == 0 || days < (long)accountAge2.getStartDays() || accountAge2.getEndDays() != 0)) continue;
                this.getMainTable().getCell(i, "days").setValue((Object)accountAge2.getDaysDesc());
                this.getMainTable().getCell(i, "jtRate").setValue((Object)(this.rdInvoiceBill.isSelected() ? accountAge2.getJtRate() : accountAge2.getOtherJtRate()));
                continue block0;
            }
        }
    }

    private FilterInfo getFilterInfo(int isOtherBill) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", this.getUIContext().get("companyId")));
        filter.setMaskString("#" + (filter.getFilterItems().size() - 1));
        filter.getFilterItems().add(new FilterItemInfo("billDate", this.getUIContext().get("jtDate"), CompareType.LESS));
        filter.setMaskString(filter.getMaskString() + " AND #" + (filter.getFilterItems().size() - 1));
        if (this.getUIContext().get("custIds") != null) {
            filter.getFilterItems().add(new FilterItemInfo("asstActID", this.getUIContext().get("custIds"), CompareType.INCLUDE));
            filter.setMaskString(filter.getMaskString() + " AND #" + (filter.getFilterItems().size() - 1));
        }
        if (!((Boolean)this.getUIContext().get("isIncludeUndue")).booleanValue()) {
            filter.getFilterItems().add(new FilterItemInfo(this.isBizDate ? "bizDate" : "recievePlan.recievePayDate", this.getUIContext().get("jtDate"), CompareType.LESS_EQUALS));
            filter.setMaskString(filter.getMaskString() + " AND #" + (filter.getFilterItems().size() - 1));
        }
        if (((Boolean)this.getUIContext().get("isRelationGL")).booleanValue()) {
            filter.getFilterItems().add(new FilterItemInfo("fiVouchered", (Object)1));
            filter.setMaskString(filter.getMaskString() + " AND (#" + (filter.getFilterItems().size() - 1));
            filter.getFilterItems().add(new FilterItemInfo("billDate", this.getUIContext().get("startPeriodBeginDate"), CompareType.LESS));
            filter.setMaskString(filter.getMaskString() + " OR #" + (filter.getFilterItems().size() - 1) + ")");
        }
        if (isOtherBill == 1) {
            filter.getFilterItems().add(new FilterItemInfo("billType", (Object)101, CompareType.EQUALS));
            filter.setMaskString(filter.getMaskString() + " AND #" + (filter.getFilterItems().size() - 1));
        } else if (isOtherBill == 0) {
            filter.getFilterItems().add(new FilterItemInfo("billType", (Object)101, CompareType.NOTEQUALS));
            filter.setMaskString(filter.getMaskString() + " AND #" + (filter.getFilterItems().size() - 1));
        }
        filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)3));
        filter.setMaskString(filter.getMaskString() + " AND #" + (filter.getFilterItems().size() - 1));
        filter.getFilterItems().add(new FilterItemInfo("isBizBill", (Object)0));
        filter.setMaskString(filter.getMaskString() + " AND #" + (filter.getFilterItems().size() - 1));
        filter.getFilterItems().add(new FilterItemInfo("isNotJoinBadAccount", (Object)0));
        filter.setMaskString(filter.getMaskString() + " AND #" + (filter.getFilterItems().size() - 1));
        filter.getFilterItems().add(new FilterItemInfo("unVerifyAmtLocal", (Object)0, CompareType.NOTEQUALS));
        filter.setMaskString(filter.getMaskString() + " AND #" + (filter.getFilterItems().size() - 1));
        return filter;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return OtherBillFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return OtherBillEditUI.class.getName();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected String[] getQueryShowField() {
        if (this.isBizDate) {
            return new String[]{"company.number", "company.name", "asstActNumber", "asstActName", "number", "bizDate", "amountLocal", "verifyAmountLocal", "unVerifyAmountLocal", "days", "jtRate"};
        }
        return new String[]{"company.number", "company.name", "asstActNumber", "asstActName", "number", "recievePlan.recievePayDate", "recievePlan.recievePayAmountLocal", "recievePlan.verifyAmountLocal", "unVerifyAmtLocal", "days", "jtRate"};
    }

    protected SelectorItemCollection getCustomHideSelectors() {
        SelectorItemCollection sic = super.getCustomHideSelectors();
        if (this.isBizDate) {
            for (int i = 0; i < this.recievePayDateFields.length; ++i) {
                sic.add(this.recievePayDateFields[i]);
            }
        } else {
            for (int i = 0; i < this.bizDateFields.length; ++i) {
                sic.add(this.bizDateFields[i]);
            }
        }
        return sic;
    }

    private void setMergeColumn(String[] mergeColumnKeys) {
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                this.tblMain.getColumn(mergeColumnKeys[i]).setGroup(true);
                this.tblMain.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
    }

    @Override
    protected void rdInvoiceBill_actionPerformed(ActionEvent e) throws Exception {
        this.mainQuery.setFilter(this.getFilterInfo(0));
        this.refreshList();
    }

    @Override
    protected void rdOtherBill_actionPerformed(ActionEvent e) throws Exception {
        this.mainQuery.setFilter(this.getFilterInfo(1));
        this.refreshList();
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected boolean isOrderByIDForBill() {
        return false;
    }

    public List<AccountBadDebtCustDetailInfo> getTableData() throws Exception {
        AccountBadDebtCustDetailInfo info = null;
        int precision = Integer.valueOf(this.getUIContext().get("precision").toString());
        this.mainQuery.setFilter(this.getFilterInfo(-1));
        this.refreshList();
        int rowCount = this.tblMain.getRowCount();
        ArrayList<AccountBadDebtCustDetailInfo> rowDataList = new ArrayList<AccountBadDebtCustDetailInfo>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            info = new AccountBadDebtCustDetailInfo();
            Object asstActId = row.getCell("asstActId").getValue();
            if (asstActId != null) {
                CustomerInfo customerInfo = new CustomerInfo();
                customerInfo.setId(BOSUuid.read((String)asstActId.toString()));
                info.setCustomer(customerInfo);
            }
            info.setOtherbillNumber((String)row.getCell("number").getValue());
            info.setRecieveData((Date)row.getCell(this.isBizDate ? "bizDate" : "recievePlan.recievePayDate").getValue());
            info.setRecieveAmountLocal(this.getCellBigDecimalValue(row, this.isBizDate ? "amountLocal" : "recievePlan.recievePayAmountLocal"));
            info.setVerifyAmountLocal(this.getCellBigDecimalValue(row, this.isBizDate ? "verifyAmountLocal" : "recievePlan.verifyAmountLocal"));
            info.setUnVerifyAmountLocal(this.getCellBigDecimalValue(row, this.isBizDate ? "unVerifyAmountLocal" : "unVerifyAmtLocal"));
            info.setDays((String)row.getCell("days").getValue());
            BigDecimal jtRate = ((BigDecimal)row.getCell("jtRate").getValue()).setScale(precision);
            if (jtRate != null) {
                jtRate = jtRate.setScale(precision);
                info.setJtRate(jtRate.toString());
            }
            int billType = ((BizEnumValueDTO)row.getCell("billType").getValue()).getInt();
            info.setBillType(OtherBillTypeEnum.getEnum((int)billType));
            rowDataList.add(info);
        }
        return rowDataList;
    }

    public BigDecimal getCellBigDecimalValue(IRow row, String columnName) {
        BigDecimal result = BigDecimal.ZERO;
        if (row.getCell(columnName) != null && row.getCell(columnName).getValue() != null) {
            result = (BigDecimal)row.getCell(columnName).getValue();
        }
        return result;
    }
}

