/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroupStandard;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.client.F7CustomerTreeDetailListUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ar.BadAccountFacadeFactory;
import com.kingdee.eas.fi.ar.IBadAccountFacade;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.client.AbstractAccountBadDebtCustPrepareQueryUI;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.ar.client.util.CommonClientUtils;
import com.kingdee.eas.fi.arap.BaseServiceFacadeFactory;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccountBadDebtCustPrepareQueryUI
extends AbstractAccountBadDebtCustPrepareQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountBadDebtCustPrepareQueryUI.class);
    private Boolean isShowMuliCompany = false;
    public CompanyOrgUnitInfo currentCompany = null;
    private static final String PERMISSION = "fi_ar_customer_balance_query";
    public CurrencyInfo baseCurrency = null;
    public CurrencyInfo currency = null;
    private boolean isPrepareCurrency = false;

    public void onLoad() throws Exception {
        try {
            this.currentCompany = ArApBillHelper.getDefaultCompany(null, SysContext.getSysContext().getCurrentUserInfo(), SystemEnum.ACCOUNTSRECEIVABLE, PERMISSION);
        }
        catch (Exception ex) {
            SysUtil.abort();
        }
        this.isShowMuliCompany = this.isShowMuliCompany();
        super.onLoad();
        this.isPrepareCurrency = !CommonClientUtils.isDisplayLocalCurrency();
        this.baseCurrency = this.currentCompany.getBaseCurrency();
        this.bizPromptCompany.setData((Object)this.currentCompany);
        this.setCompanyF7();
    }

    private boolean isPrepareCurrency() {
        return this.isPrepareCurrency;
    }

    private void setCurrencyF7(boolean isSetData) throws Exception {
        if (this.isPrepareCurrency()) {
            this.bizPromptCurrency.setEditable(true);
            this.bizPromptCurrency.setEditFormat("$number$");
            this.bizPromptCurrency.setDisplayFormat("$name$");
            this.bizPromptCurrency.setCommitFormat("$number$");
            this.bizPromptCurrency.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("isoCode"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            this.bizPromptCurrency.setSelectorCollection(sic);
            if (isSetData) {
                this.bizPromptCurrency.setData((Object)this.baseCurrency);
            }
        } else {
            this.bizPromptCurrency.setEnabled(false);
            if (isSetData) {
                this.bizPromptCurrency.setData((Object)ArClientUtils.getIntegrateLocalCurrency());
            }
        }
    }

    public void setAsstActSelector(CoreUIObject ui, KDBizPromptBox bizPromptBox, Set companyIdSet) throws Exception {
        String queryInfo = "com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyQuery";
        bizPromptBox.setEditable(true);
        bizPromptBox.setDisplayFormat("$name$");
        bizPromptBox.setEditFormat("$number$");
        bizPromptBox.setCommitFormat("$number$;$mnemonicCode$");
        bizPromptBox.setVisible(true);
        bizPromptBox.setSelector(null);
        bizPromptBox.setEntityViewInfo(null);
        bizPromptBox.setQueryInfo(queryInfo);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(0), CompareType.GREATER));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyIdSet, CompareType.INCLUDE));
        ICSSPGroupStandard cSSPGroupStandard = CSSPGroupStandardFactory.getRemoteInstance();
        String groupStandardId = cSSPGroupStandard.getBasicStandardId("1");
        filter.getFilterItems().add(new FilterItemInfo("browseGroup.groupStandard", (Object)groupStandardId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        bizPromptBox.setEntityViewInfo(evi);
        if (bizPromptBox.getSelectorListeners() == null || bizPromptBox.getSelectorListeners().length == 0) {
            GeneralKDPromptSelectorAdaptor selectorLisenterCustomer = null;
            selectorLisenterCustomer = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizPromptBox, (Component)new F7CustomerTreeDetailListUI(), (Object)ui, CSSPGroupInfo.getBosType(), queryInfo, "browseGroup.id");
            AccountBadDebtCustPrepareQueryUI.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)selectorLisenterCustomer);
            bizPromptBox.addSelectorListener((SelectorListener)selectorLisenterCustomer);
        }
    }

    public static void assignSelector(KDPromptBox promptBox, KDPromptSelector selector) {
        promptBox.setSelector(selector);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public boolean verify() {
        if (this.bizPromptCurrency.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getStrApResource("lab_nocurrency"));
            SysUtil.abort();
        }
        return super.verify();
    }

    public FilterInfo getFilterInfo() {
        FilterItemInfo cussentFilter;
        String AsstActID;
        IObjectValue ICussent;
        this.filterInfo = new FilterInfo();
        Object object = this.bizPromptCompany.getData();
        Set companyIdSet = this.getIdSetByCompanyInfo(object);
        if (object != null) {
            FilterItemInfo companyFilter = new FilterItemInfo("companyid", (Object)companyIdSet, CompareType.INCLUDE);
            this.filterInfo.getFilterItems().add(companyFilter);
        }
        if (this.bizPromptCurrency.getData() != null) {
            this.currency = (CurrencyInfo)this.bizPromptCurrency.getData();
            String currencyID = this.currency.getId().toString();
            UIContext cntxt = new UIContext((Object)this);
            cntxt.put((Object)"account_bad_currencyid", (Object)currencyID);
            FilterItemInfo currencyFilter = null;
            if (this.isPrepareCurrency()) {
                currencyFilter = new FilterItemInfo("currencyid", (Object)currencyID, CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(currencyFilter);
            }
        }
        FilterItemInfo conditionFilter = new FilterItemInfo("prepareAmountFlag", (Object)this.kDComboBox1.getSelectedIndex(), CompareType.EQUALS);
        this.filterInfo.getFilterItems().add(conditionFilter);
        if (this.bizPromptCussentFrom.getData() != null && (ICussent = (IObjectValue)this.bizPromptCussentFrom.getData()) != null) {
            AsstActID = ICussent.getString("number");
            cussentFilter = new FilterItemInfo("number", (Object)AsstActID, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(cussentFilter);
        }
        if (this.bizPromptCussentTo.getData() != null && (ICussent = (IObjectValue)this.bizPromptCussentTo.getData()) != null) {
            AsstActID = ICussent.getString("number");
            cussentFilter = new FilterItemInfo("number", (Object)AsstActID, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(cussentFilter);
        }
        boolean needCal = this.ck_needcal.isSelected();
        FilterItemInfo needCalFilter = new FilterItemInfo("needCal", (Object)needCal, CompareType.EQUALS);
        this.filterInfo.getFilterItems().add(needCalFilter);
        return this.filterInfo;
    }

    public void clear() {
        this.bizPromptCompany.setData((Object)this.currentCompany);
        this.bizPromptCussentFrom.setData(null);
        this.bizPromptCussentTo.setData(null);
        this.kDComboBox1.setSelectedIndex(0);
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.clear();
        FilterItemCollection filterItemCollection = entityViewInfo.getFilter().getFilterItems();
        String sPropertyName = null;
        Object oCompareValue = null;
        CompareType ctCompare = null;
        for (int i = 0; i < filterItemCollection.size(); ++i) {
            sPropertyName = filterItemCollection.get(i).getPropertyName();
            oCompareValue = filterItemCollection.get(i).getCompareValue();
            ctCompare = filterItemCollection.get(i).getCompareType();
            if ("companyid".equalsIgnoreCase(sPropertyName)) {
                Set<Object> companyIdSet = new HashSet();
                if (oCompareValue == null) continue;
                if (oCompareValue instanceof Set) {
                    companyIdSet = (Set)oCompareValue;
                } else if (oCompareValue instanceof String) {
                    companyIdSet.add(oCompareValue);
                }
                try {
                    IObjectValue[] companyArr = this.getCompanyArr(companyIdSet);
                    this.bizPromptCompany.setDataNoNotify((Object)companyArr);
                    this.setCurrencyF7(false);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                continue;
            }
            if ("currencyid".equalsIgnoreCase(sPropertyName)) {
                if ("".equals(oCompareValue.toString())) continue;
                if (this.isPrepareCurrency()) {
                    this.setBizPromptData(this.bizPromptCurrency, oCompareValue.toString());
                    continue;
                }
                try {
                    this.bizPromptCurrency.setData((Object)ArClientUtils.getIntegrateLocalCurrency());
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
                continue;
            }
            if ("number".equalsIgnoreCase(sPropertyName)) {
                if (CompareType.GREATER_EQUALS.equals((Object)ctCompare)) {
                    this.bizPromptCussentFrom.setValue((Object)this.getCustomerByNumber(oCompareValue.toString()));
                    continue;
                }
                if (!CompareType.LESS_EQUALS.equals((Object)ctCompare)) continue;
                this.bizPromptCussentTo.setValue((Object)this.getCustomerByNumber(oCompareValue.toString()));
                continue;
            }
            if ("prepareAmountFlag".equalsIgnoreCase(sPropertyName)) {
                this.kDComboBox1.setSelectedIndex(Integer.parseInt(oCompareValue.toString()));
                continue;
            }
            if (!"needCal".equalsIgnoreCase(sPropertyName)) continue;
            this.ck_needcal.setSelected(new Boolean(oCompareValue.toString()).booleanValue());
        }
    }

    private CustomerInfo getCustomerByNumber(String number) {
        CustomerInfo customerInfo = null;
        try {
            ICustomer iCustomer = CustomerFactory.getRemoteInstance();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo numberFilter = new FilterItemInfo("number", (Object)number, CompareType.EQUALS);
            filterInfo.getFilterItems().add(numberFilter);
            view.setFilter(filterInfo);
            CustomerCollection customerCollection = iCustomer.getCustomerCollection(view);
            if (customerCollection.size() > 0) {
                customerInfo = customerCollection.get(0);
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return customerInfo;
    }

    private void setBizPromptData(KDBizPromptBox bizPrompt, String id) {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(id);
            IObjectValue objVal = DynamicObjectFactory.getRemoteInstance().getValue(pk.getObjectType(), (IObjectPK)pk);
            bizPrompt.setData((Object)objVal);
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
    }

    private String getStrApResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)key);
    }

    private String getStrArResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)resKey);
    }

    protected void setCompanyF7() {
        this.bizPromptCompany.setRequired(true);
        this.bizPromptCompany.setEditFormat("$number$");
        this.bizPromptCompany.setDisplayFormat("$name$");
        this.bizPromptCompany.setCommitFormat("$number$");
        this.bizPromptCompany.setEnabledMultiSelection(true);
        if (this.isShowMuliCompany.booleanValue()) {
            this.bizPromptCompany.setEnabled(true);
        } else {
            this.bizPromptCompany.setEnabled(false);
        }
        this.bizPromptCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company, PERMISSION);
        this.bizPromptCompany.setFilterInfoProducer((IFilterInfoProducer)iProducer);
    }

    @Override
    protected void bizPromptCompany_dataChanged(DataChangeEvent e) throws Exception {
        Object object = e.getNewValue();
        if (object != null) {
            CompanyOrgUnitInfo tempCompany = null;
            ArrayList<CompanyOrgUnitInfo> companyList = new ArrayList<CompanyOrgUnitInfo>();
            CompanyOrgUnitInfo firstCompanyInfo = null;
            if (object instanceof CompanyOrgUnitInfo) {
                firstCompanyInfo = (CompanyOrgUnitInfo)object;
                companyList.add(firstCompanyInfo);
            } else if (object instanceof Object[] && null != ((Object[])object)[0]) {
                Object[] array = (Object[])object;
                for (int i = 0; i < array.length; ++i) {
                    if (array[i] == null || !(array[i] instanceof CompanyOrgUnitInfo)) continue;
                    tempCompany = (CompanyOrgUnitInfo)array[i];
                    companyList.add(tempCompany);
                }
                firstCompanyInfo = (CompanyOrgUnitInfo)companyList.get(0);
            }
            if (firstCompanyInfo == null || companyList.size() == 0) {
                return;
            }
            IBadAccountFacade iBadAccountFacade = BadAccountFacadeFactory.getRemoteInstance();
            String errorCompanyName = "";
            String noSetCustomerPrepareParamCompanys = "";
            String accuralParam = "";
            String splitCode = "\u3001";
            for (int i = 0; i < companyList.size(); ++i) {
                CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)companyList.get(i);
                PeriodInfo startPeriod = ArClientUtils.getArStartPeriod(companyInfo);
                if (startPeriod == null) {
                    errorCompanyName = errorCompanyName + companyInfo.getName() + splitCode;
                }
                if ((accuralParam = iBadAccountFacade.getAccuralParam((CompanyOrgUnitInfo)companyList.get(i))).equalsIgnoreCase(String.valueOf(5))) continue;
                noSetCustomerPrepareParamCompanys = noSetCustomerPrepareParamCompanys + companyInfo.getName() + splitCode;
            }
            if (errorCompanyName.length() > 0) {
                errorCompanyName = errorCompanyName.substring(0, errorCompanyName.length() - splitCode.length());
                this.bizPromptCompany.setDataNoNotify(e.getOldValue());
                MsgBox.showWarning((Component)((Object)this), (String)new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{errorCompanyName + SystemEnum.ACCOUNTSRECEIVABLE.getAlias()}).getMessage());
                SysUtil.abort();
            }
            if (noSetCustomerPrepareParamCompanys.length() > 0) {
                noSetCustomerPrepareParamCompanys = noSetCustomerPrepareParamCompanys.substring(0, noSetCustomerPrepareParamCompanys.length() - splitCode.length());
                this.bizPromptCompany.setDataNoNotify(e.getOldValue());
                MsgBox.showWarning((Component)((Object)this), (String)(noSetCustomerPrepareParamCompanys + this.getStrArResource("no_set_customer_prepare_param")));
                SysUtil.abort();
            }
            Set companyIdSet = this.getIdSetByCompanyInfo(object);
            this.setAsstActSelector((CoreUIObject)this, this.bizPromptCussentFrom, companyIdSet);
            this.setAsstActSelector((CoreUIObject)this, this.bizPromptCussentTo, companyIdSet);
            this.baseCurrency = firstCompanyInfo.getBaseCurrency();
            this.setCurrencyF7(true);
        }
    }

    protected Set getIdSetByCompanyInfo(Object companyObj) {
        HashSet<String> companySet = new HashSet<String>();
        CompanyOrgUnitInfo companyInfo = null;
        if (null != companyObj) {
            if (companyObj instanceof CompanyOrgUnitInfo) {
                companySet.add(((CompanyOrgUnitInfo)companyObj).getId().toString());
            } else if (companyObj instanceof Object[] && null != ((Object[])companyObj)[0]) {
                Object[] companyObjArr;
                for (Object object : companyObjArr = (Object[])companyObj) {
                    if (!(object instanceof CompanyOrgUnitInfo)) continue;
                    companyInfo = (CompanyOrgUnitInfo)object;
                    companySet.add(companyInfo.getId().toString());
                }
            }
        }
        return companySet;
    }

    private IObjectValue[] getCompanyArr(Set companyIdSet) throws BOSException {
        if (companyIdSet.isEmpty()) {
            return null;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)companyIdSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("isOnlyUnion"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("CU.longNumber"));
        ev.setSelector(sic);
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getRemoteInstance();
        CompanyOrgUnitCollection companyColl = iCompany.getCompanyOrgUnitCollection(ev);
        if (null == companyColl || 0 == companyColl.size()) {
            return null;
        }
        Iterator compIte = companyColl.iterator();
        IObjectValue[] companyArr = new IObjectValue[companyColl.size()];
        int index = 0;
        while (compIte.hasNext()) {
            companyArr[index] = (IObjectValue)compIte.next();
            ++index;
        }
        return companyArr;
    }

    private Boolean isShowMuliCompany() throws EASBizException, BOSException {
        String isShowMuliCompany = BaseServiceFacadeFactory.getRemoteInstance().getCommonParamValue("BAD_ACCOUNT_IS_SHOW_MULTI_COMPANY");
        if (isShowMuliCompany != null) {
            return Boolean.valueOf(isShowMuliCompany);
        }
        return false;
    }
}

