/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ap.ApOtherParamsCollection;
import com.kingdee.eas.fi.ap.ApOtherParamsInfo;
import com.kingdee.eas.fi.ar.AccountBadDebtEntryFactory;
import com.kingdee.eas.fi.ar.AccountBadDebtEntryInfo;
import com.kingdee.eas.fi.ar.AccountBadDebtFactory;
import com.kingdee.eas.fi.ar.AccountBadDebtInfo;
import com.kingdee.eas.fi.ar.IAccountBadDebt;
import com.kingdee.eas.fi.ar.IAccountBadDebtEntry;
import com.kingdee.eas.fi.ar.ManageAccountFactory;
import com.kingdee.eas.fi.ar.client.AbstractAccountBadDebt_BD_ReceivePercent;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.ar.client.util.CommonClientUtils;
import com.kingdee.eas.fi.gl.AccountBalanceInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.client.VoucherEditUI;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

public class AccountBadDebt_BD_ReceivePercent
extends AbstractAccountBadDebt_BD_ReceivePercent {
    private Map countBadDebtMethodOptions = null;

    private void initialize() {
        this.countBadDebtAccountTable.getStyleAttributes().setLocked(true);
        this.shouldAccountBadDebtText.setEnabled(false);
        this.yearPrepareBadDebtText.setEnabled(false);
        this.patchText.setEnabled(false);
        this.rushText.setEnabled(false);
        this.countBadDebtMethodOptions = ArClientUtils.getCountBadDebtMethodOptions();
        this.countBadDebtAccountTable.checkParsed();
        this.fillCountBadDebtAccount();
    }

    private void fillCountBadDebtAccount() {
        try {
            BigDecimal difference;
            BigDecimal accountBalance;
            this.countBadDebtAccountTable.removeRows();
            ApOtherParamsCollection apOthrPrmsClctn = ArClientUtils.getCountBadDebtAccounts();
            int size = apOthrPrmsClctn.size();
            for (int i = 0; i <= size - 1; ++i) {
                ApOtherParamsInfo apOthrPrmsInf = apOthrPrmsClctn.get(i);
                AccountViewInfo account = apOthrPrmsInf.getAccount();
                BalanceDirectionEnum debitLoan = apOthrPrmsInf.getDebitLoan();
                BigDecimal drawingRatio = apOthrPrmsInf.getDrawingRatio();
                IRow row = this.countBadDebtAccountTable.addRow();
                row.getCell("AccountID").setValue((Object)account.getId().toString());
                row.getCell("AccountName").setValue((Object)account.getName());
                row.getCell("DirectionID").setValue((Object)new Integer(debitLoan.getValue()));
                row.getCell("DirectionName").setValue((Object)debitLoan);
                accountBalance = CommonClientUtils.getGLAccountBalance(account);
                BigDecimal accountBalanceDecimal = new BigDecimal(0);
                if (accountBalance != null) {
                    accountBalanceDecimal = accountBalance.getEndBalanceLocal();
                }
                row.getCell("Balance").setValue((Object)accountBalanceDecimal);
                row.getCell("AccountPercent").setValue((Object)drawingRatio);
            }
            BigDecimal totalPrepareBadDebt = new BigDecimal(0);
            int rowCount = this.countBadDebtAccountTable.getRowCount();
            for (int i = 0; i <= rowCount - 1; ++i) {
                IRow row = this.countBadDebtAccountTable.getRow(i);
                BigDecimal balance = (BigDecimal)row.getCell("Balance").getValue();
                BigDecimal accountPercent = (BigDecimal)row.getCell("AccountPercent").getValue();
                accountBalance = balance.multiply(accountPercent).divide(new BigDecimal(100), 0);
                totalPrepareBadDebt = totalPrepareBadDebt.add(accountBalance);
                row.getCell("AccountBalance").setValue((Object)accountBalance);
            }
            this.shouldAccountBadDebtText.setText(totalPrepareBadDebt.toString());
            AccountViewInfo accountViewInfo = ArClientUtils.getBadDebtPrepareAccount(this.countBadDebtMethodOptions);
            AccountBalanceInfo prprBdDbtblnc = CommonClientUtils.getGLAccountBalance(accountViewInfo);
            BigDecimal prprBdDbtblncBigDcml = new BigDecimal(0);
            if (prprBdDbtblnc != null) {
                prprBdDbtblncBigDcml = prprBdDbtblnc.getEndBalanceLocal();
            }
            this.yearPrepareBadDebtText.setText(prprBdDbtblncBigDcml.toString());
            if (totalPrepareBadDebt.compareTo(prprBdDbtblncBigDcml) >= 0) {
                difference = totalPrepareBadDebt.subtract(prprBdDbtblncBigDcml);
                this.patchText.setText(difference.toString());
                this.rushText.setText(new BigDecimal(0).toString());
            } else {
                difference = prprBdDbtblncBigDcml.subtract(totalPrepareBadDebt);
                this.patchText.setText(new BigDecimal(0).toString());
                this.rushText.setText(difference.toString());
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private boolean saveAccountBadDebtDetail() {
        CurrencyInfo integrateLocalCurrency = CommonClientUtils.getIntegrateLocalCurrency();
        try {
            CompanyOrgUnitInfo company = CommonClientUtils.getCurrentCompany();
            IAccountBadDebt accountBadDebt = AccountBadDebtFactory.getRemoteInstance();
            IAccountBadDebtEntry accountBadDebtEntry = AccountBadDebtEntryFactory.getRemoteInstance();
            AccountBadDebtInfo accountBadDebtInfo = new AccountBadDebtInfo();
            accountBadDebtInfo.setCompany(company);
            accountBadDebtInfo.setAccountDate(new Date());
            accountBadDebtInfo.setCurrency(integrateLocalCurrency);
            BigDecimal patch = new BigDecimal(this.patchText.getText());
            accountBadDebtInfo.setPatch(patch);
            BigDecimal rush = new BigDecimal(this.rushText.getText());
            accountBadDebtInfo.setRush(rush);
            ObjectUuidPK pk = (ObjectUuidPK)accountBadDebt.addnew(accountBadDebtInfo);
            accountBadDebtInfo.setId(pk.getKeyValue());
            int rowCount = this.countBadDebtAccountTable.getRowCount();
            for (int i = 0; i <= rowCount - 1; ++i) {
                IRow row = this.countBadDebtAccountTable.getRow(i);
                String accountID = (String)row.getCell("AccountID").getValue();
                ObjectUuidPK accountPK = new ObjectUuidPK(accountID);
                AccountViewInfo account = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)accountPK);
                String accountName = (String)row.getCell("AccountName").getValue();
                Integer directionID = (Integer)row.getCell("DirectionID").getValue();
                BalanceDirectionEnum direction = BalanceDirectionEnum.getEnum((int)directionID);
                BigDecimal balance = (BigDecimal)row.getCell("Balance").getValue();
                BigDecimal accountPercent = (BigDecimal)row.getCell("AccountPercent").getValue();
                BigDecimal accountBalance = (BigDecimal)row.getCell("AccountBalance").getValue();
                AccountBadDebtEntryInfo acntBdDbtEntryInf = new AccountBadDebtEntryInfo();
                acntBdDbtEntryInf.setAccount(account);
                acntBdDbtEntryInf.setDirection(direction);
                acntBdDbtEntryInf.setBalance(balance);
                acntBdDbtEntryInf.setAccountPercent(accountPercent);
                acntBdDbtEntryInf.setAccountBalance(accountBalance);
                acntBdDbtEntryInf.setParent(accountBadDebtInfo);
                accountBadDebtEntry.addnew(acntBdDbtEntryInf);
            }
            return true;
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
    }

    private boolean createVoucher() {
        try {
            AccountViewInfo badDebtLossAccount = ArClientUtils.getBadDebtLossAccount(this.countBadDebtMethodOptions);
            AccountViewInfo badDebtPrepareAccount = ArClientUtils.getBadDebtPrepareAccount(this.countBadDebtMethodOptions);
            BigDecimal zero = new BigDecimal(0);
            CurrencyInfo integrateLocalCurrency = CommonClientUtils.getIntegrateLocalCurrency();
            CompanyOrgUnitInfo company = CommonClientUtils.getCurrentCompany();
            PeriodInfo period = ArClientUtils.getArCurrentPeriod(company);
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            BigDecimal patchOrRushValue = new BigDecimal(0);
            BigDecimal patchValue = new BigDecimal(this.patchText.getText());
            BigDecimal rushValue = new BigDecimal(this.rushText.getText());
            patchOrRushValue = patchValue.equals(zero) ? rushValue : patchValue;
            VoucherInfo voucherInfo = new VoucherInfo();
            VoucherEntryCollection collection = voucherInfo.getEntries();
            patchOrRushValue = new BigDecimal(55555);
            VoucherEntryInfo voucherEntryInfo = new VoucherEntryInfo();
            voucherEntryInfo.setAccount(badDebtLossAccount);
            voucherEntryInfo.setCurrency(integrateLocalCurrency);
            voucherEntryInfo.setOriginalAmount(zero);
            voucherEntryInfo.setReportingAmount(zero);
            voucherEntryInfo.setLocalExchangeRate(new BigDecimal(1));
            voucherEntryInfo.setReportingExchangeRate(zero);
            voucherEntryInfo.setDescription("");
            voucherEntryInfo.setOprStatus(1);
            voucherEntryInfo.setEntryDC(EntryDC.DEBIT);
            voucherEntryInfo.setLocalAmount(patchOrRushValue);
            voucherEntryInfo.setSeq(1);
            collection.add(voucherEntryInfo);
            voucherEntryInfo = new VoucherEntryInfo();
            voucherEntryInfo.setAccount(badDebtPrepareAccount);
            voucherEntryInfo.setCurrency(integrateLocalCurrency);
            voucherEntryInfo.setOriginalAmount(zero);
            voucherEntryInfo.setReportingAmount(zero);
            voucherEntryInfo.setLocalExchangeRate(new BigDecimal(1));
            voucherEntryInfo.setReportingExchangeRate(zero);
            voucherEntryInfo.setDescription("");
            voucherEntryInfo.setOprStatus(1);
            voucherEntryInfo.setEntryDC(EntryDC.CREDIT);
            voucherEntryInfo.setLocalAmount(patchOrRushValue);
            voucherEntryInfo.setSeq(1);
            collection.add(voucherEntryInfo);
            voucherInfo.setCompany(company);
            voucherInfo.setPeriod(period);
            VoucherTypeInfo voucherTypeInfo = VoucherTypeFactory.getRemoteInstance().getVoucherTypeCollection().get(0);
            voucherInfo.setVoucherType(voucherTypeInfo);
            voucherInfo.setBizDate(new Date());
            voucherInfo.setBookedDate(new Date());
            voucherInfo.setHandler(user);
            voucherInfo.setSourceSys(SystemEnum.ACCOUNTSRECEIVABLE);
            voucherInfo.setSourceType(SourceType.NONE);
            voucherInfo.setAttachments(0);
            voucherInfo.setDescription("");
            voucherInfo.setLocalDebitAmount(patchOrRushValue);
            voucherInfo.setLocalCreditAmount(patchOrRushValue);
            voucherInfo.setReportingDebitAmount(zero);
            voucherInfo.setReportingCreditAmount(zero);
            voucherInfo = ManageAccountFactory.getRemoteInstance().voucherLazyLoad(voucherInfo);
            UIContext ctx = new UIContext((Object)this);
            ctx.put((Object)"InitDataObject", (Object)voucherInfo);
            ctx.put((Object)"EDITRULE", (Object)"com.kingdee.eas.fi.ar.client.util.ArapVoucherEditRule");
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(VoucherInfo.getEditUIName(), (Map)ctx, null, OprtState.ADDNEW);
            uiWindow.show();
            VoucherEditUI voucherEditUI = (VoucherEditUI)uiWindow.getUIObject();
            return voucherEditUI.isSave();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
    }

    public AccountBadDebt_BD_ReceivePercent() throws Exception {
        this.initialize();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void voucherButton_actionPerformed(ActionEvent e) throws Exception {
        this.saveAccountBadDebtDetail();
    }

    @Override
    protected void closeButton_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }
}

