/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.ap.PrepareOptionMethodEnum;
import com.kingdee.eas.fi.ar.client.AbstractAcctBadDebtQuery;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.util.SysUtil;
import java.awt.event.ItemEvent;
import org.apache.log4j.Logger;

public class AcctBadDebtQuery
extends AbstractAcctBadDebtQuery {
    private static final Logger logger = CoreUIObject.getLogger(AcctBadDebtQuery.class);
    private CompanyOrgUnitInfo currentCompany = BaseDataUtil.getCompanyInfo();

    public AcctBadDebtQuery() throws Exception {
        int endYear;
        this.kDComboBoxAccountType.setSelectedIndex(1);
        PeriodInfo periodInfoFrom = ArClientUtils.getArStartPeriod(this.currentCompany);
        PeriodInfo periodInfoNow = ArClientUtils.getArCurrentPeriod(this.currentCompany);
        int beginYear = periodInfoFrom.getBeginDate().getYear() + 1900;
        int i = endYear - beginYear + 1;
        Object[] str = new String[i];
        i = 0;
        for (endYear = periodInfoNow.getEndDate().getYear() + 1900; endYear >= beginYear; --endYear) {
            str[i] = String.valueOf(endYear);
            ++i;
        }
        this.kDComboBoxAccountYearfrom.addItems(str);
        this.kDComboBoxAccountYearto.addItems(str);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    protected void kDComboBoxAccountYearfrom_itemStateChanged(ItemEvent e) throws Exception {
        super.kDComboBoxAccountYearfrom_itemStateChanged(e);
    }

    @Override
    protected void kDComboBoxAccountYearto_itemStateChanged(ItemEvent e) throws Exception {
        super.kDComboBoxAccountYearto_itemStateChanged(e);
    }

    public FilterInfo getFilterInfo() {
        if (this.kDBizPrCompany.getData() != null) {
            String companyId = this.currentCompany.getId().toString();
            FilterItemInfo companyFilter = new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(companyFilter);
        }
        String accountYear = "";
        if (this.kDComboBoxAccountYearfrom.getSelectedItem() != null) {
            accountYear = this.kDComboBoxAccountYearfrom.getSelectedItem().toString();
            FilterItemInfo accountYearfromFilter = new FilterItemInfo("accountYear", (Object)accountYear, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(accountYearfromFilter);
        }
        if (this.kDComboBoxAccountYearto.getSelectedItem() != null) {
            accountYear = this.kDComboBoxAccountYearto.getSelectedItem().toString();
            FilterItemInfo accountYeartoFilter = new FilterItemInfo("accountYear", (Object)accountYear, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(accountYeartoFilter);
        }
        if (this.kDComboBoxAccountType.getSelectedItem() != null) {
            PrepareOptionMethodEnum prepareOptionMethodEnum = (PrepareOptionMethodEnum)((Object)this.kDComboBoxAccountType.getSelectedItem());
            int accountType = prepareOptionMethodEnum.getValue();
            String sAccountType = "";
            sAccountType = String.valueOf(accountType);
            FilterItemInfo accountTypeFilter = new FilterItemInfo("accountType", (Object)sAccountType, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(accountTypeFilter);
        }
        StringBuffer sbFormula = new StringBuffer();
        if (this.filterInfo.getFilterItems() != null && this.filterInfo.getFilterItems().size() > 0) {
            sbFormula.append("(").append(" ").append("#").append(0).append(" ").append(")").append(" ");
            int size = this.filterInfo.getFilterItems().size();
            for (int i = 1; i < size; ++i) {
                sbFormula.append("and").append(" ").append("(").append(" ").append("#").append(i).append(" ").append(")").append(" ");
            }
        }
        this.filterInfo.setMaskString(sbFormula.toString());
        return this.filterInfo;
    }

    public void clear() {
        this.kDBizPrCompany.setData((Object)this.currentCompany);
        this.kDComboBoxAccountYearfrom.setSelectedIndex(this.kDComboBoxAccountYearfrom.getItemCount() - 1);
        this.kDComboBoxAccountYearto.setSelectedIndex(this.kDComboBoxAccountYearto.getItemCount() - 1);
    }

    private void setBizPromptData(KDBizPromptBox bizPrompt, String id) {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(id);
            IObjectValue objVal = DynamicObjectFactory.getRemoteInstance().getValue(pk.getObjectType(), (IObjectPK)pk);
            bizPrompt.setData((Object)objVal);
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
    }

    private void setComBoxData(KDComboBox comBox, String value) {
        try {
            for (int i = 0; i < comBox.getItemCount(); ++i) {
                if (!comBox.getItemAt(i).toString().equals(value)) continue;
                comBox.setSelectedIndex(i);
                break;
            }
        }
        catch (Exception e) {
            SysUtil.abort();
        }
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clear();
        super.loadData(entityViewInfo);
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter().getFilterItems();
        String propName = "";
        Object compVal = null;
        CompareType comp = null;
        for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            propName = currentFilterItemCollection.get(i).getPropertyName();
            compVal = currentFilterItemCollection.get(i).getCompareValue();
            comp = currentFilterItemCollection.get(i).getCompareType();
            if ("company.id".equalsIgnoreCase(propName)) {
                this.kDBizPrCompany.setData((Object)this.currentCompany);
                continue;
            }
            if ("accountType".equalsIgnoreCase(propName)) {
                int item = Integer.parseInt(compVal.toString());
                this.setComBoxData(this.kDComboBoxAccountType, PrepareOptionMethodEnum.getEnum(item).getAlias());
                continue;
            }
            if ("accountYear".equalsIgnoreCase(propName) && comp.equals((Object)CompareType.GREATER_EQUALS)) {
                this.setComBoxData(this.kDComboBoxAccountYearfrom, compVal.toString());
                continue;
            }
            if (!"accountYear".equalsIgnoreCase(propName) || !comp.equals((Object)CompareType.LESS_EQUALS)) continue;
            this.setComBoxData(this.kDComboBoxAccountYearto, compVal.toString());
        }
    }
}

