/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.account.AccountCurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountingCurrencyEnum;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.ar.IOtherBill;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.client.ArApBillEditUI;
import com.kingdee.eas.fi.arap.client.KDTableUtils;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.math.BigDecimal;
import javax.swing.JTextField;

public abstract class ArApBillBaseHandler {
    public static Component getTableCellEditorComp(KDTable table, int row, String column) {
        ICell cell = table.getCell(row, column);
        IColumn icolumn = table.getColumn(column);
        Component editorComp = null;
        if (cell != null && cell.getEditor() != null) {
            editorComp = cell.getEditor().getComponent();
        } else if (cell != null && icolumn.getEditor() != null) {
            editorComp = icolumn.getEditor().getComponent();
        }
        return editorComp;
    }

    public static void setTableCellDecimalValue(KDTable table, int row, String column, BigDecimal value) {
        ICell cell = table.getCell(row, column);
        Component editorComp = ArApBillBaseHandler.getTableCellEditorComp(table, row, column);
        if (editorComp != null && editorComp instanceof KDFormattedTextField) {
            KDFormattedTextField formatTxtField = (KDFormattedTextField)editorComp;
            int precision = formatTxtField.getPrecision();
            cell.setValue((Object)SCMUtils.effectualNumeric((BigDecimal)value).setScale(precision, 4));
        } else {
            cell.setValue((Object)value);
        }
    }

    public static BigDecimal getQty(String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        if (unitInfo == null || otherUnitInfo == null) {
            return SysConstant.BIGZERO;
        }
        BigDecimal targetQty = qty = qty == null ? SysConstant.BIGZERO : qty;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
        MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, otherUnitInfo.getId().toString());
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = qty.multiply(baseExchangeRate1);
            int scale = 10;
            if (baseQty != null && qty != null) {
                scale = othermultiUnifInfo.getQtyPrecision();
            }
            if (baseQty != null) {
                targetQty = baseQty.divide(baseExchangeRate2, scale, 4);
            }
        }
        return targetQty;
    }

    public static void setCellPrecision(KDTable table, int row, String[] columns, int precision) {
        if (precision < 0) {
            precision = 2;
        }
        if (null == columns || columns.length == 0 || null == table) {
            return;
        }
        String formatStr = PrecisionFormatUtils.getFormatString(precision);
        KDTDefaultCellEditor editor = ArApBillBaseHandler.getNumberCellEditor(precision);
        BigDecimal temp = null;
        ICell iCell = null;
        for (int i = 0; i < columns.length; ++i) {
            iCell = table.getCell(row, columns[i]);
            if (null == iCell) continue;
            iCell.getStyleAttributes().setNumberFormat(formatStr);
            iCell.setEditor((ICellEditor)editor);
            if (iCell.getValue() == null) continue;
            temp = new BigDecimal(iCell.getValue().toString());
            iCell.setValue(temp == null ? null : temp.setScale(precision, 4));
        }
    }

    public static KDTDefaultCellEditor getNumberCellEditor(int precision) {
        KDFormattedTextField qtyformatedTxtField = KDTableUtils.getBigDecimalTextField(precision, true);
        KDTDefaultCellEditor qtynumber_CellEditor = new KDTDefaultCellEditor((JTextField)qtyformatedTxtField);
        return qtynumber_CellEditor;
    }

    public static void setTableQtyPrecision(KDTable kdtEntry, MaterialInfo materialInfo, int row) throws BOSException, EASBizException {
        MultiMeasureUnitInfo multiUnitInfo;
        MeasureUnitInfo assistunitInfo;
        MultiMeasureUnitInfo multiUnitInfo2;
        MultiMeasureUnitInfo multiUnifInfo;
        IMultiMeasureUnit iMultUnit = MultiMeasureUnitFactory.getRemoteInstance();
        if (materialInfo == null) {
            throw new IllegalArgumentException();
        }
        int baseprecision = 2;
        MeasureUnitInfo baseunitInfo = (MeasureUnitInfo)kdtEntry.getCell(row, "baseUnit").getValue();
        if (baseunitInfo == null) {
            IMaterial imaterial = MaterialFactory.getRemoteInstance();
            MaterialInfo info = imaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()));
            baseunitInfo = info.getBaseUnit();
        }
        if ((multiUnifInfo = iMultUnit.getMultiUnit(materialInfo.getId().toString(), baseunitInfo.getId().toString())) != null) {
            baseprecision = multiUnifInfo.getQtyPrecision();
        }
        ArApBillBaseHandler.setCellPrecision(kdtEntry, row, ArApBillEditUI.KDTEntry_BaseQty_Col, baseprecision);
        MeasureUnitInfo unitInfo = (MeasureUnitInfo)kdtEntry.getCell(row, "measureUnit").getValue();
        if (unitInfo != null && (multiUnitInfo2 = iMultUnit.getMultiUnit(materialInfo.getId().toString(), unitInfo.getId().toString())) != null) {
            ArApBillBaseHandler.setCellPrecision(kdtEntry, row, ArApBillEditUI.KDTEntry_UnitQty_Col, multiUnitInfo2.getQtyPrecision());
        }
        if ((assistunitInfo = (MeasureUnitInfo)kdtEntry.getCell(row, "assistUnit").getValue()) != null && (multiUnitInfo = iMultUnit.getMultiUnit(materialInfo.getId().toString(), assistunitInfo.getId().toString())) != null) {
            String formatStr = PrecisionFormatUtils.getFormatString(multiUnitInfo.getQtyPrecision());
            kdtEntry.getCell(row, "assistQty").getStyleAttributes().setNumberFormat(formatStr);
            kdtEntry.getCell(row, "assistQty").setEditor((ICellEditor)ArApBillBaseHandler.getNumberCellEditor(multiUnitInfo.getQtyPrecision()));
        }
    }

    public static AccountViewInfo getKAClassAccount(String companyID, String asstActId, boolean isArBill, boolean isArSystem, int isPreRecPay) throws Exception {
        IOtherBill iArAp = OtherBillFactory.getRemoteInstance();
        AccountViewInfo account = new AccountViewInfo();
        IRowSet accountResult = iArAp.getKAClassAccount(companyID, asstActId, isArBill, isArSystem, isPreRecPay);
        if (accountResult == null) {
            return null;
        }
        accountResult.beforeFirst();
        while (accountResult.next()) {
            account.setId(BOSUuid.read((String)accountResult.getString("account_id")));
            account.setNumber(accountResult.getString("account_number"));
            account.setName(accountResult.getString("account_name"));
            account.setAccountingcurrency(AccountingCurrencyEnum.getEnum((int)accountResult.getInt("accounting_currency")));
            if (accountResult.getString("account_currency") == null) continue;
            AccountCurrencyInfo accCurInfo = new AccountCurrencyInfo();
            CurrencyInfo cur = new CurrencyInfo();
            cur.setId(BOSUuid.read((String)accountResult.getString("account_currency")));
            accCurInfo.setCurrency(cur);
            account.getAccountCurrency().add(accCurInfo);
        }
        if (account.getId() == null) {
            return null;
        }
        return account;
    }

    public abstract SystemEnum getSysEnum();
}

