/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.ar.IIncomeConfimBill;
import com.kingdee.eas.fi.ar.IOtherBill;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.client.AbstractArApreverseEditUI;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.client.ArApBillListUI;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ArApreverseEditUI
extends AbstractArApreverseEditUI {
    private static final long serialVersionUID = -5620790274034964020L;
    private static final Logger logger = CoreUIObject.getLogger(ArApreverseEditUI.class);
    private ArApSysParamInfo sysParam = null;
    private ICoreBase iCoreBase = null;
    private ArApBillListUI parentListUI = null;
    IObjectPK[] pk = null;
    private boolean fAR = true;
    private boolean isIncomeConfirmBill = false;
    private String alia = null;
    private ArrayList selectedIdValues = null;
    private boolean isReversedBizBill = false;

    public void onLoad() throws Exception {
        Object incomeConfirm;
        Map uiCtx = this.getUIContext();
        this.parentListUI = (ArApBillListUI)((Object)uiCtx.get("Owner"));
        this.sysParam = (ArApSysParamInfo)uiCtx.get("ArApSysParamInfo");
        this.iCoreBase = (ICoreBase)uiCtx.get("iCoreBase");
        this.alia = (String)uiCtx.get("alia");
        this.pk = (ObjectUuidPK[])uiCtx.get("pk");
        Object obj = uiCtx.get("isReversedBizBill");
        if (null != obj) {
            this.isReversedBizBill = Boolean.valueOf(obj.toString());
        }
        if ((incomeConfirm = uiCtx.get("isIncomeConfirmBill")) != null) {
            this.isIncomeConfirmBill = Boolean.valueOf(incomeConfirm.toString());
        }
        this.selectedIdValues = (ArrayList)uiCtx.get("selectedIdValues");
        if (this.sysParam.getSysEnum() == SystemEnum.ACCOUNTSRECEIVABLE) {
            this.fAR = true;
        } else if (this.sysParam.getSysEnum() == SystemEnum.ACCOUNTSPAYABLE) {
            this.fAR = false;
        }
        Date defaultDate = this.sysParam.getDate();
        if (this.sysParam.getCurrentPeriod(this.sysParam.getSysEnum()) != null) {
            Date minDate = this.sysParam.getCurrentPeriod(this.sysParam.getSysEnum()).getBeginDate();
            if (defaultDate.before(minDate)) {
                defaultDate = minDate;
            }
            this.ptmtBillDate.setValue((Object)defaultDate);
            this.ptmtBillDate.setMinimumDate(minDate);
        } else {
            this.ptmtBillDate.setValue((Object)defaultDate);
        }
        this.ptmtBizDate.setValue((Object)this.sysParam.getDate());
        this.btnConfirm.setEnabled(true);
        this.btnCancel.setEnabled(true);
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
        Date txtBizDate = (Date)this.ptmtBizDate.getValue();
        Date txtBillDate = (Date)this.ptmtBillDate.getValue();
        if (txtBillDate == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.arap.ArapResource", (String)"BillDateCanNotNull"));
            this.ptmtBizDate.requestFocus();
            SysUtil.abort();
        }
        IObjectPK[] newPKs = null;
        String msg = null;
        if (this.fAR) {
            if (this.isIncomeConfirmBill) {
                IIncomeConfimBill incomeConfimBill = (IIncomeConfimBill)this.getBizInterface();
                newPKs = incomeConfimBill.createReverseBill(this.pk, txtBizDate, txtBillDate);
            } else {
                IOtherBill otherBill = (IOtherBill)this.getBizInterface();
                if (this.isReversedBizBill) {
                    msg = otherBill.batchReversedBizBill(this.pk, txtBillDate, txtBizDate);
                } else {
                    newPKs = otherBill.createReverseBill(this.pk, txtBizDate, txtBillDate);
                }
            }
        } else {
            com.kingdee.eas.fi.ap.IOtherBill otherBill = (com.kingdee.eas.fi.ap.IOtherBill)this.getBizInterface();
            if (this.isReversedBizBill) {
                msg = otherBill.batchReversedBizBill(this.pk, txtBillDate, txtBizDate);
            } else {
                newPKs = otherBill.createReverseBill(this.pk, txtBizDate, txtBillDate);
            }
        }
        if (this.isReversedBizBill) {
            if (StringUtils.isEmpty((CharSequence)msg)) {
                return;
            }
            if ("success".equals(msg)) {
                this.setMessageText(ArApBillUIUtil.getStrResource("232_reverseBizSuccess"));
                this.showMessage();
            } else {
                MsgBox.showDetailAndOK((Component)((Object)this.parentListUI), (String)ArApBillUIUtil.getStrResource("233_reverseBizBill_Partial_Failure"), (String)msg, (int)1);
            }
        } else if (newPKs != null) {
            this.setMessageText(ArApBillUIUtil.getStrResource("reverseSuccess"));
            this.showMessage();
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        if (null != this.iCoreBase) {
            return this.iCoreBase;
        }
        if (this.fAR) {
            return OtherBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        }
        return com.kingdee.eas.fi.ap.OtherBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }
}

