/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.common.perf.JobConfig;
import com.kingdee.eas.basedata.common.perf.client.JobMonitorManager;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.client.ArCloseAccountManagerUI;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.MsgBox;
import java.text.MessageFormat;
import java.util.Map;

class ArCloseAccountThread
extends Thread {
    private ArCloseAccountManagerUI page;

    public ArCloseAccountThread(ArCloseAccountManagerUI aPage) {
        this.page = aPage;
    }

    @Override
    public void run() {
        try {
            this.CloseAccountForThread();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void CloseAccountForThread() throws EASBizException, BOSException {
        Boolean isAr = Boolean.TRUE;
        Object[] companys = this.page.getValidCompanys();
        final StringBuilder sb = new StringBuilder(150);
        int len = companys.length;
        for (int i = 0; i < len; ++i) {
            Object[] params = new Object[]{companys[i], isAr, SysContext.getSysContext().getLocale(), SysContext.getSysContext().getCurrentUserInfo()};
            JobConfig jobCfg = this.creteJobCfg((CompanyOrgUnitInfo)companys[i]);
            if (this.page.getICreateJobFacade().checkDuplicateTask(jobCfg.getTaskType())) {
                sb.append(MessageFormat.format(this.page.getARResourcesValue("ArClosrAccountIsInQueue"), ((CompanyOrgUnitInfo)companys[i]).getName()));
                sb.append("\r\n");
                continue;
            }
            sb.append(MessageFormat.format(this.page.getARResourcesValue("ArClosrAccountJoinInQueue"), ((CompanyOrgUnitInfo)companys[i]).getName()));
            sb.append("\r\n");
            Object objResult = this.page.getICreateJobFacade().executeJob(jobCfg, (Object)params);
            Map result = null;
            if (objResult instanceof Map) {
                result = (Map)objResult;
            }
            if (result == null || result.get("jobInstExtId") == null) continue;
            JobMonitorManager.getInstance().addMonitorInfo((String)result.get("jobInstExtId"), jobCfg.getTitle());
        }
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                MsgBox.showDetailAndOK(null, (String)ArCloseAccountThread.this.page.getARResourcesValue("ArCloseAccountFinish"), (String)sb.toString(), (int)1);
                return null;
            }
        };
        worker.start();
    }

    private JobConfig creteJobCfg(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)company);
        String title = currentPeriod.toString() + "\u3010" + company.getName() + "(" + company.getNumber() + ")\u3011" + this.page.getARResourcesValue("ArCloseAccount");
        JobConfig jobCfg = new JobConfig();
        jobCfg.setTitle(title);
        jobCfg.setSyn(true);
        jobCfg.setTaskType("SCM_FI_AR_001" + company.getNumber());
        jobCfg.setDescription(title);
        jobCfg.setNeedCheckTaskType(true);
        jobCfg.setNumber("SCM_FI_AR_001");
        return jobCfg;
    }
}

