/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.ArGLDetailFacadeFactory;
import com.kingdee.eas.fi.ar.ContrastGLQueryParam;
import com.kingdee.eas.fi.ar.client.AbstractArGLDetailUI;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class ArGLDetailUI
extends AbstractArGLDetailUI {
    private static final long serialVersionUID = 4869662485014366432L;
    private static final Logger logger = CoreUIObject.getLogger(ArGLDetailUI.class);
    private static final String ArResource = "com.kingdee.eas.fi.ar.client.ArResource";
    private Map tabMap = new Hashtable();
    private ContrastGLQueryParam param = null;
    private IRow iRow = null;
    private CompanyOrgUnitInfo company = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.param = (ContrastGLQueryParam)((Object)this.getUIContext().get("filterParam"));
        this.iRow = (IRow)this.getUIContext().get("iRow");
        this.company = SysContext.getSysContext().getCurrentFIUnit();
        this.kDBizPromptBox1.setValue((Object)this.company);
        this.kDBizPromptBox1.setEnabled(false);
        this.initKDTree();
    }

    private void initKDTree() {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"ArGLDetail");
        DefaultKingdeeTreeNode child = new DefaultKingdeeTreeNode((Object)this.getResourceString("DAP_LOST"));
        root.add((MutableTreeNode)child);
        child = new DefaultKingdeeTreeNode((Object)this.getResourceString("BillPeriod_VoucherPeriod_Diff"));
        root.add((MutableTreeNode)child);
        child = new DefaultKingdeeTreeNode((Object)this.getResourceString("DestObjectNoSrcId"));
        root.add((MutableTreeNode)child);
        this.kdTree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        ((KingdeeTreeModel)this.kdTree.getModel()).setAsksAllowsChildren(true);
        root = (DefaultKingdeeTreeNode)((KingdeeTreeModel)this.kdTree.getModel()).getRoot();
        this.kdTree.setSelectionNode((DefaultKingdeeTreeNode)root.getFirstChild());
        this.kdTree.expandPath(this.kdTree.getSelectionPath());
    }

    @Override
    protected void kdTree_valueChanged(TreeSelectionEvent e) throws Exception {
        if (e.getOldLeadSelectionPath() != null) {
            this.kdTree.collapsePath(e.getOldLeadSelectionPath());
        }
        this.kdTree.expandPath(e.getNewLeadSelectionPath());
        String title = e.getNewLeadSelectionPath().getLastPathComponent().toString();
        if (this.kDTabbedPane1.getSelectedIndex() != -1) {
            this.kDTabbedPane1.removeTabAt(this.kDTabbedPane1.getSelectedIndex());
        }
        this.setSelected(title);
    }

    private void setSelected(String title) {
        if (this.getResourceString("DAP_LOST").equals(title)) {
            this.selectedDAP();
        } else if (this.getResourceString("BillPeriod_VoucherPeriod_Diff").equals(title)) {
            this.selectedPeriodDiff();
        } else if (this.getResourceString("DestObjectNoSrcId").equals(title)) {
            this.selectedDestObjectNoSrcId();
        }
    }

    private void selectedDAP() {
        String dap_Lost = this.getResourceString("DAP_LOST");
        KDTable kdTab = null;
        String[] head = new String[]{this.getResourceString("BillType"), this.getResourceString("BillNumber"), this.getResourceString("BillDate")};
        String[] keys = new String[]{"BillType", "BillNumber", "BillDate"};
        kdTab = new KDTable();
        kdTab.setExportPrintSetup2Xls(true);
        kdTab.setEditable(false);
        kdTab.addColumns(head.length);
        for (int i = 0; i < keys.length; ++i) {
            kdTab.getColumn(i).setKey(keys[i]);
        }
        IRow irow = kdTab.addHeadRow();
        for (int i = 0; i < head.length; ++i) {
            irow.getCell(i).setValue((Object)head[i]);
        }
        kdTab.getColumn("BillType").setWidth(80);
        kdTab.getColumn("BillNumber").setWidth(125);
        kdTab.getColumn("BillDate").setWidth(80);
        kdTab.getColumn("BillDate").getStyleAttributes().setNumberFormat(ArApBillUtil.getDateFormatString());
        kdTab.getColumn("BillDate").setEditor(null);
        this.kDTabbedPane1.addTab(dap_Lost, (Component)kdTab);
        this.kDTabbedPane1.setSelectedComponent((Component)kdTab);
        this.tabMap.put(dap_Lost, kdTab);
        try {
            Map result = (Map)ArGLDetailFacadeFactory.getRemoteInstance().queryData("queryDapLost", this.getParam());
            KDTableHelper.addRows((KDTable)kdTab, (Collection[])((Collection[])result.get("data")));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void selectedPeriodDiff() {
        String periodDiff = this.getResourceString("BillPeriod_VoucherPeriod_Diff");
        KDTable kdTab = null;
        String[] head = new String[]{this.getResourceString("BillType"), this.getResourceString("BillNumber"), this.getResourceString("BillPeriod"), this.getResourceString("VoucherPeriod"), this.getResourceString("VoucherType"), this.getResourceString("VoucherNumber")};
        kdTab = new KDTable();
        kdTab.setExportPrintSetup2Xls(true);
        kdTab.setEditable(false);
        kdTab.addColumns(head.length);
        String[] keys = new String[]{"BillType", "BillNumber", "BillPeriod", "VoucherPeriod", "VoucherType", "VoucherNumber"};
        for (int i = 0; i < keys.length; ++i) {
            kdTab.getColumn(i).setKey(keys[i]);
        }
        kdTab.getColumn("BillType").setWidth(80);
        kdTab.getColumn("BillNumber").setWidth(125);
        kdTab.getColumn("BillPeriod").setWidth(80);
        kdTab.getColumn("VoucherPeriod").setWidth(80);
        kdTab.getColumn("VoucherType").setWidth(80);
        kdTab.getColumn("VoucherNumber").setWidth(80);
        IRow irow = kdTab.addHeadRow();
        for (int i = 0; i < head.length; ++i) {
            irow.getCell(i).setValue((Object)head[i]);
        }
        this.kDTabbedPane1.addTab(periodDiff, (Component)kdTab);
        this.kDTabbedPane1.setSelectedComponent((Component)kdTab);
        this.tabMap.put(periodDiff, kdTab);
        try {
            Map result = (Map)ArGLDetailFacadeFactory.getRemoteInstance().queryData("queryPeriodDiff", this.getParam());
            KDTableHelper.addRows((KDTable)kdTab, (Collection[])((Collection[])result.get("data")));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void selectedDestObjectNoSrcId() {
        String destObjectNoSrcId = this.getResourceString("DestObjectNoSrcId");
        KDTable kdTab = null;
        if (this.tabMap.get(destObjectNoSrcId) == null) {
            String[] head = new String[]{this.getResourceString("BillType"), this.getResourceString("BillNumber")};
            kdTab = new KDTable();
            kdTab.setExportPrintSetup2Xls(true);
            kdTab.setEditable(false);
            kdTab.addColumns(head.length);
            String[] keys = new String[]{"BillType", "BillNumber"};
            for (int i = 0; i < keys.length; ++i) {
                kdTab.getColumn(i).setKey(keys[i]);
            }
            kdTab.getColumn("BillType").setWidth(80);
            kdTab.getColumn("BillNumber").setWidth(125);
            IRow irow = kdTab.addHeadRow();
            for (int i = 0; i < head.length; ++i) {
                irow.getCell(i).setValue((Object)head[i]);
            }
            this.kDTabbedPane1.addTab(destObjectNoSrcId, (Component)kdTab);
            this.kDTabbedPane1.setSelectedComponent((Component)kdTab);
            this.tabMap.put(destObjectNoSrcId, kdTab);
            try {
                Map result = (Map)ArGLDetailFacadeFactory.getRemoteInstance().queryData("queryDestObjectNoSrcId", this.getParam());
                KDTableHelper.addRows((KDTable)kdTab, (Collection[])((Collection[])result.get("data")));
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else {
            kdTab = (KDTable)this.tabMap.get(destObjectNoSrcId);
            this.kDTabbedPane1.addTab(destObjectNoSrcId, (Component)kdTab);
            this.kDTabbedPane1.setSelectedComponent((Component)kdTab);
        }
    }

    private Map getParam() {
        Hashtable<String, String> filterParam = new Hashtable<String, String>();
        filterParam.put("companyId", this.param.getCompanyId());
        filterParam.put("currencyId", this.param.getCurrencyId());
        String periodYear = this.param.getPeriodYear() + "";
        filterParam.put("periodYear", periodYear);
        String periodNum = this.param.getPeriodNum() + "";
        filterParam.put("periodNum", periodNum);
        if (this.iRow.getCell("FCussAcct") != null) {
            String cussId = this.iRow.getCell("FCussAcct").getValue().toString();
            filterParam.put("cussId", cussId);
        } else {
            filterParam.put("cussId", "");
        }
        if (!this.param.isBySum() && !this.param.isByBillSum()) {
            if (this.iRow.getCell("FAccountId").getValue() != null) {
                filterParam.put("account", this.iRow.getCell("FAccountId").getValue().toString());
            } else {
                filterParam.put("account", "");
            }
        } else {
            filterParam.put("account", "");
        }
        return filterParam;
    }

    private String getResourceString(String key) {
        return EASResource.getString((String)ArResource, (String)key);
    }
}

