/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.ArApQueryParam;
import com.kingdee.eas.fi.ar.ArApReportTreeData;
import com.kingdee.eas.fi.ar.IReportData;
import com.kingdee.eas.fi.ar.IReportFacade;
import com.kingdee.eas.fi.ar.IReportQueryParam;
import com.kingdee.eas.fi.ar.ItemRptQueryParam;
import com.kingdee.eas.fi.ar.ReportFacadeFactory;
import com.kingdee.eas.fi.ar.client.AbstractArItemRptUI;
import com.kingdee.eas.fi.ar.client.ItemRptQueryUI;
import com.kingdee.eas.fi.ar.client.ReportLinkHelper;
import com.kingdee.eas.fi.ar.client.RptBaseQueryUI;
import com.kingdee.eas.fi.arap.client.util.TablePrintUtil;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.fi.gl.common.print.IRequestTableData;
import com.kingdee.eas.fi.gl.common.print.MultiPrint;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ArItemRptUI
extends AbstractArItemRptUI {
    private static final Logger logger = CoreUIObject.getLogger(ArItemRptUI.class);
    protected ItemRptQueryUI queryUI = null;

    @Override
    protected void initUI() {
        super.initUI();
        this.actionView.setVisible(true);
        this.seprtPrint.setVisible(true);
    }

    @Override
    protected boolean isQueryChangeTable() {
        return true;
    }

    @Override
    protected RptBaseQueryUI getQueryPanel() throws Exception {
        if (this.queryUI == null) {
            this.queryUI = new ItemRptQueryUI(true);
        }
        return this.queryUI;
    }

    @Override
    protected CommonQueryDialog getQueryDialog() throws Exception {
        this.dialog = super.getQueryDialog();
        this.dialog.setWidth(640);
        this.dialog.setHeight(380);
        return this.dialog;
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        String billId = this.getSelectedId();
        if (billId == null || billId.length() == 0) {
            return;
        }
        ReportLinkHelper.showBillUI((IUIObject)this, billId);
    }

    private String getSelectedId() throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null) {
            return null;
        }
        int rowInd = selectBlock.getTop();
        String billId = (String)this.tblMain.getRow(rowInd).getCell("FBillId").getValue();
        return billId;
    }

    @Override
    protected void setTreeNodeParam(KDTreeNode selectedNode) {
        super.setTreeNodeParam(selectedNode);
        ((ItemRptQueryParam)this.filterParam).setIsQryAdminPersonNull(false);
        if (!selectedNode.isRoot() && this.filterParam.getCussAcctId() == null) {
            ((ItemRptQueryParam)this.filterParam).setIsQryAdminPersonNull(true);
        }
    }

    @Override
    protected String getTreeTitle() {
        ItemRptQueryParam itemParam = (ItemRptQueryParam)this.filterParam;
        if (itemParam.isSumByCussAcct()) {
            return super.getTreeTitle();
        }
        if (itemParam.isSumByDept()) {
            return EASResource.getString((String)"com.kingdee.eas.fi.ar.ArReport.adminOrgUnit");
        }
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ArReport.Lbl_bizPerson");
    }

    @Override
    protected IRowSet getTreeRowSet() throws Exception {
        IReportFacade iReport = ReportFacadeFactory.getRemoteInstance();
        ArApReportTreeData treeData = iReport.getARItemRptTreeData((IReportQueryParam)this.filterParam);
        if (treeData != null) {
            this.filterParam.setTempTable(treeData.getTempTable());
            if (((ItemRptQueryParam)this.filterParam).isSumByCussAcct()) {
                this.filterParam.setCussAcctTempTable(treeData.getAssistTempTable());
            } else if (((ItemRptQueryParam)this.filterParam).isSumByDept()) {
                ((ItemRptQueryParam)this.filterParam).setAdminOrgTempTable(treeData.getAssistTempTable());
            } else if (((ItemRptQueryParam)this.filterParam).isSumByPerson()) {
                ((ItemRptQueryParam)this.filterParam).setPersonTempTable(treeData.getAssistTempTable());
            }
            return treeData.getRowSet();
        }
        return null;
    }

    @Override
    protected void releaseTempTable() throws BOSException {
        super.releaseTempTable();
        if (((ItemRptQueryParam)this.filterParam).getAdminOrgTempTable() != null) {
            this.iRptFacade.releaseTempTable(((ItemRptQueryParam)this.filterParam).getAdminOrgTempTable());
            ((ItemRptQueryParam)this.filterParam).setAdminOrgTempTable(null);
        }
        if (((ItemRptQueryParam)this.filterParam).getPersonTempTable() != null) {
            this.iRptFacade.releaseTempTable(((ItemRptQueryParam)this.filterParam).getPersonTempTable());
            ((ItemRptQueryParam)this.filterParam).setPersonTempTable(null);
        }
    }

    @Override
    protected IReportData getReport() throws BOSException, EASBizException {
        KDTreeNode selectedNode = this.getSelectedTreeNode();
        if (selectedNode == null) {
            return null;
        }
        IReportFacade iReport = ReportFacadeFactory.getRemoteInstance();
        IReportData rptData = null;
        rptData = iReport.getARItemReport((IReportQueryParam)this.filterParam);
        return rptData;
    }

    @Override
    protected boolean isSumByCussAcct() {
        ItemRptQueryParam param = (ItemRptQueryParam)this.filterParam;
        return param.isSumByCussAcct();
    }

    @Override
    protected boolean isShowAllNodesData() {
        return true;
    }

    @Override
    protected boolean isViewEnabled() {
        return true;
    }

    @Override
    protected boolean isGetAllNodesRptFirstTime() {
        return true;
    }

    @Override
    protected String getColTitle(String key) {
        if ("base".equals(this.filterParam.getCurrencyId())) {
            if (key.equals("FDebitAmtLocal")) {
                return EASResource.getString((String)this.getResource(), (String)"Lbl_FArDebitLocal");
            }
            if (key.equals("FCreditAmtLocal")) {
                return EASResource.getString((String)this.getResource(), (String)"Lbl_FArCreditLocal");
            }
        } else if (!"base".equals(this.filterParam.getCurrencyId()) && !this.filterParam.isBaseCurrency()) {
            if (key.equals("FDebitAmt")) {
                return EASResource.getString((String)this.getResource(), (String)"Lbl_FArDebit");
            }
            if (key.equals("FCreditAmt")) {
                return EASResource.getString((String)this.getResource(), (String)"Lbl_FArCredit");
            }
        } else if (!"base".equals(this.filterParam.getCurrencyId()) && this.filterParam.isBaseCurrency()) {
            if (key.equals("FDebitAmt")) {
                return EASResource.getString((String)this.getResource(), (String)"Lbl_FArDebit");
            }
            if (key.equals("FCreditAmt")) {
                return EASResource.getString((String)this.getResource(), (String)"Lbl_FArCredit");
            }
            if (key.equals("FDebitAmtLocal")) {
                return EASResource.getString((String)this.getResource(), (String)"Lbl_FArDebitLocal");
            }
            if (key.equals("FCreditAmtLocal")) {
                return EASResource.getString((String)this.getResource(), (String)"Lbl_FArCreditLocal");
            }
        }
        return EASResource.getString((String)this.getResource(), (String)("Lbl_" + key));
    }

    protected void preparePrintPageHeader(HeadFootModel headerModel) {
        StringBuffer row = new StringBuffer();
        row.append(EASResource.getString((String)this.getResource(), (String)"PRNT_Company"));
        row.append("&[Company] &| ");
        ItemRptQueryParam param = (ItemRptQueryParam)this.filterParam;
        if (param.isSumByCussAcct()) {
            row.append(param.getCussAcctTypeInfo().getName());
            row.append(": &[AsstAct]");
        }
        headerModel.addRow(row.toString());
        row.delete(0, row.length());
        if (!param.isAllCurrency()) {
            row.append(EASResource.getString((String)this.getResource(), (String)"PRNT_Currency"));
            row.append("&[Currency] &| ");
        } else {
            row.append(" &| ");
        }
        row.append(EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"PRNT_DateRange"));
        row.append("&[DateRange] ");
        headerModel.addRow(row.toString());
    }

    @Override
    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        String compName = SysContext.getSysContext().getCurrentFIUnit().getName();
        map.put("Company", compName);
        ItemRptQueryParam param = (ItemRptQueryParam)this.filterParam;
        if (param.isSumByCussAcct() && !StringUtils.isEmpty((String)param.getCussAcctId())) {
            KDTreeNode selectedNode = this.getSelectedTreeNode();
            map.put("AsstAct", selectedNode.getText());
        }
        if (!param.isAllCurrency()) {
            map.put("Currency", param.getCurrencyInfo().getName());
        }
        String dateRange = null;
        dateRange = param.isByPeriod() ? TablePrintUtil.getPeriodRangeDesc(param.getStartPeriodYear(), param.getStartPeriodNum(), param.getEndPeriodYear(), param.getEndPeriodNum()) : TablePrintUtil.getDateRangeDesc(param.getBeginDate(), param.getEndDate());
        map.put("DateRange", dateRange);
        return map;
    }

    @Override
    protected boolean isSupportTreeMultiPrint() {
        return true;
    }

    @Override
    protected void prepareContinousPrintVarMap(MultiPrint mp) {
        TreePath[] tps = this.getTreePath(mp.isPrintAll());
        if (tps == null) {
            return;
        }
        mp.getMultiPrintModel().setRequestData((IRequestTableData)this);
        String compName = SysContext.getSysContext().getCurrentFIUnit().getName();
        ItemRptQueryParam param = (ItemRptQueryParam)this.filterParam;
        String dateRange = null;
        dateRange = param.isByPeriod() ? TablePrintUtil.getPeriodRangeDesc(param.getStartPeriodYear(), param.getStartPeriodNum(), param.getEndPeriodYear(), param.getEndPeriodNum()) : TablePrintUtil.getDateRangeDesc(param.getBeginDate(), param.getEndDate());
        String currName = param.isAllCurrency() ? "" : param.getCurrencyInfo().getName();
        int n = tps.length;
        for (int i = 0; i < n; ++i) {
            HashMap<String, String> var = new HashMap<String, String>();
            var.put("Company", compName);
            var.put("Currency", currName);
            var.put("AsstAct", tps[i].getLastPathComponent().toString());
            var.put("DateRange", dateRange);
            mp.getMultiPrintModel().addVarParser("PrintJob_" + i, var);
            mp.getMultiPrintModel().addTreePath("PrintJob_" + i, (Object)tps[i]);
        }
    }

    @Override
    protected void loadRow(IRow row, IObjectValue rowInfo) {
        super.loadRow(row, rowInfo);
        ItemRptQueryParam param = (ItemRptQueryParam)this.filterParam;
        if (!param.isShowMaterialItem()) {
            return;
        }
        int qtyPrec = rowInfo.getInt("FQtyPrecision");
        String qtyFmt = PrecisionFormatUtils.getFormatString(qtyPrec);
        row.getCell("FQuantity").getStyleAttributes().setNumberFormat(qtyFmt);
    }

    @Override
    public boolean isAsynchronism() {
        return true;
    }

    @Override
    protected String getUIFullName() {
        return "com.kingdee.eas.fi.ar.client.ArItemRptUI";
    }

    @Override
    protected boolean isReportTree() {
        return true;
    }

    @Override
    protected String getPrintPermItem() {
        return "fi_arap_ArDetailReport_Print";
    }

    @Override
    protected List getQueryCompanys() {
        if (this.getUIContext().get("RPTFilter") instanceof ItemRptQueryParam) {
            ItemRptQueryParam param = (ItemRptQueryParam)this.getUIContext().get("RPTFilter");
            if (param.getCompanyId() != null) {
                ArrayList<String> companyList = new ArrayList<String>();
                companyList.add(param.getCompanyId());
                return companyList;
            }
        } else {
            CompanyOrgUnitInfo companyInfo = SysContext.getSysContext().getCurrentFIUnit();
            if (companyInfo != null) {
                ArrayList<String> companyList = new ArrayList<String>();
                companyList.add(companyInfo.getId().toString());
                return companyList;
            }
        }
        return null;
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.curIndex = 0;
        if (!this.bLoaded) {
            this.filterParam = this.getDefaultQueryParam();
        }
        if (this.bLoaded || this.filterParam == null) {
            if (!this.getQueryDialog().show()) {
                this.filterParam = (ArApQueryParam)this.getQueryPanel().getRptParam();
                this.filterParam.setBaseCurrencyInfo(this.baseCurrency);
                this.prepareParamForQuery(this.filterParam);
                SysUtil.abort();
                return;
            }
            this.filterParam = (ArApQueryParam)this.getQueryPanel().getRptParam();
        }
        if (this.filterParam == null) {
            logger.warn((Object)"the query param is null");
            SysUtil.abort();
        }
        this.filterParam.setBaseCurrencyInfo(this.baseCurrency);
        this.prepareGetReport(null).callHandler();
        if (!this.bLoaded || this.isQueryChangeTable()) {
            this.setReportHead(this.filterParam.getReportHead());
        }
        if (this.filterParam.isAllCurrency() && this.currencyColls == null) {
            ICurrency iCurr = CurrencyFactory.getRemoteInstance();
            this.currencyColls = iCurr.getCurrencyCollection(true);
        }
        this.prepareParamForQuery(this.filterParam);
        ActionEvent getEvt = new ActionEvent(this.btnRefresh, 1001, this.btnRefresh.getActionCommand());
        this.actionRefresh.actionPerformed(getEvt);
    }
}

