/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.ar.ArOtherBillReportFacadeFactory;
import com.kingdee.eas.fi.ar.client.AbstractArOtherBillReportUI;
import com.kingdee.eas.fi.ar.client.ArOtherBillReportQueryUI;
import com.kingdee.eas.fi.arap.ArApConstants;
import com.kingdee.eas.fi.arap.client.KDTableUtils;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.DefaultKDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.TypeConversionUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.log4j.Logger;

public class ArOtherBillReportUI
extends AbstractArOtherBillReportUI {
    private static final Color TOTALCOLOR = new Color(246, 246, 191);
    private static final long serialVersionUID = 435704582705266501L;
    private static final int sum = 1;
    private static final int total = 2;
    private static final Logger logger = CoreUIObject.getLogger(ArOtherBillReportUI.class);
    private static final String ArResource = "com.kingdee.eas.fi.ar.client.ArResource";
    private static final String precisionColumn = "precision";
    private static final String billnumberCoumn = "number";
    private static final String[] numberColumn = new String[]{"amount", "verifyamount", "unverifyamount"};
    private static final String[] localNumberColumn = new String[]{"amountlocal", "verifyamountlocal", "unverifyamountlocal"};

    public ArOtherBillReportUI() throws Exception {
        this.tblReport.checkParsed();
        this.tblReport.getDataRequestManager().setDataRequestMode(1);
        this.tblReport.getStyleAttributes().setLocked(true);
        this.tblReport.getSelectManager().setSelectMode(10);
        this.enableExportExcel(this.tblReport);
        this.tblReport.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        Map oldQuery = this.params.toMap();
        this.params.clear();
        if (!this.showQueryDialog(false)) {
            this.params.putAll(oldQuery);
        }
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        String logMsg = this.getPrintLogMsg(false);
        IObjectPK pkOut = LogUtil.beginLog(null, (String)logMsg, (BOSObjectType)this.getRemoteInstance().getType(), null, (String)logMsg);
        super.actionPrint_actionPerformed(e);
        LogUtil.afterLog(null, (IObjectPK)pkOut);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        String logMsg = this.getPrintLogMsg(true);
        IObjectPK pkOut = LogUtil.beginLog(null, (String)logMsg, (BOSObjectType)this.getRemoteInstance().getType(), null, (String)logMsg);
        super.actionPrintPreview_actionPerformed(e);
        LogUtil.afterLog(null, (IObjectPK)pkOut);
    }

    protected String getPrintLogMsg(boolean fPreview) {
        String pattern = EASResource.getString((String)"com.kingdee.eas.fi.arap.ArApRptResource", (String)(fPreview ? "LogPrintPreview" : "LogPrint"));
        return MessageFormat.format(pattern, this.getUITitle());
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return ArOtherBillReportFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblReport;
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected String getQueryDialogTitle(CustomerQueryPanel[] userPanels) {
        return this.getUITitle() + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter");
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        ArOtherBillReportQueryUI ui = new ArOtherBillReportQueryUI();
        ui.setSize(548, 475);
        return ui;
    }

    protected void query() {
        RptParams rptParams = new RptParams();
        rptParams.putAll(this.params.toMap());
        this.setColumnPosition(rptParams);
        this.tblReport.removeRows();
    }

    public void getData(KDTDataRequestEvent e) {
        try {
            RptParams rpt;
            this.tblReport.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
            int from = e.getFirstRow();
            int len = e.getLastRow() - from + 1;
            RptParams rptParams = new RptParams();
            rptParams.putAll(this.params.toMap());
            if (from == 0) {
                rptParams.setString("tempTable", this.getTempTable());
                rpt = this.getRemoteInstance().createTempTable(rptParams);
                this.setTempTable(rpt.getString("tempTable"));
                this.tblReport.setRowCount(rpt.getInt("rowCount"));
            }
            rptParams.setString("tempTable", this.getTempTable());
            rpt = this.getRemoteInstance().query(rptParams, from, len);
            RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
            KDTableUtils.insertRows(rs, from, this.tblReport, true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs));
            if (rs.getRowCount() != 0) {
                this.changeDataDisplayStyle(rptParams.getString("currency"), rptParams.getString("company"), e.getFirstRow(), e.getFirstRow() + rs.getRowCount() - 1);
            }
            if (from == 0) {
                this.tblReport.gerGroupManager().group();
            }
            this.tblReport.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private void setColumnPosition(RptParams rptParams) {
        this.tblReport.getGroupManager().removeGroup();
        this.tblReport.getGroupManager().setGroup(true);
        this.tblReport.getColumn("currency").setGroup(true);
        this.tblReport.getColumn("currency").setMergeable(true);
        this.tblReport.setColumnMoveable(true);
        int sumFreezeCol = 0;
        if ("yes".equals(rptParams.getString("sumAsstact"))) {
            this.tblReport.moveColumn(this.tblReport.getColumnIndex("asstacttype"), this.tblReport.getColumnIndex(billnumberCoumn));
            this.tblReport.moveColumn(this.tblReport.getColumnIndex("asstactnumber"), this.tblReport.getColumnIndex(billnumberCoumn));
            this.tblReport.moveColumn(this.tblReport.getColumnIndex("asstactname"), this.tblReport.getColumnIndex(billnumberCoumn));
            this.tblReport.getColumn("asstacttype").setGroup(true);
            this.tblReport.getColumn("asstacttype").setMergeable(true);
            this.tblReport.getColumn("asstactnumber").setGroup(true);
            this.tblReport.getColumn("asstactnumber").setMergeable(true);
            this.tblReport.getColumn("asstactname").setGroup(true);
            this.tblReport.getColumn("asstactname").setMergeable(true);
            sumFreezeCol += 3;
        } else {
            this.tblReport.moveColumn(this.tblReport.getColumnIndex("asstacttype"), this.tblReport.getColumnIndex("saleorg"));
            this.tblReport.moveColumn(this.tblReport.getColumnIndex("asstactnumber"), this.tblReport.getColumnIndex("saleorg"));
            this.tblReport.moveColumn(this.tblReport.getColumnIndex("asstactname"), this.tblReport.getColumnIndex("saleorg"));
            this.tblReport.getColumn("asstacttype").setGroup(false);
            this.tblReport.getColumn("asstacttype").setMergeable(false);
            this.tblReport.getColumn("asstactnumber").setGroup(false);
            this.tblReport.getColumn("asstactnumber").setMergeable(false);
            this.tblReport.getColumn("asstactname").setGroup(false);
            this.tblReport.getColumn("asstactname").setMergeable(false);
        }
        if ("yes".equals(rptParams.getString("sumAdminorg"))) {
            this.tblReport.moveColumn(this.tblReport.getColumnIndex("adminorg"), this.tblReport.getColumnIndex(billnumberCoumn));
            this.tblReport.getColumn("adminorg").setGroup(true);
            this.tblReport.getColumn("adminorg").setMergeable(true);
            ++sumFreezeCol;
        } else {
            this.tblReport.moveColumn(this.tblReport.getColumnIndex("adminorg"), this.tblReport.getColumnIndex("abstractname"));
            this.tblReport.getColumn("adminorg").setGroup(false);
            this.tblReport.getColumn("adminorg").setMergeable(false);
        }
        if ("yes".equals(rptParams.getString("sumPerson"))) {
            this.tblReport.moveColumn(this.tblReport.getColumnIndex("person"), this.tblReport.getColumnIndex(billnumberCoumn));
            this.tblReport.getColumn("person").setGroup(true);
            this.tblReport.getColumn("person").setMergeable(true);
            ++sumFreezeCol;
        } else {
            this.tblReport.moveColumn(this.tblReport.getColumnIndex("person"), this.tblReport.getColumnIndex("abstractname"));
            this.tblReport.getColumn("person").setGroup(false);
            this.tblReport.getColumn("person").setMergeable(false);
        }
        this.tblReport.moveColumn(this.tblReport.getColumnIndex("recSendOrgUnit"), this.tblReport.getColumnIndex("abstractname"));
        this.tblReport.getViewManager().setFreezeView(0, 3 + sumFreezeCol);
        this.tblReport.setColumnMoveable(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        String fmt = CtrlFormatUtilities.getDateFormatString();
        this.tblReport.getColumn("billdate").getStyleAttributes().setNumberFormat(fmt);
    }

    public Object getTablePreferenceSchemaKey() {
        RptParams rptParams = new RptParams();
        rptParams.putAll(this.params.toMap());
        StringBuffer sb = new StringBuffer("");
        if ("yes".equals(rptParams.getString("sumAsstact"))) {
            sb.append("-sumAsstact");
        }
        if ("yes".equals(rptParams.getString("sumAdminorg"))) {
            sb.append("-sumAdminorg");
        }
        if ("yes".equals(rptParams.getString("sumPerson"))) {
            sb.append("-sumPerson");
        }
        return sb.toString();
    }

    private void changeDataDisplayStyle(String currency, String companyId, int from, int to) {
        this.setNumberPrecision(currency, companyId, from, to);
        this.setSumRowStyle(from, to);
        this.setDateStyle(from, to);
    }

    private void setNumberPrecision(String currency, String companyId, int from, int to) {
        CompanyOrgUnitInfo company = this.getCompany(companyId);
        for (int i = from; i <= to; ++i) {
            IRow row = this.tblReport.getRow(i);
            if (row == null) continue;
            int precision = UIRuleUtil.getInt((Object)row.getCell(precisionColumn).getValue());
            int localPrecision = company.getBaseCurrency().getPrecision();
            String formatString = PrecisionFormatUtils.getFormatString(precision);
            String localFormatString = PrecisionFormatUtils.getFormatString(localPrecision);
            for (int j = 0; j < numberColumn.length; ++j) {
                if (currency == null) {
                    row.getCell(numberColumn[j]).getStyleAttributes().setNumberFormat(formatString);
                    continue;
                }
                this.tblReport.getColumn(numberColumn[j]).getStyleAttributes().setNumberFormat(formatString);
            }
            for (int k = 0; k < localNumberColumn.length; ++k) {
                this.tblReport.getColumn(localNumberColumn[k]).getStyleAttributes().setNumberFormat(localFormatString);
            }
        }
    }

    private CompanyOrgUnitInfo getCompany(String companyId) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo(billnumberCoumn));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        CompanyOrgUnitInfo company = null;
        try {
            company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), sic);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return company;
    }

    private void setSumRowStyle(int from, int to) {
        for (int i = from; i <= to; ++i) {
            IRow row = this.tblReport.getRow(i);
            if (row == null) continue;
            int flag = Integer.parseInt(row.getCell("flag").getValue().toString());
            if (flag == 1) {
                row.getCell(billnumberCoumn).setValue((Object)EASResource.getString((String)ArResource, (String)"sum"));
                row.getStyleAttributes().setBackground(ArApConstants.DAY_SUM_COLOR);
                continue;
            }
            if (flag != 2) continue;
            String totalString = EASResource.getString((String)ArResource, (String)"total");
            String currency = "";
            if (row.getCell("currency").getValue() != null) {
                currency = row.getCell("currency").getValue().toString();
            }
            row.getCell("currency").setValue((Object)(currency + totalString));
            row.getStyleAttributes().setBackground(TOTALCOLOR);
        }
    }

    private void setDateStyle(int from, int to) {
        Date cellVal = null;
        for (int i = from; i <= to; ++i) {
            IRow row = this.tblReport.getRow(i);
            if (row == null || row.getCell("billdate").getValue() == null || !(row.getCell("billdate").getValue() instanceof Timestamp)) continue;
            cellVal = TypeConversionUtils.objToDate((Object)row.getCell("billdate").getValue());
            row.getCell("billdate").setValue((Object)cellVal);
        }
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
    }

    public boolean isAsynchronism() {
        return true;
    }

    protected String getUIFullName() {
        return "com.kingdee.eas.fi.ar.client.ArOtherBillReportUI";
    }
}

