/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.util.CommonPrintIntegrationDataProvider;
import com.kingdee.eas.basedata.assistant.util.PrintIntegrationManager;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.ArPrintBillCollection;
import com.kingdee.eas.fi.ar.ArPrintBillEntryInfo;
import com.kingdee.eas.fi.ar.ArPrintBillFactory;
import com.kingdee.eas.fi.ar.ArPrintBillInfo;
import com.kingdee.eas.fi.ar.IArPrintBill;
import com.kingdee.eas.fi.ar.client.AbstractArPrintBillEditUI;
import com.kingdee.eas.fi.ar.client.util.ArApValidateHelper;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.client.util.ComBoxInfo;
import com.kingdee.eas.fi.ar.util.ArBillListPrintProvider;
import com.kingdee.eas.fi.arap.client.KDTableUtils;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.util.MultiDataSourceDataProviderProxy;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ArPrintBillEditUI
extends AbstractArPrintBillEditUI {
    private CompanyOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentFIUnit();
    private static final Logger logger = CoreUIObject.getLogger(ArPrintBillEditUI.class);
    private AsstActTypeInfo asstActTypeInfo = null;
    IDynamicObject dynamicObject = null;
    private String sNumber = "";
    private static final String PERSON_HOMEPHONE_KEY = "person_homePhone_key";
    private static final String CUSTOMER_ADDRESS_KEY = "customer_address_key";

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemBlankout.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
    }

    @Override
    public void loadFields() {
        BOSObjectType objType;
        ObjectUuidPK pk;
        BOSUuid uuid;
        BigDecimal totalAmount = new BigDecimal("0.00");
        CurrencyInfo currencyInfo = (CurrencyInfo)this.prmtCurrency.getData();
        int precision = 2;
        if (currencyInfo != null) {
            precision = currencyInfo.getPrecision();
        }
        if (this.editData.getCurrency() != null) {
            precision = this.editData.getCurrency().getPrecision();
        }
        this.txtTotalAmount.setValue((Object)totalAmount);
        this.txtTotalAmount.setHorizontalAlignment(4);
        this.txtTotalAmount.setDataType(1);
        this.txtTotalAmount.setPrecision(precision);
        this.txtTotalAmount.setEditable(false);
        this.txtTotalAmount.setEnabled(true);
        this.txtTotalAmount.setRemoveingZeroInDispaly(false);
        this.txtNumber.setRequired(true);
        KDFormattedTextField currencyTextField = ArClientUtils.getFormattedTextField(precision, true);
        currencyTextField.setRoundingMode(4);
        super.loadFields();
        this.setAsstActType();
        if (this.editData.getAcctCussentId() != null) {
            uuid = BOSUuid.read((String)this.editData.getAcctCussentId());
            pk = new ObjectUuidPK(uuid);
            objType = uuid.getType();
            try {
                if (this.dynamicObject == null) {
                    this.dynamicObject = DynamicObjectFactory.getRemoteInstance();
                }
                IObjectValue objectValue = this.dynamicObject.getValue(objType, (IObjectPK)pk);
                this.prmtAccountCussent.setData((Object)objectValue);
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        this.setNumberEnabled();
        this.prmtAccountCussent.setEnabled(false);
        this.setBillTotalAmount();
        this.actionEdit.setEnabled(false);
        this.actionRemove.setEnabled(false);
        if (this.editData.getStatus() == null) {
            this.actionCreateFrom.setEnabled(true);
            this.actionBlankout.setEnabled(false);
            this.actionSave.setEnabled(true);
        } else if (DeletedStatusEnum.NORMAL.equals((Object)this.editData.getStatus())) {
            this.actionCreateFrom.setEnabled(true);
            this.actionBlankout.setEnabled(!"ADDNEW".equals(this.getOprtState()));
            this.actionRemoveLine.setEnabled(false);
            this.actionSave.setEnabled(false);
        } else {
            this.actionCreateFrom.setEnabled(false);
            this.actionBlankout.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
            this.actionSave.setEnabled(false);
        }
        if (!StringUtils.isEmpty((String)this.editData.getAcctCussentId())) {
            uuid = BOSUuid.read((String)this.editData.getAcctCussentId());
            pk = new ObjectUuidPK(uuid);
            objType = uuid.getType();
            try {
                IDynamicObject dynamicObject = DynamicObjectFactory.getRemoteInstance();
                IObjectValue objectValue = dynamicObject.getValue(objType, (IObjectPK)pk);
                this.prmtAccountCussent.setData((Object)objectValue);
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        if (this.editData.getCompany() == null) {
            this.prmtCompany.setValue((Object)this.currentCompany);
        }
        try {
            this.setAcctCussentProps();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        KDTableUtils.setStrColMaxLength(this.kdtEntries, "summary", 255);
    }

    private void setAcctCussentProps() throws EASBizException, BOSException {
        if (this.editData.getAcctCussentId() != null) {
            BOSUuid asstActId = BOSUuid.read((String)this.editData.getAcctCussentId());
            if (new CustomerInfo().getBOSType().equals((Object)asstActId.getType())) {
                CustomerInfo customerInfo = CustomerFactory.getRemoteInstance().getCustomerInfo("select address where id='" + this.editData.getAcctCussentId() + "'");
                this.editData.put(CUSTOMER_ADDRESS_KEY, customerInfo.getAddress());
            }
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getCreator().getId());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("person.officePhone");
        String officePhone = "";
        UserInfo userInfo = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)pk, sic);
        if (userInfo.getPerson() != null) {
            officePhone = userInfo.getPerson().getOfficePhone();
        }
        this.editData.put(PERSON_HOMEPHONE_KEY, officePhone);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        try {
            this.editData.setAsstActType(this.asstActTypeInfo);
            if (this.prmtAccountCussent.getValue() != null) {
                this.editData.setAcctCussentId(((IObjectValue)this.prmtAccountCussent.getValue()).getString("id"));
                this.editData.setAcctCussentName(((IObjectValue)this.prmtAccountCussent.getValue()).getString("name"));
                this.editData.setAcctCussentNumber(((IObjectValue)this.prmtAccountCussent.getValue()).getString("number"));
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private boolean isFromGL() {
        String sIsFromGL = (String)this.getUIContext().get("UIClassParam");
        return "isFromGL".equals(sIsFromGL);
    }

    public List getSrcBosTypeForBotp(List srcBosTypeList) {
        if (this.isFromGL()) {
            srcBosTypeList.remove("FC910EF3");
        } else {
            srcBosTypeList.remove("CE2D850A");
        }
        return super.getSrcBosTypeForBotp(srcBosTypeList);
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.actionSubmit_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getCU() == null) {
            this.editData.setCU(this.currentCompany.getCU());
        }
        super.actionSubmit_actionPerformed(e);
    }

    protected void afterSubmitEdit(IObjectPK pk) {
        this.actionBlankout.setEnabled(true);
        super.afterSubmitEdit(pk);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.prmtAccountCussent.setEnabled(false);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.prmtAccountCussent.setEnabled(false);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.prmtAccountCussent.setEnabled(false);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.prmtAccountCussent.setEnabled(false);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.btnCreateFrom.setEnabled(true);
        this.pkBillDate.setEnabled(true);
        this.actionBlankout.setEnabled(false);
        this.setBillTotalAmount();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setOprtState("EDIT");
        this.pkBillDate.setEnabled(true);
        if ("EDIT".equals(this.oprtState)) {
            this.actionRemoveLine.setEnabled(true);
            this.txtTotalAmount.setEditable(false);
            this.txtTotalAmount.setEnabled(true);
            this.kDTextRemark.setEditable(true);
            this.pkBillDate.setEnabled(true);
            this.kDComboBoxStatus.setEnabled(false);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
    }

    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertLine_actionPerformed(e);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
        this.setBillTotalAmount();
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        this.sNumber = this.txtNumber.getText();
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put("TargetBillType", "ArPrintBill");
        this.getBillEdit().createFrom(this.getMainOrgContext(), ctx);
        this.setBillTotalAmount();
        if (!StringUtils.isEmpty((String)this.sNumber) && !this.isAutoNumber()) {
            this.txtNumber.setText(this.sNumber);
        }
    }

    public void actionCopyFrom_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyFrom_actionPerformed(e);
    }

    public void actionAuditResult_actionPerformed(ActionEvent e) throws Exception {
        super.actionAuditResult_actionPerformed(e);
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceUp_actionPerformed(e);
    }

    private boolean isCheckNumber() throws CodingRuleException, EASBizException, BOSException {
        return !this.isAutoNumber() || this.isAddView();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        ArApValidateHelper.validateContainer((Container)((Object)this));
        IRow row = null;
        Object obj = null;
        int entryRowCount = this.kdtEntries.getRowCount();
        if (entryRowCount <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("entryIsNull"));
            SysUtil.abort();
        }
        for (int i = 0; i < entryRowCount; ++i) {
            row = this.kdtEntries.getRow(i);
            if (row.getCell("sourceBillEntryId").getValue() != null && row.getCell("Eid").getValue() != null) continue;
            MsgBox.showInfo((String)ArApBillUIUtil.getStrResource("SourceIDIsNull"));
            SysUtil.abort();
        }
        super.beforeStoreFields(e);
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceDown_actionPerformed(e);
    }

    public void actionViewSubmitProccess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewSubmitProccess_actionPerformed(e);
    }

    public void actionViewDoProccess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewDoProccess_actionPerformed(e);
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ArPrintBillFactory.getRemoteInstance();
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        ArPrintBillEntryInfo aArPrintBillEntryInfo = new ArPrintBillEntryInfo();
        return aArPrintBillEntryInfo;
    }

    protected IObjectValue createNewData() {
        ArPrintBillInfo aArPrintBillInfo = new ArPrintBillInfo();
        aArPrintBillInfo.setCompany(this.currentCompany);
        AsstActTypeInfo asstInfo = null;
        try {
            asstInfo = BaseDataUtil.getDefaultAsstActType();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (asstInfo != null) {
            aArPrintBillInfo.setAsstActType(asstInfo);
        }
        aArPrintBillInfo.setStatus(DeletedStatusEnum.NORMAL);
        aArPrintBillInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        return aArPrintBillInfo;
    }

    public void setAsstActType() {
        try {
            BaseDataUtil.makeBillAsstActType(this.kdComAsstActType);
            if (this.kdComAsstActType.getSelectedItem() == null) {
                this.prmtAccountCussent.setEnabled(false);
            }
            if (this.editData.getAsstActType() != null) {
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.editData.getAsstActType().getString("id")));
                AsstActTypeInfo asstInfo = AsstActTypeFactory.getRemoteInstance().getAsstActTypeInfo((IObjectPK)pk);
                ComBoxInfo comboxInfo = new ComBoxInfo((IObjectValue)asstInfo, asstInfo.getName(), true);
                this.kdComAsstActType.setSelectedItem((Object)comboxInfo);
            }
        }
        catch (Exception e) {
            logger.info((Object)e);
            this.handUIExceptionAndAbort(e);
        }
    }

    protected boolean isAutoNumber() throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        return iCodingRuleManager.isExist((IObjectValue)this.editData, this.currentCompany.getId().toString());
    }

    public void setNumberEnabled() {
        if (this.editData == null) {
            return;
        }
        try {
            boolean isAutoNumber = this.isAutoNumber();
            if ("ADDNEW".equals(this.getOprtState())) {
                if (isAutoNumber) {
                    this.txtNumber.setEnabled(false);
                }
            } else if ("EDIT".equals(this.getOprtState())) {
                if (isAutoNumber) {
                    boolean isAddView = this.isAddView();
                    if (this.editData.getStatus() == null && isAddView && StringUtils.isEmpty((String)this.editData.getNumber())) {
                        this.txtNumber.setEnabled(false);
                        this.txtNumber.setText(BaseDataUtil.getCodeRuleClient(this.editData));
                    }
                } else {
                    this.txtNumber.setEnabled(true);
                    this.txtNumber.setText(this.sNumber);
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public boolean isAddView() throws CodingRuleException, EASBizException, BOSException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = this.currentCompany;
        String strCompanyID = aCompanyOrgUnitInfo.getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        return iCodingRuleManager.isAddView((IObjectValue)this.editData, strCompanyID);
    }

    @Override
    protected void kdComAsstActType_itemStateChanged(ItemEvent e) throws Exception {
        this.prmtAccountCussent.setValue(null);
        if (this.kdComAsstActType.getItemCount() == 0 || this.kdComAsstActType.getSelectedItem() == null) {
            this.prmtAccountCussent.setEnabled(false);
            return;
        }
        this.asstActTypeInfo = (AsstActTypeInfo)((ComBoxInfo)this.kdComAsstActType.getSelectedItem()).getobjInfo();
        if (this.asstActTypeInfo == null || this.asstActTypeInfo.getDefaultQueryName() == null) {
            this.prmtAccountCussent.setEnabled(false);
            return;
        }
        ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmtAccountCussent, this.asstActTypeInfo, false);
        this.prmtAccountCussent.setEnabled(true);
        super.kdComAsstActType_itemStateChanged(e);
    }

    public void onLoad() throws Exception {
        BigDecimal totalAmount = new BigDecimal("0.00");
        CurrencyInfo currencyInfo = (CurrencyInfo)this.prmtCurrency.getData();
        int precision = 2;
        if (currencyInfo != null) {
            precision = currencyInfo.getPrecision();
        }
        this.txtTotalAmount.setValue((Object)totalAmount);
        this.txtTotalAmount.setHorizontalAlignment(4);
        this.txtTotalAmount.setDataType(1);
        this.txtTotalAmount.setPrecision(precision);
        this.txtTotalAmount.setRoundingMode(4);
        this.txtTotalAmount.setRemoveingZeroInDispaly(true);
        this.txtNumber.setRequired(true);
        KDFormattedTextField currencyTextField = ArClientUtils.getFormattedTextField(precision, true);
        currencyTextField.setRoundingMode(4);
        String format = PrecisionFormatUtils.getFormatString(precision);
        KDTDefaultCellEditor numCellEditor = new KDTDefaultCellEditor((JTextField)currencyTextField);
        super.onLoad();
        if ("VIEW".equalsIgnoreCase(this.getOprtState())) {
            this.actionRemoveLine.setEnabled(false);
            this.btnRemoveLine.setEnabled(false);
            this.btnRemoveLine.setVisible(false);
        }
        this.kdtEntries.getColumn("amount").setEditor((ICellEditor)numCellEditor);
        this.kdtEntries.getColumn("amount").getStyleAttributes().setNumberFormat(format);
        this.kdtEntries.getColumn("price").setEditor((ICellEditor)numCellEditor);
        this.kdtEntries.getColumn("price").getStyleAttributes().setNumberFormat(format);
        this.btn_blankout.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.prmtAccountCussent.setEnabled(false);
        this.kDComboBoxStatus.setEditable(false);
        this.kDComboBoxStatus.setEnabled(false);
        this.actionAddNew.setVisible(true);
        this.actionCreateFrom.setVisible(true);
        this.actionBlankout.setVisible(true);
        this.actionAddLine.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionCopyFrom.setVisible(false);
        this.actionDelVoucher.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionInsertLine.setVisible(false);
        this.actionMultiapprove.setVisible(false);
        this.actionNextPerson.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionSave.setVisible(true);
        this.actionTraceDown.setVisible(false);
        this.actionViewDoProccess.setVisible(false);
        this.actionViewSubmitProccess.setVisible(false);
        this.actionVoucher.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.menuWorkflow.setVisible(false);
        this.menuTable1.setVisible(true);
        this.menuBiz.setVisible(true);
        this.setBillTotalAmount();
        if ("ADDNEW".equals(this.oprtState)) {
            this.btnCreateFrom.setEnabled(true);
        }
        this.kDTextRemark.setMaxLength(255);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.prmtAccountCussent.setEnabled(false);
        this.kdComAsstActType.setEnabled(false);
        this.kDComboBoxStatus.setEnabled(false);
        this.prmtCurrency.setEnabled(false);
        this.txtTotalAmount.setEnabled(false);
        this.pkBillDate.setEnabled(true);
    }

    public int getBtpCreateFromType() {
        return 1;
    }

    private void setBillTotalAmount() {
        int rowIndex = 0;
        BigDecimal totalAmount = new BigDecimal("0.00");
        BigDecimal receiveAmount = null;
        this.prmtAccountCussent.setEnabled(false);
        this.prmtAccountCussent.setEnabled(false);
        this.kdComAsstActType.setEnabled(false);
        this.kDComboBoxStatus.setEnabled(false);
        this.prmtCurrency.setEnabled(false);
        this.txtTotalAmount.setEditable(false);
        this.pkBillDate.setEnabled(true);
        CurrencyInfo currencyInfo = (CurrencyInfo)this.prmtCurrency.getData();
        int precision = 2;
        if (currencyInfo != null) {
            precision = currencyInfo.getPrecision();
        }
        KDFormattedTextField currencyTextField = ArClientUtils.getFormattedTextField(precision, true);
        currencyTextField.setRoundingMode(4);
        String format = PrecisionFormatUtils.getFormatString(precision);
        KDTDefaultCellEditor numCellEditor = new KDTDefaultCellEditor((JTextField)currencyTextField);
        this.kdtEntries.getColumn("amount").setEditor((ICellEditor)numCellEditor);
        this.kdtEntries.getColumn("amount").getStyleAttributes().setNumberFormat(format);
        this.kdtEntries.getColumn("price").setEditor((ICellEditor)numCellEditor);
        this.kdtEntries.getColumn("price").getStyleAttributes().setNumberFormat(format);
        while (rowIndex < this.kdtEntries.getRowCount()) {
            IRow row = this.kdtEntries.getRow(rowIndex);
            receiveAmount = (BigDecimal)row.getCell("amount").getValue();
            if (receiveAmount != null) {
                totalAmount = totalAmount.add(receiveAmount);
            }
            ++rowIndex;
        }
        this.txtTotalAmount.setValue((Object)totalAmount);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.invokePrintFunction(e, true);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.invokePrintFunction(e, false);
    }

    protected void invokePrintFunction(ActionEvent e, boolean noPreview) {
        ArPrintBillCollection billCol = new ArPrintBillCollection();
        this.editData.setTotalAmount((BigDecimal)this.txtTotalAmount.getValue());
        billCol.add(this.editData);
        MultiDataSourceDataProviderProxy data = new MultiDataSourceDataProviderProxy();
        ArBillListPrintProvider rsprv = new ArBillListPrintProvider(billCol){

            @Override
            public ArBillListPrintProvider.ColDesc[] getColDesc() {
                return new ArBillListPrintProvider.ColDesc[]{new ArBillListPrintProvider.ColDesc("FNumber", "number"), new ArBillListPrintProvider.ColDesc("FRemark", "remark"), new ArBillListPrintProvider.ColDesc("FBillDate", "billDate", 2), new ArBillListPrintProvider.ColDesc("FCussType", "asstActType.name"), new ArBillListPrintProvider.ColDesc("FCurrency", "currency.name"), new ArBillListPrintProvider.ColDesc("FTotalAmount", "totalAmount", 1, "2"), new ArBillListPrintProvider.ColDesc("FCussName", "acctCussentName"), new ArBillListPrintProvider.ColDesc("FCussNumber", "acctCussentNumber"), new ArBillListPrintProvider.ColDesc("FPersonPhone", ArPrintBillEditUI.PERSON_HOMEPHONE_KEY), new ArBillListPrintProvider.ColDesc("FCustomerAddress", ArPrintBillEditUI.CUSTOMER_ADDRESS_KEY), new ArBillListPrintProvider.ColDesc("FBizDate", "entries.bizDate", 2), new ArBillListPrintProvider.ColDesc("FMaterialNumber", "entries.material.number"), new ArBillListPrintProvider.ColDesc("FMaterialName", "entries.material.name"), new ArBillListPrintProvider.ColDesc("FSummary", "entries.summary"), new ArBillListPrintProvider.ColDesc("FTicketNumber", "entries.ticketNumber"), new ArBillListPrintProvider.ColDesc("FQuantity", "entries.quantity", 1, "2"), new ArBillListPrintProvider.ColDesc("FPrice", "entries.price", 1, "2"), new ArBillListPrintProvider.ColDesc("FMaturityDate", "entries.maturityDate", 2), new ArBillListPrintProvider.ColDesc("FDiscount", "entries.discount", 1, "2"), new ArBillListPrintProvider.ColDesc("FAmount", "entries.amount", 1, "2")};
            }
        };
        data.put("MainQuery", (BOSQueryDelegate)rsprv);
        ArrayList<BOSUuid> idList = new ArrayList<BOSUuid>();
        idList.add(this.editData.getId());
        KDNoteHelper appHlp = new KDNoteHelper();
        CommonPrintIntegrationDataProvider printQueryData = new CommonPrintIntegrationDataProvider(this.editData.getBOSType().toString(), PrintIntegrationManager.getPrintQueryPK());
        data.put("PrintQuery", (BOSQueryDelegate)printQueryData);
        String resTag = noPreview ? "log_TDPrint" : "log_TDPrintReview";
        PrintIntegrationManager.initPrint((KDNoteHelper)appHlp, (BOSObjectType)this.editData.getBOSType(), idList, (String)"/FI/AR/ArBillList", (String)ArApBillUIUtil.getStrResource(resTag), (boolean)true);
        if (noPreview) {
            appHlp.print("/FI/AR/ArBillList", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview("/FI/AR/ArBillList", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    @Override
    public void actionBlankout_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() != null) {
            IArPrintBill iArPrintBill = ArPrintBillFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            iArPrintBill.revoke((IObjectPK)pk);
            this.setOprtState("VIEW");
            this.setDataObject(this.getValue((IObjectPK)pk));
            this.loadFields();
            this.btn_blankout.setEnabled(false);
            this.btnCreateFrom.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
            this.actionBlankout.setEnabled(false);
            this.btnRemoveLine.setEnabled(false);
            this.actionCreateFrom.setEnabled(false);
            this.actionEdit.setEnabled(false);
            this.btnEdit.setEnabled(false);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectors = super.getSelectors();
        selectors.add(new SelectorItemInfo("acctCussentNumber"));
        selectors.add(new SelectorItemInfo("acctCussentName"));
        selectors.add("creator.id");
        return selectors;
    }

    protected void applyDefaultValue(IObjectValue vo) {
    }
}

