/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.fi.ar.AccountAgeQueryParam;
import com.kingdee.eas.fi.ar.OtherBillTypeEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ArVirtualAgingRptDataProvider
extends DefaultNoteDataProvider {
    private DynamicRowSet drs = this.buildDynamicRowSet();
    private static final BigDecimal ZERO = new BigDecimal("0.00");

    private DynamicRowSet buildDynamicRowSet() {
        DynamicRowSet drs = null;
        try {
            drs = new DynamicRowSet(15);
            drs.setColInfo(1, "company", "company", 12, null);
            drs.setColInfo(2, "asstActName", "asstActName", 12, null);
            drs.setColInfo(3, "addr", "accountPeriod", 12, null);
            drs.setColInfo(4, "asstActNumber", "asstActNumber", 12, null);
            drs.setColInfo(5, "currency", "currency", 12, null);
            drs.setColInfo(6, "currencyName", "currencyName", 12, null);
            drs.setColInfo(7, "endDate", "endDate", 12, null);
            drs.setColInfo(8, "billDate", "billDate", 12, null);
            drs.setColInfo(9, "billNumber", "billNumber", 12, null);
            drs.setColInfo(10, "description", "description", 12, null);
            drs.setColInfo(11, "arAmount", "arAmount", 12, null);
            drs.setColInfo(12, "recAmount", "recAmount", 12, null);
            drs.setColInfo(13, "balanceAmount", "balanceAmount", 12, null);
            drs.setColInfo(14, "sumArAmount", "sumArAmount", 12, null);
            drs.setColInfo(15, "sumRecAmount", "sumRecAmount", 12, null);
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)((CoreUI)null), (Throwable)e1);
        }
        return drs;
    }

    public void insertDataToDynamicRowSet(RptParams params, RptRowSet currentRowSet) {
        try {
            AccountAgeQueryParam param = (AccountAgeQueryParam)((Object)params.getObject("qryParam"));
            Map<String, String> addrMap = this.getAddrMap(param, currentRowSet);
            currentRowSet.reset();
            BigDecimal sumBalanceAmount = ZERO;
            BigDecimal sumArAmount = ZERO;
            BigDecimal sumRecAmount = ZERO;
            HashSet<String> asstActSet = new HashSet<String>();
            String asstActNumber = null;
            while (currentRowSet.next()) {
                if (1 == currentRowSet.getInt("FIsSum")) continue;
                this.drs.moveToInsertRow();
                asstActNumber = currentRowSet.getString("FAsstActNumber");
                if (!asstActSet.contains(asstActNumber)) {
                    asstActSet.add(asstActNumber);
                    sumBalanceAmount = ZERO;
                    sumArAmount = ZERO;
                    sumRecAmount = ZERO;
                }
                this.drs.updateString("company", currentRowSet.getString("FCompany"));
                this.drs.updateString("asstActName", currentRowSet.getString("FCussAcct"));
                this.drs.updateString("asstActNumber", asstActNumber);
                this.drs.updateString("addr", addrMap.get(asstActNumber));
                this.drs.updateString("currency", currentRowSet.getString("FCurrNum"));
                this.drs.updateString("currencyName", currentRowSet.getString("FCurrency"));
                this.drs.updateString("endDate", param.getEndDate().toString().substring(0, 10));
                if (currentRowSet.getObject("FBillDate") != null) {
                    this.drs.updateString("billDate", currentRowSet.getObject("FBillDate").toString().substring(0, 10));
                } else {
                    this.drs.updateString("billDate", "");
                }
                this.drs.updateString("billNumber", currentRowSet.getString("FBillNum"));
                this.drs.updateString("description", currentRowSet.getString("FDescription"));
                if (currentRowSet.getString("FBillType") != null && OtherBillTypeEnum.getEnumList().toString().contains(currentRowSet.getString("FBillType"))) {
                    this.drs.updateBigDecimal("arAmount", currentRowSet.getBigDecimal("FBalance"));
                    this.drs.updateNull("recAmount");
                    sumArAmount = sumArAmount.add(currentRowSet.getBigDecimal("FBalance"));
                    sumBalanceAmount = sumBalanceAmount.add(currentRowSet.getBigDecimal("FBalance"));
                } else {
                    this.drs.updateNull("arAmount");
                    this.drs.updateBigDecimal("recAmount", currentRowSet.getBigDecimal("FBalance").negate());
                    sumRecAmount = sumRecAmount.add(currentRowSet.getBigDecimal("FBalance").negate());
                    sumBalanceAmount = sumBalanceAmount.subtract(currentRowSet.getBigDecimal("FBalance").negate());
                }
                this.drs.updateBigDecimal("sumArAmount", sumArAmount);
                this.drs.updateBigDecimal("sumRecAmount", sumRecAmount);
                this.drs.updateBigDecimal("balanceAmount", sumBalanceAmount);
                this.drs.insertRow();
            }
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)((CoreUI)null), (Throwable)e1);
        }
    }

    private Map<String, String> getAddrMap(AccountAgeQueryParam param, RptRowSet currentRowSet) throws BOSException {
        HashMap<String, String> addrMap = new HashMap<String, String>();
        EntityViewInfo view = this.getAddrViewInfo(currentRowSet);
        if (view == null) {
            return addrMap;
        }
        if ("t_bd_customer".equalsIgnoreCase(param.getCussAcctTypeInfo().getRealtionDataObject())) {
            return this.getCustomerAddr(view);
        }
        if ("t_bd_supplier".equalsIgnoreCase(param.getCussAcctTypeInfo().getRealtionDataObject())) {
            return this.getSupplierAddr(view);
        }
        return addrMap;
    }

    private Map<String, String> getCustomerAddr(EntityViewInfo view) throws BOSException {
        HashMap<String, String> custAddrMap = new HashMap<String, String>();
        ICustomer iCustomer = CustomerFactory.getRemoteInstance();
        CustomerInfo customerInfo = null;
        CustomerCollection collection = iCustomer.getCustomerCollection(view);
        if (collection != null && collection.size() > 0) {
            int size = collection.size();
            int i = 0;
            while (size-- > 0) {
                if (custAddrMap.containsKey((customerInfo = collection.get(i++)).getNumber())) continue;
                custAddrMap.put(customerInfo.getNumber(), customerInfo.getAddress());
            }
        }
        return custAddrMap;
    }

    private Map<String, String> getSupplierAddr(EntityViewInfo view) throws BOSException {
        HashMap<String, String> supplierAddrMap = new HashMap<String, String>();
        ISupplier iSupplier = SupplierFactory.getRemoteInstance();
        SupplierInfo supplierInfo = null;
        SupplierCollection collection = iSupplier.getSupplierCollection(view);
        if (collection != null && collection.size() > 0) {
            int size = collection.size();
            int i = 0;
            while (size-- > 0) {
                if (supplierAddrMap.containsKey((supplierInfo = collection.get(i++)).getNumber())) continue;
                supplierAddrMap.put(supplierInfo.getNumber(), supplierInfo.getAddress());
            }
        }
        return supplierAddrMap;
    }

    private EntityViewInfo getAddrViewInfo(RptRowSet currentRowSet) {
        HashSet<String> asstActNumberSet = new HashSet<String>();
        currentRowSet.reset();
        String asstActNumber = null;
        while (currentRowSet.next()) {
            asstActNumber = currentRowSet.getString("FAsstActNumber");
            if (asstActNumber == null) continue;
            asstActNumberSet.add(asstActNumber);
        }
        if (asstActNumberSet.isEmpty()) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", asstActNumberSet, CompareType.INCLUDE));
        view.setFilter(filter);
        return view;
    }

    public IRowSet getData(R1PrintDataSource dataSource) throws Exception {
        if (dataSource.getAssociateParameter() == null) {
            DynamicRowSet rowSet = this.drs;
            rowSet.beforeFirst();
            return rowSet;
        }
        return super.getData(dataSource);
    }

    public DynamicRowSet getDynamicRowSet() {
        return this.drs;
    }
}

