/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ar.AccountAgeQueryParam;
import com.kingdee.eas.fi.ar.ArVirtualAgingRptFacadeFactory;
import com.kingdee.eas.fi.ar.client.AbstractArVirtualAgingRptUI;
import com.kingdee.eas.fi.ar.client.ArAgingRptExportManager;
import com.kingdee.eas.fi.ar.client.ArVirtualAgingItemRptUI;
import com.kingdee.eas.fi.ar.client.ArVirtualAgingQueryUI;
import com.kingdee.eas.fi.ar.client.ArVirtualAgingRptDataProvider;
import com.kingdee.eas.fi.ar.client.ReportLinkHelper;
import com.kingdee.eas.fi.arap.client.ArApAgingTimeSettingUI;
import com.kingdee.eas.fi.arap.client.util.AgingRptTablePrintUtil;
import com.kingdee.eas.fi.arap.client.util.ArApReportUIUtil;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.IVirtualRptBaseFacade;
import com.kingdee.eas.framework.report.SimpleCompanyUserObject;
import com.kingdee.eas.framework.report.util.DefaultKDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.util.ObjectUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ArVirtualAgingRptUI
extends AbstractArVirtualAgingRptUI {
    private static final Logger logger = CoreUIObject.getLogger(ArVirtualAgingRptUI.class);
    private boolean isGroupByCom = false;
    private String currencyID = null;
    private Set columnSet = new HashSet();
    private ArAgingRptExportManager exportManager;

    public ArVirtualAgingRptUI() throws Exception {
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getDataRequestManager().setExportPageRowCount(500);
        this.enableExportExcel(this.tblMain);
        this.actionJoinQuery.setEnabled(true);
        this.actionJoinQuery.setVisible(true);
        this.exportManager = new ArAgingRptExportManager(this.tblMain);
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return ArVirtualAgingRptFacadeFactory.getRemoteInstance();
    }

    protected IVirtualRptBaseFacade getVirtualRemoteInstance() throws BOSException {
        return ArVirtualAgingRptFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTable() {
        return this.tblMain;
    }

    protected KDTable getTableForOA() {
        return this.getTable();
    }

    protected KDTable getTableForPrintSetting() {
        return this.getTable();
    }

    protected CustomerQueryPanel[] getCustomerQueryPanels() throws Exception {
        CustomerQueryPanel[] panels = new CustomerQueryPanel[]{new ArVirtualAgingQueryUI(), new ArApAgingTimeSettingUI()};
        return panels;
    }

    protected Dimension getQueryDialogSize(CustomerQueryPanel[] userPanels) {
        return new Dimension(595, 338);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    @Override
    protected String getPrintPermItem() {
        return "fi_arap_ArAgesReport_Print";
    }

    @Override
    protected List getQueryCompanys() {
        AccountAgeQueryParam param = (AccountAgeQueryParam)((Object)this.params.getObject("qryParam"));
        if (param != null) {
            return param.getCompanyIds();
        }
        return null;
    }

    @Override
    public void actionJoinQuery_actionPerformed(ActionEvent e) throws Exception {
        AccountAgeQueryParam param = (AccountAgeQueryParam)((Object)this.params.getObject("qryParam"));
        if (param.getAnalyseObjIndex() == 0) {
            this.actionAsstActJoinQuery(null);
            return;
        }
        String billId = ArApReportUIUtil.getSelectedId(this.tblMain, "fbillid");
        if (billId == null || billId.length() == 0) {
            return;
        }
        ReportLinkHelper.showBillUI((IUIObject)this, billId);
    }

    public void tblDoubleClicked(int row, int column, int x, int y) {
        AccountAgeQueryParam param = (AccountAgeQueryParam)((Object)this.params.getObject("qryParam"));
        StringBuilder logBuilder = new StringBuilder();
        try {
            if (param.getAnalyseObjIndex() == 0) {
                this.actionAsstActJoinQuery(null);
                logBuilder.append("analyseObjIndex: 0 ,View AsstAct");
            } else if (param.getAnalyseObjIndex() == 1) {
                this.actionJoinQuery_actionPerformed(null);
                logBuilder.append("analyseObjIndex: 1, View bill");
            }
        }
        catch (Exception e) {
            logger.error((Object)logBuilder.toString(), (Throwable)e);
            this.handUIException(e);
        }
    }

    public void actionAsstActJoinQuery(ActionEvent e) throws Exception {
        String asstActId = ArApReportUIUtil.getSelectedId(this.tblMain, "fasstactid");
        if (asstActId == null) {
            return;
        }
        String asstActNumber = ArApReportUIUtil.getSelectedId(this.tblMain, "fasstactnumber");
        String asstActName = ArApReportUIUtil.getSelectedId(this.tblMain, "fcussacct");
        AccountAgeQueryParam param = (AccountAgeQueryParam)((Object)this.params.getObject("qryParam"));
        AccountAgeQueryParam copyParam = (AccountAgeQueryParam)((Object)param.clone());
        copyParam.setAnalyseObjIndex(1);
        if (param.isQueryComps()) {
            String companyId = ArApReportUIUtil.getSelectedId(this.tblMain, "fcompanyid");
            copyParam.setCompanyId(companyId);
            ArrayList<String> companyArray = new ArrayList<String>();
            companyArray.add(companyId);
            copyParam.setCompanyIds(companyArray);
        }
        String currencyId = ArApReportUIUtil.getSelectedId(this.tblMain, "fcurrencyid");
        copyParam.setCurrencyId(currencyId);
        if (param.getGroupTypeIndex() == 2) {
            copyParam.setAdminOrgId(ArApReportUIUtil.getSelectedId(this.tblMain, "fadminorgid"));
            copyParam.setAdminOrgNum(ArApReportUIUtil.getSelectedId(this.tblMain, "fadminorgnumber"));
            copyParam.setAdminOrgName(ArApReportUIUtil.getSelectedId(this.tblMain, "fadminorgname"));
        }
        copyParam.setCussAcctFromId(asstActId);
        copyParam.setCussAcctFromName(asstActName);
        copyParam.setCussAcctFromNum(asstActNumber);
        copyParam.setCussAcctToId(asstActId);
        copyParam.setCussAcctToName(asstActName);
        copyParam.setCussAcctToNum(asstActNumber);
        copyParam.setBoolean("isJoinQuery", true);
        UIContext uiContext = new UIContext((Object)this);
        RptParams newParams = new RptParams();
        newParams.setObject("qryParam", (Object)copyParam);
        AccountAgeQueryParam timingParam = (AccountAgeQueryParam)((Object)this.params.getObject("qryParam-timeSetting"));
        newParams.setObject("qryParam-timeSetting", (Object)timingParam);
        uiContext.put((Object)"RPTFilter", (Object)newParams);
        IUIWindow itemRptUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(ArVirtualAgingItemRptUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        itemRptUI.show();
    }

    public Object getTablePreferenceSchemaKey() {
        AccountAgeQueryParam param = (AccountAgeQueryParam)((Object)this.params.getObject("qryParam"));
        return param.getRptPreferenceSchemaKey();
    }

    public RptParams findData(int rowIndex, SimpleCompanyUserObject companyUserObject) throws Exception {
        AccountAgeQueryParam param = (AccountAgeQueryParam)((Object)this.params.getObject("qryParam"));
        RptParams pp = new RptParams();
        IRow row = this.getTable().getRow(rowIndex);
        if (this.isGroupByCom) {
            pp.setString("SubCompanyId", row.getCell("fcompanyid").getValue().toString());
        } else {
            pp.setString("AsstActId", row.getCell("fasstactid").getValue().toString());
        }
        pp.setBoolean("isBaseCurrency", param.isBaseCurrency());
        pp.setBoolean("hasLocAmt", param.hasLocAmt());
        if (!param.isBaseCurrency()) {
            pp.setString("FCurrencyId", row.getCell("fcurrencyid").getValue().toString());
        }
        if (param.isBaseCurrency() || param.hasLocAmt()) {
            pp.setString("FBaseCurrencyId", row.getCell("fbasecurrencyid").getValue().toString());
        }
        pp.setString("fparentid", companyUserObject.getCompanyId());
        pp.setBoolean("isByBill", param.getAnalyseObjIndex() == 1);
        pp.setString("tempTable", this.getTempTable());
        pp.setBoolean("isGroupByCom", this.isGroupByCom);
        pp.setInt("groupTypeIndex", param.getGroupTypeIndex());
        return this.getVirtualRemoteInstance().findData(pp, 0, -1, this.getTempTable(), (Object)companyUserObject);
    }

    protected void query() {
        this.fFirstLoad = true;
        this.insertRowCount = 0;
        AccountAgeQueryParam param = (AccountAgeQueryParam)((Object)this.params.getObject("qryParam"));
        param.setTotalRowCount(0);
        this.tblMain.removeColumns();
        try {
            this.tblMain.removeRows();
            super.query();
        }
        catch (Exception e) {
            logger.error((Object)"agingRpt query", (Throwable)e);
        }
    }

    public void getData(KDTDataRequestEvent e) {
        int start = e.getFirstRow();
        int length = e.getLastRow() - start + 1;
        this.tblMain.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
        try {
            AccountAgeQueryParam param = (AccountAgeQueryParam)((Object)this.params.getObject("qryParam"));
            if ("base".equals(param.getCurrencyId())) {
                param.setBaseCurrency(true);
            }
            IVirtualRptBaseFacade iRpt = this.getVirtualRemoteInstance();
            if (this.fFirstLoad) {
                RptParams rptRslt = null;
                if (!this.exportManager.isFirstLoad()) {
                    rptRslt = iRpt.createTempTable(this.params);
                    this.exportManager.setInitRptParams((RptParams)ObjectUtils.createCopy((Object)rptRslt));
                } else {
                    rptRslt = this.exportManager.getInitRptParams();
                    this.exportManager.finishFirstLoad();
                }
                String tmpTable = rptRslt.getString("tempTable");
                param.setTempTable(tmpTable);
                this.setTempTable(tmpTable);
                this.isGroupByCom = param.getGroupTypeIndex() == 1 || param.getGroupTypeIndex() == 2;
                this.initTableHeader(rptRslt);
                this.params.setBoolean("fFirstLoad", true);
                rptRslt = iRpt.query(this.params, start, length);
                if (rptRslt == null) {
                    return;
                }
                this.currencyID = null;
                this.columnSet.clear();
                RptRowSet rs = (RptRowSet)rptRslt.getObject("rowset");
                this.tblMain.setRowCount(rptRslt.getInt("totalRowCount"));
                param.setTotalRowCount(rptRslt.getInt("totalRowCount"));
                this.isDoExpand = true;
                this.insertRows(rs, start, this.tblMain, true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), 0);
                this.tHelper.setDefaultUserData(null);
                this.initUserConfig();
                this.tblMain.gerGroupManager().group();
                this.isDoExpand = true;
                this.fFirstLoad = false;
                if (param.isQueryComps()) {
                    this.tblMain.getGroupManager().setGroup(false);
                    this.innerStart = this.tblMain.getDataRequestManager().getPageRowCount();
                    this.innerLength = this.innerStart + this.tblMain.getDataRequestManager().getPageRowCount() > param.getTotalRowCount() ? param.getTotalRowCount() - this.innerStart : this.tblMain.getDataRequestManager().getPageRowCount();
                }
            } else {
                this.params.setBoolean("fFirstLoad", false);
                if (param.isQueryComps()) {
                    RptParams rpt = iRpt.query(this.params, this.innerStart, this.innerStart + this.innerLength);
                    RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
                    this.isDoExpand = false;
                    this.insertRows(rs, this.innerStart, this.tblMain, true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), this.insertRowCount);
                    this.isDoExpand = true;
                    this.innerStart += this.tblMain.getDataRequestManager().getPageRowCount();
                    this.innerLength = this.innerStart + this.tblMain.getDataRequestManager().getPageRowCount() > param.getTotalRowCount() ? param.getTotalRowCount() - this.innerStart : this.tblMain.getDataRequestManager().getPageRowCount();
                } else {
                    RptParams rpt = iRpt.query(this.params, start, length);
                    RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
                    this.isDoExpand = false;
                    this.insertRows(rs, start, this.tblMain, true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), this.insertRowCount);
                    this.isDoExpand = true;
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"ui loadRpt", (Throwable)ex);
            this.processException(ex);
        }
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
    }

    public String[] getMergeColumnKeys() {
        boolean hasLocAmt = false;
        boolean isBaseCurrency = false;
        if (null != this.params) {
            AccountAgeQueryParam param = (AccountAgeQueryParam)((Object)this.params.getObject("qryParam"));
            hasLocAmt = param.hasLocAmt();
            isBaseCurrency = param.isBaseCurrency();
        }
        ArrayList<String> cols = new ArrayList<String>();
        if (!isBaseCurrency) {
            cols.add("fcurrency");
        }
        if (isBaseCurrency || hasLocAmt) {
            cols.add("fbasecurrency");
        }
        if (!this.isGroupByCom) {
            cols.add("fasstactnumber");
            cols.add("fcussacct");
        } else {
            cols.add("fadminorgnumber");
            cols.add("fadminorgname");
        }
        return cols.toArray(new String[0]);
    }

    public void insertRows(RptRowSet rs, int insertRowIndex, KDTable table, boolean refreshUI, KDTableInsertHandler handler, int insertRowCount) {
        String[] mergeCols;
        if (rs.getRowCount() == 0) {
            return;
        }
        int currPrecision = 2;
        int baseCurrPrecision = 2;
        AccountAgeQueryParam param = (AccountAgeQueryParam)((Object)this.params.getObject("qryParam"));
        boolean hasLocAmt = param.hasLocAmt();
        boolean isBaseCurrency = param.isBaseCurrency();
        String suffix_baseCurrency = "bsc";
        int rowIndex = insertRowIndex + insertRowCount;
        int cols = table.getColumnCount();
        SimpleCompanyUserObject companyUserObject = null;
        this.tblMain.setRefresh(false);
        int count = 0;
        while (rs.next()) {
            int rowType = rs.getInt("FIsSum");
            this.currencyID = !isBaseCurrency ? rs.getString("FCurrencyID") : rs.getString("FBaseCurrencyId");
            IRow row = this.isDoExpand ? table.addRow(rowIndex++) : table.setRow(rowIndex++);
            if (!isBaseCurrency) {
                currPrecision = rs.getInt("fcurrprecision");
            }
            if (isBaseCurrency || hasLocAmt) {
                baseCurrPrecision = rs.getInt("FBaseCurrPrecision");
            }
            String str = PrecisionFormatUtils.getFormatString(currPrecision);
            String baseStr = PrecisionFormatUtils.getFormatString(baseCurrPrecision);
            for (int i = 0; i < cols; ++i) {
                String key = this.tblMain.getColumn(i).getKey();
                Object cellVal = rs.getObject(key);
                if (key.equals("fbilldate") && cellVal != null) {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                    cellVal = df.format(cellVal);
                }
                if (cellVal instanceof BigDecimal) {
                    BigDecimal amt = (BigDecimal)cellVal;
                    String fmt = key.endsWith(suffix_baseCurrency) ? baseStr : str;
                    row.getCell(i).getStyleAttributes().setNumberFormat(fmt);
                    if (amt.signum() != 0) {
                        this.columnSet.add(this.currencyID + key);
                    }
                    if (amt.signum() == 0 && (rowType != 1 || rowType == 1 && !this.columnSet.contains(this.currencyID + key))) {
                        row.getCell(i).setValue(null);
                        continue;
                    }
                    row.getCell(i).setValue((Object)amt);
                    continue;
                }
                row.getCell(i).setValue(cellVal);
            }
            if (rowType == 1) {
                row.getStyleAttributes().setBackground(Color.decode("#F5F5E6"));
                this.setCurrencyBgColor(row, isBaseCurrency, hasLocAmt);
            }
            if (this.isGroupByCom) {
                if (rs.getInt("FComplevel") == 1) {
                    row.getStyleAttributes().setBackground(Color.decode("#F6F6BF"));
                    this.setCurrencyBgColor(row, isBaseCurrency, hasLocAmt);
                }
                if (rs.getInt("FIsCompLeaf") == 0 && rs.getInt("FComplevel") >= 2) {
                    row.getStyleAttributes().setBackground(Color.decode("#E8E4CB"));
                    this.setCurrencyBgColor(row, isBaseCurrency, hasLocAmt);
                }
            }
            ICell cell = row.getCell(this.getTreeCol());
            companyUserObject = this.getCompanyUserObject(rs);
            if (cell != null && companyUserObject != null) {
                cell.setValue((Object)companyUserObject);
                cell.setUserObject((Object)companyUserObject);
            }
            ++count;
        }
        if (!this.fFirstLoad && !this.exportManager.isExportStarted() && ((AccountAgeQueryParam)((Object)this.params.getObject("qryParam"))).isQueryComps() && (mergeCols = this.getMergeColumnKeys()) != null) {
            int len = mergeCols.length;
            for (int i = 0; i < len; ++i) {
                if (i == 0) {
                    this.mergeBlock(insertRowIndex + insertRowCount, null, mergeCols[i]);
                    continue;
                }
                this.mergeBlock(insertRowIndex + insertRowCount, mergeCols[i - 1], mergeCols[i]);
            }
        }
        this.tblMain.setRefresh(true);
        if (count > 0) {
            table.reLayoutAndPaint();
        } else {
            table.repaint();
        }
        this.setCellTreeRenderer();
    }

    private SimpleCompanyUserObject getCompanyUserObject(RptRowSet rs) {
        SimpleCompanyUserObject companyUserObject = null;
        String companyId = rs.getString("fcompanyid");
        int isSum = rs.getInt("FIsSum");
        companyUserObject = new SimpleCompanyUserObject();
        companyUserObject.setCompanyId(companyId == null ? "null" : companyId);
        companyUserObject.setName(rs.getString("fcompany"));
        companyUserObject.setLongNumber(rs.getString("fCompLongNumber"));
        companyUserObject.setExpanded(isSum != 0);
        if (isSum != 0) {
            companyUserObject.setHasExpanded(true);
        }
        AccountAgeQueryParam param = (AccountAgeQueryParam)((Object)this.params.getObject("qryParam"));
        String blockId = null;
        blockId = this.isGroupByCom ? (param.isBaseCurrency() ? rs.getString("FBaseCurrencyId") : rs.getString("FCurrencyId")) : rs.getString("FAsstActId");
        companyUserObject.setBlockId(blockId);
        if (companyId == null || rs.getInt("fissum") == 1 && !this.isGroupByCom) {
            companyUserObject.setLeaf(true);
            companyUserObject.setisIconEmpty(true);
        } else {
            int leaf = rs.getInt("FIsCompLeaf");
            companyUserObject.setLeaf(leaf == 1);
            companyUserObject.setLevel(rs.getInt("fcomplevel"));
        }
        return companyUserObject;
    }

    public String getTreeCol() {
        AccountAgeQueryParam param = (AccountAgeQueryParam)((Object)this.params.getObject("qryParam"));
        return param.isQueryComps() ? "fcompany" : "fcompanyid";
    }

    protected void preparePrintPageHeader(HeadFootModel headerModel) {
        AccountAgeQueryParam param = (AccountAgeQueryParam)((Object)this.params.getObject("qryParam"));
        AgingRptTablePrintUtil.preparePrintPageHeader(headerModel, param);
    }

    protected Map preparePrintVariantMap() {
        AccountAgeQueryParam param = (AccountAgeQueryParam)((Object)this.params.getObject("qryParam"));
        return AgingRptTablePrintUtil.preparePrintVarMap(param);
    }

    public boolean isAsynchronism() {
        return true;
    }

    protected String getUIFullName() {
        return "com.kingdee.eas.fi.ar.client.ArVirtualAgingRptUI";
    }

    @Override
    protected void prepareParamForQuery(QueryPanelCollection queryPanelInfo) throws Exception {
        CustomerQueryPanel[] panels = this.getCustomerQueryPanels();
        panels[0].setCustomerParams(CustomerParams.getCustomerParams2((String)queryPanelInfo.get(0).getCustomerParams()));
        panels[1].setCustomerParams(CustomerParams.getCustomerParams2((String)queryPanelInfo.get(1).getCustomerParams()));
        this.params = new RptParams();
        this.params.setObject("qryParam", (Object)((ArVirtualAgingQueryUI)panels[0]).getAccountAgeQueryParam());
        this.params.setObject("qryParam-timeSetting", (Object)((ArApAgingTimeSettingUI)panels[1]).getAccountAgeQueryParam());
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.print(e, true);
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.print(e, false);
    }

    private void print(ActionEvent e, boolean isPrint) throws Exception {
        ArApReportUIUtil.checkCompanysPrintPermission((CoreUI)this, this.getQueryCompanys(), this.getPrintPermItem(), this.getMainBizOrgType());
        AccountAgeQueryParam param = (AccountAgeQueryParam)((Object)this.params.getObject("qryParam"));
        if (isPrint) {
            super.actionPrint_actionPerformed(e);
        } else {
            super.actionPrintPreview_actionPerformed(e);
        }
    }

    protected void invokePrintFunction(boolean isPrint, ActionEvent e) throws Exception {
        ArVirtualAgingRptDataProvider data = new ArVirtualAgingRptDataProvider();
        RptRowSet rs = this.getCurrentPrintData();
        data.insertDataToDynamicRowSet(this.params, rs);
        if (this.getTDFileName() == null) {
            return;
        }
        KDNoteHelper appHlp = new KDNoteHelper();
        if (isPrint) {
            appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    private RptRowSet getCurrentPrintData() {
        int len = 0;
        AccountAgeQueryParam param = (AccountAgeQueryParam)((Object)this.params.getObject("qryParam"));
        try {
            IVirtualRptBaseFacade iRpt = this.getVirtualRemoteInstance();
            RptParams rptRslt = iRpt.createTempTable(this.params);
            String tmpTable = rptRslt.getString("tempTable");
            len = rptRslt.getInt("verticalCount");
            param.setTempTable(tmpTable);
            this.setTempTable(tmpTable);
            this.params.setBoolean("fFirstLoad", true);
            rptRslt = iRpt.query(this.params, 0, len);
            if (rptRslt == null) {
                return new RptRowSet();
            }
            RptRowSet rs = (RptRowSet)rptRslt.getObject("rowset");
            return rs;
        }
        catch (Exception ex) {
            this.handleException(ex);
            return new RptRowSet();
        }
    }

    protected String getTDFileName() {
        return "/FI/AR/ArVirtualAgingRpt";
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        this.exportManager.startExport();
        super.actionExport_actionPerformed(e);
        this.fFirstLoad = true;
        this.exportManager.stopExport();
    }
}

