/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.fi.ar.ArApCommonException;
import com.kingdee.eas.fi.ar.ArrearageCompareQueryParam;
import com.kingdee.eas.fi.ar.ArrearageQueryParam;
import com.kingdee.eas.fi.ar.ArrearageStructQueryParam;
import com.kingdee.eas.fi.ar.ArrearageTrendQueryParam;
import com.kingdee.eas.fi.ar.IReportQueryParam;
import com.kingdee.eas.fi.ar.client.AbstractArrearageRptQueryUI;
import com.kingdee.eas.fi.ar.client.util.ArPeriodHelper;
import com.kingdee.eas.fi.arap.util.paramconvertor.IRptParamConvertor;
import com.kingdee.eas.fi.arap.util.paramconvertor.RptParamConvertorFactory;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class ArrearageRptQueryUI
extends AbstractArrearageRptQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(ArrearageRptQueryUI.class);
    private PeriodInfo currPeriod = null;
    private ArPeriodHelper periodHelper = null;
    private ArrearageQueryParam filterParam = null;
    private ItemListener chkIsCentralBalanceListener = null;

    @Override
    protected void initUICtrls() throws Exception {
        super.initUICtrls();
        this.currPeriod = this.arApSysParamInfo.getCurrentPeriod(SystemEnum.ACCOUNTSRECEIVABLE);
        if (this.currPeriod == null) {
            throw new ArApCommonException(ArApCommonException.STARTPERIOD_NULL);
        }
        this.periodHelper = ArPeriodHelper.getInstance(false);
        this.periodHelper.initPeriodSpinner(this.currentCompany, this.spFromPeriodYear, this.spFromPeriodNum, this.spToPeriodYear, this.spToPeriodNum, this.arApSysParamInfo);
        this.periodHelper.initPeriodSpinner(this.currentCompany, this.spBasePeriodYear, this.spBasePeriodNum, this.arApSysParamInfo);
        this.rdBtnStruct.setSelected(true);
        this.removeControlListener();
        this.addListen();
    }

    private void removeControlListener() {
        if (null != this.chkIsCentralBalanceListener) {
            this.bizcheckBox.removeItemListener(this.chkIsCentralBalanceListener);
        }
    }

    private void addListen() {
        this.chkIsCentralBalanceListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                try {
                    ArrearageRptQueryUI.this.chkIsCentralBalanceChanged(arg0);
                }
                catch (Exception e) {
                    ArrearageRptQueryUI.this.handUIException(e);
                }
            }
        };
        this.bizcheckBox.addItemListener(this.chkIsCentralBalanceListener);
    }

    protected void chkIsCentralBalanceChanged(ItemEvent arg0) throws Exception {
        boolean ischeckBox = this.bizcheckBox.isSelected();
        if (ischeckBox) {
            this.contPaymentType.setEnabled(true);
        } else {
            this.contPaymentType.setEnabled(false);
        }
    }

    @Override
    protected void rdBtnCompare_itemStateChanged(ItemEvent e) throws Exception {
        this.periodHelper.initPeriodSpinner(this.currentCompany, this.spFromPeriodYear, this.spFromPeriodNum, this.spToPeriodYear, this.spToPeriodNum, this.arApSysParamInfo);
        this.periodHelper.initPeriodSpinner(this.currentCompany, this.spBasePeriodYear, this.spBasePeriodNum, this.arApSysParamInfo);
        this.enableBasePeriod(true);
    }

    @Override
    protected void rdBtnStruct_itemStateChanged(ItemEvent e) throws Exception {
        this.periodHelper.initPeriodSpinner(this.currentCompany, this.spFromPeriodYear, this.spFromPeriodNum, this.spToPeriodYear, this.spToPeriodNum, this.arApSysParamInfo);
        this.periodHelper.initPeriodSpinner(this.currentCompany, this.spBasePeriodYear, this.spBasePeriodNum, this.arApSysParamInfo);
        this.enableBasePeriod(true);
    }

    @Override
    protected void rdBtnTrend_itemStateChanged(ItemEvent e) throws Exception {
        this.periodHelper.initPeriodSpinner(this.currentCompany, this.spFromPeriodYear, this.spFromPeriodNum, this.spToPeriodYear, this.spToPeriodNum, this.arApSysParamInfo);
        this.periodHelper.initPeriodSpinner(this.currentCompany, this.spBasePeriodYear, this.spBasePeriodNum, this.arApSysParamInfo);
        this.enableBasePeriod(false);
    }

    private void enableBasePeriod(boolean fEnableBasePeriod) {
        this.spBasePeriodYear.setEnabled(fEnableBasePeriod);
        this.spBasePeriodNum.setEnabled(fEnableBasePeriod);
        this.spFromPeriodYear.setEnabled(!fEnableBasePeriod);
        this.spFromPeriodNum.setEnabled(!fEnableBasePeriod);
        this.spToPeriodYear.setEnabled(!fEnableBasePeriod);
        this.spToPeriodNum.setEnabled(!fEnableBasePeriod);
    }

    @Override
    protected void spFromPeriodNum_stateChanged(ChangeEvent e) throws Exception {
        this.periodHelper.periodChange(this.spFromPeriodYear, this.spFromPeriodNum, this.spToPeriodYear, this.spToPeriodNum, true);
    }

    @Override
    protected void spFromPeriodYear_stateChanged(ChangeEvent e) throws Exception {
        this.periodHelper.periodChange(this.spFromPeriodYear, this.spFromPeriodNum, this.spToPeriodYear, this.spToPeriodNum, false);
        this.periodHelper.setPeriodNum(this.currentCompany, this.spFromPeriodNum, this.spFromPeriodYear);
    }

    @Override
    protected void spToPeriodNum_stateChanged(ChangeEvent e) throws Exception {
        this.periodHelper.periodChange(this.spFromPeriodYear, this.spFromPeriodNum, this.spToPeriodYear, this.spToPeriodNum, true);
    }

    @Override
    protected void spToPeriodYear_stateChanged(ChangeEvent e) throws Exception {
        this.periodHelper.periodChange(this.spFromPeriodYear, this.spFromPeriodNum, this.spToPeriodYear, this.spToPeriodNum, false);
        this.periodHelper.setPeriodNum(this.currentCompany, this.spToPeriodNum, this.spToPeriodYear);
    }

    @Override
    protected void spBasePeriodNum_stateChanged(ChangeEvent e) throws Exception {
        super.spBasePeriodNum_stateChanged(e);
    }

    @Override
    protected void spBasePeriodYear_stateChanged(ChangeEvent e) throws Exception {
        this.periodHelper.setPeriodNum(this.currentCompany, this.spBasePeriodNum, this.spBasePeriodYear);
    }

    public boolean verify() {
        AsstActTypeInfo typeInfo = (AsstActTypeInfo)this.comboCussType.getSelectedItem();
        if (typeInfo == null || StringUtils.isEmpty((String)typeInfo.getRealtionDataObject()) || StringUtils.isEmpty((String)typeInfo.getDefaultQueryName())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"NoAsstActType"));
            return false;
        }
        if (this.rdBtnCompare.isSelected()) {
            int basePeriodYear = this.spBasePeriodYear.getIntegerVlaue();
            int basePeriodNum = this.spBasePeriodNum.getIntegerVlaue();
            if (basePeriodYear == this.currPeriod.getPeriodYear() && basePeriodNum == this.currPeriod.getPeriodNumber()) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"BasePeriodCannotBeCurrPeriod"));
                return false;
            }
        }
        return true;
    }

    @Override
    public void clear() {
        super.clear();
        this.rdBtnStruct.setEnabled(true);
        Integer currYear = new Integer(this.currPeriod.getPeriodYear());
        Integer currNum = new Integer(this.currPeriod.getPeriodNumber());
        this.spFromPeriodYear.setValue((Object)currYear);
        this.spFromPeriodNum.setValue((Object)currNum);
        this.spToPeriodYear.setValue((Object)currYear);
        this.spToPeriodNum.setValue((Object)currNum);
        this.chkIncludeBizBill.setSelected(false);
        this.rdBtnStruct.setSelected(true, true);
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.setParamToUI();
    }

    public void setParam(Object obj) {
        this.filterParam = (ArrearageQueryParam)((Object)obj);
        this.setParamToUI();
    }

    public void setCustomerParams(CustomerParams cp) {
        int iType = cp.getInt("rptType");
        if (iType == 0) {
            this.filterParam = new ArrearageCompareQueryParam();
        } else if (iType == 1) {
            this.filterParam = new ArrearageStructQueryParam();
        } else if (iType == 2) {
            this.filterParam = new ArrearageTrendQueryParam();
        }
        IRptParamConvertor convertor = RptParamConvertorFactory.getConvertor((IReportQueryParam)this.filterParam);
        try {
            convertor.read(null, cp);
        }
        catch (Exception e) {
            logger.error((Object)"exception: parse the customerParams ", (Throwable)e);
        }
    }

    @Override
    public IReportQueryParam getRptParam() {
        ArrearageQueryParam param = null;
        if (this.rdBtnStruct.isSelected()) {
            param = this.getStructParam();
        } else if (this.rdBtnCompare.isSelected()) {
            param = this.getCompareParam();
        } else if (this.rdBtnTrend.isSelected()) {
            param = this.getTrendParam();
        }
        if (param != null) {
            param.setCompanyId(this.currentCompany.getId().toString());
            param.setCuId(this.currentCompany.getCU().getId().toString());
            param.setIncludeBizBill(this.chkIncludeBizBill.isSelected());
            param.setBizeIndex(this.comboPaymentType.getSelectedIndex());
            param.setBizeCheckBox(this.bizcheckBox.isSelected());
            this.setCurrCussAcct2RptParam(param);
        }
        return param;
    }

    private ArrearageTrendQueryParam getTrendParam() {
        ArrearageTrendQueryParam tParam = new ArrearageTrendQueryParam();
        int fromYear = this.spFromPeriodYear.getIntegerVlaue();
        int fromNum = this.spFromPeriodNum.getIntegerVlaue();
        int toYear = this.spToPeriodYear.getIntegerVlaue();
        int toNum = this.spToPeriodNum.getIntegerVlaue();
        tParam.setFromPeriodYear(fromYear);
        tParam.setFromPeriodNum(fromNum);
        tParam.setToPeriodYear(toYear);
        tParam.setToPeriodNum(toNum);
        try {
            PeriodCollection periods;
            PeriodInfo fromPeriod = this.periodHelper.getPeriodInfo(fromYear, fromNum, this.currentCompany);
            PeriodInfo toPeriod = this.periodHelper.getPeriodInfo(toYear, toNum, this.currentCompany);
            if (fromPeriod != null) {
                tParam.setBeginDate(fromPeriod.getBeginDate());
            }
            if (toPeriod != null) {
                tParam.setEndDate(toPeriod.getEndDate());
            }
            if ((periods = this.periodHelper.getPeriods(fromYear, fromNum, toYear, toNum, this.currentCompany)) != null && periods.size() > 0) {
                ArrayList<String> descList = new ArrayList<String>(periods.size());
                PeriodInfo periodInfo = null;
                int n = periods.size();
                for (int i = 0; i < n; ++i) {
                    periodInfo = periods.get(i);
                    descList.add(periodInfo.getPeriodYear() + "_" + periodInfo.getPeriodNumber());
                }
                tParam.setPeriodDescList(descList);
            }
        }
        catch (Exception e) {
            logger.error((Object)"get period from cache:PeriodHelper", (Throwable)e);
            this.handUIException(e);
        }
        return tParam;
    }

    private ArrearageCompareQueryParam getCompareParam() {
        ArrearageCompareQueryParam cpParam = new ArrearageCompareQueryParam();
        int baseYear = this.spBasePeriodYear.getIntegerVlaue();
        int baseNum = this.spBasePeriodNum.getIntegerVlaue();
        cpParam.setBasePeriodYear(baseYear);
        cpParam.setBasePeriodNum(baseNum);
        cpParam.setCurrPeriodYear(this.currPeriod.getPeriodYear());
        cpParam.setCurrPeriodNum(this.currPeriod.getPeriodNumber());
        try {
            PeriodInfo basePeriod = this.periodHelper.getPeriodInfo(baseYear, baseNum, this.currentCompany);
            if (basePeriod != null) {
                cpParam.setBasePeriodId(basePeriod.getId());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"cannot get the period from periodHelper's cache", (Throwable)ex);
            this.handUIException(ex);
        }
        return cpParam;
    }

    private ArrearageStructQueryParam getStructParam() {
        ArrearageStructQueryParam stParam = new ArrearageStructQueryParam();
        int baseYear = this.spBasePeriodYear.getIntegerVlaue();
        int baseNum = this.spBasePeriodNum.getIntegerVlaue();
        stParam.setFromPeriodYear(baseYear);
        stParam.setFromPeriodNum(baseNum);
        stParam.setToPeriodYear(baseYear);
        stParam.setToPeriodNum(baseNum);
        try {
            PeriodInfo toPeriod;
            PeriodInfo fromPeriod = this.periodHelper.getPeriodInfo(baseYear, baseNum, this.currentCompany);
            if (fromPeriod != null) {
                stParam.setBeginDate(fromPeriod.getBeginDate());
            }
            if ((toPeriod = this.periodHelper.getPeriodInfo(baseYear, baseNum, this.currentCompany)) != null) {
                stParam.setEndDate(toPeriod.getEndDate());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"cannot get the period from periodHelper's cache", (Throwable)ex);
            this.handUIException(ex);
        }
        return stParam;
    }

    private void setParamToUI() {
        this.loadCurrCussAcctData(this.filterParam);
        switch (this.filterParam.analyseMethod()) {
            case 0: {
                this.setCompareParamToUI((ArrearageCompareQueryParam)this.filterParam);
                break;
            }
            case 1: {
                this.setStructParamToUI((ArrearageStructQueryParam)this.filterParam);
                break;
            }
            case 2: {
                this.setTrendParamToUI((ArrearageTrendQueryParam)this.filterParam);
            }
        }
        this.chkIncludeBizBill.setSelected(this.filterParam.isIncludeBizBill());
    }

    private void setTrendParamToUI(ArrearageTrendQueryParam param) {
        this.rdBtnTrend.setSelected(true);
        this.spFromPeriodYear.setValue((Object)new Integer(param.getFromPeriodYear()));
        this.spFromPeriodNum.setValue((Object)new Integer(param.getFromPeriodNum()));
        this.spToPeriodYear.setValue((Object)new Integer(param.getToPeriodYear()));
        this.spToPeriodNum.setValue((Object)new Integer(param.getToPeriodNum()));
    }

    private void setCompareParamToUI(ArrearageCompareQueryParam param) {
        this.rdBtnCompare.setSelected(true);
        this.spBasePeriodYear.setValue((Object)new Integer(param.getBasePeriodYear()));
        this.spBasePeriodNum.setValue((Object)new Integer(param.getBasePeriodNum()));
    }

    private void setStructParamToUI(ArrearageStructQueryParam param) {
        this.rdBtnStruct.setSelected(true);
        this.spFromPeriodYear.setValue((Object)new Integer(param.getFromPeriodYear()));
        this.spFromPeriodNum.setValue((Object)new Integer(param.getFromPeriodNum()));
        this.spToPeriodYear.setValue((Object)new Integer(param.getToPeriodYear()));
        this.spToPeriodNum.setValue((Object)new Integer(param.getToPeriodNum()));
    }
}

