/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.util.BotRelationUtil;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ar.BadAcctTakeBackFacadeFactory;
import com.kingdee.eas.fi.ar.IBadAcctTakeBackFacade;
import com.kingdee.eas.fi.ar.IVerificationBill;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.VerificationBillFactory;
import com.kingdee.eas.fi.ar.VerificationBillInfo;
import com.kingdee.eas.fi.ar.client.AbstractBadAcctBackListUI;
import com.kingdee.eas.fi.ar.client.BadAcctBackQueryUI;
import com.kingdee.eas.fi.ar.client.BadAcctTakeBackListUI;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.client.util.CommonClientUtils;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.client.util.ArApReportUIUtil;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class BadAcctBackListUI
extends AbstractBadAcctBackListUI {
    private CompanyOrgUnitInfo currentCompany = null;
    private UserInfo defaultUserInfo = null;
    private CommonQueryDialog dialog = null;
    private BadAcctBackQueryUI badAcctBackQueryUI = null;
    private List lockObjs = new ArrayList();
    private PeriodInfo currPeriod = null;
    private PeriodInfo startPeriod = null;
    private LogUtil logUtil = new LogUtil();

    public void onLoad() throws Exception {
        if (this.defaultUserInfo == null) {
            this.defaultUserInfo = SysContext.getSysContext().getCurrentUserInfo();
        }
        this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        ArApReportUIUtil.checkCompany((Component)((Object)this), this.currentCompany);
        this.currPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)this.currentCompany);
        this.setMainTableConfig();
        Object id = this.getUIContext().get("ID");
        Object strModule = this.getUIContext().get("Module");
        if (strModule != null && id != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)id.toString()));
            view.setFilter(filter);
            this.mainQuery = view;
            this.refreshList();
        }
        super.onLoad();
        this.initTable();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                BadAcctBackListUI.this.tblMain_afterDataFill(e);
            }
        });
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return VerificationBillFactory.getRemoteInstance();
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.setMainTableConfig();
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = super.initCommonQueryDialog();
        try {
            if (this.badAcctBackQueryUI == null) {
                this.badAcctBackQueryUI = new BadAcctBackQueryUI();
            }
            this.dialog.addUserPanel((KDPanel)this.badAcctBackQueryUI);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.dialog.setHeight(280);
        this.dialog.setWidth(375);
        this.dialog.setTitle(this.getStrResource("bad_acct_take_back_query_condition"));
        return this.dialog;
    }

    protected EntityViewInfo getInitDefaultSolution() {
        EntityViewInfo ev = new EntityViewInfo();
        BadAcctBackQueryUI queryUI = null;
        try {
            queryUI = new BadAcctBackQueryUI();
            queryUI.onLoad();
            ev.setFilter(queryUI.getFilterInfo());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return ev;
    }

    public void initTable() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getColumn("badAmounts").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("badAmountsLocal").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("takeBackAmounts").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("takeBackAmountsLocal").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("thisVerificateAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("thisVerificateAmtLoc").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("gainAndLoss").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("gainAndLoss").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    protected void initWorkButton() {
        try {
            this.startPeriod = ArClientUtils.getArStartPeriod(this.currentCompany);
            if (this.startPeriod == null) {
                throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{this.currentCompany.getName() + this.getSystemEnumForOA().getAlias()});
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        super.initWorkButton();
        this.menuItemVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_scvoucher"));
        this.menuItemDelVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_deletecredence"));
        this.menuItemViewVocher.setIcon(EASResource.getIcon((String)"imgTbtn_credence"));
        this.btnEditVouchers.setIcon(EASResource.getIcon((String)"imgTbtn_bluepencil"));
        this.menuItemEditVouchers.setIcon(EASResource.getIcon((String)"imgTbtn_bluepencil"));
        this.btnVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_scvoucher"));
        this.btnVoucher.setEnabled(true);
        this.btnDelVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_deletecredence"));
        this.btnDelVoucher.setEnabled(true);
        this.btnViewVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_credence"));
        this.btnViewVoucher.setEnabled(true);
        this.actionEditVouchers.setEnabled(true);
        this.btnEditVouchers.setEnabled(true);
        this.actionAddNew.setVisible(true);
        this.actionView.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionLocate.setVisible(false);
        this.actionRemove.setVisible(true);
        this.actionQuery.setVisible(true);
        this.actionPrint.setVisible(true);
        this.actionPrintPreview.setVisible(true);
    }

    private String getFormatString(CurrencyInfo currencyInfo) {
        int precision = 0;
        if (currencyInfo == null) {
            precision = 2;
        } else {
            precision = currencyInfo.getPrecision();
            if (precision == 0) {
                precision = 2;
            }
        }
        return PrecisionFormatUtils.getFormatString(precision);
    }

    private List getBadAcctIDList() {
        ArrayList<String> list = new ArrayList<String>();
        IRow row = null;
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            int endRow = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= endRow; ++i) {
                row = this.tblMain.getRow(i);
                String ID = row.getCell("id").getValue().toString();
                if (list.contains(ID)) continue;
                list.add(ID);
            }
        }
        return list;
    }

    protected void verifyInput() {
        int selectRow;
        int rowCount = this.tblMain.getRowCount();
        if (rowCount == 0) {
            MsgBox.showWarning((String)this.getStrResource("row_zero"));
            SysUtil.abort();
        }
        if (this.tblMain.getSelectManager().get() == null) {
            MsgBox.showWarning((String)this.getStrResource("no_select_record"));
            SysUtil.abort();
        }
        if ((selectRow = this.tblMain.getSelectManager().get().getTop()) < 0) {
            MsgBox.showWarning((String)this.getStrResource("no_select_record"));
            SysUtil.abort();
        }
    }

    public void tblMain_afterDataFill(KDTDataRequestEvent e) {
        this.changeData(e.getFirstRow(), e.getLastRow());
    }

    private void changeData(int beginRow, int endRow) {
        IMutexServiceControl mutex = MutexServiceControlFactory.getRemoteInstance();
        IRow row = null;
        String formateString = null;
        CurrencyInfo baseCurreny = CommonClientUtils.getCurrency(String.valueOf(this.currentCompany.getBaseCurrency().getId()));
        String baseFormateString = this.getFormatString(baseCurreny);
        CurrencyInfo currencyInfo = null;
        try {
            ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
            ObjectUuidPK pk = null;
            int size = endRow;
            for (int i = beginRow; i <= size; ++i) {
                row = this.tblMain.getRow(i);
                if (row.getCell("currency").getValue() != null) {
                    pk = new ObjectUuidPK(row.getCell("currency").getValue().toString());
                    currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)pk);
                }
                formateString = this.getFormatString(currencyInfo);
                this.tblMain.getRow(i).getCell("badAmounts").getStyleAttributes().setNumberFormat(formateString);
                this.tblMain.getRow(i).getCell("takeBackAmounts").getStyleAttributes().setNumberFormat(formateString);
                this.tblMain.getRow(i).getCell("thisVerificateAmt").getStyleAttributes().setNumberFormat(formateString);
                this.tblMain.getRow(i).getCell("gainAndLoss").getStyleAttributes().setNumberFormat(formateString);
                this.tblMain.getRow(i).getCell("badAmountsLocal").getStyleAttributes().setNumberFormat(baseFormateString);
                this.tblMain.getRow(i).getCell("takeBackAmountsLocal").getStyleAttributes().setNumberFormat(baseFormateString);
                this.tblMain.getRow(i).getCell("thisVerificateAmtLoc").getStyleAttributes().setNumberFormat(baseFormateString);
                String billID = row.getCell("id").getValue().toString();
                if (this.lockObjs.contains(billID)) continue;
                if (mutex.requestObjIDForUpdate(billID, this.defaultUserInfo.getString("id"))) {
                    this.lockObjs.add(billID);
                    continue;
                }
                row.setUserObject((Object)"locked");
                row.getStyleAttributes().setLocked(true);
            }
        }
        catch (Exception err) {
            this.handleException(err);
        }
    }

    private void releaseLock() {
        IMutexServiceControl mutex = MutexServiceControlFactory.getRemoteInstance();
        int iCount = this.lockObjs.size();
        for (int i = 0; i < iCount; ++i) {
            mutex.releaseObjIDForUpdate(this.lockObjs.get(i).toString());
        }
        this.lockObjs.clear();
    }

    protected boolean checkBeforeWindowClosing() {
        this.releaseLock();
        return super.checkBeforeWindowClosing();
    }

    protected void finalize() throws Throwable {
        this.releaseLock();
        super.finalize();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        BadAcctTakeBackListUI.show((Object)this);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        List IDList = this.getBadAcctIDList();
        IVerificationBill iVerification = VerificationBillFactory.getRemoteInstance();
        int size = IDList.size();
        for (int i = 0; i < size; ++i) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)IDList.get(i).toString()));
            VerificationBillInfo verificationBillBill = iVerification.getVerificationBillInfo((IObjectPK)pk);
            this.checkBizDateisValidate(this.currPeriod, verificationBillBill.getBizDate());
        }
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        IBadAcctTakeBackFacade iBadAcctTakeBackFacade = BadAcctTakeBackFacadeFactory.getRemoteInstance();
        int size2 = IDList.size();
        for (int i = 0; i < size2; ++i) {
            String ID = (String)IDList.get(i);
            if (!iBadAcctTakeBackFacade.isVouchered(ID)) continue;
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("badacct_takeback_voucher"));
            return;
        }
        int value = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.common.EASCommonResource", (String)"confirmDelete"));
        if (value == 1 || value == 2) {
            SysUtil.abort();
        }
        int size3 = IDList.size();
        for (int i = 0; i < size3; ++i) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)((String)IDList.get(i))));
            VerificationBillInfo verificationBillBill = iVerification.getVerificationBillInfo((IObjectPK)pk);
            BaseDataUtil.rolbackNumber((CoreBillBaseInfo)verificationBillBill);
        }
        iBadAcctTakeBackFacade.UnVerification(IDList);
        KDTSelectBlock selectRowBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            int endRow = selectRowBlock.getEndRow();
            for (int i = selectRowBlock.getTop(); i <= endRow; ++i) {
                this.tblMain.removeRow(i);
            }
        }
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.common.EASCommonResource", (String)"deleteSuccessed"));
        this.showMessage();
        this.refreshList();
    }

    private void isRelationGL() {
        if (!this.isNeedChecked()) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("gl_not_relation_or_start"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.isRelationGL();
        this.verifyInput();
        IBadAcctTakeBackFacade iBadAcctTakeBackFacade = BadAcctTakeBackFacadeFactory.getRemoteInstance();
        List IDList = this.getBadAcctIDList();
        int size = IDList.size();
        for (int i = 0; i < size; ++i) {
            String ID = (String)IDList.get(i);
            if (!iBadAcctTakeBackFacade.isVouchered(ID)) continue;
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("already_vouchered"));
            SysUtil.abort();
        }
        IObjectPK logObjectPK = null;
        if (IDList.size() > 0) {
            String ID = (String)IDList.get(0);
            ObjectUuidPK pk = new ObjectUuidPK(ID);
            IVerificationBill iVerificationBill = VerificationBillFactory.getRemoteInstance();
            VerificationBillInfo verificationBillInfo = iVerificationBill.getVerificationBillInfo((IObjectPK)pk);
            logObjectPK = this.beginLog((IObjectPK)pk, "voucher_log", (CoreBillBaseInfo)verificationBillInfo, "fi_ar_badacct_takeback_voucher");
        }
        super.actionVoucher_actionPerformed(e);
        if (logObjectPK != null) {
            this.afterLog(logObjectPK);
        }
    }

    @Override
    public void actionEditVouchers_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        IRow row = this.tblMain.getRow(selectBlock.getTop());
        String billId = row.getCell("id").getValue().toString();
        ArrayList voucherColl = BotRelationUtil.getDestObjectIdByDestType(null, (String)billId, (String)new VoucherInfo().getBOSType().toString());
        if (voucherColl.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("VoucherCannotEdit"));
            SysUtil.abort();
        }
        IIDList voucherIDList = this.arrayList2IIDList(voucherColl);
        String voucherId = voucherColl.get(0).toString();
        if (this.defaultUserInfo == null || this.defaultUserInfo == null) {
            return;
        }
        boolean hasPermission = BaseDataUtil.checkEditVoucherPermission((IObjectPK)new ObjectUuidPK(this.defaultUserInfo.getId()), (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()), "", (IObjectPK)new ObjectUuidPK(voucherId));
        if (!hasPermission) {
            MsgBox.showInfo((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("NoPermissionCannotEdit"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)voucherId);
        uiContext.put((Object)"EDITRULE", (Object)"com.kingdee.eas.fi.gl.client.DefaultVoucherEditRule");
        uiContext.put((Object)"IDList", (Object)voucherIDList);
        String uiClass = "com.kingdee.eas.fi.gl.client.VoucherEditUI";
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)uiContext, null, OprtState.EDIT) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(uiClass, (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    private IIDList arrayList2IIDList(ArrayList al) {
        RealModeIDList List2 = RealModeIDList.getEmptyIDList();
        if (al != null && al.size() != 0) {
            for (int i = 0; i < al.size(); ++i) {
                List2.add(i, (String)al.get(i));
            }
        }
        return List2;
    }

    @Override
    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        List IDList = this.getBadAcctIDList();
        int iCount = IDList.size();
        if (iCount <= 0) {
            MsgBox.showWarning((String)this.getStrResource("no_select_voucher_record"));
            SysUtil.abort();
        }
        if (this.tblMain.getSelectManager().get() == null) {
            SysUtil.abort();
        }
        IBadAcctTakeBackFacade iBadAcctTakeBackFacade = BadAcctTakeBackFacadeFactory.getRemoteInstance();
        int size = IDList.size();
        for (int i = 0; i < size; ++i) {
            String ID = (String)IDList.get(i);
            if (iBadAcctTakeBackFacade.isVouchered(ID)) continue;
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("no_gen_voucher"));
            return;
        }
        int value = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.common.EASCommonResource", (String)"confirmDelete"));
        if (value == 1 || value == 2) {
            SysUtil.abort();
        }
        iBadAcctTakeBackFacade.makeVoucher(false, IDList);
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.common.EASCommonResource", (String)"deleteSuccessed"));
        this.showMessage();
    }

    @Override
    public void actionViewVoucher_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null || selectBlock.size() <= 0) {
            return;
        }
        IRow row = this.tblMain.getRow(selectBlock.getTop());
        String billId = row.getCell("id").getValue().toString();
        ArrayList voucherColl = BotRelationUtil.getDestObjectIdByDestType(null, (String)billId, (String)new VoucherInfo().getBOSType().toString());
        if (voucherColl.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("lab_novoucher_beview"));
            return;
        }
        String voucherId = voucherColl.get(0).toString();
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"ID", (Object)voucherId);
        ctx.put((Object)"EDITRULE", (Object)"com.kingdee.eas.fi.gl.client.DefaultVoucherEditRule");
        IUIWindow uiVerificationWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(VoucherInfo.getEditUIName(), (Map)ctx, null, OprtState.VIEW);
        uiVerificationWindow.show();
    }

    private IObjectPK beginLog(IObjectPK pk, String method, CoreBillBaseInfo coreBillBaseInfo, String methodDes) throws BOSException, EASBizException {
        String methodName = this.getStrResource(method);
        String instanceDeatil = coreBillBaseInfo.getNumber();
        return LogUtil.beginLog(null, (String)methodName, (BOSObjectType)coreBillBaseInfo.getBOSType(), (IObjectPK)pk, (String)instanceDeatil, (String)methodDes);
    }

    private void afterLog(IObjectPK pk) {
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    public void setMainTableConfig() {
        this.tblMain.checkParsed();
        this.tblMain.getGroupManager().group();
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn("number").setGroup(true);
        this.tblMain.getColumn("company").setGroup(true);
        this.tblMain.getColumn("companyName").setGroup(true);
        this.tblMain.getColumn("personName").setGroup(true);
        this.tblMain.getColumn("adminOrgUnitName").setGroup(true);
        this.tblMain.getColumn("badAcctType").setGroup(true);
        this.tblMain.getColumn("badAcctTypeDes").setGroup(true);
        this.tblMain.getColumn("bizDate").setGroup(true);
        this.tblMain.getColumn("billDate").setGroup(true);
        this.tblMain.getColumn("billNumber").setGroup(true);
        this.tblMain.getColumn("acctCussTypeName").setGroup(true);
        this.tblMain.getColumn("acctCussName").setGroup(true);
        this.tblMain.getColumn("currencyName").setGroup(true);
        this.tblMain.getColumn("number").setMergeable(true);
        this.tblMain.getColumn("company").setMergeable(true);
        this.tblMain.getColumn("companyName").setMergeable(true);
        this.tblMain.getColumn("personName").setMergeable(true);
        this.tblMain.getColumn("adminOrgUnitName").setMergeable(true);
        this.tblMain.getColumn("badAcctType").setMergeable(true);
        this.tblMain.getColumn("badAcctTypeDes").setMergeable(true);
        this.tblMain.getColumn("bizDate").setMergeable(true);
        this.tblMain.getColumn("billDate").setMergeable(true);
        this.tblMain.getColumn("billNumber").setMergeable(true);
        this.tblMain.getColumn("acctCussTypeName").setMergeable(true);
        this.tblMain.getColumn("acctCussName").setMergeable(true);
        this.tblMain.getColumn("currencyName").setMergeable(true);
    }

    private boolean isNeedChecked() {
        boolean arIsRltdAccunt = false;
        boolean glIsStart = false;
        try {
            arIsRltdAccunt = ArClientUtils.arIsRelatedAccount(this.currentCompany);
            glIsStart = CommonClientUtils.glIsStart(this.currentCompany);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return arIsRltdAccunt && glIsStart;
    }

    private String getStrResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)resKey);
    }

    public String getClientStrResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)key);
    }

    private void checkBizDateisValidate(PeriodInfo currPeriod, Date bizDate) {
        if (currPeriod != null && bizDate != null && bizDate.compareTo(currPeriod.getBeginDate()) < 0) {
            MsgBox.showInfo((String)this.getStrResource("badacct_this_period_over"));
            SysUtil.abort();
        }
    }

    protected boolean isSupportDynQuery() {
        return true;
    }
}

