/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.BizobjectFacadeFactory;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.BadAcctBillTypeEnum;
import com.kingdee.eas.fi.ar.BadAcctCause;
import com.kingdee.eas.fi.ar.BadAcctCollection;
import com.kingdee.eas.fi.ar.BadAcctFactory;
import com.kingdee.eas.fi.ar.BadAcctInfo;
import com.kingdee.eas.fi.ar.IBadAcct;
import com.kingdee.eas.fi.ar.IOtherBill;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.client.AbstractBadAcctLossListUI;
import com.kingdee.eas.fi.ar.client.BadAcctLossQueryUI;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.client.util.CommonClientUtils;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.client.util.ArApReportUIUtil;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.scm.credit.CreditCtrlResult;
import com.kingdee.eas.scm.credit.CreditDirectionEnum;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.client.CreditCheck;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class BadAcctLossListUI
extends AbstractBadAcctLossListUI {
    private static final String TB_ID = "id";
    private static final String TB_CHECKBOX = "checkbox";
    private static final String TB_BILLTYPE = "billType";
    private static final String TB_SOURCEBILLNAME = "sourceBillName";
    private static final String TB_OTHERBILLID = "otherBillID";
    private static final String TB_BILLDATE = "billDate";
    private static final String TB_BADACCTCAUSE = "badAcctCause";
    private static final String TB_BADACCTDATE = "badAcctDate";
    private static final String TB_CURRENCY = "currency.id";
    private static final String TB_CURRENCYNAME = "currency.name";
    private static final String TB_SALEINVEXCHANGE = "exchangeRate";
    private static final String TB_ASSTACTTYPE = "asstActTypeID";
    private static final String TB_ASSTACTTYPEName = "asstActTypeName";
    private static final String TB_ACCTCUSSENTID = "asstActID";
    private static final String TB_ACCTCUSSENTNAME = "asstActName";
    private static final String TB_COMPANY = "company.id";
    private static final String TB_COMPANYNAME = "company.name";
    private static final String TB_NUMBER = "billNumber";
    private static final String TB_SALEINVENTRYID = "entryID";
    private static final String TB_ENTRYSEQ = "entrySeq";
    private static final String TB_ADMINORGUNIT = "adminOrgUnit";
    private static final String TB_ADMINORGUNITID = "adminOrgUnitID";
    private static final String TB_PERSON = "person";
    private static final String TB_PERSONID = "personID";
    private static final String TB_TOTALAMOUNTS = "recievePayAmount";
    private static final String TB_LOCALTOTALAMOUNTS = "recievePayAmountLocal";
    private static final String TB_VERIFYAMT = "verifyAmount";
    private static final String TB_LOCALVERIFYAMT = "verifyAmountLocal";
    private static final String TB_NONVERIFYAMT = "unVerifyAmount";
    private static final String TB_LOCALNONVERIFYAMT = "unVerifyAmountLocal";
    private static final String TB_LOCKVERIFYAMT = "lockVerifyAmt";
    private static final String TB_LOCKVERIFYAMTLOCAL = "lockVerifyAmtLocal";
    private static final String TB_LOCKUNVERIFYAMT = "lockUnVerifyAmt";
    private static final String TB_LOCKUNVERIFYAMTLOCAL = "lockUnVerifyAmtLocal";
    private static final String TB_BADACCTAMT = "badAmount";
    private static final String TB_LOCALBADACCTAMT = "badAmountLocal";
    private static final String TB_THISBADAMT = "badAmt";
    private static final String TB_LOCALTHISBADAMT = "localBadAmt";
    private String baseCurrencyPrecision = null;
    private static final String DATE_FORMAT = CtrlFormatUtilities.getDateFormatString();
    private CompanyOrgUnitInfo currentCompany = null;
    private BadAcctCollection savedCollection = new BadAcctCollection();
    private Map countBadDebtMethodOptions = null;
    private BadAcctLossQueryUI badAcctLossQueryUI = null;
    CommonQueryDialog dialog = null;
    private List lockObjs = new ArrayList();
    private UserInfo defaultUserInfo = null;
    private int precision = 0;
    private PeriodInfo currPeriod = null;
    private PeriodInfo startPeriod = null;
    protected ArApSysParamInfo cache = null;
    protected ExchangeRateInfo exgRateInfo = null;
    protected boolean isDirectExchange = true;
    protected IArApBillFacade iBillFacade = ArApBillFacadeFactory.getRemoteInstance();
    private static final String PERMISSION = "fi_arap_BadAccountLost_View";
    protected static final String strTakeOutZeroFormat = "%{0.##########}f";
    private String attachMentTempID = null;

    public BadAcctLossListUI() throws Exception {
        this.cache = new ArApSysParamInfo();
    }

    public void onLoad() throws Exception {
        this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        ArApReportUIUtil.checkCompany((Component)((Object)this), this.currentCompany);
        super.onLoad();
        this.countBadDebtMethodOptions = this.cache.getBadAccountFacadeParams();
        boolean isSetAccurralParam = this.cache.isSetAccurralParam();
        if (!isSetAccurralParam) {
            MsgBox.showInfo((String)this.getStrResource("no_set_accurral_param"));
            this.abort();
        }
        if (this.getBadAccount(this.cache, true) == null) {
            MsgBox.showInfo((String)this.getStrResource("no_set_accurral_param"));
            this.abort();
        }
        if (this.defaultUserInfo == null) {
            this.defaultUserInfo = SysContext.getSysContext().getCurrentUserInfo();
        }
        this.setToolbarImage();
        this.setButtonStatus();
        this.initData();
        this.initComponet();
        this.precision = this.currentCompany.getBaseCurrency().getPrecision();
        if (this.precision == 0) {
            this.precision = 2;
        }
        this.currPeriod = this.cache.getCurrentPeriod(this.getSysEnum());
    }

    protected HashMap getUIParam() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sysEnum", this.getSysEnum());
        map.put("isSCM", Boolean.FALSE);
        map.put("isInit", Boolean.FALSE);
        map.put("isBadAcctLoss", Boolean.TRUE);
        map.put("permissionItem", this.getPermissionItem());
        return map;
    }

    protected String getPermissionItem() {
        return PERMISSION;
    }

    protected SystemEnum getSysEnum() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    public EntityObjectInfo getBOSEntity() throws Exception {
        return MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(this.getBizType());
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                BadAcctLossListUI.this.tblMain_afterDataFill(e);
            }
        });
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        this.verifyInput();
        super.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BadAcctFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected void initWorkButton() {
        try {
            this.cache = this.iBillFacade.getSysParams(this.currentCompany, this.getUIParam());
            this.currentCompany = this.cache.getCompany();
            this.startPeriod = this.cache.getStartPeriod(this.getSysEnum());
            if (this.startPeriod == null) {
                throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{this.currentCompany.getName() + this.getSystemEnumForOA().getAlias()});
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        super.initWorkButton();
        this.menuItemAdd.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.menuItemSave.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    private void setToolbarImage() {
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnGenVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_scvoucher"));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
    }

    private void setButtonStatus() {
        this.actionView.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionLocate.setVisible(false);
        this.actionQuery.setVisible(false);
        this.btnGenVoucher.setVisible(false);
        this.btnAudit.setVisible(false);
        this.btnQuery.setVisible(true);
        this.btnQuery.setEnabled(true);
        this.MenuItemAttachment.setVisible(true);
        this.actionAttachment.setVisible(true);
    }

    private void initData() throws Exception {
        this.baseCurrencyPrecision = PrecisionFormatUtils.getFormatString(this.currentCompany.getBaseCurrency());
        KDCheckBox checkBox = new KDCheckBox();
        KDTDefaultCellEditor check_CellEditor = new KDTDefaultCellEditor((JCheckBox)checkBox);
        this.tblMain.getColumn(TB_CHECKBOX).setEditor((ICellEditor)check_CellEditor);
        this.tblMain.getColumn(TB_CHECKBOX).getStyleAttributes().setLocked(false);
        KDDatePicker datePicker = new KDDatePicker();
        datePicker.setDateEnabled(true);
        KDTDefaultCellEditor date_CellEditor = new KDTDefaultCellEditor(datePicker);
        this.tblMain.getColumn(TB_BADACCTDATE).setEditor((ICellEditor)date_CellEditor);
    }

    private void initComponet() {
        this.tblMain.getColumn(TB_BADACCTDATE).getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(TB_BADACCTDATE).getStyleAttributes().setNumberFormat(DATE_FORMAT);
        this.tblMain.getColumn(TB_TOTALAMOUNTS).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_BILLDATE).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(TB_BILLDATE).getStyleAttributes().setNumberFormat(DATE_FORMAT);
        this.tblMain.getColumn(TB_LOCALTOTALAMOUNTS).getStyleAttributes().setNumberFormat(this.baseCurrencyPrecision);
        this.tblMain.getColumn(TB_LOCALTOTALAMOUNTS).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_LOCKUNVERIFYAMT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_VERIFYAMT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_LOCALVERIFYAMT).getStyleAttributes().setNumberFormat(this.baseCurrencyPrecision);
        this.tblMain.getColumn(TB_LOCALVERIFYAMT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_NONVERIFYAMT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_LOCKVERIFYAMT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_LOCALNONVERIFYAMT).getStyleAttributes().setNumberFormat(this.baseCurrencyPrecision);
        this.tblMain.getColumn(TB_LOCALNONVERIFYAMT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_BADACCTAMT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_LOCALBADACCTAMT).getStyleAttributes().setNumberFormat(this.baseCurrencyPrecision);
        this.tblMain.getColumn(TB_LOCALBADACCTAMT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        KDFormattedTextField floatDrawing = new KDFormattedTextField((Object)new BigDecimal(String.valueOf("0.0")));
        KDTDefaultCellEditor floatDrawingCellEditor = new KDTDefaultCellEditor((JTextField)floatDrawing);
        this.tblMain.getColumn(TB_THISBADAMT).setEditor((ICellEditor)floatDrawingCellEditor);
        this.tblMain.getColumn(TB_THISBADAMT).getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(TB_THISBADAMT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_LOCALTHISBADAMT).getStyleAttributes().setNumberFormat(this.baseCurrencyPrecision);
        this.tblMain.getColumn(TB_LOCALTHISBADAMT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_SALEINVEXCHANGE).getStyleAttributes().setNumberFormat(this.baseCurrencyPrecision);
        this.tblMain.getColumn(TB_SALEINVEXCHANGE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        KDComboBox comboBox = new KDComboBox();
        KDTDefaultCellEditor combo_CellEditor = new KDTDefaultCellEditor((JComboBox)comboBox);
        comboBox.addItem((Object)BadAcctCause.NoReturn);
        comboBox.addItem((Object)BadAcctCause.RuptOrDeath);
        comboBox.addItem((Object)BadAcctCause.Others);
        this.tblMain.getColumn(TB_BADACCTCAUSE).getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(TB_BADACCTCAUSE).setEditor((ICellEditor)combo_CellEditor);
        this.menuItemAdd.setVisible(true);
    }

    private AccountViewInfo getBadAcctPrepareAccount(String key) throws BOSException, EASBizException {
        AccountViewInfo accountViewInfo = null;
        if (this.countBadDebtMethodOptions.get(key) != null && ((ParamItemInfo)this.countBadDebtMethodOptions.get(key)).getValue() != null && ((ParamItemInfo)this.countBadDebtMethodOptions.get(key)).getValue().toString().length() != 0) {
            accountViewInfo = ArClientUtils.getBadDebtPrepareAccount(this.countBadDebtMethodOptions, key);
        }
        return accountViewInfo;
    }

    public AccountViewInfo getBadAccount(ArApSysParamInfo cache, boolean isBadAcct) throws Exception {
        AccountViewInfo account = null;
        String accuralParam = cache.getBadAccountFacadeAccuralParam();
        if (cache.isDerectorTransferCancelMethod()) {
            account = this.getBadAcctPrepareAccount("arap001002005");
        } else if (accuralParam.equalsIgnoreCase(String.valueOf(2))) {
            account = isBadAcct ? this.getBadAcctPrepareAccount("arap001001002003") : this.getBadAcctPrepareAccount("arap001002002004");
        } else if (accuralParam.equalsIgnoreCase(String.valueOf(5))) {
            account = isBadAcct ? this.getBadAcctPrepareAccount("arap001001002001") : this.getBadAcctPrepareAccount("arap001002002002");
        } else if (accuralParam.equalsIgnoreCase(String.valueOf(6))) {
            account = isBadAcct ? this.getBadAcctPrepareAccount("arap001001002") : this.getBadAcctPrepareAccount("arap001002002");
        } else if (accuralParam.equalsIgnoreCase(String.valueOf(3))) {
            account = isBadAcct ? this.getBadAcctPrepareAccount("arap001001003") : this.getBadAcctPrepareAccount("arap001002003");
        } else if (accuralParam.equalsIgnoreCase(String.valueOf(1))) {
            account = isBadAcct ? this.getBadAcctPrepareAccount("arap001001001") : this.getBadAcctPrepareAccount("arap001002001");
        }
        return account;
    }

    private BadAcctCollection getSelectedInfo() throws Exception {
        IRow row = null;
        int rowCount = this.tblMain.getRowCount3();
        String checkValue = "false";
        BadAcctCollection badAcctColection = new BadAcctCollection();
        IBadAcct iBadAcct = (IBadAcct)this.getBizInterface();
        String badAcctCauseValue = "";
        BigDecimal thisBadAmt = new BigDecimal("0");
        BigDecimal thisBadAmtLocal = new BigDecimal("0");
        BigDecimal exchangeRate = new BigDecimal("0");
        Date badAcctDate = new Date();
        String billID = "";
        String companyID = "";
        String companyName = "";
        String currencyID = "";
        String currencyName = "";
        boolean billType = false;
        String entrySeq = "";
        String entryID = "";
        String acctCussentID = "";
        String acctCussentName = "";
        String billNumber = "";
        String asstActTypeID = null;
        Date billDate = null;
        ObjectUuidPK cussentTypePK = null;
        AsstActTypeInfo asstActTypeInfo = null;
        IAsstActType iAsstActType = AsstActTypeFactory.getRemoteInstance();
        IOtherBill iOtherBill = OtherBillFactory.getRemoteInstance();
        OtherBillInfo otherBillInfo = null;
        Map asstActNameMap = null;
        for (int i = 0; i < rowCount; ++i) {
            BadAcctInfo info = new BadAcctInfo();
            row = this.tblMain.getRow(i);
            checkValue = UIRuleUtil.getString((Object)row.getCell(TB_CHECKBOX).getValue());
            if (!"true".equals(checkValue)) continue;
            if (row.getCell(TB_ID).getValue() != null) {
                billID = row.getCell(TB_ID).getValue().toString();
                otherBillInfo = iOtherBill.getOtherBillInfo((IObjectPK)new ObjectUuidPK(billID));
            }
            if (row.getCell(TB_ENTRYSEQ).getValue() != null) {
                entrySeq = row.getCell(TB_ENTRYSEQ).getValue().toString();
            }
            if (row.getCell(TB_BADACCTDATE).getValue() != null) {
                badAcctDate = (Date)row.getCell(TB_BADACCTDATE).getValue();
            }
            if (row.getCell(TB_SALEINVEXCHANGE).getValue() != null) {
                exchangeRate = UIRuleUtil.getBigDecimal((Object)row.getCell(TB_SALEINVEXCHANGE).getValue());
            }
            if (row.getCell(TB_COMPANY).getValue() != null) {
                companyID = row.getCell(TB_COMPANY).getValue().toString();
            }
            if (row.getCell(TB_COMPANYNAME).getValue() != null) {
                companyName = row.getCell(TB_COMPANYNAME).getValue().toString();
            }
            if (row.getCell(TB_CURRENCY).getValue() != null) {
                currencyID = row.getCell(TB_CURRENCY).getValue().toString();
            }
            if (row.getCell(TB_CURRENCYNAME).getValue() != null) {
                currencyName = row.getCell(TB_CURRENCYNAME).getValue().toString();
            }
            if (row.getCell(TB_ACCTCUSSENTID).getValue() != null) {
                acctCussentID = row.getCell(TB_ACCTCUSSENTID).getValue().toString();
            }
            if (row.getCell(TB_ACCTCUSSENTNAME).getValue() != null) {
                acctCussentName = row.getCell(TB_ACCTCUSSENTNAME).getValue().toString();
            }
            if (row.getCell(TB_NUMBER).getValue() != null) {
                billNumber = row.getCell(TB_NUMBER).getValue().toString();
            }
            if (row.getCell(TB_BADACCTCAUSE).getValue() != null) {
                badAcctCauseValue = row.getCell(TB_BADACCTCAUSE).getValue().toString();
            }
            if (row.getCell(TB_THISBADAMT).getValue() != null) {
                thisBadAmt = UIRuleUtil.getBigDecimal((Object)row.getCell(TB_THISBADAMT).getValue());
            }
            if (row.getCell(TB_LOCALTHISBADAMT).getValue() != null) {
                thisBadAmtLocal = UIRuleUtil.getBigDecimal((Object)row.getCell(TB_LOCALTHISBADAMT).getValue());
            }
            if (row.getCell(TB_SALEINVENTRYID).getValue() != null) {
                entryID = row.getCell(TB_SALEINVENTRYID).getValue().toString();
            }
            if (row.getCell(TB_ASSTACTTYPE).getValue() != null) {
                asstActTypeID = row.getCell(TB_ASSTACTTYPE).getValue().toString();
                cussentTypePK = new ObjectUuidPK(BOSUuid.read((String)asstActTypeID));
                asstActTypeInfo = iAsstActType.getAsstActTypeInfo((IObjectPK)cussentTypePK);
            }
            if (row.getCell(TB_BILLDATE).getValue() != null) {
                billDate = (Date)row.getCell(TB_BILLDATE).getValue();
            }
            if (badAcctCauseValue.equals(BadAcctCause.NoReturn.toString())) {
                info.setBadAcctCause(BadAcctCause.NoReturn);
            }
            if (badAcctCauseValue.equals(BadAcctCause.RuptOrDeath.toString())) {
                info.setBadAcctCause(BadAcctCause.RuptOrDeath);
            }
            if (badAcctCauseValue.equals(BadAcctCause.Others.toString())) {
                info.setBadAcctCause(BadAcctCause.Others);
            }
            info.setBadAmounts(thisBadAmt);
            info.setBadAmountsLocal(thisBadAmtLocal);
            info.setTakeBackAmounts(BaseDataUtil.ZERO);
            info.setTakeBackAmountsLocal(BaseDataUtil.ZERO);
            try {
                info.setBadAcctDate(DateTimeUtils.truncateDate((Date)badAcctDate));
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            info.setExchageRate(exchangeRate);
            if (otherBillInfo != null) {
                info.setBillType(BadAcctBillTypeEnum.getEnum(otherBillInfo.getBillType().getValue()));
            }
            info.setBillNumber(billNumber);
            info.setBillID(billID);
            info.setBillDate(billDate);
            info.setCussentType(asstActTypeInfo);
            info.setAcctCussentID(acctCussentID);
            asstActNameMap = iBadAcct.getAsstActName(billID, "otherbill");
            info.setAcctCussentName(asstActNameMap.get("L1").toString(), ArApBillUIUtil.L1);
            info.setAcctCussentName(asstActNameMap.get("L2").toString(), ArApBillUIUtil.L2);
            info.setAcctCussentName(asstActNameMap.get("L3").toString(), ArApBillUIUtil.L3);
            info.setAccount(this.getBadAccount(this.cache, false));
            info.setBadAccount(this.getBadAccount(this.cache, true));
            CompanyOrgUnitInfo tmpOrg = new CompanyOrgUnitInfo();
            tmpOrg.setId(BOSUuid.read((String)companyID));
            tmpOrg.setName(companyName);
            info.setCompany(tmpOrg);
            CurrencyInfo tmpCurrency = new CurrencyInfo();
            tmpCurrency.setId(BOSUuid.read((String)currencyID));
            tmpCurrency.setName(currencyName);
            info.setCurrency(tmpCurrency);
            if (row.getCell(TB_ADMINORGUNITID).getValue() != null) {
                String adminOrgUnitID = row.getCell(TB_ADMINORGUNITID).getValue().toString();
                String adminOrgUnitName = null;
                if (row.getCell(TB_ADMINORGUNIT).getValue() != null) {
                    adminOrgUnitName = row.getCell(TB_ADMINORGUNIT).getValue().toString();
                }
                AdminOrgUnitInfo adminOrgInfo = new AdminOrgUnitInfo();
                adminOrgInfo.setId(BOSUuid.read((String)adminOrgUnitID));
                adminOrgInfo.setName(adminOrgUnitName);
                info.setAdminOrgUnit(adminOrgInfo);
            }
            if (row.getCell(TB_PERSONID).getValue() != null) {
                String personID = row.getCell(TB_PERSONID).getValue().toString();
                String personName = null;
                if (row.getCell(TB_PERSONID).getValue() != null) {
                    personName = row.getCell(TB_PERSON).getValue().toString();
                }
                PersonInfo person = new PersonInfo();
                person.setId(BOSUuid.read((String)personID));
                person.setName(personName);
                info.setPerson(person);
            }
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("cstype", (Object)String.valueOf(1), CompareType.EQUALS));
            evi.getSelector().add(new SelectorItemInfo("*"));
            evi.getSelector().add(new SelectorItemInfo("asstacttype.*"));
            filterInfo.setMaskString("#0");
            evi.setFilter(filterInfo);
            info.setEntrySeq(Integer.parseInt(entrySeq));
            info.setEntryID(entryID);
            CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
            info.setCU(cu);
            badAcctColection.add(info);
        }
        return badAcctColection;
    }

    protected void verifyInput() {
        IRow row = null;
        String checkValue = "false";
        int rowCount = this.tblMain.getRowCount3();
        if (rowCount == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("row_zero"));
            SysUtil.abort();
        }
        BigDecimal thisBadAmt = new BigDecimal("0.00");
        BigDecimal noVerifyAmt = new BigDecimal("0.00");
        BigDecimal exchangeRate = null;
        BigDecimal localBadAmt = null;
        Date badAcctDate = null;
        Date billDate = null;
        Date currDate = null;
        if (this.currPeriod != null) {
            currDate = this.currPeriod.getBeginDate();
        }
        Object thisBadAmtObj = null;
        Object noVerifyAmtObj = null;
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblMain.getRow(i);
            checkValue = row.getCell(TB_CHECKBOX).getValue().toString();
            if (!checkValue.equals("true")) continue;
            thisBadAmtObj = row.getCell(TB_THISBADAMT).getValue();
            if (thisBadAmtObj != null) {
                thisBadAmt = UIRuleUtil.getBigDecimal((Object)thisBadAmtObj);
            }
            if (thisBadAmt.equals(new BigDecimal("0.00"))) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("ar_bill_BadAccountsAmountIsNull"));
                SysUtil.abort();
            }
            if (thisBadAmt.compareTo(new BigDecimal("0.0")) <= 0) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("this_bigger_zero"));
                SysUtil.abort();
            }
            if ((noVerifyAmtObj = row.getCell(TB_LOCKUNVERIFYAMT).getValue()) != null) {
                noVerifyAmt = UIRuleUtil.getBigDecimal((Object)noVerifyAmtObj);
            }
            if (thisBadAmt.compareTo(noVerifyAmt) > 0) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("bad_amount_bigger_lock_amount"));
                SysUtil.abort();
            }
            if ((badAcctDate = (Date)row.getCell(TB_BADACCTDATE).getValue()).compareTo(billDate = (Date)row.getCell(TB_BILLDATE).getValue()) < 0) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("bad_date_not_big_bill_date"));
                SysUtil.abort();
            }
            if (currDate != null && badAcctDate.compareTo(currDate) < 0) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("bad_date_not_in_closeaccount_period"));
                SysUtil.abort();
            }
            exchangeRate = (BigDecimal)row.getCell(TB_SALEINVEXCHANGE).getValue();
            try {
                this.isDirectExchange = this.getExgRateInfo(row);
                localBadAmt = this.caculateLocalBadAmt(thisBadAmt, exchangeRate, this.isDirectExchange);
                row.getCell(TB_LOCALTHISBADAMT).setValue((Object)localBadAmt);
                continue;
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
        }
    }

    public void checkboxSelected() {
        int selCount = 0;
        int rowCount = this.tblMain.getRowCount3();
        if (rowCount == 0) {
            MsgBox.showWarning((String)this.getStrResource("no_data"));
            SysUtil.abort();
        }
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            String checkValue = UIRuleUtil.getString((Object)row.getCell(TB_CHECKBOX).getValue());
            if (!"true".equals(checkValue)) continue;
            ++selCount;
        }
        if (selCount == 0) {
            MsgBox.showWarning((String)this.getStrResource("select_data"));
            SysUtil.abort();
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected ArrayList getSelectedIdValues() {
        ArrayList<String> list = new ArrayList<String>();
        KDTSelectBlock selectBlock = null;
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            return list;
        }
        if (size == 1 && this.tblMain.getSelectManager().get().getTop() == this.tblMain.getSelectManager().get().getBottom()) {
            int rowNum = this.tblMain.getSelectManager().get().getTop();
            ICell cell = this.tblMain.getRow(rowNum).getCell(this.getKeyFieldName());
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if (cell.getValue() != null) {
                list.add(cell.getValue().toString());
            }
        } else {
            for (int i = 0; i < size; ++i) {
                selectBlock = this.tblMain.getSelectManager().get(i);
                for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                    String id;
                    ICell cell = this.tblMain.getRow(j).getCell(this.getKeyFieldName());
                    if (cell == null) {
                        MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                        SysUtil.abort();
                    }
                    if (list.contains(id = cell.getValue().toString())) continue;
                    list.add(id);
                }
            }
        }
        return list;
    }

    private BigDecimal caculateLocalBadAmt(BigDecimal badAmt, BigDecimal exchangeRate, boolean isDirectExchange) {
        BigDecimal result = new BigDecimal("0.00");
        if (badAmt == null || exchangeRate == null) {
            return result;
        }
        result = isDirectExchange ? badAmt.multiply(exchangeRate).divide(new BigDecimal("1.0"), this.precision, 4) : badAmt.divide(exchangeRate, this.cache.getBaseCurrency().getPrecision(), 4);
        return result;
    }

    protected ExchangeRateInfo getExgRateInfo(CurrencyInfo currency, Date billDate) throws EASBizException, BOSException {
        if (!ArApBillHelper.idEquals((CoreBaseInfo)currency, (CoreBaseInfo)this.cache.getBaseCurrency())) {
            return BaseDataUtil.getExchangeRate(this.cache.getCompany(), currency, billDate);
        }
        return null;
    }

    public void checkSelected() {
        if (this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected String getSelectedKeyValue() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        int rowIndex = 0;
        if (selectBlock != null) {
            Object keyValue;
            rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            ICell cell = row.getCell(TB_ID);
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return keyValue.toString();
            }
        }
        return null;
    }

    @Override
    public void tblMain_editStopped(KDTEditEvent e) throws Exception {
        if (e.getColIndex() == this.tblMain.getColumn(TB_THISBADAMT).getColumnIndex()) {
            IRow row = this.tblMain.getRow(e.getRowIndex());
            BigDecimal thisBadAmt = new BigDecimal("0.0");
            if (row.getCell(TB_THISBADAMT).getValue() != null) {
                thisBadAmt = new BigDecimal(row.getCell(TB_THISBADAMT).getValue().toString());
            }
            BigDecimal unLockVerifyAmt = (BigDecimal)row.getCell(TB_LOCKUNVERIFYAMT).getValue();
            if (thisBadAmt != null && thisBadAmt.compareTo(new BigDecimal("0.0")) < 0) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("this_bad_acct_biiger_zero"));
                row.getCell(TB_THISBADAMT).setValue(null);
                row.getCell(TB_LOCALTHISBADAMT).setValue(null);
                SysUtil.abort();
            }
            if (unLockVerifyAmt != null && thisBadAmt != null && thisBadAmt.compareTo(unLockVerifyAmt) > 0) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("bad_amount_bigger_lock_amount"));
                row.getCell(TB_THISBADAMT).setValue(null);
                row.getCell(TB_LOCALTHISBADAMT).setValue(null);
                SysUtil.abort();
            }
            if (thisBadAmt != null) {
                BigDecimal exchangeRate = (BigDecimal)row.getCell(TB_SALEINVEXCHANGE).getValue();
                this.isDirectExchange = this.getExgRateInfo(row);
                BigDecimal localBadAmt = this.caculateLocalBadAmt(thisBadAmt, exchangeRate, this.isDirectExchange);
                row.getCell(TB_LOCALTHISBADAMT).setValue((Object)localBadAmt);
            }
        }
    }

    public boolean getExgRateInfo(IRow row) throws Exception {
        if (row.getCell(TB_ID).getValue() != null) {
            String billID = "";
            IOtherBill iOtherBill = OtherBillFactory.getRemoteInstance();
            OtherBillInfo otherBillInfo = null;
            billID = row.getCell(TB_ID).getValue().toString();
            otherBillInfo = iOtherBill.getOtherBillInfo((IObjectPK)new ObjectUuidPK(billID));
            ObjectUuidPK currencyPK = new ObjectUuidPK(otherBillInfo.getCurrency().getId());
            ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
            CurrencyInfo currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)currencyPK);
            this.exgRateInfo = this.getExgRateInfo(currencyInfo, new Date());
            if (this.exgRateInfo != null) {
                this.isDirectExchange = this.exgRateInfo.getExchangeAux() != null && ConvertModeEnum.DIRECTEXCHANGERATE.equals((Object)this.exgRateInfo.getExchangeAux().getConvertMode());
            }
        }
        return this.isDirectExchange;
    }

    private void tblMain_afterDataFill(KDTDataRequestEvent e) {
        this.insertInitData_afterDataFill(e.getFirstRow(), e.getLastRow());
        this.changeData(e.getFirstRow(), e.getLastRow());
    }

    private void changeData(int beginRow, int endRow) {
        int i;
        this.btnSave.setEnabled(true);
        IRow row = null;
        String formateString = null;
        Object currencyInfo = null;
        BigDecimal lockUnVerifyAmt = null;
        int precision = 0;
        IMutexServiceControl mutex = MutexServiceControlFactory.getRemoteInstance();
        ArrayList<String> requestList = new ArrayList<String>();
        for (int i2 = beginRow; i2 <= endRow; ++i2) {
            ICell cell = this.tblMain.getRow(i2).getCell(TB_ID);
            if (cell == null || StringUtils.isEmpty((String)cell.getValue().toString())) continue;
            requestList.add(cell.getValue().toString());
        }
        Map map = mutex.batchRequestObjIDForUpdate(requestList);
        int size = requestList.size();
        for (i = 0; i < size; ++i) {
            String id = (String)requestList.get(i);
            if (!((Boolean)map.get(id)).booleanValue()) continue;
            this.lockObjs.add(id);
        }
        try {
            for (i = beginRow; i <= endRow; ++i) {
                ICell cell;
                row = this.tblMain.getRow(i);
                formateString = this.getFormatString(row);
                row.getCell(TB_TOTALAMOUNTS).getStyleAttributes().setNumberFormat(formateString);
                row.getCell(TB_LOCKVERIFYAMT).getStyleAttributes().setNumberFormat(formateString);
                row.getCell(TB_LOCKUNVERIFYAMT).getStyleAttributes().setNumberFormat(formateString);
                row.getCell(TB_BADACCTAMT).getStyleAttributes().setNumberFormat(formateString);
                row.getCell(TB_THISBADAMT).getStyleAttributes().setNumberFormat(formateString);
                row.getCell(TB_SALEINVEXCHANGE).getStyleAttributes().setNumberFormat(strTakeOutZeroFormat);
                if (row.getCell(TB_LOCKUNVERIFYAMT).getValue() != null) {
                    lockUnVerifyAmt = (BigDecimal)row.getCell(TB_LOCKUNVERIFYAMT).getValue();
                    row.getCell(TB_THISBADAMT).setValue((Object)lockUnVerifyAmt);
                }
                if ((cell = row.getCell("currency.precision")) != null && cell.getValue() != null) {
                    precision = Integer.parseInt(cell.getValue().toString());
                }
                if (precision == 0) {
                    precision = 2;
                }
                KDFormattedTextField textfield = new KDFormattedTextField((Object)new BigDecimal(String.valueOf("0.0")));
                textfield.setPrecision(precision);
                KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)textfield);
                row.getCell(TB_THISBADAMT).setEditor((ICellEditor)editor);
                String billID = null;
                if (row.getCell(TB_ID).getValue() != null) {
                    billID = row.getCell(TB_ID).getValue().toString();
                }
                if (this.lockObjs.contains(billID)) continue;
                if (this.defaultUserInfo == null) {
                    this.defaultUserInfo = SysContext.getSysContext().getCurrentUserInfo();
                }
                if (mutex.requestObjIDForUpdate(billID, this.defaultUserInfo.getString(TB_ID))) {
                    this.lockObjs.add(billID);
                    continue;
                }
                row.setUserObject((Object)"locked");
                row.getStyleAttributes().setLocked(true);
                row.getCell(TB_CHECKBOX).getStyleAttributes().setLocked(true);
                row.getCell(TB_BADACCTDATE).getStyleAttributes().setLocked(true);
                row.getCell(TB_BADACCTCAUSE).getStyleAttributes().setLocked(true);
                row.getCell(TB_THISBADAMT).getStyleAttributes().setLocked(true);
                row.getStyleAttributes().setBackground(Color.decode("#E8E8E3"));
            }
        }
        catch (Exception err) {
            this.handleException(err);
        }
    }

    public void refreshList() throws Exception {
        super.refreshList();
        this.tblMain.getColumn(TB_ASSTACTTYPE).getStyleAttributes().setHided(true);
        this.tblMain.getColumn(TB_ACCTCUSSENTID).getStyleAttributes().setHided(true);
    }

    private void releaseLock() {
        if (this.lockObjs.size() > 0) {
            IMutexServiceControl mutex = MutexServiceControlFactory.getRemoteInstance();
            mutex.batchReleaseObjIDForUpdate(this.lockObjs);
        }
        this.lockObjs.clear();
    }

    public void insertInitData_afterDataFill(int beginRow, int endRow) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        for (int i = beginRow; i <= endRow; ++i) {
            this.tblMain.getRow(i).getCell(TB_BADACCTDATE).setValue((Object)calendar.getTime());
            KDComboBox comboBox = new KDComboBox();
            comboBox.addItem((Object)BadAcctCause.NoReturn);
            comboBox.addItem((Object)BadAcctCause.RuptOrDeath);
            comboBox.addItem((Object)BadAcctCause.Others);
            KDTDefaultCellEditor combo_CellEditor = new KDTDefaultCellEditor((JComboBox)comboBox);
            this.tblMain.getColumn(TB_BADACCTCAUSE).getStyleAttributes().setLocked(false);
            this.tblMain.getColumn(TB_BADACCTCAUSE).setEditor((ICellEditor)combo_CellEditor);
            this.tblMain.getRow(i).getCell(TB_BADACCTCAUSE).setValue((Object)BadAcctCause.NoReturn);
        }
    }

    protected EntityViewInfo getInitDefaultSolution() {
        return null;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = super.initCommonQueryDialog();
        try {
            if (this.badAcctLossQueryUI == null) {
                this.badAcctLossQueryUI = new BadAcctLossQueryUI(this.cache);
            }
            this.dialog.addUserPanel((KDPanel)this.badAcctLossQueryUI);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.dialog.setHeight(260);
        this.dialog.setWidth(400);
        this.dialog.setTitle(this.getStrResource("bad_acct_query_condition"));
        return this.dialog;
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idListColl = this.getSelectedIdValues();
        String[] idList = new String[idListColl.size()];
        idListColl.toArray(idList);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        this.requestDataMutex(iMutex, idList);
        BadAcctInfo info = null;
        this.checkboxSelected();
        this.verifyInput();
        String sysNumber = null;
        IBadAcct badAcct = (IBadAcct)this.getBizInterface();
        BadAcctCollection badAcctInfoCol = this.getSelectedInfo();
        if (badAcctInfoCol == null || badAcctInfoCol.size() == 0) {
            return;
        }
        CoreBillBaseInfo[] billInfos = new CoreBillBaseInfo[badAcctInfoCol.size()];
        int size = badAcctInfoCol.size();
        for (int i = 0; i < size; ++i) {
            billInfos[i] = badAcctInfoCol.get(i);
        }
        CreditCtrlResult creditCtrlResult = CreditCheck.checkApSysBillAtOperation((CoreUI)this, (IObjectValue[])billInfos, (CreditFormulaSceneEnum)CreditFormulaSceneEnum.ARBILL, (CreditOperationEnum)CreditOperationEnum.BADDEBTLOSSES, (CreditDirectionEnum)CreditDirectionEnum.LESS);
        int size2 = badAcctInfoCol.size();
        for (int i = 0; i < size2; ++i) {
            BadAcctInfo badAcctInfo = badAcctInfoCol.get(i);
            sysNumber = BaseDataUtil.getNumberFromCodeRule(badAcctInfo);
            if (sysNumber == null || sysNumber.trim().equals("")) {
                MsgBox.showInfo((String)this.getStrResource("badacct_number_null"));
                SysUtil.abort();
            }
            badAcctInfo.setNumber(sysNumber);
            info = (BadAcctInfo)badAcct.saveBadAcct((IObjectValue)badAcctInfo);
            this.savedCollection.add(info);
            this.attachmentPerform(this.attachMentTempID, info.getId().toString());
        }
        if (creditCtrlResult != null && creditCtrlResult.isOverspend()) {
            CreditCheck.addExceptionRecord((CoreBillBaseInfo[])billInfos, (CreditFormulaSceneEnum)CreditFormulaSceneEnum.ARBILL, (CreditCtrlResult)creditCtrlResult, (CreditOperationEnum)CreditOperationEnum.BADDEBTLOSSES);
        }
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.common.EASCommonResource", (String)"saveSuccessed"));
        this.showMessage();
        this.execQuery();
        this.btnSave.setEnabled(true);
        this.releaseDataMutex(iMutex, idList);
    }

    private void requestDataMutex(IMutexServiceControl iMutex, String[] idList) {
        for (int i = 0; i < idList.length; ++i) {
            if (iMutex.requestObjIDForUpdate(idList[i])) continue;
            MsgBox.showInfo((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("DataMutex"));
            ArrayList<String> list = new ArrayList<String>();
            for (int j = 0; j < i; ++j) {
                list.add(idList[i]);
            }
            if (list.size() > 0) {
                String[] idListToRelease = new String[list.size()];
                list.toArray(idListToRelease);
                this.releaseDataMutex(iMutex, idListToRelease);
            }
            SysUtil.abort();
        }
    }

    private void releaseDataMutex(IMutexServiceControl iMutex, String[] idList) {
        for (int i = 0; i < idList.length; ++i) {
            iMutex.releaseObjIDForUpdate(idList[i]);
        }
    }

    private String[] getSelectedListId() {
        this.checkSelected();
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        ArrayList<Object> idList = new ArrayList<Object>();
        for (KDTSelectBlock block : blocks) {
            int top = block.getTop();
            int bottom = block.getBottom();
            for (int rowIndex = top; rowIndex <= bottom; ++rowIndex) {
                ICell cell = this.tblMain.getRow(rowIndex).getCell(this.getKeyFieldName());
                if (idList.contains(cell.getValue())) continue;
                idList.add(cell.getValue());
            }
        }
        String[] listId = null;
        if (idList != null && idList.size() > 0) {
            Iterator iterat = idList.iterator();
            listId = new String[idList.size()];
            int index = 0;
            while (iterat.hasNext()) {
                listId[index] = (String)iterat.next();
                ++index;
            }
        }
        return listId;
    }

    private String getFormatString(IRow row) {
        int precision = 2;
        ICell cell = row.getCell("currency.precision");
        if (cell != null && cell.getValue() != null) {
            precision = Integer.parseInt(cell.getValue().toString());
        }
        return PrecisionFormatUtils.getFormatString(precision);
    }

    protected boolean checkBeforeWindowClosing() {
        this.releaseLock();
        return super.checkBeforeWindowClosing();
    }

    protected void finalize() throws Throwable {
        this.releaseLock();
        super.finalize();
    }

    private boolean isNeedChecked() {
        boolean arIsRltdAccunt = false;
        boolean glIsStart = false;
        try {
            arIsRltdAccunt = ArClientUtils.arIsRelatedAccount(this.currentCompany);
            glIsStart = CommonClientUtils.glIsStart(this.currentCompany);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return arIsRltdAccunt && glIsStart;
    }

    private String getStrResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)resKey);
    }

    public String getClientStrResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)key);
    }

    protected void prepareMutexParameter(ActionEvent e, MutexParameter param) {
        param.setOrgUnitID(SysContext.getSysContext().getCurrentFIUnit().getId());
        super.prepareMutexParameter(e, param);
    }

    protected boolean isSupportDynQuery() {
        return true;
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        AttachmentUIContextInfo info = new AttachmentUIContextInfo();
        String boID = null;
        if (this.attachMentTempID == null) {
            this.attachMentTempID = boID = acm.getAttID().toString();
        } else {
            boID = this.attachMentTempID;
        }
        info.setBoID(boID);
        info.setEdit(true);
        String multi = (String)this.getUIContext().get("MultiapproveAttachment");
        if (multi != null && multi.equals("true")) {
            acm.showAttachmentListUIByBoIDNoAlready((Object)this, info);
        } else {
            acm.showAttachmentListUIByBoID((Object)this, info);
        }
    }

    private void attachmentPerform(String tempId, String pk) throws BOSException {
        if (pk == null || tempId == null) {
            return;
        }
        BizobjectFacadeFactory.getRemoteInstance().upAttID2BosID(tempId, pk);
        BizobjectFacadeFactory.getRemoteInstance().delTempAttachment(tempId);
        this.attachMentTempID = null;
    }
}

