/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.ar.BadAcctBillTypeEnum;
import com.kingdee.eas.fi.ar.client.AbstractBadAcctLossQueryUI;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.client.util.ComBoxInfo;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.ItemEvent;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;

public class BadAcctLossQueryUI
extends AbstractBadAcctLossQueryUI {
    private CompanyOrgUnitInfo currentCompany = null;
    private AsstActTypeInfo asstActTypeInfo = null;
    PeriodInfo startPeriod = null;
    protected ArApSysParamInfo cache = new ArApSysParamInfo();
    protected IArApBillFacade iBillFacade = ArApBillFacadeFactory.getRemoteInstance();
    private static final String PERMISSION = "fi_arap_BadAccountLost_View";

    public BadAcctLossQueryUI() throws Exception {
        try {
            this.currentCompany = BaseDataUtil.getCompanyInfo();
        }
        catch (Exception ex) {
            SysUtil.abort();
        }
        this.cache = this.iBillFacade.getSysParams(this.currentCompany, this.getUIParam());
    }

    public BadAcctLossQueryUI(ArApSysParamInfo cache) throws Exception {
        try {
            this.currentCompany = BaseDataUtil.getCompanyInfo();
        }
        catch (Exception ex) {
            SysUtil.abort();
        }
        this.cache = cache;
        if (this.cache.getCompany() == null) {
            this.cache = this.iBillFacade.getSysParams(this.currentCompany, this.getUIParam());
        }
    }

    protected HashMap getUIParam() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isSCM", Boolean.FALSE);
        map.put("sysEnum", SystemEnum.ACCOUNTSRECEIVABLE);
        map.put("permissionItem", PERMISSION);
        return map;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.isNeedChecked()) {
            this.kDChkVoucher.setSelected(true);
        } else {
            this.kDChkVoucher.setSelected(false);
        }
        this.startPeriod = this.cache.getStartPeriod(SystemEnum.ACCOUNTSRECEIVABLE);
        this.initPrompt();
        ArApBillUIUtil.makeAsstActType(this.comboCussentType, this.cache, false);
        int n = this.comboCussentType.getItemCount();
        for (int i = 0; i < n; ++i) {
            AsstActTypeInfo comObj = (AsstActTypeInfo)this.comboCussentType.getItemAt(i);
            if (comObj == null || ComBoxInfo.ITEM_ALL.equals(comObj) || !comObj.getString("asstHGAttribute").equalsIgnoreCase("customer")) continue;
            this.comboCussentType.setSelectedIndex(i);
            break;
        }
        CurrencyInfo baseCurrency = this.cache.getBaseCurrency();
        if (this.bizPromptCurrency.getData() == null) {
            this.bizPromptCurrency.setData((Object)baseCurrency);
        }
    }

    private void initPrompt() {
        this.bizPromptCompany.setData((Object)this.currentCompany);
        this.setCurrencyF7();
        this.setBillF7();
    }

    private void setCurrencyF7() {
        this.bizPromptCurrency.setEditable(true);
        this.bizPromptCurrency.setEditFormat("$number$");
        this.bizPromptCurrency.setDisplayFormat("$name$");
        this.bizPromptCurrency.setCommitFormat("$number$");
        this.bizPromptCurrency.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isoCode"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        this.bizPromptCurrency.setSelectorCollection(sic);
    }

    private void setBillF7() {
        int billType;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer sbFormula = new StringBuffer("");
        if (this.bizPromptCompany.getData() != null) {
            String companyID = ((CompanyOrgUnitInfo)this.bizPromptCompany.getData()).getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID, CompareType.EQUALS));
        }
        if (this.cmbBillType.getSelectedItem() != null && (billType = ((BadAcctBillTypeEnum)((Object)this.cmbBillType.getSelectedItem())).getValue()) != 100) {
            filter.getFilterItems().add(new FilterItemInfo("billType", (Object)("" + billType), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)String.valueOf(3), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("entry.lockUnVerifyAmt", (Object)String.valueOf(0), CompareType.GREATER));
        if (this.kDChkVoucher.isSelected()) {
            FilterItemInfo toNumberFilter = new FilterItemInfo("fiVouchered", (Object)"1", CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(toNumberFilter);
        }
        if (this.filterInfo.getFilterItems() != null && this.filterInfo.getFilterItems().size() > 0) {
            sbFormula.append("(").append(" ").append("#").append(0).append(" ").append(")").append(" ");
            for (int i = 1; i < this.filterInfo.getFilterItems().size(); ++i) {
                sbFormula.append("and").append(" ").append("(").append(" ").append("#").append(i).append(" ").append(")").append(" ");
            }
        }
        this.filterInfo.setMaskString(sbFormula.toString());
        viewInfo.setFilter(filter);
        this.bizBillNumFrom.setEntityViewInfo(viewInfo);
        this.bizBillNumTo.setEntityViewInfo(viewInfo);
        this.bizBillNumFrom.setEditable(true);
        this.bizBillNumFrom.setDisplayFormat("$number$");
        this.bizBillNumFrom.setEditFormat("$number$");
        this.bizBillNumFrom.setCommitFormat("$number$");
        this.bizBillNumTo.setEditable(true);
        this.bizBillNumTo.setDisplayFormat("$number$");
        this.bizBillNumTo.setEditFormat("$number$");
        this.bizBillNumTo.setCommitFormat("$number$");
        this.bizBillNumFrom.setQueryInfo("com.kingdee.eas.fi.ar.app.F7OtherBillQuery");
        this.bizBillNumTo.setQueryInfo("com.kingdee.eas.fi.ar.app.F7OtherBillQuery");
    }

    @Override
    protected void comboCussentType_itemStateChanged(ItemEvent e) throws Exception {
        if (this.comboCussentType.getSelectedIndex() == -1) {
            return;
        }
        try {
            this.asstActTypeInfo = (AsstActTypeInfo)this.comboCussentType.getSelectedItem();
            ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.bizPromptCussent, this.asstActTypeInfo, this.currentCompany.getId().toString(), true);
        }
        catch (Exception e2) {
            ExceptionHandler.handle((Throwable)e2);
        }
    }

    @Override
    protected void cmbBillType_itemStateChanged(ItemEvent e) throws Exception {
        this.setBillF7();
    }

    public FilterInfo getFilterInfo() {
        int billType;
        IObjectValue ICussent;
        Object obj;
        this.filterInfo = new FilterInfo();
        if (this.bizPromptCompany.getData() != null) {
            String companyId = ((OrgUnitInfo)this.bizPromptCompany.getData()).getId().toString();
            FilterItemInfo companyFilter = new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(companyFilter);
        }
        if ((obj = this.comboCussentType.getSelectedItem()) != null && !ComBoxInfo.ITEM_ALL.equals(obj)) {
            AsstActTypeInfo comObj = (AsstActTypeInfo)this.comboCussentType.getSelectedItem();
            String CussentType = comObj.getString("id");
            FilterItemInfo cussentTypeFilter = new FilterItemInfo("asstActTypeID", (Object)CussentType, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(cussentTypeFilter);
        }
        if (this.bizPromptCussent.getData() != null && (ICussent = (IObjectValue)this.bizPromptCussent.getData()) != null) {
            String AsstActID = ICussent.getString("id");
            FilterItemInfo cussentFilter = new FilterItemInfo("asstActID", (Object)AsstActID, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(cussentFilter);
        }
        if (this.cmbBillType.getSelectedItem() != null && (billType = ((BadAcctBillTypeEnum)((Object)this.cmbBillType.getSelectedItem())).getValue()) != 100) {
            FilterItemInfo billTypeFilter = new FilterItemInfo("billType", (Object)("" + billType), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(billTypeFilter);
        }
        if (this.bizPromptCurrency.getData() != null) {
            String currencyId = ((CurrencyInfo)this.bizPromptCurrency.getData()).getId().toString();
            FilterItemInfo currencyFilter = new FilterItemInfo("currency.id", (Object)currencyId, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(currencyFilter);
        }
        if (this.dateBillFrom.getTimestamp() != null) {
            FilterItemInfo fromBillDateFilter = new FilterItemInfo("billDate", (Object)this.downTimestamp(this.dateBillFrom.getTimestamp()), CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(fromBillDateFilter);
        }
        if (this.dateBillTo.getTimestamp() != null) {
            Calendar curDate = Calendar.getInstance();
            FilterItemInfo toBillDateFilter = new FilterItemInfo("billDate", (Object)this.upTimestamp(this.dateBillTo.getTimestamp()), CompareType.LESS_EQUALS);
            curDate.setTime((Date)toBillDateFilter.getCompareValue());
            curDate.set(curDate.get(1), curDate.get(2), curDate.get(5), 23, 59, 59);
            toBillDateFilter.setCompareValue((Object)new Date(curDate.getTimeInMillis()));
            this.filterInfo.getFilterItems().add(toBillDateFilter);
        }
        if (this.bizBillNumFrom.getData() != null) {
            String strNumber = "";
            strNumber = this.bizBillNumFrom.getText().trim();
            FilterItemInfo fromNumberFilter = new FilterItemInfo("billNumber", (Object)strNumber, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(fromNumberFilter);
        }
        if (this.bizBillNumTo.getData() != null) {
            String strNumber = "";
            strNumber = this.bizBillNumTo.getText().trim();
            FilterItemInfo toNumberFilter = new FilterItemInfo("billNumber", (Object)strNumber, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(toNumberFilter);
        }
        this.filterInfo.getFilterItems().add(new FilterItemInfo("isBizBill", (Object)Integer.valueOf("0"), CompareType.EQUALS));
        StringBuffer sbFormula = new StringBuffer();
        if (this.filterInfo.getFilterItems() != null && this.filterInfo.getFilterItems().size() > 0) {
            sbFormula.append("(").append(" ").append("#").append(0).append(" ").append(")").append(" ");
            for (int i = 1; i < this.filterInfo.getFilterItems().size(); ++i) {
                sbFormula.append("and").append(" ").append("(").append(" ").append("#").append(i).append(" ").append(")").append(" ");
            }
        }
        if (this.kDChkVoucher.isSelected()) {
            FilterItemInfo fivoucheredFilter = new FilterItemInfo("fiVouchered", (Object)"1", CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(fivoucheredFilter);
            FilterItemInfo initBillDateFilter = new FilterItemInfo("billDate", (Object)this.startPeriod.getBeginDate(), CompareType.LESS);
            this.filterInfo.getFilterItems().add(initBillDateFilter);
            int size = this.filterInfo.getFilterItems().size();
            sbFormula.append("and").append(" ").append("(").append(" ").append("#").append(size - 2).append(" ").append(" or ").append("#").append(size - 1).append(" ").append(")").append(" ");
        }
        this.filterInfo.setMaskString(sbFormula.toString());
        return this.filterInfo;
    }

    private Date upTimestamp(Timestamp oldTime) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(oldTime);
        GregorianCalendar calendarUp = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.get(5));
        Date dateUp = new Date(calendarUp.getTime().getTime());
        return dateUp;
    }

    private Date downTimestamp(Timestamp oldTime) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(oldTime);
        GregorianCalendar calendarDown = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.get(5));
        Date dateDown = new Date(calendarDown.getTime().getTime());
        return dateDown;
    }

    public void clear() {
        this.bizPromptCompany.setData((Object)this.currentCompany);
        this.bizPromptCussent.setData(null);
        this.bizPromptCurrency.setData(null);
        int n = this.comboCussentType.getItemCount();
        for (int i = 0; i < n; ++i) {
            AsstActTypeInfo comObj = (AsstActTypeInfo)this.comboCussentType.getItemAt(i);
            if (!comObj.getString("asstHGAttribute").equalsIgnoreCase("customer")) continue;
            this.comboCussentType.setSelectedIndex(i);
            break;
        }
        if (this.comboCussentType.getSelectedIndex() == -1 && this.comboCussentType.getItemCount() != 0) {
            this.comboCussentType.setSelectedIndex(0);
        }
        this.cmbBillType.setSelectedIndex(0);
        this.bizBillNumFrom.setValue(null);
        this.bizBillNumTo.setValue(null);
        Calendar calendar = Calendar.getInstance();
        this.dateBillFrom.setValue((Object)calendar.getTime());
        this.dateBillTo.setValue((Object)calendar.getTime());
    }

    public void thisClear() {
        this.bizPromptCussent.setData(null);
        this.bizPromptCurrency.setData(null);
        int n = this.comboCussentType.getItemCount();
        for (int i = 0; i < n; ++i) {
            AsstActTypeInfo comObj = (AsstActTypeInfo)this.comboCussentType.getItemAt(i);
            if (!comObj.getString("asstHGAttribute").equalsIgnoreCase("customer")) continue;
            this.comboCussentType.setSelectedIndex(i);
            break;
        }
        if (this.comboCussentType.getSelectedIndex() == -1 && this.comboCussentType.getItemCount() != 0) {
            this.comboCussentType.setSelectedIndex(0);
        }
        this.cmbBillType.setSelectedIndex(0);
        this.bizBillNumFrom.setValue(null);
        this.bizBillNumTo.setValue(null);
        this.dateBillFrom.setValue(null);
        this.dateBillTo.setValue(null);
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.thisClear();
        FilterItemCollection filterItemCollection = entityViewInfo.getFilter().getFilterItems();
        String sPropertyName = null;
        Object oCompareValue = null;
        CompareType ctCompare = null;
        block0: for (int i = 0; i < filterItemCollection.size(); ++i) {
            sPropertyName = filterItemCollection.get(i).getPropertyName();
            oCompareValue = filterItemCollection.get(i).getCompareValue();
            ctCompare = filterItemCollection.get(i).getCompareType();
            if ("company.id".equalsIgnoreCase(sPropertyName)) {
                this.bizPromptCompany.setData((Object)this.currentCompany);
                continue;
            }
            if ("asstActTypeID".equalsIgnoreCase(sPropertyName)) {
                IObjectValue objValue = this.getBizObject(oCompareValue.toString());
                int iCount = this.comboCussentType.getItemCount();
                for (int index = 0; index < iCount; ++index) {
                    if (!objValue.toString().equals(((AsstActTypeInfo)this.comboCussentType.getItemAt(index)).toString())) continue;
                    this.comboCussentType.setSelectedIndex(index);
                    continue block0;
                }
                continue;
            }
            if ("asstActID".equalsIgnoreCase(sPropertyName)) {
                this.setBizPromptData(this.bizPromptCussent, oCompareValue.toString());
                continue;
            }
            if ("currency.id".equalsIgnoreCase(sPropertyName)) {
                this.setBizPromptData(this.bizPromptCurrency, oCompareValue.toString());
                continue;
            }
            if ("billType".equalsIgnoreCase(sPropertyName)) {
                this.setComBoxData(this.cmbBillType, oCompareValue.toString());
                continue;
            }
            if ("billDate".equalsIgnoreCase(sPropertyName)) {
                if (CompareType.GREATER_EQUALS.equals((Object)ctCompare)) {
                    this.dateBillFrom.setValue(oCompareValue);
                    continue;
                }
                if (!CompareType.LESS_EQUALS.equals((Object)ctCompare)) continue;
                this.dateBillTo.setValue(oCompareValue);
                continue;
            }
            if ("billNumber".equalsIgnoreCase(sPropertyName)) {
                if (CompareType.GREATER_EQUALS.equals((Object)ctCompare)) {
                    this.bizBillNumFrom.setValue(oCompareValue);
                    continue;
                }
                if (!CompareType.LESS_EQUALS.equals((Object)ctCompare)) continue;
                this.bizBillNumTo.setValue(oCompareValue);
                continue;
            }
            if (!"fiVouchered".equalsIgnoreCase(sPropertyName) || !this.isNeedChecked()) continue;
            this.kDChkVoucher.setSelected(true);
        }
    }

    private IObjectValue getBizObject(String id) {
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            ObjectUuidPK pk = new ObjectUuidPK(id);
            IObjectValue objVal = DynamicObjectFactory.getRemoteInstance().getValue(pk.getObjectType(), (IObjectPK)pk, sic);
            return objVal;
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
            return null;
        }
    }

    private void setComBoxData(KDComboBox comBox, String value) {
        BadAcctBillTypeEnum badAcctBillTypeEnum = null;
        try {
            for (int i = 0; i < comBox.getItemCount(); ++i) {
                badAcctBillTypeEnum = (BadAcctBillTypeEnum)((Object)comBox.getItemAt(i));
                if (!(badAcctBillTypeEnum.getValue() + "").equals(value.toString())) continue;
                comBox.setSelectedIndex(i);
                break;
            }
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
    }

    private void setBizPromptData(KDBizPromptBox bizPrompt, String id) {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(id);
            IObjectValue objVal = DynamicObjectFactory.getRemoteInstance().getValue(pk.getObjectType(), (IObjectPK)pk);
            bizPrompt.setData((Object)objVal);
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
    }

    private void setBizComboboxData(KDComboBox bizPrompt, String id) {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(id);
            IObjectValue objVal = DynamicObjectFactory.getRemoteInstance().getValue(pk.getObjectType(), (IObjectPK)pk);
            bizPrompt.setSelectedItem((Object)objVal);
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
    }

    private boolean isNeedChecked() {
        boolean arIsRltdAccunt = false;
        boolean glIsStart = false;
        arIsRltdAccunt = this.cache.isRelationGL();
        glIsStart = this.cache.isGLStart();
        return arIsRltdAccunt && glIsStart;
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection sorterColl = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("billNumber");
        sorterItem.setSortType(SortType.DESCEND);
        sorterColl.add(sorterItem);
        sorterItem = new SorterItemInfo("entrySeq");
        sorterItem.setSortType(SortType.ASCEND);
        sorterColl.add(sorterItem);
        return sorterColl;
    }
}

