/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractPrintDataProvider;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.botp.util.BotRelationUtil;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.assistant.util.CommonPrintIntegrationDataProvider;
import com.kingdee.eas.basedata.assistant.util.PrintIntegrationManager;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ar.BadAcctBillTypeEnum;
import com.kingdee.eas.fi.ar.BadAcctCause;
import com.kingdee.eas.fi.ar.BadAcctCollection;
import com.kingdee.eas.fi.ar.BadAcctFactory;
import com.kingdee.eas.fi.ar.BadAcctInfo;
import com.kingdee.eas.fi.ar.BadAcctTypeInitOrNot;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.IBadAcct;
import com.kingdee.eas.fi.ar.IOtherBill;
import com.kingdee.eas.fi.ar.InitBadAccountFactory;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.client.AbstractBadAcctReferListUI;
import com.kingdee.eas.fi.ar.client.BadAcctReferQueryUI;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.client.util.CommonClientUtils;
import com.kingdee.eas.fi.arap.client.util.ArApBatchUtil;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.client.util.ArApReportUIUtil;
import com.kingdee.eas.fi.arap.util.DefinitionNewDataProvider;
import com.kingdee.eas.fi.arap.util.MultiDataSourceDataProviderProxy;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.scm.common.util.SCMSlaveCommonDataProvider;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class BadAcctReferListUI
extends AbstractBadAcctReferListUI {
    private CompanyOrgUnitInfo currentCompany = null;
    private static final String TB_ID = "id";
    private static final String TB_COMPANY = "company.id";
    private static final String TB_COMPANYNAME = "company.name";
    private static final String TB_ASSTACTTYPEID = "cussentType.id";
    private static final String TB_ASSTASSISTTYPE = "cussentType.assistantType";
    private static final String TB_ASSTNAME = "cussentType.name";
    private static final String TB_ACCTCUSSENTID = "acctCussentID";
    private static final String TB_ACCTCUSSENT = "acctCussentName";
    private static final String TB_CURRENCY = "currency.id";
    private static final String TB_CURRENCYNAME = "currency.name";
    private static final String TB_EXCHANGE_RATE = "exchangeRate";
    private static final String TB_NUMBER = "billNumber";
    private static final String TB_SEQ = "entrySeq";
    private static final String TB_BADACCTAMOUNTS = "badAmounts";
    private static final String TB_TAKEBACKAMOUNTS = "takeBackAmounts";
    private static final String TB_BILLTYPE = "billType";
    private static final String TB_BILLDATE = "billDate";
    private static final String TB_BILLTYPEENUM = "billTypeEnum";
    private static final String TB_THISTAKEBACKAMT = "thisTakeBackAmt";
    private static final String TB_THISTAKEBACKAMTLOC = "thisTakeBackAmtLoc";
    private static final String TB_BADACCTTYPE = "badAcctType";
    private static final String TB_BADACCTTYPERES = "badAcctTypeRes";
    private static final String TB_BALANCEAMT = "compareAmounts";
    private static final String TB_OTHERBILLID = "billID";
    private boolean isInitBadAcct = false;
    private IVoucher iVoucher;
    IBadAcct iBadAcct = null;
    IOtherBill iOtherBill = null;
    private BadAcctReferQueryUI badAcctReferQueryUI = null;
    CommonQueryDialog dialog = null;
    private CurrencyInfo localCurrency = null;
    private PeriodInfo startPeriod = null;
    private List lockObjs = new ArrayList();
    private UserInfo defaultUserInfo = null;
    private LogUtil logUtil = new LogUtil();
    private BadAcctReferQueryUI queryUI = null;
    public static final String RELATION_QUERY_PARAM = "RelationQueryParameter";

    public void onLoad() throws Exception {
        HashMap hm;
        this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        ArApReportUIUtil.checkCompany((Component)((Object)this), this.currentCompany);
        if (this.defaultUserInfo == null) {
            this.defaultUserInfo = SysContext.getSysContext().getCurrentUserInfo();
        }
        this.localCurrency = CommonClientUtils.getCurrency(String.valueOf(this.currentCompany.getBaseCurrency().getId()));
        this.iBadAcct = BadAcctFactory.getRemoteInstance();
        this.iVoucher = VoucherFactory.getRemoteInstance();
        this.iOtherBill = OtherBillFactory.getRemoteInstance();
        this.setOprtState("EDIT");
        Object obj = this.getUIContext().get("needDefaultFilter");
        if (obj != null) {
            this.setIsNeedDefaultFilter((Boolean)obj);
        }
        super.onLoad();
        Object id = this.getUIContext().get("ID");
        if (id != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(TB_ID, (Object)id.toString()));
            view.setFilter(filter);
            this.mainQuery = view;
            this.setButtonVisible(true);
            this.refreshList();
        }
        if ((hm = (HashMap)this.getUIContext().get(RELATION_QUERY_PARAM)) != null && !hm.isEmpty() && hm.get("ID") != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(TB_ID, (Object)hm.get("ID").toString()));
            view.setFilter(filter);
            this.mainQuery = view;
            this.refreshList();
        }
        this.initTable();
        this.initButton();
        this.setButtonVisible(!this.isInitBadAcct);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                BadAcctReferListUI.this.tblMain_afterDataFill(e);
            }
        });
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void releaseLock() {
        IMutexServiceControl mutex = MutexServiceControlFactory.getRemoteInstance();
        int iCount = this.lockObjs.size();
        for (int i = 0; i < iCount; ++i) {
            mutex.releaseObjIDForUpdate(this.lockObjs.get(i).toString());
        }
        this.lockObjs.clear();
    }

    protected String getEditUIName() {
        return null;
    }

    public EntityObjectInfo getBOSEntity() throws Exception {
        return MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(this.getBizType());
    }

    protected ICoreBase getBizInterface() throws Exception {
        if (this.isInitBadAcct) {
            return InitBadAccountFactory.getRemoteInstance();
        }
        return BadAcctFactory.getRemoteInstance();
    }

    private void tblMain_afterDataFill(KDTDataRequestEvent e) {
        this.changeData(e.getFirstRow(), e.getLastRow());
    }

    private void changeData(int beginRow, int endRow) {
        IRow row = null;
        String formateString = null;
        CurrencyInfo currencyInfo = null;
        String temp = "";
        int billTypeValue = 0;
        int badAcctType = 0;
        Object badAcctCause = null;
        IMutexServiceControl mutex = MutexServiceControlFactory.getRemoteInstance();
        try {
            ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
            ObjectUuidPK pk = null;
            for (int i = beginRow; i <= endRow; ++i) {
                BadAcctCause badAcctCauseEnum;
                row = this.tblMain.getRow(i);
                String ID = row.getCell(TB_ID).getValue().toString();
                if (!this.lockObjs.contains(ID)) {
                    if (mutex.requestObjIDForUpdate(ID, this.defaultUserInfo.getString(TB_ID))) {
                        this.lockObjs.add(ID);
                    } else {
                        row.setUserObject((Object)"locked");
                        row.getStyleAttributes().setLocked(true);
                        row.getStyleAttributes().setBackground(Color.decode("#E8E8E3"));
                    }
                }
                if (row.getCell(TB_CURRENCY).getValue() != null) {
                    pk = new ObjectUuidPK(row.getCell(TB_CURRENCY).getValue().toString());
                    currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)pk);
                    formateString = PrecisionFormatUtils.getFormatString(currencyInfo);
                    row.getCell(TB_EXCHANGE_RATE).getStyleAttributes().setNumberFormat(BaseDataUtil.getERFormatString(currencyInfo, this.localCurrency));
                    row.getCell(TB_BADACCTAMOUNTS).getStyleAttributes().setNumberFormat(formateString);
                    row.getCell(TB_TAKEBACKAMOUNTS).getStyleAttributes().setNumberFormat(formateString);
                    row.getCell(TB_BALANCEAMT).getStyleAttributes().setNumberFormat(formateString);
                }
                if (row.getCell(TB_BADACCTTYPE).getValue() != null && (badAcctType = Integer.parseInt(row.getCell(TB_BADACCTTYPE).getValue().toString())) == 2 && row.getCell(TB_BILLTYPE).getValue() != null) {
                    temp = row.getCell(TB_BILLTYPE).getValue().toString();
                    billTypeValue = Integer.parseInt(temp);
                    BadAcctBillTypeEnum billTypeEnum = BadAcctBillTypeEnum.getEnum(billTypeValue);
                    row.getCell(TB_BILLTYPEENUM).setValue((Object)billTypeEnum);
                }
                if (row.getCell(TB_BADACCTTYPE).getValue() != null) {
                    BadAcctTypeInitOrNot badAcctTypeInitOrNot = BadAcctTypeInitOrNot.getEnum(Integer.parseInt(row.getCell(TB_BADACCTTYPE).getValue().toString()));
                    row.getCell(TB_BADACCTTYPERES).setValue((Object)badAcctTypeInitOrNot.getAlias());
                    if (badAcctTypeInitOrNot.getValue() == 1) {
                        row.getCell(TB_NUMBER).setValue(null);
                    }
                }
                if ((badAcctCause = row.getCell("badAcctCause").getValue()) != null && (badAcctCauseEnum = BadAcctCause.getEnum(badAcctCause.toString())) != null) {
                    String badAcctC = badAcctCauseEnum.getAlias();
                    row.getCell("badAcctCause").setValue((Object)badAcctC);
                }
                if (this.isInitBadAcct) continue;
                if (row.getCell("auditDate").getValue() != null) {
                    row.getCell("status").setValue((Object)BillStatusEnum.AUDITED);
                    continue;
                }
                row.getCell("status").setValue((Object)BillStatusEnum.SUBMITED);
            }
        }
        catch (BOSException err) {
            this.handUIExceptionAndAbort((Exception)((Object)err));
        }
        catch (EASBizException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        String queryFiter = this.getMainQuery().toString();
        this.isInitBadAcct = this.isInitBadAcct(queryFiter);
        this.setButtonVisible(!this.isInitBadAcct);
        this.setButtonEnabled(true);
        this.tblMain.getColumn("status").getStyleAttributes().setHided(this.isInitBadAcct);
        this.refreshList();
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = super.initCommonQueryDialog();
        try {
            if (this.badAcctReferQueryUI == null) {
                this.badAcctReferQueryUI = new BadAcctReferQueryUI();
            }
            if (this.badAcctReferQueryUI != null) {
                String string = this.badAcctReferQueryUI.badAcctType;
            }
            this.dialog.addUserPanel((KDPanel)this.badAcctReferQueryUI);
            this.dialog.setShowFilter(false);
            this.dialog.setShowSorter(false);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.dialog.setHeight(270);
        this.dialog.setWidth(485);
        this.dialog.setTitle(this.getStrResource("bad_acct_refer_query_condition"));
        return this.dialog;
    }

    protected EntityViewInfo getInitDefaultSolution() {
        EntityViewInfo ev = new EntityViewInfo();
        if (this.queryUI == null) {
            try {
                this.queryUI = new BadAcctReferQueryUI();
                this.queryUI.onLoad();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        ev.setFilter(this.queryUI.getFilterInfo());
        return ev;
    }

    protected boolean isAllowDefaultSolutionNull() {
        return false;
    }

    private FilterInfo getDefalutQueryFilter() {
        try {
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            EntityViewInfo viewInfo = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), "com.kingdee.eas.fi.ar.app.BadAcctReferQuery", ToolUtils.getCurrentCUPK().toString(), ToolUtils.getCurrentUserPK().toString());
            if (viewInfo != null) {
                return viewInfo.getFilter();
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        return null;
    }

    private String getFormatString(CurrencyInfo currencyInfo, boolean flag) {
        int precision = 0;
        if (currencyInfo == null) {
            precision = 2;
        } else {
            precision = currencyInfo.getPrecision();
            if (precision == 0) {
                precision = 2;
            }
        }
        StringBuffer buffer = new StringBuffer("%r-[=]{#,##0.");
        for (int i = 0; i < precision; ++i) {
            buffer.append(flag ? "0" : "#");
        }
        buffer.append("}f");
        return buffer.toString();
    }

    private boolean isInitBadAcct(String queryFilter) {
        if (queryFilter == null) {
            this.isInitBadAcct = false;
            return this.isInitBadAcct;
        }
        int pos = queryFilter.indexOf(TB_BADACCTTYPE);
        String subQueryFilter = queryFilter.substring(pos + TB_BADACCTTYPE.length(), queryFilter.length());
        if (subQueryFilter == null || "".equals(subQueryFilter.trim())) {
            this.isInitBadAcct = false;
            return this.isInitBadAcct;
        }
        int pos1 = subQueryFilter.indexOf("'");
        String subQueryFilter1 = subQueryFilter.substring(pos1 + 1, subQueryFilter.length());
        if (subQueryFilter1 == null || "".equals(subQueryFilter1.trim())) {
            this.isInitBadAcct = false;
            return this.isInitBadAcct;
        }
        int pos2 = subQueryFilter1.indexOf("'");
        String badAcct = subQueryFilter1.substring(0, pos2);
        if (badAcct == null || "".equals(badAcct.trim())) {
            this.isInitBadAcct = false;
            return this.isInitBadAcct;
        }
        BadAcctTypeInitOrNot badAccTypeInitOrNot = BadAcctTypeInitOrNot.getEnum(Integer.parseInt(badAcct));
        this.isInitBadAcct = badAccTypeInitOrNot.getValue() == 1;
        return this.isInitBadAcct;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.menuEdit.setVisible(false);
    }

    private void initTable() {
        this.tblMain.getColumn(TB_BADACCTAMOUNTS).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_TAKEBACKAMOUNTS).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_BALANCEAMT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    private void initButton() {
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_scvoucher"));
        this.btnDelVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_deletecredence"));
        this.btnViewVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_credence"));
        this.btnAttachment.setVisible(false);
        this.btnPrint.setVisible(true);
        this.btnPrintPreview.setVisible(true);
        this.MenuItemAttachment.setEnabled(true);
        this.actionAttachment.setVisible(true);
        this.actionEditVouchers.setEnabled(true);
        this.btnEditVouchers.setEnabled(true);
    }

    protected void initWorkButton() {
        try {
            this.startPeriod = ArClientUtils.getArStartPeriod(this.currentCompany);
            if (this.startPeriod == null) {
                throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{this.currentCompany.getName() + this.getSystemEnumForOA().getAlias()});
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        super.initWorkButton();
        this.ItemRemove.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.menuItemViewVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_credence"));
        this.btnEditVouchers.setIcon(EASResource.getIcon((String)"imgTbtn_bluepencil"));
        this.menuItemEditVouchers.setIcon(EASResource.getIcon((String)"imgTbtn_bluepencil"));
    }

    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("company"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo(TB_COMPANYNAME));
        sic.add(new SelectorItemInfo(TB_CURRENCYNAME));
        sic.add(new SelectorItemInfo(TB_THISTAKEBACKAMTLOC));
        sic.add(new SelectorItemInfo(TB_THISTAKEBACKAMT));
        return sic;
    }

    private BadAcctInfo getSelectedInfo(int i) {
        IRow row = this.tblMain.getRow(i);
        BadAcctInfo info = new BadAcctInfo();
        String id = "";
        String companyID = "";
        String companyName = "";
        String asstActTypeID = "";
        String asstName = "";
        String asstNumber = "";
        String acctCussent = "";
        String currencyID = "";
        String currencyName = "";
        BigDecimal exchangeRate = null;
        String acctCussentID = "";
        String number = "";
        String entrySeq = "";
        BigDecimal badAmounts = new BigDecimal("0");
        BigDecimal takeBackAmounts = new BigDecimal("0");
        String badAcctType = null;
        String billType = "";
        String billID = "";
        if (row.getCell(TB_ID).getValue() != null) {
            id = row.getCell(TB_ID).getValue().toString();
        }
        if (row.getCell(TB_COMPANY).getValue() != null) {
            companyID = row.getCell(TB_COMPANY).getValue().toString();
        }
        if (row.getCell(TB_COMPANYNAME).getValue() != null) {
            companyName = row.getCell(TB_COMPANYNAME).getValue().toString();
        }
        if (row.getCell(TB_ASSTACTTYPEID).getValue() != null) {
            asstActTypeID = row.getCell(TB_ASSTACTTYPEID).getValue().toString();
        }
        if (row.getCell(TB_ASSTNAME).getValue() != null) {
            asstName = row.getCell(TB_ASSTNAME).getValue().toString();
        }
        if (row.getCell(TB_ACCTCUSSENT).getValue() != null) {
            acctCussent = row.getCell(TB_ACCTCUSSENT).getValue().toString();
        }
        if (row.getCell(TB_ACCTCUSSENTID).getValue() != null) {
            acctCussentID = row.getCell(TB_ACCTCUSSENTID).getValue().toString();
        }
        if (row.getCell(TB_CURRENCY).getValue() != null) {
            currencyID = row.getCell(TB_CURRENCY).getValue().toString();
        }
        if (row.getCell(TB_CURRENCYNAME).getValue() != null) {
            currencyName = row.getCell(TB_CURRENCYNAME).getValue().toString();
        }
        if (row.getCell(TB_ACCTCUSSENT).getValue() != null) {
            acctCussent = row.getCell(TB_ACCTCUSSENT).getValue().toString();
        }
        if (row.getCell(TB_NUMBER).getValue() != null) {
            number = row.getCell(TB_NUMBER).getValue().toString();
        }
        if (row.getCell(TB_SEQ).getValue() != null) {
            entrySeq = row.getCell(TB_SEQ).getValue().toString();
        }
        if (row.getCell(TB_BADACCTAMOUNTS).getValue() != null) {
            badAmounts = UIRuleUtil.getBigDecimal((Object)row.getCell(TB_BADACCTAMOUNTS).getValue());
        }
        if (row.getCell(TB_TAKEBACKAMOUNTS).getValue() != null) {
            takeBackAmounts = UIRuleUtil.getBigDecimal((Object)row.getCell(TB_TAKEBACKAMOUNTS).getValue());
        }
        if (row.getCell(TB_BILLTYPE).getValue() != null) {
            billType = row.getCell(TB_BILLTYPE).getValue().toString();
        }
        if (row.getCell(TB_EXCHANGE_RATE).getValue() != null) {
            exchangeRate = (BigDecimal)row.getCell(TB_EXCHANGE_RATE).getValue();
        }
        if (row.getCell(TB_BADACCTTYPE).getValue() != null) {
            badAcctType = row.getCell(TB_BADACCTTYPE).getValue().toString();
        }
        if (row.getCell(TB_OTHERBILLID).getValue() != null) {
            billID = row.getCell(TB_OTHERBILLID).getValue().toString();
        }
        info.setId(BOSUuid.read((String)id));
        CompanyOrgUnitInfo tmpOrg = new CompanyOrgUnitInfo();
        tmpOrg.setId(BOSUuid.read((String)companyID));
        tmpOrg.setName(companyName);
        info.setCompany(tmpOrg);
        AsstActTypeInfo tmpAsstType = new AsstActTypeInfo();
        if (asstActTypeID != null && !asstActTypeID.trim().equals("")) {
            tmpAsstType.setId(BOSUuid.read((String)asstActTypeID));
        }
        tmpAsstType.setNumber(asstNumber);
        tmpAsstType.setName(asstName);
        info.setCussentType(tmpAsstType);
        CurrencyInfo tmpCurrency = new CurrencyInfo();
        tmpCurrency.setId(BOSUuid.read((String)currencyID));
        tmpCurrency.setName(currencyName);
        BadAcctBillTypeEnum billTypeEnum = BadAcctBillTypeEnum.getEnum(Integer.parseInt(billType));
        if (billTypeEnum != null) {
            info.setBillType(billTypeEnum);
        }
        info.setCurrency(tmpCurrency);
        info.setAcctCussentID(acctCussentID);
        info.setAcctCussentName(acctCussent);
        info.setExchageRate(exchangeRate);
        info.setNumber(number);
        info.setEntrySeq(Integer.parseInt(entrySeq));
        info.setBadAmounts(badAmounts);
        info.setTakeBackAmounts(takeBackAmounts);
        info.setBadAcctCause(badAcctType == null ? null : BadAcctCause.getEnum(badAcctType));
        info.setBillID(billID);
        return info;
    }

    private BadAcctCollection getSelectedCollection() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null) {
            MsgBox.showInfo((String)this.getStrResource("no_select_data"));
            SysUtil.abort();
        }
        this.checkDataLock(selectBlock);
        BadAcctCollection badAcctCollection = new BadAcctCollection();
        for (int i = selectBlock.getTop(); i <= selectBlock.getEndRow(); ++i) {
            BadAcctInfo badAcctInfo = this.getSelectedInfo(i);
            badAcctCollection.add(badAcctInfo);
        }
        return badAcctCollection;
    }

    private List getSelectedIDList() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("no_select_data"));
            SysUtil.abort();
        }
        ArrayList<String> IDList = new ArrayList<String>();
        IRow row = null;
        if (selectBlock != null) {
            for (int i = selectBlock.getTop(); i <= selectBlock.getEndRow(); ++i) {
                row = this.tblMain.getRow(i);
                if (row.getCell(TB_ID).getValue() == null) continue;
                String ID = row.getCell(TB_ID).getValue().toString();
                IDList.add(ID);
            }
        }
        return IDList;
    }

    protected void verifyInput() {
        int rowCount = this.tblMain.getRowCount3();
        if (rowCount == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("no_data"));
            SysUtil.abort();
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        this.setButtonEnabled(true);
    }

    private boolean isNeedChecked() {
        boolean arIsRltdAccunt = false;
        boolean glIsStart = false;
        try {
            arIsRltdAccunt = ArClientUtils.arIsRelatedAccount(this.currentCompany);
            glIsStart = CommonClientUtils.glIsStart(this.currentCompany);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return arIsRltdAccunt && glIsStart;
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        this.btnRemove.setVisible(true);
        this.btnRemove.setEnabled(true);
        this.btnUnAudit.setVisible(true);
        this.btnUnAudit.setEnabled(true);
        this.btnVoucher.setVisible(true);
        this.btnVoucher.setEnabled(true);
        this.btnDelVoucher.setVisible(true);
        this.btnDelVoucher.setEnabled(true);
    }

    private void setButtonVisible(boolean visible) {
        this.actionAudit.setVisible(visible);
        this.actionUnAudit.setVisible(visible);
        this.btnVoucher.setVisible(visible);
        this.menuItemVoucher.setVisible(visible);
        this.btnEditVouchers.setVisible(visible);
        this.menuItemEditVouchers.setVisible(visible);
        this.btnDelVoucher.setVisible(visible);
        this.menuItemDelVoucher.setVisible(visible);
        this.btnViewVoucher.setVisible(visible);
        this.menuItemViewVoucher.setVisible(visible);
        this.btnWorkFlowG.setVisible(visible);
        this.separatorFW2.setVisible(visible);
        this.separatorFW3.setVisible(visible);
        this.separatorFW6.setVisible(visible);
        this.menuBiz.setVisible(visible);
        this.menuWorkFlow.setVisible(visible);
    }

    protected void setButtonEnabled(boolean enable) {
        this.actionRemove.setEnabled(true);
        this.actionAudit.setEnabled(true);
        this.actionUnAudit.setEnabled(true);
        this.actionVoucher.setEnabled(true);
        this.actionDelVoucher.setEnabled(true);
        this.actionViewVoucher.setEnabled(true);
    }

    private void isBadAcct() throws Exception {
        if (this.isInitBadAcct) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("init_badacct_no_function"));
            SysUtil.abort();
        }
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.setButtonVisible(!this.isInitBadAcct);
        this.setButtonEnabled(true);
    }

    private void checkDataLock(KDTSelectBlock selectBlock) {
        for (int i = selectBlock.getEndRow(); i >= selectBlock.getTop(); --i) {
            IRow row = this.tblMain.getRow(i);
            if (!row.getStyleAttributes().getBackground().equals(Color.decode("#E8E8E3"))) continue;
            MsgBox.showWarning((Component)((Object)this), (String)this.getStrResource("data_locked"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput();
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null) {
            MsgBox.showInfo((String)this.getStrResource("no_select_data"));
            SysUtil.abort();
        }
        this.checkDataLock(selectBlock);
        int value = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.common.EASCommonResource", (String)"confirmDelete"));
        if (value == 1 || value == 2) {
            SysUtil.abort();
        }
        ArrayList idList = this.getSelectedIdValues();
        Class[] clz = new Class[]{IObjectPK.class};
        ArApBatchUtil.batchOperaction((CoreUI)this, idList, this.getBizInterface(), this.getBOSEntity().getAlias(), this.btnRemove.getText(), "delete", clz);
        this.refreshList();
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.isInitBadAcct) {
            return;
        }
        this.verifyInput();
        this.isBadAcct();
        ArrayList idList = this.getSelectedIdValues();
        Class[] clz = new Class[]{String.class};
        ArApBatchUtil.batchOperaction((CoreUI)this, idList, this.getBizInterface(), this.getBOSEntity().getAlias(), this.btnAudit.getText(), "audit", clz);
        this.refreshList();
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.isInitBadAcct) {
            return;
        }
        this.verifyInput();
        this.isBadAcct();
        ArrayList idList = this.getSelectedIdValues();
        Class[] clz = new Class[]{String.class};
        ArApBatchUtil.batchOperaction((CoreUI)this, idList, this.getBizInterface(), this.getBOSEntity().getAlias(), this.btnUnAudit.getText(), "unAudit", clz);
        this.refreshList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        if (this.isInitBadAcct) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("voucher_failed"));
            return;
        }
        HashSet billIdSet = new HashSet(this.getSelectedIdValues());
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        ArrayList<String> requestIdList = new ArrayList<String>();
        try {
            String billId = null;
            boolean isLocked = false;
            Map result = iMutex.batchRequestBizObjIDForUpdate(new ArrayList(billIdSet));
            Iterator it = billIdSet.iterator();
            while (it.hasNext()) {
                billId = it.next().toString();
                if (result.get(billId) != null && ((Boolean)result.get(billId)).booleanValue()) {
                    requestIdList.add(billId);
                    continue;
                }
                isLocked = true;
            }
            if (isLocked) {
                throw new com.kingdee.eas.fi.ap.OtherBillBizException(com.kingdee.eas.fi.ap.OtherBillBizException.BILL_LOCKED);
            }
            super.actionVoucher_actionPerformed(e);
        }
        finally {
            if (requestIdList.size() > 0) {
                iMutex.batchReleaseObjIDForUpdate(requestIdList);
            }
        }
        this.refreshList();
    }

    public String getSelectedKeyNumber() {
        String keyFiledName = "number";
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        return BadAcctReferListUI.getSelectedKeyValue(selectRows, this.tblMain, keyFiledName);
    }

    public static String getSelectedKeyValue(int[] selectRows, KDTable table, String columnName) {
        StringBuffer numbers = new StringBuffer();
        int size = selectRows.length;
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                Object keyValue;
                int rowIndex = selectRows[i];
                IRow row = table.getRow(rowIndex);
                if (row == null) {
                    return null;
                }
                ICell cell = row.getCell(columnName);
                if (cell == null) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                    SysUtil.abort();
                }
                if ((keyValue = cell.getValue()) == null) continue;
                numbers.append(keyValue.toString());
                numbers.append(" ");
            }
        }
        return numbers.toString();
    }

    @Override
    public void actionEditVouchers_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        IRow row = this.tblMain.getRow(selectBlock.getTop());
        String billId = row.getCell(TB_ID).getValue().toString();
        ArrayList voucherColl = BotRelationUtil.getDestObjectIdByDestType(null, (String)billId, (String)new VoucherInfo().getBOSType().toString());
        if (voucherColl.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("VoucherCannotEdit"));
            SysUtil.abort();
        }
        IIDList voucherIDList = this.arrayList2IIDList(voucherColl);
        String voucherId = voucherColl.get(0).toString();
        UserInfo defaultUserInfo = null;
        if (defaultUserInfo == null) {
            defaultUserInfo = SysContext.getSysContext().getCurrentUserInfo();
        }
        if (defaultUserInfo == null || defaultUserInfo == null) {
            return;
        }
        boolean hasPermission = BaseDataUtil.checkEditVoucherPermission((IObjectPK)new ObjectUuidPK(defaultUserInfo.getId()), (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()), "", (IObjectPK)new ObjectUuidPK(voucherId));
        if (!hasPermission) {
            MsgBox.showInfo((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("NoPermissionCannotEdit"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)voucherId);
        uiContext.put((Object)"EDITRULE", (Object)"com.kingdee.eas.fi.gl.client.DefaultVoucherEditRule");
        uiContext.put((Object)"IDList", (Object)voucherIDList);
        String uiClass = "com.kingdee.eas.fi.gl.client.VoucherEditUI";
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)uiContext, null, OprtState.EDIT) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(uiClass, (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    private IIDList arrayList2IIDList(ArrayList al) {
        RealModeIDList List2 = RealModeIDList.getEmptyIDList();
        if (al != null && al.size() != 0) {
            for (int i = 0; i < al.size(); ++i) {
                List2.add(i, (String)al.get(i));
            }
        }
        return List2;
    }

    @Override
    public void actionViewVoucher_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock selectBlock;
        if (this.isInitBadAcct) {
            return;
        }
        if (!this.isNeedChecked()) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("gl_not_relation_or_start_viewVoucher"));
            SysUtil.abort();
        }
        if ((selectBlock = this.tblMain.getSelectManager().get()) == null || selectBlock.size() <= 0) {
            return;
        }
        IRow row = this.tblMain.getRow(selectBlock.getTop());
        String billId = row.getCell(TB_ID).getValue().toString();
        ArrayList voucherColl = BotRelationUtil.getDestObjectIdByDestType(null, (String)billId, (String)new VoucherInfo().getBOSType().toString());
        if (voucherColl.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("lab_novoucher_beview"));
            return;
        }
        String voucherId = voucherColl.get(0).toString();
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"ID", (Object)voucherId);
        ctx.put((Object)"EDITRULE", (Object)"com.kingdee.eas.fi.gl.client.DefaultVoucherEditRule");
        IUIWindow uiVerificationWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(VoucherInfo.getEditUIName(), (Map)ctx, null, OprtState.VIEW);
        uiVerificationWindow.show();
    }

    @Override
    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        if (this.isInitBadAcct) {
            return;
        }
        ArrayList list = this.getSelectedIdValues();
        ArApBatchUtil.requestPureMutex(list);
        try {
            super.actionDelVoucher_actionPerformed(e);
        }
        finally {
            ArApBatchUtil.releasePureMutex(list);
        }
    }

    private void isRelationGL() {
        if (!this.isNeedChecked()) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("gl_not_relation_or_start"));
            SysUtil.abort();
        }
    }

    protected boolean checkBeforeWindowClosing() {
        this.releaseLock();
        return super.checkBeforeWindowClosing();
    }

    protected void finalize() throws Throwable {
        this.releaseLock();
        super.finalize();
    }

    private void checkBadAcctDate(Date badAcctDate) throws EASBizException, BOSException {
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)this.currentCompany);
        Date beginDate = currPeriod.getBeginDate();
        if (badAcctDate.before(beginDate)) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getStrResource("badacct_operate_date_invalid"));
            SysUtil.abort();
        }
    }

    private IObjectPK beginLog(IObjectPK pk, String method, CoreBillBaseInfo coreBillBaseInfo, String methodDes) throws BOSException, EASBizException {
        String methodName = this.getStrResource(method);
        String instanceDeatil = coreBillBaseInfo.getNumber();
        return LogUtil.beginLog(null, (String)methodName, (BOSObjectType)coreBillBaseInfo.getBOSType(), (IObjectPK)pk, (String)instanceDeatil, (String)methodDes);
    }

    private void afterLog(IObjectPK pk) {
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    private String getStrResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)resKey);
    }

    public String getClientStrResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)key);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        String boID = this.getSelectedKeyValue();
        this.checkSelected();
        if (boID == null) {
            return;
        }
        boolean isAudit = this.checkBillAudit(boID);
        boolean isDelete = !isAudit;
        boolean isAMEdit = !isAudit;
        acm.showAttachmentListUIByBoID(boID, (Object)this, true, isDelete, isAMEdit);
    }

    public boolean checkBillAudit(String boID) throws EASBizException, BOSException, Exception {
        boolean isBillAudit = false;
        CoreBaseInfo obj = this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(boID));
        if (obj instanceof BadAcctInfo) {
            BadAcctInfo badAcctInfo = (BadAcctInfo)obj;
            if (null == badAcctInfo) {
                MsgBox.showInfo((String)this.getStrResource("select_bill_not_exist"));
                SysUtil.abort();
            }
            if (!this.isInitBadAcct && null != badAcctInfo.getAuditDate()) {
                isBillAudit = true;
            }
        }
        return isBillAudit;
    }

    @Override
    public void actionMultiPrint_actionPerformed(ActionEvent e) throws Exception {
        this.invokeMultiPrintFunction(true);
    }

    @Override
    public void actionMultiPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.invokeMultiPrintFunction(false);
    }

    protected void invokeMultiPrintFunction(boolean isPrint) {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        this.invokeMultiPrintFunction(idList, isPrint);
    }

    protected void invokeMultiPrintFunction(List idList, boolean isPrint) {
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        MultiDataSourceDataProviderProxy data = new MultiDataSourceDataProviderProxy();
        DefinitionNewDataProvider mainQueryData = new DefinitionNewDataProvider(idList, this.getTDQueryPK());
        data.putAbstractPrint("MainQuery", (AbstractPrintDataProvider)mainQueryData);
        SCMSlaveCommonDataProvider multiApproveViewQueryData = new SCMSlaveCommonDataProvider(idList, this.getMultiApproveViewQuery(), "billId");
        data.put("MultiApproveViewQuery", (BOSQueryDelegate)multiApproveViewQueryData);
        KDNoteHelper appHlp = new KDNoteHelper();
        BOSObjectType bosType = null;
        try {
            bosType = this.getBizInterface().getType();
        }
        catch (Exception e) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.PrintIntegrationResource", (String)"pi.remoteerror"));
            SysUtil.abort();
        }
        CommonPrintIntegrationDataProvider printQueryData = new CommonPrintIntegrationDataProvider(bosType.toString(), PrintIntegrationManager.getPrintQueryPK());
        data.put("PrintQuery", (BOSQueryDelegate)printQueryData);
        PrintIntegrationManager.initPrint((KDNoteHelper)appHlp, (BOSObjectType)bosType, (List)idList, (String)this.getTDFileName(), (String)"com.kingdee.eas.scm.common.SCMResource", (boolean)false);
        if (isPrint) {
            appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    protected String getTDFileName() {
        return "/FI/AR/BadAcct";
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fi.ar.app.BadAcctReferDailyQurey");
    }

    protected IMetaDataPK getMultiApproveViewQuery() {
        return new MetaDataPK("com.kingdee.eas.base.multiapprove.app.MultiApproveViewQuery");
    }
}

