/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.BadAccountFacadeFactory;
import com.kingdee.eas.fi.ar.BadAcctReportFacadeFactory;
import com.kingdee.eas.fi.ar.IBadAccountFacade;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.client.AbstractBadAcctReportUI;
import com.kingdee.eas.fi.ar.client.BadAcctStatisticReportQueryUI;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.ar.client.util.CommonClientUtils;
import com.kingdee.eas.fi.arap.client.util.ArApReportUIUtil;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;

public class BadAcctReportUI
extends AbstractBadAcctReportUI {
    protected static final String ArRpt_RESOURCE = "com.kingdee.eas.fi.ar.ArReport";
    protected static final String ORDER_NUMBER = "zzzzzzzzzzzzzzzzzzzz";
    protected static final Color SUB_TOTAL_COLOR = new Color(15789529);
    private CompanyOrgUnitInfo currentCompany = null;
    private int statisticObjectValue = 0;
    private IBadAccountFacade iBadAccountFacade = null;
    private boolean isPrepareCurrency = false;
    private CurrencyInfo localCurrency = null;
    private int localPrecision = 0;

    public BadAcctReportUI() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.enableExportExcel(this.tblMain);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return BadAcctReportFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return new BadAcctStatisticReportQueryUI();
    }

    protected void query() {
        this.tblMain.removeColumns();
        this.tblMain.removeRows();
    }

    public void onLoad() throws Exception {
        FMClientHelper.addSqlMenu((CoreUIObject)this, (KDMenu)this.menuTool);
        this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        ArApReportUIUtil.checkCompany((Component)((Object)this), this.currentCompany);
        this.localCurrency = CommonClientUtils.getCurrency(String.valueOf(this.currentCompany.getBaseCurrency().getId()));
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                BadAcctReportUI.this.tblMain_afterDataFill(e);
            }
        });
        super.onLoad();
        this.localPrecision = this.localCurrency.getPrecision();
        if (this.localPrecision == 0) {
            this.localPrecision = 2;
        }
        this.iBadAccountFacade = BadAccountFacadeFactory.getRemoteInstance();
        String accuralParam = this.iBadAccountFacade.getAccuralParam(this.currentCompany);
        boolean isCustomerAnalysis = accuralParam.equalsIgnoreCase(String.valueOf(5));
        boolean isBillAnalysis = accuralParam.equalsIgnoreCase(String.valueOf(6));
        if (!isCustomerAnalysis && !isBillAnalysis) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("customer_bill_analysis"));
            SysUtil.abort();
        }
        this.isPrepareCurrency = !CommonClientUtils.isDisplayLocalCurrency();
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    protected void initWorkButton() {
        try {
            if (ArClientUtils.getArStartPeriod(this.currentCompany) == null) {
                throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{this.currentCompany.getName() + this.getSystemEnumForOA().getAlias()});
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnPrint);
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.setButtonDefaultStyl(this.btnPrintPreview);
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.setButtonDefaultStyl(this.btnRefresh);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.setButtonDefaultStyl(this.btnQuery);
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
        try {
            RptParams rpt;
            int from = e.getFirstRow();
            int len = e.getLastRow() - from + 1;
            RptParams rptParams = new RptParams();
            rptParams.putAll(this.params.toMap());
            if (from == 0) {
                rptParams.setString("tempTable", this.getTempTable());
                rpt = this.getRemoteInstance().createTempTable(rptParams);
                this.setTempTable(rpt.getString("tempTable"));
                RptTableHeader rptTableHeader = (RptTableHeader)rpt.getObject("header");
                this.tblMain.removeHeadRows();
                KDTableUtil.setHeader((RptTableHeader)rptTableHeader, (KDTable)this.tblMain);
                this.tblMain.setRowCount(rpt.getInt("rowCount"));
            }
            rptParams.setString("tempTable", this.getTempTable());
            this.statisticObjectValue = Integer.parseInt(rptParams.getObject("statisticObject").toString());
            rpt = this.getRemoteInstance().query(rptParams, from, len);
            RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
            KDTableUtil.insertRows((RptRowSet)rs, (int)from, (KDTable)this.tblMain);
            this.setMainTableConfig();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private void tblMain_afterDataFill(KDTDataRequestEvent e) {
        this.changeData(e.getFirstRow(), e.getLastRow());
    }

    private void changeData(int fistRow, int lastRow) {
        for (int i = fistRow; i <= lastRow; ++i) {
            IRow row = this.tblMain.getRow(i);
            String currencyID = null;
            if (row.getCell("currencyID").getValue() != null) {
                currencyID = row.getCell("currencyID").getValue().toString();
            }
            String precision = this.getFormatString(currencyID);
            String currencyLocalFormat = this.getFormatString(this.localCurrency.getId().toString());
            if (this.isPrepareCurrency) {
                row.getCell("prepareAmount").getStyleAttributes().setNumberFormat(precision);
                row.getCell("badAmount").getStyleAttributes().setNumberFormat(precision);
                row.getCell("takeBackAmount").getStyleAttributes().setNumberFormat(precision);
            } else {
                row.getCell("prepareAmountLocal").getStyleAttributes().setNumberFormat(currencyLocalFormat);
                row.getCell("badAmountLocal").getStyleAttributes().setNumberFormat(currencyLocalFormat);
                row.getCell("takeBackAmountLocal").getStyleAttributes().setNumberFormat(currencyLocalFormat);
            }
            if (2 == this.statisticObjectValue) {
                String adminOrgNumber = null;
                if (row.getCell("adminOrgUnit").getValue() != null) {
                    adminOrgNumber = row.getCell("adminOrgUnit").getValue().toString();
                }
                if (!ORDER_NUMBER.equals(adminOrgNumber)) continue;
                row.getCell("currency").getStyleAttributes().setBackground(SUB_TOTAL_COLOR);
                row.getCell("adminOrgUnitNumber").getStyleAttributes().setBackground(SUB_TOTAL_COLOR);
                row.getCell("adminOrgUnit").getStyleAttributes().setBackground(SUB_TOTAL_COLOR);
                row.getCell("adminOrgUnitNumber").setValue(null);
                row.getCell("adminOrgUnit").setValue((Object)this.getArReportResource("Lbl_Sum"));
                if (this.isPrepareCurrency) {
                    row.getCell("prepareAmount").getStyleAttributes().setBackground(SUB_TOTAL_COLOR);
                    row.getCell("badAmount").getStyleAttributes().setBackground(SUB_TOTAL_COLOR);
                    row.getCell("takeBackAmount").getStyleAttributes().setBackground(SUB_TOTAL_COLOR);
                    continue;
                }
                row.getCell("prepareAmountLocal").getStyleAttributes().setBackground(SUB_TOTAL_COLOR);
                row.getCell("badAmountLocal").getStyleAttributes().setBackground(SUB_TOTAL_COLOR);
                row.getCell("takeBackAmountLocal").getStyleAttributes().setBackground(SUB_TOTAL_COLOR);
                continue;
            }
            String asstActNumber = null;
            if (row.getCell("asstActNumber").getValue() != null) {
                asstActNumber = row.getCell("asstActNumber").getValue().toString();
            }
            if (!ORDER_NUMBER.equals(asstActNumber)) continue;
            row.getCell("currency").getStyleAttributes().setBackground(SUB_TOTAL_COLOR);
            row.getCell("asstActNumber").getStyleAttributes().setBackground(SUB_TOTAL_COLOR);
            row.getCell("asstActName").getStyleAttributes().setBackground(SUB_TOTAL_COLOR);
            row.getCell("asstActName").setValue((Object)this.getArReportResource("Lbl_Sum"));
            row.getCell("asstActNumber").setValue(null);
            if (this.isPrepareCurrency) {
                row.getCell("prepareAmount").getStyleAttributes().setBackground(SUB_TOTAL_COLOR);
                row.getCell("badAmount").getStyleAttributes().setBackground(SUB_TOTAL_COLOR);
                row.getCell("takeBackAmount").getStyleAttributes().setBackground(SUB_TOTAL_COLOR);
                continue;
            }
            row.getCell("prepareAmountLocal").getStyleAttributes().setBackground(SUB_TOTAL_COLOR);
            row.getCell("badAmountLocal").getStyleAttributes().setBackground(SUB_TOTAL_COLOR);
            row.getCell("takeBackAmountLocal").getStyleAttributes().setBackground(SUB_TOTAL_COLOR);
        }
    }

    public void setMainTableConfig() {
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getGroupManager().group();
        this.tblMain.getColumn("currency").setGroup(true);
        this.tblMain.getColumn("currency").setMergeable(true);
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)ArRpt_RESOURCE, (String)"print_label_company")).append("&[Company]");
        sb.append("&|");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Company", SysContext.getSysContext().getCurrentFIUnit().getName());
        return map;
    }

    private CurrencyInfo getCurrency(String ID) {
        CurrencyInfo info = null;
        try {
            ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(ID);
            info = iCurrency.getCurrencyInfo((IObjectPK)pk);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return info;
    }

    private String getFormatString(String currencyID) {
        int precision = 0;
        if (currencyID == null) {
            precision = 2;
        } else {
            CurrencyInfo currencyInfo = this.getCurrency(currencyID);
            precision = currencyInfo.getPrecision();
        }
        if (precision == 0) {
            precision = 2;
        }
        return PrecisionFormatUtils.getFormatString(precision);
    }

    private String getStrResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)resKey);
    }

    private String getArReportResource(String resKey) {
        return EASResource.getString((String)ArRpt_RESOURCE, (String)resKey);
    }
}

