/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ap.VerificationEnum;
import com.kingdee.eas.fi.ar.AbstractOtherBillInfo;
import com.kingdee.eas.fi.ar.BadAcctCause;
import com.kingdee.eas.fi.ar.BadAcctFacadeFactory;
import com.kingdee.eas.fi.ar.BadAcctFactory;
import com.kingdee.eas.fi.ar.BadAcctInfo;
import com.kingdee.eas.fi.ar.BadAcctTakeBackCollection;
import com.kingdee.eas.fi.ar.BadAcctTakeBackFacadeFactory;
import com.kingdee.eas.fi.ar.BadAcctTakeBackFactory;
import com.kingdee.eas.fi.ar.BadAcctTakeBackInfo;
import com.kingdee.eas.fi.ar.BadAcctTypeInitOrNot;
import com.kingdee.eas.fi.ar.IBadAcct;
import com.kingdee.eas.fi.ar.IBadAcctFacade;
import com.kingdee.eas.fi.ar.IBadAcctTakeBackFacade;
import com.kingdee.eas.fi.ar.IOtherBill;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.VerificationBillInfo;
import com.kingdee.eas.fi.ar.VerificationBillentryInfo;
import com.kingdee.eas.fi.ar.client.AbstractBadAcctTakeBackListUI;
import com.kingdee.eas.fi.ar.client.BadAcctTakeBackQueryUI;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.client.util.CommonClientUtils;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.ReceivingBillEntryCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public class BadAcctTakeBackListUI
extends AbstractBadAcctTakeBackListUI {
    private CompanyOrgUnitInfo currentCompany = null;
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private static final String DATE_FORMAT = CtrlFormatUtilities.getDateFormatString();
    private boolean isSameCurrency = false;
    private BadAcctTakeBackQueryUI badAcctTakeBackQueryUI = null;
    private boolean isInitBadAcct = false;
    private UserInfo defaultUserInfo = null;
    private CurrencyInfo topCurrency = null;
    private CurrencyInfo bottomCurrency = null;
    private CurrencyInfo baseCurrency = null;
    private boolean isSameAsstAct = false;
    private boolean isSameCode = false;
    private List lockObjs = new ArrayList();
    private List IDList = null;
    private CurrencyInfo localCurrency = null;
    private int precision = 0;
    private CommonQueryDialog dialog = null;
    private PeriodInfo currPeriod = null;
    private IBadAcct iBadAcct = null;
    private boolean isGainAndLoss = false;
    private BigDecimal mainGainAndLoss = BaseDataUtil.ZERO;
    private IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
    protected ArApSysParamInfo cache = null;
    protected IArApBillFacade iBillFacade = ArApBillFacadeFactory.getRemoteInstance();

    public BadAcctTakeBackListUI() throws Exception {
        this.cache = new ArApSysParamInfo();
    }

    public void onLoad() throws Exception {
        if (this.defaultUserInfo == null) {
            this.defaultUserInfo = SysContext.getSysContext().getCurrentUserInfo();
        }
        try {
            this.currentCompany = BaseDataUtil.getCompanyInfo();
            this.baseCurrency = this.currentCompany.getBaseCurrency();
        }
        catch (Exception ex) {
            SysUtil.abort();
        }
        this.cache = this.iBillFacade.getSysParams(this.currentCompany, this.getUIParam());
        this.currPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)this.currentCompany);
        this.localCurrency = this.currentCompany.getBaseCurrency();
        this.precision = this.localCurrency.getPrecision();
        if (this.precision == 0) {
            this.precision = 2;
        }
        this.initBadAcctProp();
        this.initTblMainProp();
        this.iBadAcct = BadAcctFactory.getRemoteInstance();
        super.onLoad();
        this.recTotal.setRoundingMode(4);
        this.recTotalLocal.setRoundingMode(4);
        this.badAcctTotal.setRoundingMode(4);
        this.badAcctTotalLocal.setRoundingMode(4);
        this.badAcctTotalLocal.setValue((Object)BaseDataUtil.ZERO);
        this.badAcctTotalLocal.setPrecision(this.precision);
        this.badAcctTotalLocal.setHorizontalAlignment(4);
        this.badAcctTotalLocal.setRemoveingZeroInDispaly(false);
        this.recTotalLocal.setValue((Object)BaseDataUtil.ZERO);
        this.recTotalLocal.setPrecision(this.precision);
        this.recTotalLocal.setRemoveingZeroInDispaly(false);
        this.recTotalLocal.setHorizontalAlignment(4);
        this.kDBizPromptCompany.setData((Object)this.currentCompany);
        this.kDBizPromptCompany.setEnabled(false);
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnVerify.setIcon(EASResource.getIcon((String)"imgTbtn_handworkcollate"));
        this.btnVerify.setEnabled(true);
        this.btnUnVerify.setVisible(false);
        this.btnUnVerify.setIcon(EASResource.getIcon((String)"imgTbtn_handworkcollate"));
        this.btnVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_scvoucher"));
        this.btnVoucher.setEnabled(true);
        this.btnDelVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_deletecredence"));
        this.btnDelVoucher.setEnabled(true);
        this.btnSelectAll.setVisible(false);
        this.btnSelectNone.setVisible(false);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnSelectNone.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnAttachment.setVisible(true);
        this.actionAttachment.setVisible(true);
        boolean apIsRltdAccunt = ArClientUtils.arIsRelatedAccount(this.currentCompany);
        if (!apIsRltdAccunt) {
            this.actionVoucher.setVisible(false);
            this.actionDelVoucher.setVisible(false);
            this.kDMenu1.setVisible(false);
            this.separatorFW2.setVisible(false);
        } else {
            this.separatorFW2.setVisible(true);
        }
    }

    protected SystemEnum getSysEnum() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    protected HashMap getUIParam() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sysEnum", this.getSysEnum());
        map.put("isSCM", Boolean.FALSE);
        map.put("isInit", Boolean.FALSE);
        map.put("isBadAcctLoss", Boolean.TRUE);
        return map;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return null;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemVerify.setIcon(EASResource.getIcon((String)"imgTbtn_handworkcollate"));
        this.menuItemVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_scvoucher"));
        this.menuItemDelVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_deletecredence"));
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BadAcctTakeBackFactory.getRemoteInstance();
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                BadAcctTakeBackListUI.this.tblMain_afterDataFill(e);
            }
        });
    }

    private String getExchangeRatePrecision(CurrencyInfo currency) {
        int precision = 0;
        if (currency.getId().equals((Object)this.baseCurrency.getId())) {
            precision = 0;
        } else {
            ExchangeRateInfo rateInfo = null;
            try {
                rateInfo = BaseDataUtil.getExchangeRate(this.currentCompany, currency);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            if (rateInfo != null) {
                precision = rateInfo.getPrecision();
            }
        }
        return PrecisionFormatUtils.getFormatString(precision);
    }

    private void initTblMainProp() {
        KDCheckBox checkBox = new KDCheckBox();
        KDTDefaultCellEditor check_CellEditor = new KDTDefaultCellEditor((JCheckBox)checkBox);
        KDFormattedTextField floatDrawing = new KDFormattedTextField((Object)new BigDecimal(String.valueOf("0.0")));
        KDTDefaultCellEditor floatDrawingCellEditor = new KDTDefaultCellEditor((JTextField)floatDrawing);
        this.tblMain.checkParsed();
        this.tblMain.getColumn("checkbox").setEditor((ICellEditor)check_CellEditor);
        this.tblMain.getColumn("checkbox").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("exchangeRate").setEditor((ICellEditor)floatDrawingCellEditor);
        this.tblMain.getColumn("exchangeRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("entries.amount").setEditor((ICellEditor)floatDrawingCellEditor);
        this.tblMain.getColumn("entries.amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("entries.localAmt").setEditor((ICellEditor)floatDrawingCellEditor);
        this.tblMain.getColumn("entries.localAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("entries.amountVc").setEditor((ICellEditor)floatDrawingCellEditor);
        this.tblMain.getColumn("entries.amountVc").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("entries.localAmtVc").setEditor((ICellEditor)floatDrawingCellEditor);
        this.tblMain.getColumn("entries.localAmtVc").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("entries.unVcAmount").setEditor((ICellEditor)floatDrawingCellEditor);
        this.tblMain.getColumn("entries.unVcAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("entries.unVcLocAmount").setEditor((ICellEditor)floatDrawingCellEditor);
        this.tblMain.getColumn("entries.unVcLocAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("entries.unLockAmt").setEditor((ICellEditor)floatDrawingCellEditor);
        this.tblMain.getColumn("entries.unLockAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("entries.unLockLocAmt").setEditor((ICellEditor)floatDrawingCellEditor);
        this.tblMain.getColumn("entries.unLockLocAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("receiveSettleAmt").setEditor((ICellEditor)floatDrawingCellEditor);
        this.tblMain.getColumn("receiveSettleAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("receiveSettleAmt").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("localReceiveSettleAmt").setEditor((ICellEditor)floatDrawingCellEditor);
        this.tblMain.getColumn("localReceiveSettleAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("localReceiveSettleAmt").getStyleAttributes().setBackground(new Color(192, 192, 192));
        this.tblMain.getColumn("localReceiveSettleAmt").getStyleAttributes().setLocked(true);
    }

    private void initBadAcctProp() {
        KDCheckBox checkBox = new KDCheckBox();
        KDTDefaultCellEditor check_CellEditor = new KDTDefaultCellEditor((JCheckBox)checkBox);
        KDFormattedTextField floatDrawing = new KDFormattedTextField((Object)SysConstant.BIGZERO);
        floatDrawing.setPrecision(this.precision);
        KDTDefaultCellEditor floatDrawingCellEditor = new KDTDefaultCellEditor((JTextField)floatDrawing);
        this.tblBadAcct.checkParsed();
        this.tblBadAcct.getColumn("checkbox").setEditor((ICellEditor)check_CellEditor);
        this.tblBadAcct.getColumn("checkbox").getStyleAttributes().setLocked(false);
        this.tblBadAcct.getColumn("badAmounts").setEditor((ICellEditor)floatDrawingCellEditor);
        this.tblBadAcct.getColumn("takeBackMounts").setEditor((ICellEditor)floatDrawingCellEditor);
        this.tblBadAcct.getColumn("thisTotalAmount").setEditor((ICellEditor)floatDrawingCellEditor);
        this.tblBadAcct.getColumn("localThisTotalAmount").setEditor((ICellEditor)floatDrawingCellEditor);
        this.tblBadAcct.getColumn("exchangeRate").setEditor((ICellEditor)floatDrawingCellEditor);
        this.tblBadAcct.getColumn("badAmounts").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblBadAcct.getColumn("exchangeRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblBadAcct.getColumn("takeBackMounts").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblBadAcct.getColumn("thisTotalAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblBadAcct.getColumn("thisTotalAmount").getStyleAttributes().setLocked(false);
        this.tblBadAcct.getColumn("localThisTotalAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblBadAcct.getColumn("localThisTotalAmount").getStyleAttributes().setBackground(new Color(192, 192, 192));
        this.tblBadAcct.getColumn("localThisTotalAmount").getStyleAttributes().setLocked(true);
        this.tblBadAcct.getColumn("badAcctDate").getStyleAttributes().setNumberFormat(DATE_FORMAT);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.dialog == null) {
            this.dialog = new CommonQueryDialog();
            this.dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            this.dialog.setShowFilter(false);
            this.dialog.setShowSorter(false);
            this.dialog.setQueryObjectPK(this.mainQueryPK);
            this.dialog.addUserPanel((KDPanel)new BadAcctTakeBackQueryUI());
            this.dialog.setHeight(290);
            this.dialog.setWidth(560);
            this.dialog.setTitle(this.getStrResource("bad_acct_take_back_query_condition"));
            this.dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        }
        if (this.dialog.show()) {
            this.badAcctTakeBackQueryUI = (BadAcctTakeBackQueryUI)this.dialog.getUserPanel(0);
            this.badAcctTakeBackQueryUI.getFilterInfo();
            EntityViewInfo view = this.badAcctTakeBackQueryUI.view;
            SorterItemCollection sorterItem = new SorterItemCollection();
            sorterItem.add(new SorterItemInfo("bizdate"));
            sorterItem.add(new SorterItemInfo("number"));
            sorterItem.add(new SorterItemInfo("entries.seq"));
            view.setSorter(sorterItem);
            this.mainQuery = view;
            this.refreshList();
            this.isSameCurrency = this.badAcctTakeBackQueryUI.isSameCurrency;
            this.isInitBadAcct = this.badAcctTakeBackQueryUI.isInitBadAcct;
            this.topCurrency = this.badAcctTakeBackQueryUI.topCurrency;
            this.bottomCurrency = this.badAcctTakeBackQueryUI.bottomCurrency;
            this.isSameAsstAct = this.badAcctTakeBackQueryUI.isSameAsstAct;
            this.isSameCode = this.badAcctTakeBackQueryUI.isSameCode;
            this.insertBadAcctData(this.badAcctTakeBackQueryUI.badAcctSQL.toString(), this.isInitBadAcct);
            this.setNumberFormat();
        } else {
            SysUtil.abort();
        }
    }

    public void refreshList() throws Exception {
        this.releaseLock();
        super.refreshList();
        this.badAcctTotal.setValue((Object)BaseDataUtil.ZERO);
        this.badAcctTotalLocal.setValue((Object)BaseDataUtil.ZERO);
        this.recTotal.setValue((Object)BaseDataUtil.ZERO);
        this.recTotalLocal.setValue((Object)BaseDataUtil.ZERO);
    }

    protected void execQuery() {
        super.execQuery();
        this.tblMain.getSelectManager().removeAll();
    }

    private void insertBadAcctData(String filter, boolean isInitBadAcct) throws Exception {
        IMutexServiceControl mutex = MutexServiceControlFactory.getRemoteInstance();
        IRowSet rowSet = null;
        IBadAcctFacade iBadAcctFacade = BadAcctFacadeFactory.getRemoteInstance();
        rowSet = iBadAcctFacade.getBadAcct(filter, isInitBadAcct);
        IRow row = null;
        BadAcctTypeInitOrNot badAcctType = null;
        this.tblBadAcct.removeRows();
        Object exchangeRate = null;
        int topPrecision = 0;
        if (!this.topCurrency.equals((Object)this.localCurrency)) {
            topPrecision = this.topCurrency.getPrecision();
        }
        if (topPrecision == 0) {
            topPrecision = this.precision;
        }
        this.badAcctTotal.setValue((Object)BaseDataUtil.ZERO);
        this.badAcctTotal.setPrecision(topPrecision);
        this.badAcctTotal.setHorizontalAlignment(4);
        this.badAcctTotal.setRemoveingZeroInDispaly(false);
        while (rowSet.next()) {
            row = this.tblBadAcct.addRow();
            row.getCell("checkbox").setValue((Object)Boolean.FALSE);
            row.getCell("badAcctID").setValue((Object)rowSet.getString("FID"));
            row.getCell("number").setValue((Object)rowSet.getString("FNumber"));
            row.getCell("accountID").setValue((Object)rowSet.getString("FAccountID"));
            row.getCell("badAcctType").setValue((Object)rowSet.getString("FBadAcctType"));
            badAcctType = BadAcctTypeInitOrNot.getEnum(rowSet.getInt("FBadAcctType"));
            row.getCell("badAcctTypeDes").setValue((Object)badAcctType.getAlias());
            row.getCell("badAcctDate").setValue((Object)rowSet.getString("FBadAcctDate"));
            row.getCell("badAcctNote").setValue((Object)BadAcctCause.getEnum(rowSet.getString("FBadAcctNote")));
            row.getCell("companyID").setValue((Object)rowSet.getString("FCompanyID"));
            row.getCell("company").setValue((Object)rowSet.getString("FCompany"));
            row.getCell("personID").setValue((Object)rowSet.getString("FPersonID"));
            row.getCell("person").setValue((Object)rowSet.getString("FPerson"));
            row.getCell("adminOrgUnitID").setValue((Object)rowSet.getString("FAdminOrgUnitID"));
            row.getCell("adminOrgUnit").setValue((Object)rowSet.getString("FAdminOrgUnit"));
            row.getCell("asstAcctTypeID").setValue((Object)rowSet.getString("FAsstAcctTypeID"));
            row.getCell("asstAcctType").setValue((Object)rowSet.getString("FAsstAcctType"));
            row.getCell("asstAcctID").setValue((Object)rowSet.getString("FAsstAcctID"));
            row.getCell("asstAcct").setValue((Object)rowSet.getString("FAsstAcct"));
            row.getCell("currencyID").setValue((Object)rowSet.getString("FCurrencyID"));
            row.getCell("currency").setValue((Object)rowSet.getString("FCurrency"));
            row.getCell("exchangeRate").setValue((Object)rowSet.getString("FExchangeRate"));
            row.getCell("billNumber").setValue((Object)rowSet.getString("FBillNumber"));
            row.getCell("badAmounts").setValue((Object)rowSet.getBigDecimal("FBadAmounts"));
            row.getCell("takeBackMounts").setValue((Object)rowSet.getBigDecimal("FTakeBackMounts"));
            row.getCell("noTakeBackMounts").setValue((Object)rowSet.getBigDecimal("FNoTakeBackMounts"));
            row.getCell("localNoTakeBackMounts").setValue((Object)rowSet.getBigDecimal("FLocalNoTakeBackMounts"));
            String billID = row.getCell("badAcctID").getValue().toString();
            if (this.lockObjs.contains(billID)) continue;
            if (mutex.requestObjIDForUpdate(billID, this.defaultUserInfo.getString("id"))) {
                this.lockObjs.add(billID);
                continue;
            }
            row.setUserObject((Object)"locked");
            row.getStyleAttributes().setLocked(true);
            row.getCell("checkbox").getStyleAttributes().setLocked(true);
            row.getCell("thisTotalAmount").getStyleAttributes().setLocked(true);
            row.getStyleAttributes().setBackground(Color.decode("#E8E8E3"));
        }
    }

    private void tblMain_afterDataFill(KDTDataRequestEvent e) {
        IRow row = null;
        int size = e.getLastRow();
        for (int i = e.getFirstRow(); i <= size; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell("checkbox").getValue() != null) continue;
            row.getCell("checkbox").setValue((Object)Boolean.FALSE);
        }
        this.changeData(e.getFirstRow(), e.getLastRow());
    }

    private void changeData(int beginRow, int endRow) {
        IMutexServiceControl mutex = MutexServiceControlFactory.getRemoteInstance();
        IRow row = null;
        try {
            for (int i = beginRow; i <= endRow; ++i) {
                row = this.tblMain.getRow(i);
                String billID = row.getCell("id").getValue().toString();
                if (!this.lockObjs.contains(billID)) {
                    if (mutex.requestObjIDForUpdate(billID, this.defaultUserInfo.getString("id"))) {
                        this.lockObjs.add(billID);
                        row.getCell("receiveSettleAmt").getStyleAttributes().setLocked(true);
                        row.getCell("checkbox").getStyleAttributes().setLocked(false);
                        continue;
                    }
                    row.setUserObject((Object)"locked");
                    row.getCell("checkbox").getStyleAttributes().setLocked(true);
                    row.getStyleAttributes().setBackground(Color.decode("#E8E8E3"));
                    continue;
                }
                row.getCell("receiveSettleAmt").getStyleAttributes().setLocked(true);
                row.getCell("checkbox").getStyleAttributes().setLocked(false);
            }
        }
        catch (Exception err) {
            this.handleException(err);
        }
    }

    private void releaseLock() {
        IMutexServiceControl mutex = MutexServiceControlFactory.getRemoteInstance();
        int iCount = this.lockObjs.size();
        for (int i = 0; i < iCount; ++i) {
            mutex.releaseObjIDForUpdate(this.lockObjs.get(i).toString());
        }
        this.lockObjs.clear();
    }

    public static void show(Object owner) throws UIException {
        UIContext cntxt = new UIContext(owner);
        String className = BadAcctTakeBackListUI.class.getName();
        IUIWindow uiWindowNew = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(className, (Map)cntxt);
        uiWindowNew.show();
    }

    public void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            this.tblMain.getSelectManager().setSelectMode(4);
        } else if (e.getColIndex() > 0) {
            this.tblMain.getSelectManager().setSelectMode(1);
        } else {
            this.tblMain.getSelectManager().setSelectMode(2);
        }
    }

    private void setNumberFormat() throws EASBizException, BOSException {
        int bottomPrecision = this.bottomCurrency.getPrecision();
        if (bottomPrecision == 0) {
            bottomPrecision = this.precision;
        }
        this.recTotal.setValue((Object)BaseDataUtil.ZERO);
        this.recTotal.setPrecision(bottomPrecision);
        this.recTotal.setHorizontalAlignment(4);
        this.recTotal.setRemoveingZeroInDispaly(false);
        String bottomCurrencyFormat = PrecisionFormatUtils.getFormatString(this.bottomCurrency);
        String bottomCurrencyLocalFormat = PrecisionFormatUtils.getFormatString(this.cache.getBaseCurrency());
        this.tblMain.getColumn("exchangeRate").getStyleAttributes().setNumberFormat(this.getExchangeRatePrecision(this.bottomCurrency));
        this.tblMain.getColumn("entries.amount").getStyleAttributes().setNumberFormat(bottomCurrencyFormat.toString());
        this.tblMain.getColumn("entries.localAmt").getStyleAttributes().setNumberFormat(bottomCurrencyLocalFormat.toString());
        this.tblMain.getColumn("entries.amountVc").getStyleAttributes().setNumberFormat(bottomCurrencyFormat.toString());
        this.tblMain.getColumn("entries.localAmtVc").getStyleAttributes().setNumberFormat(bottomCurrencyLocalFormat.toString());
        this.tblMain.getColumn("entries.unVcAmount").getStyleAttributes().setNumberFormat(bottomCurrencyFormat.toString());
        this.tblMain.getColumn("entries.unVcLocAmount").getStyleAttributes().setNumberFormat(bottomCurrencyLocalFormat.toString());
        this.tblMain.getColumn("entries.unLockAmt").getStyleAttributes().setNumberFormat(bottomCurrencyFormat.toString());
        this.tblMain.getColumn("entries.unLockLocAmt").getStyleAttributes().setNumberFormat(bottomCurrencyLocalFormat.toString());
        this.tblMain.getColumn("receiveSettleAmt").getStyleAttributes().setNumberFormat(bottomCurrencyFormat.toString());
        this.tblMain.getColumn("localReceiveSettleAmt").getStyleAttributes().setNumberFormat(bottomCurrencyLocalFormat.toString());
        String topCurrencyFormat = PrecisionFormatUtils.getFormatString(this.topCurrency);
        String topCurrencyLocalFormat = PrecisionFormatUtils.getFormatString(this.cache.getBaseCurrency());
        this.tblBadAcct.getColumn("badAmounts").getStyleAttributes().setNumberFormat(topCurrencyFormat.toString());
        this.tblBadAcct.getColumn("exchangeRate").getStyleAttributes().setNumberFormat(this.getExchangeRatePrecision(this.topCurrency));
        this.tblBadAcct.getColumn("takeBackMounts").getStyleAttributes().setNumberFormat(topCurrencyFormat.toString());
        this.tblBadAcct.getColumn("thisTotalAmount").getStyleAttributes().setNumberFormat(topCurrencyFormat.toString());
        this.tblBadAcct.getColumn("localThisTotalAmount").getStyleAttributes().setNumberFormat(topCurrencyLocalFormat.toString());
    }

    @Override
    public void tblBadAcct_editStopped(KDTEditEvent e) throws Exception {
        super.tblBadAcct_editStopped(e);
        if (this.tblBadAcct.getColumn("thisTotalAmount").getColumnIndex() == e.getColIndex()) {
            IRow row = this.tblBadAcct.getRow(e.getRowIndex());
            this.checkBadAcctData(row);
            this.caculateBadAcctTotal();
        }
    }

    @Override
    public void tblBadAcct_tableClicked(KDTMouseEvent e) {
    }

    @Override
    public void tblBadAcct_editValueChanged(KDTEditEvent e) throws Exception {
        if (this.tblBadAcct.getColumn("checkbox").getColumnIndex() == e.getColIndex()) {
            this.tblBadAcct.getRow(e.getRowIndex()).getCell(e.getColIndex()).setValue(e.getValue());
            IRow row = this.tblBadAcct.getRow(e.getRowIndex());
            Boolean selected = (Boolean)e.getValue();
            String billId = row.getCell("badAcctID").getValue().toString();
            IRow billRow = null;
            if (Boolean.TRUE.equals(selected)) {
                for (int i = 0; i < this.tblBadAcct.getRowCount3(); ++i) {
                    billRow = this.tblBadAcct.getRow(i);
                    if (!billRow.getCell("badAcctID").getValue().equals(billId)) continue;
                    billRow.getCell("checkbox").setValue((Object)Boolean.TRUE);
                    if (row.getCell("thisTotalAmount").getValue() == null) {
                        row.getCell("thisTotalAmount").setValue((Object)((BigDecimal)row.getCell("noTakeBackMounts").getValue()));
                    }
                    if (row.getCell("localThisTotalAmount").getValue() != null) continue;
                    row.getCell("localThisTotalAmount").setValue((Object)((BigDecimal)row.getCell("localNoTakeBackMounts").getValue()));
                }
            } else {
                for (int i = 0; i < this.tblBadAcct.getRowCount3(); ++i) {
                    billRow = this.tblBadAcct.getRow(i);
                    if (!billRow.getCell("badAcctID").getValue().equals(billId)) continue;
                    billRow.getCell("checkbox").setValue((Object)Boolean.FALSE);
                }
            }
            this.caculateBadAcctTotal();
        }
    }

    @Override
    public void tblMain_editValueChanged(KDTEditEvent e) throws Exception {
        if (this.tblMain.getColumn("checkbox").getColumnIndex() == e.getColIndex()) {
            boolean isDirectExchange = true;
            this.tblMain.getRow(e.getRowIndex()).getCell(e.getColIndex()).setValue(e.getValue());
            IRow row = this.tblMain.getRow(e.getRowIndex());
            Boolean selected = (Boolean)e.getValue();
            String billId = row.getCell("id").getValue().toString();
            IRow billRow = null;
            if (Boolean.TRUE.equals(selected)) {
                for (int i = 0; i < this.tblMain.getRowCount3(); ++i) {
                    billRow = this.tblMain.getRow(i);
                    if (!billRow.getCell("id").getValue().equals(billId)) continue;
                    billRow.getCell("checkbox").setValue((Object)Boolean.TRUE);
                    BigDecimal exchangeRate = new BigDecimal(billRow.getCell("exchangeRate").getValue().toString());
                    if (billRow.getCell("receiveSettleAmt").getValue() == null) {
                        billRow.getCell("receiveSettleAmt").setValue((Object)((BigDecimal)billRow.getCell("entries.unLockAmt").getValue()));
                    }
                    if (billRow.getCell("localReceiveSettleAmt").getValue() != null) continue;
                    isDirectExchange = this.getExgRateInfo(billRow, this.bottomCurrency);
                    if (isDirectExchange) {
                        billRow.getCell("localReceiveSettleAmt").setValue((Object)((BigDecimal)billRow.getCell("receiveSettleAmt").getValue()).multiply(exchangeRate).divide(new BigDecimal("1.0"), this.precision, 4));
                        continue;
                    }
                    if (exchangeRate.compareTo(ZERO) != 0) {
                        billRow.getCell("localReceiveSettleAmt").setValue((Object)((BigDecimal)billRow.getCell("receiveSettleAmt").getValue()).divide(exchangeRate, this.cache.getBaseCurrency().getPrecision(), 4));
                        continue;
                    }
                    billRow.getCell("localReceiveSettleAmt").setValue((Object)((BigDecimal)billRow.getCell("receiveSettleAmt").getValue()));
                }
            } else {
                for (int i = 0; i < this.tblMain.getRowCount3(); ++i) {
                    billRow = this.tblMain.getRow(i);
                    if (!billRow.getCell("id").getValue().equals(billId)) continue;
                    billRow.getCell("checkbox").setValue((Object)Boolean.FALSE);
                    billRow.getCell("receiveSettleAmt").setValue(null);
                    billRow.getCell("localReceiveSettleAmt").setValue(null);
                }
            }
            this.caculateRecTotal();
        }
    }

    private void caculateBadAcctTotal() {
        BigDecimal amount = BaseDataUtil.ZERO;
        BigDecimal amountLoc = BaseDataUtil.ZERO;
        BigDecimal tmpAmt = BaseDataUtil.ZERO;
        BigDecimal tmpAmtLoc = BaseDataUtil.ZERO;
        IRow row = null;
        for (int i = 0; i < this.tblBadAcct.getRowCount3(); ++i) {
            row = this.tblBadAcct.getRow(i);
            if (!row.getCell("checkbox").getValue().equals(Boolean.TRUE)) continue;
            if (row.getCell("thisTotalAmount").getValue() != null) {
                tmpAmt = new BigDecimal(row.getCell("thisTotalAmount").getValue().toString());
            }
            if (row.getCell("localThisTotalAmount").getValue() != null) {
                tmpAmtLoc = new BigDecimal(row.getCell("localThisTotalAmount").getValue().toString());
            }
            amount = amount.add(tmpAmt);
            amountLoc = amountLoc.add(tmpAmtLoc);
        }
        this.badAcctTotal.setValue((Object)amount);
        this.badAcctTotalLocal.setValue((Object)amountLoc);
    }

    public boolean getExgRateInfo(IRow row, CurrencyInfo currencyInfo) throws Exception {
        ExchangeRateInfo exgRateInfo = null;
        boolean isDirectExchange = true;
        exgRateInfo = this.getExgRateInfo(currencyInfo, new Date());
        if (exgRateInfo != null) {
            isDirectExchange = exgRateInfo.getExchangeAux() != null && ConvertModeEnum.DIRECTEXCHANGERATE.equals((Object)exgRateInfo.getExchangeAux().getConvertMode());
        }
        return isDirectExchange;
    }

    protected ExchangeRateInfo getExgRateInfo(CurrencyInfo currency, Date billDate) throws EASBizException, BOSException {
        if (!ArApBillHelper.idEquals((CoreBaseInfo)currency, (CoreBaseInfo)this.cache.getBaseCurrency())) {
            return BaseDataUtil.getExchangeRate(this.cache.getCompany(), currency, billDate);
        }
        return null;
    }

    private void caculateRecTotal() {
        BigDecimal amount = BaseDataUtil.ZERO;
        BigDecimal amountLoc = BaseDataUtil.ZERO;
        BigDecimal tmpAmt = BaseDataUtil.ZERO;
        BigDecimal tmpAmtLoc = BaseDataUtil.ZERO;
        IRow row = null;
        for (int i = 0; i < this.tblMain.getRowCount3(); ++i) {
            row = this.tblMain.getRow(i);
            if (!row.getCell("checkbox").getValue().equals(Boolean.TRUE)) continue;
            if (row.getCell("receiveSettleAmt").getValue() != null) {
                tmpAmt = new BigDecimal(row.getCell("receiveSettleAmt").getValue().toString());
            }
            if (row.getCell("localReceiveSettleAmt").getValue() != null) {
                tmpAmtLoc = new BigDecimal(row.getCell("localReceiveSettleAmt").getValue().toString());
            }
            amount = amount.add(tmpAmt);
            amountLoc = amountLoc.add(tmpAmtLoc);
        }
        this.recTotal.setValue((Object)amount);
        this.recTotalLocal.setValue((Object)amountLoc);
    }

    @Override
    public void tblMain_editStopped(KDTEditEvent e) throws Exception {
        super.tblMain_editStopped(e);
        if (this.tblMain.getColumn("receiveSettleAmt").getColumnIndex() == e.getColIndex()) {
            IRow row = this.tblMain.getRow(e.getRowIndex());
            this.checkReceivingBillData(row);
            this.caculateRecTotal();
        }
    }

    private BadAcctTakeBackCollection getSelectedCollection() throws Exception {
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getRemoteInstance();
        BadAcctTakeBackCollection badAcctTakeBackCollection = new BadAcctTakeBackCollection();
        IRow row = null;
        ObjectUuidPK companyPK = null;
        BigDecimal thisTotalAmount = null;
        int size = this.tblBadAcct.getRowCount3();
        for (int i = 0; i < size; ++i) {
            row = this.tblBadAcct.getRow(i);
            if (!row.getCell("checkbox").getValue().toString().equalsIgnoreCase("true")) continue;
            thisTotalAmount = (BigDecimal)row.getCell("thisTotalAmount").getValue();
            BigDecimal bigDecimal = thisTotalAmount = thisTotalAmount == null ? new BigDecimal("0.00") : thisTotalAmount;
            if (thisTotalAmount.compareTo(SysConstant.BIGZERO) <= 0) continue;
            BadAcctTakeBackInfo info = new BadAcctTakeBackInfo();
            companyPK = new ObjectUuidPK(row.getCell("companyID").getValue().toString());
            info.setCompany(iCompany.getCompanyOrgUnitInfo((IObjectPK)companyPK));
            badAcctTakeBackCollection.add(info);
        }
        return badAcctTakeBackCollection;
    }

    private ReceivingBillEntryCollection getSelectedReceivingBillEntryCollection() throws Exception {
        ReceivingBillEntryCollection entryCollection = new ReceivingBillEntryCollection();
        IRow row = null;
        int size = this.tblMain.getRowCount3();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            if (!row.getCell("checkbox").getValue().toString().equalsIgnoreCase("true")) continue;
            ReceivingBillEntryInfo info = new ReceivingBillEntryInfo();
            info.setId(BOSUuid.read((String)row.getCell("entries.id").getValue().toString()));
            info.setSeq(Integer.parseInt(row.getCell("entries.seq").getValue().toString()));
            info.setAmountVc((BigDecimal)row.getCell("receiveSettleAmt").getValue());
            info.setLocalAmtVc((BigDecimal)row.getCell("localReceiveSettleAmt").getValue());
            entryCollection.add(info);
        }
        return entryCollection;
    }

    private void checkBadAcctData(IRow row) {
        boolean isDirectExchange = true;
        if (row.getCell("thisTotalAmount").getValue() != null) {
            BigDecimal noTakeBackMounts;
            BigDecimal thisTotalAmount = (BigDecimal)row.getCell("thisTotalAmount").getValue();
            if (thisTotalAmount.compareTo(new BigDecimal("0.0")) < 0) {
                MsgBox.showInfo((String)this.getStrResource("this_bigger_zero"));
                row.getCell("thisTotalAmount").setValue((Object)new BigDecimal("0.0"));
                SysUtil.abort();
            }
            if (thisTotalAmount.compareTo(noTakeBackMounts = (BigDecimal)row.getCell("noTakeBackMounts").getValue()) > 0) {
                MsgBox.showInfo((String)this.getStrResource("this_bigger_total"));
                row.getCell("thisTotalAmount").setValue((Object)new BigDecimal("0.0"));
                SysUtil.abort();
            }
            BigDecimal exchangeRate = new BigDecimal(row.getCell("exchangeRate").getValue().toString());
            try {
                isDirectExchange = this.getExgRateInfo(row, this.topCurrency);
                if (isDirectExchange) {
                    row.getCell("localThisTotalAmount").setValue((Object)thisTotalAmount.multiply(exchangeRate).divide(new BigDecimal("1.0"), this.precision, 4));
                } else if (SysConstant.BIGZERO.compareTo(exchangeRate) != 0) {
                    row.getCell("localThisTotalAmount").setValue((Object)thisTotalAmount.divide(exchangeRate, this.cache.getBaseCurrency().getPrecision(), 4));
                } else {
                    row.getCell("localThisTotalAmount").setValue((Object)thisTotalAmount.multiply(exchangeRate).setScale(this.cache.getBaseCurrency().getPrecision(), 4));
                }
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
        }
    }

    private void checkReceivingBillData(IRow row) {
        boolean isDirectExchange = true;
        if (row.getCell("receiveSettleAmt").getValue() != null) {
            BigDecimal unLockAmt;
            BigDecimal receiveSettleAmt = (BigDecimal)row.getCell("receiveSettleAmt").getValue();
            if (receiveSettleAmt.compareTo(new BigDecimal("0.0")) < 0) {
                MsgBox.showInfo((String)this.getStrResource("receive_SettleAmt_big_zero"));
                row.getCell("receiveSettleAmt").setValue((Object)new BigDecimal("0.0"));
                SysUtil.abort();
            }
            if (receiveSettleAmt.compareTo(unLockAmt = (BigDecimal)row.getCell("entries.unLockAmt").getValue()) > 0) {
                MsgBox.showInfo((String)this.getStrResource("receive_SettleAmt_too_big"));
                row.getCell("receiveSettleAmt").setValue((Object)new BigDecimal("0.0"));
                SysUtil.abort();
            }
            BigDecimal exchangeRate = new BigDecimal(row.getCell("exchangeRate").getValue().toString());
            try {
                isDirectExchange = this.getExgRateInfo(row, this.bottomCurrency);
                if (isDirectExchange) {
                    row.getCell("localReceiveSettleAmt").setValue((Object)receiveSettleAmt.multiply(exchangeRate).divide(new BigDecimal("1.0"), this.precision, 4));
                } else if (exchangeRate.compareTo(ZERO) != 0) {
                    row.getCell("localReceiveSettleAmt").setValue((Object)receiveSettleAmt.divide(exchangeRate, this.cache.getBaseCurrency().getPrecision(), 4));
                } else {
                    row.getCell("localReceiveSettleAmt").setValue((Object)receiveSettleAmt);
                }
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
        }
    }

    private void verify(boolean isSameCurrency) throws Exception {
        BigDecimal mainGainAndLoss;
        Date takeDate;
        this.checkboxSelected();
        if (this.dtTakeBackDate.getTimestamp() == null) {
            MsgBox.showInfo((String)this.getStrResource("bad_date_null"));
            SysUtil.abort();
        }
        if ((takeDate = (Date)this.dtTakeBackDate.getValue()).compareTo(this.currPeriod.getBeginDate()) < 0) {
            MsgBox.showInfo((String)this.getStrResource("badacct_takeback_date_big_currentdate"));
            SysUtil.abort();
        }
        BigDecimal recTotalamount = (BigDecimal)this.recTotal.getValue();
        BigDecimal badAcctTotalamount = (BigDecimal)this.badAcctTotal.getValue();
        if ((this.topCurrency == null && this.bottomCurrency == null || this.topCurrency != null && this.topCurrency.getId() != null && this.bottomCurrency != null && this.bottomCurrency.getId() != null && this.topCurrency.getId().toString().equals(this.bottomCurrency.getId().toString())) && recTotalamount.compareTo(badAcctTotalamount) == 1) {
            MsgBox.showInfo((String)this.getStrResource("badacct_takeback_amount_notmore_badAmounts"));
            SysUtil.abort();
        }
        CurrencyInfo basCurrency = this.currentCompany.getBaseCurrency();
        IRow row = null;
        BigDecimal thisTotalAmount = null;
        BigDecimal lossThisTotalAmount = null;
        BigDecimal totalTakeBadAmount = new BigDecimal("0.0");
        BigDecimal lossTotalTakeBadAmount = new BigDecimal("0.0");
        int size = this.tblBadAcct.getRowCount3();
        for (int i = 0; i < size; ++i) {
            row = this.tblBadAcct.getRow(i);
            if (!row.getCell("checkbox").getValue().toString().trim().equals("true")) continue;
            this.checkBadAcctData(row);
            thisTotalAmount = isSameCurrency ? this.changeNumber(this.topCurrency, (BigDecimal)row.getCell("thisTotalAmount").getValue()) : this.changeNumber(basCurrency, (BigDecimal)row.getCell("localThisTotalAmount").getValue());
            if (thisTotalAmount != null) {
                totalTakeBadAmount = totalTakeBadAmount.add(thisTotalAmount);
            }
            if ((lossThisTotalAmount = this.changeNumber(basCurrency, (BigDecimal)row.getCell("localThisTotalAmount").getValue())) == null) continue;
            lossTotalTakeBadAmount = lossTotalTakeBadAmount.add(lossThisTotalAmount);
        }
        if (totalTakeBadAmount.compareTo(new BigDecimal("0.0")) <= 0) {
            MsgBox.showInfo((String)this.getStrResource("this_badacct_takeback_biger_zero"));
            SysUtil.abort();
        }
        BigDecimal receivingAmount = null;
        BigDecimal lossReceivingAmount = null;
        BigDecimal totalReceivingAmount = new BigDecimal("0.0");
        BigDecimal lossTotalReceivingAmount = new BigDecimal("0.0");
        int size2 = this.tblMain.getRowCount3();
        for (int j = 0; j < size2; ++j) {
            row = this.tblMain.getRow(j);
            if (!row.getCell("checkbox").getValue().toString().trim().equals("true")) continue;
            this.checkReceivingBillData(row);
            receivingAmount = isSameCurrency ? this.changeNumber(this.bottomCurrency, (BigDecimal)row.getCell("receiveSettleAmt").getValue()) : this.changeNumber(basCurrency, (BigDecimal)row.getCell("localReceiveSettleAmt").getValue());
            if (receivingAmount != null) {
                totalReceivingAmount = totalReceivingAmount.add(receivingAmount);
            }
            if ((lossReceivingAmount = this.changeNumber(basCurrency, (BigDecimal)row.getCell("localReceiveSettleAmt").getValue())) == null) continue;
            lossTotalReceivingAmount = lossTotalReceivingAmount.add(lossReceivingAmount);
        }
        if (this.isSameCurrency && totalTakeBadAmount.compareTo(totalReceivingAmount) != 0) {
            MsgBox.showInfo((String)this.getStrResource("badacct_takeback_not_equal"));
            SysUtil.abort();
        }
        if ((mainGainAndLoss = lossTotalReceivingAmount.subtract(lossTotalTakeBadAmount).setScale(this.baseCurrency.getPrecision())).signum() != 0) {
            if (!isSameCurrency) {
                if (MsgBox.showConfirm2((Component)((Object)this), (String)(this.getAPStrResource("ap_label_gain1") + mainGainAndLoss + this.getAPStrResource("ap_label_gain2"))) != 0) {
                    SysUtil.abort();
                } else {
                    this.isGainAndLoss = true;
                }
            } else {
                this.isGainAndLoss = true;
            }
        }
    }

    private BigDecimal changeNumber(CurrencyInfo currencyInfo, BigDecimal amount) {
        if (currencyInfo == null || amount == null) {
            return BaseDataUtil.ZERO;
        }
        int DEF_SCALE = currencyInfo.getPrecision();
        if (DEF_SCALE == 0) {
            DEF_SCALE = 2;
        }
        return amount.divide(new BigDecimal("1.0"), DEF_SCALE, 4);
    }

    public void checkboxSelected() {
        String checkValue;
        IRow row;
        int i;
        int rowCount1;
        int selCount = 0;
        int rowCount = this.tblBadAcct.getRowCount();
        if (rowCount == 0) {
            MsgBox.showWarning((String)this.getStrResource("no_bad_acct"));
            SysUtil.abort();
        }
        if ((rowCount1 = this.tblMain.getRowCount()) == 0) {
            MsgBox.showWarning((String)this.getStrResource("no_receiving_bill"));
            SysUtil.abort();
        }
        for (i = 0; i < rowCount; ++i) {
            row = this.tblBadAcct.getRow(i);
            checkValue = UIRuleUtil.getString((Object)row.getCell("checkbox").getValue());
            if (!"true".equals(checkValue)) continue;
            ++selCount;
        }
        if (selCount == 0) {
            MsgBox.showWarning((String)this.getStrResource("no_select_badacct"));
            SysUtil.abort();
        }
        selCount = 0;
        for (i = 0; i < rowCount1; ++i) {
            row = this.tblMain.getRow(i);
            checkValue = UIRuleUtil.getString((Object)row.getCell("checkbox").getValue());
            if (!"true".equals(checkValue)) continue;
            ++selCount;
        }
        if (selCount == 0) {
            MsgBox.showWarning((String)this.getStrResource("no_select_receiving_bill"));
            SysUtil.abort();
        }
    }

    protected boolean checkBeforeWindowClosing() {
        this.releaseLock();
        return super.checkBeforeWindowClosing();
    }

    protected void finalize() throws Throwable {
        this.releaseLock();
        super.finalize();
    }

    private String getAPStrResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)resKey);
    }

    private String getStrResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)resKey);
    }

    private Map getBadAcctIDMap() {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        IRow row = null;
        int size = this.tblBadAcct.getRowCount3();
        for (int i = 0; i < size; ++i) {
            row = this.tblBadAcct.getRow(i);
            if (!row.getCell("checkbox").getValue().toString().equalsIgnoreCase("true")) continue;
            String badAcctID = row.getCell("badAcctID").getValue().toString();
            BigDecimal thisTotalAmount = (BigDecimal)row.getCell("thisTotalAmount").getValue();
            if (thisTotalAmount == null) continue;
            map.put(badAcctID, thisTotalAmount);
        }
        return map;
    }

    private List getBadAcctIDList() {
        ArrayList<String> list = new ArrayList<String>();
        IRow row = null;
        int size = this.tblBadAcct.getRowCount3();
        for (int i = 0; i < size; ++i) {
            row = this.tblBadAcct.getRow(i);
            if (!row.getCell("checkbox").getValue().toString().equalsIgnoreCase("true")) continue;
            String badAcctID = row.getCell("badAcctID").getValue().toString();
            BigDecimal thisTotalAmount = (BigDecimal)row.getCell("thisTotalAmount").getValue();
            if (thisTotalAmount == null) continue;
            list.add(badAcctID);
        }
        return list;
    }

    private Date convertTimestampToDate(Timestamp timestamp) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(timestamp);
        return new Date(calendar.getTime().getTime());
    }

    private BigDecimal getTotalAmount(boolean direct) {
        BigDecimal tmpAmt;
        BigDecimal topAmountA = BaseDataUtil.ZERO;
        BigDecimal topAmountB = BaseDataUtil.ZERO;
        BigDecimal bottomAmountA = BaseDataUtil.ZERO;
        BigDecimal bottomAmountB = BaseDataUtil.ZERO;
        int iTopCount = 0;
        int topSize = this.tblBadAcct.getRowCount3();
        for (int i = 0; i < topSize; ++i) {
            IRow row = this.tblBadAcct.getRow(i);
            if (!row.getCell("checkbox").getValue().equals(Boolean.TRUE)) continue;
            tmpAmt = new BigDecimal(row.getCell("localThisTotalAmount").getValue().toString());
            if (tmpAmt.signum() >= 0) {
                topAmountA = topAmountA.add(tmpAmt);
            } else {
                topAmountB = topAmountB.add(tmpAmt);
            }
            ++iTopCount;
        }
        int iBottomCount = 0;
        int bottomSize = this.tblMain.getRowCount3();
        for (int i = 0; i < bottomSize; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (!row.getCell("checkbox").getValue().equals(Boolean.TRUE)) continue;
            tmpAmt = new BigDecimal(row.getCell("localReceiveSettleAmt").getValue().toString());
            if (tmpAmt.signum() >= 0) {
                bottomAmountA = bottomAmountA.add(tmpAmt);
            } else {
                bottomAmountB = bottomAmountB.add(tmpAmt);
            }
            ++iBottomCount;
        }
        if (iTopCount > 0 && iBottomCount > 0) {
            return direct ? topAmountA.add(topAmountB) : bottomAmountA.add(bottomAmountB);
        }
        if (iTopCount == 0) {
            return direct ? bottomAmountA : bottomAmountB;
        }
        if (iBottomCount == 0) {
            return direct ? topAmountA : topAmountB;
        }
        return new BigDecimal("0.0");
    }

    private BigDecimal getGainAndLossRate() {
        BigDecimal topAmount = this.getTotalAmount(true);
        BigDecimal bottomAmount = this.getTotalAmount(false);
        BigDecimal diffValue = bottomAmount.subtract(topAmount);
        if (topAmount.compareTo(ZERO) != 0) {
            return diffValue.divide(topAmount, 6, 4);
        }
        return diffValue;
    }

    private void saveVerification() throws Exception {
        VerificationBillInfo verificaionBill = new VerificationBillInfo();
        verificaionBill.setCompany(this.currentCompany);
        verificaionBill.setBizDate(this.dtTakeBackDate.getTimestamp());
        verificaionBill.setCreator(this.defaultUserInfo);
        if (this.isSameAsstAct) {
            verificaionBill.setVerificationType(VerificationEnum.getEnum((int)111));
        } else {
            verificaionBill.setVerificationType(VerificationEnum.getEnum((int)112));
        }
        if (this.isInitBadAcct) {
            verificaionBill.setMainBillType(VerificateBillTypeEnum.InitBadAcct);
        } else {
            verificaionBill.setMainBillType(VerificateBillTypeEnum.BadAcct);
        }
        verificaionBill.setSecondBillType(VerificateBillTypeEnum.ReceiveBill);
        verificaionBill.setMainCurrency(this.topCurrency);
        verificaionBill.setSecondCurrency(this.bottomCurrency);
        verificaionBill.setIsSameCurrency(this.isSameCurrency);
        ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
        if (this.isSameAsstAct) {
            verificaionBill.setIsSameCode(true);
        } else {
            verificaionBill.setIsSameCode(this.isSameCode);
        }
        IAsstActType iAsstActType = AsstActTypeFactory.getRemoteInstance();
        IAsstActType iAsstActType1 = AsstActTypeFactory.getRemoteInstance();
        String topAssAcctTypeID = this.tblBadAcct.getRow(0).getCell("asstAcctTypeID").getValue().toString();
        AsstActTypeInfo topAsstActTypeInfo = null;
        if (topAssAcctTypeID != null) {
            topAsstActTypeInfo = iAsstActType.getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(topAssAcctTypeID));
        }
        verificaionBill.setMainAcctCussType(topAsstActTypeInfo);
        String botAssAcctTypeID = this.tblMain.getRow(0).getCell("payerType.id").getValue().toString();
        AsstActTypeInfo botAsstActTypeInfo = null;
        if (botAssAcctTypeID != null) {
            botAsstActTypeInfo = iAsstActType.getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(botAssAcctTypeID));
        }
        verificaionBill.setSecondAcctCussType(botAsstActTypeInfo);
        verificaionBill.setMainAcctCussID(BOSUuid.read((String)this.tblBadAcct.getRow(0).getCell("asstAcctID").getValue().toString()));
        if (this.tblBadAcct.getRow(0).getCell("asstAcct").getValue() != null) {
            verificaionBill.setMainAcctCussName(this.tblBadAcct.getRow(0).getCell("asstAcct").getValue().toString());
        }
        verificaionBill.setSecondAcctCussID(BOSUuid.read((String)this.tblMain.getRow(0).getCell("payerID").getValue().toString()));
        verificaionBill.setSecondAcctCussName(this.tblMain.getRow(0).getCell("payerName").getValue().toString());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String badAcctID = null;
        BigDecimal topTotalVeriAmt = BaseDataUtil.ZERO;
        BigDecimal topTotalVeriAmtLoc = BaseDataUtil.ZERO;
        String personID = null;
        String person = null;
        String adminOrgUnitID = null;
        String adminOrgUnit = null;
        Map badAcctAsstAcctMap = new HashMap();
        HashMap receivingBillMap = new HashMap();
        BigDecimal mainTotal = BaseDataUtil.ZERO;
        BigDecimal totalGainAndLoss = BaseDataUtil.ZERO;
        IRow row = null;
        int count = this.tblBadAcct.getRowCount();
        for (int i = 0; i < count; ++i) {
            String asstAcctTypeID;
            row = this.tblBadAcct.getRow(i);
            if (!row.getCell("checkbox").getValue().equals(Boolean.TRUE)) continue;
            BigDecimal thisVeriAmt = BaseDataUtil.ZERO;
            if (row.getCell("thisTotalAmount").getValue() != null) {
                thisVeriAmt = new BigDecimal(row.getCell("thisTotalAmount").getValue().toString());
            }
            if (thisVeriAmt.compareTo(BaseDataUtil.ZERO) <= 0) continue;
            VerificationBillentryInfo entryInfo = new VerificationBillentryInfo();
            badAcctID = row.getCell("badAcctID").getValue().toString();
            if (this.isInitBadAcct) {
                entryInfo.setBillType(VerificateBillTypeEnum.InitBadAcct);
                entryInfo.setBillSubType(VerificateBillTypeEnum.InitBadAcct);
                badAcctAsstAcctMap = this.iBadAcct.getAsstActName(badAcctID, "initbadaccount");
            } else {
                entryInfo.setBillType(VerificateBillTypeEnum.BadAcct);
                badAcctAsstAcctMap = this.iBadAcct.getAsstActName(badAcctID, "badacct");
                IBadAcct iBadAcct = BadAcctFactory.getRemoteInstance();
                IOtherBill iOtherBill = OtherBillFactory.getRemoteInstance();
                ObjectUuidPK badAcctPK = new ObjectUuidPK(badAcctID);
                BadAcctInfo badAcctInfo = iBadAcct.getBadAcctInfo((IObjectPK)badAcctPK);
                entryInfo.setAccount(badAcctInfo.getAccount());
                entryInfo.setOppAccount(badAcctInfo.getBadAccount());
                if (badAcctInfo != null) {
                    entryInfo.setBillSubType(this.changeBillType(this.getSubBillType(badAcctInfo)));
                }
            }
            if (row.getCell("personID").getValue() != null) {
                personID = row.getCell("personID").getValue().toString();
                PersonInfo personInfo = new PersonInfo();
                personInfo.setId(BOSUuid.read((String)personID));
                if (row.getCell("person").getValue() != null) {
                    person = row.getCell("person").getValue().toString();
                    personInfo.setName(person);
                }
                entryInfo.setPerson(personInfo);
            }
            if (row.getCell("adminOrgUnitID").getValue() != null) {
                adminOrgUnitID = row.getCell("adminOrgUnitID").getValue().toString();
                AdminOrgUnitInfo orgUnitInfo = new AdminOrgUnitInfo();
                orgUnitInfo.setId(BOSUuid.read((String)adminOrgUnitID));
                if (row.getCell("adminOrgUnit").getValue() != null) {
                    adminOrgUnit = row.getCell("adminOrgUnit").getValue().toString();
                    orgUnitInfo.setName(adminOrgUnit);
                }
                entryInfo.setAdminOrgUnit(orgUnitInfo);
            }
            if (row.getCell("currencyID").getValue() != null) {
                CurrencyInfo currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(row.getCell("currencyID").getValue().toString()));
                entryInfo.setCurrency(currencyInfo);
            }
            entryInfo.setBillID(BOSUuid.read((String)badAcctID));
            entryInfo.setEntryID(BOSUuid.read((String)badAcctID));
            if (row.getCell("number").getValue() != null) {
                entryInfo.setBillNumber(row.getCell("number").getValue().toString());
            }
            if (row.getCell("badAcctDate").getValue() != null) {
                entryInfo.setBillDate(df.parse(row.getCell("badAcctDate").getValue().toString()));
            }
            if ((asstAcctTypeID = row.getCell("asstAcctTypeID").getValue().toString()) != null) {
                AsstActTypeInfo asstActTypeInfo = iAsstActType.getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(asstAcctTypeID));
                entryInfo.setAcctCussType(asstActTypeInfo);
            }
            entryInfo.setAcctCussID(BOSUuid.read((String)row.getCell("asstAcctID").getValue().toString()));
            entryInfo.setAcctCussName(badAcctAsstAcctMap.get("L1").toString(), ArApBillUIUtil.L1);
            entryInfo.setAcctCussName(badAcctAsstAcctMap.get("L2").toString(), ArApBillUIUtil.L2);
            entryInfo.setAcctCussName(badAcctAsstAcctMap.get("L3").toString(), ArApBillUIUtil.L3);
            int topPrecision = 0;
            topPrecision = this.topCurrency == null || this.topCurrency.getPrecision() == 0 ? 2 : this.topCurrency.getPrecision();
            thisVeriAmt = thisVeriAmt.setScale(topPrecision, 4);
            BigDecimal thisVeriAmtLoc = BaseDataUtil.ZERO;
            if (row.getCell("localThisTotalAmount").getValue() != null) {
                thisVeriAmtLoc = new BigDecimal(row.getCell("localThisTotalAmount").getValue().toString());
            }
            int basePrecision = 0;
            basePrecision = this.baseCurrency == null || this.baseCurrency.getPrecision() == 0 ? 2 : this.baseCurrency.getPrecision();
            thisVeriAmtLoc = thisVeriAmtLoc.setScale(basePrecision, 4);
            entryInfo.setThisVerificateAmt(thisVeriAmt);
            entryInfo.setThisVerificateAmtLoc(thisVeriAmtLoc);
            topTotalVeriAmt = topTotalVeriAmt.add(thisVeriAmt);
            topTotalVeriAmtLoc = topTotalVeriAmtLoc.add(thisVeriAmtLoc);
            if (this.isGainAndLoss) {
                if ((mainTotal = mainTotal.add(thisVeriAmtLoc)).compareTo(this.getTotalAmount(true)) == 0) {
                    BigDecimal diffValue = this.getTotalAmount(false).subtract(this.getTotalAmount(true));
                    entryInfo.setGainAndLoss(diffValue.subtract(totalGainAndLoss));
                } else {
                    BigDecimal tmpGain = thisVeriAmtLoc.multiply(this.getGainAndLossRate()).setScale(this.baseCurrency.getPrecision(), 4);
                    entryInfo.setGainAndLoss(tmpGain);
                    totalGainAndLoss = totalGainAndLoss.add(tmpGain);
                }
            } else {
                entryInfo.setGainAndLoss(new BigDecimal("0.0"));
            }
            verificaionBill.getEntrys().add(entryInfo);
        }
        verificaionBill.setMainThisVerificateAmt(topTotalVeriAmt);
        verificaionBill.setMainThisVerificateAmtLoc(topTotalVeriAmtLoc);
        verificaionBill.setGainAndLoss(this.mainGainAndLoss);
        IReceivingBill iReceivingBill = null;
        BigDecimal botTotalVeriAmt = BaseDataUtil.ZERO;
        BigDecimal botTotalVeriAmtLoc = BaseDataUtil.ZERO;
        String receivingBillID = null;
        ArrayList<String> receivingBillList = new ArrayList<String>();
        int count2 = this.tblMain.getRowCount();
        for (int i = 0; i < count2; ++i) {
            String payerTypeID;
            row = this.tblMain.getRow(i);
            if (!row.getCell("checkbox").getValue().equals(Boolean.TRUE)) continue;
            VerificationBillentryInfo entryInfo = new VerificationBillentryInfo();
            BigDecimal thisVeriAmt = BaseDataUtil.ZERO;
            if (row.getCell("receiveSettleAmt").getValue() != null) {
                thisVeriAmt = new BigDecimal(row.getCell("receiveSettleAmt").getValue().toString());
            }
            if (thisVeriAmt.compareTo(BaseDataUtil.ZERO) <= 0) continue;
            receivingBillID = row.getCell("id").getValue().toString();
            this.setMutex(receivingBillList, receivingBillID);
            receivingBillList.add(receivingBillID);
            entryInfo.setBillType(VerificateBillTypeEnum.ReceiveBill);
            entryInfo.setBillSubType(this.getReceivingBillSubBillType(receivingBillID));
            entryInfo.setCurrency(this.bottomCurrency);
            entryInfo.setBillID(BOSUuid.read((String)receivingBillID));
            entryInfo.setEntryID(BOSUuid.read((String)row.getCell("entries.id").getValue().toString()));
            entryInfo.setBillNumber(row.getCell("number").getValue().toString());
            entryInfo.setBillDate((Date)row.getCell("bizDate").getValue());
            if (row.getCell("personID").getValue() != null) {
                personID = row.getCell("personID").getValue().toString();
                PersonInfo personInfo = new PersonInfo();
                personInfo.setId(BOSUuid.read((String)personID));
                if (row.getCell("person").getValue() != null) {
                    person = row.getCell("person").getValue().toString();
                    personInfo.setName(person);
                }
                entryInfo.setPerson(personInfo);
            }
            if (row.getCell("adminOrgUnitID").getValue() != null) {
                adminOrgUnitID = row.getCell("adminOrgUnitID").getValue().toString();
                AdminOrgUnitInfo orgUnitInfo = new AdminOrgUnitInfo();
                orgUnitInfo.setId(BOSUuid.read((String)adminOrgUnitID));
                if (row.getCell("adminOrgUnit").getValue() != null) {
                    adminOrgUnit = row.getCell("adminOrgUnit").getValue().toString();
                    orgUnitInfo.setName(adminOrgUnit);
                }
                entryInfo.setAdminOrgUnit(orgUnitInfo);
            }
            if (row.getCell("currency.id").getValue() != null) {
                CurrencyInfo currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(row.getCell("currency.id").getValue().toString()));
                entryInfo.setCurrency(currencyInfo);
            }
            if ((payerTypeID = row.getCell("payerType.id").getValue().toString()) != null) {
                AsstActTypeInfo asstActTypeInfo = iAsstActType.getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(payerTypeID));
                entryInfo.setAcctCussType(asstActTypeInfo);
            }
            entryInfo.setAcctCussID(BOSUuid.read((String)row.getCell("payerID").getValue().toString()));
            entryInfo.setAcctCussName(row.getCell("payerName").getValue().toString());
            if (row.getCell("receiveSettleAmt").getValue() != null) {
                thisVeriAmt = new BigDecimal(row.getCell("receiveSettleAmt").getValue().toString());
            }
            int bottomPrecision = 0;
            bottomPrecision = this.bottomCurrency == null || this.bottomCurrency.getPrecision() == 0 ? 2 : this.bottomCurrency.getPrecision();
            thisVeriAmt = thisVeriAmt.setScale(bottomPrecision, 4);
            BigDecimal thisVeriAmtLoc = BaseDataUtil.ZERO;
            if (row.getCell("localReceiveSettleAmt").getValue() != null) {
                thisVeriAmtLoc = new BigDecimal(row.getCell("localReceiveSettleAmt").getValue().toString());
            }
            int basePrecision1 = 0;
            basePrecision1 = this.baseCurrency == null || this.baseCurrency.getPrecision() == 0 ? 2 : this.baseCurrency.getPrecision();
            thisVeriAmtLoc = thisVeriAmtLoc.setScale(basePrecision1, 4);
            entryInfo.setThisVerificateAmt(thisVeriAmt);
            entryInfo.setThisVerificateAmtLoc(thisVeriAmtLoc);
            botTotalVeriAmt = botTotalVeriAmt.add(thisVeriAmt);
            botTotalVeriAmtLoc = botTotalVeriAmtLoc.add(thisVeriAmtLoc);
            if (row.getCell("id").getValue() != null) {
                ObjectStringPK pk = new ObjectStringPK(row.getCell("id").getValue().toString());
                if (iReceivingBill == null) {
                    iReceivingBill = ReceivingBillFactory.getRemoteInstance();
                }
                ReceivingBillInfo recBillInfo = (ReceivingBillInfo)iReceivingBill.getValue((IObjectPK)pk);
                entryInfo.setAccount(recBillInfo.getPayeeAccount());
                entryInfo.setOppAccount(recBillInfo.getOppAccount());
            }
            verificaionBill.getEntrys().add(entryInfo);
        }
        verificaionBill.setSecondThisVerificateAmt(botTotalVeriAmt);
        verificaionBill.setSecondThisVerificateAmtLoc(botTotalVeriAmtLoc);
        try {
            String sysNumber = BaseDataUtil.getNumberFromCodeRule(verificaionBill);
            if (sysNumber == null || sysNumber.trim().equals("")) {
                MsgBox.showInfo((String)this.getStrResource("badacct_takeback_number_null"));
                SysUtil.abort();
            }
            verificaionBill.setNumber(sysNumber);
            IObjectPK objPK = null;
            IBadAcctTakeBackFacade iBadAcctTakeBackFacade = BadAcctTakeBackFacadeFactory.getRemoteInstance();
            objPK = iBadAcctTakeBackFacade.verification(verificaionBill);
            if (objPK != null) {
                String verifyBillID = objPK.getKeyValue("id").toString();
                this.IDList = new ArrayList();
                this.IDList.add(objPK.toString());
                this.actionAddNew_actionPerformed(null);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.releaseMutex(receivingBillList);
    }

    private void setMutex(List receivingBillList, String receivingBillID) {
        if (!this.iMutex.requestObjIDForUpdate(receivingBillID)) {
            Iterator it = receivingBillList.iterator();
            while (it.hasNext()) {
                if (it.next().equals(receivingBillID)) continue;
                this.iMutex.releaseObjIDForUpdate((String)it.next());
            }
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"data_Mutex_Lock"));
            SysUtil.abort();
        }
    }

    private void releaseMutex(List receivingBillList) {
        Iterator it = receivingBillList.iterator();
        while (it.hasNext()) {
            this.iMutex.releaseObjIDForUpdate((String)it.next());
        }
    }

    private int getSubBillType(BadAcctInfo badAcctInfo) throws BOSException, EASBizException {
        IOtherBill iOtherBill = OtherBillFactory.getRemoteInstance();
        ObjectUuidPK otherBillPK = null;
        AbstractOtherBillInfo otherBillInfo = null;
        String otherBillID = badAcctInfo.getBillID();
        if (otherBillID != null) {
            otherBillPK = new ObjectUuidPK(otherBillID);
            otherBillInfo = iOtherBill.getOtherBillInfo((IObjectPK)otherBillPK);
        }
        if (otherBillInfo == null) {
            return 8;
        }
        return otherBillInfo.getBillType().getValue();
    }

    private VerificateBillTypeEnum changeBillType(int billType) {
        VerificateBillTypeEnum billTypeEnum = null;
        switch (billType) {
            case 102: {
                billTypeEnum = VerificateBillTypeEnum.SaleInvoice;
                break;
            }
            case 103: {
                billTypeEnum = VerificateBillTypeEnum.SaleChargeInvoice;
                break;
            }
            case 101: {
                billTypeEnum = VerificateBillTypeEnum.OtherReceiveBill;
            }
        }
        return billTypeEnum;
    }

    private boolean isRecType(String recTypeNumber) {
        ArrayList<String> recTypeList = new ArrayList<String>();
        recTypeList.add("100");
        recTypeList.add("101");
        recTypeList.add("102");
        recTypeList.add("103");
        recTypeList.add("104");
        recTypeList.add("105");
        recTypeList.add("121");
        recTypeList.add("999");
        return recTypeList.contains(recTypeNumber);
    }

    private VerificateBillTypeEnum getReceivingBillSubBillType(String receivingBillID) throws BOSException, EASBizException {
        IReceivingBill iReceivingBill = ReceivingBillFactory.getRemoteInstance();
        ReceivingBillInfo recInfo = iReceivingBill.getReceivingBillInfo((IObjectPK)new ObjectUuidPK(receivingBillID));
        int recTypeValue = 999;
        if (recInfo.getRecBillType() != null || recInfo.getRecBillType().getNumber() != null) {
            recTypeValue = this.isRecType(recInfo.getRecBillType().getNumber()) ? Integer.parseInt(recInfo.getRecBillType().getNumber()) : 100;
        }
        VerificateBillTypeEnum veriBillEnum = null;
        if (recInfo != null) {
            veriBillEnum = VerificateBillTypeEnum.getEnum((int)recTypeValue);
        }
        return veriBillEnum;
    }

    @Override
    public void actionVerify_actionPerformed(ActionEvent e) throws Exception {
        this.verify(this.isSameCurrency);
        this.saveVerification();
        this.setMessageText(this.getStrResource("badacct_takeback_successed"));
        this.showMessage();
    }

    @Override
    public void actionUnVerify_actionPerformed(ActionEvent e) throws Exception {
        this.verify(this.isSameCurrency);
    }

    @Override
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.isRelationGL();
        if (this.IDList == null || this.IDList.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("no_gen_badacct_takeback"));
            return;
        }
        IBadAcctTakeBackFacade iBadAcctTakeBackFacade = BadAcctTakeBackFacadeFactory.getRemoteInstance();
        int size = this.IDList.size();
        for (int i = 0; i < size; ++i) {
            String ID = (String)this.IDList.get(i);
            if (!iBadAcctTakeBackFacade.isVouchered(ID)) continue;
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("gen_vouchered"));
            return;
        }
        IObjectCollection tmpCollection = iBadAcctTakeBackFacade.makeVoucher(true, this.IDList);
        VoucherInfo vch = (VoucherInfo)tmpCollection.getObject(0);
        if (vch != null) {
            UIContext ctx = new UIContext((Object)this);
            ctx.put((Object)"ID", (Object)vch.getId());
            ctx.put((Object)"EDITRULE", (Object)"com.kingdee.eas.fi.gl.client.DefaultVoucherEditRule");
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(VoucherInfo.getEditUIName(), (Map)ctx, null, OprtState.VIEW);
            uiWindow.show();
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("voucher_fail"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.isRelationGL();
        if (this.IDList == null || this.IDList.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("delvoucher_no_gen_badaccttakeback"));
            return;
        }
        IBadAcctTakeBackFacade iBadAcctTakeBackFacade = BadAcctTakeBackFacadeFactory.getRemoteInstance();
        int count = this.IDList.size();
        for (int i = 0; i < count; ++i) {
            String ID = (String)this.IDList.get(i);
            if (iBadAcctTakeBackFacade.isVouchered(ID)) continue;
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("no_gen_voucher"));
            return;
        }
        iBadAcctTakeBackFacade.makeVoucher(false, this.IDList);
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.common.EASCommonResource", (String)"deleteSuccessed"));
        this.showMessage();
    }

    private void isRelationGL() {
        if (!this.isNeedChecked()) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("gl_not_relation_or_start"));
            SysUtil.abort();
        }
    }

    private boolean isNeedChecked() {
        boolean arIsRltdAccunt = false;
        boolean glIsStart = false;
        try {
            arIsRltdAccunt = ArClientUtils.arIsRelatedAccount(this.currentCompany);
            glIsStart = CommonClientUtils.glIsStart(this.currentCompany);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return arIsRltdAccunt && glIsStart;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.insertBadAcctData(this.badAcctTakeBackQueryUI.badAcctSQL.toString(), this.isInitBadAcct);
        this.refreshList();
        this.setNumberFormat();
    }
}

