/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.ar.client.AbstractBadAcctTakeBackVerifyQueryUI;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.client.util.ComBoxInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.sql.Date;
import java.util.Calendar;
import java.util.HashMap;

public class BadAcctTakeBackVerifyQueryUI
extends AbstractBadAcctTakeBackVerifyQueryUI {
    private CompanyOrgUnitInfo currentCompany = null;
    private static String AR_NAME = "com.kingdee.eas.fi.ar.app.BadAcctTakeBack";
    private static String REC_NAME = "com.kingdee.eas.fi.cas.app.ReceivingBill";

    public void onLoad() throws Exception {
        try {
            this.currentCompany = BaseDataUtil.getCompanyInfo();
        }
        catch (Exception ex) {
            SysUtil.abort();
        }
        super.onLoad();
        this.kDBizPromptCompany.setData((Object)this.currentCompany);
        this.kDBizPromptCompany.setEnabled(false);
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        this.dtFrom.setValue((Object)calendar.getTime());
        BaseDataUtil.makeBillAsstActType(this.cmbAcctCussType);
        BaseDataUtil.makeBillAsstActType(this.cmbAcctCussTypeTo);
        if (this.cmbAcctCussType.getItemCount() == 0) {
            this.prmAcctCuss.setEnabled(false);
            this.prmAcctCussTo.setEnabled(false);
        }
        this.kdBizPromCurrency.setData((Object)this.currentCompany.getBaseCurrency());
        this.kdBizPromCurrency.setEditable(true);
        this.kdBizPromCurrency.setDisplayFormat("$name$");
        this.kdBizPromCurrency.setEditFormat("$number$");
        this.kdBizPromCurrency.setCommitFormat("$number$");
        this.kdBizPromCurrency.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
        this.kdBizPromCurrencyTo.setData((Object)this.currentCompany.getBaseCurrency());
        this.kdBizPromCurrencyTo.setEditable(true);
        this.kdBizPromCurrencyTo.setDisplayFormat("$name$");
        this.kdBizPromCurrencyTo.setEditFormat("$number$");
        this.kdBizPromCurrencyTo.setCommitFormat("$number$");
        this.kdBizPromCurrencyTo.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
        this.prmAcctCuss.setEditable(true);
        this.prmAcctCuss.setDisplayFormat("$name$");
        this.prmAcctCuss.setEditFormat("$number$");
        this.prmAcctCuss.setCommitFormat("$number$");
        this.prmAcctCussTo.setEditable(true);
        this.prmAcctCussTo.setDisplayFormat("$name$");
        this.prmAcctCussTo.setEditFormat("$number$");
        this.prmAcctCussTo.setCommitFormat("$number$");
    }

    public HashMap getTopFilter() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String companyID = ((CompanyOrgUnitInfo)this.kDBizPromptCompany.getValue()).getId().toString();
        result.put("company", companyID);
        CurrencyInfo currencyInfo = (CurrencyInfo)this.kdBizPromCurrency.getValue();
        result.put("currency", currencyInfo);
        IObjectValue objValue = (IObjectValue)this.prmAcctCuss.getValue();
        result.put("assActID", objValue.getString("id"));
        Date startDate = BaseDataUtil.downTimestamp(this.dtFrom.getTimestamp());
        Date endDate = BaseDataUtil.upTimestamp(this.dtTo.getTimestamp());
        result.put("startdate", startDate);
        result.put("enddate", endDate);
        return result;
    }

    public HashMap getBottomFilter() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String companyID = ((CompanyOrgUnitInfo)this.kDBizPromptCompany.getValue()).getId().toString();
        result.put("company", companyID);
        CurrencyInfo currencyInfo = (CurrencyInfo)this.kdBizPromCurrencyTo.getValue();
        result.put("currency", currencyInfo);
        IObjectValue objValue = (IObjectValue)this.prmAcctCussTo.getValue();
        if (objValue == null) {
            objValue = (IObjectValue)this.prmAcctCuss.getValue();
        }
        result.put("assActID", objValue.getString("id"));
        Date startDate = BaseDataUtil.downTimestamp(this.dtFrom.getTimestamp());
        Date endDate = BaseDataUtil.upTimestamp(this.dtTo.getTimestamp());
        result.put("startdate", startDate);
        result.put("enddate", endDate);
        return result;
    }

    public HashMap getFilterOQL() {
        HashMap<String, String> map = new HashMap<String, String>();
        Date startDate = BaseDataUtil.downTimestamp(this.dtFrom.getTimestamp());
        Date endDate = BaseDataUtil.upTimestamp(this.dtTo.getTimestamp());
        IObjectValue asstActA = (IObjectValue)this.prmAcctCuss.getValue();
        IObjectValue asstActB = (IObjectValue)this.prmAcctCussTo.getValue();
        IObjectValue currencyA = (IObjectValue)this.kdBizPromCurrency.getValue();
        IObjectValue currencyB = (IObjectValue)this.kdBizPromCurrencyTo.getValue();
        String numberA = this.txtBillNumberA.getText().trim();
        String numberB = this.txtBillNumberB.getText().trim();
        StringBuffer oqlA = new StringBuffer(" ");
        StringBuffer oqlB = new StringBuffer(" ");
        if (numberA.length() > 0) {
            oqlA.append(" number = '").append(numberA).append("' and ");
        }
        oqlA.append("cussentType = '").append(asstActA.getString("id")).append("' and ");
        oqlA.append("currency = '").append(currencyA.getString("id")).append("' and ");
        oqlA.append("badAcctDate < '").append(endDate).append("' and ");
        oqlA.append("badAcctDate >= '").append(startDate).append("' ");
        if (numberB.length() > 0) {
            oqlB.append(" number = '").append(numberB).append("' and ");
        }
        oqlB.append("asstActID = '").append(asstActB.getString("id")).append("' and ");
        oqlB.append("currency = '").append(currencyB.getString("id")).append("' and ");
        oqlB.append("billDate < '").append(endDate).append("' and ");
        oqlB.append("billDate >= '").append(startDate).append("' ");
        map.put(REC_NAME, oqlA.toString());
        map.put(AR_NAME, oqlB.toString());
        return map;
    }

    public boolean isSameAcct() {
        IObjectValue obj1 = (IObjectValue)this.prmAcctCuss.getValue();
        IObjectValue obj2 = (IObjectValue)this.prmAcctCussTo.getValue();
        return obj1 != null && obj2 != null && obj1.getString("id").equals(obj2.getString("id"));
    }

    public boolean isSameCurrency() {
        IObjectValue obj1 = (IObjectValue)this.kdBizPromCurrency.getValue();
        IObjectValue obj2 = (IObjectValue)this.kdBizPromCurrencyTo.getValue();
        return obj1 != null && obj2 != null && obj1.getString("id").equals(obj2.getString("id"));
    }

    @Override
    protected void cmbAcctCussType_itemStateChanged(ItemEvent e) throws Exception {
        if (this.cmbAcctCussType.getSelectedItem() == null) {
            return;
        }
        AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)((ComBoxInfo)this.cmbAcctCussType.getSelectedItem()).getobjInfo();
        String queryName = asstActTypeInfo.getDefaultQueryName();
        this.prmAcctCuss.setValue(null);
        this.prmAcctCuss.setQueryInfo(queryName);
    }

    @Override
    protected void cmbAcctCussTypeTo_itemStateChanged(ItemEvent e) throws Exception {
        if (this.cmbAcctCussTypeTo.getSelectedItem() == null) {
            return;
        }
        AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)((ComBoxInfo)this.cmbAcctCussTypeTo.getSelectedItem()).getobjInfo();
        String queryName = asstActTypeInfo.getDefaultQueryName();
        this.prmAcctCussTo.setValue(null);
        this.prmAcctCussTo.setQueryInfo(queryName);
    }

    @Override
    protected void kDRadioType1_itemStateChanged(ItemEvent e) throws Exception {
        if (this.kDRadioType1.isSelected()) {
            this.kDBizUniformNumber.setEnabled(true);
            this.kDPanelMain.setEnabled(false);
            this.kDPanelSecond.setEnabled(false);
        }
    }

    @Override
    protected void kDRadioType2_itemStateChanged(ItemEvent e) throws Exception {
        if (this.kDRadioType2.isSelected()) {
            this.kDBizUniformNumber.setEnabled(false);
            this.kDPanelMain.setEnabled(true);
            this.kDPanelSecond.setEnabled(true);
        }
    }

    public boolean verify() {
        if (this.prmAcctCuss.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("nullAcctCussent"));
            SysUtil.abort();
        }
        if (this.prmAcctCussTo.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("nullAcctCussent"));
            this.prmAcctCussTo.setFocusCycleRoot(true);
            SysUtil.abort();
        }
        return super.verify();
    }

    public FilterInfo getFilterInfo() {
        FilterItemInfo filter;
        CurrencyInfo currencyInfo;
        FilterItemInfo filter2;
        this.filterInfo = new FilterInfo();
        CompanyOrgUnitInfo objValue = null;
        objValue = (CompanyOrgUnitInfo)this.kDBizPromptCompany.getValue();
        if (objValue != null) {
            filter2 = new FilterItemInfo("company.id", (Object)objValue.getString("id"), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filter2);
        }
        if (this.cmbAcctCussType.getSelectedItem() != null && (objValue = (AsstActTypeInfo)((ComBoxInfo)this.cmbAcctCussType.getSelectedItem()).getobjInfo()) != null) {
            filter2 = new FilterItemInfo("asstacttype.id", (Object)objValue.getString("id"), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filter2);
        }
        if ((objValue = (IObjectValue)this.prmAcctCuss.getValue()) != null) {
            filter2 = new FilterItemInfo("assact.id", (Object)objValue.getString("id"), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filter2);
        }
        if ((objValue = (IObjectValue)this.prmAcctCussTo.getValue()) != null) {
            filter2 = new FilterItemInfo("assactto.id", (Object)objValue.getString("id"), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filter2);
        }
        if ((currencyInfo = (CurrencyInfo)this.kdBizPromCurrency.getValue()) != null) {
            FilterItemInfo filter3 = new FilterItemInfo("currency.id", (Object)currencyInfo.getString("id"), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filter3);
        }
        if (this.dtFrom.getTimestamp() != null) {
            Date startDate = BaseDataUtil.downTimestamp(this.dtFrom.getTimestamp());
            filter = new FilterItemInfo("startdate", (Object)startDate, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filter);
        }
        if (this.dtTo.getTimestamp() != null) {
            Date endDate = BaseDataUtil.upTimestamp(this.dtTo.getTimestamp());
            filter = new FilterItemInfo("enddate", (Object)endDate, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filter);
        }
        return this.filterInfo;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clear();
        super.loadData(entityViewInfo);
        IObjectValue objValue = null;
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter().getFilterItems();
        block0: for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            String propName = currentFilterItemCollection.get(i).getPropertyName();
            Object compVal = currentFilterItemCollection.get(i).getCompareValue();
            CompareType comp = currentFilterItemCollection.get(i).getCompareType();
            if ("company.id".equalsIgnoreCase(propName)) {
                this.kDBizPromptCompany.setValue((Object)this.currentCompany);
                continue;
            }
            if ("asstacttype.id".equalsIgnoreCase(propName)) {
                objValue = this.getBizObject(compVal.toString());
                int iCount = this.cmbAcctCussType.getItemCount();
                for (int index = 0; index < iCount; ++index) {
                    if (!objValue.equals(((ComBoxInfo)this.cmbAcctCussType.getItemAt(index)).getobjInfo())) continue;
                    this.cmbAcctCussType.setSelectedIndex(index);
                    continue block0;
                }
                continue;
            }
            if ("assact.id".equalsIgnoreCase(propName)) {
                objValue = this.getBizObject(compVal.toString());
                this.prmAcctCuss.setValue((Object)objValue);
                continue;
            }
            if ("assactto.id".equalsIgnoreCase(propName)) {
                objValue = this.getBizObject(compVal.toString());
                this.prmAcctCussTo.setValue((Object)objValue);
                continue;
            }
            if ("currency.id".equalsIgnoreCase(propName)) {
                objValue = this.getBizObject(compVal.toString());
                this.kdBizPromCurrency.setValue((Object)objValue);
                continue;
            }
            if ("startdate".equalsIgnoreCase(propName)) {
                this.dtFrom.setValue(compVal);
                continue;
            }
            if (!"enddate".equalsIgnoreCase(propName)) continue;
            this.dtTo.setValue(compVal);
        }
    }

    private IObjectValue getBizObject(String id) {
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            ObjectUuidPK pk = new ObjectUuidPK(id);
            IObjectValue objVal = DynamicObjectFactory.getRemoteInstance().getValue(pk.getObjectType(), (IObjectPK)pk, sic);
            return objVal;
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
            return null;
        }
    }

    private String getStrResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)key);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }
}

