/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.auxacct.IAsstActTypeDefault;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ap.client.util.ApClientUtils;
import com.kingdee.eas.fi.ar.client.AbstractBalanceReportConditionUI;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.client.util.ComBoxInfo;
import com.kingdee.eas.fi.ar.util.AsstActTypeUtils;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class BalanceReportConditionUI
extends AbstractBalanceReportConditionUI {
    private static final long serialVersionUID = -1595255581179235685L;
    private static final Logger logger = CoreUIObject.getLogger(BalanceReportConditionUI.class);
    String resClassName = "com.kingdee.eas.fi.ar.ArReport";
    private boolean systemToker = false;
    CompanyOrgUnitInfo currentCompany = null;
    CurrencyInfo currency = null;
    AsstActTypeUtils asstActType = null;
    int loadcount = 0;

    public BalanceReportConditionUI() throws Exception {
        this.setSize(500, 186);
    }

    public BalanceReportConditionUI(boolean flag) throws Exception {
        this.systemToker = flag;
        this.setSize(500, 186);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        ++this.loadcount;
        if (this.loadcount == 1) {
            this.initPrompt();
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public RptParams getCustomCondition() {
        if (this.listAsstActType.getItemCount() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("AsstTypeEmpty"));
            SysUtil.abort();
        }
        RptParams pp = new RptParams();
        pp.setObject("endDate", (Object)this.endDate.getTimestamp());
        if (this.f7Currency.getData() != null) {
            pp.setObject("f7Currency", (Object)((CurrencyInfo)this.f7Currency.getData()));
        } else {
            pp.setObject("f7Currency", null);
        }
        if (this.listAsstActType.getSelectedItem() != null) {
            pp.setObject("asstActType", (Object)((AsstActTypeInfo)((ComBoxInfo)this.listAsstActType.getSelectedItem()).getobjInfo()));
        } else {
            pp.setObject("asstActType", null);
        }
        if (this.f7AsstActFrom.getData() != null) {
            pp.setObject("f7AsstActFrom", (Object)((DataBaseInfo)this.f7AsstActFrom.getData()));
        } else {
            pp.setObject("f7AsstActFrom", null);
        }
        if (this.f7AsstActTo.getData() != null) {
            pp.setObject("f7AsstActTo", (Object)((DataBaseInfo)this.f7AsstActTo.getData()));
        } else {
            pp.setObject("f7AsstActTo", null);
        }
        return pp;
    }

    public void setCustomCondition(RptParams params) {
        this.endDate.setValue((Object)((Timestamp)params.getObject("endDate")));
        int itemCount = this.listAsstActType.getItemCount();
        for (int j = 0; j < itemCount; ++j) {
            AsstActTypeInfo obj = (AsstActTypeInfo)params.getObject("asstActType");
            AsstActTypeInfo assActType = (AsstActTypeInfo)((ComBoxInfo)this.listAsstActType.getItemAt(j)).getobjInfo();
            if (!assActType.equalsPK((IObjectValue)obj)) continue;
            this.listAsstActType.setSelectedIndex(j);
        }
        this.f7AsstActFrom.setData((Object)((DataBaseInfo)params.getObject("f7AsstActFrom")));
        this.f7AsstActTo.setData((Object)((DataBaseInfo)params.getObject("f7AsstActTo")));
    }

    private boolean initPrompt() throws EASBizException, BOSException {
        this.currentCompany = BaseDataUtil.getCompanyInfo();
        this.currency = this.currentCompany.getBaseCurrency();
        ObjectUuidPK currencyPk = new ObjectUuidPK(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID);
        CurrencyInfo generalLocalCurrency = null;
        try {
            generalLocalCurrency = (CurrencyInfo)CurrencyFactory.getRemoteInstance().getValue((IObjectPK)currencyPk);
        }
        catch (Exception e) {
            logger.info((Object)e);
            this.handUIException(e);
        }
        this.currency = generalLocalCurrency;
        this.setEndDate();
        this.f7Currency.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
        this.f7Currency.setValue((Object)this.currency);
        this.f7Currency.setEnabled(false);
        this.makeBillAsstActType(this.listAsstActType);
        this.f7AsstActFrom.setEditable(true);
        this.f7AsstActFrom.setCommitFormat("$number$");
        this.f7AsstActTo.setEditable(true);
        this.f7AsstActTo.setCommitFormat("$number$");
        return true;
    }

    private void setEndDate() throws BOSException, EASBizException {
        Date endDateValue;
        PeriodInfo periodMaxInfo;
        PeriodInfo periodMinInfo;
        if (this.systemToker) {
            periodMinInfo = ArClientUtils.getArStartPeriod(this.currentCompany);
            periodMaxInfo = ArClientUtils.getArCurrentPeriod(this.currentCompany);
        } else {
            periodMinInfo = ApClientUtils.getApStartPeriod(this.currentCompany);
            periodMaxInfo = ApClientUtils.getApCurrentPeriod(this.currentCompany);
        }
        if (periodMinInfo == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)this.resClassName, (String)"noStart"));
            SysUtil.abort();
        }
        if (periodMaxInfo == null) {
            MsgBox.showError((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("currentPeriodIsNull"));
            SysUtil.abort();
        }
        if ((endDateValue = (Date)this.endDate.getValue()).before(periodMinInfo.getBeginDate())) {
            this.endDate.setValue((Object)periodMinInfo.getBeginDate());
        }
        if (endDateValue.after(periodMaxInfo.getEndDate())) {
            this.endDate.setValue((Object)periodMaxInfo.getEndDate());
        }
        this.endDate.setMinimumDate(periodMinInfo.getBeginDate());
        this.endDate.setMaximumDate((Date)periodMaxInfo.getEndDate());
    }

    @Override
    public void listAsstActType_itemStateChanged(ItemEvent e) throws Exception {
        if (this.listAsstActType.getItemCount() == 0) {
            this.f7AsstActFrom.setEnabled(false);
            this.f7AsstActTo.setEnabled(false);
            return;
        }
        this.f7AsstActFrom.setValue(null);
        this.f7AsstActTo.setValue(null);
        AsstActTypeInfo typeInfo = (AsstActTypeInfo)((ComBoxInfo)this.listAsstActType.getSelectedItem()).getobjInfo();
        try {
            ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.f7AsstActFrom, typeInfo, false);
            ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.f7AsstActTo, typeInfo, false);
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        super.listAsstActType_itemStateChanged(e);
    }

    private boolean setPrompt() throws Exception {
        this.setAsstActType(null);
        return true;
    }

    public void setAsstActType(String strFlag) throws EASBizException, BOSException {
        String cpid = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        IAsstActTypeDefault iAsstActType = AsstActTypeDefaultFactory.getRemoteInstance();
        AsstActTypeDefaultCollection asstActTypeColl = iAsstActType.getAsstActTypeDefaultCollection(" where isAccountCussent = 1  and  company.id='" + cpid + "' ");
        AsstActTypeDefaultInfo defaultVal = null;
        int count = asstActTypeColl.size();
        Object[] typeValue = new Object[count];
        IAsstActType iaat = AsstActTypeFactory.getRemoteInstance();
        for (int i = 0; i < count; ++i) {
            AsstActTypeDefaultInfo value = asstActTypeColl.get(i);
            if (value.isIsDefaultAccountPayable()) {
                defaultVal = value;
            }
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)value.getAsstActType().getString("id")));
            AsstActTypeInfo asstInfo = iaat.getAsstActTypeInfo((IObjectPK)pk);
            String typeName = asstInfo.getName();
            String typeId = asstInfo.getId().toString();
            String typeQueryName = asstInfo.getDefaultQueryName();
            String typeTableName = asstInfo.getRealtionDataObject();
            int csType = 0;
            this.asstActType = new AsstActTypeUtils(typeName, typeId, typeTableName, typeQueryName, csType);
            typeValue[i] = this.asstActType;
        }
        this.listAsstActType.removeAllItems();
        this.listAsstActType.addItems(typeValue);
        int c = this.listAsstActType.getItemCount();
        for (int k = 0; k < c; ++k) {
            if (this.systemToker) {
                if (!((AsstActTypeUtils)this.listAsstActType.getItemAt((int)k)).tableName.equalsIgnoreCase("t_bd_customer")) continue;
                this.listAsstActType.setSelectedIndex(k);
                break;
            }
            if (!((AsstActTypeUtils)this.listAsstActType.getItemAt((int)k)).tableName.equalsIgnoreCase("t_bd_supplier")) continue;
            this.listAsstActType.setSelectedIndex(k);
            break;
        }
    }

    private void makeBillAsstActType(KDComboBox comboAsstActType) throws EASBizException, BOSException {
        String cpID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        IAsstActTypeDefault iAsstActType = AsstActTypeDefaultFactory.getRemoteInstance();
        AsstActTypeDefaultCollection asstActTypeColl = iAsstActType.getAsstActTypeDefaultCollection(" where isAccountCussent = 1 and company.id = '" + cpID + "'");
        Object defaultVal = null;
        int count = asstActTypeColl.size();
        Object[] cbi = new ComBoxInfo[count];
        for (int i = 0; i < count; ++i) {
            AsstActTypeDefaultInfo value = asstActTypeColl.get(i);
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)value.getAsstActType().getString("id")));
            AsstActTypeInfo asstInfo = AsstActTypeFactory.getRemoteInstance().getAsstActTypeInfo((IObjectPK)pk);
            cbi[i] = new ComBoxInfo((IObjectValue)asstInfo, asstInfo.getName(), true);
            if (!value.isIsDefaultAccountReceivable()) continue;
            defaultVal = cbi[i];
        }
        comboAsstActType.removeAllItems();
        comboAsstActType.addItems(cbi);
        if (defaultVal != null) {
            comboAsstActType.setSelectedItem(defaultVal);
        }
        int c = comboAsstActType.getItemCount();
        boolean hasCustom = false;
        boolean hasSupplier = false;
        for (int k = 0; k < c; ++k) {
            AsstActTypeInfo asstInfo = (AsstActTypeInfo)((ComBoxInfo)comboAsstActType.getItemAt(k)).getobjInfo();
            if (this.systemToker) {
                if (!asstInfo.getRealtionDataObject().equalsIgnoreCase("T_BD_Customer")) continue;
                comboAsstActType.setSelectedIndex(k);
                comboAsstActType.setEnabled(false);
                hasCustom = true;
                break;
            }
            if (!asstInfo.getRealtionDataObject().equalsIgnoreCase("T_BD_Supplier")) continue;
            comboAsstActType.setSelectedIndex(k);
            comboAsstActType.setEnabled(false);
            hasSupplier = true;
            break;
        }
        if (this.systemToker && !hasCustom) {
            comboAsstActType.removeAllItems();
            comboAsstActType.setEnabled(false);
        }
        if (!this.systemToker && !hasSupplier) {
            comboAsstActType.removeAllItems();
            comboAsstActType.setEnabled(false);
        }
    }

    private void setBizPromptData(KDBizPromptBox bizPrompt, String id) {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(id);
            IObjectValue objVal = DynamicObjectFactory.getRemoteInstance().getValue(pk.getObjectType(), (IObjectPK)pk);
            bizPrompt.setData((Object)objVal);
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
    }
}

