/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountTable;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ap.client.util.ApClientUtils;
import com.kingdee.eas.fi.ar.ContrastAccountViewDerectionEnum;
import com.kingdee.eas.fi.ar.ContrastAccountViewFactory;
import com.kingdee.eas.fi.ar.ContrastAccountViewInfo;
import com.kingdee.eas.fi.ar.IContrastAccountView;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.client.AbstractContrastAccountViewListUI;
import com.kingdee.eas.fi.ar.client.util.AccountUtils;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.client.util.ArApReportUIUtil;
import com.kingdee.eas.fi.arap.util.ArApMutextUtils;
import com.kingdee.eas.fi.cas.client.ArApRecPayHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;

public class ContrastAccountViewListUI
extends AbstractContrastAccountViewListUI {
    private static final int MIN_PERIOD_YEAR = 1900;
    private static final int MIN_PERIOD_NUMBER = 1;
    private static final int MAX_PERIOD_NUMBER = 13;
    private CompanyOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentFIUnit();
    private IContrastAccountView iContrastAccountView = null;
    private IAccountView iAccountView = null;
    private int rowcount = 0;
    protected int system = 0;
    private PeriodInfo startPeriod = null;
    private PeriodInfo currPeriod = null;
    boolean dataChanged = false;
    private boolean isOppPositive = false;
    private static final String COL_ISCONTRACT = "isContrast";

    public ContrastAccountViewListUI() throws Exception {
        ArApReportUIUtil.checkCompany((Component)((Object)this), this.currentCompany);
    }

    public void onLoad() throws Exception {
        this.setSystem();
        this.iContrastAccountView = ContrastAccountViewFactory.getRemoteInstance();
        this.iAccountView = AccountViewFactory.getRemoteInstance();
        super.onLoad();
        this.initTable();
        this.setPeriod(this.currPeriod);
        this.actionAddNew.setEnabled(true);
        this.insertContrastAccountView(this.currPeriod.getPeriodYear(), this.currPeriod.getPeriodNumber());
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    public void refreshList() throws Exception {
    }

    protected void setSystem() {
        this.system = 1;
    }

    protected PeriodInfo getStartPeriod() throws BOSException, EASBizException {
        if (this.system == 1) {
            return ArClientUtils.getArStartPeriod(this.currentCompany);
        }
        return ApClientUtils.getApStartPeriod(this.currentCompany);
    }

    protected PeriodInfo getCurrPeriod() throws BOSException, EASBizException {
        PeriodInfo period = null;
        period = this.system == 1 ? ArClientUtils.getArCurrentPeriod(this.currentCompany) : ApClientUtils.getApCurrentPeriod(this.currentCompany);
        if (period == null) {
            period = this.startPeriod;
        }
        return period;
    }

    public void actionView_actionPerformed(ActionEvent e) {
    }

    private void initTable() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getActionMap().remove("Delete");
        KDBizPromptBox kdtEntrys_paySubject_PromptBox = new KDBizPromptBox();
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        StringBuffer mask = new StringBuffer("#0 AND #1 AND #2");
        fic.add(new FilterItemInfo("companyID.id", (Object)this.currentCompany.getId().toString()));
        fic.add(new FilterItemInfo("isGFreeze", (Object)false));
        fic.add(new FilterItemInfo("isCFreeze", (Object)false));
        String accountTableID = this.getAccountTableID();
        AccountTableInfo accountTableInfo = this.getAccountTable(accountTableID);
        if (accountTableID != null && !"".equals(accountTableID)) {
            fic.add(new FilterItemInfo("accountTableID.id", (Object)accountTableID));
            mask.append(" AND #3");
        }
        fi.setMaskString(mask.toString());
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(fi);
        kdtEntrys_paySubject_PromptBox.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        kdtEntrys_paySubject_PromptBox.setSelector((KDPromptSelector)new AccountPromptBox((IUIObject)this, this.currentCompany, accountTableInfo, fi, false, true, true));
        kdtEntrys_paySubject_PromptBox.setVisible(true);
        kdtEntrys_paySubject_PromptBox.setEditable(true);
        kdtEntrys_paySubject_PromptBox.setEnabled(true);
        kdtEntrys_paySubject_PromptBox.setEditFormat("$number$");
        kdtEntrys_paySubject_PromptBox.setDisplayFormat("$number$");
        kdtEntrys_paySubject_PromptBox.setCommitFormat("$number$;$name$");
        kdtEntrys_paySubject_PromptBox.setEntityViewInfo(viewInfo);
        KDTDefaultCellEditor kdtbadAccountCellEditor = new KDTDefaultCellEditor((IKDEditor)kdtEntrys_paySubject_PromptBox);
        ObjectValueRender kdtEntrys_recAccount_OVR = new ObjectValueRender();
        kdtEntrys_recAccount_OVR.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.tblMain.getColumn("account").setEditor((ICellEditor)kdtbadAccountCellEditor);
        this.tblMain.getColumn("account").setRenderer((IBasicRender)kdtEntrys_recAccount_OVR);
        this.tblMain.getColumn("account").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("name").getStyleAttributes().setLocked(true);
        this.setDataDirectionColumnEidtor();
        this.setIsContractColmuEditor();
    }

    private void setIsContractColmuEditor() {
        KDCheckBox checkIsContract = new KDCheckBox();
        KDTDefaultCellEditor kdIsContractEditor = new KDTDefaultCellEditor((JCheckBox)checkIsContract);
        this.tblMain.getColumn(COL_ISCONTRACT).setEditor((ICellEditor)kdIsContractEditor);
    }

    private void setDataDirectionColumnEidtor() {
        KDComboBox comboDataDirection = new KDComboBox();
        Iterator it = ContrastAccountViewDerectionEnum.iterator();
        while (it.hasNext()) {
            comboDataDirection.addItem(it.next());
        }
        KDTDefaultCellEditor kdDataDirectionEditor = new KDTDefaultCellEditor((JComboBox)comboDataDirection);
        this.tblMain.getColumn("dataDirection").setEditor((ICellEditor)kdDataDirectionEditor);
        this.tblMain.getColumn("dataDirection").getStyleAttributes().setLocked(false);
    }

    protected void initWorkButton() {
        try {
            this.startPeriod = this.getStartPeriod();
            if (this.startPeriod == null) {
                throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{this.currentCompany.getName() + this.getSystemEnumForOA().getAlias()});
            }
            this.currPeriod = this.getCurrPeriod();
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnAddNew);
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.setButtonDefaultStyl(this.btnRemove);
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.setButtonDefaultStyl(this.btnSave);
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.menuItemSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    private void insertControlAccountView() throws Exception {
        String accountTableID = this.getAccountTableID();
        AccountViewCollection coll = this.iContrastAccountView.getControlAccountView(this.system, this.currentCompany, accountTableID);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            AccountViewInfo accountViewInfo = coll.get(i);
            IRow row = this.tblMain.addRow();
            row.getCell("account").setValue((Object)accountViewInfo);
            row.getCell("name").setValue((Object)accountViewInfo.getLongName());
            row.getCell("account").getStyleAttributes().setBackground(Color.decode("#E8E8E3"));
            row.getCell("account").getStyleAttributes().setLocked(true);
            row.getCell("name").getStyleAttributes().setBackground(Color.decode("#E8E8E3"));
            row.getCell("name").getStyleAttributes().setLocked(true);
            ++this.rowcount;
        }
        this.tblMain.setRowCount(this.rowcount);
    }

    private void insertContrastAccountView(int periodYear, int periodNumber) throws Exception {
        String accountTableID = this.getAccountTableID();
        IRowSet rs = this.iContrastAccountView.getAccountView(this.system, this.currentCompany, accountTableID, periodYear, periodNumber);
        this.tblMain.removeRows();
        this.rowcount = 0;
        HashSet<String> accountIDSet = new HashSet<String>();
        rs.beforeFirst();
        while (rs.next()) {
            String accountid = rs.getString("faccountid");
            if (accountid == null || "".equals(accountid)) continue;
            accountIDSet.add(accountid);
        }
        HashMap<String, AccountViewInfo> accountViewMap = new HashMap<String, AccountViewInfo>();
        AccountViewInfo accountViewInfo = null;
        if (accountIDSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("number"));
            view.getSelector().add(new SelectorItemInfo("name"));
            view.getSelector().add(new SelectorItemInfo("longName"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", accountIDSet, CompareType.INCLUDE));
            view.setFilter(filter);
            AccountViewCollection accountViewColl = this.iAccountView.getAccountViewCollection(view);
            int size = accountViewColl.size();
            for (int i = 0; i < size; ++i) {
                accountViewInfo = accountViewColl.get(i);
                accountViewMap.put(accountViewInfo.getId().toString(), accountViewInfo);
            }
        }
        rs.beforeFirst();
        while (rs.next()) {
            String id = rs.getString("fid");
            String accountid = rs.getString("faccountid");
            if (accountid == null || "".equals(accountid)) continue;
            accountViewInfo = (AccountViewInfo)accountViewMap.get(accountid);
            IRow row = this.tblMain.addRow();
            row.getCell("id").setValue((Object)id);
            row.getCell("account").setValue((Object)accountViewInfo);
            row.getCell("name").setValue((Object)accountViewInfo.getLongName());
            row.getCell("dataDirection").setValue((Object)ContrastAccountViewDerectionEnum.getEnum(rs.getInt("FDataDirection")));
            row.getCell("periodYear").setValue((Object)new Integer(rs.getInt("FPeriodYear")));
            row.getCell("periodNumber").setValue((Object)new Integer(rs.getInt("FPeriodNumber")));
            row.getCell(COL_ISCONTRACT).setValue((Object)(rs.getInt("FisContrast") == 1 ? 1 : 0));
            this.fillAsstActTypeCell(row.getCell("asstActType"), rs.getString("fAsstActTypeID"), accountid);
            row.getCell("account").getStyleAttributes().setLocked(true);
            row.getCell("name").getStyleAttributes().setLocked(true);
            ++this.rowcount;
        }
        this.tblMain.setRowCount(this.rowcount);
    }

    private void fillAsstActTypeCell(ICell cell, String selectedAsstActTypeID, String accountid) throws BOSException {
        AsstActTypeCollection asstCol = this.iContrastAccountView.getAsstActType(accountid, this.currentCompany.getId().toString());
        if (asstCol.size() != 0) {
            KDComboBox combAsstActType = new KDComboBox();
            Iterator it = asstCol.iterator();
            AsstActTypeInfo firstPriorityInfo = null;
            while (it.hasNext()) {
                AsstActTypeInfo item = (AsstActTypeInfo)it.next();
                combAsstActType.addItem((Object)item);
                if (!item.getId().toString().equals(selectedAsstActTypeID)) continue;
                firstPriorityInfo = item;
            }
            if (firstPriorityInfo == null) {
                firstPriorityInfo = this.getFirstPriorityAsstActType(asstCol);
            }
            cell.setValue(firstPriorityInfo);
            cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)combAsstActType));
            cell.getStyleAttributes().setLocked(false);
            cell.getStyleAttributes().setBackground(new Color(252, 251, 223));
        } else {
            cell.setValue(null);
            cell.getStyleAttributes().setLocked(true);
            cell.getStyleAttributes().setBackground(Color.WHITE);
        }
    }

    private AsstActTypeInfo getFirstPriorityAsstActType(AsstActTypeCollection asstCol) {
        AsstActTypeInfo info = asstCol.get(0);
        for (int i = 1; i < asstCol.size(); ++i) {
            AsstActTypeInfo nextInfo = asstCol.get(i);
            String nextHgType = nextInfo.getAsstHGAttribute();
            String infoHgType = info.getAsstHGAttribute();
            if (infoHgType.equals("customer")) break;
            if (infoHgType.equals("provider") && nextHgType.equals("customer")) {
                info = nextInfo;
                continue;
            }
            if (infoHgType.equals("adminOrg") && (nextHgType.equals("provider") || nextHgType.equals("customer"))) {
                info = nextInfo;
                continue;
            }
            if (infoHgType.equals("person") && (nextHgType.equals("provider") || nextHgType.equals("customer") || nextHgType.equals("adminOrg"))) {
                info = nextInfo;
                continue;
            }
            if (!nextHgType.equals("provider") && !nextHgType.equals("customer") && !nextHgType.equals("adminOrg") && !nextHgType.equals("person")) continue;
            info = nextInfo;
        }
        return info;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ContrastAccountViewFactory.getRemoteInstance();
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                ContrastAccountViewListUI.this.tblMain_afterDataFill(e);
            }
        });
        this.tblMain.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                if (e.getColIndex() == ContrastAccountViewListUI.this.tblMain.getColumnIndex("dataDirection") && ContrastAccountViewDerectionEnum.DirectionOppPositive.equals(ContrastAccountViewListUI.this.tblMain.getCell(e.getRowIndex(), e.getColIndex()).getValue())) {
                    ContrastAccountViewListUI.this.isOppPositive = true;
                }
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
    }

    private void tblMain_afterDataFill(KDTDataRequestEvent e) {
        try {
            this.changeData(e.getFirstRow(), e.getLastRow());
        }
        catch (BOSException e1) {
            this.handleException((Exception)((Object)e1));
        }
        catch (EASBizException e2) {
            this.handleException((Exception)((Object)e2));
        }
    }

    private void changeData(int beginRow, int endRow) throws BOSException, EASBizException {
        for (int i = beginRow; i <= endRow; ++i) {
            IRow row = this.tblMain.getRow(i);
            Object accountObj = row.getCell("account").getValue();
            if (accountObj == null || !(accountObj instanceof String)) continue;
            AccountViewInfo accountViewInfo = this.iAccountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountObj.toString()));
            row.getCell("account").setValue((Object)accountViewInfo);
        }
    }

    private void verify() {
        int size = this.tblMain.getRowCount3();
        if (size == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("no_data"));
            SysUtil.abort();
        }
    }

    private void checkAccontRepeat() throws BOSException, EASBizException {
        ArrayList<String> list = new ArrayList<String>(100);
        int size = this.tblMain.getRowCount();
        for (int i = size - 1; i >= 0; --i) {
            IRow row = this.tblMain.getRow(i);
            if (row.getCell("account").getValue() == null) continue;
            AccountViewInfo accountViewInfo = (AccountViewInfo)row.getCell("account").getValue();
            if (list.contains(accountViewInfo.getId().toString())) {
                String message = this.getStrResource("contrast_account_view_order") + String.valueOf(i + 1) + this.getStrResource("contrast_account_view_row") + accountViewInfo.getName() + "(" + accountViewInfo.getNumber() + ")" + this.getStrResource("account_repeat");
                int value = MsgBox.showConfirm2((Component)((Object)this), (String)message);
                if (value == 1 || value == 2) {
                    SysUtil.abort();
                    continue;
                }
                this.deleteRow(i);
                continue;
            }
            list.add(accountViewInfo.getId().toString());
        }
    }

    private void verifyInput() throws BOSException, EASBizException {
        this.verify();
        int size = this.tblMain.getRowCount3();
        if (size == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("no_data"));
            SysUtil.abort();
        }
        for (int i = 0; i < size; ++i) {
            String number;
            IRow row = this.tblMain.getRow(i);
            if (row.getCell("account").getValue() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("account_number_null"));
                SysUtil.abort();
            } else {
                number = row.getCell("account").getValue().toString().trim();
                if ("".equals(number)) {
                    MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("account_number_null"));
                    SysUtil.abort();
                }
            }
            if (row.getCell("name").getValue() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("account_name_null"));
                SysUtil.abort();
            } else {
                number = row.getCell("name").getValue().toString().trim();
                if ("".equals(number)) {
                    MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("account_name_null"));
                    SysUtil.abort();
                }
            }
            if (row.getCell("asstActType").getStyleAttributes().isLocked() || row.getCell("asstActType").getValue() != null) continue;
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("asstType_null"));
            SysUtil.abort();
        }
        if (this.isOppPositive) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("warn_DAP"));
        }
        this.checkAccontRepeat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        Uuid mutexUuid = Uuid.create();
        try {
            int i;
            MutexParameter param = ArApMutextUtils.getMutexParameter(null, null, mutexUuid, ((Object)((Object)this)).getClass().toString(), "actionSave_actionPerformed", MutexLockType.EXCLUSIVE_LOCK, SysContext.getSysContext().getCurrentFIUnit().getId(), SysContext.getSysContext().getCurrentUserInfo().getId());
            if (!ArApMutextUtils.requestMutex(null, param)) {
                ArApRecPayHelper.throwExcetion((String)ArApBillUIUtil.getStrResource("DataMutex"));
            }
            this.verifyInput();
            int size = this.tblMain.getRowCount3();
            CoreBaseCollection submitCoreColl = new CoreBaseCollection();
            CoreBaseCollection updateCoreColl = new CoreBaseCollection();
            IRow row = null;
            AccountViewInfo accountViewInfo = null;
            String id = null;
            String accountTableID = null;
            AccountTableInfo accountTableInfo = null;
            for (i = 0; i < size; ++i) {
                ContrastAccountViewInfo info = new ContrastAccountViewInfo();
                row = this.tblMain.getRow(i);
                if (row.getCell("id").getValue() != null) {
                    id = row.getCell("id").getValue().toString();
                    info.setId(BOSUuid.read((String)id));
                }
                if (row.getCell("account").getValue() != null) {
                    accountViewInfo = (AccountViewInfo)row.getCell("account").getValue();
                    info.setAccount(accountViewInfo);
                }
                if (row.getCell("periodYear").getValue() == null) {
                    info.setPeriodYear(this.spnPeriodYear.getIntegerVlaue());
                }
                if (row.getCell("periodNumber").getValue() == null) {
                    info.setPeriodNumber(this.spnPeriodNumber.getIntegerVlaue());
                }
                if (row.getCell("name").getValue() != null) {
                    String name = row.getCell("name").getValue().toString();
                    info.setName(name);
                }
                info.setDataDirection((ContrastAccountViewDerectionEnum)((Object)row.getCell("dataDirection").getValue()));
                if (row.getCell("asstActType").getValue() != null) {
                    info.setDefaultAsstActType((AsstActTypeInfo)row.getCell("asstActType").getValue());
                } else {
                    info.setDefaultAsstActType(null);
                }
                info.setIsContrast(Boolean.valueOf(row.getCell(COL_ISCONTRACT).getValue().toString()));
                if (info.getId() != null) {
                    updateCoreColl.add((CoreBaseInfo)info);
                    continue;
                }
                if (accountTableID == null) {
                    accountTableID = this.getAccountTableID();
                }
                if (accountTableInfo == null) {
                    accountTableInfo = new AccountTableInfo();
                    accountTableInfo.setId(BOSUuid.read((String)accountTableID));
                }
                info.setAccountTableID(accountTableInfo);
                info.setSystem(this.system);
                info.setCompany(this.currentCompany);
                info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
                submitCoreColl.add((CoreBaseInfo)info);
            }
            this.dataChanged = false;
            if (submitCoreColl.size() > 0) {
                this.iContrastAccountView.submit(submitCoreColl);
                block4: for (i = 0; i < size; ++i) {
                    row = this.tblMain.getRow(i);
                    if (row.getCell("account").getValue() == null) continue;
                    accountViewInfo = (AccountViewInfo)row.getCell("account").getValue();
                    int count = submitCoreColl.size();
                    for (int j = 0; j < count; ++j) {
                        if (!accountViewInfo.getNumber().equals(((AccountViewInfo)submitCoreColl.get(j).get("account")).getNumber())) continue;
                        row.getCell("id").setValue((Object)submitCoreColl.get(j).get("id").toString());
                        submitCoreColl.removeObject(j);
                        continue block4;
                    }
                }
            }
            if (updateCoreColl.size() > 0) {
                this.iContrastAccountView.update(updateCoreColl);
            }
            CacheServiceFactory.getInstance().discardQuery((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.ar.app.F7AccountViewQuery"));
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.common.EASCommonResource", (String)"saveSuccessed"));
            this.showMessage();
            this.isOppPositive = false;
        }
        finally {
            ArApMutextUtils.releaseMutex(null, mutexUuid);
        }
    }

    private void verifyRemove() {
        this.verify();
        int size = this.tblMain.getRowCount3();
        for (int i = 0; i < size; ++i) {
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null || this.tblMain.getRowCount() == 0) {
            MsgBox.showInfo((String)this.getStrResource("no_select_data"));
            SysUtil.abort();
        }
        for (int i = selectBlock.getEndRow(); i >= selectBlock.getTop(); --i) {
            int value;
            AccountViewInfo accountViewInfo;
            IRow row = this.tblMain.getRow(i);
            if (row.getCell("id").getValue() == null || (accountViewInfo = (AccountViewInfo)row.getCell("account").getValue()) == null || !this.iContrastAccountView.existAccouSettle(this.currentCompany.getId().toString(), accountViewInfo.getId().toString(), this.system) || (value = MsgBox.showConfirm2((Component)((Object)this), (String)(accountViewInfo.getName() + "(" + accountViewInfo.getNumber() + ")" + this.getStrResource("account_in_arbalance_collate")))) != 1 && value != 2) continue;
            SysUtil.abort();
        }
        int value = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.common.EASCommonResource", (String)"confirmDelete"));
        if (value == 1 || value == 2) {
            SysUtil.abort();
        }
        for (int i = selectBlock.getEndRow(); i >= selectBlock.getTop(); --i) {
            this.deleteRow(i);
        }
        CacheServiceFactory.getInstance().discardQuery((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.ar.app.F7AccountViewQuery"));
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.common.EASCommonResource", (String)"deleteSuccessed"));
        this.showMessage();
    }

    private void deleteRow(int i) throws BOSException, EASBizException {
        String id;
        ObjectUuidPK pk;
        IRow row = this.tblMain.getRow(i);
        if (row.getCell("id").getValue() != null && this.iContrastAccountView.exists((IObjectPK)(pk = new ObjectUuidPK(id = row.getCell("id").getValue().toString())))) {
            this.iContrastAccountView.delete((IObjectPK)pk);
        }
        this.tblMain.removeRow(i);
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.addRow();
        this.tblMain.setRowCount(this.tblMain.getRowCount() + 1);
        this.dataChanged = true;
    }

    @Override
    public void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    @Override
    public void tblMain_editValueChanged(KDTEditEvent e) throws Exception {
        super.tblMain_editValueChanged(e);
        if (e.getColIndex() == this.tblMain.getColumn("account").getColumnIndex() && e.getValue() != null) {
            IRow row = this.tblMain.getRow(e.getRowIndex());
            AccountViewInfo accountViewInfo = (AccountViewInfo)e.getValue();
            row.getCell("name").setValue((Object)accountViewInfo.getLongName());
            this.fillAsstActTypeCell(row.getCell("asstActType"), null, accountViewInfo.getId().toString());
        }
    }

    @Override
    public void tblMain_editStopped(KDTEditEvent e) throws Exception {
        super.tblMain_editStopped(e);
        if (e.getColIndex() == this.tblMain.getColumn("account").getColumnIndex()) {
            Object oldValue = e.getOldValue();
            if (e.getValue() != null && !e.getValue().equals(oldValue)) {
                IRow row = this.tblMain.getRow(e.getRowIndex());
                AccountViewInfo accountViewInfo = (AccountViewInfo)e.getValue();
                if (!accountViewInfo.isIsLeaf()) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"IsOnlyLeaf"));
                    row.getCell("account").setValue(oldValue);
                    return;
                }
                row.getCell("name").setValue((Object)accountViewInfo.getLongName());
                row.getCell("dataDirection").setValue((Object)ContrastAccountViewDerectionEnum.DirectionNegative);
                row.getCell(COL_ISCONTRACT).setValue((Object)true);
                this.fillAsstActTypeCell(row.getCell("asstActType"), null, accountViewInfo.getId().toString());
            }
        }
    }

    protected IIDList getSelectedKeyValuesForHasQueryPK() {
        return null;
    }

    private String getStrResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)key);
    }

    private String getAccountTableID(PeriodInfo period) throws EASBizException, BOSException {
        if (this.currentCompany.getAccountTable() == null) {
            return null;
        }
        return AccountUtils.getCurrentAcctTable(this.currentCompany.getId().toString(), this.currentCompany.getAccountTable().getId().toString(), period);
    }

    private String getAccountTableID() throws EASBizException, BOSException {
        String accountTableID = null;
        accountTableID = this.currPeriod != null ? this.getAccountTableID(this.currPeriod) : this.getAccountTableID(this.startPeriod);
        return accountTableID;
    }

    private AccountTableInfo getAccountTable(String id) throws EASBizException, BOSException {
        if (id == null) {
            throw new AccountException(AccountException.CURRENTCOMPANYHASNOSTARTACCOUNTTABLE);
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IAccountTable iAccountTable = AccountTableFactory.getRemoteInstance();
        return iAccountTable.getAccountTableInfo((IObjectPK)pk);
    }

    protected boolean checkBeforeWindowClosing() {
        if (this.dataChanged) {
            String message = this.getStrResource("data_changed");
            int val = MsgBox.showConfirm3((Component)((Object)this), (String)message);
            if (val == 0) {
                try {
                    this.actionSave_actionPerformed(null);
                }
                catch (Exception e) {
                    Logger.error((Throwable)e);
                }
                return false;
            }
            return true;
        }
        return super.checkBeforeWindowClosing();
    }

    private void setPeriod(PeriodInfo period) throws BOSException, EASBizException {
        int startPeriodYear = this.getStartPeriod().getPeriodYear();
        int endPeriodYear = this.getCurrPeriod().getPeriodYear();
        SpinnerNumberModel periodYearMode = new SpinnerNumberModel(endPeriodYear, startPeriodYear, endPeriodYear, 1);
        this.spnPeriodYear.setModel((SpinnerModel)periodYearMode);
        SpinnerNumberModel periodNumberMode = new SpinnerNumberModel(this.getCurrPeriod().getPeriodNumber(), 1, PeriodUtils.getPeriodCount((PeriodInfo)this.getCurrPeriod(), (boolean)false), 1);
        this.spnPeriodNumber.setModel((SpinnerModel)periodNumberMode);
        this.spnPeriodYear.setValue((Object)new Integer(period.getPeriodYear()));
        this.spnPeriodNumber.setValue((Object)new Integer(period.getPeriodNumber()));
    }

    @Override
    protected void spnPeriodYear_stateChanged(ChangeEvent e) throws Exception {
        this.periodChange();
    }

    @Override
    protected void spnPeriodNumber_stateChanged(ChangeEvent e) throws Exception {
        this.periodChange();
    }

    private void periodChange() throws Exception {
        PeriodInfo period;
        int periodYear = this.spnPeriodYear.getIntegerVlaue();
        int periodNumber = this.spnPeriodNumber.getIntegerVlaue();
        if (periodYear > 1900 && periodNumber >= 1 && periodNumber <= PeriodUtils.getPeriodCount((PeriodInfo)this.getCurrPeriod(), (boolean)false) && (period = this.getPeriod(periodYear, periodNumber)) != null) {
            this.alterContrastAccountView(period);
            this.insertContrastAccountView(period.getPeriodYear(), period.getPeriodNumber());
        }
    }

    private PeriodInfo getPeriod(int periodYear, int periodNumber) throws EASBizException, BOSException {
        return PeriodUtils.getPeriodInfo(null, (int)periodYear, (int)periodNumber, (CompanyOrgUnitInfo)this.currentCompany);
    }

    private void alterContrastAccountView(PeriodInfo period) throws BOSException, EASBizException {
        boolean isClosed = this.isClosedPeriod(period);
        this.setAccountViewModify(!isClosed);
    }

    private boolean isClosedPeriod(PeriodInfo period) throws BOSException, EASBizException {
        if (period == null) {
            return true;
        }
        boolean isClose = false;
        PeriodInfo currentPeriod = this.getCurrPeriod();
        if (period.getPeriodYear() < currentPeriod.getPeriodYear() || period.getPeriodYear() == currentPeriod.getPeriodYear() && period.getPeriodNumber() < currentPeriod.getPeriodNumber()) {
            isClose = true;
        }
        return isClose;
    }

    private void setAccountViewModify(boolean isModify) {
        this.actionAddNew.setEnabled(isModify);
        this.actionRemove.setEnabled(isModify);
        this.actionSave.setEnabled(isModify);
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = new RequestContext();
            request.put("system", (Object)1);
            request.put("currentCompany", (Object)SysContext.getSysContext().getCurrentFIUnit());
            handler.setRequestContext((Serializable)request);
        }
        return handler;
    }
}

