/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ar.ContrastGLCheckParam;
import com.kingdee.eas.fi.ar.ContrastGLFacadeFactory;
import com.kingdee.eas.fi.ar.IContrastGLFacade;
import com.kingdee.eas.fi.ar.IReportData;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.client.AbstractContrastGLCheckRptUI;
import com.kingdee.eas.fi.ar.client.ContrastGLCheckUI;
import com.kingdee.eas.fi.ar.client.ReportLoader;
import com.kingdee.eas.fi.ar.client.TableExportAction;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.client.util.ArApReportUIUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class ContrastGLCheckRptUI
extends AbstractContrastGLCheckRptUI {
    private static final Logger logger = CoreUIObject.getLogger(ContrastGLCheckRptUI.class);
    protected static final String RES = "com.kingdee.eas.fi.ar.client.ArResource";
    protected CompanyOrgUnitInfo currentCompany = null;
    private TableExportAction exportAction = null;
    protected ContrastGLCheckParam tempParam;
    protected PeriodInfo cacheCurrentPeriod;

    protected void checkBeforeLoad() throws Exception {
        if (ArClientUtils.getArStartPeriod(this.currentCompany) == null) {
            throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{this.currentCompany.getName() + this.getSystemEnumForOA().getAlias()});
        }
        this.cacheCurrentPeriod = ArClientUtils.getArCurrentPeriod(this.currentCompany);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    public void onLoad() throws Exception {
        this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        ArApReportUIUtil.checkCompany((Component)((Object)this), this.currentCompany);
        super.onLoad();
        this.checkBeforeLoad();
        this.tblMain.checkParsed();
        this.enableExportExcel(this.tblMain);
        this.tblMain.setEditable(false);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnToNextPeriod.setIcon(EASResource.getIcon((String)"imgTbtn_conversionsave"));
        this.showCheckUI();
    }

    private void showCheckUI() throws BOSException, EASBizException, UIException {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"ID", null);
        uiContext.put((Object)"company", (Object)this.currentCompany);
        this.setSubSys(uiContext);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ContrastGLCheckUI.class.getName(), (Map)uiContext, null);
        window.show();
        ContrastGLCheckUI paramUI = (ContrastGLCheckUI)window.getUIObject();
        if (paramUI.isConfirm()) {
            ContrastGLCheckParam param;
            this.tempParam = param = paramUI.getParam();
            this.getData(param);
        } else {
            SysUtil.abort();
        }
    }

    protected void setSubSys(UIContext uiContext) {
        uiContext.put((Object)"isAr", (Object)"true");
    }

    protected IReportData getCheckReport(ContrastGLCheckParam param) throws BOSException, EASBizException {
        IContrastGLFacade iContrast = ContrastGLFacadeFactory.getRemoteInstance();
        IReportData rptData = null;
        rptData = iContrast.checkARGL(param);
        return rptData;
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        if (this.exportAction == null) {
            this.exportAction = new TableExportAction(this.tblMain);
        }
        this.exportAction.export();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.getPrintManager().printPreview();
    }

    @Override
    public void actionToNextPeriod_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        int rowCount = this.tblMain.getRowCount();
        HashSet<String> toNextPeriodBillType = new HashSet<String>();
        toNextPeriodBillType.add("otherbill");
        toNextPeriodBillType.add("proxybill");
        toNextPeriodBillType.add("receivingbill");
        toNextPeriodBillType.add("incomeConfirm");
        for (int i = 0; i < rowCount; ++i) {
            IRow irow = this.tblMain.getRow(i);
            String billType = irow.getCell("billType").getValue().toString();
            String isaudited = irow.getCell("IsAudited").getValue().toString();
            String item = irow.getCell("Item").getValue().toString();
            if (EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"21_ApContrastGLCheckRptUI").equals(item) || !toNextPeriodBillType.contains(billType) || !isaudited.equals("0")) continue;
            String billID = irow.getCell("billID").getValue().toString();
            map.put(billID, billType);
        }
        if (map.size() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("NoDataToNext"));
            return;
        }
        IContrastGLFacade ContrastGLFacade2 = ContrastGLFacadeFactory.getRemoteInstance();
        boolean flag = ContrastGLFacade2.toNextPeriod1(map, true, SysContext.getSysContext().getCurrentFIUnit(), this.cacheCurrentPeriod);
        if (flag) {
            MsgBox.showInfo((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("ToNextOK"));
            this.getData(this.tempParam);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("NoDataToNext"));
        }
    }

    protected void getData(ContrastGLCheckParam param) throws EASBizException, BOSException {
        if (!(param.isCheckBillAudited() || param.isCheckBillVouchered() || param.isCheckVoucherRelatedBill() || param.isCheckVoucherPeriod() || param.ischkCashVerifiBill())) {
            return;
        }
        this.tblMain.refresh();
        IReportData rptData = this.getCheckReport(param);
        if (rptData != null && rptData.size() > 0) {
            ReportLoader loader = new ReportLoader(this.tblMain);
            loader.loadData(rptData);
        }
        if (rptData == null || rptData.size() == 0) {
            this.tblMain.refresh();
        }
    }
}

