/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.ap.client.util.ApClientUtils;
import com.kingdee.eas.fi.ar.ContrastGLCheckParam;
import com.kingdee.eas.fi.ar.client.AbstractContrastGLCheckUI;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.ar.client.util.CommonClientUtils;
import com.kingdee.eas.fi.arap.ArApConstants;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ContrastGLCheckUI
extends AbstractContrastGLCheckUI {
    private static final Logger logger = CoreUIObject.getLogger(ContrastGLCheckUI.class);
    private CompanyOrgUnitInfo currentCompany = null;
    private int windowClose = -1;
    private ContrastGLCheckParam param = null;
    private static final int ACCTS_LIMITED = 1000;

    public void onLoad() throws Exception {
        boolean isRelatedGL;
        super.onLoad();
        this.lblWizardImg.setIcon(EASResource.getIcon((String)"imgGuide_pic338"));
        this.tblAccts.checkParsed();
        this.tblAccts.setActiveCellStatus(1);
        this.tblAccts.addRow();
        this.btnAddRow.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelRow.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        boolean isAr = true;
        if (this.getUIContext().get("company") != null) {
            this.currentCompany = (CompanyOrgUnitInfo)this.getUIContext().get("company");
        }
        if (this.getUIContext().get("isAr") != null) {
            isAr = Boolean.valueOf((String)this.getUIContext().get("isAr"));
        }
        boolean bl = isRelatedGL = isAr ? ArClientUtils.arIsRelatedAccount(this.currentCompany) : ApClientUtils.apIsRelatedAccount(this.currentCompany);
        if (isRelatedGL) {
            KDBizPromptBox prmptAcct = new KDBizPromptBox();
            CommonClientUtils.setContrastAccountF7((IUIObject)this, prmptAcct, this.currentCompany, isAr);
            prmptAcct.setEnabledMultiSelection(true);
            KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((IKDEditor)prmptAcct);
            this.tblAccts.getColumn(0).setEditor((ICellEditor)cellEditor);
        } else {
            this.btnAddRow.setEnabled(false);
            this.btnDelRow.setEnabled(false);
            this.tblAccts.setEnabled(false);
            this.chkBillVouchered.setSelected(false);
            this.chkVoucherHasBill.setSelected(false);
            this.chkBillVouchered.setEnabled(false);
            this.chkVoucherHasBill.setEnabled(false);
        }
    }

    public boolean isConfirm() {
        return this.windowClose == 1;
    }

    public ContrastGLCheckParam getParam() {
        return this.isConfirm() ? this.param : null;
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        String res = "com.kingdee.eas.fi.ar.client.ArResource";
        if (this.chkVoucherHasBill.isSelected() && this.tblAccts.getRowCount() < 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)res, (String)"ContrastGLCheck_NoAcct"));
            return;
        }
        boolean fChkVouHasBill = this.chkVoucherHasBill.isSelected();
        String acctId = null;
        ArrayList<String> acctIds = new ArrayList<String>();
        int n = this.tblAccts.getRowCount();
        for (int i = 0; i < n; ++i) {
            AccountViewInfo accountInfo = (AccountViewInfo)this.tblAccts.getRow(i).getCell(0).getValue();
            if (fChkVouHasBill && accountInfo == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)res, (String)"ContrastGLCheck_NoAcct"));
                this.tblAccts.getEditManager().editCellAt(i, 0);
                return;
            }
            if (accountInfo == null) continue;
            acctId = accountInfo.getId().toString();
            if (acctIds.contains(acctId)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)res, (String)"CTGL_HasSameAcct"));
                this.tblAccts.getEditManager().editCellAt(i, 0);
                return;
            }
            acctIds.add(accountInfo.getId().toString());
        }
        this.windowClose = 1;
        this.param = new ContrastGLCheckParam();
        this.param.setCompanyId(this.currentCompany.getString("id"));
        this.param.setAccountIds(acctIds);
        this.param.setCheckBillAudited(this.chkBillAudited.isSelected());
        this.param.setCheckBillVouchered(this.chkBillVouchered.isSelected());
        this.param.setCheckVoucherRelatedBill(this.chkVoucherHasBill.isSelected());
        this.param.setCheckVoucherPeriod(this.chkVoucherPeriod.isSelected());
        this.param.setchkCashVerifiBill(this.chkCashVerifiBill.isSelected());
        this.disposeUIWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.windowClose = 0;
        this.disposeUIWindow();
    }

    @Override
    protected void btnAddRow_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblAccts.getRowCount() < 1000) {
            this.tblAccts.addRow();
        }
    }

    @Override
    protected void btnDelRow_actionPerformed(ActionEvent e) throws Exception {
        this.delRow(this.tblAccts);
    }

    private void delRow(KDTable tbl) throws Exception {
        if (tbl.getRowCount() == 0) {
            return;
        }
        if (tbl.getSelectManager().size() > 0) {
            KDTSelectBlock block = tbl.getSelectManager().get();
            if (block != null) {
                tbl.removeRow(block.getTop());
            }
        } else if (tbl.getRowCount() > 0) {
            tbl.removeRow(tbl.getRowCount() - 1);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblAccts.getColumn("account").getStyleAttributes().setBackground(ArApConstants.REQUIRED_COLOR);
        this.tblAccts.requestFocusInWindow();
        this.tblAccts.getSelectManager().select(0, 0);
    }

    @Override
    protected void kdtEditStopped(KDTEditEvent e) {
        if (e.getValue() == null) {
            return;
        }
        Object[] accounts = null;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String key = this.tblAccts.getColumnKey(colIndex);
        Object obj = e.getValue();
        if ("account".equalsIgnoreCase(key)) {
            if (obj instanceof AccountViewInfo) {
                accounts = new AccountViewInfo[]{(AccountViewInfo)obj};
            } else if (obj instanceof Object[]) {
                accounts = (Object[])obj;
            } else {
                return;
            }
            int length = accounts.length;
            AccountViewInfo account = null;
            for (int i = 0; i < length; ++i) {
                account = (AccountViewInfo)accounts[i];
                if (account == null) continue;
                IRow curRow2 = this.tblAccts.getRow(rowIndex + i);
                int curCol = this.tblAccts.getColumnIndex("account");
                curRow2.getCell(curCol).setValue(null);
                curRow2.getCell(curCol).setValue((Object)account);
                if (i >= length - 1) continue;
                this.insertLine(rowIndex + i + 1);
            }
        }
    }

    protected void insertLine(int row) {
        KDTable kdtEntry = this.tblAccts;
        IRow irow = null;
        irow = kdtEntry.addRow(row);
    }
}

