/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ar.ArApQueryParam;
import com.kingdee.eas.fi.ar.ContrastGLFacadeFactory;
import com.kingdee.eas.fi.ar.ContrastGLQueryParam;
import com.kingdee.eas.fi.ar.IContrastGLFacade;
import com.kingdee.eas.fi.ar.IReportData;
import com.kingdee.eas.fi.ar.client.AbstractContrastGLRptUI;
import com.kingdee.eas.fi.ar.client.ContrastGLQueryUI;
import com.kingdee.eas.fi.ar.client.RptBaseQueryUI;
import com.kingdee.eas.fi.ar.client.contrastGLDefaultSol.CommonQueryDialog;
import com.kingdee.eas.fi.arap.AmountDirectionEnum;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.ContrastGLDiffTypeEnum;
import com.kingdee.eas.fi.arap.ContrastGLRptDetailQueryParam;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.client.ContrastGLRptDetailUI;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.client.util.ArApReportUIUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ContrastGLRptUI
extends AbstractContrastGLRptUI {
    private static final long serialVersionUID = 8232667307063104927L;
    private static final Logger logger = CoreUIObject.getLogger(ContrastGLRptUI.class);
    protected CommonQueryDialog dialog = null;
    protected ContrastGLQueryUI queryUI = null;
    protected IArApBillFacade iBillFacade = ArApBillFacadeFactory.getRemoteInstance();
    protected IContrastGLFacade iContrast = ContrastGLFacadeFactory.getRemoteInstance();
    protected ArApSysParamInfo cache = null;
    protected CompanyOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentFIUnit();
    protected boolean isContrastByBillAccount = false;
    protected AmountDirectionEnum amtDirection = null;

    public ContrastGLRptUI() throws Exception {
        this.cache = this.iBillFacade.getSysParams(this.currentCompany, this.uiParam);
        ArApReportUIUtil.checkCompany((Component)((Object)this), this.currentCompany);
    }

    @Override
    protected boolean isQueryChangeTable() {
        return true;
    }

    @Override
    protected void checkBeforeLoad() throws Exception {
        super.checkBeforeLoad();
        boolean isRelationGL = this.cache.isRelationGL();
        if (!isRelationGL) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.getResource(), (String)"NotRelatedWithGL"));
            SysUtil.abort();
        }
    }

    @Override
    protected RptBaseQueryUI getQueryPanel() throws Exception {
        if (this.queryUI == null) {
            this.queryUI = new ContrastGLQueryUI(true, this.uiParam);
        }
        return this.queryUI;
    }

    protected CommonQueryDialog contrastGLetQueryDialog() throws Exception {
        if (this.dialog == null) {
            this.dialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.dialog.setOwner((Component)((Object)this));
            }
            this.dialog.setShowFilter(false);
            this.dialog.setShowSorter(false);
            this.dialog.setMaxReturnCountVisible(false);
            this.dialog.setQueryObjectPK((IMetaDataPK)queryPK);
            this.dialog.setTitle(this.getUITitle() + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
            this.dialog.addUserPanel((KDPanel)this.getQueryPanel());
            this.dialog.setUiObject((IUIObject)this);
            this.dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        }
        this.dialog.setWidth(450);
        this.dialog.setHeight(500);
        return this.dialog;
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.curIndex = 0;
        if (!this.bLoaded) {
            this.filterParam = this.getDefaultQueryParam();
        }
        if (this.filterParam != null) {
            this.isContrastByBillAccount = ((ContrastGLQueryParam)this.filterParam).isContrastByBillAccount();
            if (this.isContrastByBillAccount && !this.cache.isContrastByBillAccount()) {
                this.filterParam = null;
            }
        }
        if (this.bLoaded || this.filterParam == null) {
            if (!this.contrastGLetQueryDialog().show()) {
                SysUtil.abort();
            }
            this.filterParam = (ArApQueryParam)this.getQueryPanel().getRptParam();
        }
        if (this.filterParam == null) {
            logger.warn((Object)"the query param is null");
            SysUtil.abort();
        }
        this.isContrastByBillAccount = ((ContrastGLQueryParam)this.filterParam).isContrastByBillAccount();
        this.actionView.setEnabled(this.isContrastByBillAccount);
        this.actionView.setVisible(this.isContrastByBillAccount);
        this.prepareGetReport(null).callHandler();
        if (!this.bLoaded || this.isQueryChangeTable()) {
            this.setReportHead(this.filterParam.getReportHead());
        }
        if (this.filterParam.isAllCurrency() && this.currencyColls == null) {
            this.currencyColls = this.iCurrency.getCurrencyCollection(true);
        }
        this.prepareParamForQuery(this.filterParam);
        ActionEvent getEvt = new ActionEvent(this.btnRefresh, 1001, this.btnRefresh.getActionCommand());
        this.actionRefresh.actionPerformed(getEvt);
    }

    @Override
    protected void prepareParamForQuery(ArApQueryParam filterParam) {
        String currentCompanyId = this.currentCompany.getId().toString();
        if (!filterParam.getCompanyId().equals(currentCompanyId)) {
            filterParam.setCompanyId(currentCompanyId);
        }
        ContrastGLQueryParam contrastFilterParam = (ContrastGLQueryParam)filterParam;
        try {
            contrastFilterParam = ContrastGLFacadeFactory.getRemoteInstance().convertContrastAccount(contrastFilterParam, SystemEnum.ACCOUNTSRECEIVABLE == this.getSystemEnumForOA());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        PeriodInfo currentPeriod = this.getCurrentPeriod();
        PeriodInfo startPeriod = this.getStartPeriod();
        if (startPeriod != null) {
            int solution_year = contrastFilterParam.getPeriodYear();
            int solution_num = contrastFilterParam.getPeriodNum();
            if (solution_year < startPeriod.getPeriodYear() || solution_year == startPeriod.getPeriodYear() && solution_num < startPeriod.getPeriodNumber()) {
                contrastFilterParam.setPeriodYear(currentPeriod.getPeriodYear());
                contrastFilterParam.setPeriodNum(currentPeriod.getPeriodNumber());
            }
        }
    }

    @Override
    protected IReportData getReport() throws BOSException, EASBizException {
        ContrastGLQueryParam param = (ContrastGLQueryParam)this.filterParam;
        boolean isAr = SystemEnum.ACCOUNTSRECEIVABLE.equals((Object)this.getSystemEnumForOA());
        int newContrastPeriodNumber = ArApBillUIUtil.getNewContrastPeriodNumber(this.currentCompany.getId().toString(), isAr);
        if (param.isContrastByBillAccount() && newContrastPeriodNumber == 999999) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"AR_045_DISABLED"));
            SysUtil.abort();
        }
        return this.iContrast.arContrastGL(param);
    }

    @Override
    protected PeriodInfo getCurrentPeriod() {
        PeriodInfo currPeriod = null;
        if (this.cache != null) {
            currPeriod = this.cache.getCurrentPeriod(this.getSystemEnumForOA());
        }
        return currPeriod;
    }

    protected PeriodInfo getStartPeriod() {
        PeriodInfo currPeriod = null;
        if (this.cache != null) {
            currPeriod = this.cache.getStartPeriod(this.getSystemEnumForOA());
        }
        return currPeriod;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (!this.isPrepareInit()) {
            return handler;
        }
        RequestContext request = (RequestContext)handler.getRequestContext();
        request.setId((String)this.getUIContext().get("ID"));
        request.setState(this.getOprtState());
        request.setSelectorItemCollection(this.getSelectors());
        request.setOrg(this.getOrgPK(null));
        request.put("uiParam", (Object)this.uiParam);
        request.put("currentCompany", (Object)this.currentCompany);
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    @Override
    public boolean isAsynchronism() {
        return true;
    }

    @Override
    protected String getUIFullName() {
        return "com.kingdee.eas.fi.ar.client.ContrastGLRptUI";
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.isContrastByBillAccount = this.cache.isContrastByBillAccount();
        this.actionView.setEnabled(this.isContrastByBillAccount);
        this.actionView.setVisible(this.isContrastByBillAccount);
    }

    protected List<IRow> getContrstRptSelectRows() {
        int[] rowIds = this.getSelectedRows();
        if (null == rowIds || rowIds.length == 0) {
            return null;
        }
        this.amtDirection = this.tblMain.getColumnIndex("FDebitDiffAmt") == this.currCol || this.tblMain.getColumnIndex("FDebitDiffAmt" + ContrastGLQueryParam.LOCAL_SUFFIX) == this.currCol ? AmountDirectionEnum.DR : (this.tblMain.getColumnIndex("FCreditDiffAmt") == this.currCol || this.tblMain.getColumnIndex("FCreditDiffAmt" + ContrastGLQueryParam.LOCAL_SUFFIX) == this.currCol ? AmountDirectionEnum.CR : null);
        if (null == this.amtDirection) {
            return null;
        }
        int isSum = 0;
        IRow row = null;
        String cellValue = null;
        ArrayList<IRow> dataRows = new ArrayList<IRow>(rowIds.length);
        for (int i = 0; i < rowIds.length; ++i) {
            row = this.tblMain.getRow(rowIds[i]);
            cellValue = this.getCellValue(row, "FIsSum");
            if (null == cellValue || (isSum = Integer.parseInt(cellValue)) != 1) continue;
            dataRows.add(row);
        }
        return dataRows;
    }

    protected ContrastGLRptDetailQueryParam getDetailQueryParam() {
        ContrastGLRptDetailQueryParam param = null;
        List<IRow> dataRows = this.getContrstRptSelectRows();
        if (this.filterParam == null || dataRows == null || dataRows.size() != 1) {
            return param;
        }
        IRow row = dataRows.get(0);
        ContrastGLQueryParam contrastParam = (ContrastGLQueryParam)this.filterParam;
        param = new ContrastGLRptDetailQueryParam();
        param.setCurrencyId(this.getCellValue(row, "FCurrencyID"));
        if (contrastParam.isHasItem()) {
            param.setCussTypeId(this.getCellValue(row, "FCussTypeID"));
            param.setCussAcctId(this.getCellValue(row, "FCussAcct"));
        }
        param.setAccountId(this.getCellValue(row, "FAccountId"));
        param.setHasUnRegVoucher(contrastParam.isHasUnRegVoucher());
        param.setCompanyId(contrastParam.getCompanyId());
        param.setPeriodYear(contrastParam.getPeriodYear());
        param.setPeriodNum(contrastParam.getPeriodNum());
        param.setDiffType(ContrastGLDiffTypeEnum.ALL);
        param.setIsArRpt(SystemEnum.ACCOUNTSRECEIVABLE == this.getSystemEnumForOA());
        param.setAmtDirection(this.amtDirection);
        return param;
    }

    protected String getContrastGLRptDetailUI() {
        return ContrastGLRptDetailUI.class.getName();
    }

    @Override
    protected boolean isViewEnabled() {
        return this.isContrastByBillAccount;
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        ContrastGLRptDetailQueryParam param = this.getDetailQueryParam();
        if (null == param) {
            return;
        }
        String detailUIClass = this.getContrastGLRptDetailUI();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"RPTFilter", (Object)param);
        uiContext.put((Object)"currentPeriod", (Object)this.getCurrentPeriod());
        IUIWindow itemRptUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(detailUIClass, (Map)uiContext, null, OprtState.VIEW);
        itemRptUI.show();
    }

    @Override
    protected ArrayList<String> getLinkedColumnKeys() {
        ArrayList<String> list = null;
        if (this.isContrastByBillAccount) {
            list = new ArrayList<String>(10);
            list.add("FDebitDiffAmt");
            list.add("FDebitDiffAmt" + ContrastGLQueryParam.LOCAL_SUFFIX);
            list.add("FCreditDiffAmt");
            list.add("FCreditDiffAmt" + ContrastGLQueryParam.LOCAL_SUFFIX);
        }
        return list;
    }
}

