/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ap.client.util.ApClientUtils;
import com.kingdee.eas.fi.ap.client.util.ApPeriodHelper;
import com.kingdee.eas.fi.ar.ARAPEnum;
import com.kingdee.eas.fi.ar.ContrastGroupInnerFacadeFactory;
import com.kingdee.eas.fi.ar.IContrastGroupInnerFacade;
import com.kingdee.eas.fi.ar.client.AbstractContrastGroupInnerQueryUI;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.ar.client.util.ArPeriodHelper;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.client.util.BizSysPeriodHelper;
import com.kingdee.eas.fi.ar.client.util.ComBoxInfo;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;

public class ContrastGroupInnerQueryUI
extends AbstractContrastGroupInnerQueryUI {
    private static final long serialVersionUID = 3961554551446095129L;
    protected boolean isSingle = true;
    private CompanyOrgUnitInfo currentCompany = null;
    private CurrencyInfo baseCurrency = null;
    private transient CompanyOrgUnitInfo selectedMComps = null;
    private transient Object[] selectedSComps = null;
    private IContrastGroupInnerFacade iCGIFacade = null;
    private ICompanyOrgUnit iCompanyOrgUnit = null;
    private BizSysPeriodHelper periodHelper = null;
    protected String PERMISSION_ITEM = "fi_ar_ContrastGroup_List";
    protected ICompanyOrgUnit iCompany = null;
    private CompanyOrgUnitInfo defaultCompany = null;
    protected IArApBillFacade iBillFacade;
    protected ArApSysParamInfo currentCache = null;
    protected ArApSysParamInfo currentMasterCache = null;
    protected ArApSysParamInfo currentSecondCache = null;
    protected int f7DisplayMode = 0;
    private boolean isDefaultCompanyPermission = false;

    public ContrastGroupInnerQueryUI() throws Exception {
        this.iBillFacade = ArApBillFacadeFactory.getRemoteInstance();
    }

    public ContrastGroupInnerQueryUI(boolean isSingle) throws Exception {
        this.setSize(475, 245);
        this.isSingle = isSingle;
        this.iCompany = CompanyOrgUnitFactory.getRemoteInstance();
        this.iBillFacade = ArApBillFacadeFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.bizPromptSCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    ContrastGroupInnerQueryUI.this.bizPromptSCompany_dataChanged(e);
                }
                catch (Exception exc) {
                    ContrastGroupInnerQueryUI.this.handUIException(exc);
                }
            }
        });
        this.bizPromptMCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    ContrastGroupInnerQueryUI.this.bizPromptMCompany_dataChanged(e);
                }
                catch (Exception exc) {
                    ContrastGroupInnerQueryUI.this.handUIException(exc);
                }
            }
        });
        this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        this.currentCache = this.iBillFacade.getSysParams(null, this.getUIParam());
        if (this.currentCache != null) {
            this.f7DisplayMode = this.currentCache.getF7DisplayMode();
        }
        if (this.isSingle) {
            this.setCompanyF7(this.bizPromptMCompany);
            this.setCompanyF7(this.bizPromptSCompany);
        } else {
            this.setCompanyF7(this.bizPromptMCompany);
            FullOrgUnitInfo orgInfo = new FullOrgUnitInfo();
            orgInfo.setId(this.currentCompany.getId());
            orgInfo.setName(this.currentCompany.getName());
            NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company, this.getPermissionItem());
            NewCompanyF7 companyF7 = new NewCompanyF7();
            companyF7.setMultiSelect(true);
            companyF7.setPermissionItem(this.getPermissionItem());
            this.bizPromptSCompany.setDisplayFormat("$name$");
            this.bizPromptSCompany.setEditFormat("$number$");
            this.bizPromptSCompany.setCommitFormat("$number$");
            this.bizPromptSCompany.setFilterInfoProducer((IFilterInfoProducer)iProducer);
            this.bizPromptSCompany.setSelector((KDPromptSelector)companyF7);
        }
        this.defaultCompany = this.currentCache.getCompany();
        if (this.defaultCompany != null) {
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            ObjectUuidPK companyPK = new ObjectUuidPK(this.defaultCompany.getId().toString());
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
            this.isDefaultCompanyPermission = iPermission.hasFunctionPermission((IObjectPK)userPK, (IObjectPK)companyPK, this.getPermissionItem());
            if (this.isDefaultCompanyPermission) {
                this.bizPromptMCompany.setData((Object)this.defaultCompany);
            }
            this.setPeriod(true, this.isMARDirection(), true);
        }
        if (this.isARSystem()) {
            this.setContrastDirection(this.cmbMContrastDirection, "AR");
            this.setContrastDirection(this.cmbSContrastDirection, "AP");
        } else {
            this.setContrastDirection(this.cmbMContrastDirection, "AP");
            this.setContrastDirection(this.cmbSContrastDirection, "AR");
        }
        if (this.isSingle) {
            this.bizPromptMAsstAct.setRequired(true);
            this.bizPromptSAsstAct.setRequired(true);
        } else {
            this.setCurrencyF7(this.bizPromptMAsstAct);
            this.setCurrencyF7(this.bizPromptSAsstAct);
            this.cmbMAsstActType.setEnabled(false);
            this.cmbSAsstActType.setEnabled(false);
            this.bizPromptMAsstAct.setEnabled(false);
            this.bizPromptSAsstAct.setEnabled(false);
        }
        boolean isAr = this.isARSystem();
        this.makeAsstActType(this.cmbMAsstActType, this.defaultCompany.getId().toString(), isAr, this.currentCache);
        this.makeAsstActType(this.cmbSAsstActType, this.defaultCompany.getId().toString(), !isAr, this.currentCache);
        this.setCurrencyF7(this.bizPromptMCurrency);
        this.setCurrencyF7(this.bizPromptSCurrency);
        this.baseCurrency = this.currentCompany.getBaseCurrency();
        this.bizPromptMCurrency.setValue((Object)this.baseCurrency);
        this.bizPromptSCurrency.setValue((Object)this.baseCurrency);
        this.iCGIFacade = ContrastGroupInnerFacadeFactory.getRemoteInstance();
        this.iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        boolean single = this.isSingle();
        this.spinnerSContrastYear.setEnabled(single);
        this.spinnerSContrastPeriod.setEnabled(single);
        this.setHistoryRecordEnabled(false);
        this.bizPromptMCompany.getEditor().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                try {
                    ContrastGroupInnerQueryUI.this.bizPromptMCompany_focusLost(e);
                }
                catch (Exception exc) {
                    ContrastGroupInnerQueryUI.this.handUIException(exc);
                }
            }
        });
        this.bizPromptSCompany.getEditor().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                try {
                    ContrastGroupInnerQueryUI.this.bizPromptSCompany_focusLost(e);
                }
                catch (Exception exc) {
                    ContrastGroupInnerQueryUI.this.handUIException(exc);
                }
            }
        });
        this.bizPromptMCurrency.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    ContrastGroupInnerQueryUI.this.bizPromptMCurrency_dataChanged(e);
                }
                catch (Exception exc) {
                    ContrastGroupInnerQueryUI.this.handUIException(exc);
                }
            }
        });
        this.cmbMAsstActType.setFocusable(false);
        this.cmbMAsstActType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    ContrastGroupInnerQueryUI.this.cmbMAsstActType_itemStateChanged(e);
                }
                catch (Exception exc) {
                    ContrastGroupInnerQueryUI.this.handUIException(exc);
                }
            }
        });
        this.cmbSAsstActType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    ContrastGroupInnerQueryUI.this.cmbSAsstActType_itemStateChanged(e);
                }
                catch (Exception exc) {
                    ContrastGroupInnerQueryUI.this.handUIException(exc);
                }
            }
        });
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void setHistoryRecordEnabled(boolean enabled) {
        this.bizPromptMCompany.setHistoryRecordEnabled(enabled);
        this.bizPromptSCompany.setHistoryRecordEnabled(enabled);
        this.bizPromptMAsstAct.setHistoryRecordEnabled(enabled);
        this.bizPromptSAsstAct.setHistoryRecordEnabled(enabled);
        this.bizPromptMCurrency.setHistoryRecordEnabled(enabled);
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public boolean verify() {
        if (this.isSingle) {
            if (this.bizPromptMCompany.getData() == null) {
                BaseDataUtil.showInfo((Component)((Object)this), "m_company_null");
                SysUtil.abort();
            }
            if (this.bizPromptSCompany.getData() == null) {
                BaseDataUtil.showInfo((Component)((Object)this), "s_company_null");
                SysUtil.abort();
            }
            CompanyOrgUnitInfo mCompany = (CompanyOrgUnitInfo)this.bizPromptMCompany.getData();
            CompanyOrgUnitInfo sCompany = (CompanyOrgUnitInfo)this.bizPromptSCompany.getData();
            if (mCompany.getId().toString().equalsIgnoreCase(sCompany.getId().toString())) {
                BaseDataUtil.showInfo((Component)((Object)this), "m_s_company_not_same");
                SysUtil.abort();
            }
        } else {
            if (this.bizPromptMCompany.getData() == null) {
                BaseDataUtil.showInfo((Component)((Object)this), "m_company_null");
                SysUtil.abort();
            }
            if (this.bizPromptSCompany.getData() == null) {
                BaseDataUtil.showInfo((Component)((Object)this), "s_company_null");
                SysUtil.abort();
            }
        }
        Integer mYear = this.spinnerMContrastYear.getIntegerVlaue();
        Integer mPeriodNumber = this.spinnerMContrastPeriod.getIntegerVlaue();
        Integer sYear = this.spinnerSContrastYear.getIntegerVlaue();
        Integer sPeriodNumber = this.spinnerSContrastPeriod.getIntegerVlaue();
        if (mYear == 0 || mPeriodNumber == 0) {
            BaseDataUtil.showInfo((Component)((Object)this), "m_period_null");
            SysUtil.abort();
        }
        if (sYear == 0 || sPeriodNumber == 0) {
            BaseDataUtil.showInfo((Component)((Object)this), "s_period_null");
            SysUtil.abort();
        }
        CompanyOrgUnitInfo mCompany1 = this.getMCompany();
        CompanyOrgUnitInfo[] sCompanys = this.getSCompany();
        CompanyOrgUnitInfo sCompany1 = sCompanys[0];
        try {
            PeriodInfo sPeriod;
            PeriodInfo mPeriod = PeriodUtils.getPeriodInfo((int)mYear, (int)mPeriodNumber, (CompanyOrgUnitInfo)mCompany1);
            if (mPeriod == null) {
                BaseDataUtil.showInfo((Component)((Object)this), "m_period_invalidate");
                SysUtil.abort();
            }
            if ((sPeriod = PeriodUtils.getPeriodInfo((int)sYear, (int)sPeriodNumber, (CompanyOrgUnitInfo)sCompany1)) == null) {
                BaseDataUtil.showInfo((Component)((Object)this), "s_period_invalidate");
                SysUtil.abort();
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        if (this.isSingle) {
            if (this.bizPromptMAsstAct.getData() == null) {
                BaseDataUtil.showInfo((Component)((Object)this), "m_asstact_null");
                SysUtil.abort();
            }
            if (this.bizPromptSAsstAct.getData() == null) {
                BaseDataUtil.showInfo((Component)((Object)this), "s_asstact_null");
                SysUtil.abort();
            }
        }
        if ("".equals(this.bizPromptMCurrency.getText().trim())) {
            BaseDataUtil.showInfo((Component)((Object)this), "s_currency_null");
            SysUtil.abort();
        }
        return true;
    }

    public RptParams getCustomCondition() {
        RptParams rptParams = new RptParams();
        rptParams.setObject("isSingle", (Object)this.isSingle);
        if (this.isSingle) {
            if (this.bizPromptMCompany.getData() != null) {
                CompanyOrgUnitInfo mCompany = (CompanyOrgUnitInfo)this.bizPromptMCompany.getData();
                rptParams.setObject("mCompany", (Object)mCompany);
            }
            if (this.bizPromptSCompany.getData() != null) {
                CompanyOrgUnitInfo sCompany = (CompanyOrgUnitInfo)this.bizPromptSCompany.getData();
                rptParams.setObject("sCompany", (Object)sCompany);
            }
        } else {
            this.selectedMComps = this.getMCompany();
            this.selectedSComps = this.getSCompany();
            rptParams.setObject("selectedMComps", (Object)this.selectedMComps);
            rptParams.setObject("selectedSComps", (Object)this.selectedSComps);
        }
        ARAPEnum mContrastDirection = (ARAPEnum)((Object)this.cmbMContrastDirection.getSelectedItem());
        ARAPEnum sContrastDirection = (ARAPEnum)((Object)this.cmbSContrastDirection.getSelectedItem());
        rptParams.setObject("mContrastDirection", (Object)mContrastDirection);
        rptParams.setObject("sContrastDirection", (Object)sContrastDirection);
        Integer mYear = this.spinnerMContrastYear.getIntegerVlaue();
        Integer sYear = this.spinnerSContrastYear.getIntegerVlaue();
        rptParams.setObject("mYear", (Object)mYear);
        rptParams.setObject("sYear", (Object)sYear);
        Integer mPeriodNumber = this.spinnerMContrastPeriod.getIntegerVlaue();
        Integer sPeriodNumber = this.spinnerSContrastPeriod.getIntegerVlaue();
        rptParams.setObject("mPeriodNumber", (Object)mPeriodNumber);
        rptParams.setObject("sPeriodNumber", (Object)sPeriodNumber);
        AsstActTypeInfo mAsstActTypeInfo = null;
        if (this.cmbMAsstActType.getSelectedItem() != null) {
            mAsstActTypeInfo = (AsstActTypeInfo)((ComBoxInfo)this.cmbMAsstActType.getSelectedItem()).getobjInfo();
        }
        AsstActTypeInfo sAsstActTypeInfo = null;
        if (this.cmbSAsstActType.getSelectedItem() != null) {
            sAsstActTypeInfo = (AsstActTypeInfo)((ComBoxInfo)this.cmbSAsstActType.getSelectedItem()).getobjInfo();
        }
        rptParams.setObject("mAsstActTypeInfo", (Object)mAsstActTypeInfo);
        rptParams.setObject("sAsstActTypeInfo", (Object)sAsstActTypeInfo);
        ArrayList<String> asstActMList = new ArrayList<String>();
        if (this.isSingle && this.bizPromptMAsstAct.getData() != null) {
            if (!(this.bizPromptMAsstAct.getData() instanceof Object[])) {
                IObjectValue mCussent = (IObjectValue)this.bizPromptMAsstAct.getData();
                String id = mCussent.getString("id");
                asstActMList.add(id);
                rptParams.setObject("asstActM", (Object)mCussent);
            } else {
                Object[] asstMObjects = (Object[])this.bizPromptMAsstAct.getData();
                int length = asstMObjects.length;
                for (int i = 0; i < length; ++i) {
                    IObjectValue mCussent = (IObjectValue)asstMObjects[i];
                    String id = mCussent.getString("id");
                    asstActMList.add(id);
                }
                rptParams.setObject("asstActM", (Object)asstMObjects);
            }
        }
        rptParams.setObject("asstActMList", asstActMList);
        ArrayList<String> asstActSList = new ArrayList<String>();
        if (this.isSingle && this.bizPromptSAsstAct.getData() != null) {
            if (!(this.bizPromptSAsstAct.getData() instanceof Object[])) {
                IObjectValue sCussent = (IObjectValue)this.bizPromptSAsstAct.getData();
                String id = sCussent.getString("id");
                asstActSList.add(id);
                rptParams.setObject("asstActS", (Object)sCussent);
            } else {
                Object[] asstSObjects = (Object[])this.bizPromptSAsstAct.getData();
                int length = asstSObjects.length;
                for (int i = 0; i < length; ++i) {
                    IObjectValue sCussent = (IObjectValue)asstSObjects[i];
                    String id = sCussent.getString("id");
                    asstActSList.add(id);
                }
                rptParams.setObject("asstActS", (Object)asstSObjects);
            }
        }
        rptParams.setObject("asstActSList", asstActSList);
        CurrencyInfo mCurrency = null;
        CurrencyInfo sCurrency = null;
        if (this.bizPromptMCurrency.getData() != null) {
            mCurrency = (CurrencyInfo)this.bizPromptMCurrency.getData();
        }
        if (this.bizPromptSCurrency.getData() != null) {
            sCurrency = (CurrencyInfo)this.bizPromptSCurrency.getData();
        }
        rptParams.setObject("mCurrency", (Object)mCurrency);
        rptParams.setObject("sCurrency", (Object)sCurrency);
        rptParams.setObject("isIncludeBizBill", (Object)new Boolean(this.chkIncludeBizBill.isSelected()));
        rptParams.setObject("isBalanceZeroNotShow", (Object)new Boolean(this.chkBalanceZeroNotShow.isSelected()));
        rptParams.setObject("isAmtZeroNotShow", (Object)new Boolean(this.chkAmtZeroNotShow.isSelected()));
        return rptParams;
    }

    public void setCustomCondition(RptParams params) {
        AsstActTypeInfo comObj;
        int i;
        int n;
        CompanyOrgUnitInfo mCompany;
        if (this.isSingle) {
            mCompany = (CompanyOrgUnitInfo)params.getObject("mCompany");
            CompanyOrgUnitInfo sCompany = (CompanyOrgUnitInfo)params.getObject("sCompany");
            this.bizPromptMCompany.setData((Object)mCompany);
            this.bizPromptSCompany.setData((Object)sCompany);
        } else {
            mCompany = (CompanyOrgUnitInfo)params.getObject("selectedMComps");
            this.bizPromptMCompany.setData((Object)mCompany);
            Object[] selectedSComp = (Object[])params.getObject("selectedSComps");
            this.bizPromptSCompany.setData((Object)selectedSComp);
        }
        ARAPEnum mContrastDirection = (ARAPEnum)((Object)params.getObject("mContrastDirection"));
        ARAPEnum sContrastDirection = (ARAPEnum)((Object)params.getObject("sContrastDirection"));
        this.cmbMContrastDirection.setSelectedItem((Object)mContrastDirection);
        this.cmbSContrastDirection.setSelectedItem((Object)sContrastDirection);
        AsstActTypeInfo mAsstActTypeInfo = (AsstActTypeInfo)params.getObject("mAsstActTypeInfo");
        AsstActTypeInfo sAsstActTypeInfo = (AsstActTypeInfo)params.getObject("sAsstActTypeInfo");
        if (mAsstActTypeInfo != null) {
            n = this.cmbMAsstActType.getItemCount();
            for (i = 0; i < n; ++i) {
                comObj = (AsstActTypeInfo)((ComBoxInfo)this.cmbMAsstActType.getItemAt(i)).getobjInfo();
                if (!comObj.getId().toString().equalsIgnoreCase(mAsstActTypeInfo.getId().toString())) continue;
                this.cmbMAsstActType.setSelectedIndex(i);
                break;
            }
        }
        if (sAsstActTypeInfo != null) {
            n = this.cmbSAsstActType.getItemCount();
            for (i = 0; i < n; ++i) {
                comObj = (AsstActTypeInfo)((ComBoxInfo)this.cmbSAsstActType.getItemAt(i)).getobjInfo();
                if (!comObj.getId().toString().equalsIgnoreCase(sAsstActTypeInfo.getId().toString())) continue;
                this.cmbSAsstActType.setSelectedIndex(i);
                break;
            }
        }
        if (this.isSingle) {
            Object[] obj;
            if (params.getObject("asstActM") instanceof Object[]) {
                obj = (Object[])params.getObject("asstActM");
                this.bizPromptMAsstAct.setData((Object)obj);
            } else {
                obj = (Object[])params.getObject("asstActM");
                this.bizPromptMAsstAct.setData((Object)obj);
            }
            if (params.getObject("asstActS") instanceof Object[]) {
                obj = (Object[])params.getObject("asstActS");
                this.bizPromptSAsstAct.setData((Object)obj);
            } else {
                obj = (Object[])params.getObject("asstActS");
                this.bizPromptSAsstAct.setData((Object)obj);
            }
        }
        Integer mYear = (Integer)params.getObject("mYear");
        Integer sYear = (Integer)params.getObject("sYear");
        Integer mPeriodNumber = (Integer)params.getObject("mPeriodNumber");
        Integer sPeriodNumber = (Integer)params.getObject("sPeriodNumber");
        if (mYear != null) {
            this.spinnerMContrastYear.setValue((Object)mYear);
        }
        if (sYear != null) {
            this.spinnerSContrastYear.setValue((Object)sYear);
        }
        if (mPeriodNumber != null) {
            this.spinnerMContrastPeriod.setValue((Object)mPeriodNumber);
        }
        if (sPeriodNumber != null) {
            this.spinnerSContrastPeriod.setValue((Object)sPeriodNumber);
        }
        CurrencyInfo mCurrency = (CurrencyInfo)params.getObject("mCurrency");
        CurrencyInfo sCurrency = (CurrencyInfo)params.getObject("sCurrency");
        this.bizPromptMCurrency.setData((Object)mCurrency);
        this.bizPromptSCurrency.setData((Object)sCurrency);
        if (params.getObject("isIncludeBizBill") != null) {
            this.chkIncludeBizBill.setSelected(((Boolean)params.getObject("isIncludeBizBill")).booleanValue());
        }
        if (params.getObject("isBalanceZeroNotShow") != null) {
            this.chkBalanceZeroNotShow.setSelected(((Boolean)params.getObject("isBalanceZeroNotShow")).booleanValue());
        }
        if (params.getObject("isAmtZeroNotShow") != null) {
            this.chkAmtZeroNotShow.setSelected(((Boolean)params.getObject("isAmtZeroNotShow")).booleanValue());
        }
    }

    @Override
    protected void bizPromptMCompany_focusLost(FocusEvent e) throws Exception {
        if (this.bizPromptMCompany.getData() == null) {
            return;
        }
        if (this.isSingle) {
            if (this.checkSameCompany()) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getResource("m_s_same_company"));
                this.bizPromptMCompany.setData(null);
                this.setMPeriodNull();
                SysUtil.abort();
            }
            if (this.bizPromptSCompany.getData() != null) {
                CoreBaseInfo orgMInfo = (CoreBaseInfo)this.bizPromptMCompany.getData();
                CoreBaseInfo orgSInfo = (CoreBaseInfo)this.bizPromptSCompany.getData();
                ArrayList<String> idList = new ArrayList<String>();
                idList.add(orgMInfo.getId().toString());
                idList.add(orgSInfo.getId().toString());
                if (!this.iCGIFacade.checkSamePeriodType(idList, this.isMARDirection())) {
                    this.setPeriodNull();
                } else {
                    this.setPeriod(true, this.isMARDirection(), false);
                    this.setSingleDefaultPeriod();
                }
            } else {
                this.setPeriod(true, this.isMARDirection(), false);
            }
            this.makeAsstActType();
        } else {
            this.setPeriod(true, this.isMARDirection(), false);
            if (this.bizPromptSCompany.getData() != null) {
                this.setDefaultPeriod();
            }
        }
    }

    public void clear() {
        try {
            if (this.defaultCompany != null) {
                if (this.isDefaultCompanyPermission) {
                    this.bizPromptMCompany.setData((Object)this.defaultCompany);
                } else {
                    this.bizPromptMCompany.setData(null);
                }
                this.setPeriod(true, this.isMARDirection(), false);
            }
            this.bizPromptSCompany.setData(null);
            if (this.isARSystem()) {
                this.setContrastDirection(this.cmbMContrastDirection, "AR");
                this.setContrastDirection(this.cmbSContrastDirection, "AP");
            } else {
                this.setContrastDirection(this.cmbMContrastDirection, "AP");
                this.setContrastDirection(this.cmbSContrastDirection, "AR");
            }
            this.setPeriodNull();
            if (this.isSingle()) {
                this.bizPromptMAsstAct.setRequired(true);
                this.bizPromptSAsstAct.setRequired(true);
            }
            if (this.isARSystem()) {
                this.makeAsstActType(this.cmbMAsstActType, this.defaultCompany.getId().toString(), true, this.currentCache);
                this.makeAsstActType(this.cmbSAsstActType, this.defaultCompany.getId().toString(), false, this.currentCache);
            } else {
                this.makeAsstActType(this.cmbMAsstActType, this.defaultCompany.getId().toString(), false, this.currentCache);
                this.makeAsstActType(this.cmbSAsstActType, this.defaultCompany.getId().toString(), true, this.currentCache);
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        this.bizPromptMAsstAct.setData(null);
        this.bizPromptMCurrency.setData(null);
        this.bizPromptSAsstAct.setData(null);
        this.bizPromptSCurrency.setData(null);
        this.chkIncludeBizBill.setSelected(false);
        this.chkAmtZeroNotShow.setSelected(false);
        this.chkBalanceZeroNotShow.setSelected(false);
    }

    protected void bizPromptMCompany_dataChanged(DataChangeEvent e) throws Exception {
        CompanyOrgUnitInfo mCompany = this.getMCompany();
        if (mCompany == null) {
            mCompany = this.currentCompany;
        }
        AsstActTypeInfo asstActTypeInfo = null;
        if (this.cmbMAsstActType.getSelectedItem() != null) {
            asstActTypeInfo = (AsstActTypeInfo)((ComBoxInfo)this.cmbMAsstActType.getSelectedItem()).getobjInfo();
        }
        if (mCompany != null && asstActTypeInfo != null) {
            ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.bizPromptMAsstAct, (Object)asstActTypeInfo, mCompany.getId().toString(), mCompany.getCU().getId().toString(), true, this.currentMasterCache == null ? this.f7DisplayMode : this.currentMasterCache.getF7DisplayMode(), null, true);
        }
        this.bizPromptMAsstAct.setData(null);
    }

    protected void bizPromptSCompany_dataChanged(DataChangeEvent e) throws Exception {
        CompanyOrgUnitInfo[] sCompany = this.getSCompany();
        CompanyOrgUnitInfo company = null;
        if (sCompany != null) {
            if (sCompany.length > 0) {
                company = sCompany[0];
            }
        } else {
            company = this.currentCompany;
        }
        AsstActTypeInfo asstActTypeInfo = null;
        if (this.cmbSAsstActType.getSelectedItem() != null) {
            asstActTypeInfo = (AsstActTypeInfo)((ComBoxInfo)this.cmbSAsstActType.getSelectedItem()).getobjInfo();
        }
        if (company != null && asstActTypeInfo != null) {
            ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.bizPromptSAsstAct, (Object)asstActTypeInfo, company.getId().toString(), company.getCU().getId().toString(), true, this.currentSecondCache == null ? this.f7DisplayMode : this.currentSecondCache.getF7DisplayMode(), null, true);
        }
        this.bizPromptSAsstAct.setData(null);
    }

    @Override
    protected void bizPromptSCompany_focusLost(FocusEvent e) throws Exception {
        if (this.bizPromptSCompany.getData() == null) {
            return;
        }
        if (this.isSingle) {
            if (this.checkSameCompany()) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getResource("m_s_same_company"));
                this.bizPromptSCompany.setData(null);
                this.setPeriodNull();
                SysUtil.abort();
            }
            if (this.bizPromptSCompany.getData() != null) {
                CoreBaseInfo orgMInfo = (CoreBaseInfo)this.bizPromptMCompany.getData();
                CoreBaseInfo orgSInfo = (CoreBaseInfo)this.bizPromptSCompany.getData();
                ArrayList<String> idList = new ArrayList<String>();
                if (orgMInfo != null) {
                    idList.add(orgMInfo.getId().toString());
                }
                if (orgSInfo != null) {
                    idList.add(orgSInfo.getId().toString());
                }
                if (!this.iCGIFacade.checkSamePeriodType(idList, this.isMARDirection())) {
                    this.setPeriodNull();
                } else {
                    this.setSingleDefaultPeriod();
                }
            }
            this.makeAsstActType();
        } else {
            this.setDefaultPeriod();
        }
    }

    @Override
    protected void spinnerMContrastYear_stateChanged(ChangeEvent e) throws Exception {
        if (this.periodHelper == null) {
            this.periodHelper = this.isMARDirection() ? ArPeriodHelper.getInstance(false) : ApPeriodHelper.getInstance(false);
        }
        if (this.isSingle()) {
            if (this.bizPromptMCompany.getValue() != null) {
                this.periodHelper.setPeriodNum((CompanyOrgUnitInfo)this.bizPromptMCompany.getValue(), this.spinnerMContrastPeriod, this.spinnerMContrastYear);
            }
            PeriodInfo periodInfo = new PeriodInfo();
            if (this.bizPromptSCompany.getValue() != null) {
                periodInfo.setPeriodYear(((Integer)this.spinnerMContrastYear.getValue()).intValue());
                periodInfo.setPeriodNumber(((Integer)this.spinnerMContrastPeriod.getValue()).intValue());
                periodInfo = this.periodHelper.getSPeriod((CompanyOrgUnitInfo)this.bizPromptSCompany.getValue(), null, periodInfo);
                if (periodInfo != null && this.bizPromptSCompany.getValue() != null) {
                    this.setDefaultPeriod();
                } else {
                    this.setPeriodNull();
                }
            } else {
                this.setPeriodNull();
            }
        } else {
            if (this.bizPromptMCompany.getValue() != null) {
                this.periodHelper.setPeriodNum((CompanyOrgUnitInfo)this.bizPromptMCompany.getValue(), this.spinnerMContrastPeriod, this.spinnerMContrastYear);
            }
            this.setDefaultPeriod();
        }
    }

    @Override
    public void spinnerMContrastPeriod_stateChanged(ChangeEvent e) throws Exception {
        if (this.isSingle()) {
            PeriodInfo periodInfo = new PeriodInfo();
            if (this.bizPromptSCompany.getValue() != null) {
                periodInfo.setPeriodYear(((Integer)this.spinnerMContrastYear.getValue()).intValue());
                periodInfo.setPeriodNumber(((Integer)this.spinnerMContrastPeriod.getValue()).intValue());
                periodInfo = this.periodHelper.getSPeriod((CompanyOrgUnitInfo)this.bizPromptSCompany.getValue(), null, periodInfo);
                if (periodInfo != null && this.bizPromptSCompany.getValue() != null) {
                    this.setDefaultPeriod();
                } else {
                    this.setPeriodNull();
                }
            } else {
                this.setPeriodNull();
            }
        } else {
            this.setDefaultPeriod();
        }
    }

    public void cmbMAsstActType_itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1 || this.cmbMAsstActType.getItemCount() == 0 || this.cmbMAsstActType.getSelectedItem() == null) {
            return;
        }
        try {
            CompanyOrgUnitInfo company = null;
            String companyID = null;
            if (this.bizPromptMCompany.getData() != null) {
                company = (CompanyOrgUnitInfo)this.bizPromptMCompany.getData();
            }
            if (company == null) {
                company = this.currentCompany;
            }
            companyID = company.getId().toString();
            AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)((ComBoxInfo)this.cmbMAsstActType.getSelectedItem()).getobjInfo();
            ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.bizPromptMAsstAct, (Object)asstActTypeInfo, companyID, company.getCU().getId().toString(), true, this.currentMasterCache == null ? this.f7DisplayMode : this.currentMasterCache.getF7DisplayMode(), null, true);
            this.bizPromptMAsstAct.setData(null);
        }
        catch (Exception e2) {
            ExceptionHandler.handle((Throwable)e2);
        }
    }

    public void cmbSAsstActType_itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1 || this.cmbSAsstActType.getItemCount() == 0 || this.cmbSAsstActType.getSelectedItem() == null) {
            return;
        }
        try {
            CompanyOrgUnitInfo[] companys;
            CompanyOrgUnitInfo company = null;
            String companyID = null;
            if (this.bizPromptSCompany.getData() != null && (companys = this.getCompany(this.bizPromptSCompany)).length > 0) {
                company = companys[0];
            }
            if (company == null) {
                company = this.currentCompany;
            }
            companyID = company.getId().toString();
            AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)((ComBoxInfo)this.cmbSAsstActType.getSelectedItem()).getobjInfo();
            ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.bizPromptSAsstAct, (Object)asstActTypeInfo, companyID, company.getCU().getId().toString(), true, this.currentSecondCache == null ? this.f7DisplayMode : this.currentSecondCache.getF7DisplayMode(), null, true);
            this.bizPromptSAsstAct.setData(null);
        }
        catch (Exception e2) {
            ExceptionHandler.handle((Throwable)e2);
        }
    }

    @Override
    public void cmbMContrastDirection_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 1 || this.cmbMContrastDirection.getItemCount() == 0 || this.cmbMContrastDirection.getSelectedItem() == null) {
            return;
        }
        ARAPEnum arapEnum = (ARAPEnum)((Object)this.cmbMContrastDirection.getSelectedItem());
        if (arapEnum.getValue().equalsIgnoreCase("AR")) {
            this.setContrastDirection(this.cmbSContrastDirection, "AP");
        } else {
            this.setContrastDirection(this.cmbSContrastDirection, "AR");
        }
        if (this.bizPromptMCompany.getData() != null) {
            this.setPeriod(true, this.isMARDirection(), false);
        }
        if (this.bizPromptSCompany.getData() != null) {
            this.setPeriod(false, this.isSARDirection(), false);
        }
        this.setDefaultAsstActType(arapEnum, this.cmbMAsstActType);
        ARAPEnum arapSEnum = (ARAPEnum)((Object)this.cmbSContrastDirection.getSelectedItem());
        this.setDefaultAsstActType(arapSEnum, this.cmbSAsstActType);
    }

    public void bizPromptMCurrency_dataChanged(DataChangeEvent e) {
        if (this.bizPromptMCurrency.getData() != null) {
            CurrencyInfo currency = (CurrencyInfo)this.bizPromptMCurrency.getData();
            this.bizPromptSCurrency.setData((Object)currency);
        }
    }

    private void setCurrencyF7(KDBizPromptBox bizPrompt) {
        bizPrompt.setEditable(true);
        bizPrompt.setEditFormat("$number$");
        bizPrompt.setDisplayFormat("$name$");
        bizPrompt.setCommitFormat("$number$");
        bizPrompt.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isoCode"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        bizPrompt.setSelectorCollection(sic);
    }

    private void setCompanyF7(KDBizPromptBox bizPrompt) {
        bizPrompt.setEditFormat("$number$");
        bizPrompt.setDisplayFormat("$name$");
        bizPrompt.setCommitFormat("$number$");
        bizPrompt.setEditable(true);
        bizPrompt.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company, this.getPermissionItem());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)"1", CompareType.EQUALS));
        bizPrompt.setEntityViewInfo(view);
        bizPrompt.setFilterInfoProducer((IFilterInfoProducer)iProducer);
    }

    private void setContrastDirection(KDComboBox cmb, String value) {
        int size = cmb.getItemCount();
        for (int i = 0; i < size; ++i) {
            ARAPEnum arapEnum = (ARAPEnum)((Object)cmb.getItemAt(i));
            if (!arapEnum.getValue().equalsIgnoreCase(value)) continue;
            cmb.setSelectedIndex(i);
        }
    }

    private String getCDirection(KDComboBox cmb) {
        ARAPEnum arapEnum = (ARAPEnum)((Object)cmb.getSelectedItem());
        if (arapEnum == null) {
            cmb.setSelectedIndex(0);
            arapEnum = (ARAPEnum)((Object)cmb.getSelectedItem());
        }
        return arapEnum.getValue();
    }

    private boolean isMARDirection() {
        return "AR".equalsIgnoreCase(this.getCDirection(this.cmbMContrastDirection));
    }

    private boolean isSARDirection() {
        return "AR".equalsIgnoreCase(this.getCDirection(this.cmbSContrastDirection));
    }

    private void setPeriod(boolean isMDirection, boolean isARDirection, boolean isOnload) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = this.getPeriodCompany(isMDirection);
        if (company == null || this.currentMasterCache == null) {
            return;
        }
        ArApSysParamInfo tempCache = null;
        tempCache = company.getId().equals((Object)this.currentMasterCache.getCompany().getId()) ? this.currentMasterCache : this.currentSecondCache;
        if (tempCache == null) {
            return;
        }
        PeriodInfo currentPeriod = null;
        if (isARDirection) {
            currentPeriod = tempCache.getCurrentPeriod(SystemEnum.ACCOUNTSRECEIVABLE);
            this.periodHelper = ArPeriodHelper.getInstance(false);
        } else {
            currentPeriod = tempCache.getCurrentPeriod(SystemEnum.ACCOUNTSPAYABLE);
            this.periodHelper = ApPeriodHelper.getInstance(false);
        }
        if (currentPeriod != null && !isOnload) {
            if (isMDirection) {
                this.periodHelper.initPeriodSpinner(company, this.spinnerMContrastYear, this.spinnerMContrastPeriod, tempCache);
            } else {
                this.periodHelper.initPeriodSpinner(company, this.spinnerSContrastYear, this.spinnerSContrastPeriod, tempCache);
            }
        }
        if (!isMDirection && !this.isSingle()) {
            this.spinnerSContrastYear.setEnabled(false);
            this.spinnerSContrastPeriod.setEnabled(false);
        }
    }

    private void setDefaultPeriod() {
        this.spinnerSContrastYear.setValue(this.spinnerMContrastYear.getValue());
        this.spinnerSContrastPeriod.setValue(this.spinnerMContrastPeriod.getValue());
    }

    private void setSingleDefaultPeriod() throws BOSException, EASBizException {
        int periodNumber;
        CompanyOrgUnitInfo[] company = this.getCompany(this.bizPromptSCompany);
        CompanyOrgUnitInfo sCompany = null;
        if (company.length > 0) {
            sCompany = company[0];
        }
        if (sCompany == null) {
            return;
        }
        PeriodInfo sStartPeriod = null;
        if (this.isMARDirection() && this.currentSecondCache != null && this.currentSecondCache.getCompany().getId().equals((Object)sCompany.getId())) {
            sStartPeriod = this.currentSecondCache.getStartPeriod(SystemEnum.ACCOUNTSPAYABLE);
        } else if (this.currentSecondCache != null && this.currentSecondCache.getCompany().getId().equals((Object)sCompany.getId())) {
            sStartPeriod = this.currentSecondCache.getStartPeriod(SystemEnum.ACCOUNTSRECEIVABLE);
        }
        if (sStartPeriod == null) {
            this.spinnerSContrastYear.setValue((Object)new Integer(1900));
            this.spinnerSContrastPeriod.setValue((Object)new Integer(1));
            return;
        }
        int periodYear = this.spinnerMContrastYear.getIntegerVlaue();
        PeriodInfo mPeriod = PeriodUtils.getPeriodInfo((int)periodYear, (int)(periodNumber = this.spinnerMContrastPeriod.getIntegerVlaue().intValue()), (CompanyOrgUnitInfo)this.getMCompany());
        if (!PeriodUtils.PeriodCompare((PeriodInfo)mPeriod, (PeriodInfo)sStartPeriod)) {
            this.spinnerSContrastYear.setValue((Object)new Integer(1900));
            this.spinnerSContrastPeriod.setValue((Object)new Integer(1));
        } else {
            this.spinnerSContrastYear.setValue(this.spinnerMContrastYear.getValue());
            this.spinnerSContrastPeriod.setValue(this.spinnerMContrastPeriod.getValue());
        }
    }

    private void setMPeriodNull() {
        this.spinnerMContrastYear.setValue((Object)new Integer(0));
        this.spinnerMContrastPeriod.setValue((Object)new Integer(0));
    }

    private CompanyOrgUnitInfo getPeriodCompany(boolean isMDirection, boolean isARDirection) throws BOSException, EASBizException {
        CoreBaseInfo orgInfo;
        ObjectUuidPK pk;
        PeriodInfo currPeriod = null;
        CompanyOrgUnitInfo[] selectedCompanys = null;
        if (!isMDirection) {
            selectedCompanys = this.getSCompany();
        }
        if (selectedCompanys == null) {
            return null;
        }
        CompanyOrgUnitInfo company = null;
        int length = selectedCompanys.length;
        for (int i = 0; !(i >= length || (company = this.iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)(pk = new ObjectUuidPK((orgInfo = (CoreBaseInfo)selectedCompanys[i]).getId().toString())))).isIsBizUnit() && (currPeriod = isARDirection ? ArClientUtils.getArCurrentPeriod(company) : ApClientUtils.getApCurrentPeriod(company)) != null); ++i) {
        }
        return company;
    }

    private CompanyOrgUnitInfo getPeriodCompany(boolean isMDirection) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = null;
        if (isMDirection) {
            if (this.bizPromptMCompany.getData() != null) {
                company = (CompanyOrgUnitInfo)this.bizPromptMCompany.getData();
            }
        } else if (this.isSingle) {
            if (this.bizPromptMCompany.getData() != null) {
                company = (CompanyOrgUnitInfo)this.bizPromptMCompany.getData();
            }
        } else {
            company = this.getPeriodCompany(isMDirection, this.isMARDirection());
        }
        return company;
    }

    private CompanyOrgUnitInfo[] getCompany(KDBizPromptBox promptBox) throws BOSException, EASBizException {
        if (promptBox.getData() == null) {
            return null;
        }
        if (!(promptBox.getData() instanceof Object[])) {
            CompanyOrgUnitInfo[] companys = new CompanyOrgUnitInfo[]{(CompanyOrgUnitInfo)promptBox.getData()};
            return companys;
        }
        Object[] selectedCompanys = (Object[])promptBox.getData();
        if (selectedCompanys == null) {
            return null;
        }
        int length = selectedCompanys.length;
        if (length == 0) {
            return null;
        }
        if (this.iCompanyOrgUnit == null) {
            this.iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        }
        CompanyOrgUnitInfo[] companys = new CompanyOrgUnitInfo[length];
        for (int i = 0; i < length; ++i) {
            CompanyOrgUnitInfo company;
            CoreBaseInfo orgInfo = (CoreBaseInfo)selectedCompanys[i];
            ObjectUuidPK pk = new ObjectUuidPK(orgInfo.getId().toString());
            companys[i] = company = this.iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)pk);
        }
        return companys;
    }

    private CompanyOrgUnitInfo getMCompany() {
        CompanyOrgUnitInfo company = null;
        if (this.bizPromptMCompany.getData() != null) {
            company = (CompanyOrgUnitInfo)this.bizPromptMCompany.getData();
            if (this.currentMasterCache == null || !company.getId().equals((Object)this.currentMasterCache.getCompany().getId())) {
                try {
                    this.currentMasterCache = this.iBillFacade.getSysParams(company, this.getUIParam());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return company;
    }

    private CompanyOrgUnitInfo[] getSCompany() {
        CompanyOrgUnitInfo[] companys = null;
        try {
            companys = this.getCompany(this.bizPromptSCompany);
            if (companys != null) {
                CompanyOrgUnitInfo company = null;
                if (companys.length > 0) {
                    company = companys[0];
                }
                if (!(company == null || this.currentSecondCache != null && company.getId().equals((Object)this.currentSecondCache.getCompany().getId()))) {
                    try {
                        this.currentSecondCache = this.iBillFacade.getSysParams(company, this.getUIParam());
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        catch (EASBizException e2) {
            this.handUIException(e2);
        }
        return companys;
    }

    private boolean checkSameCompany() {
        if (this.bizPromptMCompany.getData() == null || this.bizPromptSCompany.getData() == null) {
            return false;
        }
        CompanyOrgUnitInfo mCompany = (CompanyOrgUnitInfo)this.bizPromptMCompany.getData();
        CompanyOrgUnitInfo sCompany = (CompanyOrgUnitInfo)this.bizPromptSCompany.getData();
        return mCompany.getId().toString().equalsIgnoreCase(sCompany.getId().toString());
    }

    private String getResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)resKey);
    }

    private String getArReportResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)resKey);
    }

    private void makeAsstActType(KDComboBox comboAsstActType, CompanyOrgUnitInfo company, boolean defaultCustomer, ArApSysParamInfo cache) throws EASBizException, BOSException {
        if (company == null || company.getId() == null) {
            return;
        }
        String cpID = company.getId().toString();
        if ("".equals(cpID)) {
            return;
        }
        this.makeAsstActType(comboAsstActType, cpID, defaultCustomer, cache);
    }

    private void makeAsstActType(KDComboBox comboAsstActType, String cpID, boolean defaultCustomer, ArApSysParamInfo cache) throws EASBizException, BOSException {
        BaseDataUtil.makeAsstActType(comboAsstActType, cpID, false, cache);
        int n = comboAsstActType.getItemCount();
        for (int i = 0; i < n; ++i) {
            AsstActTypeInfo comObj = (AsstActTypeInfo)((ComBoxInfo)comboAsstActType.getItemAt(i)).getobjInfo();
            if (defaultCustomer) {
                if (comObj == null || ComBoxInfo.ITEM_ALL.equals(comObj) || !comObj.getString("asstHGAttribute").equalsIgnoreCase("customer")) continue;
                comboAsstActType.setSelectedIndex(i);
                break;
            }
            if (comObj == null || ComBoxInfo.ITEM_ALL.equals(comObj) || !comObj.getString("asstHGAttribute").equalsIgnoreCase("provider")) continue;
            comboAsstActType.setSelectedIndex(i);
            break;
        }
    }

    private void makeAsstActType() throws EASBizException, BOSException {
        if (this.bizPromptMCompany.getData() == null) {
            CompanyOrgUnitInfo mCompany = (CompanyOrgUnitInfo)this.bizPromptMCompany.getData();
            this.makeAsstActType(this.cmbMAsstActType, mCompany, this.isMARDirection(), this.currentMasterCache);
        }
        if (this.bizPromptSCompany.getData() == null) {
            CompanyOrgUnitInfo sCompany = (CompanyOrgUnitInfo)this.bizPromptSCompany.getData();
            this.makeAsstActType(this.cmbSAsstActType, sCompany, !this.isSARDirection(), this.currentSecondCache);
        }
    }

    private void setDefaultAsstActType(ARAPEnum arapEnum, KDComboBox comboAsstActType) {
        String cmpValue = null;
        cmpValue = arapEnum.getValue().equalsIgnoreCase("AR") ? "customer" : "provider";
        int n = comboAsstActType.getItemCount();
        for (int i = 0; i < n; ++i) {
            AsstActTypeInfo comObj = (AsstActTypeInfo)((ComBoxInfo)comboAsstActType.getItemAt(i)).getobjInfo();
            if (comObj == null || ComBoxInfo.ITEM_ALL.equals(comObj) || !comObj.getString("asstHGAttribute").equalsIgnoreCase(cmpValue)) continue;
            comboAsstActType.setSelectedIndex(i);
            break;
        }
    }

    protected boolean isARSystem() {
        return true;
    }

    public String getPermissionItem() {
        return this.PERMISSION_ITEM;
    }

    private boolean isSingle() {
        return this.isSingle;
    }

    private void setPeriodNull() {
        SpinnerNumberModel yearModel = new SpinnerNumberModel(1900, 1900, 9999, 1);
        SpinnerNumberModel periodModel = new SpinnerNumberModel(1, 1, 13, 1);
        this.spinnerSContrastYear.setModel((SpinnerModel)yearModel);
        this.spinnerSContrastPeriod.setModel((SpinnerModel)periodModel);
        this.spinnerSContrastYear.setValue((Object)new Integer(1900));
        this.spinnerSContrastPeriod.setValue((Object)new Integer(1));
    }

    public PeriodInfo getCurrentPeriod(CompanyOrgUnitInfo companyInfo, SystemEnum systemNum) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)systemNum, (CompanyOrgUnitInfo)companyInfo);
    }

    protected SystemEnum getSystem() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    protected HashMap getUIParam() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sysEnum", this.getSystem());
        map.put("permissionItem", this.getPermissionItem());
        return map;
    }
}

