/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ap.client.ApItemRptUI;
import com.kingdee.eas.fi.ar.ARAPEnum;
import com.kingdee.eas.fi.ar.ContrastGroupInnerFacadeFactory;
import com.kingdee.eas.fi.ar.ItemRptQueryParam;
import com.kingdee.eas.fi.ar.client.AbstractContrastGroupInnerRptUI;
import com.kingdee.eas.fi.ar.client.ArItemRptUI;
import com.kingdee.eas.fi.ar.client.ContrastGroupInnerQueryUI;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.arap.client.KDTableUtils;
import com.kingdee.eas.fi.arap.client.util.ArApReportUIUtil;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.DefaultKDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class ContrastGroupInnerRptUI
extends AbstractContrastGroupInnerRptUI {
    private static final Logger logger = CoreUIObject.getLogger(ContrastGroupInnerRptUI.class);
    public boolean isSingle = true;
    private CurrencyInfo currency = null;
    private ItemRptQueryParam mItemRptParam = new ItemRptQueryParam();
    private ItemRptQueryParam sItemRptParam = new ItemRptQueryParam();
    private ARAPEnum mContrastDirection = null;
    private ARAPEnum sContrastDirection = null;

    public ContrastGroupInnerRptUI() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.enableExportExcel(this.tblMain);
        this.isSingle(false);
    }

    public void onLoad() throws Exception {
        FMClientHelper.addSqlMenu((CoreUIObject)this, (KDMenu)this.menuTool);
        this.tblMain.checkParsed();
        super.onLoad();
        String title = "";
        title = this.isSingle ? this.getResource("contrastgroup_single") : this.getResource("contrastgroup");
        this.setUITitle(title);
        this.tblMain.setEditable(false);
    }

    protected void handlePermissionForItemAction(ItemAction action) {
        String actionName = action.getClass().getName();
        if (actionName.indexOf("$") >= 0) {
            actionName = actionName.substring(actionName.indexOf("$") + 1);
        }
        try {
            if (!"ActionOnLoad".equals(actionName)) {
                PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)this.getOrgPK(action), (IMetaDataPK)this.getMetaDataPK(), (ItemAction)action);
            }
        }
        catch (Exception err) {
            this.handUIException(err);
            this.abort(err);
        }
    }

    protected void initQueryDialog(CommonQueryDialog queryDialog) {
        if (queryDialog != null) {
            queryDialog.setMaxReturnCountVisible(false);
            queryDialog.setWidth(600);
            queryDialog.setHeight(254);
            queryDialog.setTitle(this.getTitle());
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnMDetail.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.btnSDetail.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.menuItemMDetail.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.menuItemSDetail.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return ContrastGroupInnerFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return new ContrastGroupInnerQueryUI(this.isSingle);
    }

    protected void query() {
        this.tblMain.removeColumns();
        this.tblMain.removeRows();
    }

    public void getData(KDTDataRequestEvent e) {
        try {
            RptParams rpt;
            int from = e.getFirstRow();
            int len = e.getLastRow() - from + 1;
            RptParams rptParams = new RptParams();
            this.tblMain.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
            if (from == 0) {
                rptParams.setString("tempTable", this.getTempTable());
                rptParams.putAll(this.params.toMap());
                rpt = this.getRemoteInstance().createTempTable(rptParams);
                this.setTempTable(rpt.getString("tempTable"));
                if (rpt.getObject("currency") != null) {
                    this.currency = (CurrencyInfo)rpt.getObject("currency");
                }
                if (rpt.getObject("mItemRptParam") != null) {
                    this.mItemRptParam = (ItemRptQueryParam)rpt.getObject("mItemRptParam");
                }
                if (rpt.getObject("sItemRptParam") != null) {
                    this.sItemRptParam = (ItemRptQueryParam)rpt.getObject("sItemRptParam");
                }
                this.mContrastDirection = (ARAPEnum)((Object)rpt.getObject("mContrastDirection"));
                this.sContrastDirection = (ARAPEnum)((Object)rpt.getObject("sContrastDirection"));
                RptTableHeader rptTableHeader = (RptTableHeader)rpt.getObject("header");
                this.tblMain.removeHeadRows();
                KDTableUtil.setHeader((RptTableHeader)rptTableHeader, (KDTable)this.tblMain);
                this.tblMain.setRowCount(rpt.getInt("rowCount"));
                this.initUserConfig();
            }
            rptParams.setString("tempTable", this.getTempTable());
            rpt = this.getRemoteInstance().query(rptParams, from, len);
            RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
            KDTableUtils.insertRows(rs, from, this.tblMain, true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs));
            this.changeDataFormat(this.currency, from, rs.getRowCount() + from);
            this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private void changeDataFormat(CurrencyInfo currencyInfo, int fistRow, int lastRow) {
        String precision = PrecisionFormatUtils.getFormatString(currencyInfo);
        for (int i = fistRow; i <= lastRow; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (row == null) continue;
            row.getCell("mbeginbalance").getStyleAttributes().setNumberFormat(precision);
            row.getCell("sbeginbalance").getStyleAttributes().setNumberFormat(precision);
            row.getCell("beginbalance").getStyleAttributes().setNumberFormat(precision);
            row.getCell("currency").getStyleAttributes().setNumberFormat(precision);
            row.getCell("mcredit").getStyleAttributes().setNumberFormat(precision);
            row.getCell("scredit").getStyleAttributes().setNumberFormat(precision);
            row.getCell("creditbalance").getStyleAttributes().setNumberFormat(precision);
            row.getCell("mdebit").getStyleAttributes().setNumberFormat(precision);
            row.getCell("sdebit").getStyleAttributes().setNumberFormat(precision);
            row.getCell("debitbalance").getStyleAttributes().setNumberFormat(precision);
            row.getCell("mendbalance").getStyleAttributes().setNumberFormat(precision);
            row.getCell("sendbalance").getStyleAttributes().setNumberFormat(precision);
            row.getCell("endbalance").getStyleAttributes().setNumberFormat(precision);
        }
    }

    @Override
    public void actionMDetail_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.dispDetailData(true);
    }

    @Override
    public void actionSDetail_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.dispDetailData(false);
    }

    private void checkSelected() {
        if (this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    private void dispDetailData(boolean isMainDerection) throws BOSException, EASBizException {
        int rowIndex = 0;
        String mCompanyID = null;
        String sCompanyID = null;
        CompanyOrgUnitInfo mCompany = null;
        CompanyOrgUnitInfo sCompany = null;
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            ICell iCellS;
            rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            ICell iCellM = row.getCell("mcompanyid");
            if (iCellM.getValue() != null) {
                mCompanyID = iCellM.getValue().toString();
            }
            if ((iCellS = row.getCell("scompanyid")).getValue() != null) {
                sCompanyID = iCellS.getValue().toString();
            }
            this.mItemRptParam.setCompanyId(mCompanyID);
            this.sItemRptParam.setCompanyId(sCompanyID);
            mCompany = BaseDataUtil.getCompany(mCompanyID);
            sCompany = BaseDataUtil.getCompany(sCompanyID);
            this.mItemRptParam.setIncludeBizBill(this.params.getBoolean("isIncludeBizBill"));
            this.sItemRptParam.setIncludeBizBill(this.params.getBoolean("isIncludeBizBill"));
            this.mItemRptParam.setBizeCheckBox(true);
            this.mItemRptParam.setBizeIndex(0);
            this.sItemRptParam.setBizeCheckBox(true);
            this.sItemRptParam.setBizeIndex(0);
            if (mCompany != null) {
                this.mItemRptParam.setCuId(mCompany.getCU().getId().toString());
            }
            if (sCompany != null) {
                this.sItemRptParam.setCuId(sCompany.getCU().getId().toString());
            }
        }
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow itemRptUI = null;
        if (isMainDerection) {
            if (this.mContrastDirection.getValue() == "AR") {
                uiContext.put((Object)"RPTFilter", (Object)this.mItemRptParam);
                itemRptUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(ArItemRptUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            } else {
                uiContext.put((Object)"RPTFilter", (Object)this.mItemRptParam);
                itemRptUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(ApItemRptUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            }
        } else if (this.sContrastDirection.getValue() == "AR") {
            uiContext.put((Object)"RPTFilter", (Object)this.sItemRptParam);
            itemRptUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(ArItemRptUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        } else {
            uiContext.put((Object)"RPTFilter", (Object)this.sItemRptParam);
            itemRptUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(ApItemRptUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        }
        itemRptUI.show();
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.printTbl(false);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.printTbl(true);
    }

    protected void printTbl(boolean preview) throws Exception {
        if (this.tblMain == null) {
            return;
        }
        String logMsg = ArApReportUIUtil.getPrintLogMsg(this.getUITitle(), preview);
        IObjectPK pkOut = LogUtil.beginLog(null, (String)logMsg, (BOSObjectType)this.getRemoteInstance().getType(), null, (String)logMsg);
        this.preparePrintPage(this.tblMain);
        if (preview) {
            this.tblMain.getPrintManager().printPreview();
        } else {
            this.tblMain.getPrintManager().print();
        }
        LogUtil.afterLog(null, (IObjectPK)pkOut);
    }

    private String getResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)resKey);
    }

    private String getTitle() {
        String title = null;
        title = this.isSingle ? this.getResource("contrastgroup_single_title") : this.getResource("contrastgroup_title");
        return title;
    }

    public void isSingle(boolean isSingle) {
        this.isSingle = isSingle;
    }

    public boolean isAsynchronism() {
        return true;
    }

    protected String getUIFullName() {
        return "com.kingdee.eas.fi.ar.client.ContrastGroupInnerRptUI";
    }
}

