/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroupStandard;
import com.kingdee.eas.basedata.master.cssp.client.F7CustomerTreeDetailListUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.ArSysFacadeFactory;
import com.kingdee.eas.fi.ar.IArSysFacade;
import com.kingdee.eas.fi.ar.client.AbstractCreditBalTestUI;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.common.IFMIsqlFacade;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CreditBalTestUI
extends AbstractCreditBalTestUI {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.client.CreditBalTestUI");
    private CompanyOrgUnitInfo currentCompany = null;
    private static final NumberFormat AMT_FORMATTER = NumberFormat.getInstance();

    public void onLoad() throws Exception {
        super.onLoad();
        this.comboBalType.addItem((Object)"UnauditBills");
        this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        ArApBillUIUtil.setCompanyF7((IUIObject)this, this.prmptCompany, this.currentCompany);
        this.initCustomerF7();
        this.txtBal.setHorizontalAlignment(4);
        this.txtAreaMsg.setSelectAllOnFocus(false);
        this.txtAreaMsg.setAutoscrolls(true);
    }

    private void initCustomerF7() throws Exception {
        String queryInfo = "com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyQuery";
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.currentCompany.getId()));
        ICSSPGroupStandard cSSPGroupStandard = CSSPGroupStandardFactory.getRemoteInstance();
        String groupStandardId = cSSPGroupStandard.getBasicStandardId("1");
        filter.getFilterItems().add(new FilterItemInfo("browseGroup.groupStandard", (Object)groupStandardId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmptCustomer.setEntityViewInfo(evi);
        GeneralKDPromptSelectorAdaptor selectorLisenterCustomer = null;
        selectorLisenterCustomer = new GeneralKDPromptSelectorAdaptor((KDPromptBox)this.prmptCustomer, (Component)new F7CustomerTreeDetailListUI(), (Object)this.ui, CSSPGroupInfo.getBosType(), queryInfo, "browseGroup.id");
        this.prmptCustomer.setEditFormat("$number$");
        this.prmptCustomer.setCommitFormat("$number$");
        this.prmptCustomer.setSelector((KDPromptSelector)selectorLisenterCustomer);
        this.prmptCustomer.addSelectorListener((SelectorListener)selectorLisenterCustomer);
    }

    @Override
    protected void btnCalc_actionPerformed(ActionEvent e) throws Exception {
        DateFormat DT_FORMAT = BOSLocaleUtil.getDateTimeFormat();
        this.txtBal.setText(null);
        if (this.prmptCompany.getValue() == null) {
            this.txtAreaMsg.append(DT_FORMAT.format(new Date()) + "::company can't be null!!!\r\n");
            return;
        }
        int balType = this.comboBalType.getSelectedIndex();
        if (balType != 2 && this.prmptCustomer.getValue() == null) {
            this.txtAreaMsg.append(DT_FORMAT.format(new Date()) + "::customer can't be null!!!\r\n");
            return;
        }
        DataBaseInfo compInfo = (DataBaseInfo)this.prmptCompany.getValue();
        ObjectUuidPK companyPK = new ObjectUuidPK(compInfo.getId());
        DataBaseInfo custInfo = (DataBaseInfo)this.prmptCustomer.getValue();
        IArSysFacade iArSys = ArSysFacadeFactory.getRemoteInstance();
        BigDecimal bal = null;
        String tmpCustsBalTbl = null;
        try {
            if (2 == balType) {
                ArrayList<BOSUuid> ids = new ArrayList<BOSUuid>();
                if (custInfo != null) {
                    ids.add(custInfo.getId());
                }
                tmpCustsBalTbl = iArSys.getCustomersCreditBalTable((IObjectPK)companyPK, ids, true);
                this.logCustomersBal(tmpCustsBalTbl);
            } else if (3 == balType) {
                ArrayList<BOSUuid> companyIds = new ArrayList<BOSUuid>();
                ArrayList<BOSUuid> custIds = new ArrayList<BOSUuid>();
                companyIds.add(this.currentCompany.getId());
                if (custInfo != null) {
                    custIds.add(custInfo.getId());
                }
                tmpCustsBalTbl = iArSys.getComsCustsCreditBalTable(companyIds, custIds, new Date(), true);
                this.logCustomersBal(tmpCustsBalTbl);
            } else if (4 == balType) {
                ArrayList<BOSUuid> ids = new ArrayList<BOSUuid>();
                if (custInfo != null) {
                    ids.add(custInfo.getId());
                }
                tmpCustsBalTbl = iArSys.getCustomersUnAuditBillsAmtTable((IObjectPK)companyPK, ids, true);
                this.logCustomersBal(tmpCustsBalTbl);
            } else {
                ObjectUuidPK customerPK = new ObjectUuidPK(custInfo.getId());
                bal = 1 == balType ? iArSys.getBizCodeCreditBal((IObjectPK)companyPK, (IObjectPK)customerPK) : iArSys.getArCreditBal((IObjectPK)companyPK, (IObjectPK)customerPK);
                this.txtBal.setText(bal != null ? AMT_FORMATTER.format(bal) : "");
                this.txtAreaMsg.append(DT_FORMAT.format(new Date()) + " :: company: " + compInfo.getName() + ", customer: " + custInfo.getName() + (balType == 1 ? ",bizCodeCreditBal. " : ",arCreditBal. ") + bal + "\r\n");
            }
        }
        catch (Exception ex) {
            this.txtAreaMsg.append(DT_FORMAT.format(new Date()) + " Error::" + ex.getMessage() + "\r\n");
            this.txtAreaMsg.append("    " + ExceptionUtil.getExcLinkStackTrace((Throwable)ex));
            logger.error((Object)"", (Throwable)ex);
        }
    }

    private void logCustomersBal(String custBalTbl) throws Exception {
        int i;
        DateFormat DT_FORMAT = BOSLocaleUtil.getDateTimeFormat();
        StringBuffer msg = new StringBuffer();
        msg.append(DT_FORMAT.format(new Date()));
        msg.append(": ").append(custBalTbl).append("\r\n");
        Locale locale = SysContext.getSysContext().getLocale();
        StringBuffer sql = new StringBuffer();
        sql.append("select t1.*, t2.FDisplayName_").append(locale);
        sql.append(" FCompany, t2.FLongNumber, ");
        sql.append(" t3.FName_").append(locale);
        sql.append(" FCustomer, t3.FNumber FCustNumber from ");
        sql.append(custBalTbl).append(" t1 left join t_org_company t2 on ");
        sql.append("t1.FCompanyId = t2.FId left join t_bd_customer t3 on");
        sql.append(" t1.FCustomerId = t3.FId order by t2.FNumber, t3.FNumber");
        IFMIsqlFacade iSql = FMIsqlFacadeFactory.getRemoteInstance();
        IRowSet rs = iSql.executeQuery(sql.toString(), null);
        ResultSetMetaData rsMeta = rs.getMetaData();
        int colCount = rsMeta.getColumnCount();
        for (i = 1; i <= colCount; ++i) {
            msg.append(rsMeta.getColumnName(i));
            msg.append("\t");
        }
        while (rs.next()) {
            msg.append("\r\n");
            for (i = 1; i <= colCount; ++i) {
                msg.append(rs.getString(i)).append("\t");
            }
            msg.append("\r\n");
        }
        this.txtAreaMsg.append(msg.toString() + "\r\n");
    }

    @Override
    protected void btnClearLog_actionPerformed(ActionEvent e) throws Exception {
        this.txtAreaMsg.setText(null);
    }
}

