/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ap.client.util.ApClientUtils;
import com.kingdee.eas.fi.ar.ContrastAccountViewCollection;
import com.kingdee.eas.fi.ar.ContrastAccountViewFactory;
import com.kingdee.eas.fi.ar.ContrastAccountViewInfo;
import com.kingdee.eas.fi.ar.IContrastAccountView;
import com.kingdee.eas.fi.ar.IImpInitDataGLFacade;
import com.kingdee.eas.fi.ar.ImpInitDataGLFacadeFactory;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.client.AbstractImpInitDataGLUI;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.client.util.ComBoxInfo;
import com.kingdee.eas.fi.ar.client.util.CommonClientUtils;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.client.util.ArApReportUIUtil;
import com.kingdee.eas.fi.arap.util.ArApMutextUtils;
import com.kingdee.eas.fi.cas.client.ArApRecPayHelper;
import com.kingdee.eas.fi.gl.GLFlagFactory;
import com.kingdee.eas.fi.gl.IGLFlag;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.Uuid;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;

public class ImpInitDataGLUI
extends AbstractImpInitDataGLUI {
    private String system = null;
    private CompanyOrgUnitInfo currentCompany = null;
    private IImpInitDataGLFacade impInitDataGLFacade = null;
    private PeriodInfo startPeriod = null;
    private PeriodInfo glCurrentPeriod = null;
    private IGLFlag iGLFlag = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        ArApReportUIUtil.checkCompany((Component)((Object)this), this.currentCompany);
        super.onLoad();
        if (this.getUIContext().get("UIClassParam") != null) {
            this.system = this.getUIContext().get("UIClassParam").toString();
        }
        this.startPeriod = "AR".equalsIgnoreCase(this.system) ? ArClientUtils.getArStartPeriod(this.currentCompany) : ApClientUtils.getApStartPeriod(this.currentCompany);
        if (this.startPeriod == null) {
            throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{this.currentCompany.getName() + this.getSystemEnumForOA().getAlias()});
        }
        if (!CommonClientUtils.glIsStart(this.currentCompany)) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("gl_is_not_start"));
            SysUtil.abort();
        }
        if ("AR".equalsIgnoreCase(this.system)) {
            if (ArClientUtils.arIsStart(this.currentCompany)) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("ar_is_not_start"));
                SysUtil.abort();
            }
        } else if (ApClientUtils.apIsStart(this.currentCompany)) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("ap_is_not_start"));
            SysUtil.abort();
        }
        this.glCurrentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.currentCompany);
        if (this.startPeriod.getBeginDate().compareTo(this.glCurrentPeriod.getBeginDate()) > 0) {
            if ("AR".equalsIgnoreCase(this.system)) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("gl_period_equal_ar_period"));
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("gl_period_equal_ap_period"));
            }
            SysUtil.abort();
        }
        this.impInitDataGLFacade = ImpInitDataGLFacadeFactory.getRemoteInstance();
        this.iGLFlag = GLFlagFactory.getRemoteInstance();
        this.initialize();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    private void initialize() throws BOSException, EASBizException {
        this.labWizardImg.setIcon(EASResource.getIcon((String)"imgGuide_pic338"));
        this.btnAddRow.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertRow.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnDelRow.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.tblMain.checkParsed();
        KDBizPromptBox f7AccpimtPromptBox = new KDBizPromptBox();
        if ("AR".equalsIgnoreCase(this.system)) {
            CommonClientUtils.setContrastAccountF7((IUIObject)this, f7AccpimtPromptBox, this.currentCompany, true, this.startPeriod);
            this.tblMain.getColumn("payAccount").getStyleAttributes().setHided(true);
        } else {
            CommonClientUtils.setContrastAccountF7((IUIObject)this, f7AccpimtPromptBox, this.currentCompany, false, this.startPeriod);
            this.tblMain.getColumn("recAccount").getStyleAttributes().setHided(true);
        }
        KDTDefaultCellEditor kdtbadAccountCellEditor = new KDTDefaultCellEditor((IKDEditor)f7AccpimtPromptBox);
        ObjectValueRender kdtEntrys_recAccount_OVR = new ObjectValueRender();
        kdtEntrys_recAccount_OVR.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.tblMain.getColumn("account").setEditor((ICellEditor)kdtbadAccountCellEditor);
        this.tblMain.getColumn("account").setRenderer((IBasicRender)kdtEntrys_recAccount_OVR);
        KDComboBox bizTypeKDCmb = new KDComboBox();
        KDTDefaultCellEditor kdtBizTypeCellEditor = new KDTDefaultCellEditor((JComboBox)bizTypeKDCmb);
        bizTypeKDCmb.removeAllItems();
        List list = VerificateBillTypeEnum.getEnumList();
        for (int i = 0; i < list.size(); ++i) {
            VerificateBillTypeEnum billTypeEnum = (VerificateBillTypeEnum)list.get(i);
            if ("AR".equalsIgnoreCase(this.system)) {
                if (billTypeEnum.getValue() != 2 && billTypeEnum.getValue() != 11 && billTypeEnum.getValue() != 8 && billTypeEnum.getValue() != 7) continue;
                bizTypeKDCmb.addItem(list.get(i));
                continue;
            }
            if (billTypeEnum.getValue() != 0 && billTypeEnum.getValue() != 10 && billTypeEnum.getValue() != 9 && billTypeEnum.getValue() != 5) continue;
            bizTypeKDCmb.addItem(list.get(i));
        }
        this.tblMain.getColumn("bizType").setEditor((ICellEditor)kdtBizTypeCellEditor);
        KDComboBox directionKDCmb = new KDComboBox();
        KDTDefaultCellEditor kdtDirectionCellEditor = new KDTDefaultCellEditor((JComboBox)directionKDCmb);
        directionKDCmb.removeAllItems();
        list = BalanceDirectionEnum.getEnumList();
        for (int i = 0; i < list.size(); ++i) {
            BalanceDirectionEnum directionEnum = (BalanceDirectionEnum)list.get(i);
            if (directionEnum.getValue() != -1 && directionEnum.getValue() != 1) continue;
            directionKDCmb.addItem((Object)directionEnum);
        }
        this.tblMain.getColumn("direction").setEditor((ICellEditor)kdtDirectionCellEditor);
        KDComboBox asstActTypeKDCmb = new KDComboBox();
        BaseDataUtil.makeBillAsstActType(asstActTypeKDCmb);
        KDTDefaultCellEditor kdtAsstActCellEditor = new KDTDefaultCellEditor((JComboBox)asstActTypeKDCmb);
        this.tblMain.getColumn("asstActType").setEditor((ICellEditor)kdtAsstActCellEditor);
        KDBizPromptBox expenseItemPrmtBox = new KDBizPromptBox();
        String billType = "AR".equalsIgnoreCase(this.system) ? "OtherArBill" : "OtherApBill";
        ArApBillUIUtil.setExpenseTypeFilter(expenseItemPrmtBox, (CoreUIObject)this, false, billType, this.currentCompany, true);
        KDTDefaultCellEditor expenseItem_CellEditor = new KDTDefaultCellEditor((IKDEditor)expenseItemPrmtBox);
        this.tblMain.getColumn("expenseitem").setEditor((ICellEditor)expenseItem_CellEditor);
        ObjectValueRender expenseitemOvr = new ObjectValueRender();
        expenseitemOvr.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.tblMain.getColumn("expenseitem").setRenderer((IBasicRender)expenseitemOvr);
        KDBizPromptBox materialPrmtBox = new KDBizPromptBox();
        ArApBillUIUtil.setMaterialF7((CoreUIObject)this, materialPrmtBox, true);
        KDTDefaultCellEditor material_CellEditor = new KDTDefaultCellEditor((IKDEditor)materialPrmtBox);
        this.tblMain.getColumn("material").setEditor((ICellEditor)material_CellEditor);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.tblMain.getColumn("material").setRenderer((IBasicRender)avr);
        KDBizPromptBox kdtEntrys_paySubject_PromptBox = new KDBizPromptBox();
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        StringBuffer mask = new StringBuffer("#0 AND #1 AND #2 AND #3 ");
        fic.add(new FilterItemInfo("companyID.id", (Object)this.currentCompany.getId().toString()));
        fic.add(new FilterItemInfo("isGFreeze", (Object)false));
        fic.add(new FilterItemInfo("isCFreeze", (Object)false));
        fic.add(new FilterItemInfo("isLeaf", (Object)true));
        if (this.currentCompany.getAccountTable() != null) {
            fic.add(new FilterItemInfo("accountTableID.id", (Object)this.currentCompany.getAccountTable().getId().toString()));
            mask.append(" AND #4");
        }
        fi.setMaskString(mask.toString());
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(fi);
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        kdtEntrys_paySubject_PromptBox.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        kdtEntrys_paySubject_PromptBox.setSelector((KDPromptSelector)new AccountPromptBox((IUIObject)this, this.currentCompany, fi));
        kdtEntrys_paySubject_PromptBox.setVisible(true);
        kdtEntrys_paySubject_PromptBox.setEditable(true);
        kdtEntrys_paySubject_PromptBox.setEnabled(true);
        kdtEntrys_paySubject_PromptBox.setEditFormat("$number$");
        kdtEntrys_paySubject_PromptBox.setDisplayFormat("$number$");
        kdtEntrys_paySubject_PromptBox.setCommitFormat("$number$;$name$");
        kdtEntrys_paySubject_PromptBox.setEntityViewInfo(viewInfo);
        KDTDefaultCellEditor kdtAccountCellEditor = new KDTDefaultCellEditor((IKDEditor)kdtEntrys_paySubject_PromptBox);
        ObjectValueRender kdtAccountOVR = new ObjectValueRender();
        kdtAccountOVR.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.tblMain.getColumn("recAccount").setEditor((ICellEditor)kdtAccountCellEditor);
        this.tblMain.getColumn("recAccount").setRenderer((IBasicRender)kdtAccountOVR);
        this.tblMain.getColumn("payAccount").setEditor((ICellEditor)kdtAccountCellEditor);
        this.tblMain.getColumn("payAccount").setRenderer((IBasicRender)kdtAccountOVR);
        this.tblMain.getColumn("isBizBill").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
        this.tblMain.addRow();
    }

    private void setMaterialprmtView(CompanyOrgUnitInfo companyOrgInfo) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (companyOrgInfo != null) {
            Component comp;
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)companyOrgInfo.getId(), CompareType.EQUALS));
            viewInfo.setFilter(filter);
            if (this.tblMain.getColumn("material").getEditor() != null && (comp = this.tblMain.getColumn("material").getEditor().getComponent()) != null && comp instanceof KDBizPromptBox) {
                ((KDBizPromptBox)comp).setEntityViewInfo(viewInfo);
            }
        }
    }

    @Override
    public void tblMain_editStopped(KDTEditEvent e) throws Exception {
        super.tblMain_editStopped(e);
        if (e.getColIndex() == this.tblMain.getColumn("account").getColumnIndex()) {
            Object value = e.getValue();
            if (value == null) {
                return;
            }
            AccountViewInfo accountViewInfo = (AccountViewInfo)value;
            if (accountViewInfo.getCAA() != null) {
                IRow row = this.tblMain.getRow(e.getRowIndex());
                EntityViewInfo viewIn = new EntityViewInfo();
                FilterInfo filterIn = new FilterInfo();
                filterIn.getFilterItems().add(new FilterItemInfo("account", (Object)accountViewInfo.getId()));
                if (this.currentCompany != null) {
                    filterIn.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
                    PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.currentCompany);
                    if (periodInfo != null) {
                        filterIn.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodInfo.getPeriodYear())));
                        filterIn.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodInfo.getPeriodNumber())));
                    }
                }
                viewIn.setFilter(filterIn);
                SelectorItemCollection selectorAdmin = new SelectorItemCollection();
                selectorAdmin.add(new SelectorItemInfo("defaultAsstActType.id"));
                selectorAdmin.add(new SelectorItemInfo("defaultAsstActType.name"));
                selectorAdmin.add(new SelectorItemInfo("defaultAsstActType.number"));
                viewIn.setSelector(selectorAdmin);
                IContrastAccountView iContrastAccountView = ContrastAccountViewFactory.getRemoteInstance();
                ContrastAccountViewCollection contrastAccountViewColl = iContrastAccountView.getContrastAccountViewCollection(viewIn);
                if (contrastAccountViewColl.size() > 0) {
                    AsstActTypeInfo asstActTypeInfo = null;
                    ContrastAccountViewInfo cavInfo = null;
                    int size = contrastAccountViewColl.size();
                    for (int i = 0; i < size; ++i) {
                        cavInfo = contrastAccountViewColl.get(i);
                        if (cavInfo == null || cavInfo.getDefaultAsstActType() == null) continue;
                        asstActTypeInfo = cavInfo.getDefaultAsstActType();
                        break;
                    }
                    row.getCell("asstActType").setValue(asstActTypeInfo);
                } else {
                    row.getCell("asstActType").setValue(null);
                }
                row.getCell("asstAct").setValue(null);
                row.getCell("direction").setValue((Object)accountViewInfo.getDC());
                row.getCell("asstActType").getStyleAttributes().setLocked(true);
                row.getCell("asstActType").getStyleAttributes().setBackground(Color.decode("#E8E8E3"));
                row.getCell("asstAct").getStyleAttributes().setLocked(true);
                row.getCell("asstAct").getStyleAttributes().setBackground(Color.decode("#E8E8E3"));
            } else {
                IRow row = this.tblMain.getRow(e.getRowIndex());
                row.getCell("asstActType").getStyleAttributes().setLocked(false);
                row.getCell("asstActType").getStyleAttributes().setBackground(Color.WHITE);
                row.getCell("direction").setValue((Object)accountViewInfo.getDC());
                row.getCell("asstAct").getStyleAttributes().setLocked(false);
                row.getCell("asstAct").getStyleAttributes().setBackground(Color.WHITE);
            }
        } else if (e.getColIndex() == this.tblMain.getColumn("bizType").getColumnIndex()) {
            VerificateBillTypeEnum bizTypeEnum;
            Object value = e.getValue();
            if (value == null) {
                return;
            }
            IRow row = this.tblMain.getRow(e.getRowIndex());
            if (e.getOldValue() != null && !e.getOldValue().equals(e.getValue())) {
                row.getCell("material").setValue(null);
                row.getCell("expenseitem").setValue(null);
                row.getCell("recAccount").setValue(null);
                row.getCell("payAccount").setValue(null);
                row.getCell("isBizBill").setValue((Object)Boolean.FALSE);
            }
            if ((bizTypeEnum = (VerificateBillTypeEnum)value).getValue() == 2 || bizTypeEnum.getValue() == 0) {
                row.getCell("material").getStyleAttributes().setLocked(false);
                row.getCell("material").getStyleAttributes().setBackground(Color.WHITE);
                row.getCell("expenseitem").getStyleAttributes().setLocked(true);
                row.getCell("expenseitem").getStyleAttributes().setBackground(Color.decode("#E8E8E3"));
                row.getCell("isBizBill").getStyleAttributes().setLocked(false);
                row.getCell("isBizBill").getStyleAttributes().setBackground(Color.WHITE);
                if (this.system.equalsIgnoreCase("AR")) {
                    row.getCell("recAccount").getStyleAttributes().setLocked(true);
                    row.getCell("recAccount").getStyleAttributes().setBackground(Color.decode("#E8E8E3"));
                } else {
                    row.getCell("payAccount").getStyleAttributes().setLocked(true);
                    row.getCell("payAccount").getStyleAttributes().setBackground(Color.decode("#E8E8E3"));
                }
            } else if (bizTypeEnum.getValue() == 8 || bizTypeEnum.getValue() == 11 || bizTypeEnum.getValue() == 9 || bizTypeEnum.getValue() == 10) {
                row.getCell("material").getStyleAttributes().setLocked(true);
                row.getCell("material").getStyleAttributes().setBackground(Color.decode("#E8E8E3"));
                row.getCell("expenseitem").getStyleAttributes().setLocked(false);
                row.getCell("expenseitem").getStyleAttributes().setBackground(Color.WHITE);
                row.getCell("isBizBill").getStyleAttributes().setLocked(false);
                row.getCell("isBizBill").getStyleAttributes().setBackground(Color.WHITE);
                if (this.system.equalsIgnoreCase("AR")) {
                    row.getCell("recAccount").getStyleAttributes().setLocked(true);
                    row.getCell("recAccount").getStyleAttributes().setBackground(Color.decode("#E8E8E3"));
                } else {
                    row.getCell("payAccount").getStyleAttributes().setLocked(true);
                    row.getCell("payAccount").getStyleAttributes().setBackground(Color.decode("#E8E8E3"));
                }
            } else if (bizTypeEnum.getValue() == 7 || bizTypeEnum.getValue() == 5) {
                row.getCell("material").getStyleAttributes().setLocked(true);
                row.getCell("material").getStyleAttributes().setBackground(Color.decode("#E8E8E3"));
                row.getCell("expenseitem").getStyleAttributes().setLocked(true);
                row.getCell("expenseitem").getStyleAttributes().setBackground(Color.decode("#E8E8E3"));
                row.getCell("isBizBill").getStyleAttributes().setLocked(true);
                row.getCell("isBizBill").getStyleAttributes().setBackground(Color.decode("#E8E8E3"));
                if (this.system.equalsIgnoreCase("AR")) {
                    row.getCell("recAccount").getStyleAttributes().setLocked(false);
                    row.getCell("recAccount").getStyleAttributes().setBackground(Color.decode("#FFFFFF"));
                } else {
                    row.getCell("payAccount").getStyleAttributes().setLocked(false);
                    row.getCell("payAccount").getStyleAttributes().setBackground(Color.decode("#FFFFFF"));
                }
            }
        } else if (e.getColIndex() == this.tblMain.getColumn("asstActType").getColumnIndex()) {
            Object value = e.getValue();
            if (value == null) {
                return;
            }
            AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)((ComBoxInfo)value).getobjInfo();
            if (asstActTypeInfo.getDefaultQueryName() != null) {
                KDBizPromptBox f7AsstActPromptBox = new KDBizPromptBox();
                ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, f7AsstActPromptBox, asstActTypeInfo, false);
                KDTDefaultCellEditor kdtAsstActCellEditor = new KDTDefaultCellEditor((IKDEditor)f7AsstActPromptBox);
                ObjectValueRender kdtEntrys_asstAct_OVR = new ObjectValueRender();
                kdtEntrys_asstAct_OVR.setFormat((IDataFormat)new BizDataFormat("$name$"));
                this.tblMain.getCell(e.getRowIndex(), "asstAct").setEditor((ICellEditor)kdtAsstActCellEditor);
                this.tblMain.getCell(e.getRowIndex(), "asstAct").setRenderer((IBasicRender)kdtEntrys_asstAct_OVR);
            }
        }
    }

    private void verify() throws Exception {
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            String[] accountIds;
            boolean[] bl;
            boolean isHasCas = false;
            AccountViewInfo accountViewInfo = null;
            IRow row = this.tblMain.getRow(i);
            if (row.getCell("account").getValue() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("ar_account_isNull"));
                SysUtil.abort();
            } else {
                accountViewInfo = (AccountViewInfo)row.getCell("account").getValue();
                isHasCas = accountViewInfo.getCAA() != null;
            }
            if (isHasCas && !(bl = this.iGLFlag.getAstInitClosed(accountIds = new String[]{accountViewInfo.getId().toString()}, this.currentCompany.getId().toString()))[0]) {
                MsgBox.showInfo((Component)((Object)this), (String)(accountViewInfo.getName() + " " + this.getStrResource("account_no_init")));
                SysUtil.abort();
            }
            if (row.getCell("bizType").getValue() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("biztype_isnull"));
                SysUtil.abort();
            }
            if (!isHasCas) {
                if (row.getCell("asstActType").getValue() == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("ar_bill_acctCussentTypeIsNull"));
                    SysUtil.abort();
                }
                if (row.getCell("asstAct").getValue() == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("ar_bill_acctCussentIsNull"));
                    SysUtil.abort();
                }
            }
            if (row.getCell("bizType").getValue() == null) continue;
            VerificateBillTypeEnum bizTypeEnum = (VerificateBillTypeEnum)row.getCell("bizType").getValue();
            if (bizTypeEnum.getValue() == 2 || bizTypeEnum.getValue() == 0) {
                if (row.getCell("material").getValue() != null || this.isHasMaterial(accountViewInfo = (AccountViewInfo)row.getCell("account").getValue())) continue;
                MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("account_caa_no_material"));
                SysUtil.abort();
                continue;
            }
            if (bizTypeEnum.getValue() == 8 || bizTypeEnum.getValue() == 11 || bizTypeEnum.getValue() == 9 || bizTypeEnum.getValue() == 10) {
                if (row.getCell("expenseitem").getValue() != null) continue;
                MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("expenseitem_isnull"));
                SysUtil.abort();
                continue;
            }
            if (this.system.equalsIgnoreCase("AR")) {
                if (row.getCell("recAccount").getValue() != null) continue;
                MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("rec_account_not_null"));
                SysUtil.abort();
                continue;
            }
            if (row.getCell("payAccount").getValue() != null) continue;
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("pay_account_not_null"));
            SysUtil.abort();
        }
    }

    private void checkAccontRepeat() throws BOSException, EASBizException {
        ArrayList<String> list = new ArrayList<String>(100);
        int size = this.tblMain.getRowCount();
        for (int i = size - 1; i >= 0; --i) {
            IRow row = this.tblMain.getRow(i);
            if (row.getCell("account").getValue() == null) continue;
            AccountViewInfo accountViewInfo = (AccountViewInfo)row.getCell("account").getValue();
            if (list.contains(accountViewInfo.getId().toString())) {
                String message = this.getStrResource("contrast_account_view_order") + String.valueOf(i + 1) + this.getStrResource("contrast_account_view_row") + accountViewInfo.getName() + "(" + accountViewInfo.getNumber() + ")" + this.getStrResource("account_repeat");
                int value = MsgBox.showConfirm2((Component)((Object)this), (String)message);
                if (value == 1 || value == 2) {
                    SysUtil.abort();
                    continue;
                }
                this.tblMain.removeRow(i);
                this.tblMain.setRowCount(this.tblMain.getRowCount() - 1);
                continue;
            }
            list.add(accountViewInfo.getId().toString());
        }
    }

    private boolean isHasMaterial(AccountViewInfo accout) throws BOSException, EASBizException {
        if (accout.getCAA() == null) {
            return false;
        }
        AsstActGroupDetailCollection AsstActGDColl = accout.getCAA().getAsstActGpDt();
        int size = AsstActGDColl.size();
        for (int i = 0; i < size; ++i) {
            AsstActGroupDetailInfo info = AsstActGDColl.get(i);
            AsstActTypeInfo asstActTypeInfo = this.getAsstActType(info.getAsstActType().getId().toString());
            if (!"FMaterialID".equalsIgnoreCase(asstActTypeInfo.getMappingFieldName())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    private void deleteRow(KDTable tbl) {
        if (tbl.getRowCount() == 0) {
            return;
        }
        if (tbl.getSelectManager().size() > 0) {
            KDTSelectBlock block = tbl.getSelectManager().get();
            if (block != null) {
                tbl.removeRow(block.getTop());
            }
        } else if (tbl.getRowCount() > 0) {
            tbl.removeRow(tbl.getRowCount() - 1);
        }
    }

    protected void insertLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() > 0) {
            int top = table.getSelectManager().get().getTop();
            table.addRow(top);
        } else {
            table.addRow();
        }
    }

    private void importInitData() throws Exception {
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            Map filter = this.getFilter(i);
            this.impInitDataGLFacade.ImportInitData(filter);
        }
    }

    private void importInitBill() throws Exception {
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            Map filter = this.getFilter(i);
            this.impInitDataGLFacade.importInitBill(filter);
        }
        if (count > 0) {
            this.showSuccess();
        }
    }

    private Map getFilter(int rowIndex) {
        Object obj;
        HashMap<String, Object> filter = new HashMap<String, Object>();
        IRow row = this.tblMain.getRow(rowIndex);
        AccountViewInfo accountViewInfo = null;
        if (row.getCell("account").getValue() != null) {
            accountViewInfo = (AccountViewInfo)row.getCell("account").getValue();
        }
        BalanceDirectionEnum direction = null;
        if (row.getCell("direction").getValue() != null) {
            direction = (BalanceDirectionEnum)row.getCell("direction").getValue();
        }
        VerificateBillTypeEnum bizType = null;
        if (row.getCell("bizType").getValue() != null) {
            bizType = (VerificateBillTypeEnum)row.getCell("bizType").getValue();
        }
        AsstActTypeInfo asstActType = null;
        if (row.getCell("asstActType").getValue() != null) {
            ComBoxInfo comBoxInfo;
            Object obj2 = row.getCell("asstActType").getValue();
            if (obj2 instanceof AsstActTypeInfo) {
                asstActType = (AsstActTypeInfo)obj2;
            }
            if (obj2 instanceof ComBoxInfo && (comBoxInfo = (ComBoxInfo)obj2).getobjInfo() instanceof AsstActTypeInfo) {
                asstActType = (AsstActTypeInfo)comBoxInfo.getobjInfo();
            }
        }
        DataBaseInfo asstAct = null;
        if (row.getCell("asstAct").getValue() != null && (obj = row.getCell("asstAct").getValue()) instanceof DataBaseInfo) {
            asstAct = (DataBaseInfo)obj;
        }
        MaterialInfo material = null;
        Object obj3 = row.getCell("material").getValue();
        if (obj3 != null) {
            Object[] material_arr;
            if (obj3 instanceof MaterialInfo) {
                material = (MaterialInfo)row.getCell("material").getValue();
            } else if (obj3 instanceof Object[] && (material_arr = (Object[])obj3).length > 0) {
                material = (MaterialInfo)material_arr[0];
            }
        }
        ExpenseTypeInfo expenseitem = null;
        Object expenseitemObj = row.getCell("expenseitem").getValue();
        if (expenseitemObj != null) {
            if (expenseitemObj instanceof ExpenseTypeInfo) {
                expenseitem = (ExpenseTypeInfo)row.getCell("expenseitem").getValue();
            } else if (expenseitemObj instanceof Object[]) {
                Object[] expenseitem_arr = (Object[])expenseitemObj;
                expenseitem = expenseitem_arr.length > 0 ? (ExpenseTypeInfo)expenseitem_arr[0] : null;
            }
        }
        AccountViewInfo recAccountViewInfo = null;
        if (row.getCell("recAccount").getValue() != null) {
            recAccountViewInfo = (AccountViewInfo)row.getCell("recAccount").getValue();
        }
        AccountViewInfo payAccountViewInfo = null;
        if (row.getCell("payAccount").getValue() != null) {
            payAccountViewInfo = (AccountViewInfo)row.getCell("payAccount").getValue();
        }
        filter.put("account", accountViewInfo);
        filter.put("direction", direction);
        filter.put("bizType", bizType);
        filter.put("asstActType", asstActType);
        filter.put("asstAct", asstAct);
        filter.put("material", material);
        filter.put("expenseitem", expenseitem);
        filter.put("company", this.currentCompany);
        filter.put("startPeriod", this.startPeriod);
        filter.put("system", this.system);
        filter.put("recAccount", recAccountViewInfo);
        filter.put("payAccount", payAccountViewInfo);
        filter.put("glCurrentPeriod", this.glCurrentPeriod);
        filter.put("isBizBill", row.getCell("isBizBill").getValue() != null ? row.getCell("isBizBill").getValue() : Boolean.FALSE);
        return filter;
    }

    @Override
    public void actionAddRow_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.addRow();
    }

    @Override
    public void actionInsertRow_actionPerformed(ActionEvent e) throws Exception {
        this.insertLine(this.tblMain);
    }

    @Override
    public void actionDelRow_actionPerformed(ActionEvent e) throws Exception {
        this.deleteRow(this.tblMain);
    }

    @Override
    public void btnOK_actionPerformed(ActionEvent e) {
        this.getUIWindow().close();
    }

    private void showImpInitDataMsg() {
        String message = this.getStrResource("impInitDataMsg");
        this.tblMain.setVisible(false);
        this.txtMessage.setVisible(true);
        this.btnAddRow.setVisible(false);
        this.btnDelRow.setVisible(false);
        this.btnInsertRow.setVisible(false);
        this.btnNext.setVisible(true);
        this.btnOK.setVisible(false);
        this.txtMessage.setText(message);
        this.txtMessage.setEditable(true);
    }

    private void showSuccess() {
        String message = this.getStrResource("import_success");
        this.tblMain.setVisible(false);
        this.txtMessage.setVisible(true);
        this.btnAddRow.setVisible(false);
        this.btnDelRow.setVisible(false);
        this.btnInsertRow.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnOK.setVisible(true);
        this.txtMessage.setText(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        Uuid mutexUuid = Uuid.create();
        try {
            MutexParameter param = ArApMutextUtils.getMutexParameter(null, null, mutexUuid, ((Object)((Object)this)).getClass().toString(), "actionImport_actionPerformed", MutexLockType.EXCLUSIVE_LOCK, SysContext.getSysContext().getCurrentFIUnit().getId(), SysContext.getSysContext().getCurrentUserInfo().getId());
            if (!ArApMutextUtils.requestMutex(null, param)) {
                ArApRecPayHelper.throwExcetion((String)ArApBillUIUtil.getStrResource("DataMutex"));
            }
            this.verify();
            this.checkAccontRepeat();
            this.importInitData();
            this.showSuccess();
        }
        finally {
            ArApMutextUtils.releaseMutex(null, mutexUuid);
        }
    }

    private AsstActTypeInfo getAsstActType(String asstActTypeID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(asstActTypeID);
        IAsstActType iAsstActType = AsstActTypeFactory.getRemoteInstance();
        return iAsstActType.getAsstActTypeInfo((IObjectPK)pk);
    }

    private String getStrResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)resKey);
    }
}

