/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.fi.ar.IncomeConfimBillTypeEnum;
import com.kingdee.eas.fi.ar.client.AbstractIncomeConfirmBillQueryUI;
import com.kingdee.eas.fi.ar.client.FilterInfoExtractor;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.client.util.ComBoxInfo;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.client.util.ArApQueryUIUtil;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class IncomeConfirmBillQueryUI
extends AbstractIncomeConfirmBillQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(IncomeConfirmBillQueryUI.class);
    private ArApSysParamInfo cache;
    private HashMap uiParam;

    public IncomeConfirmBillQueryUI(HashMap uiParam) throws Exception {
        this.cache = new ArApSysParamInfo();
        this.uiParam = uiParam;
    }

    public IncomeConfirmBillQueryUI() throws Exception {
        this.initDefaultUIParam();
    }

    protected void initDefaultUIParam() throws BOSException {
        this.cache = new ArApSysParamInfo();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("sysEnum", SystemEnum.ACCOUNTSRECEIVABLE);
        String sIsSCMBill = (String)this.getUIContext().get("UIClassParam");
        boolean isSCM = "isSCMBill".equals(sIsSCMBill);
        map.put("isSCM", isSCM);
        this.uiParam = map;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams params = new CustomerParams();
        params.addCustomerParam("isShowEntry", String.valueOf(this.radioEntries.isSelected()));
        params.addCustomerParam("isShowShortName", String.valueOf(this.ckBxMShortName.isSelected()));
        return params;
    }

    public void setCustomerParams(CustomerParams cp) {
        String showShortNameStr;
        this.clear();
        String showEntryStr = cp.getCustomerParam("isShowEntry");
        if (null != showEntryStr) {
            boolean isShowEntry = Boolean.parseBoolean(showEntryStr);
            if (isShowEntry) {
                this.radioEntries.setSelected(true);
            } else {
                this.radioHead.setSelected(true);
            }
        }
        if (null != (showShortNameStr = cp.getCustomerParam("isShowShortName"))) {
            this.ckBxMShortName.setSelected(Boolean.parseBoolean(showShortNameStr));
        }
    }

    protected HashMap getUIParam() {
        return this.uiParam;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.kDBizPrCompany;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.ckBxMShortName.setVisible(true);
        this.txtMShortNameFrom.setVisible(true);
        this.txtMShortNameTo.setVisible(true);
        this.ckBxMShortName.setSelected(false);
        this.txtMShortNameFrom.setEnabled(false);
        this.txtMShortNameTo.setEnabled(false);
        if (this.cache == null || this.cache.getCompany() == null) {
            this.cache = ArApBillFacadeFactory.getRemoteInstance().getSysParams(null, this.getUIParam());
        }
        this.kDBizPrCompany.setValue((Object)this.cache.getCompany());
        this.setCompanyF7();
        ArApBillUIUtil.makeAsstActType(this.kdComAsstActType, this.cache, true);
        this.kDBizCurrency.setVisible(true);
        this.kDBizCurrency.setEditable(true);
        this.kDBizCurrency.setDisplayFormat("$name$");
        this.kDBizCurrency.setEditFormat("$number$");
        this.kDBizCurrency.setCommitFormat("$number$");
        this.kDBizCurrency.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CurrencyQuery");
        this.kdComBillType.removeAllItems();
        if ("com.kingdee.eas.scm.cal.config.IncomeWriteOffConfig".equals(this.getUIContext().get("UIClassParam"))) {
            this.kdComBillType.addItem((Object)IncomeConfimBillTypeEnum.SALE_INCOME);
        } else {
            this.kdComBillType.addItem((Object)EASResource.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"itemAll"));
            this.kdComBillType.addItem((Object)IncomeConfimBillTypeEnum.SALE_INCOME);
            this.kdComBillType.addItem((Object)IncomeConfimBillTypeEnum.SALE_EXPENSE_INCOME);
            this.kdComBillType.addItem((Object)IncomeConfimBillTypeEnum.OTHER_INCOME);
        }
        String companyId = this.cache.getCompanyId();
        ArApBillUIUtil.setAdminAllCUNew((IUIObject)this, this.prmtAdminOrgFrom, false, true, false);
        ArApBillUIUtil.setAdminOrgUnitFilterByParam((IUIObject)this, this.prmtAdminOrgFrom, companyId);
        ArApBillUIUtil.setAdminAllCUNew((IUIObject)this, this.prmtAdminOrgTo, false, true, false);
        ArApBillUIUtil.setAdminOrgUnitFilterByParam((IUIObject)this, this.prmtAdminOrgTo, companyId);
        ArApBillUIUtil.setPersonAllCU((IUIObject)this, this.prmtPersonFrom);
        ArApBillUIUtil.setPersonAllCU((IUIObject)this, this.prmtPersonTo);
        this.setNumber(this.kDBizBillNumFrom, companyId);
        this.setNumber(this.kDBizBillNumTo, companyId);
        this.kdBillDateFrom.setEditable(true);
        this.kdBillDateTo.setEditable(true);
        this.setF7ExtendParser();
        ArApBillUIUtil.setMaterialF7((CoreUIObject)this, this.prmtMaterialFrom, this.cache, false, true);
        ArApBillUIUtil.setMaterialF7((CoreUIObject)this, this.prmtMaterialTo, this.cache, false, true);
        ArApBillUIUtil.setOrgUnitF7(this.prmtSaleOrgFrom, OrgType.Sale, companyId, this.cache);
        ArApBillUIUtil.setOrgUnitF7(this.prmtSaleOrgTo, OrgType.Sale, companyId, this.cache);
        this.radioEntries.setSelected(true);
    }

    public FilterInfo getFilterInfo() {
        FilterItemInfo filterDisplay;
        FilterItemInfo filterAccountant;
        FilterItemInfo filterAudit;
        FilterItemInfo toNumberFilter;
        FilterItemInfo shortNameToFilter;
        String shortNameTo;
        String strNumber;
        FilterItemInfo fromNumberFilter;
        String asstActNumber;
        Object asstActType;
        Object billTypeObject;
        StringBuffer sbFormula = new StringBuffer();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        int i = 0;
        if (this.cache.getCompanyId() != null) {
            FilterItemInfo companyFilter = new FilterItemInfo("company.id", (Object)this.cache.getCompanyId(), CompareType.EQUALS);
            items.add(companyFilter);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if ((billTypeObject = this.kdComBillType.getSelectedItem()) != null && !ComBoxInfo.ITEM_ALL.equals(billTypeObject)) {
            IncomeConfimBillTypeEnum billType = (IncomeConfimBillTypeEnum)((Object)this.kdComBillType.getSelectedItem());
            FilterItemInfo billTypeFilter = new FilterItemInfo("billType", (Object)Integer.valueOf(String.valueOf(billType.getValue())), CompareType.EQUALS);
            items.add(billTypeFilter);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.kdBillDateFrom.getTimestamp() != null) {
            FilterItemInfo fromBillDateFilter = new FilterItemInfo("billDate", (Object)BaseDataUtil.downTimestamp(this.kdBillDateFrom.getTimestamp()), CompareType.GREATER_EQUALS);
            items.add(fromBillDateFilter);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.kdBillDateTo.getTimestamp() != null) {
            FilterItemInfo toBillDateFilter = new FilterItemInfo("billDate", (Object)BaseDataUtil.upTimestamp(this.kdBillDateTo.getTimestamp()), CompareType.LESS);
            items.add(toBillDateFilter);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.kDBizCurrency.getData() != null) {
            String currencyId = ((CurrencyInfo)this.kDBizCurrency.getData()).getId().toString();
            FilterItemInfo currencyFilter = new FilterItemInfo("currency.id", (Object)currencyId, CompareType.EQUALS);
            items.add(currencyFilter);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if ((asstActType = this.kdComAsstActType.getSelectedItem()) != null && !ComBoxInfo.ITEM_ALL.equals(asstActType)) {
            String assActTypeId = ((AsstActTypeInfo)this.kdComAsstActType.getSelectedItem()).getId().toString();
            FilterItemInfo asstActTypeFiter = new FilterItemInfo("asstActType.id", (Object)assActTypeId, CompareType.EQUALS);
            items.add(asstActTypeFiter);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.prmtAcctCussentFrom.getData() != null) {
            asstActNumber = ArApBillUIUtil.getNumberValue(this.prmtAcctCussentFrom);
            fromNumberFilter = new FilterItemInfo("asstActNumber", (Object)asstActNumber, CompareType.GREATER_EQUALS);
            items.add(fromNumberFilter);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.prmtAcctCussentTo.getData() != null) {
            asstActNumber = ArApBillUIUtil.getNumberValue(this.prmtAcctCussentTo);
            fromNumberFilter = new FilterItemInfo("asstActNumber", (Object)asstActNumber, CompareType.LESS_EQUALS);
            items.add(fromNumberFilter);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (null != this.prmtAcctCussentTo.getData() && null != this.prmtAcctCussentFrom.getData() && ArApBillUIUtil.getIDValue(this.prmtAcctCussentFrom).equals(ArApBillUIUtil.getIDValue(this.prmtAcctCussentTo))) {
            String asstActId = ArApBillUIUtil.getIDValue(this.prmtAcctCussentTo);
            fromNumberFilter = new FilterItemInfo("asstActID", (Object)asstActId, CompareType.EQUALS);
            items.add(fromNumberFilter);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.prmtMaterialFrom.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.prmtMaterialFrom);
            fromNumberFilter = new FilterItemInfo("entry.material.number", (Object)strNumber, CompareType.GREATER_EQUALS);
            items.add(fromNumberFilter);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.prmtMaterialTo.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.prmtMaterialTo);
            fromNumberFilter = new FilterItemInfo("entry.material.number", (Object)strNumber, CompareType.LESS_EQUALS);
            items.add(fromNumberFilter);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.txtMShortNameFrom.getText().trim().length() > 0) {
            String shortNameFrom = this.txtMShortNameFrom.getText().trim();
            FilterItemInfo shortNameFromFilter = new FilterItemInfo("material.shortName", (Object)shortNameFrom, CompareType.GREATER_EQUALS);
            items.add(shortNameFromFilter);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.txtMShortNameTo.getText().trim().length() > 0 && this.txtMShortNameFrom.getText().trim().length() > 0) {
            shortNameTo = this.txtMShortNameTo.getText().trim();
            shortNameToFilter = new FilterItemInfo("material.shortName", (Object)shortNameTo, CompareType.LESS_EQUALS);
            items.add(shortNameToFilter);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.txtMShortNameTo.getText().trim().length() > 0 && this.txtMShortNameFrom.getText().trim().length() <= 0) {
            shortNameTo = this.txtMShortNameTo.getText().trim();
            shortNameToFilter = new FilterItemInfo("material.shortName", (Object)shortNameTo, CompareType.LESS_EQUALS);
            items.add(shortNameToFilter);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and (#" + i++);
            }
            FilterItemInfo shortNameIsNull = new FilterItemInfo("material.shortName", null, CompareType.IS);
            items.add(shortNameIsNull);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" or #" + i++ + ")");
            }
        }
        if (this.prmtExpenseItemFrom.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.prmtExpenseItemFrom);
            fromNumberFilter = new FilterItemInfo("entry.expenseItem.number", (Object)strNumber, CompareType.GREATER_EQUALS);
            items.add(fromNumberFilter);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.prmtExpenseItemTo.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.prmtExpenseItemTo);
            fromNumberFilter = new FilterItemInfo("entry.expenseItem.number", (Object)strNumber, CompareType.LESS_EQUALS);
            items.add(fromNumberFilter);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.prmtSaleOrgFrom.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.prmtSaleOrgFrom);
            fromNumberFilter = new FilterItemInfo("saleOrg.number", (Object)strNumber, CompareType.GREATER_EQUALS);
            items.add(fromNumberFilter);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.prmtSaleOrgTo.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.prmtSaleOrgTo);
            fromNumberFilter = new FilterItemInfo("saleOrg.number", (Object)strNumber, CompareType.LESS_EQUALS);
            items.add(fromNumberFilter);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.kDBizBillNumFrom.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.kDBizBillNumFrom);
            fromNumberFilter = new FilterItemInfo("number", (Object)strNumber, CompareType.GREATER_EQUALS);
            items.add(fromNumberFilter);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.kDBizBillNumTo.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.kDBizBillNumTo);
            toNumberFilter = new FilterItemInfo("number", (Object)strNumber, CompareType.LESS_EQUALS);
            items.add(toNumberFilter);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.prmtAdminOrgFrom.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.prmtAdminOrgFrom);
            fromNumberFilter = new FilterItemInfo("adminOrgUnit.number", (Object)strNumber, CompareType.GREATER_EQUALS);
            items.add(fromNumberFilter);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.prmtAdminOrgTo.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.prmtAdminOrgTo);
            toNumberFilter = new FilterItemInfo("adminOrgUnit.number", (Object)strNumber, CompareType.LESS_EQUALS);
            items.add(toNumberFilter);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.prmtPersonFrom.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.prmtPersonFrom);
            fromNumberFilter = new FilterItemInfo("person.number", (Object)strNumber, CompareType.GREATER_EQUALS);
            items.add(fromNumberFilter);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.prmtPersonTo.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.prmtPersonTo);
            toNumberFilter = new FilterItemInfo("person.number", (Object)strNumber, CompareType.LESS_EQUALS);
            items.add(toNumberFilter);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.radAudit.isSelected()) {
            filterAudit = new FilterItemInfo("billStatus", (Object)new Integer(3), CompareType.EQUALS);
            items.add(filterAudit);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        } else if (this.radUnAudit.isSelected()) {
            filterAudit = new FilterItemInfo("billStatus", (Object)new Integer(3), CompareType.NOTEQUALS);
            items.add(filterAudit);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.radVouchered.isSelected()) {
            filterAccountant = new FilterItemInfo("fiVouchered", (Object)Boolean.TRUE, CompareType.EQUALS);
            items.add(filterAccountant);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        } else if (this.radUnVouchered.isSelected()) {
            filterAccountant = new FilterItemInfo("fiVouchered", (Object)Boolean.TRUE, CompareType.NOTEQUALS);
            items.add(filterAccountant);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (this.radioHead.isSelected()) {
            filterDisplay = new FilterItemInfo("entry.seq", (Object)1, CompareType.EQUALS);
            items.add(filterDisplay);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        } else if (this.radioEntries.isSelected()) {
            filterDisplay = new FilterItemInfo("entry.seq", (Object)0, CompareType.NOTEQUALS);
            items.add(filterDisplay);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (sbFormula.toString().length() != 0) {
            filter.setMaskString(sbFormula.toString());
        }
        return filter;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        Object fiVoucheredNotEquals;
        Object fiVoucheredEquals;
        Object billStatusTo;
        Object currencyObjecct;
        super.loadData(entityViewInfo);
        FilterItemCollection filters = entityViewInfo.getFilter().getFilterItems();
        FilterInfoExtractor filterExtrator = new FilterInfoExtractor(filters);
        Object companyObject = filterExtrator.getCompareValue("company.id", CompareType.EQUALS);
        if (companyObject != null) {
            CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
            companyInfo.setId(BOSUuid.read((String)companyObject.toString()));
            try {
                if (!ArApBillHelper.idEquals((CoreBaseInfo)this.cache.getCompany(), (CoreBaseInfo)companyInfo)) {
                    this.cache = ArApBillFacadeFactory.getRemoteInstance().getSysParams(companyInfo, this.getUIParam());
                }
                ArApQueryUIUtil.setBizCompanyData(this.kDBizPrCompany, companyObject.toString());
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((currencyObjecct = filterExtrator.getCompareValue("currency.id", CompareType.EQUALS)) != null) {
            this.setBizPromptData(this.kDBizCurrency, currencyObjecct.toString());
        } else {
            this.kDBizCurrency.setValue(null);
        }
        Object billDateFromObject = filterExtrator.getCompareValue("billDate", CompareType.GREATER_EQUALS);
        this.kdBillDateFrom.setValue(billDateFromObject);
        Object billDateToObject = filterExtrator.getCompareValue("billDate", CompareType.LESS);
        if (billDateToObject != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)billDateToObject);
            calendar.add(5, -1);
            this.kdBillDateTo.setValue((Object)calendar.getTime());
        } else {
            this.kdBillDateTo.setValue(null);
        }
        Object numberFrom = filterExtrator.getCompareValue("number", CompareType.GREATER_EQUALS);
        this.kDBizBillNumFrom.setValue(numberFrom);
        Object numberTo = filterExtrator.getCompareValue("number", CompareType.LESS_EQUALS);
        this.kDBizBillNumTo.setValue(numberTo);
        Object asstActType = filterExtrator.getCompareValue("asstActType.id", CompareType.EQUALS);
        if (asstActType != null) {
            int itemCount = this.kdComAsstActType.getItemCount();
            for (int j = 0; j < itemCount; ++j) {
                String assActTypeId;
                if (this.kdComAsstActType.getItemAt(j).equals(ComBoxInfo.ITEM_ALL) || !(assActTypeId = ((AsstActTypeInfo)this.kdComAsstActType.getItemAt(j)).getId().toString()).equals(asstActType.toString())) continue;
                this.kdComAsstActType.setSelectedIndex(j);
                break;
            }
        }
        Object asstActNumber = filterExtrator.getCompareValue("asstActNumber", CompareType.GREATER_EQUALS);
        Object asstActID = filterExtrator.getCompareValue("asstActID", CompareType.EQUALS);
        if (asstActID != null) {
            try {
                DataBaseInfo dbInfo = ArApBillHelper.getAccountCussent((String)asstActType, (String)asstActID, (String)asstActNumber);
                this.prmtAcctCussentFrom.setValue((Object)dbInfo);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        } else {
            this.prmtAcctCussentFrom.setValue(asstActNumber);
        }
        Object asstActNumberTo = filterExtrator.getCompareValue("asstActNumber", CompareType.LESS_EQUALS);
        if (asstActID != null) {
            try {
                DataBaseInfo dbInfo = ArApBillHelper.getAccountCussent((String)asstActType, (String)asstActID, (String)asstActNumberTo);
                this.prmtAcctCussentTo.setValue((Object)dbInfo);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        } else {
            this.prmtAcctCussentTo.setValue(asstActNumberTo);
        }
        Object materialNumberFrom = filterExtrator.getCompareValue("entry.material.number", CompareType.GREATER_EQUALS);
        this.prmtMaterialFrom.setValue(materialNumberFrom);
        Object materialNumberTo = filterExtrator.getCompareValue("entry.material.number", CompareType.LESS_EQUALS);
        this.prmtMaterialTo.setValue(materialNumberTo);
        Object billType = filterExtrator.getCompareValue("billType", CompareType.EQUALS);
        if (billType != null) {
            this.kdComBillType.setSelectedItem((Object)IncomeConfimBillTypeEnum.getEnum((Integer)billType));
        }
        Object shortNameFrom = filterExtrator.getCompareValue("material.shortName", CompareType.GREATER_EQUALS);
        this.txtMShortNameFrom.setText((String)shortNameFrom);
        Object shortNameTo = filterExtrator.getCompareValue("material.shortName", CompareType.LESS_EQUALS);
        this.txtMShortNameTo.setText((String)shortNameTo);
        if (!this.ckBxMShortName.isSelected()) {
            this.txtMShortNameFrom.setText(null);
            this.txtMShortNameTo.setText(null);
        }
        Object expenseItemFrom = filterExtrator.getCompareValue("entry.expenseItem.number", CompareType.GREATER_EQUALS);
        this.prmtExpenseItemFrom.setValue(expenseItemFrom);
        Object expenseNumberTo = filterExtrator.getCompareValue("entry.expenseItem.number", CompareType.LESS_EQUALS);
        this.prmtExpenseItemTo.setValue(expenseNumberTo);
        Object saleOrgNumberFrom = filterExtrator.getCompareValue("saleOrg.number", CompareType.GREATER_EQUALS);
        this.prmtSaleOrgFrom.setValue(saleOrgNumberFrom);
        Object saleOrgNumberTo = filterExtrator.getCompareValue("saleOrg.number", CompareType.LESS_EQUALS);
        this.prmtSaleOrgTo.setValue(saleOrgNumberTo);
        Object adminOrgUnitFrom = filterExtrator.getCompareValue("adminOrgUnit.number", CompareType.GREATER_EQUALS);
        this.prmtAdminOrgFrom.setValue(adminOrgUnitFrom);
        Object adminOrgUnitTo = filterExtrator.getCompareValue("adminOrgUnit.number", CompareType.LESS_EQUALS);
        this.prmtAdminOrgTo.setValue(adminOrgUnitTo);
        Object personFrom = filterExtrator.getCompareValue("person.number", CompareType.GREATER_EQUALS);
        this.prmtPersonFrom.setValue(personFrom);
        Object personTo = filterExtrator.getCompareValue("person.number", CompareType.LESS_EQUALS);
        this.prmtPersonTo.setValue(personTo);
        Object billStatusFrom = filterExtrator.getCompareValue("billStatus", CompareType.EQUALS);
        if (billStatusFrom != null) {
            this.radAudit.setSelected(true);
        }
        if ((billStatusTo = filterExtrator.getCompareValue("billStatus", CompareType.NOTEQUALS)) != null) {
            this.radUnAudit.setSelected(true);
        }
        if ((fiVoucheredEquals = filterExtrator.getCompareValue("fiVouchered", CompareType.EQUALS)) != null) {
            this.radVouchered.setSelected(true);
        }
        if ((fiVoucheredNotEquals = filterExtrator.getCompareValue("fiVouchered", CompareType.NOTEQUALS)) != null) {
            this.radUnVouchered.setSelected(true);
        }
    }

    @Override
    protected void kDBizPrCompany_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() == null || e.getNewValue().equals(e.getOldValue())) {
            return;
        }
        if (!ArApBillHelper.idEquals((CoreBaseInfo)this.cache.getCompany(), (CoreBaseInfo)((CompanyOrgUnitInfo)e.getNewValue()))) {
            this.cache = ArApBillFacadeFactory.getRemoteInstance().getSysParams((CompanyOrgUnitInfo)e.getNewValue(), this.getUIParam());
        }
        ArApBillUIUtil.makeAsstActType(this.kdComAsstActType, this.cache, true);
        this.setF7ExtendParser();
        ArApBillUIUtil.setMaterialF7((CoreUIObject)this, this.prmtMaterialFrom, this.cache, false, true);
        ArApBillUIUtil.setMaterialF7((CoreUIObject)this, this.prmtMaterialTo, this.cache, false, true);
        ArApBillUIUtil.setExpenseTypeFilter(this.prmtExpenseItemFrom, (CoreUIObject)this, true, "OtherArBill", this.cache.getCompany(), false);
        ArApBillUIUtil.setExpenseTypeFilter(this.prmtExpenseItemTo, (CoreUIObject)this, true, "OtherArBill", this.cache.getCompany(), false);
        this.prmtExpenseItemFrom.setDisplayFormat("$name$");
        this.prmtExpenseItemTo.setDisplayFormat("$name$");
        String companyId = this.cache.getCompanyId();
        this.setNumber(this.kDBizBillNumFrom, companyId);
        this.setNumber(this.kDBizBillNumTo, companyId);
        ArApBillUIUtil.setOrgUnitF7(this.prmtSaleOrgFrom, OrgType.Sale, companyId, this.cache);
        ArApBillUIUtil.setOrgUnitF7(this.prmtSaleOrgTo, OrgType.Sale, companyId, this.cache);
        ArApBillUIUtil.setAdminAllCUNew((IUIObject)this, this.prmtAdminOrgFrom, false, true, false);
        ArApBillUIUtil.setAdminAllCUNew((IUIObject)this, this.prmtAdminOrgTo, false, true, false);
        ArApBillUIUtil.setAdminOrgUnitFilterByParam((IUIObject)this, this.prmtAdminOrgFrom, companyId);
        ArApBillUIUtil.setAdminOrgUnitFilterByParam((IUIObject)this, this.prmtAdminOrgTo, companyId);
        this.getUIContext().put("COMPANY", e.getNewValue());
    }

    @Override
    protected void radUnAudit_itemStateChanged(ItemEvent e) throws Exception {
        if (this.radUnAudit.isSelected()) {
            this.radVouchered.setEnabled(false);
            this.radUnVouchered.setEnabled(false);
            this.radVoucheredAll.setSelected(true);
        } else {
            this.radVouchered.setEnabled(true);
            this.radUnVouchered.setEnabled(true);
        }
    }

    @Override
    protected void kdComAsstActType_itemStateChanged(ItemEvent e) throws Exception {
        this.prmtAcctCussentFrom.setValue(null);
        this.prmtAcctCussentTo.setValue(null);
        Object obj = this.kdComAsstActType.getSelectedItem();
        if (ComBoxInfo.ITEM_ALL.equals(obj) || this.kdComAsstActType.getItemCount() == 0 || obj == null) {
            this.prmtAcctCussentFrom.setEnabled(false);
            this.prmtAcctCussentTo.setEnabled(false);
            return;
        }
        AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)obj;
        ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmtAcctCussentFrom, (Object)asstActTypeInfo, this.cache, false, true);
        ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmtAcctCussentTo, (Object)asstActTypeInfo, this.cache, false, true);
        this.prmtAcctCussentFrom.setEnabled(true);
        this.prmtAcctCussentTo.setEnabled(true);
    }

    public boolean verify() {
        Timestamp dateTo;
        Timestamp dateFrom;
        if (this.kDBizPrCompany.getValue() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"6_OtherBillQueryUI"));
            this.kDBizPrCompany.requestFocus();
            return false;
        }
        if (this.kdBillDateFrom.getValue() != null && this.kdBillDateTo.getValue() != null && (dateFrom = this.kdBillDateFrom.getTimestamp()).after((Date)(dateTo = this.kdBillDateTo.getTimestamp()))) {
            this.kdBillDateFrom.requestFocus();
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"204_DateFail"));
            return false;
        }
        return super.verify();
    }

    @Override
    protected void kdComBillType_itemStateChanged(ItemEvent e) throws Exception {
        boolean isMaterialBill;
        super.kdComBillType_itemStateChanged(e);
        if (this.kdComBillType.getSelectedItem() instanceof IncomeConfimBillTypeEnum) {
            this.prmtMaterialFrom.setEnabled(true);
            this.prmtMaterialTo.setEnabled(true);
            this.prmtExpenseItemFrom.setEnabled(true);
            this.prmtExpenseItemTo.setEnabled(true);
        } else {
            this.ckBxMShortName.setSelected(false);
            this.ckBxMShortName.setEnabled(false);
            this.txtMShortNameFrom.setText(null);
            this.txtMShortNameTo.setText(null);
            this.prmtMaterialFrom.setEnabled(false);
            this.prmtMaterialTo.setEnabled(false);
            this.prmtExpenseItemFrom.setEnabled(false);
            this.prmtExpenseItemTo.setEnabled(false);
        }
        boolean bl = isMaterialBill = !IncomeConfimBillTypeEnum.SALE_EXPENSE_INCOME.equals(this.kdComBillType.getSelectedItem()) && !IncomeConfimBillTypeEnum.OTHER_INCOME.equals(this.kdComBillType.getSelectedItem());
        if (!isMaterialBill) {
            this.prmtMaterialFrom.setValue(null);
            this.prmtMaterialTo.setValue(null);
            this.kDLabelContainer5.setVisible(false);
            this.kDLabelContainer6.setVisible(false);
            this.kDLabelContainer9.setVisible(true);
            this.kDLabelContainer10.setVisible(true);
            this.ckBxMShortName.setSelected(false);
            this.ckBxMShortName.setEnabled(false);
            this.txtMShortNameFrom.setText(null);
            this.txtMShortNameTo.setText(null);
        } else {
            this.prmtExpenseItemFrom.setValue(null);
            this.prmtExpenseItemTo.setValue(null);
            this.txtMShortNameFrom.setText(null);
            this.txtMShortNameTo.setText(null);
            this.kDLabelContainer5.setVisible(true);
            this.kDLabelContainer6.setVisible(true);
            this.kDLabelContainer9.setVisible(false);
            this.kDLabelContainer10.setVisible(false);
            if (this.kdComBillType.getSelectedItem() != null && this.kdComBillType.getSelectedItem().equals((Object)IncomeConfimBillTypeEnum.SALE_INCOME)) {
                this.ckBxMShortName.setSelected(false);
                this.ckBxMShortName.setEnabled(true);
                this.txtMShortNameFrom.setText(null);
                this.txtMShortNameTo.setText(null);
            }
        }
    }

    @Override
    protected void ckBxMShortName_stateChanged(ChangeEvent e) throws Exception {
        this.txtMShortNameFrom.setText(null);
        this.txtMShortNameTo.setText(null);
        boolean isShowShortName = this.ckBxMShortName.isSelected();
        this.txtMShortNameFrom.setEnabled(isShowShortName);
        this.txtMShortNameTo.setEnabled(isShowShortName);
    }

    public void clear() {
        if (this.getUIContext().get("ARAPCOMPANY") != null) {
            this.kDBizPrCompany.setValue(this.getUIContext().get("ARAPCOMPANY"));
            this.kDBizPrCompany.setEnabled(true);
        } else {
            try {
                this.cache = ArApBillFacadeFactory.getRemoteInstance().getSysParams(null, this.getUIParam());
                this.kDBizPrCompany.setValue((Object)this.cache.getCompany());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        this.kDBizCurrency.setValue(null);
        this.prmtAcctCussentFrom.setValue(null);
        this.prmtAcctCussentTo.setValue(null);
        this.kdBillDateTo.setValue((Object)SCMUtils.getSCMQueryTime(null, (String)"endDate"));
        this.kdBillDateFrom.setValue((Object)SCMUtils.getSCMQueryTime(null, (String)"startDate"));
        this.kDBizBillNumFrom.setValue(null);
        this.kDBizBillNumTo.setValue(null);
        this.ckBxMShortName.setSelected(false);
        this.txtMShortNameFrom.setText(null);
        this.txtMShortNameTo.setText(null);
        this.prmtMaterialFrom.setValue(null);
        this.prmtMaterialTo.setValue(null);
        this.prmtExpenseItemFrom.setValue(null);
        this.prmtExpenseItemTo.setValue(null);
        this.prmtPersonFrom.setValue(null);
        this.prmtPersonTo.setValue(null);
        this.prmtSaleOrgFrom.setValue(null);
        this.prmtSaleOrgFrom.setValue(null);
        this.prmtAdminOrgFrom.setValue(null);
        this.prmtAdminOrgTo.setValue(null);
        this.radVoucheredAll.setSelected(true);
        this.radAuditAll.setSelected(true);
        try {
            ArApBillUIUtil.makeAsstActType(this.kdComAsstActType, this.cache, true);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        this.kdComBillType.setSelectedItem((Object)ComBoxInfo.ITEM_ALL);
        this.radioEntries.setSelected(true);
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = new RequestContext();
            this.prepareHandlerParam(request);
            request.setClassName(this.getUIHandlerClassName());
            handler.setRequestContext((Serializable)request);
        }
        return handler;
    }

    private void prepareHandlerParam(RequestContext request) {
        request.put("uiparam", (Object)this.getUIParam());
        request.put("cache", (Object)this.cache);
    }

    protected void setNumber(KDBizPromptBox kDBizBillNum, String companyId) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        kDBizBillNum.setEntityViewInfo(viewInfo);
        kDBizBillNum.setVisible(true);
        kDBizBillNum.setEditFormat("$number$");
        kDBizBillNum.setDisplayFormat("$number$");
        kDBizBillNum.setCommitFormat("$number$");
        kDBizBillNum.setQueryInfo("com.kingdee.eas.fi.ar.app.F7IncomeConfirmBillQuery");
    }

    protected void setCompanyF7() {
        this.kDBizPrCompany.setRequired(true);
        this.kDBizPrCompany.setEnabled(true);
        this.kDBizPrCompany.setEditFormat("$number$");
        this.kDBizPrCompany.setDisplayFormat("$name$");
        this.kDBizPrCompany.setCommitFormat("$number$");
        this.kDBizPrCompany.setEditable(true);
        this.kDBizPrCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company, "fi_ar_IncomeConfirmBill_View");
        this.kDBizPrCompany.setFilterInfoProducer((IFilterInfoProducer)iProducer);
    }

    protected void setF7ExtendParser() {
        ExtendParser parserMaterialFrom = new ExtendParser(this.prmtMaterialFrom);
        this.prmtMaterialFrom.setCommitParser((IParser)parserMaterialFrom);
        this.prmtMaterialFrom.setDisplayFormat("$name$");
        this.prmtMaterialFrom.setMaxLength(80);
        ExtendParser parserMaterialTo = new ExtendParser(this.prmtMaterialTo);
        this.prmtMaterialTo.setCommitParser((IParser)parserMaterialTo);
        this.prmtMaterialTo.setDisplayFormat("$name$");
        this.prmtMaterialTo.setMaxLength(80);
        ExtendParser parserExpenseItemFrom = new ExtendParser(this.prmtExpenseItemFrom);
        this.prmtExpenseItemFrom.setCommitParser((IParser)parserExpenseItemFrom);
        this.prmtExpenseItemFrom.setDisplayFormat("$name$");
        this.prmtExpenseItemFrom.setMaxLength(80);
        ExtendParser parserExpenseItemTo = new ExtendParser(this.prmtExpenseItemTo);
        this.prmtExpenseItemTo.setCommitParser((IParser)parserExpenseItemTo);
        this.prmtExpenseItemTo.setDisplayFormat("$name$");
        this.prmtExpenseItemTo.setMaxLength(80);
    }

    private void setBizPromptData(KDBizPromptBox bizPrompt, String id) {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(id);
            IObjectValue objVal = DynamicObjectFactory.getRemoteInstance().getValue(pk.getObjectType(), (IObjectPK)pk);
            bizPrompt.setData((Object)objVal);
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
    }
}

