/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ar.IInitBadAccount;
import com.kingdee.eas.fi.ar.InitBadAccountFactory;
import com.kingdee.eas.fi.ar.InitBadAccountInfo;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.client.AbstractInitBadAccountListUI;
import com.kingdee.eas.fi.ar.client.InitBadAccountEditUI;
import com.kingdee.eas.fi.ar.client.InitBadAccountQueryUI;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.client.util.CommonClientUtils;
import com.kingdee.eas.fi.arap.client.util.ArApReportUIUtil;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class InitBadAccountListUI
extends AbstractInitBadAccountListUI {
    private static final String TB_EXCHANGE_RATE = "exchangeRate";
    private static final String TB_AMOUNTS = "amounts";
    private static final String TB_CREATE_TIME = "createTime";
    private static final String DATE_FORMAT = CtrlFormatUtilities.getDateFormatString();
    private CompanyOrgUnitInfo currentCompany = null;
    private CurrencyInfo localCurrency = null;
    private InitBadAccountQueryUI initBadAccountQueryUI = null;
    private PeriodInfo startPeriod = null;
    CommonQueryDialog dialog = null;
    private List lockObjs = new ArrayList();
    private List lockedObjs = new ArrayList();
    private UserInfo defaultUserInfo = null;
    private LogUtil logUtil = new LogUtil();

    public InitBadAccountListUI() throws Exception {
        this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        ArApReportUIUtil.checkCompany((Component)((Object)this), this.currentCompany);
    }

    public void onLoad() throws Exception {
        if (this.defaultUserInfo == null) {
            this.defaultUserInfo = SysContext.getSysContext().getCurrentUserInfo();
        }
        this.localCurrency = CommonClientUtils.getCurrency(String.valueOf(this.currentCompany.getBaseCurrency().getId()));
        super.onLoad();
        this.initTable();
        this.btnAttachment.setVisible(true);
        this.actionAttachment.setVisible(true);
    }

    protected void initWorkButton() {
        try {
            this.startPeriod = ArClientUtils.getArStartPeriod(this.currentCompany);
            if (this.startPeriod == null) {
                throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{this.currentCompany.getName() + this.getSystemEnumForOA().getAlias()});
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        super.initWorkButton();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                InitBadAccountListUI.this.tblMain_afterDataFill(e);
            }
        });
    }

    private void tblMain_afterDataFill(KDTDataRequestEvent e) {
        this.changeData(e.getFirstRow(), e.getLastRow());
    }

    private void initTable() {
        this.tblMain.getColumn(TB_EXCHANGE_RATE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_AMOUNTS).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_CREATE_TIME).getStyleAttributes().setNumberFormat(DATE_FORMAT);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = super.initCommonQueryDialog();
        try {
            if (this.initBadAccountQueryUI == null) {
                this.initBadAccountQueryUI = new InitBadAccountQueryUI();
            }
            this.dialog.addUserPanel((KDPanel)this.initBadAccountQueryUI);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.dialog.setHeight(260);
        this.dialog.setWidth(397);
        this.dialog.setTitle(this.getStrResource("init_badacct_condition_query"));
        return this.dialog;
    }

    protected EntityViewInfo getInitDefaultSolution() {
        EntityViewInfo ev = new EntityViewInfo();
        InitBadAccountQueryUI queryUI = null;
        try {
            queryUI = new InitBadAccountQueryUI();
            queryUI.onLoad();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (queryUI != null) {
            ev.setFilter(queryUI.getFilterInfo());
        }
        return ev;
    }

    private String getStrResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)key);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getEditUIName() {
        return InitBadAccountEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return InitBadAccountFactory.getRemoteInstance();
    }

    private void changeData(int beginRow, int endRow) {
        IMutexServiceControl mutex = MutexServiceControlFactory.getRemoteInstance();
        try {
            ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
            ObjectUuidPK pk = null;
            for (int i = beginRow; i <= endRow; ++i) {
                IRow row = this.tblMain.getRow(i);
                String id = row.getCell("id").getValue().toString();
                if (!this.lockObjs.contains(id)) {
                    if (mutex.requestObjIDForUpdate(id, this.defaultUserInfo.getString("id"))) {
                        this.lockObjs.add(id);
                    } else {
                        this.lockedObjs.add(id);
                        row.setUserObject((Object)"locked");
                        row.getStyleAttributes().setLocked(true);
                        row.getStyleAttributes().setBackground(Color.decode("#E8E8E3"));
                    }
                }
                if (row.getCell("currencyID").getValue() == null) continue;
                pk = new ObjectUuidPK(row.getCell("currencyID").getValue().toString());
                CurrencyInfo currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)pk);
                int precision = 0;
                ExchangeRateInfo rateInfo = BaseDataUtil.getExchangeRate(this.currentCompany, currencyInfo, (Date)row.getCell("badAccountDate").getValue());
                if (rateInfo != null) {
                    precision = rateInfo.getPrecision();
                }
                row.getCell(TB_EXCHANGE_RATE).getStyleAttributes().setNumberFormat(PrecisionFormatUtils.getFormatString(precision));
                row.getCell(TB_AMOUNTS).getStyleAttributes().setNumberFormat(PrecisionFormatUtils.getFormatString(currencyInfo));
            }
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        int rowIndex = 0;
        if (selectBlock != null) {
            rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            String ID = row.getCell("id").getValue().toString();
            ObjectUuidPK pk = new ObjectUuidPK(ID);
            IInitBadAccount iInitBadAccount = InitBadAccountFactory.getRemoteInstance();
            InitBadAccountInfo initBadAccountInfo = iInitBadAccount.getInitBadAccountInfo((IObjectPK)pk);
            if (initBadAccountInfo.getTakeBackAmounts().compareTo(new BigDecimal("0.0")) > 0) {
                MsgBox.showInfo((String)this.getStrResource("init_acct_bad_take_back_modify"));
                SysUtil.abort();
            }
        }
        IUIWindow uiWindow = this.showEditUI(e);
        uiWindow.show();
        if (this.needRefresh(uiWindow)) {
            this.refresh(e);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        if (this.needRefresh(uiWindow)) {
            this.refresh(e);
        }
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        this.checkSelected();
        this.checkObjectExists();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected boolean checkBeforeWindowClosing() {
        this.releaseLock();
        return super.checkBeforeWindowClosing();
    }

    protected void finalize() throws Throwable {
        this.releaseLock();
        super.finalize();
    }

    public IUIWindow showEditUI(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkObjectExists();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT);
        return uiWindow;
    }

    public void checkObjectExists() throws BOSException, EASBizException, Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    private void releaseLock() {
        IMutexServiceControl mutex = MutexServiceControlFactory.getRemoteInstance();
        int iCount = this.lockObjs.size();
        for (int i = 0; i < iCount; ++i) {
            mutex.releaseObjIDForUpdate(this.lockObjs.get(i).toString());
        }
        this.lockObjs.clear();
    }

    private boolean needRefresh(IUIWindow uiWindow) {
        if (this.getEditUIModal().equals("com.kingdee.eas.base.uiframe.client.UIModelDialogFactory")) {
            return !(uiWindow.getUIObject() instanceof EditUI) || ((EditUI)uiWindow.getUIObject()).isSave();
        }
        return false;
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        IRow row = null;
        String ID = null;
        ObjectUuidPK pk = null;
        InitBadAccountInfo initBadAccountInfo = null;
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        this.checkSelected();
        for (int i = selectBlock.getTop(); i <= selectBlock.getEndRow(); ++i) {
            row = this.tblMain.getRow(i);
            ID = row.getCell("id").getValue().toString();
            if (!this.lockedObjs.contains(ID)) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"13_BadAccountParamEditUI"));
            SysUtil.abort();
        }
        if (this.confirmRemove()) {
            if (selectBlock != null) {
                int i;
                IInitBadAccount iInitBadAccount = InitBadAccountFactory.getRemoteInstance();
                for (i = selectBlock.getTop(); i <= selectBlock.getEndRow(); ++i) {
                    row = this.tblMain.getRow(i);
                    ID = row.getCell("id").getValue().toString();
                    pk = new ObjectUuidPK(ID);
                    initBadAccountInfo = iInitBadAccount.getInitBadAccountInfo((IObjectPK)pk);
                    if (initBadAccountInfo.getTakeBackAmounts().compareTo(new BigDecimal("0.0")) <= 0) continue;
                    MsgBox.showInfo((String)this.getStrResource("not_delete_init_bad_account"));
                    SysUtil.abort();
                }
                for (i = selectBlock.getEndRow(); i >= selectBlock.getTop(); --i) {
                    row = this.tblMain.getRow(i);
                    ID = row.getCell("id").getValue().toString();
                    pk = new ObjectUuidPK(ID);
                    initBadAccountInfo = iInitBadAccount.getInitBadAccountInfo((IObjectPK)pk);
                    InitBadAccountInfo info = iInitBadAccount.getInitBadAccountInfo((IObjectPK)pk);
                    IObjectPK logObjectPK = this.beginLog((IObjectPK)pk, (CoreBillBaseInfo)info, "delete_log", "fi_ar_badacct_delete");
                    BaseDataUtil.rolbackNumber((CoreBillBaseInfo)initBadAccountInfo);
                    iInitBadAccount.delete((IObjectPK)pk);
                    this.tblMain.removeRow(i);
                    this.afterLog(logObjectPK);
                }
            }
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.common.EASCommonResource", (String)"deleteSuccessed"));
            this.showMessage();
        }
    }

    private IObjectPK beginLog(IObjectPK pk, CoreBillBaseInfo coreBillBaseInfo, String method, String methodDes) throws BOSException, EASBizException {
        String methodName = this.getStrResource(method);
        String instanceDeatil = coreBillBaseInfo.getNumber();
        return LogUtil.beginLog(null, (String)methodName, (BOSObjectType)coreBillBaseInfo.getBOSType(), (IObjectPK)pk, (String)instanceDeatil, (String)methodDes);
    }

    private void afterLog(IObjectPK pk) {
        LogUtil.afterLog(null, (IObjectPK)pk);
    }
}

