/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ar.BadAcctInfo;
import com.kingdee.eas.fi.ar.BadAcctTakeBackFactory;
import com.kingdee.eas.fi.ar.BadAcctTakeBackInfo;
import com.kingdee.eas.fi.ar.client.AbstractReceiveForBadListUI;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public class ReceiveForBadListUI
extends AbstractReceiveForBadListUI {
    private static final String TB_COMPANY = "company";
    private static final String TB_CUSSENTTYPE = "cussentType";
    private static final String TB_ACCTCUSSENT = "acctCussent";
    private static final String TB_CURRENCY = "currency";
    private static final String TB_BILLTYPE = "billType";
    private static final String TB_NUMBER = "number";
    private static final String TB_BADACCTAMOUNTS = "badAcctAmounts";
    private static final String TB_RECEIVEAMOUNTS = "receiveAmounts";
    private static final String TB_THISRECEIVEAMT = "thisReceiveAmt";
    private static final String TB_CHECKBOX = "checkbox";
    private static final String TB_RECEIVEBILLID = "id";
    private static final String TB_COMPANYNAME = "company.name";
    private static final String TB_COMPANYNUM = "company.number";
    private static final String TB_CURRENCYID = "currency.id";
    private static final String TB_CURRENCYNAME = "currency.name";
    private static final String TB_ENTRYSID = "entrys.id";
    private static final String TB_ENTRYSEQ = "entrys.seq";
    private static final String TB_BILLDATE = "entrys.bizDate";
    private static final String TB_PAYERID = "payerID";
    private static final String TB_RECEIVEAMT = "entrys.amount";
    private static final String TB_REMAINAMT = "remainAmt";
    private static final String TB_VERIFYAMT = "entrys.verificateAmt";
    private static final String TB_RECEIVESETTLEAMT = "receiveSettleAmt";
    private String PRECISION = null;
    private static final String DATE_FORMAT = CtrlFormatUtilities.getDateFormatString();
    private CompanyOrgUnitInfo currentCompany = null;
    private CurrencyInfo badAcctCurrInfo = null;
    BadAcctTakeBackInfo savedBadAcctTakeBackInfo = null;

    public ReceiveForBadListUI() throws Exception {
        try {
            this.currentCompany = BaseDataUtil.getCompanyInfo();
        }
        catch (Exception ex) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("ar_bill_currentCompanyIsNull"));
        }
        if (this.currentCompany == null || this.currentCompany.isIsOnlyUnion()) {
            SysUtil.abort();
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void setUITitle(String title) {
        super.setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"73_ReceiveForBadListUI"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnGenVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_scvoucher"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSave.setEnabled(true);
        this.btnGenVoucher.setEnabled(false);
        this.PRECISION = PrecisionFormatUtils.getFormatString(ArClientUtils.getIntegrateLocalCurrency());
        if (this.tblBadAcct.getRowCount() < 1) {
            this.tblBadAcct.checkParsed();
            this.tblBadAcct.addRow();
        }
        BadAcctInfo badAcctInfo = (BadAcctInfo)this.getUIContext().get("InitDataObject");
        this.badAcctCurrInfo = badAcctInfo.getCurrency();
        this.mainQuery = (EntityViewInfo)this.getUIContext().get("mainQuery");
        KDCheckBox checkBox = new KDCheckBox();
        KDTDefaultCellEditor check_CellEditor = new KDTDefaultCellEditor((JCheckBox)checkBox);
        this.tblMain.getColumn(TB_CHECKBOX).setEditor((ICellEditor)check_CellEditor);
        this.tblMain.getColumn(TB_CHECKBOX).getStyleAttributes().setLocked(false);
        if (badAcctInfo.getCompany() != null) {
            this.tblBadAcct.getRow(0).getCell(TB_COMPANY).setValue((Object)badAcctInfo.getCompany().getName());
        }
        this.tblBadAcct.getColumn(TB_COMPANY).getStyleAttributes().setLocked(true);
        if (badAcctInfo.getCussentType() != null) {
            this.tblBadAcct.getRow(0).getCell(TB_CUSSENTTYPE).setValue((Object)badAcctInfo.getCussentType().getName());
        }
        this.tblBadAcct.getColumn(TB_CUSSENTTYPE).getStyleAttributes().setLocked(true);
        this.tblBadAcct.getRow(0).getCell(TB_ACCTCUSSENT).setValue((Object)badAcctInfo.getAcctCussentName());
        this.tblBadAcct.getColumn(TB_ACCTCUSSENT).getStyleAttributes().setLocked(true);
        if (badAcctInfo.getCurrency() != null) {
            this.tblBadAcct.getRow(0).getCell(TB_CURRENCY).setValue((Object)badAcctInfo.getCurrency().getName());
        }
        this.tblBadAcct.getColumn(TB_CURRENCY).getStyleAttributes().setLocked(true);
        this.tblBadAcct.getRow(0).getCell(TB_BILLTYPE).setValue((Object)badAcctInfo.getBillType());
        this.tblBadAcct.getColumn(TB_BILLTYPE).getStyleAttributes().setLocked(true);
        this.tblBadAcct.getRow(0).getCell(TB_NUMBER).setValue((Object)badAcctInfo.getNumber());
        this.tblBadAcct.getColumn(TB_NUMBER).getStyleAttributes().setLocked(true);
        this.tblBadAcct.getRow(0).getCell(TB_BADACCTAMOUNTS).setValue((Object)badAcctInfo.getBadAmounts());
        this.tblBadAcct.getColumn(TB_BADACCTAMOUNTS).getStyleAttributes().setLocked(true);
        this.tblBadAcct.getRow(0).getCell(TB_RECEIVEAMOUNTS).setValue((Object)badAcctInfo.getTakeBackAmounts());
        this.tblBadAcct.getColumn(TB_RECEIVEAMOUNTS).getStyleAttributes().setLocked(true);
        this.tblBadAcct.getColumn(TB_THISRECEIVEAMT).getStyleAttributes().setLocked(true);
        this.tblBadAcct.getColumn(TB_BADACCTAMOUNTS).getStyleAttributes().setNumberFormat(this.PRECISION);
        this.tblBadAcct.getColumn(TB_BADACCTAMOUNTS).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblBadAcct.getColumn(TB_RECEIVEAMOUNTS).getStyleAttributes().setNumberFormat(this.PRECISION);
        this.tblBadAcct.getColumn(TB_RECEIVEAMOUNTS).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblBadAcct.getColumn(TB_THISRECEIVEAMT).getStyleAttributes().setNumberFormat(this.PRECISION);
        this.tblBadAcct.getColumn(TB_THISRECEIVEAMT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_CHECKBOX).setWidth(50);
        this.tblMain.getColumn(TB_CURRENCYNAME).setWidth(50);
        this.tblMain.getColumn(TB_ENTRYSEQ).setWidth(70);
        this.tblMain.getColumn(TB_RECEIVEAMT).getStyleAttributes().setNumberFormat(this.PRECISION);
        this.tblMain.getColumn(TB_RECEIVEAMT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_VERIFYAMT).getStyleAttributes().setNumberFormat(this.PRECISION);
        this.tblMain.getColumn(TB_VERIFYAMT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_REMAINAMT).getStyleAttributes().setNumberFormat(this.PRECISION);
        this.tblMain.getColumn(TB_REMAINAMT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_RECEIVESETTLEAMT).getStyleAttributes().setNumberFormat(this.PRECISION);
        this.tblMain.getColumn(TB_RECEIVESETTLEAMT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_RECEIVESETTLEAMT).getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(TB_BILLDATE).getStyleAttributes().setNumberFormat(DATE_FORMAT);
        KDFormattedTextField floatDrawing = new KDFormattedTextField((Object)new BigDecimal(String.valueOf("0.0000")));
        KDTDefaultCellEditor floatDrawingCellEditor = new KDTDefaultCellEditor((JTextField)floatDrawing);
        this.tblMain.getColumn(TB_RECEIVESETTLEAMT).setEditor((ICellEditor)floatDrawingCellEditor);
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    ReceiveForBadListUI.this.tblMain_Changed(e.getRowIndex(), e.getColIndex());
                }
                catch (Exception exc) {
                    ReceiveForBadListUI.this.handUIException(exc);
                }
            }
        });
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                ReceiveForBadListUI.this.tblMain_afterDataFill(e);
            }
        });
    }

    public void tblMain_Changed(int rowIndex, int colIndex) throws Exception {
        this.verifyInput();
        if (this.tblMain.getColumn(TB_RECEIVESETTLEAMT).getColumnIndex() == colIndex) {
            BigDecimal receiveSettleAmounts = null;
            BigDecimal thisTakeBackAmounts = new BigDecimal("0.00");
            BigDecimal exchangeAmt = null;
            ICurrency icurrency = CurrencyFactory.getRemoteInstance();
            ObjectUuidPK currpk = null;
            CurrencyInfo currInfo = null;
            String currId = null;
            Object currObj = null;
            int rowCount = this.tblMain.getRowCount();
            Object row = null;
            IRow badAcctRow = null;
            int n = rowCount;
            for (int i = 0; i < n; ++i) {
                if (!"true".equalsIgnoreCase(this.tblMain.getCell(i, TB_CHECKBOX).getValue().toString()) || this.tblMain.getCell(i, TB_RECEIVESETTLEAMT).getValue() == null) continue;
                currObj = this.tblMain.getCell(i, TB_CURRENCYID).getValue();
                if (currObj != null) {
                    currId = currObj.toString();
                    currpk = new ObjectUuidPK(currId);
                    currInfo = (CurrencyInfo)icurrency.getValue((IObjectPK)currpk);
                }
                receiveSettleAmounts = UIRuleUtil.getBigDecimal((String)this.tblMain.getCell(i, TB_RECEIVESETTLEAMT).getValue().toString());
                exchangeAmt = this.getExchangeAmt(currInfo, this.badAcctCurrInfo, receiveSettleAmounts);
                thisTakeBackAmounts = thisTakeBackAmounts.add(exchangeAmt);
            }
            if (this.tblBadAcct.getRowCount() > 0) {
                badAcctRow = this.tblBadAcct.getRow(0);
                badAcctRow.getCell(TB_THISRECEIVEAMT).setValue((Object)thisTakeBackAmounts);
                BigDecimal tmpAmt = UIRuleUtil.getBigDecimal((String)badAcctRow.getCell(TB_BADACCTAMOUNTS).getValue().toString()).subtract(UIRuleUtil.getBigDecimal((String)badAcctRow.getCell(TB_RECEIVEAMOUNTS).getValue().toString()));
                if (tmpAmt.compareTo(thisTakeBackAmounts) == -1) {
                    MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("this_bigger_total"));
                    SysUtil.abort();
                }
            }
        }
    }

    @Override
    public void tblMain_editValueChanged(KDTEditEvent e) throws Exception {
        super.tblMain_editValueChanged(e);
        this.verifyInput();
        if (this.tblMain.getColumn(TB_CHECKBOX).getColumnIndex() == e.getColIndex()) {
            BigDecimal thisTakeBackAmounts = new BigDecimal("0.00");
            BigDecimal thisReceiveAmt = new BigDecimal("0.00");
            ICurrency icurrency = CurrencyFactory.getRemoteInstance();
            ObjectUuidPK currpk = null;
            CurrencyInfo currInfo = null;
            String currId = null;
            Object currObj = null;
            IRow row = this.tblMain.getRow(e.getRowIndex());
            IRow badAcctRow = null;
            if (row.getCell(TB_RECEIVESETTLEAMT).getValue() != null) {
                currObj = row.getCell(TB_CURRENCYID).getValue();
                if (currObj != null) {
                    currId = currObj.toString();
                    currpk = new ObjectUuidPK(currId);
                    currInfo = (CurrencyInfo)icurrency.getValue((IObjectPK)currpk);
                }
                BigDecimal receiveSettleAmounts = (BigDecimal)row.getCell(TB_RECEIVESETTLEAMT).getValue();
                BigDecimal exchangeAmt = this.getExchangeAmt(currInfo, this.badAcctCurrInfo, receiveSettleAmounts);
                thisTakeBackAmounts = thisTakeBackAmounts.add(exchangeAmt);
            }
            if ((badAcctRow = this.tblBadAcct.getRow(0)).getCell(TB_THISRECEIVEAMT).getValue() != null) {
                thisReceiveAmt = (BigDecimal)badAcctRow.getCell(TB_THISRECEIVEAMT).getValue();
            }
            if ("true".equalsIgnoreCase(e.getValue().toString())) {
                thisTakeBackAmounts = thisTakeBackAmounts.add(thisReceiveAmt);
            } else if ((thisTakeBackAmounts = thisReceiveAmt.subtract(thisTakeBackAmounts)).compareTo(new BigDecimal("0.0")) < 0) {
                thisTakeBackAmounts = new BigDecimal("0.0");
            }
            if (this.tblBadAcct.getRowCount() > 0) {
                badAcctRow.getCell(TB_THISRECEIVEAMT).setValue((Object)thisTakeBackAmounts);
                BigDecimal tmpAmt = UIRuleUtil.getBigDecimal((String)badAcctRow.getCell(TB_BADACCTAMOUNTS).getValue().toString()).subtract(UIRuleUtil.getBigDecimal((String)badAcctRow.getCell(TB_RECEIVEAMOUNTS).getValue().toString()));
                if (tmpAmt.compareTo(thisTakeBackAmounts) == -1) {
                    MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("this_bigger_total"));
                    SysUtil.abort();
                }
            }
        }
    }

    public void tblMain_afterDataFill(KDTDataRequestEvent e) {
        BigDecimal remainAmt = null;
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            remainAmt = UIRuleUtil.getBigDecimal((Object)row.getCell(TB_RECEIVEAMT).getValue()).subtract(UIRuleUtil.getBigDecimal((Object)row.getCell(TB_VERIFYAMT).getValue()));
            row.getCell(TB_REMAINAMT).setValue((Object)remainAmt);
            if (row.getCell(TB_CHECKBOX).getValue() != null) continue;
            row.getCell(TB_CHECKBOX).setValue((Object)new Boolean(false));
        }
    }

    private BigDecimal getExchangeAmt(CurrencyInfo sourceCur, CurrencyInfo destCur, BigDecimal amount) throws Exception {
        ObjectUuidPK destCurrpk;
        if (sourceCur == null || destCur == null || amount == null) {
            return new BigDecimal("0.00");
        }
        BigDecimal amt = new BigDecimal("0.00");
        IExchangeRate iexchangRate = ExchangeRateFactory.getRemoteInstance();
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(sourceCur.getId());
        if (sourceCurrpk.equals((Object)(destCurrpk = new ObjectUuidPK(sourceCur.getId())))) {
            return amount;
        }
        ObjectUuidPK excTablepk = new ObjectUuidPK(this.currentCompany.getBaseExchangeTable().getId());
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, Calendar.getInstance().getTime());
        if (erInfo != null) {
            amt = amount.multiply(erInfo.getConvertRate());
        }
        return amt;
    }

    private void verifyInputBeforeSave() {
        BigDecimal thisTakeBackAmt;
        IRow row = null;
        BigDecimal remainReceiveAmt = null;
        row = this.tblBadAcct.getRow(0);
        BigDecimal badAcctAmounts = (BigDecimal)row.getCell(TB_BADACCTAMOUNTS).getValue();
        BigDecimal receiveAmounts = (BigDecimal)row.getCell(TB_RECEIVEAMOUNTS).getValue();
        BigDecimal thisReceiveAmt = (BigDecimal)row.getCell(TB_THISRECEIVEAMT).getValue();
        if (receiveAmounts != null && thisReceiveAmt != null) {
            receiveAmounts = receiveAmounts.add(thisReceiveAmt);
        }
        if (badAcctAmounts != null && receiveAmounts != null) {
            remainReceiveAmt = badAcctAmounts.subtract(receiveAmounts);
        }
        if (remainReceiveAmt != null && remainReceiveAmt.doubleValue() < 0.0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("this_bigger_total"));
            SysUtil.abort();
        }
        if (this.tblBadAcct.getRowCount() > 0 && ((thisTakeBackAmt = UIRuleUtil.getBigDecimal((String)this.tblBadAcct.getRow(0).getCell(TB_THISRECEIVEAMT).getValue().toString())).compareTo(new BigDecimal("0.0")) == 0 || thisTakeBackAmt.compareTo(new BigDecimal("0.0")) == -1)) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("this_bigger_zero"));
            SysUtil.abort();
        }
    }

    @Override
    public void actoinSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkboxSelected();
        this.verifyInput();
        this.verifyInputBeforeSave();
        this.savedBadAcctTakeBackInfo = this.getSelectedInfo();
        IObjectPK pk = null;
        if (this.savedBadAcctTakeBackInfo.getId() == null) {
            pk = this.getBizInterface().addnew((CoreBaseInfo)this.savedBadAcctTakeBackInfo);
            this.savedBadAcctTakeBackInfo.setId(BOSUuid.read((String)pk.toString()));
        }
        this.btnSave.setEnabled(false);
        this.btnGenVoucher.setEnabled(true);
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"74_ReceiveForBadListUI"));
        this.showMessage();
    }

    @Override
    public void actionGenVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkboxSelected();
        this.verifyInput();
        Object tmpCollection = null;
        UIContext ctx = new UIContext((Object)this);
        if (tmpCollection != null) {
            VoucherInfo vch = (VoucherInfo)tmpCollection.getObject(0);
            ctx.put((Object)"ID", (Object)vch.getId());
            ctx.put((Object)"EDITRULE", (Object)"com.kingdee.eas.fi.gl.client.DefaultVoucherEditRule");
        }
        this.btnSave.setEnabled(false);
        this.btnGenVoucher.setEnabled(false);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(VoucherInfo.getEditUIName(), (Map)ctx, null, OprtState.EDIT);
        uiWindow.show();
    }

    protected ArrayList getSelectedIdValues() {
        ArrayList<String> list = new ArrayList<String>();
        KDTSelectBlock selectBlock = null;
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            return list;
        }
        if (size == 1 && this.tblMain.getSelectManager().get().getTop() == this.tblMain.getSelectManager().get().getBottom()) {
            int rowNum = this.tblMain.getSelectManager().get().getTop();
            ICell cell = this.tblMain.getRow(rowNum).getCell(this.getKeyFieldName());
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if (cell.getValue() != null) {
                list.add(cell.getValue().toString());
            } else {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"75_ReceiveForBadListUI"));
                SysUtil.abort();
            }
        } else {
            for (int i = 0; i < size; ++i) {
                selectBlock = this.tblMain.getSelectManager().get(i);
                for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                    String id;
                    ICell cell = this.tblMain.getRow(j).getCell(this.getKeyFieldName());
                    if (cell == null) {
                        MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                        SysUtil.abort();
                    }
                    if (list.contains(id = cell.getValue().toString())) continue;
                    list.add(id);
                }
            }
        }
        return list;
    }

    private BadAcctTakeBackInfo getSelectedInfo() {
        BadAcctTakeBackInfo info = new BadAcctTakeBackInfo();
        BadAcctInfo badAcctInfo = (BadAcctInfo)this.getUIContext().get("InitDataObject");
        info.setCompany(badAcctInfo.getCompany());
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        info.setCU(cu);
        return info;
    }

    protected void verifyInput() {
        IRow row = null;
        int rowCount = this.tblMain.getRowCount();
        if (rowCount == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("row_zero"));
            SysUtil.abort();
        }
        BigDecimal remainAmt = new BigDecimal("0.00");
        Object remainAmtObj = null;
        BigDecimal receiveSettleAmt = null;
        Object receiveSettleAmtObj = null;
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblMain.getRow(i);
            remainAmtObj = row.getCell(TB_REMAINAMT).getValue();
            if (remainAmtObj != null) {
                remainAmt = UIRuleUtil.getBigDecimal((Object)remainAmtObj);
            }
            if ((receiveSettleAmtObj = row.getCell(TB_RECEIVESETTLEAMT).getValue()) == null) continue;
            receiveSettleAmt = UIRuleUtil.getBigDecimal((Object)receiveSettleAmtObj);
            if (receiveSettleAmt.compareTo(remainAmt) == 1) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("settleTooBig"));
                SysUtil.abort();
            }
            if (receiveSettleAmt.compareTo(new BigDecimal("0.0")) != -1) continue;
            MsgBox.showInfo((Component)((Object)this), (String)this.getStrResource("settleAmt_less_zero"));
            SysUtil.abort();
        }
    }

    public void checkboxSelected() {
        int selCount = 0;
        int rowCount = this.tblMain.getRowCount();
        if (rowCount == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"76_ReceiveForBadListUI"));
            SysUtil.abort();
        }
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            String checkValue = UIRuleUtil.getString((Object)row.getCell(TB_CHECKBOX).getValue());
            if (!"true".equals(checkValue)) continue;
            ++selCount;
        }
        if (selCount == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"77_ReceiveForBadListUI"));
            SysUtil.abort();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private String getStrResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)resKey);
    }

    protected String getEditUIName() {
        return null;
    }

    public void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    @Override
    public void tblMain_editStopped(KDTEditEvent e) throws Exception {
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BadAcctTakeBackFactory.getRemoteInstance();
    }
}

