/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ar.client.BadAcctBackListUI;
import com.kingdee.eas.fi.ar.client.BadAcctReferListUI;
import com.kingdee.eas.fi.ar.client.OtherBillEditUI;
import com.kingdee.eas.fi.ar.client.VerificationBillListUI;
import com.kingdee.eas.fi.arap.ArApConstants;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.cas.client.PaymentBillUI;
import com.kingdee.eas.fi.cas.client.ReceivingBillUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReportLinkHelper {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.client.ReportLinkHelper");

    private ReportLinkHelper() {
    }

    private static String getBillUIName(String billId) {
        BOSUuid billUuid = BOSUuid.read((String)billId);
        String uiCls = null;
        BOSObjectType type = billUuid.getType();
        if (type.equals((Object)ArApConstants.AR_OBILL_TYPE)) {
            uiCls = OtherBillEditUI.class.getName();
        } else if (type.equals((Object)ArApConstants.AP_OBILL_TYPE)) {
            uiCls = com.kingdee.eas.fi.ap.client.OtherBillEditUI.class.getName();
        } else if (type.equals((Object)ArApConstants.REC_TYPE)) {
            uiCls = ReceivingBillUI.class.getName();
        } else if (type.equals((Object)ArApConstants.PAY_TYPE)) {
            uiCls = PaymentBillUI.class.getName();
        } else if (type.equals((Object)ArApConstants.BADACCT_TYPE)) {
            uiCls = BadAcctReferListUI.class.getName();
        } else if (type.equals((Object)ArApConstants.BADACCT_BACK_TYPE)) {
            uiCls = BadAcctBackListUI.class.getName();
        } else if (type.equals((Object)ArApConstants.ARVEC_TYPE)) {
            uiCls = VerificationBillListUI.class.getName();
        } else if (type.equals((Object)ArApConstants.APVEC_TYPE)) {
            uiCls = com.kingdee.eas.fi.ap.client.VerificationBillListUI.class.getName();
        }
        logger.info((Object)(" bill UI: " + uiCls));
        return uiCls;
    }

    public static void showBillUI(IUIObject ui, String billId) throws Exception {
        String uiCls = ReportLinkHelper.getBillUIName(billId);
        if (uiCls == null || uiCls.length() == 0) {
            return;
        }
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"ID", (Object)billId);
        RealModeIDList idList = new RealModeIDList();
        idList.add(1, billId);
        uiContext.put((Object)"IDList", (Object)idList);
        if (uiCls.equals(VerificationBillListUI.class.getName()) || uiCls.equals(com.kingdee.eas.fi.ap.client.VerificationBillListUI.class.getName())) {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(billId);
            uiContext.put((Object)"BillID", ids);
        }
        if (uiCls.equals(BadAcctBackListUI.class.getName()) || uiCls.equals(BadAcctReferListUI.class.getName())) {
            HashMap<String, String> hm = new HashMap<String, String>();
            hm.put("System", "com.kingdee.eas.fi.ar");
            hm.put("Module", "report");
            hm.put("ID", billId);
            uiContext.put((Object)"RelationQueryParameter", hm);
        }
        IUIWindow billUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(uiCls, (Map)uiContext, null, OprtState.VIEW);
        billUI.show();
    }

    public static void showVerificationUI(IUIObject ui, String uiName, String billId, String system) throws BOSException, EASBizException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"EntryBillID", (Object)billId);
        uiContext.put((Object)"system", (Object)system);
        uiContext.put((Object)"isFromVerification", (Object)Boolean.TRUE);
        IUIWindow billUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(uiName, (Map)uiContext, null, OprtState.VIEW);
        billUI.show();
    }

    public static void showVerificationUI(IUIObject ui, String uiName, String billId, String system, ArApSysParamInfo cache) throws BOSException, EASBizException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"EntryBillID", (Object)billId);
        uiContext.put((Object)"system", (Object)system);
        uiContext.put((Object)"cache", (Object)cache);
        uiContext.put((Object)"isFromVerification", (Object)Boolean.TRUE);
        IUIWindow billUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(uiName, (Map)uiContext, null, OprtState.VIEW);
        billUI.show();
    }
}

