/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.fi.ar.IReportData;
import com.kingdee.eas.fi.ar.IReportHead;
import com.kingdee.eas.fi.ar.IReportHeadCell;
import com.kingdee.eas.util.client.EASResource;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class ReportLoader {
    private static final Logger logger = Logger.getLogger(ReportLoader.class);
    private KDTable tbl = null;

    public ReportLoader(KDTable tblMain) {
        this.tbl = tblMain;
    }

    public void setReportHead(IReportHead tblHead) {
        int i;
        if (tblHead == null || tblHead.getCellSize() == 0) {
            logger.error((Object)" the head info is invalid.");
            return;
        }
        this.tbl.removeColumns();
        int n = tblHead.getRows();
        for (int i2 = 0; i2 < n; ++i2) {
            this.tbl.addHeadRow();
        }
        IReportHeadCell headCell = null;
        IRow row = null;
        IColumn col = null;
        int n2 = tblHead.getCellSize();
        for (i = 0; i < n2; ++i) {
            headCell = tblHead.getCell(i);
            row = this.tbl.getHeadRow(headCell.getRow());
            col = this.tbl.getColumn(headCell.getCol());
            if (col == null) {
                col = this.tbl.addColumn(headCell.getCol());
            }
            col.setKey(headCell.getKey());
            col.setWidth(headCell.getWidth());
            col.getStyleAttributes().setNumberFormat(headCell.getDisplayFormat());
            col.getStyleAttributes().setHorizontalAlign(headCell.getHAlign());
            String title = this.getColTitle(headCell.getKey());
            title = title == null ? headCell.getKey() : title;
            row.getCell(headCell.getCol()).setValue((Object)title);
        }
        n2 = tblHead.getCellSize();
        for (i = 0; i < n2; ++i) {
            headCell = tblHead.getCell(i);
            this.mergeBlock(headCell);
        }
    }

    protected void mergeBlock(IReportHeadCell headCell) {
        if (headCell.getSpan() <= 0) {
            return;
        }
        boolean fMerged = false;
        fMerged = headCell.getSpan() == 1 ? this.tbl.getHeadMergeManager().mergeBlock(headCell.getRow(), headCell.getCol(), 1, headCell.getCol()) : this.tbl.getHeadMergeManager().mergeBlock(headCell.getRow(), headCell.getCol(), headCell.getRow(), headCell.getCol() + headCell.getSpan() - 1);
        logger.info((Object)(headCell.getKey() + " merged: " + fMerged));
    }

    protected String getColTitle(String key) {
        String res = "com.kingdee.eas.fi.ar.client.ArResource";
        if (key.indexOf("_") != -1) {
            String title = "";
            String resLbl = "Lbl_" + key.substring(0, key.indexOf("_"));
            Object[] args = key.substring(key.indexOf("_") + 1).split("t");
            if (args[0].length() == 0) {
                resLbl = resLbl + "_M";
                Object[] arg = new String[]{args[1]};
                title = EASResource.getString((String)res, (String)resLbl);
                title = MessageFormat.format(title, arg);
            } else {
                title = EASResource.getString((String)res, (String)resLbl);
                title = MessageFormat.format(title, args);
            }
            return title;
        }
        return EASResource.getString((String)res, (String)("Lbl_" + key));
    }

    public void loadData(IReportData data) {
        if (data == null || data.size() == 0) {
            return;
        }
        this.tbl.setRefresh(true);
        IRow row = null;
        int size = data.size();
        for (int i = 0; i < size; ++i) {
            row = this.tbl.addRow();
            IObjectValue rowInfo = data.getReportRowInfo(i);
            this.loadRow(row, rowInfo);
        }
        this.tbl.setRefresh(true);
        this.tbl.repaint();
    }

    protected void loadRow(IRow row, IObjectValue rowInfo) {
        if (rowInfo == null) {
            return;
        }
        int n = this.tbl.getColumnCount();
        for (int j = 0; j < n; ++j) {
            String key = this.tbl.getColumn(j).getKey();
            if (rowInfo.get(key) == null) continue;
            row.getCell(j).setValue(rowInfo.get(key));
        }
    }
}

