/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.appframework.syncUI.ThreadPool;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.uiframe.client.ui.IMainUIObject;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroupStandard;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ArApQueryParam;
import com.kingdee.eas.fi.ar.IReportFacade;
import com.kingdee.eas.fi.ar.ReportFacadeFactory;
import com.kingdee.eas.fi.ar.client.AbstractReportTreeUI;
import com.kingdee.eas.fi.ar.client.ReportUI;
import com.kingdee.eas.fi.arap.client.util.ArApReportUIUtil;
import com.kingdee.eas.fi.arap.util.Helper;
import com.kingdee.eas.fi.gl.common.print.IRequestTableData;
import com.kingdee.eas.fi.gl.common.print.MultiPrint;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.report.client.ProgressBarDialogAdapter;
import com.kingdee.eas.framework.report.client.ProgressBarRptDialog;
import com.kingdee.eas.framework.report.util.WindowMessage;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ReportTreeUI
extends AbstractReportTreeUI
implements IRequestTableData {
    private static final Logger logger = CoreUIObject.getLogger(ReportTreeUI.class);
    protected transient TreeSelectionListener treeSelectionListener = new TreeSelectionListener(){

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            try {
                ReportTreeUI.this.treeMain_valueChanged(e);
            }
            catch (Exception exc) {
                ReportTreeUI.this.handUIException(exc);
            }
        }
    };
    protected transient TreeExpansionListener treeExpansionListener = new TreeExpansionListener(){

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            try {
                KDTreeNode node = (KDTreeNode)event.getPath().getLastPathComponent();
                if (node.isRoot()) {
                    return;
                }
                ReportTreeUI.this.nodeTop.remove((MutableTreeNode)node);
                ReportTreeUI.this.filterParam.setTreeFetchRowCount(ReportTreeUI.this.nodeTop.getChildCount() + ReportTreeUI.this.filterParam.getTreeFetchSize());
                ReportTreeUI.this.filterParam.setDoExpand(true);
                ReportTreeUI.this.row2TreeNode(ReportTreeUI.this.getTreeRowSet());
                ReportTreeUI.this.filterParam.setDoExpand(false);
            }
            catch (Exception exc) {
                ReportTreeUI.this.handUIException(exc);
            }
        }
    };
    private transient TreePath oldPath = null;
    private transient int oldNodeRow = 0;
    private boolean tblPrintRequesting = false;
    private KDTreeNode nodeTop = null;
    private boolean isLoading = false;
    private static ProgressBarRptDialog progressDialog = ProgressBarRptDialog.getDialogInstance(null);

    public ReportTreeUI() throws Exception {
        this.treeMain.setVisible(false);
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnContinuousPrint.setIcon(EASResource.getIcon((String)"imgTbtn_printcontinue"));
        this.menuItemContinuousPrint.setIcon(EASResource.getIcon((String)"imgTbtn_printcontinue"));
        this.btnContinuousPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_printpreview"));
        this.menuItemContinuousPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_printpreview"));
    }

    public KDTreeNode getSelectedTreeNode() {
        return (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        KDTreeNode selectedNode;
        if (this.filterParam == null) {
            SysUtil.abort();
        }
        if ((selectedNode = this.getSelectedTreeNode()) == null || selectedNode.isRoot() && !this.isShowAllNodesData()) {
            if (this.tblMain.getRowCount() > 0) {
                this.filterParam.setTotalRowCount(0);
                this.tblMain.removeRows();
            }
            return;
        }
        if (EASResource.getString((String)this.getResource(), (String)"INFO_MORE").equals(String.valueOf(selectedNode.getUserObject()))) {
            return;
        }
        this.setTreeNodeParam(selectedNode);
        if (!this.isGetAllNodesRptFirstTime()) {
            this.filterParam.setTempTable(null);
        }
        this.filterParam.setTotalRowCount(0);
        this.tblMain.removeRows();
    }

    protected void setTreeNodeParam(KDTreeNode selectedNode) {
        if (!selectedNode.isRoot()) {
            AsstActTypeInfo cussAcctInfo = (AsstActTypeInfo)selectedNode.getUserObject();
            String cussAcctId = cussAcctInfo.getString("id");
            this.filterParam.setCussAcctId(cussAcctId);
        } else if (this.isShowAllNodesData()) {
            this.filterParam.setCussAcctId(null);
        }
    }

    protected boolean isGetAllNodesRptFirstTime() {
        return false;
    }

    protected void buildTree() throws Exception {
        logger.debug((Object)("treeRpt cussAcctTbl " + this.filterParam.getCussAcctTempTable()));
        this.nodeTop = new KDTreeNode((Object)this.getTreeTitle());
        this.row2TreeNode(this.getTreeRowSet());
        if (this.nodeTop.getChildCount() > 0) {
            this.treeMain.setVisible(true);
        }
    }

    protected String getTreeTitle() {
        AsstActTypeInfo cussTypeInfo = this.filterParam.getCussAcctTypeInfo();
        return cussTypeInfo.getName();
    }

    protected IRowSet getTreeRowSet() throws Exception {
        AsstActTypeInfo cussTypeInfo = this.filterParam.getCussAcctTypeInfo();
        if (cussTypeInfo == null || StringUtils.isEmpty((String)cussTypeInfo.getRealtionDataObject()) || StringUtils.isEmpty((String)cussTypeInfo.getDefaultQueryName())) {
            return null;
        }
        String tbl = cussTypeInfo.getRealtionDataObject();
        String qryName = cussTypeInfo.getDefaultQueryName();
        if (tbl.equalsIgnoreCase("t_bd_customer")) {
            qryName = "com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyQuery";
        } else if (tbl.equalsIgnoreCase("T_BD_Supplier")) {
            qryName = "com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQuery";
        }
        MetaDataPK cussQryPK = new MetaDataPK(qryName);
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)cussQryPK);
        exec.setObjectView(this.getTreeView());
        return exec.executeQuery();
    }

    protected void row2TreeNode(IRowSet rowSet) throws SQLException {
        AsstActTypeInfo info;
        boolean isAll = false;
        if (rowSet != null && rowSet.size() > 0) {
            while (rowSet.next()) {
                info = new AsstActTypeInfo();
                if (rowSet.getString("id") == null || !BOSUuid.isValid((String)rowSet.getString("id"), (boolean)true)) continue;
                BOSUuid id = BOSUuid.read((String)rowSet.getString("id"));
                info.setId(id);
                info.setName(rowSet.getString("name"));
                KDTreeNode node = new KDTreeNode((Object)info);
                this.nodeTop.add((MutableTreeNode)node);
            }
            KDTreeNode node = null;
            if (this.nodeTop.getChildCount() == this.filterParam.getTreeFetchRowCount()) {
                node = new KDTreeNode((Object)EASResource.getString((String)this.getResource(), (String)"INFO_MORE"));
                node.setCustomIcon(UIManager.getIcon("Tree.closedIcon"));
                node.add((MutableTreeNode)new DefaultMutableTreeNode());
                this.nodeTop.add((MutableTreeNode)node);
            } else {
                isAll = true;
            }
        } else {
            isAll = true;
        }
        if (isAll && !this.isSumByCussAcct()) {
            info = new AsstActTypeInfo();
            info.setId(null);
            info.setName("");
            KDTreeNode nullNode = new KDTreeNode((Object)info);
            this.nodeTop.add((MutableTreeNode)nullNode);
        }
        this.treeMain.removeTreeSelectionListener(this.treeSelectionListener);
        this.treeMain.removeTreeExpansionListener(this.treeExpansionListener);
        this.treeMain.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.nodeTop));
        this.treeMain.addTreeSelectionListener(this.treeSelectionListener);
        this.treeMain.addTreeExpansionListener(this.treeExpansionListener);
    }

    protected boolean isSumByCussAcct() {
        return true;
    }

    protected EntityViewInfo getTreeView() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = this.getTreeFilter();
        view.setFilter(filter);
        view.getSelector().add("id");
        view.getSelector().add("name");
        view.getSelector().add("number");
        return view;
    }

    protected FilterInfo getTreeFilter() {
        FilterInfo filter = null;
        filter = this.getNumRangeFilterItem();
        AsstActTypeInfo cussTypeInfo = this.filterParam.getCussAcctTypeInfo();
        String tblName = cussTypeInfo.getRealtionDataObject();
        FilterInfo comFilter = this.getCompanyCuDataAssignFilter(tblName);
        if (filter != null && comFilter != null) {
            try {
                filter.mergeFilter(comFilter, "and");
            }
            catch (BOSException e) {
                logger.error((Object)"filter merge exception", (Throwable)e);
            }
        } else if (filter == null && comFilter != null) {
            filter = comFilter;
        }
        if (tblName.equalsIgnoreCase("t_bd_generalasstacttype") && cussTypeInfo.getGlAsstActTypeGrp() != null) {
            filter = filter == null ? new FilterInfo() : filter;
            filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)cussTypeInfo.getGlAsstActTypeGrp().getId()));
        }
        return filter;
    }

    protected final FilterInfo getNumRangeFilterItem() {
        FilterInfo filter = null;
        List ids = this.filterParam.getCussAcctFromIds();
        if (ids != null && ids.size() > 0) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
            return filter;
        }
        String cussFromNum = this.filterParam.getCussAcctFromNum();
        String cussToNum = this.filterParam.getCussAcctToNum();
        if (!StringUtils.isEmpty((String)cussFromNum)) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)cussFromNum, CompareType.GREATER_EQUALS));
        }
        if (!StringUtils.isEmpty((String)cussToNum)) {
            filter = filter == null ? new FilterInfo() : filter;
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)cussToNum, CompareType.LESS_EQUALS));
        }
        return filter;
    }

    private FilterInfo getCompanyCuDataAssignFilter(String tblName) {
        FilterInfo comFilter = null;
        boolean fCustomer = tblName.equalsIgnoreCase("t_bd_customer");
        boolean fSupplier = tblName.equalsIgnoreCase("t_bd_supplier");
        boolean fBank = tblName.equalsIgnoreCase("T_BD_AccountBanks");
        boolean fCusSup = fCustomer || fSupplier;
        String companyId = this.filterParam.getCompanyId();
        String cuId = this.filterParam.getCuId();
        tblName = tblName.toLowerCase();
        if (fCusSup || fBank) {
            String fldCompany = "";
            if (fCusSup) {
                fldCompany = "companyOrgUnit.id";
            } else if (fBank) {
                fldCompany = "company.id";
            }
            comFilter = new FilterInfo();
            if (fCusSup) {
                comFilter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)"1"));
            }
            FilterItemInfo item = new FilterItemInfo(fldCompany, (Object)companyId);
            comFilter.getFilterItems().add(item);
            try {
                if (fCusSup) {
                    FilterItemInfo csspGrpStdFilter = null;
                    csspGrpStdFilter = StringUtils.isEmpty((String)this.filterParam.getCsspGrpStdId()) ? this.getCsspGroupBasicStdFilter(fCustomer) : new FilterItemInfo("browseGroup.groupStandard", (Object)this.filterParam.getCsspGrpStdId());
                    if (csspGrpStdFilter != null) {
                        comFilter.getFilterItems().add(csspGrpStdFilter);
                    }
                    if (!StringUtils.isEmpty((String)this.filterParam.getCsspGrpId())) {
                        FilterInfo grpFilter = Helper.getCsspGrpFilter(null, this.filterParam.getCsspGrpId());
                        comFilter.mergeFilter(grpFilter, "and");
                    }
                    FilterInfo dataAssignFilter = this.getDataAssignFilter(tblName, cuId);
                    comFilter.mergeFilter(dataAssignFilter, "and");
                }
            }
            catch (Exception e) {
                logger.error((Object)" error happened while get the data's cu filter ", (Throwable)e);
            }
        }
        return comFilter;
    }

    private FilterItemInfo getCsspGroupBasicStdFilter(boolean fCustomer) {
        FilterItemInfo csspGrpStdFilter = null;
        String cussSupType = fCustomer ? "1" : "2";
        try {
            ICSSPGroupStandard icssStandard = CSSPGroupStandardFactory.getRemoteInstance();
            String standardId = icssStandard.getBasicStandardId(cussSupType);
            String field = fCustomer ? "customerGroupDetails.customerGroupStandard.id" : "supplierGroupDetails.supplierGroupStandard.id";
            csspGrpStdFilter = new FilterItemInfo(field, (Object)standardId);
            return csspGrpStdFilter;
        }
        catch (Exception e) {
            logger.error((Object)"error while getting the css group standard", (Throwable)e);
            return null;
        }
    }

    private FilterInfo getDataAssignFilter(String tblName, String cuId) throws BOSException, EASBizException {
        if (tblName == null) {
            return null;
        }
        FilterInfo filter = null;
        ObjectUuidPK cuPK = new ObjectUuidPK(cuId);
        if ((tblName = tblName.toLowerCase()).indexOf("customer") != -1) {
            ICustomer iCust = CustomerFactory.getRemoteInstance();
            filter = iCust.getDatabaseDFilter((IObjectPK)cuPK, "id", "adminCU.id");
        } else if (tblName.indexOf("supplier") != -1) {
            ISupplier iSupp = SupplierFactory.getRemoteInstance();
            filter = iSupp.getDatabaseDFilter((IObjectPK)cuPK, "id", "adminCU.id");
        } else if (tblName.indexOf("material") != -1) {
            IMaterial iMater = MaterialFactory.getRemoteInstance();
            filter = iMater.getDatabaseDFilter((IObjectPK)cuPK, "id", "adminCU.id");
        }
        return filter;
    }

    protected boolean isShowAllNodesData() {
        return false;
    }

    protected boolean isSupportTreeMultiPrint() {
        return false;
    }

    @Override
    protected void saveCurrentLocation() {
        super.saveCurrentLocation();
        this.oldPath = this.treeMain.getSelectionPath();
        this.oldNodeRow = this.treeMain.getSelectionModel().getMaxSelectionRow();
    }

    @Override
    protected void restoreCurrentLocation() {
        super.restoreCurrentLocation();
        Object objNode = this.treeMain.getModel().getRoot();
        KDTreeNode newRoot = null;
        if (objNode instanceof KDTreeNode) {
            newRoot = (KDTreeNode)objNode;
        }
        if (this.oldPath != null && newRoot != null && this.oldPath.getPathComponent(0) != null && this.oldPath.getPathComponent(0) instanceof KDTreeNode) {
            String oldNodeTxt;
            Object newNode;
            String newNodeTxt;
            boolean fSameRootType;
            KDTreeNode oldRoot = null;
            oldRoot = (KDTreeNode)this.oldPath.getPathComponent(0);
            boolean bl = fSameRootType = oldRoot != null && newRoot != null && oldRoot.getText().equals(newRoot.getText());
            if (fSameRootType && this.treeMain.getPathForRow(this.oldNodeRow) != null && (newNodeTxt = ((KDTreeNode)(newNode = this.treeMain.getPathForRow(this.oldNodeRow).getLastPathComponent())).getText()).equals(oldNodeTxt = ((KDTreeNode)this.oldPath.getLastPathComponent()).getText())) {
                if (this.isShowAllNodesData()) {
                    this.treeMain.setSelectionRow(this.oldNodeRow);
                } else {
                    this.treeMain.setSelectionRow(this.oldNodeRow > 0 ? this.oldNodeRow : 1);
                }
                return;
            }
        }
        if (this.treeMain.getRowCount() > 1) {
            this.treeMain.setSelectionRow(this.isShowAllNodesData() ? 0 : 1);
        } else {
            this.treeMain.setSelectionRow(0);
        }
    }

    @Override
    protected void refresh(ActionEvent e) throws Exception {
        if (this.isAsynchronism() && this.isLoading) {
            return;
        }
        this.isLoading = true;
        this.isFirstLoad = true;
        this.saveCurrentLocation();
        this.releaseTempTable();
        if (this.isAsynchronism()) {
            final MonitorInfo info = new MonitorInfo(this.getUITitle(), null, (Object)this, false);
            progressDialog = ProgressBarRptDialog.getDialogInstance((Object)((Object)this));
            final SwingWorker worker = new SwingWorker(){
                private boolean stop = false;

                public Object construct() {
                    while (ReportTreeUI.this.isLoading) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    return null;
                }

                public void finished() {
                    if (!this.stop) {
                        String title = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"has_finished"), ReportTreeUI.this.getUITitle());
                        new WindowMessage("250", "150", ReportUI.getResourceString("runinbackground"), title, info);
                        ThreadPool.destroyMonitor((MonitorInfo)info);
                        info.setTitle(title);
                        ThreadPool.addActionThread((MonitorInfo)info);
                    }
                }

                public void finishedLater() {
                    ThreadPool.destroyMonitor((MonitorInfo)info);
                    if (ReportTreeUI.this.isLoading) {
                        this.stop = true;
                        IMainUIObject mainUI = ReportTreeUI.this.getMainUIObject();
                        IUIObject[] uiObjects = mainUI.getUiManager().findUIObject(ReportTreeUI.this.getUIFullName());
                        if (uiObjects != null && uiObjects.length > 0) {
                            mainUI.getUiManager().closeTab(uiObjects[0]);
                        }
                        ReportTreeUI.this.close();
                    }
                    if (progressDialog != null && progressDialog.isShowing()) {
                        progressDialog.dispose();
                    }
                    try {
                        ReportTreeUI.this.addTabOnMainUI((IUIObject)info.getUi());
                        ReportTreeUI.this.onShow();
                    }
                    catch (Exception e) {
                        ReportTreeUI.this.handUIException(e);
                    }
                }
            };
            SwingWorker dataWorker = new SwingWorker(){

                public Object construct() {
                    try {
                        ReportTreeUI.this.buildTree();
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                    ReportTreeUI.this.isLoading = false;
                    ReportTreeUI.this.isFirstLoad = false;
                    ReportTreeUI.this.restoreCurrentLocation();
                    return null;
                }

                public void finished() {
                    if (progressDialog != null && progressDialog.isShowing()) {
                        progressDialog.dispose();
                    }
                }
            };
            dataWorker.start();
            SwingWorker processBarWorker = new SwingWorker(){

                public Object construct() {
                    if (progressDialog != null) {
                        progressDialog.setTitle(ReportTreeUI.this.getUITitle());
                        if (ProgressBarDialogAdapter.show((ProgressBarRptDialog)progressDialog)) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e) {
                                ReportTreeUI.this.handleException(e);
                            }
                            ReportTreeUI.this.removeTabOnMainUI((IUIObject)info.getUi());
                            info.setWorker(worker);
                            ThreadPool.addActionThread((MonitorInfo)info);
                        }
                    }
                    return null;
                }
            };
            processBarWorker.start();
        } else {
            this.isLoading = true;
            this.buildTree();
            this.isLoading = false;
            this.restoreCurrentLocation();
        }
    }

    @Override
    protected void prepareParamForQuery(ArApQueryParam filterParam) {
        filterParam.setTreeFetchRowCount(filterParam.getTreeFetchSize());
    }

    @Override
    public void actionContinuousPrint_actionPerformed(ActionEvent e) throws Exception {
        ArApReportUIUtil.checkCompanysPrintPermission(this, this.getQueryCompanys(), this.getPrintPermItem(), this.getMainBizOrgType());
        this.continousPrintTbl(false);
    }

    @Override
    public void actionContinuousPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        ArApReportUIUtil.checkCompanysPrintPermission(this, this.getQueryCompanys(), this.getPrintPermItem(), this.getMainBizOrgType());
        this.continousPrintTbl(true);
    }

    protected void continousPrintTbl(boolean preview) throws Exception {
        if (this.tblMain == null || this.treeMain.getSelectionPath() == null) {
            return;
        }
        String logMsg = ArApReportUIUtil.getPrintLogMsg(this.getUITitle(), preview);
        IReportFacade iRpt = ReportFacadeFactory.getRemoteInstance();
        IObjectPK pkOut = LogUtil.beginLog(null, (String)logMsg, (BOSObjectType)iRpt.getType(), null, (String)logMsg);
        try {
            this.setCursorOfWair();
            if (this.isSupportTreeMultiPrint()) {
                MultiPrint mp = new MultiPrint((Component)((Object)this));
                if (!mp.showPrintOption()) {
                    return;
                }
                this.preparePrintPage(this.tblMain);
                mp.getMultiPrintModel().setTable(this.tblMain);
                this.prepareContinousPrintVarMap(mp);
                if (preview) {
                    mp.preview();
                } else {
                    mp.print();
                }
            } else {
                this.preparePrintPage(this.tblMain);
                if (preview) {
                    this.tblMain.getPrintManager().printPreview();
                } else {
                    this.tblMain.getPrintManager().print();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"exception, tree table multiPrint ", (Throwable)e);
        }
        LogUtil.afterLog(null, (IObjectPK)pkOut);
    }

    protected void prepareContinousPrintVarMap(MultiPrint mp) {
    }

    public void confirmEnd() {
        try {
            while (this.tblPrintRequesting) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)e);
        }
    }

    public void requestTableData(Object thepath) throws Exception {
        this.printRequestTableData(thepath);
    }

    public void requestTableData(Object thepath, boolean b) throws Exception {
        this.printRequestTableData(thepath);
    }

    private void printRequestTableData(Object thepath) {
        if (thepath == null || !(thepath instanceof TreePath)) {
            return;
        }
        TreePath path = (TreePath)thepath;
        this.treeMain.setSelectionPath(path);
    }

    protected TreePath[] getTreePath(boolean fAll) {
        TreePath[] tps = this.treeMain.getSelectionPaths();
        if (tps == null) {
            return null;
        }
        ArrayList<TreePath> list = new ArrayList<TreePath>();
        boolean fRoot = ((DefaultKingdeeTreeNode)tps[0].getLastPathComponent()).isRoot();
        if (fAll || fRoot) {
            Enumeration em = ((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot()).depthFirstEnumeration();
            while (em.hasMoreElements()) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)em.nextElement();
                Object nodeInfo = node.getUserObject();
                if (nodeInfo == null || !(nodeInfo instanceof IObjectValue)) continue;
                list.add(new TreePath(node.getPath()));
            }
        } else if (tps != null) {
            int n = tps.length;
            for (int i = 0; i < n; ++i) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tps[i].getLastPathComponent();
                Object nodeInfo = node.getUserObject();
                if (nodeInfo == null || !(nodeInfo instanceof IObjectValue) || !node.isLeaf()) continue;
                list.add(new TreePath(node.getPath()));
            }
        }
        tps = new TreePath[list.size()];
        list.toArray(tps);
        return tps;
    }
}

