/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.IExpenseType;
import com.kingdee.eas.fi.ap.ApVerificationFacadeFactory;
import com.kingdee.eas.fi.ap.IApVerificationFacade;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ap.VerificationEnum;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.ArVerificationFacadeFactory;
import com.kingdee.eas.fi.ar.IArVerificationFacade;
import com.kingdee.eas.fi.ar.ImportLog;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.OtherBillentryInfo;
import com.kingdee.eas.fi.ar.VerificationBillInfo;
import com.kingdee.eas.fi.ar.VerificationBillentryCollection;
import com.kingdee.eas.fi.ar.VerificationBillentryInfo;
import com.kingdee.eas.fi.arap.VerificationBillBaseEntryInfo;
import com.kingdee.eas.fi.arap.VerificationBillBaseInfo;
import com.kingdee.eas.fi.arap.util.Helper;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.PaymentBillTypeFactory;
import com.kingdee.eas.fi.cas.PaymentBillTypeInfo;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillTypeFactory;
import com.kingdee.eas.fi.cas.ReceivingBillTypeInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.BillEntryBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.AbstractExternalDataReader;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.runtime.ExternalCSVDataReader;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelDataReader;
import com.kingdee.eas.tools.datatask.runtime.ExternalTextDataReader;
import com.kingdee.eas.tools.datatask.runtime.FileFormatNotStandardException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class VerificationImporter {
    private static final Logger logger = Logger.getLogger(VerificationImporter.class);
    private static final String RES = "com.kingdee.eas.fi.ar.client.VerificateResource";
    private File dataFile = null;
    private static final int ARBILL = 1;
    private static final int APBILL = 2;
    private static final int RECBILL = 3;
    private static final int PAYBILL = 4;
    private static final BOSObjectType AR_BOSTYPE = new OtherBillentryInfo().getBOSType();
    private static final BOSObjectType AP_BOSTYPE = new com.kingdee.eas.fi.ap.OtherBillentryInfo().getBOSType();
    private static final BOSObjectType REC_BOSTYPE = new ReceivingBillEntryInfo().getBOSType();
    private static final BOSObjectType PAY_BOSTYPE = new PaymentBillEntryInfo().getBOSType();
    private Map<String, BigDecimal> amtMap = new HashMap<String, BigDecimal>();

    public VerificationImporter(File file) {
        this.dataFile = file;
    }

    private AbstractExternalDataReader getFileReader() throws TaskExternalException {
        ExternalCSVDataReader fileReader = null;
        String path = this.dataFile.getAbsolutePath();
        int lastDotInd = path.lastIndexOf(".");
        if (lastDotInd == -1 || lastDotInd + 1 == path.length()) {
            String msg = EASResource.getString((String)RES, (String)"UnknownFileType");
            logger.error((Object)msg);
            throw new TaskExternalException(msg);
        }
        String postFix = path.substring(lastDotInd + 1);
        if (postFix.equalsIgnoreCase("csv")) {
            fileReader = new ExternalCSVDataReader();
        } else if (postFix.equalsIgnoreCase("txt")) {
            fileReader = new ExternalTextDataReader();
        } else if (postFix.equalsIgnoreCase("xls")) {
            fileReader = new ExternalExcelDataReader();
        }
        if (fileReader == null) {
            String msg = EASResource.getString((String)RES, (String)"UnsupportedFile");
            logger.error((Object)msg);
            throw new TaskExternalException(msg);
        }
        fileReader.setLocacle(SysContext.getSysContext().getLocale());
        return fileReader;
    }

    public ImportLog importData(boolean fAR) throws Exception {
        ImportLog log = new ImportLog();
        log.dataFile = this.dataFile.getAbsolutePath();
        AbstractExternalDataReader fileReader = this.getFileReader();
        try {
            fileReader.openFile(this.dataFile.getAbsolutePath());
        }
        catch (FileFormatNotStandardException ex) {
            log.errList.add(ex.getMessage());
            return log;
        }
        fileReader.calculatorRowCount();
        String cuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        CompanyOrgUnitInfo companyInfo = SysContext.getSysContext().getCurrentFIUnit();
        Object iBiz = null;
        iBiz = fAR ? ArVerificationFacadeFactory.getRemoteInstance() : ApVerificationFacadeFactory.getRemoteInstance();
        CoreBaseInfo preInfo = null;
        Map dataRow = null;
        Object objVal = null;
        BigDecimal veririedAmt = BigDecimal.ZERO;
        BigDecimal veririedAmtLoc = BigDecimal.ZERO;
        String grpNum = null;
        CoreBaseInfo verificationInfo = null;
        ArrayList<String> errGrpNum = new ArrayList<String>();
        ArrayList<Map> dataRowList = new ArrayList<Map>();
        while (fileReader.hasNext()) {
            dataRow = fileReader.getNext();
            if (dataRow == null || dataRow.size() == 0) continue;
            String number = ((DataToken)dataRow.get((Object)"FBillID")).data.toString();
            String seq = ((DataToken)dataRow.get((Object)"FEntryID")).data.toString();
            objVal = ((DataToken)dataRow.get((Object)"FThisVerificateAmt")).data;
            veririedAmt = new BigDecimal(objVal.toString());
            if (this.amtMap.containsKey(number + seq)) {
                veririedAmt = veririedAmt.add(this.amtMap.get(number + seq));
            }
            this.amtMap.put(number + seq, veririedAmt);
            objVal = ((DataToken)dataRow.get((Object)"FThisVerificateAmtLoc")).data;
            veririedAmtLoc = new BigDecimal(objVal.toString());
            if (this.amtMap.containsKey(number + seq + "LOCAL")) {
                veririedAmt = veririedAmt.add(this.amtMap.get(number + seq + "LOCAL"));
            }
            this.amtMap.put(number + seq + "LOCAL", veririedAmt);
            dataRowList.add(dataRow);
        }
        int size = dataRowList.size();
        for (int i = 0; i < size; ++i) {
            dataRow = (Map)dataRowList.get(i);
            if (dataRow == null || dataRow.size() == 0) continue;
            ++log.billCount;
            try {
                boolean isDigit;
                objVal = ((DataToken)dataRow.get((Object)"FNumber")).data;
                grpNum = (String)objVal;
                boolean bl = isDigit = grpNum != null && grpNum.trim().matches("[1-9][0-9]*");
                if (!isDigit) {
                    String msg = EASResource.getString((String)RES, (String)"NumberField_Wrong");
                    msg = MessageFormat.format(msg, "FNumber", grpNum);
                    logger.error((Object)msg);
                    throw new TaskExternalException(msg);
                }
                if (grpNum != null) {
                    grpNum = grpNum.trim();
                }
                if (errGrpNum.contains(grpNum)) continue;
                verificationInfo = this.transfer(dataRow, cuId, fAR);
                verificationInfo.put("company", (Object)companyInfo);
                if (preInfo == null) {
                    preInfo = verificationInfo;
                    continue;
                }
                if (this.isSameGrp((IObjectValue)preInfo, (IObjectValue)verificationInfo)) {
                    this.mergeIt((IObjectValue)preInfo, (IObjectValue)verificationInfo);
                    continue;
                }
                this.setIsSameCurrency((IObjectValue)preInfo);
                this.checkDataValid((IObjectValue)preInfo);
                this.setVerificationBillInfoByBao((BillBaseInfo)preInfo, fAR);
                if (fAR) {
                    ((IArVerificationFacade)iBiz).verification((VerificationBillInfo)preInfo);
                    ++log.newCount;
                } else {
                    ((IApVerificationFacade)iBiz).verification((com.kingdee.eas.fi.ap.VerificationBillInfo)preInfo);
                    ++log.newCount;
                }
                preInfo = verificationInfo;
                continue;
            }
            catch (Exception e) {
                ++log.failCount;
                errGrpNum.add(grpNum);
                log.errList.add(e.getMessage());
                logger.error((Object)"ImportData: ", (Throwable)e);
            }
        }
        try {
            if (preInfo != null && !errGrpNum.contains(preInfo.getString("number"))) {
                this.setIsSameCurrency((IObjectValue)preInfo);
                this.checkDataValid((IObjectValue)preInfo);
                this.setVerificationBillInfoByBao((BillBaseInfo)preInfo, fAR);
                if (fAR) {
                    iBiz.verification((VerificationBillInfo)preInfo);
                    ++log.newCount;
                } else {
                    ((IApVerificationFacade)iBiz).verification((com.kingdee.eas.fi.ap.VerificationBillInfo)preInfo);
                    ++log.newCount;
                }
            }
        }
        catch (Exception e) {
            ++log.failCount;
            errGrpNum.add(grpNum);
            log.errList.add(e.getMessage());
            logger.error((Object)"ImportData Error: ", (Throwable)e);
        }
        return log;
    }

    private void checkDataValid(IObjectValue verifyInfo) throws TaskExternalException {
        IObjectCollection colls = (IObjectCollection)verifyInfo.get("entrys");
        Date verifyDate = verifyInfo.getDate("bizDate");
        IObjectValue objInfo = null;
        int n = colls.size();
        for (int i = 0; i < n; ++i) {
            objInfo = colls.getObject(i);
            Date billDate = objInfo.getDate("billDate");
            if (!DateTimeUtils.dayBefore((java.util.Date)verifyDate, (java.util.Date)billDate)) continue;
            String dtFmt = null;
            logger.error((Object)("verifyDateBeforeBillDate, verifyDate:" + DateTimeUtils.format((java.util.Date)verifyDate, dtFmt) + ", billDate:" + DateTimeUtils.format((java.util.Date)billDate, dtFmt)));
            String msg = EASResource.getString((String)RES, (String)"VerifyDateBeforeBillDate");
            throw new TaskExternalException(msg);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CoreBaseInfo transfer(Map dataRow, String cuId, boolean fAR) throws Exception {
        Object material;
        void var5_11;
        void var4_7;
        Object var4_4 = null;
        Object var5_8 = null;
        if (fAR) {
            VerificationBillInfo arVecInfo = new VerificationBillInfo();
            VerificationBillentryInfo arVecEntryInfo = new VerificationBillentryInfo();
            arVecInfo.getEntrys().add(arVecEntryInfo);
            VerificationBillInfo verificationBillInfo = arVecInfo;
            VerificationBillentryInfo verificationBillentryInfo = arVecEntryInfo;
        } else {
            com.kingdee.eas.fi.ap.VerificationBillInfo verificationBillInfo = new com.kingdee.eas.fi.ap.VerificationBillInfo();
            com.kingdee.eas.fi.ap.VerificationBillentryInfo verificationBillentryInfo = new com.kingdee.eas.fi.ap.VerificationBillentryInfo();
            verificationBillInfo.getEntrys().add(verificationBillentryInfo);
        }
        Object objVal = null;
        objVal = ((DataToken)dataRow.get((Object)"FNumber")).data;
        String sVal = (String)objVal;
        if (sVal == null) {
            String msg = EASResource.getString((String)RES, (String)"NumberField_Wrong");
            msg = MessageFormat.format(msg, "FNumber", "");
            throw new TaskExternalException(msg);
        }
        var4_7.put("number", (Object)sVal.trim());
        objVal = ((DataToken)dataRow.get((Object)"FVerificationType")).data;
        sVal = (String)objVal;
        try {
            if (sVal == null) {
                throw new NumberFormatException();
            }
            int iVType = Integer.parseInt(sVal.trim());
            if (fAR && iVType >= 200 || !fAR && iVType < 200) {
                throw new TaskExternalException(EASResource.getString((String)RES, (String)"VerificationTypeError"));
            }
            VerificationEnum vEnum = this.getVerificationType(iVType);
            var4_7.put("verificationType", (Object)vEnum);
        }
        catch (NumberFormatException ex) {
            String msg = EASResource.getString((String)RES, (String)"NumberField_Wrong");
            msg = MessageFormat.format(msg, "FVerificationType", sVal);
            logger.error((Object)"ImportData parseNumber: ", (Throwable)ex);
            throw new TaskExternalException(msg);
        }
        objVal = ((DataToken)dataRow.get((Object)"FBizDate")).data;
        String sDate = (String)objVal;
        try {
            java.util.Date vcDate = new SimpleDateFormat("yyyy-MM-dd").parse(sDate);
            var4_7.put("bizDate", (Object)vcDate);
        }
        catch (ParseException e) {
            logger.error((Object)"ImportData parseDate: ", (Throwable)e);
            throw new TaskExternalException(EASResource.getString((String)RES, (String)"DateFormat_Wrong"));
        }
        objVal = ((DataToken)dataRow.get((Object)"FBillType")).data;
        String bizNameCode = (String)objVal;
        int iBizCode = -1;
        try {
            if (bizNameCode == null) {
                throw new NumberFormatException();
            }
            iBizCode = Integer.parseInt(bizNameCode.trim());
            VerificateBillTypeEnum billTypeEnum = this.getBillType(iBizCode);
            var5_11.put("billType", (Object)billTypeEnum);
        }
        catch (NumberFormatException ex) {
            String msg = EASResource.getString((String)RES, (String)"NumberField_Wrong");
            msg = MessageFormat.format(msg, "FBillType", bizNameCode);
            logger.error((Object)"ImportData parseNumber: ", (Throwable)ex);
            throw new TaskExternalException(msg);
        }
        objVal = ((DataToken)dataRow.get((Object)"FBillID")).data;
        String bizObjNum = (String)objVal;
        objVal = ((DataToken)dataRow.get((Object)"FEntryID")).data;
        String entrySeq = (String)objVal;
        int iSeq = -1;
        try {
            if (entrySeq == null) {
                throw new NumberFormatException();
            }
            iSeq = Integer.parseInt(entrySeq.trim());
        }
        catch (NumberFormatException e) {
            String msg = EASResource.getString((String)RES, (String)"NumberField_Wrong");
            msg = MessageFormat.format(msg, "FEntryID", entrySeq);
            logger.error((Object)"ImportData parseNumber:", (Throwable)e);
            throw new TaskExternalException(msg);
        }
        BillEntryBaseInfo bizEntryInfo = this.getBillEntryInfo(bizObjNum, iSeq, iBizCode, cuId);
        BillBaseInfo bizInfo = null;
        if (iBizCode == 1 || iBizCode == 2) {
            bizInfo = (BillBaseInfo)bizEntryInfo.get("head");
        } else if (iBizCode == 3) {
            bizInfo = (BillBaseInfo)bizEntryInfo.get("receivingBill");
        } else if (iBizCode == 4) {
            bizInfo = (BillBaseInfo)bizEntryInfo.get("paymentBill");
        }
        this.setVerifyEntryInfo((BillEntryBaseInfo)var5_11, bizInfo, (IObjectValue)bizEntryInfo);
        objVal = ((DataToken)dataRow.get((Object)"FThisVerificateAmt")).data;
        sVal = (String)objVal;
        BigDecimal veririedAmt = this.getVerifiedAmt(sVal, bizEntryInfo, bizObjNum, iBizCode, entrySeq);
        var5_11.put("thisVerificateAmt", (Object)veririedAmt);
        this.amtMap.put(bizObjNum + entrySeq, veririedAmt);
        objVal = ((DataToken)dataRow.get((Object)"FThisVerificateAmtLoc")).data;
        sVal = (String)objVal;
        BigDecimal verifiedAmtLoc = this.getVerifiedAmtLoc(sVal, bizEntryInfo, bizObjNum, iBizCode, entrySeq);
        var5_11.put("thisVerificateAmtLoc", (Object)verifiedAmtLoc);
        objVal = ((DataToken)dataRow.get((Object)"FGainAndLoss")).data;
        sVal = (String)objVal;
        if (!StringUtils.isEmpty((String)sVal)) {
            try {
                BigDecimal amt = new BigDecimal(sVal.trim());
                var5_11.put("gainAndLoss", (Object)amt);
            }
            catch (NumberFormatException e) {
                String msg = EASResource.getString((String)RES, (String)"NumberField_Wrong");
                msg = MessageFormat.format(msg, "FGainAndLoss", sVal);
                logger.error((Object)"ImportData parseAmt: ", (Throwable)e);
                throw new TaskExternalException(msg);
            }
        }
        if (iBizCode != 1 && iBizCode != 2) return var4_7;
        Object expenseitem = bizEntryInfo.get("expenseitem");
        if (expenseitem != null) {
            if (!(expenseitem instanceof ExpenseTypeInfo)) throw new TaskExternalException(EASResource.getString((String)RES, (String)"ExpenseItem_OR_Metarial_Error_Wrong"));
            try {
                var5_11.put("materialId", (Object)((ExpenseTypeInfo)expenseitem).getId().toString());
                IExpenseType iexpenseItem = ExpenseTypeFactory.getRemoteInstance();
                ExpenseTypeInfo expenseItem2 = iexpenseItem.getExpenseTypeInfo((IObjectPK)new ObjectUuidPK(((ExpenseTypeInfo)expenseitem).getId().toString()));
                if (expenseItem2 != null) {
                    var5_11.put("materialNumber", (Object)expenseItem2.getNumber());
                    var5_11.put("materialName", (Object)expenseItem2.getName());
                }
            }
            catch (Exception e) {
                throw new TaskExternalException(EASResource.getString((String)RES, (String)"ExpenseItem_OR_Metarial_Error_Wrong"));
            }
        }
        if ((material = bizEntryInfo.get("material")) != null) {
            if (!(material instanceof MaterialInfo)) throw new TaskExternalException(EASResource.getString((String)RES, (String)"ExpenseItem_OR_Metarial_Error_Wrong"));
            try {
                var5_11.put("materialId", (Object)((MaterialInfo)material).getId().toString());
                IMaterial imaterial = MaterialFactory.getRemoteInstance();
                MaterialInfo material2 = imaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(((MaterialInfo)material).getId().toString()));
                if (material2 != null) {
                    var5_11.put("materialNumber", (Object)material2.getNumber());
                    var5_11.put("materialName", (Object)material2.getName());
                }
            }
            catch (Exception e) {
                throw new TaskExternalException(EASResource.getString((String)RES, (String)"ExpenseItem_OR_Metarial_Error_Wrong"));
            }
        }
        if (material != null || expenseitem != null) return var4_7;
        throw new TaskExternalException(EASResource.getString((String)RES, (String)"ExpenseItem_OR_Metarial_Empty_Wrong"));
    }

    private void setVerificationBillInfoByBao(BillBaseInfo bizInfo, boolean fAR) throws TaskExternalException, BOSException {
        VerificationBillBaseInfo verificaionBill = null;
        AbstractObjectCollection c = null;
        VerificationBillBaseEntryInfo entryInfo = null;
        if (bizInfo instanceof VerificationBillInfo) {
            verificaionBill = (VerificationBillInfo)bizInfo;
            c = (VerificationBillentryCollection)((Object)verificaionBill.get("entrys"));
        } else {
            verificaionBill = (com.kingdee.eas.fi.ap.VerificationBillInfo)bizInfo;
            c = (com.kingdee.eas.fi.ap.VerificationBillentryCollection)((Object)verificaionBill.get("entrys"));
        }
        VerificateBillTypeEnum billType = null;
        BigDecimal thisVerificateAmt_Main = new BigDecimal("0");
        BigDecimal thisVerificateAmt_second = new BigDecimal("0");
        BigDecimal thisVerificateAmtLoc_Main = new BigDecimal("0");
        BigDecimal thisVerificateAmtLoc_second = new BigDecimal("0");
        VerificateBillTypeEnum mainBillType = null;
        VerificateBillTypeEnum secondBillType = null;
        String mainAcctCussName = null;
        String secondAcctCussName = null;
        BOSUuid mainAcctCussID = null;
        BOSUuid secondAcctCussID = null;
        AsstActTypeInfo mainAssActType = null;
        AsstActTypeInfo secondAssActType = null;
        CurrencyInfo mainCurrency = null;
        CurrencyInfo secondCurrency = null;
        if (c.size() == 0) {
            throw new TaskExternalException("The Import Record Number Is Zero.");
        }
        for (int i = 0; i < c.size(); ++i) {
            if (fAR) {
                entryInfo = (VerificationBillentryInfo)c.getObject(i);
                billType = (VerificateBillTypeEnum)entryInfo.get("billType");
                if (mainBillType == null && (billType == VerificateBillTypeEnum.OtherReceiveBill || billType == VerificateBillTypeEnum.ReceiveBill)) {
                    thisVerificateAmt_Main = thisVerificateAmt_Main.add(entryInfo.getBigDecimal("thisVerificateAmt"));
                    thisVerificateAmtLoc_Main = thisVerificateAmt_Main.add(entryInfo.getBigDecimal("thisVerificateAmtLoc"));
                    mainBillType = (VerificateBillTypeEnum)entryInfo.get("billType");
                    mainAcctCussID = BOSUuid.read((String)entryInfo.get("acctCussID").toString());
                    mainAcctCussName = (String)entryInfo.get("acctCussName");
                    mainAcctCussName = (String)entryInfo.get("acctCussName");
                    mainAssActType = (AsstActTypeInfo)entryInfo.get("acctCussType");
                    mainCurrency = (CurrencyInfo)entryInfo.get("currency");
                    continue;
                }
                thisVerificateAmt_second = thisVerificateAmt_second.add(entryInfo.getBigDecimal("thisVerificateAmt"));
                thisVerificateAmtLoc_second = thisVerificateAmtLoc_second.add(entryInfo.getBigDecimal("thisVerificateAmtLoc"));
                secondBillType = (VerificateBillTypeEnum)entryInfo.get("billType");
                secondAcctCussID = BOSUuid.read((String)entryInfo.get("acctCussID").toString());
                mainAcctCussName = (String)entryInfo.get("acctCussName");
                secondAcctCussName = (String)entryInfo.get("acctCussName");
                secondAssActType = (AsstActTypeInfo)entryInfo.get("acctCussType");
                secondCurrency = (CurrencyInfo)entryInfo.get("currency");
                continue;
            }
            entryInfo = (com.kingdee.eas.fi.ap.VerificationBillentryInfo)c.getObject(i);
            billType = (VerificateBillTypeEnum)entryInfo.get("billType");
            if (mainBillType == null && (billType == VerificateBillTypeEnum.OtherPaymentBill || billType == VerificateBillTypeEnum.PaymentBill)) {
                thisVerificateAmt_Main = thisVerificateAmt_Main.add(entryInfo.getBigDecimal("thisVerificateAmt"));
                thisVerificateAmtLoc_Main = thisVerificateAmt_Main.add(entryInfo.getBigDecimal("thisVerificateAmtLoc"));
                mainBillType = (VerificateBillTypeEnum)entryInfo.get("billType");
                mainAcctCussID = BOSUuid.read((String)entryInfo.get("acctCussID").toString());
                mainAcctCussName = (String)entryInfo.get("acctCussName");
                mainAssActType = (AsstActTypeInfo)entryInfo.get("acctCussType");
                mainCurrency = (CurrencyInfo)entryInfo.get("currency");
                continue;
            }
            thisVerificateAmt_second = thisVerificateAmt_second.add(entryInfo.getBigDecimal("thisVerificateAmt"));
            thisVerificateAmtLoc_second = thisVerificateAmtLoc_second.add(entryInfo.getBigDecimal("thisVerificateAmtLoc"));
            secondBillType = (VerificateBillTypeEnum)entryInfo.get("billType");
            secondAcctCussID = BOSUuid.read((String)entryInfo.get("acctCussID").toString());
            secondAcctCussName = (String)entryInfo.get("acctCussName");
            secondAssActType = (AsstActTypeInfo)entryInfo.get("acctCussType");
            secondCurrency = (CurrencyInfo)entryInfo.get("currency");
        }
        if (mainBillType == null) {
            mainBillType = (VerificateBillTypeEnum)entryInfo.get("billType");
        }
        if (secondBillType == null) {
            secondBillType = (VerificateBillTypeEnum)entryInfo.get("billType");
        }
        if (mainAcctCussName == null) {
            mainAcctCussName = (String)entryInfo.get("acctCussName");
        }
        if (secondAcctCussName == null) {
            secondAcctCussName = (String)entryInfo.get("acctCussName");
        }
        if (mainAcctCussID == null) {
            mainAcctCussID = BOSUuid.read((String)entryInfo.get("acctCussID").toString());
        }
        if (secondAcctCussID == null) {
            secondAcctCussID = BOSUuid.read((String)entryInfo.get("acctCussID").toString());
        }
        if (mainAssActType == null) {
            mainAssActType = (AsstActTypeInfo)entryInfo.get("acctCussType");
        }
        if (secondAssActType == null) {
            secondAssActType = (AsstActTypeInfo)entryInfo.get("acctCussType");
        }
        if (mainCurrency == null) {
            mainCurrency = (CurrencyInfo)entryInfo.get("currency");
        }
        if (secondCurrency == null) {
            secondCurrency = (CurrencyInfo)entryInfo.get("currency");
        }
        verificaionBill.put("mainBillType", mainBillType);
        verificaionBill.put("secondBillType", secondBillType);
        verificaionBill.put("mainAcctCussType", mainAssActType);
        verificaionBill.put("mainAcctCussID", mainAcctCussID);
        verificaionBill.put("mainAcctCussName", mainAcctCussName);
        verificaionBill.put("mainCurrency", mainCurrency);
        verificaionBill.put("mainThisVerificateAmt", thisVerificateAmt_Main);
        verificaionBill.put("mainThisVerificateAmtLoc", thisVerificateAmtLoc_Main);
        verificaionBill.put("secondAcctCussType", secondAssActType);
        verificaionBill.put("secondAcctCussID", secondAcctCussID);
        verificaionBill.put("secondAcctCussName", secondAcctCussName);
        verificaionBill.put("secondCurrency", secondCurrency);
        verificaionBill.put("secondThisVerificateAmt", thisVerificateAmt_second);
        verificaionBill.put("secondThisVerificateAmtLoc", thisVerificateAmtLoc_second);
        if (mainAcctCussID.equals((Object)secondAcctCussID)) {
            verificaionBill.put("isSameCode", Boolean.TRUE);
        } else if (mainAcctCussID != null && secondAcctCussID != null) {
            IDynamicObject iDyn = DynamicObjectFactory.getRemoteInstance();
            String bizCode = "bizAnalysisCode";
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo(bizCode));
            ObjectUuidPK pk = new ObjectUuidPK(mainAcctCussID);
            IObjectValue val1 = iDyn.getValue(pk.getObjectType(), (IObjectPK)pk);
            pk = new ObjectUuidPK(secondAcctCussID);
            IObjectValue val2 = iDyn.getValue(pk.getObjectType(), (IObjectPK)pk);
            if (val1 != null && val2 != null && val1.get(bizCode) != null && val1.get(bizCode).equals(val2.get(bizCode))) {
                verificaionBill.put("isSameCode", Boolean.TRUE);
            }
        }
    }

    private void setVerifyEntryInfo(BillEntryBaseInfo verifyEntryInfo, BillBaseInfo bizInfo, IObjectValue bizEntryInfo) throws Exception {
        if (bizInfo != null && bizEntryInfo != null) {
            verifyEntryInfo.put("billSubType", (Object)"0");
            verifyEntryInfo.put("billID", (Object)bizInfo.getString("id"));
            verifyEntryInfo.put("entryID", (Object)bizEntryInfo.getString("id"));
            verifyEntryInfo.put("billNumber", (Object)bizInfo.getNumber());
            verifyEntryInfo.put("entrySeq", bizEntryInfo.get("seq"));
            if (bizInfo instanceof ArApBillBaseInfo) {
                ArApBillBaseInfo arInfo = (ArApBillBaseInfo)bizInfo;
                ArApBillEntryBaseInfo arEntryInfo = (ArApBillEntryBaseInfo)bizEntryInfo;
                verifyEntryInfo.put("billDate", (Object)arInfo.getBillDate());
                verifyEntryInfo.put("acctCussID", (Object)arInfo.getAsstActID());
                verifyEntryInfo.put("acctCussName", (Object)arInfo.getAsstActName());
                verifyEntryInfo.put("acctCussType", (Object)arInfo.getAsstActType());
                verifyEntryInfo.put("currency", (Object)arInfo.getCurrency());
                if (bizInfo instanceof OtherBillInfo) {
                    verifyEntryInfo.put("billSubType", (Object)this.changeBillType(true, arInfo.getInt("billType")));
                } else {
                    verifyEntryInfo.put("billSubType", (Object)this.changeBillType(false, arInfo.getInt("billType")));
                }
                verifyEntryInfo.put("account", (Object)arEntryInfo.getAccount());
                verifyEntryInfo.put("adminOrgUnit", (Object)arInfo.getAdminOrgUnit());
                verifyEntryInfo.put("person", (Object)arInfo.getPerson());
                verifyEntryInfo.put("comment", (Object)arInfo.getAbstractName());
            } else if (bizInfo instanceof ReceivingBillInfo) {
                ReceivingBillInfo recInfo = (ReceivingBillInfo)bizInfo;
                verifyEntryInfo.put("billDate", (Object)recInfo.getBizDate());
                verifyEntryInfo.put("acctCussID", (Object)recInfo.getPayerID());
                verifyEntryInfo.put("acctCussName", (Object)recInfo.getPayerName());
                verifyEntryInfo.put("acctCussType", (Object)recInfo.getPayerType());
                verifyEntryInfo.put("currency", (Object)recInfo.getCurrency());
                if (recInfo.getRecBillType() != null && recInfo.getRecBillType().getId() != null) {
                    try {
                        ReceivingBillTypeInfo recBillType = ReceivingBillTypeFactory.getRemoteInstance().getReceivingBillTypeInfo((IObjectPK)new ObjectUuidPK(recInfo.getRecBillType().getId()));
                        verifyEntryInfo.put("billSubType", (Object)Helper.getRecPayVeriBillTypeEnum(true, recBillType.getNumber(), new BigDecimal("1")));
                    }
                    catch (Exception e) {
                        throw new Exception(e);
                    }
                }
                verifyEntryInfo.put("account", (Object)recInfo.getPayeeAccount());
                verifyEntryInfo.put("adminOrgUnit", (Object)recInfo.getAdminOrgUnit());
                verifyEntryInfo.put("person", (Object)recInfo.getPerson());
                verifyEntryInfo.put("comment", (Object)recInfo.getDescription());
            } else if (bizInfo instanceof PaymentBillInfo) {
                PaymentBillInfo payInfo = (PaymentBillInfo)bizInfo;
                verifyEntryInfo.put("billDate", (Object)payInfo.getBizDate());
                verifyEntryInfo.put("acctCussID", (Object)payInfo.getPayeeID());
                verifyEntryInfo.put("acctCussName", (Object)payInfo.getPayeeName());
                verifyEntryInfo.put("acctCussType", (Object)payInfo.getPayeeType());
                verifyEntryInfo.put("currency", (Object)payInfo.getCurrency());
                if (payInfo.getPayBillType() != null && payInfo.getPayBillType().getId() != null) {
                    try {
                        PaymentBillTypeInfo payBillType = PaymentBillTypeFactory.getRemoteInstance().getPaymentBillTypeInfo((IObjectPK)new ObjectUuidPK(payInfo.getPayBillType().getId()));
                        verifyEntryInfo.put("billSubType", (Object)Helper.getRecPayVeriBillTypeEnum(false, payBillType.getNumber(), new BigDecimal("1")));
                    }
                    catch (Exception e) {
                        throw new Exception(e);
                    }
                }
                verifyEntryInfo.put("account", (Object)payInfo.getPayerAccount());
                verifyEntryInfo.put("adminOrgUnit", (Object)payInfo.getAdminOrgUnit());
                verifyEntryInfo.put("person", (Object)payInfo.getPerson());
                verifyEntryInfo.put("comment", (Object)payInfo.getDescription());
            }
        }
    }

    private BillEntryBaseInfo getBillEntryInfo(String billNum, int entrySeq, int bizCode, String cuId) throws TaskExternalException {
        BillEntryBaseInfo bizEntryInfo = null;
        StringBuffer oql = new StringBuffer();
        BOSObjectType bosType = null;
        try {
            if (bizCode == 1 || bizCode == 2) {
                oql.append("select *, account.id, head.id, head.currency.id,").append(" head.adminOrgUnit.id, head.person.id,").append(" head.billDate, head.number,").append(" head.billType,").append(" head.abstractName,").append(" head.asstActID, head.sourceBillType,").append(" head.asstActName, head.asstActType,").append(" head.verifyAmount, head.verifyAmountLocal,").append(" head.unVerifyAmount, head.unVerifyAmountLocal, ").append(" head.lockUnVerifyAmt, head.lockUnVerifyAmtLocal,").append(" head.auditor.id where head.number = '").append(billNum).append("' and seq = ").append(entrySeq).append(" and head.cu.id = '").append(cuId).append("'");
                bosType = bizCode == 1 ? AR_BOSTYPE : AP_BOSTYPE;
            } else if (bizCode == 3) {
                oql.append("select *, receivingBill.id, receivingBill.payeeAccount.id,").append(" receivingBill.adminOrgUnit.id, receivingBill.person.id,").append(" receivingBill.payerID, receivingBill.payerName,").append(" receivingBill.payerType, receivingBill.currency.id,").append(" receivingBill.unVcAmount, receivingBill.unVcLocAmount,").append(" receivingBill.unLockAmt, receivingBill.unLockLocAmt,").append(" receivingBill.auditor.id, receivingBill.bizDate, receivingBill.recType ").append(" ,receivingBill.description").append(" ,receivingBill.recBillType").append(" where receivingBill.number = '").append(billNum).append("' and seq = ").append(entrySeq).append(" and receivingBill.cu.id = '").append(cuId).append("'");
                bosType = REC_BOSTYPE;
            } else if (bizCode == 4) {
                oql.append("select *, paymentBill.id, paymentBill.payerAccount.id,").append(" paymentBill.adminOrgUnit.id, paymentBill.person.id,").append(" paymentBill.payeeID, paymentBill.payeeName,").append(" paymentBill.payeeType, paymentBill.currency.id,").append(" paymentBill.unVcAmount, paymentBill.unVcLocAmount, ").append(" paymentBill.unLockAmt, paymentBill.unLockLocAmt,").append(" paymentBill.bizDate, paymentBill.auditor.id, paymentBill.payType ").append(" ,paymentBill.description").append(" ,paymentBill.payBillType").append(" where paymentBill.number = '").append(billNum).append("' and seq = ").append(entrySeq).append(" and paymentBill.cu.id = '").append(cuId).append("'");
                bosType = PAY_BOSTYPE;
            }
            logger.debug((Object)("oql:" + oql));
            IDynamicObject iBiz = DynamicObjectFactory.getRemoteInstance();
            bizEntryInfo = (BillEntryBaseInfo)iBiz.getValue(bosType, oql.toString());
            if (bizEntryInfo == null) {
                String msg = EASResource.getString((String)RES, (String)"NoBill");
                msg = MessageFormat.format(msg, billNum);
                throw new TaskExternalException(msg);
            }
        }
        catch (Exception e) {
            String msg = EASResource.getString((String)RES, (String)"Error_ByNumber");
            msg = MessageFormat.format(msg, billNum);
            logger.error((Object)("getInfoByNumber: " + billNum + ".   "), (Throwable)e);
            throw new TaskExternalException(msg);
        }
        this.checkBillStatus(bizCode, billNum, bizEntryInfo);
        return bizEntryInfo;
    }

    private void checkBillStatus(int bizCode, String billNum, BillEntryBaseInfo bizEntryInfo) throws TaskExternalException {
        String errMsg = null;
        switch (bizCode) {
            case 1: {
                OtherBillInfo arInfo = (OtherBillInfo)bizEntryInfo.get("head");
                if (arInfo.getAuditor() != null) break;
                errMsg = EASResource.getString((String)RES, (String)"BillNotAudited");
                break;
            }
            case 2: {
                com.kingdee.eas.fi.ap.OtherBillInfo apInfo = (com.kingdee.eas.fi.ap.OtherBillInfo)bizEntryInfo.get("head");
                if (apInfo.getAuditor() != null) break;
                errMsg = EASResource.getString((String)RES, (String)"BillNotAudited");
                break;
            }
            case 3: {
                ReceivingBillInfo recInfo = (ReceivingBillInfo)bizEntryInfo.get("receivingBill");
                if (recInfo.getPayerID() != null) break;
                errMsg = EASResource.getString((String)RES, (String)"RecBillNotReceived");
                break;
            }
            case 4: {
                PaymentBillInfo payInfo = (PaymentBillInfo)bizEntryInfo.get("paymentBill");
                if (payInfo.getPayeeID() != null) break;
                errMsg = EASResource.getString((String)RES, (String)"BillNotPayed");
            }
        }
        if (errMsg != null) {
            errMsg = MessageFormat.format(errMsg, billNum);
            throw new TaskExternalException(errMsg);
        }
    }

    private boolean isSameGrp(IObjectValue preInfo, IObjectValue info) {
        String num;
        String preNum = preInfo.getString("number");
        return preNum.equals(num = info.getString("number"));
    }

    private void mergeIt(IObjectValue preInfo, IObjectValue info) {
        IObjectCollection preColls = (IObjectCollection)preInfo.get("entrys");
        IObjectCollection colls = (IObjectCollection)info.get("entrys");
        preColls.addObject(colls.getObject(0));
    }

    private void setIsSameCurrency(IObjectValue info) {
        info.setBoolean("isSameCurrency", true);
        IObjectCollection colls = (IObjectCollection)info.get("entrys");
        IObjectValue objVal = null;
        String preCurr = null;
        String curr = null;
        int n = colls.size();
        for (int i = 0; i < n; ++i) {
            objVal = colls.getObject(i);
            IObjectValue currObj = objVal.getObjectValue("currency");
            curr = currObj.getString("id");
            if (preCurr != null && !preCurr.equals(curr)) {
                info.setBoolean("isSameCurrency", false);
                break;
            }
            preCurr = curr;
        }
    }

    private VerificationEnum getVerificationType(int iVType) throws TaskExternalException {
        VerificationEnum vEnum = VerificationEnum.getEnum((int)iVType);
        if (vEnum == null) {
            String msg = EASResource.getString((String)RES, (String)"ValueInvalid");
            List enums = VerificationEnum.getEnumList();
            StringBuffer sEnums = new StringBuffer();
            int n = enums.size();
            for (int i = 0; i < n; ++i) {
                VerificationEnum enum1 = (VerificationEnum)enums.get(i);
                sEnums.append(enum1.getValue()).append(":").append(enum1.getAlias());
                sEnums.append(i < n - 1 ? ", " : "");
            }
            msg = MessageFormat.format(msg, sEnums.toString());
            throw new TaskExternalException(msg);
        }
        return vEnum;
    }

    private VerificateBillTypeEnum getBillType(int iBizCode) throws TaskExternalException {
        VerificateBillTypeEnum billTypeEnum = null;
        switch (iBizCode) {
            case 1: {
                billTypeEnum = VerificateBillTypeEnum.OtherReceiveBill;
                break;
            }
            case 2: {
                billTypeEnum = VerificateBillTypeEnum.OtherPaymentBill;
                break;
            }
            case 3: {
                billTypeEnum = VerificateBillTypeEnum.ReceiveBill;
                break;
            }
            case 4: {
                billTypeEnum = VerificateBillTypeEnum.PaymentBill;
            }
        }
        if (billTypeEnum == null) {
            String msg = EASResource.getString((String)RES, (String)"ValueInvalid");
            List enums = VerificateBillTypeEnum.getEnumList();
            StringBuffer sEnums = new StringBuffer();
            int n = enums.size();
            for (int i = 0; i < n; ++i) {
                VerificateBillTypeEnum enum1 = (VerificateBillTypeEnum)enums.get(i);
                sEnums.append(enum1.getValue()).append(":").append(enum1.getAlias());
                sEnums.append(i < n - 1 ? ", " : "");
            }
            msg = MessageFormat.format(msg, "FBillType", sEnums.toString());
            throw new TaskExternalException(msg);
        }
        return billTypeEnum;
    }

    private BigDecimal getVerifiedAmt(String sVal, BillEntryBaseInfo bizEntryInfo, String bizObjNum, int bizCode, String entrySeq) throws TaskExternalException {
        try {
            String msg = EASResource.getString((String)RES, (String)"ThisVerificateAmt");
            BigDecimal amt = new BigDecimal(sVal);
            if (this.amtMap.containsKey(bizObjNum + entrySeq)) {
                amt = this.amtMap.get(bizObjNum + entrySeq);
            }
            BigDecimal lockUnVerifyAmt = BigDecimal.ZERO;
            if (bizCode == 1 || bizCode == 2) {
                lockUnVerifyAmt = bizEntryInfo.get("lockUnVerifyAmt") != null ? bizEntryInfo.getBigDecimal("lockUnVerifyAmt") : BigDecimal.ZERO;
            } else if (bizCode == 3 || bizCode == 4) {
                BigDecimal bigDecimal = lockUnVerifyAmt = bizEntryInfo.get("unLockAmt") != null ? bizEntryInfo.getBigDecimal("unLockAmt") : BigDecimal.ZERO;
            }
            if (amt.abs().signum() == 0) {
                throw new TaskExternalException(this.getAmtLEZeroMsg(bizObjNum, msg));
            }
            if (amt.abs().compareTo(lockUnVerifyAmt.abs()) > 0) {
                throw new TaskExternalException(this.getAmtInvalidMsg(bizObjNum, msg));
            }
            return amt;
        }
        catch (NumberFormatException e) {
            String msg = EASResource.getString((String)RES, (String)"NumberField_Wrong");
            String msg_thisverificateamt = EASResource.getString((String)RES, (String)"ThisVerificateAmt");
            msg = MessageFormat.format(msg, msg_thisverificateamt, sVal);
            logger.error((Object)"ImportData parseAmt: ", (Throwable)e);
            throw new TaskExternalException(msg);
        }
    }

    private BigDecimal getVerifiedAmtLoc(String sVal, BillEntryBaseInfo bizEntryInfo, String bizObjNum, int bizCode, String entrySeq) throws TaskExternalException {
        try {
            BigDecimal amtLoc = new BigDecimal(sVal);
            if (this.amtMap.containsKey(bizObjNum + entrySeq + "LOCAL")) {
                amtLoc = this.amtMap.get(bizObjNum + entrySeq + "LOCAL");
            }
            BigDecimal unVcAmtLoc = BigDecimal.ZERO;
            if (bizCode == 1 || bizCode == 2) {
                unVcAmtLoc = bizEntryInfo.get("lockUnVerifyAmtLocal") != null ? bizEntryInfo.getBigDecimal("lockUnVerifyAmtLocal") : BigDecimal.ZERO;
            } else if (bizCode == 3 || bizCode == 4) {
                BigDecimal bigDecimal = unVcAmtLoc = bizEntryInfo.get("unLockLocAmt") != null ? bizEntryInfo.getBigDecimal("unLockLocAmt") : BigDecimal.ZERO;
            }
            if (amtLoc.abs().signum() == 0) {
                throw new TaskExternalException(this.getAmtLEZeroMsg(bizObjNum, "FThisVerificateAmtLoc"));
            }
            if (amtLoc.abs().compareTo(unVcAmtLoc.abs()) > 0) {
                throw new TaskExternalException(this.getAmtGreatUnLockAmtMsg(bizObjNum, "FThisVerificateAmtLoc"));
            }
            return amtLoc;
        }
        catch (NumberFormatException e) {
            String msg = EASResource.getString((String)RES, (String)"NumberField_Wrong");
            msg = MessageFormat.format(msg, "FThisVerificateAmtLoc", sVal);
            logger.error((Object)"ImportData parseAmt: ", (Throwable)e);
            throw new TaskExternalException(msg);
        }
    }

    private String getAmtLEZeroMsg(String bizObjNum, String field) {
        String msg = EASResource.getString((String)RES, (String)"AmtLEZero");
        msg = MessageFormat.format(msg, bizObjNum, field);
        return msg;
    }

    private String getAmtInvalidMsg(String bizObjNum, String field) {
        String msg = EASResource.getString((String)RES, (String)"AmtInvalid");
        msg = MessageFormat.format(msg, bizObjNum, field);
        return msg;
    }

    private String getAmtGreatUnLockAmtMsg(String bizObjNum, String field) {
        String msg = EASResource.getString((String)RES, (String)"AmtInvalid1");
        msg = MessageFormat.format(msg, bizObjNum, field);
        return msg;
    }

    private VerificateBillTypeEnum changeBillType(boolean isArBill, int billType) {
        VerificateBillTypeEnum billTypeEnum = null;
        if (isArBill) {
            switch (billType) {
                case 102: {
                    billTypeEnum = VerificateBillTypeEnum.SaleInvoice;
                    break;
                }
                case 103: {
                    billTypeEnum = VerificateBillTypeEnum.SaleChargeInvoice;
                    break;
                }
                case 101: {
                    billTypeEnum = VerificateBillTypeEnum.OtherReceiveBill;
                }
            }
        } else {
            switch (billType) {
                case 202: {
                    billTypeEnum = VerificateBillTypeEnum.PurInvoice;
                    break;
                }
                case 203: {
                    billTypeEnum = VerificateBillTypeEnum.PurChargeInvoice;
                    break;
                }
                case 201: {
                    billTypeEnum = VerificateBillTypeEnum.OtherPaymentBill;
                }
            }
        }
        return billTypeEnum;
    }
}

