/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.ar.ImportLog;
import com.kingdee.eas.fi.ar.client.AbstractVerifyDataLogUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Date;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class VerifyDataLogUI
extends AbstractVerifyDataLogUI {
    private static final Logger logger = CoreUIObject.getLogger(VerifyDataLogUI.class);
    private static final String RES = "com.kingdee.eas.scm.sd.sale.client.GTaxEasResource";
    private static final String VEC_RES = "com.kingdee.eas.fi.ar.client.VerificateResource";
    private ImportLog actionLog = null;

    public void onLoad() throws Exception {
        super.onLoad();
        Map uiCtx = this.getUIContext();
        if (uiCtx.get("Log") != null) {
            this.actionLog = (ImportLog)uiCtx.get("Log");
            this.loadActionLog();
        } else {
            SysUtil.abort();
        }
    }

    private void loadActionLog() {
        Date sqlDate = new Date(this.actionLog.startTime.getTime());
        this.lblTimeVal.setText(sqlDate.toString());
        this.lblCostVal.setText(this.actionLog.getCostTime());
        this.txtArea.setText(this.getDetailMsg());
    }

    private String getDetailMsg() {
        Object[] countArr = null;
        String msgPre = null;
        String fileProp = EASResource.getString((String)VEC_RES, (String)"FilePath");
        fileProp = MessageFormat.format(fileProp, this.actionLog.dataFile);
        msgPre = EASResource.getString((String)VEC_RES, (String)"ImportCount");
        countArr = new String[]{String.valueOf(this.actionLog.billCount), String.valueOf(this.actionLog.newCount), String.valueOf(this.actionLog.failCount)};
        String msg = fileProp + "\r\n" + MessageFormat.format(msgPre, countArr);
        if (this.actionLog.errList.size() > 0) {
            msg = msg + "\r\n" + EASResource.getString((String)RES, (String)"ErrDetail") + "\r\n" + this.actionLog.getErrDetailMsg();
        }
        return msg;
    }

    @Override
    public void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    private String getSummaryMsg() {
        String msg = this.lblTime.getText() + this.lblTimeVal.getText() + "    " + this.lblCost.getText() + this.lblCostVal.getText() + "    " + this.lblType.getText() + this.lblTypeDesc.getText() + "\r\n" + this.lblDetail.getText() + "\r\n";
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void btnLogFile_actionPerformed(ActionEvent e) throws Exception {
        String sLogDir = System.getProperty("user.home") + File.separator + ".EAS";
        File logFile = new File(sLogDir = FilenameUtils.normalize((String)sLogDir));
        if (!logFile.exists()) {
            logFile.mkdirs();
        }
        java.util.Date curTime = new java.util.Date();
        DateFormat df = BOSLocaleUtil.getDateFormat();
        String sLogFile = sLogDir + File.separator + "VerificationImportLog" + df.format(curTime) + ".log";
        sLogFile = FilenameUtils.normalize((String)sLogFile);
        logFile = new File(sLogFile);
        logFile.createNewFile();
        String sLog = this.getSummaryMsg() + this.getDetailMsg();
        FileOutputStream out = null;
        OutputStreamWriter writer = null;
        BufferedWriter buffWriter = null;
        try {
            out = new FileOutputStream(logFile);
            writer = new OutputStreamWriter(out);
            buffWriter = new BufferedWriter(writer);
            buffWriter.write(sLog);
            buffWriter.flush();
            MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)RES, (String)"LogSaved") + sLogFile));
            this.releaseIOOut(out, writer, buffWriter);
        }
        catch (IOException ex) {
            try {
                this.handUIException(ex);
                this.releaseIOOut(out, writer, buffWriter);
            }
            catch (Throwable throwable) {
                this.releaseIOOut(out, writer, buffWriter);
                throw throwable;
            }
        }
    }

    private void releaseIOOut(FileOutputStream out, OutputStreamWriter writer, BufferedWriter buffWriter) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (buffWriter != null) {
                buffWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

