/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.base.core.util.OrgRelationUtils;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.client.OtherBillQueryUI;
import com.kingdee.eas.framework.DataBaseInfo;
import java.util.Arrays;
import java.util.Comparator;

public class WriteOffOtherBillQueryUI
extends OtherBillQueryUI {
    private OrgUnitInfo[] mainOrgs = null;
    private int idxDefaultMainOrg = -1;
    private static final String SALE_WRITEOFF = "SaleWriteOff";

    public WriteOffOtherBillQueryUI() throws Exception {
        this.radAudit.setSelected(true);
        this.radAudit.setEnabled(false);
        this.radUnAudit.setEnabled(false);
        this.radAuditAll.setEnabled(false);
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        WriteOffOtherBillQueryUI.setCompanyOrgF7(this.kDBizPrCompany, this.getViewPermission(), true);
    }

    private static void setF7FilterUIProperties(KDBizPromptBox prmt, boolean required) {
        prmt.setEditable(true);
        prmt.setDisplayFormat("$name$");
        prmt.setEditFormat("$number$");
        prmt.setCommitFormat("$number$");
        prmt.setLabelVisible(true);
        prmt.setRequired(required);
    }

    public static void setCompanyOrgF7(KDBizPromptBox f7, String permissionItem, boolean required) throws Exception {
        WriteOffOtherBillQueryUI.setF7FilterUIProperties(f7, true);
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company);
        if (permissionItem != null) {
            iProducer.getModel().setPermissionItem(permissionItem);
        }
        iProducer.getModel().setIsCUFilter(false);
        f7.setFilterInfoProducer((IFilterInfoProducer)iProducer);
    }

    @Override
    protected String getViewPermission() {
        return SALE_WRITEOFF;
    }

    protected final OrgUnitInfo getDefaultMainBizOrg() {
        OrgUnitInfo currentMainOrg;
        if (this.idxDefaultMainOrg > -1) {
            return this.mainOrgs[this.idxDefaultMainOrg];
        }
        if (this.mainOrgs == null) {
            this.gainAuthMainBizOrgs();
        }
        if ((currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType())) != null && this.mainOrgs.length > 0) {
            for (int i = 0; i < this.mainOrgs.length; ++i) {
                if (!currentMainOrg.getId().toString().equals(this.mainOrgs[i].getId().toString())) continue;
                this.idxDefaultMainOrg = i;
                return currentMainOrg;
            }
        }
        if (this.mainOrgs.length > 0) {
            this.idxDefaultMainOrg = 0;
            return this.mainOrgs[0];
        }
        return null;
    }

    public static FullOrgUnitCollection getAuthOrgByPermItem(IObjectPK user, OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitCollection result = null;
        IPermission permission = PermissionFactory.getRemoteInstance();
        result = permission.getAuthorizedOrg(user, orgType, null, permItem);
        return result;
    }

    private void gainAuthMainBizOrgs() {
        if (this.mainOrgs == null) {
            try {
                FullOrgUnitCollection collection = WriteOffOtherBillQueryUI.getAuthOrgByPermItem((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), this.getMainBizOrgType(), this.getViewPermission());
                this.mainOrgs = OrgRelationUtils.getOrgUnitInfosByType((FullOrgUnitCollection)collection, (OrgType)this.getMainBizOrgType());
                if (this.mainOrgs == null) {
                    this.mainOrgs = new OrgUnitInfo[0];
                }
                if (this.mainOrgs.length > 0) {
                    this.mainOrgs = (OrgUnitInfo[])WriteOffOtherBillQueryUI.sortDataByNumber((DataBaseInfo[])this.mainOrgs, true);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private static DataBaseInfo[] sortDataByNumber(DataBaseInfo[] datas, boolean isAsc) {
        if (datas == null || datas.length < 2) {
            return datas;
        }
        class DataCompare
        implements Comparator {
            private boolean isAsc = true;

            public DataCompare(boolean isAsc) {
                this.isAsc = isAsc;
            }

            public int compare(Object arg0, Object arg1) {
                return this.isAsc ? ((DataBaseInfo)arg0).getNumber().compareTo(((DataBaseInfo)arg1).getNumber()) : ((DataBaseInfo)arg1).getNumber().compareTo(((DataBaseInfo)arg0).getNumber());
            }
        }
        Arrays.sort(datas, new DataCompare(isAsc));
        return datas;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }
}

