/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client.contrastGLDefaultSol;

import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.ui.util.UIHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.BaseCommonQueryAppException;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionUtils;
import com.kingdee.eas.base.commonquery.ShareTypeEnum;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.commonquery.client.IFilterPanel;
import com.kingdee.eas.base.commonquery.client.IQueryInfoPanel;
import com.kingdee.eas.base.commonquery.client.ISorterPanel;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.client.contrastGLDefaultSol.CommonQueryPanel;
import com.kingdee.eas.fi.ar.client.contrastGLDefaultSol.CommonTablePanel;
import com.kingdee.eas.fi.ar.client.contrastGLDefaultSol.Util;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.log4j.Logger;

public class NewSolutionPromptUI
extends CoreUI {
    private static Logger logger = Logger.getLogger(NewSolutionPromptUI.class);
    private static final String commonQueryRes = "com.kingdee.eas.base.commonquery.cqResource";
    private static final String toolBarRes = "com.kingdee.eas.base.commonquery.client.ToolBar";
    private KDBizMultiLangBox solutionNameTextField;
    private KDCheckBox isOrgIsolationBox;
    private KDButton confirmButton;
    private KDButton cancelButton;
    private CommonQueryPanel commonQueryPanel;
    public static final String COMMONQUERYPANEL = "commonquerypanel";
    public static final String COMMONLEFTPANEL = "commonleftpanel";
    public static final String NEWSOLUTIONLISTPANEL = "newsolutionlistpanel";
    private QuerySolutionInfo currentQuerySolutionInfo;
    public static final String RESULTSOLUTION = "ResultSolution";
    public static final String CURRENT_SOLUTION = "current_solution";
    private static final String solutionDialogRes = "com.kingdee.eas.base.commonquery.client.SolutionPromptUI";

    public NewSolutionPromptUI() throws Exception {
        this.init();
    }

    private String getCQResource(String resName) {
        return EASResource.getString((String)commonQueryRes, (String)resName);
    }

    private void init() {
        this.setUITitle(EASResource.getString((String)solutionDialogRes, (String)"title"));
        KDLabelContainer solutionLabContainer = new KDLabelContainer();
        solutionLabContainer.setBoundLabel((JLabel)new KDLabel(EASResource.getString((String)solutionDialogRes, (String)"text")));
        solutionLabContainer.setBoundLabelLength(88);
        solutionLabContainer.setBoundLabelUnderline(true);
        solutionLabContainer.setBounds(new Rectangle(10, 15, 280, 19));
        this.solutionNameTextField = new KDBizMultiLangBox();
        this.solutionNameTextField.setRequired(true);
        List langList = KDBizMultiLangBox.getLanguageList();
        for (int i = 0; i < langList.size(); ++i) {
            if (!SysContext.getSysContext().getLocale().toString().equalsIgnoreCase(((LanguageInfo)langList.get(i)).getLocale().toString())) continue;
            this.solutionNameTextField.setSelectedLanguage((LanguageInfo)langList.get(i));
        }
        solutionLabContainer.setBoundEditor((JComponent)this.solutionNameTextField);
        this.solutionNameTextField.setMaxLength(79);
        this.add((Component)solutionLabContainer);
        this.confirmButton = new KDButton();
        this.confirmButton.setText(EASResource.getString((String)solutionDialogRes, (String)"confirmButtonText"));
        this.confirmButton.setBounds(new Rectangle(141, 71, 73, 19));
        this.confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewSolutionPromptUI.this.confirmButton_actionPerformed(e);
            }
        });
        this.add((Component)this.confirmButton);
        this.cancelButton = new KDButton();
        this.cancelButton.setText(EASResource.getString((String)solutionDialogRes, (String)"cancelButtonText"));
        this.cancelButton.setBounds(new Rectangle(217, 71, 73, 19));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewSolutionPromptUI.this.cancelButton_actionPerformed(e);
            }
        });
        this.add((Component)this.cancelButton);
        KDSeparator separator = new KDSeparator();
        separator.setBounds(new Rectangle(0, 64, 300, 2));
        this.add((Component)separator);
        this.setLayout(null);
        this.setPreferredSize(new Dimension(300, 100));
    }

    private void confirmButton_actionPerformed(ActionEvent e) {
        if (this.saveSolution()) {
            Util.getWindow((Component)((Object)this)).dispose();
        }
    }

    private void cancelButton_actionPerformed(ActionEvent e) {
        Util.getWindow((Component)((Object)this)).dispose();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.currentQuerySolutionInfo = (QuerySolutionInfo)this.getUIContext().get(CURRENT_SOLUTION);
        this.commonQueryPanel = (CommonQueryPanel)((Object)this.getUIContext().get(COMMONQUERYPANEL));
        if (this.currentQuerySolutionInfo != null && !SolutionTypeEnum.SYSTEM_SOLUTION.equals((Object)this.currentQuerySolutionInfo.getSolutionType())) {
            UIHelper.loadMultiLangFields((KDMultiLangBox)this.solutionNameTextField, (IObjectValue)this.currentQuerySolutionInfo, (String)"name");
        }
        this.solutionNameTextField.setMaxLength(200);
        this.solutionNameTextField.setRequired(true);
        this.isOrgIsolationBox = new KDCheckBox();
        this.isOrgIsolationBox.setText(this.getCQResource("onlySelfOrg"));
        this.isOrgIsolationBox.setSelected(false);
        this.isOrgIsolationBox.setBounds(new Rectangle(10, 37, 280, 19));
        this.add((Component)this.isOrgIsolationBox);
        this.isOrgIsolationBox.setSelected(this.currentQuerySolutionInfo != null && ShareTypeEnum.USER_LEVEL.equals((Object)this.currentQuerySolutionInfo.getShareType()));
        if (this.commonQueryPanel.isOnlyShowInCurrentOrg()) {
            this.isOrgIsolationBox.setVisible(false);
            this.isOrgIsolationBox.setSelected(true);
        }
        if (!this.commonQueryPanel.isIsOrgIsolation()) {
            this.isOrgIsolationBox.setVisible(false);
            this.isOrgIsolationBox.setSelected(false);
        }
    }

    private boolean isAddNew() {
        Locale locale = SysContext.getSysContext().getLocale();
        LanguageInfo lang = new LanguageInfo(locale);
        String newName = this.solutionNameTextField.getItemBy(lang).getData().toString();
        return !newName.equals(this.currentQuerySolutionInfo.getName());
    }

    private boolean isSharedSolution() {
        return ShareTypeEnum.ORG_LEVEL.equals((Object)this.currentQuerySolutionInfo.getShareType());
    }

    private boolean isOwned() {
        return SysContext.getSysContext().getCurrentUserInfo().getId().equals((Object)this.currentQuerySolutionInfo.getOwner());
    }

    protected boolean saveSolution() {
        try {
            String solutionName = this.solutionNameTextField.getSelectedItem().toString();
            NewSolutionPromptUI newSolutionPromptUI = this;
            Locale l = ((LanguageInfo)newSolutionPromptUI.solutionNameTextField.getLanguageList().get(this.solutionNameTextField.getSelectedIndex())).getLocale();
            String sysDefaultSolutionName = ResourceBase.getString((String)commonQueryRes, (String)"sysDefaultRule", (Locale)l);
            if (StringUtils.equals((String)sysDefaultSolutionName, (String)solutionName)) {
                throw new BaseCommonQueryAppException(BaseCommonQueryAppException.NAME_IS_EXISTED);
            }
            if (StringUtils.isEmpty((String)solutionName)) {
                MsgBox.showWarning((String)EASResource.getString((String)solutionDialogRes, (String)"solutionNameIsNull"));
                SysUtil.abort();
            }
            if (this.isSharedSolution() && !this.isOwned() && !this.isAddNew()) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getCQResource("canNotChangeOthersSolution"));
                return false;
            }
            QuerySolutionInfo querySolutionInfo = null;
            if (this.isAddNew()) {
                querySolutionInfo = new QuerySolutionInfo();
                UIHelper.storeMultiLangFields((KDMultiLangBox)this.solutionNameTextField, (IObjectValue)querySolutionInfo, (String)"name");
                BOSUuid owner = SysContext.getSysContext().getCurrentUserInfo().getId();
                querySolutionInfo.setOwner(owner);
            } else {
                querySolutionInfo = this.currentQuerySolutionInfo;
            }
            IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
            boolean isOrgIsolation = this.isOrgIsolationBox.isSelected();
            String queryObjectName = this.commonQueryPanel.getQueryPK().getFullName();
            BOSUuid orgID = Util.getOrgIDOld(queryObjectName);
            if (this.isSharedSolution()) {
                if (isOrgIsolation) {
                    querySolutionInfo.setOrgID(orgID);
                }
                querySolutionInfo.setShareType(ShareTypeEnum.ORG_LEVEL);
            } else {
                if (isOrgIsolation) {
                    querySolutionInfo.setOrgID(orgID);
                    querySolutionInfo.setShareType(ShareTypeEnum.USER_LEVEL);
                } else {
                    querySolutionInfo.setShareType(ShareTypeEnum.USER_NOORG_LEVEL);
                }
                if (!this.isAddNew()) {
                    querySolutionInfo.setIsUserDefaultSolu(this.commonQueryPanel.isDefaultView());
                }
            }
            querySolutionInfo.setQueryObjectName(queryObjectName);
            querySolutionInfo.setEntityViewInfo(this.commonQueryPanel.getEntityViewInfo().toString());
            querySolutionInfo.setLockedEntityViewInfo(this.commonQueryPanel.getLockedEntityViewInfo().toString());
            querySolutionInfo.setSolutionType(SolutionTypeEnum.CUSTOMER_SOLUTION);
            String parentUIName = this.commonQueryPanel.getParentUIClassName();
            querySolutionInfo.setParentUIName(parentUIName);
            querySolutionInfo.setTableParams(this.getTableParams());
            QueryPanelCollection queryPanelCollection = NewSolutionPromptUI.getQueryPanelCollection(this.commonQueryPanel);
            if (this.getCommonQueryPanel().isDisShowRowCount()) {
                querySolutionInfo.setRowCount(-1);
            } else {
                querySolutionInfo.setRowCount(this.commonQueryPanel.getRowCount());
            }
            querySolutionInfo.setDynQuery(this.commonQueryPanel.getDynQuerySolutionInfo());
            boolean isSetNotDefault = false;
            QuerySolutionInfo defaultSolution = (QuerySolutionInfo)this.getUIContext().get("defaultSolution");
            if (this.isAddNew()) {
                querySolutionInfo.getQueryPanelInfo().addCollection(queryPanelCollection);
                isSetNotDefault = this.confimSaveSolution(defaultSolution, querySolutionInfo);
                IObjectPK objectPK = iQuerySolution.addnew((CoreBaseInfo)querySolutionInfo);
                querySolutionInfo.setId(BOSUuid.read((String)objectPK.toString()));
            } else {
                querySolutionInfo.getQueryPanelInfo().clear();
                querySolutionInfo.getQueryPanelInfo().addCollection(queryPanelCollection);
                isSetNotDefault = this.confimSaveSolution(defaultSolution, querySolutionInfo);
                iQuerySolution.update((IObjectPK)new ObjectUuidPK(querySolutionInfo.getId()), (CoreBaseInfo)querySolutionInfo);
            }
            if (isSetNotDefault) {
                this.setNotDefaultSolution(defaultSolution, false);
            }
            this.getUIContext().put(RESULTSOLUTION, querySolutionInfo);
            this.getCommonQueryPanel().showInfo(EASResource.getString((String)toolBarRes, (String)"saveSolutionSucceed"), "info");
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)toolBarRes, (String)"saveSolutionFail"), (Throwable)e);
            return false;
        }
    }

    private boolean confimSaveSolution(QuerySolutionInfo defaultSolution, QuerySolutionInfo querySolutionInfo) {
        if (defaultSolution != null && this.isDefaultSoltion(querySolutionInfo, true) && (querySolutionInfo.getId() != null && !querySolutionInfo.getId().toString().equals(defaultSolution.getId().toString()) || querySolutionInfo.getId() == null)) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"SET_DEFAULT_SOLUTION_MSG", (Object[])new String[]{defaultSolution.getName(), querySolutionInfo.getName()});
            if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)msg))) {
                return true;
            }
            SysUtil.abort();
        }
        return false;
    }

    private void setNotDefaultSolution(QuerySolutionInfo info, boolean isFullQuery) {
        if (!isFullQuery && info.getId() != null && SolutionTypeEnum.SYSTEM_SOLUTION != info.getSolutionType()) {
            try {
                info = QuerySolutionUtils.getFullQuerySolution(null, (String)info.getId().toString());
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        QueryPanelCollection queryPanelColl = info.getQueryPanelInfo();
        try {
            for (int i = 0; i < queryPanelColl.size(); ++i) {
                QueryPanelInfo queryPanelInfo = queryPanelColl.get(i);
                if (queryPanelInfo == null || queryPanelInfo.getCustomerParams() == null || !queryPanelInfo.getQueryPanelType().equals((Object)QueryPanelTypeEnum.CUSTOMER_PANEL)) continue;
                String customerParams = queryPanelInfo.getCustomerParams();
                CustomerParams cp = new CustomerParams();
                cp = XMLBean.transStrToCommonCustParams((String)customerParams);
                if (cp == null) continue;
                boolean isDefaultSolution = cp.getBoolean("isDefaultSolution");
                if (isDefaultSolution) {
                    cp.putBoolean("isDefaultSolution", false);
                }
                Collection keys = cp.getKeys();
                Collection values = cp.getValues();
                if (keys.size() > 0) {
                    customerParams = XMLBean.CreateXMLStrRecursion((Collection)keys, (Collection)values);
                }
                queryPanelInfo.setCustomerParams(customerParams);
            }
            IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
            SelectorItemCollection select = new SelectorItemCollection();
            select.add(new SelectorItemInfo("QueryPanelInfo.*"));
            iQuerySolution.updatePartial((CoreBaseInfo)info, select);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private boolean isDefaultSoltion(QuerySolutionInfo info, boolean isFullQuery) {
        if (!isFullQuery && info.getId() != null && SolutionTypeEnum.SYSTEM_SOLUTION != info.getSolutionType()) {
            try {
                info = QuerySolutionUtils.getFullQuerySolution(null, (String)info.getId().toString());
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        QueryPanelCollection queryPanelColl = info.getQueryPanelInfo();
        for (int i = 0; i < queryPanelColl.size(); ++i) {
            QueryPanelInfo queryPanelInfo = queryPanelColl.get(i);
            if (queryPanelInfo == null || queryPanelInfo.getCustomerParams() == null || !queryPanelInfo.getQueryPanelType().equals((Object)QueryPanelTypeEnum.CUSTOMER_PANEL)) continue;
            String customerParams = queryPanelInfo.getCustomerParams();
            CustomerParams cp = new CustomerParams();
            try {
                cp = XMLBean.transStrToCommonCustParams((String)customerParams);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            if (cp == null) continue;
            boolean isDefaultSolution = cp.getBoolean("isDefaultSolution");
            return isDefaultSolution;
        }
        return false;
    }

    public CommonQueryPanel getCommonQueryPanel() {
        return this.commonQueryPanel;
    }

    public String getTableParams() {
        if (this.getCommonQueryPanel().getCommonTablePanel() != null) {
            return this.getCommonQueryPanel().getCommonTablePanel().getTableParams();
        }
        return "";
    }

    public static QueryPanelCollection getQueryPanelCollection(CommonQueryPanel commonQueryPanel) throws Exception {
        QueryPanelCollection queryPanelCollection = new QueryPanelCollection();
        String panelName = null;
        String panelClassName = null;
        String filterInfo = "";
        String sorterInfo = "";
        QueryPanelTypeEnum queryPanelType = null;
        for (Object object : commonQueryPanel.getPanels().values()) {
            FilterInfo temp;
            QueryPanelInfo queryPanelInfo = new QueryPanelInfo();
            if (object == null) continue;
            if (object instanceof IQueryInfoPanel) {
                IQueryInfoPanel iQueryInfoPanel = (IQueryInfoPanel)object;
                panelName = iQueryInfoPanel.getPanelName();
                com.kingdee.eas.base.commonquery.client.CustomerParams cp = new com.kingdee.eas.base.commonquery.client.CustomerParams();
                cp = iQueryInfoPanel.getCustomerParams();
                String customerParams = null;
                if (cp != null) {
                    Collection keys = cp.getKeys();
                    Collection values = cp.getValues();
                    if (keys.size() > 0) {
                        customerParams = XMLBean.CreateXMLStrRecursion((Collection)keys, (Collection)values);
                    }
                }
                queryPanelInfo.setCustomerParams(customerParams);
                panelClassName = object.getClass().getName();
                if (iQueryInfoPanel.getSorterItems() != null) {
                    String oql = EntityViewInfo.toOQL((SorterItemCollection)iQueryInfoPanel.getSorterItems());
                    if (!(oql == null || oql.trim().equalsIgnoreCase("") || oql.indexOf("ORDER") != -1 && oql.indexOf("order") != -1)) {
                        oql = "ORDER BY " + oql;
                    }
                    sorterInfo = oql;
                }
                if (iQueryInfoPanel.getFilterInfo() != null) {
                    filterInfo = iQueryInfoPanel.getFilterInfo().toString();
                }
                queryPanelType = QueryPanelTypeEnum.CUSTOMER_PANEL;
            } else if (object instanceof IFilterPanel) {
                IFilterPanel iFilterPanel = (IFilterPanel)object;
                panelName = iFilterPanel.getPanelName();
                panelClassName = object.getClass().getName();
                temp = commonQueryPanel.getCommonFilterPanel().getFilterInfo();
                if (temp != null) {
                    filterInfo = temp.toString();
                }
                queryPanelType = QueryPanelTypeEnum.FILTER_PANEL;
                queryPanelInfo.setMaskString(temp.getMaskString());
            } else if (object instanceof ISorterPanel) {
                ISorterPanel iSorterPanel = (ISorterPanel)object;
                panelName = iSorterPanel.getPanelName();
                panelClassName = object.getClass().getName();
                temp = commonQueryPanel.getCommonSorterPanel().getSorterItems();
                if (temp != null) {
                    String oql = EntityViewInfo.toOQL((SorterItemCollection)temp);
                    if (!(oql == null || oql.trim().equalsIgnoreCase("") || oql.indexOf("ORDER") != -1 && oql.indexOf("order") != -1)) {
                        oql = "ORDER BY " + oql;
                    }
                    sorterInfo = oql;
                }
                queryPanelType = QueryPanelTypeEnum.SORTER_PANEL;
            } else if (object instanceof CommonTablePanel) {
                queryPanelType = QueryPanelTypeEnum.TABLE_PANEl;
                panelClassName = CommonTablePanel.class.getName();
                panelName = QueryPanelTypeEnum.TABLE_PANEl.getAlias();
                filterInfo = "";
                sorterInfo = "";
            }
            KDBizMultiLangBox solutionNameTextField = new KDBizMultiLangBox();
            List langList = KDBizMultiLangBox.getLanguageList();
            for (int i = 0; i < langList.size(); ++i) {
                if (!SysContext.getSysContext().getLocale().toString().equalsIgnoreCase(((LanguageInfo)langList.get(i)).getLocale().toString())) continue;
                solutionNameTextField.setSelectedLanguage((LanguageInfo)langList.get(i));
            }
            solutionNameTextField.getEditor().setItem(panelName);
            UIHelper.storeMultiLangFields((KDMultiLangBox)solutionNameTextField, (IObjectValue)queryPanelInfo, (String)"panelName");
            queryPanelInfo.setPanelClassName(panelClassName);
            queryPanelInfo.setFilterInfo(filterInfo);
            queryPanelInfo.setSorterInfo(sorterInfo);
            queryPanelInfo.setParam(null);
            queryPanelInfo.setQueryPanelType(queryPanelType);
            queryPanelCollection.add(queryPanelInfo);
        }
        return queryPanelCollection;
    }
}

