/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client.contrastGLDefaultSol;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.eas.base.commonquery.client.CommonFilterPanel;
import com.kingdee.eas.base.commonquery.client.DataObject;
import com.kingdee.eas.base.commonquery.client.QueryTreeView;
import com.kingdee.eas.fi.ar.client.contrastGLDefaultSol.CommonQueryPanel;
import com.kingdee.eas.fi.ar.client.contrastGLDefaultSol.Util;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class QueryTreePanel
extends KDPanel {
    private Logger logger = Logger.getLogger(QueryTreePanel.class);
    QueryTreeView treeView;
    KDTree tree;
    MetaDataPK queryInfo;
    CommonQueryPanel commonQueryPanel;
    int SPACE = 3;
    int BUTTON_HEIGHT = 20;

    private QueryTreePanel(CommonQueryPanel commonQueryPanel) {
        this.commonQueryPanel = commonQueryPanel;
        this.queryInfo = commonQueryPanel.getQueryPK();
    }

    public static QueryTreePanel createInstance(CommonQueryPanel commonQueryPanel) {
        QueryTreePanel p = new QueryTreePanel(commonQueryPanel);
        boolean success = p.init();
        if (success) {
            return p;
        }
        return null;
    }

    private boolean init() {
        KDTreeNode root = null;
        try {
            root = Util.getQueryFilterTreeNode(this.queryInfo);
        }
        catch (Exception e) {
            this.logger.error((Object)"", (Throwable)e);
            ExceptionHandler.handle((Throwable)e);
        }
        if (root == null) {
            return false;
        }
        this.tree = new KDTree((ITreeNode)root);
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                QueryTreePanel.this.treeClickEvent(e);
            }
        });
        this.tree.setShowCheckBox(false);
        this.treeView = new QueryTreeView(this.tree, this.commonQueryPanel.getLeftPanelWidth() - this.SPACE * 2, this.commonQueryPanel.getLeftPanelHeight() - this.SPACE * 3 - 3 * this.BUTTON_HEIGHT);
        this.treeView.setSize(100, 100);
        this.treeView.setShowButton(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.treeView, "North");
        return true;
    }

    public void treeClickEvent(MouseEvent e) {
        if (e.getButton() != 1 || e.getClickCount() != 2) {
            return;
        }
        KDTree tree = (KDTree)e.getSource();
        TreePath treePath = tree.getPathForLocation(e.getX(), e.getY());
        if (treePath == null) {
            return;
        }
        KDTreeNode selectedNode = (KDTreeNode)treePath.getLastPathComponent();
        if (!selectedNode.isLeaf() || !(selectedNode.getUserObject() instanceof DataObject)) {
            return;
        }
        DataObject dataObject = (DataObject)selectedNode.getUserObject();
        Component selectedPanel = this.commonQueryPanel.getTabbedPanel().getSelectedComponent();
        if (selectedPanel instanceof CommonFilterPanel) {
            this.commonQueryPanel.getCommonFilterPanel().insertNewRow(dataObject);
        }
    }
}

