/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client.util;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.math.BigDecimal;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;

public class ArApValidateHelper {
    public static void validateContainer(Container container) throws EASBizException {
        int j;
        Component[] bizCtrls = container.getComponents();
        KDTabbedPane kdPane = null;
        String text = "";
        for (j = 0; j < bizCtrls.length; ++j) {
            if (!(bizCtrls[j] instanceof KDLabel)) continue;
            KDLabel label = (KDLabel)bizCtrls[j];
            text = label.getText();
        }
        for (j = 0; j < bizCtrls.length; ++j) {
            KDTextField textField;
            if (ArApValidateHelper.isRequiredVerify(bizCtrls[j]) && bizCtrls[j] instanceof IKDEditor && ((IKDEditor)bizCtrls[j]).getValue() == null) {
                ArApValidateHelper.setSelectedContainer(bizCtrls[j]);
                ((JComponent)bizCtrls[j]).requestFocus();
                throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{text});
            }
            if (bizCtrls[j] instanceof KDTextField && ArApValidateHelper.isRequiredVerify((Component)(textField = (KDTextField)bizCtrls[j])) && StringUtils.isEmpty((String)textField.getText())) {
                kdPane = ArApValidateHelper.setSelectedContainer(bizCtrls[j]);
                if (kdPane == null && bizCtrls[j].getParent() != null && bizCtrls[j].getParent().getParent() != null && bizCtrls[j].getParent().getParent() instanceof KDLabelContainer) {
                    KDLabelContainer labContainer = (KDLabelContainer)bizCtrls[j].getParent().getParent();
                    text = labContainer.getBoundLabelText();
                }
                textField.requestFocus();
                throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{text});
            }
            if (bizCtrls[j] instanceof KDTable) {
                KDTable table = (KDTable)bizCtrls[j];
                ArApValidateHelper.verifyTable(table);
            }
            if (!(bizCtrls[j] instanceof Container)) continue;
            ArApValidateHelper.validateContainer((Container)bizCtrls[j]);
        }
    }

    private static void verifyTable(KDTable table) throws EASBizException {
        IRow headRow = table.getHeadRow(0);
        table.getEditManager().stopEditing();
        int rowCount = table.getRowCount();
        int columnCount = table.getColumnCount();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            for (int colIndex = 0; colIndex < columnCount; ++colIndex) {
                ICell cell = table.getCell(rowIndex, colIndex);
                if (!table.getRequiredColor().equals(cell.getStyleAttributes().getBackground()) || cell.getStyleAttributes().isHided() || cell.getValue() != null) continue;
                ArApValidateHelper.setSelectedContainer((Component)table);
                table.getEditManager().editCellAt(rowIndex, colIndex);
                String text = headRow.getCell(colIndex).getValue().toString();
                if (EASResource.getString((String)"com.kingdee.eas.fi.ar.ArAllResource", (String)"apSubject").equals(text)) continue;
                throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{text});
            }
        }
    }

    public static void compareTotalValue(KDTable table, String colName, BigDecimal totalValue) {
        BigDecimal colTotalValue = ArApBillUIUtil.getTotalValue(table, colName);
        if (colTotalValue.compareTo(totalValue) != 0) {
            // empty if block
        }
    }

    private static KDTabbedPane setSelectedContainer(Component component) {
        if (component == null) {
            return null;
        }
        if (component.getParent() instanceof KDTabbedPane) {
            ((KDTabbedPane)component.getParent()).setSelectedComponent(component);
            return (KDTabbedPane)component.getParent();
        }
        ArApValidateHelper.setSelectedContainer(component.getParent());
        return null;
    }

    private static boolean isRequiredVerify(Component component) {
        if (component instanceof IKDTextComponent) {
            IKDTextComponent iTextComp = (IKDTextComponent)component;
            return iTextComp.isRequired() && iTextComp.isEnabled() && iTextComp.isEditable() && iTextComp.getAccessAuthority() == 0;
        }
        return false;
    }

    public static void validateFormattedTextField(JFormattedTextField txtField) throws EASBizException {
        Component[] bizCtrls = txtField.getParent().getComponents();
        String text = "";
        for (int j = 0; j < bizCtrls.length; ++j) {
            if (!(bizCtrls[j] instanceof KDLabel)) continue;
            KDLabel label = (KDLabel)bizCtrls[j];
            text = label.getText();
        }
        if (txtField.getValue() == null) {
            txtField.requestFocus();
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{text});
        }
    }
}

