/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.ARAccountAnalysisParamsCollection;
import com.kingdee.eas.fi.ap.ARAccountAnalysisParamsFactory;
import com.kingdee.eas.fi.ap.AccountBadDebtMethodEnum;
import com.kingdee.eas.fi.ap.ApOtherParamsCollection;
import com.kingdee.eas.fi.ap.ApOtherParamsFactory;
import com.kingdee.eas.fi.ap.IARAccountAnalysisParams;
import com.kingdee.eas.fi.ap.IApOtherParams;
import com.kingdee.eas.fi.ap.PrepareOptionMethodEnum;
import com.kingdee.eas.fi.ar.AccountBadDebtException;
import com.kingdee.eas.fi.ar.ArBalanceFactory;
import com.kingdee.eas.fi.ar.ArBalanceInfo;
import com.kingdee.eas.fi.ar.BadAccountFacadeFactory;
import com.kingdee.eas.fi.ar.FinishArInitFacadeFactory;
import com.kingdee.eas.fi.ar.IArBalance;
import com.kingdee.eas.fi.ar.IBadAccountFacade;
import com.kingdee.eas.fi.ar.IFinishArInitFacade;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.client.util.CommonClientUtils;
import com.kingdee.eas.fi.arap.client.KDTableUtils;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public class ArClientUtils {
    private static String arResource = "com.kingdee.eas.fi.ar.client.ArResource";
    private static final String VOUCHERTYPE = "2652E01E";
    private static IBadAccountFacade iBadAccountFacade = null;

    public static String getArStringResource(String key) {
        return EASResource.getString((String)arResource, (String)key);
    }

    public static String getArStringResource(String key, Object ... args) {
        String pattern = ArClientUtils.getArStringResource(key);
        return MessageFormat.format(pattern, args);
    }

    public static SystemStatusCtrolInfo getArStatusCtrolInfo(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException {
        SystemStatusCtrolInfo systmSttsCtrlInf = CommonClientUtils.getSysStatusCtrolInfo(cmpnyOrgUntInfObj, SystemEnum.ACCOUNTSRECEIVABLE);
        return systmSttsCtrlInf;
    }

    public static PeriodInfo getArCurrentPeriod(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)cmpnyOrgUntInfObj);
    }

    public static PeriodInfo getArCurrentPeriod(IObjectPK companyPK) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (IObjectPK)companyPK);
    }

    public static PeriodInfo getArCurrentPeriod() {
        try {
            CompanyOrgUnitInfo company = CommonClientUtils.getCurrentCompany();
            return ArClientUtils.getArCurrentPeriod(company);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    public static PeriodInfo getArStartPeriod(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)cmpnyOrgUntInfObj);
    }

    public static PeriodInfo getArStartPeriod(IObjectPK companyPK) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (IObjectPK)companyPK);
    }

    public static PeriodInfo getArStartPeriod() throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = CommonClientUtils.getCurrentCompany();
        PeriodInfo startPeriod = ArClientUtils.getArStartPeriod(company);
        return startPeriod;
    }

    public static boolean arIsStart(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)cmpnyOrgUntInfObj);
    }

    public static boolean glIsStart(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws EASBizException, BOSException {
        return SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)cmpnyOrgUntInfObj);
    }

    public static boolean arIsStart() throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = CommonClientUtils.getCurrentCompany();
        if (company == null) {
            throw new IllegalArgumentException("Current company is null!");
        }
        return ArClientUtils.arIsStart(company);
    }

    public static void arStart(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        CompanyOrgUnitInfo cmpnyOrgUntInf = cmpnyOrgUntInfObj;
        ISystemStatusCtrol systemStatusCtrol = SystemStatusCtrolFactory.getRemoteInstance();
        systemStatusCtrol.start(SystemEnum.ACCOUNTSRECEIVABLE, cmpnyOrgUntInf, true);
    }

    public static void arReverseStart(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        CompanyOrgUnitInfo cmpnyOrgUntInf = cmpnyOrgUntInfObj;
        ISystemStatusCtrol systemStatusCtrol = SystemStatusCtrolFactory.getRemoteInstance();
        systemStatusCtrol.start(SystemEnum.ACCOUNTSRECEIVABLE, cmpnyOrgUntInf, false);
    }

    public static boolean arIsRelatedAccount(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.isRelAccount(null, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)cmpnyOrgUntInfObj);
    }

    public static boolean arIsRelatedAccount() throws BOSException, EASBizException {
        return ArClientUtils.arIsRelatedAccount(CommonClientUtils.getCurrentCompany());
    }

    public static PeriodInfo getArRelatedPeriod() throws BOSException, EASBizException {
        CompanyOrgUnitInfo cmpnyOrgUntInfObj = CommonClientUtils.getCurrentCompany();
        return ArClientUtils.getArRelatedPeriod(cmpnyOrgUntInfObj);
    }

    public static PeriodInfo getArRelatedPeriod(CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systmStsCtrlInf = ArClientUtils.getArStatusCtrolInfo(company);
        if (systmStsCtrlInf != null) {
            return systmStsCtrlInf.getRelatedPeriod();
        }
        return null;
    }

    public static boolean auditReceiveBill(String id) {
        try {
            IFinishArInitFacade fnshArIntFcd = FinishArInitFacadeFactory.getRemoteInstance();
            HashMap<String, String[]> userContext = new HashMap<String, String[]>();
            String[] ids = new String[]{id};
            userContext.put("ID_LIST", ids);
            return fnshArIntFcd.auditReceiveBill(userContext);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
    }

    public BigDecimal getArEndBalance(int balanceType, CompanyOrgUnitInfo company, AsstActTypeInfo astActTypInf, String astActValue, CurrencyInfo currency, PeriodInfo currentPeriod) {
        try {
            IArBalance arBalance = ArBalanceFactory.getRemoteInstance();
            String oql = "select Fendbalancefor from T_AR_ArBalance  where FcompanyID = \"" + company.getId() + '\"' + " and FcurrencyID =  " + '\"' + currency.getId() + '\"' + " and FBalType =  " + balanceType + " and FAsstActTypeID = " + '\"' + astActTypInf.getId() + '\"' + " and FAsstActID = " + '\"' + astActValue + '\"' + " and FPeriodID = " + '\"' + currentPeriod.getId() + '\"';
            CoreBaseCollection arBlncClctn = arBalance.getCollection(oql);
            if (arBlncClctn != null && arBlncClctn.size() == 0) {
                return new BigDecimal(0);
            }
            if (arBlncClctn != null && arBlncClctn.size() == 1) {
                ArBalanceInfo arBalanceInfo = (ArBalanceInfo)arBlncClctn.get(0);
                return arBalanceInfo.getEndBalanceFor();
            }
            throw new IllegalArgumentException();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    public static Map getCountBadDebtMethodOptions() {
        try {
            IBadAccountFacade badAccountFacade = BadAccountFacadeFactory.getRemoteInstance();
            CompanyOrgUnitInfo company = CommonClientUtils.getCurrentCompany();
            HashMap params = badAccountFacade.getParams(company);
            params.size();
            return params;
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    public static AccountBadDebtMethodEnum getAccountBadDebtMethod(Map value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (value.size() <= 0) {
            throw new IllegalArgumentException();
        }
        String methodString = (String)value.get("arap001");
        return AccountBadDebtMethodEnum.getEnum(methodString);
    }

    public static PrepareOptionMethodEnum getPrepareOptionMethod(Map value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (value.size() <= 0) {
            throw new IllegalArgumentException();
        }
        String methodString = (String)value.get("arap003");
        return PrepareOptionMethodEnum.getEnum(methodString);
    }

    public static AccountViewInfo getBadDebtLossAccount(Map value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (value.size() <= 0) {
            throw new IllegalArgumentException();
        }
        try {
            ParamItemInfo accountIDItem = (ParamItemInfo)value.get("arap001001");
            String accountIDString = accountIDItem.getValue();
            BOSUuid accountID = BOSUuid.read((String)accountIDString);
            ObjectUuidPK accountPK = new ObjectUuidPK(accountID);
            AccountViewInfo account = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)accountPK);
            return account;
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    public static AccountViewInfo getBadDebtPrepareAccount(Map value) throws BOSException, EASBizException {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (value.size() <= 0) {
            throw new IllegalArgumentException();
        }
        iBadAccountFacade = BadAccountFacadeFactory.getRemoteInstance();
        CompanyOrgUnitInfo curCompany = BaseDataUtil.getCompanyInfo();
        String accuralParam = iBadAccountFacade.getAccuralParam(curCompany);
        ParamItemInfo accountIDItem = null;
        if (accuralParam.equalsIgnoreCase(String.valueOf(2))) {
            if (value.get("arap001002002004") != null) {
                accountIDItem = (ParamItemInfo)value.get("arap001002002004");
            }
        } else if (accuralParam.equalsIgnoreCase(String.valueOf(6))) {
            if (value.get("arap001002002") != null) {
                accountIDItem = (ParamItemInfo)value.get("arap001002002");
            }
        } else if (accuralParam.equalsIgnoreCase(String.valueOf(5))) {
            if (value.get("arap001002002002") != null) {
                accountIDItem = (ParamItemInfo)value.get("arap001002002002");
            }
        } else if (accuralParam.equalsIgnoreCase(String.valueOf(3))) {
            if (value.get("arap001002003") != null) {
                accountIDItem = (ParamItemInfo)value.get("arap001002003");
            }
        } else if (accuralParam.equalsIgnoreCase(String.valueOf(1)) && value.get("arap001001001") != null) {
            accountIDItem = (ParamItemInfo)value.get("arap001001001");
        }
        if (accountIDItem == null) {
            throw new AccountBadDebtException(AccountBadDebtException.PREPARE_SUBJECT_NOT_EXISTS);
        }
        String accountIDString = "";
        if (accountIDItem.getValue() != null) {
            accountIDString = accountIDItem.getValue();
        } else {
            MsgBox.showInfo((String)ArClientUtils.getArStringResource("param_not_exist"));
            SysUtil.abort();
        }
        BOSUuid accountID = BOSUuid.read((String)accountIDString);
        ObjectUuidPK accountPK = new ObjectUuidPK(accountID);
        AccountViewInfo account = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)accountPK);
        return account;
    }

    public static AccountViewInfo getBadDebtPrepareAccount(Map value, String key) throws BOSException, EASBizException {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (value.size() <= 0) {
            throw new IllegalArgumentException();
        }
        iBadAccountFacade = BadAccountFacadeFactory.getRemoteInstance();
        ParamItemInfo accountIDItem = null;
        accountIDItem = (ParamItemInfo)value.get(key);
        if (accountIDItem == null) {
            throw new AccountBadDebtException(AccountBadDebtException.PREPARE_SUBJECT_NOT_EXISTS);
        }
        String accountIDString = "";
        if (accountIDItem.getValue() != null) {
            accountIDString = accountIDItem.getValue();
        } else {
            MsgBox.showInfo((String)ArClientUtils.getArStringResource("param_not_exist"));
            SysUtil.abort();
        }
        BOSUuid accountID = BOSUuid.read((String)accountIDString);
        ObjectUuidPK accountPK = new ObjectUuidPK(accountID);
        AccountViewInfo account = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)accountPK);
        return account;
    }

    public static ApOtherParamsCollection getCountBadDebtAccounts() throws BOSException {
        IApOtherParams apOtherParams = ApOtherParamsFactory.getRemoteInstance();
        CompanyOrgUnitInfo company = CommonClientUtils.getCurrentCompany();
        ApOtherParamsCollection apOthrPrmsClctn = apOtherParams.getApOtherParamsCollection("select *,account.* where company='" + company.getId() + "'");
        return apOthrPrmsClctn;
    }

    public static ARAccountAnalysisParamsCollection getARAccountAnalysisParams() throws BOSException {
        IARAccountAnalysisParams iARAccountAnalysisParams = ARAccountAnalysisParamsFactory.getRemoteInstance();
        CompanyOrgUnitInfo company = CommonClientUtils.getCurrentCompany();
        ARAccountAnalysisParamsCollection accountAnalysisParamsCollection = null;
        EntityViewInfo view = new EntityViewInfo();
        view.getSorter().add(new SorterItemInfo("startDay"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isBill", (Object)"1"));
        filter.setMaskString(" (#0 and #1)");
        view.setFilter(filter);
        accountAnalysisParamsCollection = iARAccountAnalysisParams.getARAccountAnalysisParamsCollection(view);
        return accountAnalysisParamsCollection;
    }

    public static CurrencyInfo getIntegrateLocalCurrency() throws BOSException {
        ICurrency iCurr = CurrencyFactory.getRemoteInstance();
        CurrencyCollection currCollection = iCurr.getCurrencyCollection("select * where isoCode = 'GLC'");
        return currCollection.get(0);
    }

    public static String getCurrPrecision() throws BOSException {
        StringBuffer currPrecision = new StringBuffer("%r-[=]{#,##0.");
        CurrencyInfo integrateLocalCurrency = ArClientUtils.getIntegrateLocalCurrency();
        for (int i = 0; i < integrateLocalCurrency.getPrecision(); ++i) {
            currPrecision.append("0");
        }
        currPrecision.append("}f");
        return currPrecision.toString();
    }

    public static String getNumPrecision() {
        StringBuffer numPrecision = new StringBuffer("%r-[=]{#,##0.0000}f");
        return numPrecision.toString();
    }

    public static VoucherInfo getVoucherInfo(String billId) throws EASBizException, BOSException {
        VoucherInfo voucher = null;
        IBOTRelation iBotRelation = BOTRelationFactory.getRemoteInstance();
        IVoucher iVoucher = VoucherFactory.getRemoteInstance();
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer sbMaskString = new StringBuffer();
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)billId));
        filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)VOUCHERTYPE));
        filter.setMaskString(sbMaskString.toString());
        entityView.setFilter(filter);
        BOTRelationCollection relationCollection = iBotRelation.getCollection(entityView);
        if (relationCollection.size() > 0) {
            for (BOTRelationInfo relationInfo : relationCollection) {
                String voucherId = relationInfo.getDestObjectID();
                voucher = (VoucherInfo)iVoucher.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)voucherId)));
            }
        }
        return voucher;
    }

    public static FilterInfo getDataAssignFilter(String tblName, String cuId, String companyId) throws BOSException, EASBizException {
        if (tblName == null) {
            return null;
        }
        FilterInfo filter = null;
        ObjectUuidPK cuPK = new ObjectUuidPK(cuId);
        tblName = tblName.toLowerCase();
        boolean fCusSup = false;
        if (tblName.indexOf("customer") != -1) {
            fCusSup = true;
            ICustomer iCust = CustomerFactory.getRemoteInstance();
            filter = iCust.getDatabaseDFilter((IObjectPK)cuPK, "id", "adminCU.id");
        } else if (tblName.indexOf("supplier") != -1) {
            fCusSup = true;
            ISupplier iSupp = SupplierFactory.getRemoteInstance();
            filter = iSupp.getDatabaseDFilter((IObjectPK)cuPK, "id", "adminCU.id");
        } else if (tblName.indexOf("material") != -1) {
            IMaterial iMater = MaterialFactory.getRemoteInstance();
            filter = iMater.getDatabaseDFilter((IObjectPK)cuPK, "id", "adminCU.id");
        }
        if (fCusSup) {
            FilterInfo comFilter = new FilterInfo();
            FilterItemInfo item = new FilterItemInfo("companyOrgUnit.id", (Object)companyId);
            comFilter.getFilterItems().add(item);
            comFilter.mergeFilter(filter, "and");
            return comFilter;
        }
        return filter;
    }

    public static KDFormattedTextField getFormattedTextField(int precision, boolean isNegatived) {
        return KDTableUtils.getBigDecimalTextField(precision, isNegatived);
    }

    public static String getNumberFormat(int precision) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < precision; ++i) {
            buffer.append("0");
        }
        String precisionTag = buffer.toString();
        if (precisionTag.length() > 0) {
            precisionTag = "." + precisionTag;
        }
        String format = "#,##0" + precisionTag;
        return format;
    }

    public static PeriodInfo getSCMStartPeriod(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systmStsCtrlInf = ArClientUtils.getSCMStatusCtrolInfo(cmpnyOrgUntInfObj);
        if (systmStsCtrlInf != null) {
            return systmStsCtrlInf.getStartPeriod();
        }
        return null;
    }

    public static SystemStatusCtrolInfo getSCMStatusCtrolInfo(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systmSttsCtrlInf = CommonClientUtils.getSysStatusCtrolInfo(cmpnyOrgUntInfObj, SystemEnum.INVENTORYMANAGEMENT);
        return systmSttsCtrlInf;
    }

    public static PeriodInfo getSCMCurrentPeriod(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systmStsCtrlInf = ArClientUtils.getSCMStatusCtrolInfo(cmpnyOrgUntInfObj);
        if (systmStsCtrlInf != null) {
            return systmStsCtrlInf.getCurrentPeriod();
        }
        return null;
    }

    public static boolean scmIsStart(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systmStsCtrlInf = ArClientUtils.getSCMStatusCtrolInfo(cmpnyOrgUntInfObj);
        if (systmStsCtrlInf != null) {
            return systmStsCtrlInf.isIsStart();
        }
        return false;
    }

    public static boolean isRecBillCreateVoucher(String sCompanyId) {
        ObjectUuidPK pk = new ObjectUuidPK(sCompanyId);
        int checkType = 0;
        try {
            checkType = Integer.parseInt(ParamManager.getParamValue(null, (IObjectPK)pk, (String)"AR_RECVOUCHER_BILLTYPE"));
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        return checkType != 0;
    }

    public static boolean iscashBillCreateVoucher(String sCompanyId) {
        ObjectUuidPK pk = new ObjectUuidPK(sCompanyId);
        int checkType = 0;
        try {
            checkType = Integer.parseInt(ParamManager.getParamValue(null, (IObjectPK)pk, (String)"AR_RECVOUCHER_BILLTYPE_CASH"));
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        return checkType != 0;
    }

    public static boolean isPreRecAcct(String sCompanyId) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(sCompanyId);
        String value = ParamManager.getParamValue(null, (IObjectPK)pk, (String)"AR_IS_PRE_REC_ACCT");
        return "true".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value);
    }

    public static boolean isArBillAuditNow(String sCompanyId) {
        return ArClientUtils.getBooleanParamValue(sCompanyId, "ARBILL_AUDIT_NOW");
    }

    public static boolean isProxyBillAuditNow(String sCompanyId) {
        return ArClientUtils.getBooleanParamValue(sCompanyId, "PROXYBILL_AUDIT_NOW");
    }

    public static boolean isRecBillAuditNow(String sCompanyId) {
        return ArClientUtils.getBooleanParamValue(sCompanyId, "RECBILL_AUDIT_NOW");
    }

    public static boolean getBooleanParamValue(String sCompanyId, String paramNumber) {
        ObjectUuidPK pk = new ObjectUuidPK(sCompanyId);
        String value = null;
        try {
            value = ParamManager.getParamValue(null, (IObjectPK)pk, (String)paramNumber);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        return "true".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value);
    }

    public static void setTableRowHide(KDTable kdtEntries, String[] rowNames, boolean isHide) {
        int n = rowNames.length;
        for (int i = 0; i < n; ++i) {
            if (rowNames[i] == null) continue;
            kdtEntries.getColumn(rowNames[i]).getStyleAttributes().setHided(isHide);
        }
    }

    public static void setTableRowLock(KDTable kdtEntries, String[] rowNames, boolean isLock) {
        int n = rowNames.length;
        for (int i = 0; i < n; ++i) {
            if (rowNames[i] == null || kdtEntries.getColumn(rowNames[i]) == null) continue;
            kdtEntries.getColumn(rowNames[i]).getStyleAttributes().setLocked(isLock);
        }
    }

    public static Map getCountBadDebtMethodOptions(CompanyOrgUnitInfo company) {
        try {
            IBadAccountFacade badAccountFacade = BadAccountFacadeFactory.getRemoteInstance();
            HashMap params = badAccountFacade.getParams(company);
            params.size();
            return params;
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }
}

