/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.vc.IVcScheme;
import com.kingdee.eas.base.vc.VcSchemeCollection;
import com.kingdee.eas.base.vc.VcSchemeFactory;
import com.kingdee.eas.base.vc.VcSchemeInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.IAccountTable;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.auxacct.IAsstActTypeDefault;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ap.client.util.ApClientUtils;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.ar.client.util.ComBoxInfo;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.util.CurrencyExchangeRateUtils;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BaseDataUtil {
    public static final BigDecimal ZERO = new BigDecimal("0.0");
    public static final String ASST_ACT_TYPE_ID = "BiCxYAETEADgBRfkCmQUDEc4VZA=";

    public static CompanyOrgUnitInfo getCompanyInfo() throws EASBizException, BOSException {
        CompanyOrgUnitInfo defalutOrgInfo = null;
        ObjectUuidPK compk = BaseDataUtil.getCompanyPK();
        ICompanyOrgUnit comorg = null;
        comorg = CompanyOrgUnitFactory.getRemoteInstance();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("accountBank.id"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("accountBank.number"));
        sic.add(new SelectorItemInfo("accountTable"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("accountTable.name"));
        sic.add(new SelectorItemInfo("baseCurrency"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("baseExchangeTable"));
        sic.add(new SelectorItemInfo("CU.*"));
        sic.add(new SelectorItemInfo("invalidDate"));
        sic.add(new SelectorItemInfo("isOnlyUnion"));
        defalutOrgInfo = comorg.getCompanyOrgUnitInfo((IObjectPK)compk, sic);
        return defalutOrgInfo;
    }

    public static ObjectUuidPK getCompanyPK() throws BOSException {
        CompanyOrgUnitInfo comobj = SysContext.getSysContext().getCurrentFIUnit();
        ObjectUuidPK compk = null;
        if (comobj == null) {
            throw new BOSException(BaseDataUtil.getStrResource("nullCompany"));
        }
        if (comobj.isIsOnlyUnion()) {
            throw new BOSException(BaseDataUtil.getStrResource("lab_company_isempty"));
        }
        compk = new ObjectUuidPK(BOSUuid.read((String)comobj.get("id").toString()));
        return compk;
    }

    public static void makeBillCurrency(KDComboBox comboCurrency) throws EASBizException, BOSException {
        ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
        CurrencyCollection currencyComList = iCurrency.getCurrencyCollection(true);
        if (currencyComList != null) {
            Object[] currList = new ComBoxInfo[currencyComList.size()];
            for (int i = 0; i < currencyComList.size(); ++i) {
                currList[i] = new ComBoxInfo((IObjectValue)currencyComList.get(i), "name");
            }
            comboCurrency.removeAllItems();
            comboCurrency.addItems(currList);
        }
    }

    public static void makeBillAsstActType(KDComboBox comboAsstActType) throws EASBizException, BOSException {
        String cpID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        BaseDataUtil.makeAsstActType(comboAsstActType, cpID);
    }

    public static void makeAsstActType(KDComboBox comboAsstActType, String cpID, boolean isIncludeAll, ArApSysParamInfo cache) throws BOSException, EASBizException {
        AsstActTypeCollection coll = new AsstActTypeCollection();
        if (cache == null) {
            IAsstActTypeDefault iAsstActType = AsstActTypeDefaultFactory.getRemoteInstance();
            AsstActTypeDefaultCollection asstActTypeColl = iAsstActType.getAsstActTypeDefaultCollection("select *,AsstActType.* where isAccountCussent = 1 and company.id = '" + cpID + "' ");
            for (int i = 0; i < asstActTypeColl.size(); ++i) {
                coll.add(asstActTypeColl.get(i).getAsstActType());
            }
        } else {
            coll = cache.getAsstActTypeColl();
        }
        Object defaultVal = null;
        int count = coll.size();
        Object[] cbi = null;
        cbi = isIncludeAll ? new ComBoxInfo[count + 1] : new ComBoxInfo[count];
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            AsstActTypeInfo value = coll.get(i);
            String asstActTypeID = value.getString("id");
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)value.getString("id")));
            if (list.contains(asstActTypeID)) continue;
            list.add(asstActTypeID);
            if (value.getName() == null) {
                value = AsstActTypeFactory.getRemoteInstance().getAsstActTypeInfo((IObjectPK)pk);
            }
            cbi[i] = new ComBoxInfo((IObjectValue)value, value.getName(), true);
        }
        if (isIncludeAll) {
            AsstActTypeInfo asstActTypeInfo = new AsstActTypeInfo();
            asstActTypeInfo.setId(BOSUuid.read((String)ASST_ACT_TYPE_ID));
            asstActTypeInfo.setName(ComBoxInfo.ITEM_ALL);
            cbi[count] = new ComBoxInfo((IObjectValue)asstActTypeInfo, asstActTypeInfo.getName(), true);
        }
        comboAsstActType.removeAllItems();
        comboAsstActType.addItems(cbi);
        if (defaultVal != null) {
            comboAsstActType.setSelectedItem(defaultVal);
        }
    }

    public static void makeAsstActType(KDComboBox comboAsstActType, String cpID, boolean isIncludeAll) throws BOSException, EASBizException {
        IAsstActTypeDefault iAsstActTypeDefault = AsstActTypeDefaultFactory.getRemoteInstance();
        AsstActTypeDefaultCollection asstActTypeColl = iAsstActTypeDefault.getAsstActTypeDefaultCollection("select *,AsstActType.* where isAccountCussent = 1 and company.id = '" + cpID + "' ");
        Object defaultVal = null;
        int count = asstActTypeColl.size();
        Object[] cbi = null;
        cbi = isIncludeAll ? new ComBoxInfo[count + 1] : new ComBoxInfo[count];
        ArrayList<String> list = new ArrayList<String>(count);
        IAsstActType iAsstActType = AsstActTypeFactory.getRemoteInstance();
        for (int i = 0; i < count; ++i) {
            AsstActTypeDefaultInfo value = asstActTypeColl.get(i);
            String asstActTypeID = value.getAsstActType().getString("id");
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)value.getAsstActType().getString("id")));
            if (list.contains(asstActTypeID)) continue;
            list.add(asstActTypeID);
            AsstActTypeInfo asstInfo = value.getAsstActType();
            if (asstInfo.getName() == null) {
                asstInfo = iAsstActType.getAsstActTypeInfo((IObjectPK)pk);
            }
            cbi[i] = new ComBoxInfo((IObjectValue)asstInfo, asstInfo.getName(), true);
            if (!value.isIsDefaultAccountReceivable()) continue;
            defaultVal = cbi[i];
        }
        if (isIncludeAll) {
            AsstActTypeInfo asstActTypeInfo = new AsstActTypeInfo();
            asstActTypeInfo.setId(BOSUuid.read((String)ASST_ACT_TYPE_ID));
            asstActTypeInfo.setName(ComBoxInfo.ITEM_ALL);
            cbi[count] = new ComBoxInfo((IObjectValue)asstActTypeInfo, asstActTypeInfo.getName(), true);
        }
        comboAsstActType.removeAllItems();
        comboAsstActType.addItems(cbi);
        if (defaultVal != null) {
            comboAsstActType.setSelectedItem(defaultVal);
        }
    }

    public static void makeAsstActType(KDComboBox comboAsstActType, String cpID) throws BOSException, EASBizException {
        BaseDataUtil.makeAsstActType(comboAsstActType, cpID, false);
    }

    public static AsstActTypeInfo getDefaultAsstActType() throws EASBizException, BOSException {
        String cpID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        return BaseDataUtil.getDefaultAsstActType(cpID);
    }

    public static AsstActTypeInfo getDefaultAsstActType(String cpID) throws BOSException, EASBizException {
        AsstActTypeInfo defaultValue = null;
        IAsstActTypeDefault iAsstActType = AsstActTypeDefaultFactory.getRemoteInstance();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem1 = new FilterItemInfo("isAccountCussent", (Object)Boolean.TRUE);
        FilterItemInfo filterItem2 = new FilterItemInfo("company.id", (Object)cpID);
        filter.getFilterItems().add(filterItem1);
        filter.getFilterItems().add(filterItem2);
        ev.getSelector().add("asstActType.*");
        ev.setFilter(filter);
        AsstActTypeDefaultCollection asstActTypeColl = iAsstActType.getAsstActTypeDefaultCollection(ev);
        defaultValue = asstActTypeColl.get(0).getAsstActType();
        return defaultValue;
    }

    public static ExchangeRateInfo getExchangeRate(CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo sourceCur) throws EASBizException, BOSException {
        return BaseDataUtil.getExchangeRate(companyOrgUnitInfo, sourceCur, new Date());
    }

    public static ExchangeRateInfo getExchangeRate(CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo sourceCur, Date date) throws EASBizException, BOSException {
        IExchangeRate iexchangRate = null;
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK destCurrpk = null;
        if (sourceCur == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"49_BaseDataUtil"));
            return null;
        }
        if (companyOrgUnitInfo == null) {
            companyOrgUnitInfo = BaseDataUtil.getCompanyInfo();
        }
        if (companyOrgUnitInfo.getBaseExchangeTable() == null) {
            MsgBox.showInfo((String)BaseDataUtil.getStrResource("BaseExchangeTable_not_exist"));
            return null;
        }
        excTablepk = new ObjectUuidPK(companyOrgUnitInfo.getBaseExchangeTable().getId());
        CurrencyInfo baseCur = companyOrgUnitInfo.getBaseCurrency();
        if (baseCur != null) {
            if (baseCur.getId().equals((Object)sourceCur.getId())) {
                return null;
            }
        } else {
            MsgBox.showInfo((String)"BaseCurrency is null");
            return null;
        }
        destCurrpk = new ObjectUuidPK(baseCur.getId());
        iexchangRate = ExchangeRateFactory.getRemoteInstance();
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(sourceCur.getId());
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, date);
        return erInfo;
    }

    public static boolean isDirectExchangeRate(ExchangeRateInfo rateInfo) {
        if (rateInfo == null) {
            return true;
        }
        boolean isDirectExchange = false;
        if (rateInfo.getExchangeAux() != null && ConvertModeEnum.DIRECTEXCHANGERATE.equals((Object)rateInfo.getExchangeAux().getConvertMode())) {
            isDirectExchange = true;
        }
        return isDirectExchange;
    }

    public static BigDecimal calculateLocalAmount(BigDecimal amount, BigDecimal converRate, boolean isDirectExchangeRate, int precision) {
        if (amount == null) {
            return new BigDecimal("0.0");
        }
        if (isDirectExchangeRate) {
            return amount.multiply(converRate).setScale(precision, 4);
        }
        if (converRate.compareTo(ZERO) != 0) {
            return amount.divide(converRate, precision, 4);
        }
        return amount.multiply(converRate).setScale(precision, 4);
    }

    public static String getCodeRuleClient(BillBaseInfo billInfo) throws CodingRuleException, EASBizException, BOSException {
        return BaseDataUtil.getNumberFromCodeRule(billInfo);
    }

    public static String getNumberFromCodeRule(BillBaseInfo billInfo) throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        String sysNumber = null;
        if (billInfo.getCompany() == null) {
            return null;
        }
        String companyID = billInfo.getCompany().getId().toString();
        sysNumber = iCodingRuleManager.getNumber((IObjectValue)billInfo, companyID);
        return sysNumber;
    }

    public static boolean recycleNumber(CoreBillBaseInfo coreBillInfo) throws CodingRuleException, EASBizException, BOSException {
        String companyID;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        if (iCodingRuleManager.isExist((IObjectValue)coreBillInfo, companyID = iCodingRuleManager.getCurrentAppOUID((IObjectValue)coreBillInfo)) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)coreBillInfo, companyID)) {
            iCodingRuleManager.recycleNumber((IObjectValue)coreBillInfo, companyID, coreBillInfo.getNumber());
            return true;
        }
        return false;
    }

    public static java.sql.Date upTimestamp(Timestamp oldTime) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(oldTime);
        GregorianCalendar calendarUp = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.get(5) + 1);
        java.sql.Date dateUp = new java.sql.Date(calendarUp.getTime().getTime());
        return dateUp;
    }

    public static java.sql.Date downTimestamp(Timestamp oldTime) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(oldTime);
        GregorianCalendar calendarDown = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.get(5));
        java.sql.Date dateDown = new java.sql.Date(calendarDown.getTime().getTime());
        return dateDown;
    }

    public static String getStrResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)resKey);
    }

    public static void showInfo(Component handle, String resKey) {
        MsgBox.showInfo((Component)handle, (String)BaseDataUtil.getStrResource(resKey));
    }

    public static VcSchemeInfo getVcSchemeInfoByName(String subSysName, String name) {
        VcSchemeInfo info = null;
        try {
            IVcScheme iVcScheme = VcSchemeFactory.getRemoteInstance();
            StringBuffer sb = new StringBuffer(" where ");
            String cuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            sb.append("CU.id in ('");
            sb.append(cuId);
            sb.append("','");
            sb.append("00000000-0000-0000-0000-000000000000CCE7AED4");
            sb.append("','");
            sb.append("11111111-1111-1111-1111-111111111111CCE7AED4");
            sb.append("') and isUsing=1");
            if (subSysName != null) {
                sb.append(" and subSysName='");
                sb.append(subSysName);
                sb.append("'");
            }
            sb.append(" and name ='").append(name).append("'");
            VcSchemeCollection schemeColl = iVcScheme.getVcSchemeCollection(sb.toString());
            if (schemeColl.size() > 0) {
                info = schemeColl.get(0);
            } else {
                MsgBox.showInfo((String)BaseDataUtil.getStrResource("lab_novcscheme"));
                SysUtil.abort();
            }
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
        return info;
    }

    public static void setAsstActSelector(KDBizPromptBox bizPromptBox, AsstActTypeInfo asstActTypeInfo, CoreUIObject parentUi) throws Exception {
        String queryName = asstActTypeInfo.getDefaultQueryName();
        if (asstActTypeInfo.getRealtionDataObject().equalsIgnoreCase("T_BD_GeneralAsstActType")) {
            IAsstActType asstActType = AsstActTypeFactory.getRemoteInstance();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("glAsstActTypeGrp.id"));
            ObjectUuidPK pk = new ObjectUuidPK(asstActTypeInfo.getId());
            AsstActTypeInfo info = asstActType.getAsstActTypeInfo((IObjectPK)pk, sic);
            if (info.getGlAsstActTypeGrp() == null) {
                throw new NullPointerException(BaseDataUtil.getStrResource("lab_assactid_isnull"));
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)info.getGlAsstActTypeGrp().getId().toString()));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            bizPromptBox.setEntityViewInfo(evi);
            bizPromptBox.setSelector(null);
            bizPromptBox.setQueryInfo(queryName);
            bizPromptBox.setHasCUDefaultFilter(true);
        } else {
            bizPromptBox.setEntityViewInfo(null);
            bizPromptBox.setSelector(null);
            bizPromptBox.setValue(null);
            bizPromptBox.setQueryInfo(queryName);
        }
    }

    public static String getERFormatString(CurrencyInfo currencyInfo, CurrencyInfo localCurrency) throws EASBizException, BOSException {
        if (localCurrency != null && currencyInfo.getId().toString().equals(localCurrency.getId().toString())) {
            return "%r-[=]{#,##}f";
        }
        ExchangeRateInfo exchangeRateInfo = CurrencyExchangeRateUtils.getExchangeRate(currencyInfo);
        int precision = CurrencyExchangeRateUtils.visitExchangeRatePrecision(exchangeRateInfo);
        if (precision == 0) {
            precision = 2;
        }
        return PrecisionFormatUtils.getFormatString(precision);
    }

    public static void setAdminOrgUnit(KDBizPromptBox bizPromptBox) throws BOSException, EASBizException {
        ArApBillUIUtil.setOrgUnitF7(bizPromptBox, OrgType.Admin);
    }

    public static void setBusinessor(KDBizPromptBox bizPromptBox) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = ClientUtils.getCurrLoginCompany();
        BaseDataUtil.setBusinessor(bizPromptBox, companyInfo);
    }

    public static void setBusinessor(KDBizPromptBox bizPromptBox, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        String queryInfo = "com.kingdee.eas.basedata.person.app.PersonQuery";
        Set hashSet = BaseDataUtil.getFromUnit(companyInfo.getId().toString(), 1, 0);
        FilterInfo filter = new FilterInfo();
        boolean filterCount = false;
        if (hashSet != null && hashSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)hashSet, CompareType.INCLUDE));
            filter.setMaskString("(#0 OR #1) ");
            filterCount = true;
        }
        filter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)companyInfo.getId().toString(), CompareType.EQUALS));
        CtrlUnitInfo cu = companyInfo.getCU();
        if (cu != null) {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cu.getString("id")));
            if (filterCount) {
                filter.setMaskString(filter.getMaskString() + "AND (#2) ");
            }
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        bizPromptBox.setEntityViewInfo(viewInfo);
        bizPromptBox.setQueryInfo(queryInfo);
    }

    public static Set getFromUnit(String toUnitID, int toUnitType, int formUnitType) throws BOSException, EASBizException {
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection ouColl = iUnitRel.getFromUnit(toUnitID, toUnitType, formUnitType);
        HashSet<String> set = new HashSet<String>();
        int size = ouColl.size();
        for (int i = 0; i < size; ++i) {
            OrgUnitInfo info = ouColl.get(i);
            set.add(info.getId().toString());
        }
        return set;
    }

    public static void setSaleOrgUnit(KDBizPromptBox bizPromptBox) throws BOSException, EASBizException {
        ArApBillUIUtil.setOrgUnitF7(bizPromptBox, OrgType.Sale);
    }

    public static void setPurOrgUnit(KDBizPromptBox bizPromptBox) throws BOSException, EASBizException {
        ArApBillUIUtil.setOrgUnitF7(bizPromptBox, OrgType.Purchase);
    }

    public static boolean checkEditVoucherPermission(IObjectPK userPK, IObjectPK orgPK, String permItemName, IObjectPK bizDataPK) throws EASBizException, BOSException {
        if ("".equals(permItemName)) {
            permItemName = "gl_voucher02_edit";
        }
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        boolean functionRes = iPermission.hasFunctionPermission(userPK, orgPK, permItemName);
        if (bizDataPK == null) {
            return functionRes;
        }
        boolean hasPermission = true;
        if (functionRes) {
            boolean res = iPermission.hasDataPermission(userPK, orgPK, "gl_voucher02_edit", bizDataPK);
            if (!res) {
                hasPermission = false;
            }
        } else {
            hasPermission = false;
        }
        return hasPermission;
    }

    private static String getBindingProperty() {
        return null;
    }

    public static void rolbackNumber(CoreBillBaseInfo coreBillInfo) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        String strCompanyID = iCodingRuleManager.getCurrentAppOUID((IObjectValue)coreBillInfo);
        String strBindProp = BaseDataUtil.getBindingProperty();
        if (strBindProp != null && strBindProp.trim().length() > 0) {
            if (iCodingRuleManager.isExist((IObjectValue)coreBillInfo, strCompanyID, strBindProp) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)coreBillInfo, strCompanyID, strBindProp)) {
                iCodingRuleManager.recycleNumber((IObjectValue)coreBillInfo, strCompanyID, strBindProp, "", coreBillInfo.getNumber());
            }
        } else if (iCodingRuleManager.isExist((IObjectValue)coreBillInfo, strCompanyID) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)coreBillInfo, strCompanyID)) {
            iCodingRuleManager.recycleNumber((IObjectValue)coreBillInfo, strCompanyID, coreBillInfo.getNumber());
        }
    }

    public static KDBizPromptBox getF7AccountPromptBox(IUIObject owner) throws EASBizException, BOSException {
        CompanyOrgUnitInfo currentCompany = BaseDataUtil.getCompanyInfo();
        PeriodInfo period = ArClientUtils.getArCurrentPeriod(currentCompany);
        if (period == null) {
            period = ArClientUtils.getArStartPeriod(currentCompany);
        }
        return BaseDataUtil.getF7AccountPromptBox(owner, period, currentCompany);
    }

    public static KDBizPromptBox getF7AccountPromptBox(IUIObject owner, PeriodInfo period, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        return BaseDataUtil.getF7AccountPromptBox(owner, period, companyInfo, null, null, null, false);
    }

    public static KDBizPromptBox getF7AccountPromptBox(IUIObject owner, PeriodInfo period, CompanyOrgUnitInfo companyInfo, AccountTableInfo accountTableInfo, String currencyID) throws EASBizException, BOSException {
        String currentAcctTableID = null;
        if (accountTableInfo == null) {
            currentAcctTableID = BaseDataUtil.getCurrentAccountTableID(1, period, companyInfo);
            accountTableInfo = BaseDataUtil.getAccountTable(currentAcctTableID);
        } else {
            currentAcctTableID = accountTableInfo.getId().toString();
        }
        KDBizPromptBox f7AccountPromptBox = new KDBizPromptBox();
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        int step = 3;
        StringBuilder mask = new StringBuilder();
        fic.add(new FilterItemInfo("companyID.id", (Object)companyInfo.getId().toString()));
        fic.add(new FilterItemInfo("isGFreeze", (Object)false));
        fic.add(new FilterItemInfo("isCFreeze", (Object)false));
        if (currentAcctTableID != null) {
            fic.add(new FilterItemInfo("accountTableID.id", (Object)currentAcctTableID));
            ++step;
        }
        for (int i = 0; i < step; ++i) {
            if (i != 0) {
                mask.append(" and #" + i);
                continue;
            }
            mask.append("#" + i);
        }
        if (!StringUtils.isEmpty((String)currencyID)) {
            fic.add(new FilterItemInfo("accountingcurrency", (Object)2, CompareType.EQUALS));
            mask.append(" AND (#").append(step++).append(" ");
            fic.add(new FilterItemInfo("accountingcurrency", (Object)1, CompareType.EQUALS));
            fic.add(new FilterItemInfo("accountCurrency.id", (Object)("select fid from t_bd_accountcurrency where FCURRENCYID = '" + currencyID + "'"), CompareType.INNER));
            mask.append(" OR (#").append(step++).append(" AND #").append(step++).append(") ");
            if (companyInfo.getBaseCurrency() != null && currencyID.equalsIgnoreCase(companyInfo.getBaseCurrency().getId().toString())) {
                fic.add(new FilterItemInfo("accountingcurrency", (Object)0, CompareType.EQUALS));
                mask.append(" OR #").append(step++).append(" ");
            }
            mask.append(" )");
        }
        fi.setMaskString(mask.toString());
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(fi);
        f7AccountPromptBox.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        f7AccountPromptBox.setSelector((KDPromptSelector)new AccountPromptBox(owner, companyInfo, accountTableInfo, fi, false, true, true));
        f7AccountPromptBox.setVisible(true);
        f7AccountPromptBox.setEditable(true);
        f7AccountPromptBox.setEnabled(true);
        f7AccountPromptBox.setEditFormat("$number$");
        f7AccountPromptBox.setDisplayFormat("$number$ $name$");
        f7AccountPromptBox.setCommitFormat("$number$;$name$");
        f7AccountPromptBox.setEntityViewInfo(viewInfo);
        return f7AccountPromptBox;
    }

    public static KDBizPromptBox getF7AccountPromptBox(IUIObject owner, PeriodInfo period, CompanyOrgUnitInfo companyInfo, AccountTableInfo accountTableInfo, SystemEnum sysEnum, String currencyID, boolean isContrastAccount) throws EASBizException, BOSException {
        String currentAcctTableID = null;
        if (accountTableInfo == null) {
            currentAcctTableID = BaseDataUtil.getCurrentAccountTableID(1, period, companyInfo);
            accountTableInfo = BaseDataUtil.getAccountTable(currentAcctTableID);
        } else {
            currentAcctTableID = accountTableInfo.getId().toString();
        }
        KDBizPromptBox f7AccountPromptBox = new KDBizPromptBox();
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        int step = 3;
        StringBuffer mask = new StringBuffer();
        fic.add(new FilterItemInfo("companyID.id", (Object)companyInfo.getId().toString()));
        fic.add(new FilterItemInfo("isGFreeze", (Object)false));
        fic.add(new FilterItemInfo("isCFreeze", (Object)false));
        if (currentAcctTableID != null) {
            fic.add(new FilterItemInfo("accountTableID.id", (Object)currentAcctTableID));
            ++step;
        }
        for (int i = 0; i < step; ++i) {
            if (i != 0) {
                mask.append(" and #" + i);
                continue;
            }
            mask.append("#" + i);
        }
        if (isContrastAccount && sysEnum != null && currencyID != null) {
            List accountIDs;
            boolean isAR = false;
            if (SystemEnum.ACCOUNTSPAYABLE.equals((Object)sysEnum)) {
                isAR = false;
            } else if (SystemEnum.ACCOUNTSRECEIVABLE.equals((Object)sysEnum)) {
                isAR = true;
            }
            IArApBillFacade iArApBillFacade = ArApBillFacadeFactory.getRemoteInstance();
            Map accountMap = iArApBillFacade.getContrastAccount(isAR, companyInfo, currentAcctTableID, currencyID);
            if (accountMap != null && (accountIDs = (List)accountMap.get("accountIDs")).size() > 0) {
                String strIdLists = StringUtils.arrayToString((Object[])accountIDs.toArray(), (String)",");
                mask.append(" and (#" + step++).append(")");
                fic.add(new FilterItemInfo("id", (Object)strIdLists, CompareType.NOTINCLUDE));
            }
        }
        fi.setMaskString(mask.toString());
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(fi);
        f7AccountPromptBox.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        f7AccountPromptBox.setSelector((KDPromptSelector)new AccountPromptBox(owner, companyInfo, accountTableInfo, fi, false, true, true));
        f7AccountPromptBox.setVisible(true);
        f7AccountPromptBox.setEditable(true);
        f7AccountPromptBox.setEnabled(true);
        f7AccountPromptBox.setEditFormat("$number$");
        f7AccountPromptBox.setDisplayFormat("$number$ $name$");
        f7AccountPromptBox.setCommitFormat("$number$;$name$");
        f7AccountPromptBox.setEntityViewInfo(viewInfo);
        return f7AccountPromptBox;
    }

    public static AccountTableInfo getAccountTable(String id) throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IAccountTable iAccountTable = AccountTableFactory.getRemoteInstance();
        return iAccountTable.getAccountTableInfo((IObjectPK)pk);
    }

    public static String getCurrentAccountTableID(int system, PeriodInfo period) throws EASBizException, BOSException {
        CompanyOrgUnitInfo currentCompany = BaseDataUtil.getCompanyInfo();
        return BaseDataUtil.getCurrentAccountTableID(system, period, currentCompany);
    }

    public static String getCurrentAccountTableID(int system, PeriodInfo period, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        if (companyInfo == null) {
            companyInfo = BaseDataUtil.getCompanyInfo();
        }
        if (period == null) {
            period = system == 1 ? ArClientUtils.getArCurrentPeriod(companyInfo) : ApClientUtils.getApCurrentPeriod(companyInfo);
        }
        if (period == null) {
            period = system == 1 ? ArClientUtils.getArStartPeriod(companyInfo) : ApClientUtils.getApStartPeriod(companyInfo);
        }
        String companyId = companyInfo.getId().toString();
        String currentAccountTableID = null;
        if (period != null && companyInfo.getAccountTable() != null) {
            currentAccountTableID = AccountTools.getCurrentAcctTable((String)companyId, (String)companyInfo.getAccountTable().getId().toString(), (int)period.getPeriodYear(), (int)period.getPeriodNumber());
        } else if (period == null && companyInfo.getAccountTable() != null) {
            return companyInfo.getAccountTable().getId().toString();
        }
        return currentAccountTableID;
    }

    public static String getCurrentAccountTableID(int system) throws EASBizException, BOSException {
        CompanyOrgUnitInfo currentCompany = BaseDataUtil.getCompanyInfo();
        PeriodInfo period = null;
        period = system == 1 ? ArClientUtils.getArCurrentPeriod(currentCompany) : ApClientUtils.getApCurrentPeriod(currentCompany);
        if (period == null) {
            period = system == 1 ? ArClientUtils.getArStartPeriod(currentCompany) : ApClientUtils.getApStartPeriod(currentCompany);
        }
        return BaseDataUtil.getCurrentAccountTableID(system, period);
    }

    public static AccountTableInfo getCurrentAccountTable() throws EASBizException, BOSException {
        CompanyOrgUnitInfo currentCompany = BaseDataUtil.getCompanyInfo();
        PeriodInfo period = ArClientUtils.getArCurrentPeriod(currentCompany);
        if (period == null) {
            period = ArClientUtils.getArStartPeriod(currentCompany);
        }
        String currentAcctTableID = BaseDataUtil.getCurrentAccountTableID(1, period);
        return BaseDataUtil.getAccountTable(currentAcctTableID);
    }

    public static CompanyOrgUnitInfo getCompany(String companyID) throws BOSException, EASBizException {
        if (companyID == null || "".equals(companyID.trim())) {
            return null;
        }
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getRemoteInstance();
        return iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID));
    }

    public static String date2String(Date date, String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        String format = sdf.format(date);
        return format;
    }
}

