/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParam;
import com.kingdee.eas.base.param.ParamCollection;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamFactory;
import com.kingdee.eas.base.param.ParamInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.auxacct.IAsstActTypeDefault;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ap.APParamEnum;
import com.kingdee.eas.fi.ap.client.util.ApClientUtils;
import com.kingdee.eas.fi.ar.ARParamEnum;
import com.kingdee.eas.fi.ar.BadAccountFacadeFactory;
import com.kingdee.eas.fi.ar.BalanceResult;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.client.util.NotAuditBill;
import com.kingdee.eas.fi.ar.client.util.NotVoucheredBill;
import com.kingdee.eas.fi.ar.util.CommonUtils;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.gl.AccountBalanceCollection;
import com.kingdee.eas.fi.gl.AccountBalanceFactory;
import com.kingdee.eas.fi.gl.AccountBalanceInfo;
import com.kingdee.eas.fi.gl.IAccountBalance;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class CommonClientUtils {
    public static final String SUB_SYSTEM_AR = "com.kingdee.eas.fi.ar.ar";
    public static final String SUB_SYSTEM_AP = "com.kingdee.eas.fi.ar.ap.ap";
    public static final long DAY_MILLS = 86400000L;

    private CommonClientUtils() {
    }

    public static boolean checkAllStartSysCurrentPeriod(CompanyOrgUnitInfo company, PeriodInfo period) throws BOSException {
        if (company == null) {
            throw new IllegalArgumentException();
        }
        try {
            String companyID = company.getId().toString();
            StringBuffer buffer = new StringBuffer();
            buffer.append("select");
            buffer.append(" *");
            buffer.append(" ,currentPeriod.*");
            buffer.append(" ,startPeriod.*");
            buffer.append(" where");
            buffer.append(" (company='" + companyID + "')");
            buffer.append(" and (isStart=1)");
            String oql = buffer.toString();
            ISystemStatusCtrol systemStatusCtrol = SystemStatusCtrolFactory.getRemoteInstance();
            SystemStatusCtrolCollection systmStsCtrlCllctn = systemStatusCtrol.getSystemStatusCtrolCollection(oql);
            int size = systmStsCtrlCllctn.size();
            if (size <= 0) {
                return true;
            }
            for (int i = 0; i <= size - 1; ++i) {
                SystemStatusCtrolInfo systmStsCtrlInf = systmStsCtrlCllctn.get(i);
                PeriodInfo currentPeriod = systmStsCtrlInf.getCurrentPeriod();
                int result = PeriodUtils.PeriodCompare((String)period.getId().toString(), (String)currentPeriod.getId().toString());
                if (result == 0) continue;
                return false;
            }
            return true;
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static SystemStatusCtrolInfo getSysStatusCtrolInfo(CompanyOrgUnitInfo cmpnyOrgUntInfObj, SystemEnum system) throws BOSException {
        CompanyOrgUnitInfo cmpnyOrgUntInf = cmpnyOrgUntInfObj;
        String cmpnyOrgUntID = cmpnyOrgUntInf.getId().toString();
        ISystemStatusCtrol systemStatusCtrol = SystemStatusCtrolFactory.getRemoteInstance();
        String cndtn0 = "(company='" + cmpnyOrgUntID + "')";
        String cndtn1 = "(systemStatus.name=" + system.getValue() + ")";
        String cndtn = cndtn0 + " and " + cndtn1;
        String oql = "select *,currentPeriod.*,startPeriod.* where " + cndtn;
        SystemStatusCtrolCollection systmStsCtrlCllctn = systemStatusCtrol.getSystemStatusCtrolCollection(oql);
        int size = systmStsCtrlCllctn.size();
        if (size <= 0) {
            return null;
        }
        if (size == 1) {
            SystemStatusCtrolInfo systmStsCtrlInf = systmStsCtrlCllctn.get(0);
            return systmStsCtrlInf;
        }
        throw new IllegalArgumentException();
    }

    public static SystemStatusCtrolCollection getSysStatusCollection(Object companyInfo, String sysString) throws BOSException, EASBizException {
        if (!(companyInfo instanceof CompanyOrgUnitInfo)) {
            throw new IllegalArgumentException();
        }
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)companyInfo;
        String companyId = company.getId().toString();
        ISystemStatusCtrol systemStatusCtrol = SystemStatusCtrolFactory.getRemoteInstance();
        String cndtn0 = "(company='" + companyId + "')";
        String cndtn1 = "(systemStatus.name  in (" + sysString + "))";
        String cndtn = cndtn0 + " and " + cndtn1;
        String oql = "select *,startPeriod.*,currentPeriod.* where " + cndtn;
        SystemStatusCtrolCollection sysCol = systemStatusCtrol.getSystemStatusCtrolCollection(oql);
        return sysCol;
    }

    public static SystemStatusCtrolInfo getGlStatusCtrolInfo(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systmSttsCtrlInf = CommonClientUtils.getSysStatusCtrolInfo(cmpnyOrgUntInfObj, SystemEnum.GENERALLEDGER);
        return systmSttsCtrlInf;
    }

    public static boolean glIsStart(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systmStsCtrlInf = CommonClientUtils.getGlStatusCtrolInfo(cmpnyOrgUntInfObj);
        if (systmStsCtrlInf != null) {
            return systmStsCtrlInf.isIsStart();
        }
        return false;
    }

    public static boolean glIsStart() throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = CommonClientUtils.getCurrentCompany();
        return CommonClientUtils.glIsStart(company);
    }

    public static boolean showNodAuditBills(KDTable table, Vector value) {
        if (table == null) {
            throw new IllegalArgumentException();
        }
        if (value == null || value.size() == 0) {
            return true;
        }
        table.removeRows();
        table.getStyleAttributes().setLocked(true);
        for (int i = 0; i <= value.size() - 1; ++i) {
            NotAuditBill notAuditBill = (NotAuditBill)value.get(i);
            IRow row = table.addRow();
            row.getCell(0).setValue((Object)notAuditBill.getCompany());
            row.getCell(1).setValue((Object)notAuditBill.getBillType());
            row.getCell(2).setValue((Object)notAuditBill.getBillDate());
            row.getCell(3).setValue((Object)notAuditBill.getBillID());
        }
        return true;
    }

    public static void showNotVoucheredBills(KDTable table, Vector value) {
        if (table == null) {
            throw new IllegalArgumentException();
        }
        if (value == null || value.size() == 0) {
            return;
        }
        table.removeRows();
        table.getStyleAttributes().setLocked(true);
        for (int i = 0; i <= value.size() - 1; ++i) {
            NotVoucheredBill notVoucheredBill = (NotVoucheredBill)value.get(i);
            IRow row = table.addRow();
            row.getCell(0).setValue((Object)notVoucheredBill.getCompany());
            row.getCell(1).setValue((Object)notVoucheredBill.getBillType());
            row.getCell(2).setValue((Object)notVoucheredBill.getBillDate());
            row.getCell(3).setValue((Object)notVoucheredBill.getBillID());
        }
    }

    public static boolean showBalanceResults(KDTable table, Vector value) {
        if (table == null) {
            throw new IllegalArgumentException();
        }
        if (value == null || value.size() <= 0) {
            return true;
        }
        table.removeRows();
        table.getStyleAttributes().setLocked(true);
        int size = value.size();
        for (int i = 0; i <= size - 1; ++i) {
            BalanceResult balanceResult = (BalanceResult)value.get(i);
            IRow row = table.addRow();
            row.getCell(0).setValue((Object)balanceResult.account);
            String directionName = CommonClientUtils.getAccountDirectionName(balanceResult.direction);
            row.getCell(1).setValue((Object)directionName);
            row.getCell(2).setValue((Object)balanceResult.currency);
            row.getCell(3).setValue((Object)balanceResult.asstActType);
            row.getCell(4).setValue((Object)balanceResult.asstAct);
            row.getCell(5).setValue((Object)balanceResult.beginBalanceFor);
            row.getCell(6).setValue((Object)balanceResult.yearDebitFor);
            row.getCell(7).setValue((Object)balanceResult.yearCreditFor);
            row.getCell(8).setValue((Object)balanceResult.glBeginBalanceFor);
            row.getCell(9).setValue((Object)balanceResult.glYearDebitFor);
            row.getCell(10).setValue((Object)balanceResult.glYearCreditFor);
            row.getCell(11).setValue((Object)balanceResult.balanceBeginBalanceFor);
            row.getCell(12).setValue((Object)balanceResult.balanceYearDebitFor);
            row.getCell(13).setValue((Object)balanceResult.balanceYearCreditFor);
        }
        return true;
    }

    public static String getAccountDirectionName(int value) {
        if (value == 1) {
            return ArClientUtils.getArStringResource("Debit");
        }
        if (value == -1) {
            return ArClientUtils.getArStringResource("Credit");
        }
        throw new IllegalArgumentException();
    }

    public static CompanyOrgUnitInfo getCurrentCompany() {
        CompanyOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        if (currentCompany == null || currentCompany.isIsOnlyUnion()) {
            String message = ArClientUtils.getArStringResource("CompanyIsNull");
            MsgBox.showInfo((String)message);
            SysUtil.abort();
        }
        CompanyOrgUnitInfo cmpnyOrgUntInf = currentCompany;
        return cmpnyOrgUntInf;
    }

    public static CurrencyInfo getIntegrateLocalCurrency() {
        String currencyID = "11111111-1111-1111-1111-111111111111DEB58FDC";
        return CommonClientUtils.getCurrency(currencyID);
    }

    public static CurrencyInfo getCurrency(String id) {
        try {
            ICurrency currency = CurrencyFactory.getRemoteInstance();
            ObjectUuidPK pk = CommonUtils.getPK(id);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("precision"));
            return currency.getCurrencyInfo((IObjectPK)pk, sic);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    public static AccountBalanceInfo getGLAccountBalance(AccountViewInfo account) {
        try {
            String accountID = account.getId().toString();
            CompanyOrgUnitInfo company = CommonClientUtils.getCurrentCompany();
            String companyID = company.getId().toString();
            PeriodInfo period = ArClientUtils.getArCurrentPeriod(company);
            String periodID = period.getId().toString();
            CurrencyInfo currencyInfo = company.getBaseCurrency();
            String currencyID = currencyInfo.getId().toString();
            IAccountBalance accountBalance = AccountBalanceFactory.getRemoteInstance();
            StringBuffer buffer = new StringBuffer();
            buffer.append("select");
            buffer.append(" *");
            buffer.append(" where");
            int balType = VoucherStatusEnum.POSTED.getValue();
            String balTypeString = String.valueOf(balType);
            buffer.append(" (balType=" + balTypeString + ")");
            buffer.append(" and (orgUnit='" + companyID + "')");
            buffer.append(" and (period='" + periodID + "')");
            buffer.append(" and (account='" + accountID + "')");
            buffer.append(" and (currency='" + currencyID + "')");
            String oql = buffer.toString();
            AccountBalanceCollection collection = accountBalance.getAccountBalanceCollection(oql);
            if (collection != null && collection.size() == 1) {
                return collection.get(0);
            }
            throw new BOSException("Gl account data is error!");
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    public static BigDecimal getRecentPrepareBalance(AccountViewInfo account) {
        BigDecimal beginBalanceLocal = null;
        BigDecimal debitLocal = null;
        BigDecimal creditLocal = null;
        BigDecimal balance = new BigDecimal("0.0");
        BigDecimal recentPrepareBalance = new BigDecimal("0.0");
        try {
            String accountID = account.getId().toString();
            CompanyOrgUnitInfo company = CommonClientUtils.getCurrentCompany();
            String companyID = company.getId().toString();
            PeriodInfo period = ArClientUtils.getArCurrentPeriod(company);
            String periodID = period.getId().toString();
            CurrencyInfo currencyInfo = ArClientUtils.getIntegrateLocalCurrency();
            String currencyID = currencyInfo.getId().toString();
            IAccountBalance accountBalance = AccountBalanceFactory.getRemoteInstance();
            StringBuffer buffer = new StringBuffer();
            buffer.append("select");
            buffer.append(" *  ");
            buffer.append(" where");
            int balType = VoucherStatusEnum.POSTED.getValue();
            String balTypeString = String.valueOf(balType);
            buffer.append(" (balType=" + balTypeString + ")");
            buffer.append(" and (orgUnit='" + companyID + "')");
            buffer.append(" and (period='" + periodID + "')");
            buffer.append(" and (account='" + accountID + "')");
            buffer.append(" and (currency='" + currencyID + "')");
            String oql = buffer.toString();
            AccountBalanceCollection collection = accountBalance.getAccountBalanceCollection(oql);
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                AccountBalanceInfo info = collection.get(i);
                debitLocal = info.getDebitLocal();
                creditLocal = info.getCreditLocal();
                if (account.getDC().getValue() == 1) {
                    balance = debitLocal.subtract(creditLocal);
                } else if (account.getDC().getValue() == -1) {
                    balance = creditLocal.subtract(debitLocal);
                }
                BigDecimal dc = new BigDecimal(account.getDC().getValue() + "");
                beginBalanceLocal = info.getBeginBalanceLocal();
                beginBalanceLocal = beginBalanceLocal.multiply(dc);
                balance = balance.add(beginBalanceLocal);
                recentPrepareBalance = recentPrepareBalance.add(balance);
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            return new BigDecimal("0.0");
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            return new BigDecimal("0.0");
        }
        return recentPrepareBalance;
    }

    public static BigDecimal getSaleTotalAmountsForYear(AccountViewInfo account) {
        BigDecimal saleTotalAmounts = new BigDecimal("0.0");
        try {
            String accountID = account.getId().toString();
            CompanyOrgUnitInfo company = CommonClientUtils.getCurrentCompany();
            String companyID = company.getId().toString();
            PeriodInfo period = ArClientUtils.getArCurrentPeriod(company);
            String periodID = period.getId().toString();
            CurrencyInfo currencyInfo = ArClientUtils.getIntegrateLocalCurrency();
            String currencyID = currencyInfo.getId().toString();
            IAccountBalance accountBalance = AccountBalanceFactory.getRemoteInstance();
            StringBuffer buffer = new StringBuffer();
            buffer.append("select");
            buffer.append(" *  ");
            buffer.append(" where");
            int balType = VoucherStatusEnum.POSTED.getValue();
            String balTypeString = String.valueOf(balType);
            buffer.append(" (balType=" + balTypeString + ")");
            buffer.append(" and (orgUnit='" + companyID + "')");
            buffer.append(" and (period='" + periodID + "')");
            buffer.append(" and (account='" + accountID + "')");
            buffer.append(" and (currency='" + currencyID + "')");
            String oql = buffer.toString();
            AccountBalanceCollection collection = accountBalance.getAccountBalanceCollection(oql);
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                AccountBalanceInfo info = collection.get(i);
                if (info.getYearDebitLocal() == null) continue;
                saleTotalAmounts = saleTotalAmounts.add(info.getYearCreditLocal());
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            return new BigDecimal("0.0");
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            return new BigDecimal("0.0");
        }
        return saleTotalAmounts;
    }

    public static BigDecimal getRecentPrepareBalance(AccountViewInfo account, int debtOrCredit) {
        BigDecimal beginBalanceLocal = null;
        BigDecimal debitLocal = null;
        BigDecimal creditLocal = null;
        BigDecimal balance = new BigDecimal("0.0");
        BigDecimal recentPrepareBalance = new BigDecimal("0.0");
        try {
            String accountID = account.getId().toString();
            CompanyOrgUnitInfo company = CommonClientUtils.getCurrentCompany();
            String companyID = company.getId().toString();
            PeriodInfo period = ArClientUtils.getArCurrentPeriod(company);
            String periodID = period.getId().toString();
            CurrencyInfo currencyInfo = ArClientUtils.getIntegrateLocalCurrency();
            String currencyID = currencyInfo.getId().toString();
            IAccountBalance accountBalance = AccountBalanceFactory.getRemoteInstance();
            StringBuffer buffer = new StringBuffer();
            buffer.append("select");
            buffer.append(" *  ");
            buffer.append(" where");
            int balType = VoucherStatusEnum.POSTED.getValue();
            String balTypeString = String.valueOf(balType);
            buffer.append(" (balType=" + balTypeString + ")");
            buffer.append(" and (orgUnit='" + companyID + "')");
            buffer.append(" and (period='" + periodID + "')");
            buffer.append(" and (account='" + accountID + "')");
            buffer.append(" and (currency='" + currencyID + "')");
            String oql = buffer.toString();
            AccountBalanceCollection collection = accountBalance.getAccountBalanceCollection(oql);
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                AccountBalanceInfo info = collection.get(i);
                debitLocal = info.getDebitLocal();
                creditLocal = info.getCreditLocal();
                if (debtOrCredit == 1) {
                    balance = debitLocal.subtract(creditLocal);
                } else if (debtOrCredit == -1) {
                    balance = creditLocal.subtract(debitLocal);
                }
                BigDecimal dc = new BigDecimal(debtOrCredit);
                beginBalanceLocal = info.getBeginBalanceLocal();
                beginBalanceLocal = beginBalanceLocal.multiply(dc);
                balance = balance.add(beginBalanceLocal);
                recentPrepareBalance = recentPrepareBalance.add(balance);
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            return new BigDecimal("0.0");
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            return new BigDecimal("0.0");
        }
        return recentPrepareBalance;
    }

    public static AsstActTypeInfo getClient() throws BOSException, EASBizException {
        IAsstActType asstActType = AsstActTypeFactory.getRemoteInstance();
        StringBuffer buffer = new StringBuffer();
        buffer.append("where");
        buffer.append(" (asstHGAttribute='customer')");
        String oql = buffer.toString();
        AsstActTypeInfo astActTypInf = (AsstActTypeInfo)asstActType.getObjectBaseInfo(oql);
        return astActTypInf;
    }

    public static AsstActTypeInfo getSupplier() throws BOSException, EASBizException {
        IAsstActType asstActType = AsstActTypeFactory.getRemoteInstance();
        StringBuffer buffer = new StringBuffer();
        buffer.append("where");
        buffer.append(" (asstHGAttribute='provider')");
        String oql = buffer.toString();
        AsstActTypeInfo astActTypInf = (AsstActTypeInfo)asstActType.getObjectBaseInfo(oql);
        return astActTypInf;
    }

    public static void checkFunctionPermission(String permissionItem) throws BOSException, EASBizException {
        if (permissionItem == null || permissionItem.length() == 0) {
            return;
        }
        IPermission permission = PermissionFactory.getRemoteInstance();
        SysContext sysContext = SysContext.getSysContext();
        CompanyOrgUnitInfo company = sysContext.getCurrentFIUnit();
        if (company == null) {
            return;
        }
        BOSUuid companyID = company.getId();
        ObjectUuidPK companyPK = new ObjectUuidPK(companyID);
        UserInfo currentUser = sysContext.getCurrentUserInfo();
        BOSUuid currentUserID = currentUser.getId();
        ObjectUuidPK currentUserPK = new ObjectUuidPK(currentUserID);
        permission.checkFunctionPermission((IObjectPK)currentUserPK, OrgType.Company, (IObjectPK)companyPK, permissionItem);
    }

    public static void setAsstActTypes(KDComboBox comboAcctCussentType, boolean fAr, CompanyOrgUnitInfo cpInfo) throws BOSException, EASBizException {
        if (cpInfo == null || StringUtils.isEmpty((String)cpInfo.getString("id"))) {
            return;
        }
        String cpID = cpInfo.getId().toString();
        StringBuffer oql = new StringBuffer();
        oql.append("select id, asstActType.id, asstActType.name, ");
        oql.append("asstActType.number, asstActType.defaultQueryName, ");
        oql.append("asstActType.realtionDataObject, asstActType.glAsstActTypeGrp.id");
        oql.append(", isDefaultAccountReceivable, isDefaultAccountPayable ");
        oql.append(" where isAccountCussent = 1 and company.id = '");
        oql.append(cpID).append("'");
        IAsstActTypeDefault iAsstActTypeDflt = AsstActTypeDefaultFactory.getRemoteInstance();
        AsstActTypeDefaultCollection asstActTypeColl = iAsstActTypeDflt.getAsstActTypeDefaultCollection(oql.toString());
        IAsstActType iAsstActType = null;
        int count = asstActTypeColl.size();
        AsstActTypeCollection coll = new AsstActTypeCollection();
        AsstActTypeInfo defaultAsstActInfo = null;
        for (int i = 0; i < count; ++i) {
            AsstActTypeDefaultInfo typeDefaultInfo = asstActTypeColl.get(i);
            AsstActTypeInfo asstInfo = typeDefaultInfo.getAsstActType();
            if (asstInfo != null && StringUtils.isEmpty((String)asstInfo.getName())) {
                iAsstActType = iAsstActType == null ? AsstActTypeFactory.getRemoteInstance() : iAsstActType;
                asstInfo = iAsstActType.getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(asstInfo.getId()));
            }
            coll.add(asstInfo);
            if ((!fAr || !typeDefaultInfo.isIsDefaultAccountReceivable()) && (fAr || !typeDefaultInfo.isIsDefaultAccountPayable())) continue;
            defaultAsstActInfo = asstInfo;
        }
        comboAcctCussentType.removeAllItems();
        comboAcctCussentType.addItems(coll.toArray());
        comboAcctCussentType.setSelectedItem(defaultAsstActInfo);
    }

    public static String getDefaultAsstTypeId(BOSUuid companyId, boolean fAR) throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer();
        oql.append("select asstActType.id, asstActType.name ");
        oql.append(" where isAccountCussent = 1 and ");
        oql.append(fAR ? "isDefaultAccountReceivable" : "isDefaultAccountPayable");
        oql.append(" = 1 and company.id = '");
        oql.append(companyId).append("'");
        IAsstActTypeDefault iAsstActTypeDflt = AsstActTypeDefaultFactory.getRemoteInstance();
        AsstActTypeDefaultCollection typeDefaultCollection = iAsstActTypeDflt.getAsstActTypeDefaultCollection(oql.toString());
        if (typeDefaultCollection != null && typeDefaultCollection.size() > 0 && typeDefaultCollection.get(0).getAsstActType() != null && typeDefaultCollection.get(0).getAsstActType().getId() != null) {
            return typeDefaultCollection.get(0).getAsstActType().getId().toString();
        }
        return null;
    }

    public static void setOppAccountF7(IUIObject owner, KDBizPromptBox prmptAcct, CompanyOrgUnitInfo company, ArApSysParamInfo sysParam, String currencyID, Boolean isTransBill) throws BOSException, EASBizException {
        List accountIDs;
        IArApBillFacade iArApBillFacade;
        Map accountMap;
        prmptAcct.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        prmptAcct.setDisplayFormat("$number$ $name$");
        prmptAcct.setEditFormat("$number$");
        prmptAcct.setCommitFormat("$number$;$name$");
        prmptAcct.setEditable(true);
        prmptAcct.getQueryAgent().resetRuntimeEntityView();
        String companyId = company.getId().toString();
        String accountTableId = company.getAccountTable().getId().toString();
        AccountTableInfo accountTableInfo = new AccountTableInfo();
        accountTableInfo.setId(company.getAccountTable().getId());
        StringBuffer mask = new StringBuffer();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("companyID.id", (Object)companyId));
        items.add(new FilterItemInfo("isCFreeze", (Object)"0"));
        items.add(new FilterItemInfo("isGFreeze", (Object)"0"));
        items.add(new FilterItemInfo("accountTableID.id", (Object)accountTableId));
        mask.append(" #0 and #1 and #2 and #3 ");
        if (!isTransBill.booleanValue() && (accountMap = (iArApBillFacade = ArApBillFacadeFactory.getRemoteInstance()).getContrastAccount(sysParam.getSysEnum() == SystemEnum.ACCOUNTSRECEIVABLE, company, sysParam.getCurrentAccountTableID(), currencyID)) != null && (accountIDs = (List)accountMap.get("accountIDs")).size() > 0) {
            String strIdLists = StringUtils.arrayToString((Object[])accountIDs.toArray(), (String)",");
            mask.append(" and (#4)");
            items.add(new FilterItemInfo("id", (Object)strIdLists, CompareType.NOTINCLUDE));
        }
        filter.setMaskString(mask.toString());
        prmptAcct.setSelector((KDPromptSelector)new AccountPromptBox(owner, company, accountTableInfo, filter, false, true, true));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        prmptAcct.setEntityViewInfo(view);
    }

    public static void setRecPayAccountF7(IUIObject owner, KDBizPromptBox prmptAcct, CompanyOrgUnitInfo company) {
        prmptAcct.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        prmptAcct.setDisplayFormat("$number$ $name$");
        prmptAcct.setEditFormat("$number$");
        prmptAcct.setCommitFormat("$number$;$name$");
        prmptAcct.setEditable(true);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
        items.add(new FilterItemInfo("isLeaf", (Object)"1"));
        items.add(new FilterItemInfo("isCFreeze", (Object)"0"));
        items.add(new FilterItemInfo("isGFreeze", (Object)"0"));
        items.add(new FilterItemInfo("isCash", (Object)"0"));
        items.add(new FilterItemInfo("isBank", (Object)"0"));
        items.add(new FilterItemInfo("accountTableID.id", (Object)company.getAccountTable().getId()));
        filter.setMaskString(" #0 and #1 and #2 and #3 and #4 and #5 and #6");
        prmptAcct.setSelector((KDPromptSelector)new AccountPromptBox(owner, company, filter));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        prmptAcct.setEntityViewInfo(view);
        prmptAcct.getQueryAgent().setHasCUDefaultFilter(true);
    }

    public static void setContrastAccountF7(IUIObject owner, KDBizPromptBox prmptAcct, CompanyOrgUnitInfo company, boolean fAR, PeriodInfo period, String currencyID, String currentAccountTableID) throws EASBizException, BOSException {
        prmptAcct.setQueryInfo("com.kingdee.eas.fi.ar.app.F7AccountViewQuery");
        prmptAcct.setDisplayFormat("$number$ $name$");
        prmptAcct.setEditFormat("$number$");
        prmptAcct.setCommitFormat("$number$;$name$");
        prmptAcct.setEditable(true);
        StringBuilder mask = new StringBuilder(50);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("ContrastAccountView.system", (Object)(fAR ? String.valueOf(1) : String.valueOf(2))));
        items.add(new FilterItemInfo("company.id", (Object)company.getId(), CompareType.EQUALS));
        items.add(new FilterItemInfo("companyOrgUnit.id", (Object)company.getId(), CompareType.EQUALS));
        items.add(new FilterItemInfo("contrastCU.id", (Object)company.getCU().getId(), CompareType.EQUALS));
        mask.append("#0 AND #1 AND #2 AND #3");
        int maskNo = items.size() - 1;
        if (period == null) {
            period = CommonClientUtils.getCurrPeriod(company, fAR);
        }
        if (period != null) {
            items.add(new FilterItemInfo("ContrastAccountView.periodYear", (Object)new Integer(period.getPeriodYear()), CompareType.EQUALS));
            items.add(new FilterItemInfo("ContrastAccountView.periodNumber", (Object)new Integer(period.getPeriodNumber()), CompareType.EQUALS));
            mask.append(" AND #").append(++maskNo).append(" AND #").append(++maskNo);
        }
        if (currentAccountTableID == null) {
            currentAccountTableID = BaseDataUtil.getCurrentAccountTableID(fAR ? 1 : 2, period, company);
        }
        if (currentAccountTableID != null) {
            items.add(new FilterItemInfo("accountTableID.id", (Object)currentAccountTableID, CompareType.EQUALS));
            mask.append(" AND #").append(++maskNo);
        }
        if (currencyID != null && !"".equals(currencyID)) {
            items.add(new FilterItemInfo("accountingcurrency", (Object)new Integer(2), CompareType.EQUALS));
            mask.append(" AND (#").append(++maskNo).append(" ");
            items.add(new FilterItemInfo("accountingcurrency", (Object)new Integer(1), CompareType.EQUALS));
            items.add(new FilterItemInfo("currency.id", (Object)currencyID, CompareType.EQUALS));
            mask.append(" OR (#").append(++maskNo).append(" AND #").append(++maskNo).append(") ");
            if (company.getBaseCurrency() != null && currencyID.equalsIgnoreCase(company.getBaseCurrency().getId().toString())) {
                items.add(new FilterItemInfo("accountingcurrency", (Object)new Integer(0), CompareType.EQUALS));
                mask.append(" OR #").append(++maskNo).append(" ");
            }
            mask.append(" )");
        }
        filter.setMaskString(mask.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        prmptAcct.setEntityViewInfo(view);
        prmptAcct.getQueryAgent().resetRuntimeEntityView();
    }

    public static void setContrastAccountF7(IUIObject owner, KDBizPromptBox prmptAcct, CompanyOrgUnitInfo company, boolean fAR, PeriodInfo period, String currencyID) throws EASBizException, BOSException {
        CommonClientUtils.setContrastAccountF7(owner, prmptAcct, company, fAR, period, currencyID, null);
    }

    public static void setContrastAccountF7(IUIObject owner, KDBizPromptBox prmptAcct, CompanyOrgUnitInfo company, boolean fAR, PeriodInfo period) throws EASBizException, BOSException {
        CommonClientUtils.setContrastAccountF7(owner, prmptAcct, company, fAR, period, null);
    }

    public static void setContrastAccountF7(IUIObject owner, KDBizPromptBox prmptAcct, CompanyOrgUnitInfo company, boolean fAR) throws EASBizException, BOSException {
        CommonClientUtils.setContrastAccountF7(owner, prmptAcct, company, fAR, null);
    }

    private static boolean getDefaulParam(String system, String number) throws BOSException, EASBizException {
        IParam iParam = ParamFactory.getRemoteInstance();
        StringBuffer oql = new StringBuffer("");
        oql.append(" select * where number ='").append(number).append("'");
        oql.append(" and subSysID ='").append(system).append("'");
        ParamCollection paramCollection = iParam.getParamCollection(oql.toString());
        ParamInfo paramInfo = null;
        if (paramCollection != null) {
            paramInfo = paramCollection.get(0);
            if (paramInfo != null) {
                return "true".equalsIgnoreCase(paramInfo.getDefaultValue()) || "1".equals(paramInfo.getDefaultValue());
            }
            return true;
        }
        return true;
    }

    public static boolean isARBySaleInvouce() throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = CommonClientUtils.getCurrentCompany();
        String companyID = company.getId().toString();
        return CommonClientUtils.isARBySaleInvouce(companyID);
    }

    public static boolean isARBySaleInvouce(String companyID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(companyID);
        ARParamEnum aRParamEnum = ARParamEnum.AR_BY_INV_001;
        String value = ParamControlFactory.getRemoteInstance().getParamValue((IObjectPK)pk, aRParamEnum.getValue());
        if (value == null) {
            return CommonClientUtils.getDefaulParam(SUB_SYSTEM_AR, aRParamEnum.getValue());
        }
        return value.equalsIgnoreCase("true") || value.equals("1");
    }

    public static boolean isAPByPurchaseInvoice() throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = CommonClientUtils.getCurrentCompany();
        String companyID = company.getId().toString();
        return CommonClientUtils.isAPByPurchaseInvoice(companyID);
    }

    public static boolean isAPByPurchaseInvoice(String companyID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(companyID);
        APParamEnum aPParamEnum = APParamEnum.AP_BY_INV_001;
        String value = ParamControlFactory.getRemoteInstance().getParamValue((IObjectPK)pk, aPParamEnum.getValue());
        if (value == null) {
            return CommonClientUtils.getDefaulParam(SUB_SYSTEM_AP, aPParamEnum.getValue());
        }
        return value.equalsIgnoreCase("true") || value.equals("1");
    }

    public static boolean isARRelationSCM() throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = CommonClientUtils.getCurrentCompany();
        String companyID = company.getId().toString();
        return CommonClientUtils.isARRelationSCM(companyID);
    }

    public static boolean isARRelationSCM(String companyID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(companyID);
        ARParamEnum aRParamEnum = ARParamEnum.AR_SCM_001;
        String value = ParamControlFactory.getRemoteInstance().getParamValue((IObjectPK)pk, aRParamEnum.getValue());
        if (value == null) {
            return CommonClientUtils.getDefaulParam(SUB_SYSTEM_AR, aRParamEnum.getValue());
        }
        return value.equalsIgnoreCase("true") || value.equals("1");
    }

    public static boolean isAPRelationSCM() throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = CommonClientUtils.getCurrentCompany();
        String companyID = company.getId().toString();
        return CommonClientUtils.isAPRelationSCM(companyID);
    }

    public static boolean isAPRelationSCM(String companyID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(companyID);
        APParamEnum aPParamEnum = APParamEnum.AP_SCM_001;
        String value = ParamControlFactory.getRemoteInstance().getParamValue((IObjectPK)pk, aPParamEnum.getValue());
        if (value == null) {
            return CommonClientUtils.getDefaulParam(SUB_SYSTEM_AP, aPParamEnum.getValue());
        }
        return value.equalsIgnoreCase("true") || value.equals("1");
    }

    public static boolean isARCheckVoucher() throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = CommonClientUtils.getCurrentCompany();
        String companyID = company.getId().toString();
        return CommonClientUtils.isARCheckVoucher(companyID);
    }

    public static boolean isARCheckVoucher(String companyID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(companyID);
        ARParamEnum aRParamEnum = ARParamEnum.AR_CHECK_VOUCHER_001;
        String value = ParamControlFactory.getRemoteInstance().getParamValue((IObjectPK)pk, aRParamEnum.getValue());
        if (value == null) {
            return CommonClientUtils.getDefaulParam(SUB_SYSTEM_AR, aRParamEnum.getValue());
        }
        return value.equalsIgnoreCase("true") || value.equals("1");
    }

    public static boolean isAPCheckVoucher() throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = CommonClientUtils.getCurrentCompany();
        String companyID = company.getId().toString();
        return CommonClientUtils.isAPCheckVoucher(companyID);
    }

    public static boolean isAPCheckVoucher(String companyID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(companyID);
        APParamEnum aPParamEnum = APParamEnum.AP_CHECK_VOUCHER_001;
        String value = ParamControlFactory.getRemoteInstance().getParamValue((IObjectPK)pk, aPParamEnum.getValue());
        if (value == null) {
            return CommonClientUtils.getDefaulParam(SUB_SYSTEM_AP, aPParamEnum.getValue());
        }
        return value.equalsIgnoreCase("true") || value.equals("1");
    }

    public static boolean isImportBillCanModify() {
        CompanyOrgUnitInfo company = CommonClientUtils.getCurrentCompany();
        return CommonClientUtils.isImportBillCanModify(company.getId().toString());
    }

    public static boolean isImportBillCanModify(String sCompanyId) {
        ObjectUuidPK pk = new ObjectUuidPK(sCompanyId);
        String sParamValue = null;
        try {
            sParamValue = ParamManager.getParamValue(null, (IObjectPK)pk, (String)"G003");
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        if (StringUtils.isEmpty((String)sParamValue)) {
            return false;
        }
        return "true".equalsIgnoreCase(sParamValue) || "1".equals(sParamValue);
    }

    public static boolean isDisplayLocalCurrency() throws EASBizException, BOSException {
        return BadAccountFacadeFactory.getRemoteInstance().isDisplayLocalCurrency();
    }

    private static PeriodInfo getCurrPeriod(CompanyOrgUnitInfo company, boolean fAR) throws BOSException, EASBizException {
        PeriodInfo currePeriod = null;
        currePeriod = fAR ? ArClientUtils.getArCurrentPeriod(company) : ApClientUtils.getApCurrentPeriod(company);
        if (currePeriod == null) {
            currePeriod = fAR ? ArClientUtils.getArStartPeriod(company) : ApClientUtils.getApStartPeriod(company);
        }
        return currePeriod;
    }
}

