/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.util.StringUtils;
import java.util.List;
import java.util.Map;

public class IncomeConfirmAppointAccountFilter {
    public static void setAccountF7(IUIObject owner, KDBizPromptBox f7AccountPromptBox, CompanyOrgUnitInfo company, PeriodInfo period, String currencyID, AccountTableInfo accountTableInfo) throws EASBizException, BOSException {
        String currentAcctTableID = null;
        if (accountTableInfo == null) {
            currentAcctTableID = BaseDataUtil.getCurrentAccountTableID(1, period, company);
            accountTableInfo = BaseDataUtil.getAccountTable(currentAcctTableID);
        } else {
            currentAcctTableID = accountTableInfo.getId().toString();
        }
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        int step = 3;
        StringBuilder mask = new StringBuilder();
        fic.add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
        fic.add(new FilterItemInfo("isGFreeze", (Object)false));
        fic.add(new FilterItemInfo("isCFreeze", (Object)false));
        if (currentAcctTableID != null) {
            fic.add(new FilterItemInfo("accountTableID.id", (Object)currentAcctTableID));
            ++step;
        }
        for (int i = 0; i < step; ++i) {
            if (i != 0) {
                mask.append(" and #" + i);
                continue;
            }
            mask.append("#" + i);
        }
        if (!StringUtils.isEmpty((String)currencyID)) {
            fic.add(new FilterItemInfo("accountingcurrency", (Object)2, CompareType.EQUALS));
            mask.append(" AND (#").append(step++).append(" ");
            fic.add(new FilterItemInfo("accountingcurrency", (Object)1, CompareType.EQUALS));
            fic.add(new FilterItemInfo("accountCurrency.id", (Object)currencyID, CompareType.EQUALS));
            mask.append(" OR (#").append(step++).append(" AND #").append(step++).append(") ");
            if (company.getBaseCurrency() != null && currencyID.equalsIgnoreCase(company.getBaseCurrency().getId().toString())) {
                fic.add(new FilterItemInfo("accountingcurrency", (Object)0, CompareType.EQUALS));
                mask.append(" OR #").append(step++).append(" ");
            }
            mask.append(" )");
        }
        fi.setMaskString(mask.toString());
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(fi);
        f7AccountPromptBox.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        f7AccountPromptBox.setSelector((KDPromptSelector)new AccountPromptBox(owner, company, accountTableInfo, fi, false, true, true));
        f7AccountPromptBox.setVisible(true);
        f7AccountPromptBox.setEditable(true);
        f7AccountPromptBox.setEnabled(true);
        f7AccountPromptBox.setEditFormat("$number$");
        f7AccountPromptBox.setDisplayFormat("$number$ $name$");
        f7AccountPromptBox.setCommitFormat("$number$;$name$");
        f7AccountPromptBox.setEntityViewInfo(viewInfo);
    }

    public static void setContrastAccountF7(KDBizPromptBox prmptAcct, CompanyOrgUnitInfo company, PeriodInfo period, String currencyID, String currentAccountTableID) throws EASBizException, BOSException {
        prmptAcct.setQueryInfo("com.kingdee.eas.fi.ar.app.F7AccountViewQuery");
        prmptAcct.setDisplayFormat("$number$ $name$");
        prmptAcct.setEditFormat("$number$");
        prmptAcct.setCommitFormat("$number$;$name$");
        prmptAcct.setEditable(true);
        StringBuilder mask = new StringBuilder(50);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("ContrastAccountView.system", (Object)String.valueOf(1)));
        items.add(new FilterItemInfo("company.id", (Object)company.getId(), CompareType.EQUALS));
        items.add(new FilterItemInfo("companyOrgUnit.id", (Object)company.getId(), CompareType.EQUALS));
        mask.append("#0 AND #1 AND #2 AND #3");
        int maskNo = items.size() - 1;
        if (period == null) {
            period = IncomeConfirmAppointAccountFilter.getCurrPeriod(company);
        }
        if (period != null) {
            items.add(new FilterItemInfo("ContrastAccountView.periodYear", (Object)new Integer(period.getPeriodYear()), CompareType.EQUALS));
            items.add(new FilterItemInfo("ContrastAccountView.periodNumber", (Object)new Integer(period.getPeriodNumber()), CompareType.EQUALS));
            mask.append(" AND #").append(++maskNo).append(" AND #").append(++maskNo);
        }
        if (currentAccountTableID == null) {
            currentAccountTableID = BaseDataUtil.getCurrentAccountTableID(1, period, company);
        }
        if (currentAccountTableID != null) {
            items.add(new FilterItemInfo("accountTableID.id", (Object)currentAccountTableID, CompareType.EQUALS));
            mask.append(" AND #").append(++maskNo);
        }
        if (currencyID != null && !"".equals(currencyID)) {
            items.add(new FilterItemInfo("accountingcurrency", (Object)new Integer(2), CompareType.EQUALS));
            mask.append(" AND (#").append(++maskNo).append(" ");
            items.add(new FilterItemInfo("accountingcurrency", (Object)new Integer(1), CompareType.EQUALS));
            items.add(new FilterItemInfo("currency.id", (Object)currencyID, CompareType.EQUALS));
            mask.append(" OR (#").append(++maskNo).append(" AND #").append(++maskNo).append(") ");
            if (company.getBaseCurrency() != null && currencyID.equalsIgnoreCase(company.getBaseCurrency().getId().toString())) {
                items.add(new FilterItemInfo("accountingcurrency", (Object)new Integer(0), CompareType.EQUALS));
                mask.append(" OR #").append(++maskNo).append(" ");
            }
            mask.append(" )");
        }
        filter.setMaskString(mask.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        prmptAcct.setEntityViewInfo(view);
        prmptAcct.getQueryAgent().resetRuntimeEntityView();
    }

    private static PeriodInfo getCurrPeriod(CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        PeriodInfo currePeriod = ArClientUtils.getArCurrentPeriod(company);
        if (currePeriod == null) {
            currePeriod = ArClientUtils.getArStartPeriod(company);
        }
        return currePeriod;
    }

    public static void setOppAccountF7(IUIObject owner, KDBizPromptBox prmptAcct, CompanyOrgUnitInfo company, ArApSysParamInfo sysParam, String currencyID, Boolean isTransBill) throws BOSException, EASBizException {
        List accountIDs;
        IArApBillFacade iArApBillFacade;
        Map accountMap;
        prmptAcct.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        prmptAcct.setDisplayFormat("$number$ $name$");
        prmptAcct.setEditFormat("$number$");
        prmptAcct.setCommitFormat("$number$;$name$");
        prmptAcct.setEditable(true);
        prmptAcct.getQueryAgent().resetRuntimeEntityView();
        String companyId = company.getId().toString();
        String accountTableId = company.getAccountTable().getId().toString();
        AccountTableInfo accountTableInfo = new AccountTableInfo();
        accountTableInfo.setId(company.getAccountTable().getId());
        StringBuffer mask = new StringBuffer();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("companyID.id", (Object)companyId));
        items.add(new FilterItemInfo("isCFreeze", (Object)"0"));
        items.add(new FilterItemInfo("isGFreeze", (Object)"0"));
        items.add(new FilterItemInfo("accountTableID.id", (Object)accountTableId));
        mask.append(" #0 and #1 and #2 and #3 ");
        if (!isTransBill.booleanValue() && (accountMap = (iArApBillFacade = ArApBillFacadeFactory.getRemoteInstance()).getContrastAccount(sysParam.getSysEnum() == SystemEnum.ACCOUNTSRECEIVABLE, company, sysParam.getCurrentAccountTableID(), currencyID)) != null && (accountIDs = (List)accountMap.get("accountIDs")).size() > 0) {
            String strIdLists = StringUtils.arrayToString((Object[])accountIDs.toArray(), (String)",");
            mask.append(" and (#4)");
            items.add(new FilterItemInfo("id", (Object)strIdLists, CompareType.NOTINCLUDE));
        }
        filter.setMaskString(mask.toString());
        prmptAcct.setSelector((KDPromptSelector)new AccountPromptBox(owner, company, accountTableInfo, filter, false, true, true));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        prmptAcct.setEntityViewInfo(view);
    }

    public static void setIncomeConfirmF7Account(IUIObject owner, KDBizPromptBox f7AccountPromptBox, PeriodInfo period, CompanyOrgUnitInfo companyInfo, AccountTableInfo accountTableInfo, String currencyID) throws EASBizException, BOSException {
        String currentAcctTableID = null;
        if (accountTableInfo == null) {
            currentAcctTableID = BaseDataUtil.getCurrentAccountTableID(1, period, companyInfo);
            accountTableInfo = BaseDataUtil.getAccountTable(currentAcctTableID);
        } else {
            currentAcctTableID = accountTableInfo.getId().toString();
        }
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        int step = 3;
        StringBuilder mask = new StringBuilder();
        fic.add(new FilterItemInfo("companyID.id", (Object)companyInfo.getId().toString()));
        fic.add(new FilterItemInfo("isGFreeze", (Object)false));
        fic.add(new FilterItemInfo("isCFreeze", (Object)false));
        if (currentAcctTableID != null) {
            fic.add(new FilterItemInfo("accountTableID.id", (Object)currentAcctTableID));
            ++step;
        }
        for (int i = 0; i < step; ++i) {
            if (i != 0) {
                mask.append(" and #" + i);
                continue;
            }
            mask.append("#" + i);
        }
        if (!StringUtils.isEmpty((String)currencyID)) {
            fic.add(new FilterItemInfo("accountingcurrency", (Object)2, CompareType.EQUALS));
            mask.append(" AND (#").append(step++).append(" ");
            fic.add(new FilterItemInfo("accountingcurrency", (Object)1, CompareType.EQUALS));
            fic.add(new FilterItemInfo("accountCurrency.id", (Object)("select fid from t_bd_accountcurrency where FCURRENCYID = '" + currencyID + "'"), CompareType.INNER));
            mask.append(" OR (#").append(step++).append(" AND #").append(step++).append(") ");
            if (companyInfo.getBaseCurrency() != null && currencyID.equalsIgnoreCase(companyInfo.getBaseCurrency().getId().toString())) {
                fic.add(new FilterItemInfo("accountingcurrency", (Object)0, CompareType.EQUALS));
                mask.append(" OR #").append(step++).append(" ");
            }
            mask.append(" )");
        }
        fi.setMaskString(mask.toString());
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(fi);
        f7AccountPromptBox.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        f7AccountPromptBox.setSelector((KDPromptSelector)new AccountPromptBox(owner, companyInfo, accountTableInfo, fi, false, true, true));
        f7AccountPromptBox.setVisible(true);
        f7AccountPromptBox.setEditable(true);
        f7AccountPromptBox.setEnabled(true);
        f7AccountPromptBox.setEditFormat("$number$");
        f7AccountPromptBox.setDisplayFormat("$number$ $name$");
        f7AccountPromptBox.setCommitFormat("$number$;$name$");
        f7AccountPromptBox.setEntityViewInfo(viewInfo);
    }
}

