/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.util;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamItem;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.IArApBillBase;
import com.kingdee.eas.fi.ar.ImportLog;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.util.ImportDataUtil;
import com.kingdee.eas.fi.arap.ARAPImportFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.IARAPImportFacade;
import com.kingdee.eas.fi.arap.client.ArApProcessUI;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.AbstractExternalDataReader;
import com.kingdee.eas.tools.datatask.runtime.ExternalCSVDataReader;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelDataReader;
import com.kingdee.eas.tools.datatask.runtime.ExternalStructInfo;
import com.kingdee.eas.tools.datatask.runtime.ExternalTextDataReader;
import com.kingdee.eas.tools.datatask.runtime.FileFormatNotStandardException;
import com.kingdee.eas.util.client.EASResource;
import java.io.File;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ArApOtherBillImportHelper {
    private static final Logger logger = Logger.getLogger(ArApOtherBillImportHelper.class);
    private static final String RES = "com.kingdee.eas.fi.ar.client.VerificateResource";
    private static final int AR_FIELD_NUMBER = 48;
    private static final int AP_FIELD_NUMBER = 44;
    private static final int ARAP_PROXY_FIELD_NUMBER = 49;
    private static final String AR = "AR";
    private static final String AP = "AP";
    private static final String PROXY = "PROXY";
    private File dataFile = null;
    private String postFix = null;

    public ArApOtherBillImportHelper(File file) {
        this.dataFile = file;
    }

    private void setPathFix(String path) {
        this.postFix = path.substring(path.lastIndexOf(".") + 1);
    }

    private AbstractExternalDataReader getFileReader() throws TaskExternalException {
        ExternalCSVDataReader fileReader = null;
        String path = this.dataFile.getAbsolutePath();
        int lastDotInd = path.lastIndexOf(".");
        if (lastDotInd == -1 || lastDotInd + 1 == path.length()) {
            String msg = EASResource.getString((String)RES, (String)"UnknownFileType");
            logger.error((Object)msg);
            throw new TaskExternalException(msg);
        }
        this.postFix = path.substring(lastDotInd + 1);
        if (this.postFix.equalsIgnoreCase("csv")) {
            fileReader = new ExternalCSVDataReader();
        } else if (this.postFix.equalsIgnoreCase("txt")) {
            fileReader = new ExternalTextDataReader();
        } else if (this.postFix.equalsIgnoreCase("xls")) {
            fileReader = new ExternalExcelDataReader();
        }
        if (fileReader == null) {
            String msg = EASResource.getString((String)RES, (String)"UnsupportedFile");
            logger.error((Object)msg);
            throw new TaskExternalException(msg);
        }
        fileReader.setLocacle(SysContext.getSysContext().getLocale());
        return fileReader;
    }

    public ImportLog importData(CoreUI uiObject, ArApSysParamInfo cache, final String fAR) throws Exception {
        final ImportLog log = new ImportLog();
        log.dataFile = this.dataFile.getAbsolutePath();
        this.setPathFix(this.dataFile.getAbsolutePath());
        AbstractExternalDataReader fileReader = this.getFileReader();
        if (fileReader == null) {
            String msg = EASResource.getString((String)RES, (String)"UnknownFileType");
            logger.error((Object)msg);
            throw new TaskExternalException(msg);
        }
        try {
            fileReader.openFile(this.dataFile.getAbsolutePath());
        }
        catch (FileFormatNotStandardException ex) {
            log.errList.add(ex.getMessage());
            return log;
        }
        fileReader.calculatorRowCount();
        boolean isConnSCM = "true".equals(cache.getParamValueMap().get(fAR.equalsIgnoreCase(AR) ? "AR_SCM_001" : "AP_SCM_001"));
        IARAPImportFacade iARAPImportFacade = ARAPImportFacadeFactory.getRemoteInstance();
        boolean isImportDataByRule = iARAPImportFacade.getImportParam(fAR);
        Map dataRow = null;
        ExternalStructInfo fieldsInfo = fileReader.getExternalStructInfo();
        final ArrayList fieldNameList = fieldsInfo.getFieldCollection();
        final ArrayList<Map> dataRowList = new ArrayList<Map>();
        final ArrayList headDefineFieldListList = new ArrayList();
        final ArrayList entryDefineFieldListList = new ArrayList();
        ArrayList<String> ids = new ArrayList<String>();
        final LinkedHashSet idSet = new LinkedHashSet();
        BigDecimal total = BigDecimal.ZERO;
        while (fileReader.hasNext()) {
            fileReader.getCurrentRow();
            try {
                dataRow = fileReader.getNext();
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage());
            }
            if (dataRow == null || dataRow.size() == 0) continue;
            ArrayList<String> headDefineFieldList = new ArrayList<String>();
            ArrayList<String> entryDefineFieldList = new ArrayList<String>();
            for (int i = 0; i < fieldNameList.size(); ++i) {
                String defineFieldName = fieldNameList.get(i).toString();
                if (defineFieldName.indexOf("#") > -1) {
                    headDefineFieldList.add(defineFieldName);
                    continue;
                }
                if (defineFieldName.indexOf("*") <= -1) continue;
                entryDefineFieldList.add(defineFieldName);
            }
            ++log.billCount;
            ids.add(BOSUuid.create((String)"ARIMPORT").toString());
            dataRow.put("isConnSCM", isConnSCM);
            dataRow.put("isImportDataByRule", isImportDataByRule);
            dataRow.put("isSCM", cache.isSCM());
            dataRow.put("isAR", fAR.equalsIgnoreCase(AR));
            dataRowList.add(dataRow);
            headDefineFieldListList.add(headDefineFieldList);
            entryDefineFieldListList.add(entryDefineFieldList);
        }
        log.totalAmount = total;
        ArApProcessUI.LongTimeProcess doit = new ArApProcessUI.LongTimeProcess(){

            @Override
            public void doit(IObjectPK pk) throws Exception {
                ++log.index;
                if (fAR.equalsIgnoreCase(ArApOtherBillImportHelper.AR)) {
                    if (fieldNameList.size() < 48) {
                        throw new TaskExternalException(ImportDataUtil.getResource("Column_Count_Error"));
                    }
                    pk = ARAPImportFacadeFactory.getRemoteInstance().transfer((Hashtable)dataRowList.get(log.index), fAR, (ArrayList)headDefineFieldListList.get(log.index), (ArrayList)entryDefineFieldListList.get(log.index));
                    idSet.add(pk.toString());
                } else if (fAR.equalsIgnoreCase(ArApOtherBillImportHelper.AP)) {
                    if (fieldNameList.size() < 44) {
                        throw new TaskExternalException(ImportDataUtil.getResource("Column_Count_Error"));
                    }
                    pk = ARAPImportFacadeFactory.getRemoteInstance().transfer((Hashtable)dataRowList.get(log.index), fAR, (ArrayList)headDefineFieldListList.get(log.index), (ArrayList)entryDefineFieldListList.get(log.index));
                    idSet.add(pk.toString());
                } else if (fAR.equalsIgnoreCase(ArApOtherBillImportHelper.PROXY)) {
                    if (fieldNameList.size() < 49) {
                        throw new TaskExternalException(ImportDataUtil.getResource("Column_Count_Error"));
                    }
                    pk = ARAPImportFacadeFactory.getRemoteInstance().transfer((Hashtable)dataRowList.get(log.index), fAR, (ArrayList)headDefineFieldListList.get(log.index), (ArrayList)entryDefineFieldListList.get(log.index));
                    idSet.add(pk.toString());
                }
                ++log.newCount;
            }

            @Override
            public boolean doit(List pkList) throws Exception {
                return false;
            }

            @Override
            public boolean notShowCount() {
                return false;
            }
        };
        ArApProcessUI.LongTimeProcessDoExcept doexcept = new ArApProcessUI.LongTimeProcessDoExcept(){
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.ar.ARImportData", (String)"154_IMPORT_SUMMARY");

            @Override
            public void doexcept(IObjectPK pk, Exception ex) {
                String errMsg = "";
                errMsg = ex.getMessage() == null ? ImportDataUtil.getResource("SystemError") : (ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage());
                ++log.failCount;
                log.errList.add(MessageFormat.format(this.msg, log.index + 1, errMsg));
            }

            @Override
            public void doexcept(List ids, Exception ex) {
            }
        };
        String title = "";
        if (fAR.equalsIgnoreCase(AR)) {
            title = ArApBillUIUtil.getStrResource("arBill");
        } else if (fAR.equalsIgnoreCase(AP)) {
            title = ArApBillUIUtil.getStrResource("apBill");
        }
        ArApProcessUI.process((IUIObject)uiObject, doit, ids, doexcept, title);
        if (isImportDataByRule) {
            ARAPImportFacadeFactory.getRemoteInstance().updateBatchNumber(cache.getCompanyId(), idSet, fAR);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("amount"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        IArApBillBase iBase = null;
        if (fAR.equalsIgnoreCase(AR)) {
            iBase = OtherBillFactory.getRemoteInstance();
        } else if (fAR.equalsIgnoreCase(AP)) {
            iBase = com.kingdee.eas.fi.ap.OtherBillFactory.getRemoteInstance();
        }
        if (iBase != null) {
            CoreBillBaseCollection billColl = iBase.getCoreBillBaseCollection(view);
            BigDecimal sum = BigDecimal.ZERO;
            int size = billColl.size();
            for (int i = 0; i < size; ++i) {
                sum = sum.add(billColl.get(i).getBigDecimal("amount"));
            }
            log.actualAmount = sum;
        }
        return log;
    }

    private static boolean getImportParam() {
        boolean isByRule = false;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("Value"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("keyID.subSysID", (Object)"0000", CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("keyID.number", (Object)"importDataByRule", CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        try {
            IParamItem iParamItem = ParamItemFactory.getRemoteInstance();
            ParamItemCollection collection = iParamItem.getParamItemCollection(entityViewInfo);
            if (collection == null || collection.size() == 0) {
                return isByRule;
            }
            ParamItemInfo info = collection.get(0);
            String value = info.getValue();
            if (value != null && value.equals("true")) {
                isByRule = true;
            }
        }
        catch (Exception e) {
            isByRule = false;
        }
        return isByRule;
    }
}

