/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.AccountBadDebtCustPrepareFactory;
import com.kingdee.eas.fi.ar.AccountBadDebtCustPrepareInfo;
import com.kingdee.eas.fi.ar.IAccountBadDebtCustPrepare;
import com.kingdee.eas.fi.ar.util.ImportDataUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseCollection;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class BadAcctImporter {
    private static final Logger logger = CoreUIObject.getLogger(BadAcctImporter.class);
    private CompanyOrgUnitInfo currentCompany = null;
    String[] DECIMAL_FIELDS = new String[]{"FExchangeRate", "FPrepareAmount"};
    String[] DECIMAL_OBJS = new String[]{"exchangeRate", "prepareAmount"};

    public BadAcctImporter() throws Exception {
        try {
            this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw new TaskExternalException("Get System Context Error!");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CoreBaseInfo transfer(Map hsData, ArrayList defineFieldList) throws TaskExternalException {
        AccountBadDebtCustPrepareInfo prepareInfo = new AccountBadDebtCustPrepareInfo();
        Object objVal = null;
        String str = null;
        Object data = null;
        for (int i = 0; i < this.DECIMAL_FIELDS.length; ++i) {
            try {
                objVal = ((DataToken)hsData.get((Object)this.DECIMAL_FIELDS[i])).data;
                str = objVal.toString();
                BigDecimal amtVal = null;
                if (!StringUtils.isEmpty((String)str)) {
                    amtVal = new BigDecimal(str);
                    if (amtVal == null) continue;
                    prepareInfo.setBigDecimal(this.DECIMAL_OBJS[i], amtVal);
                    continue;
                }
                amtVal = new BigDecimal(0.0);
                prepareInfo.setBigDecimal(this.DECIMAL_OBJS[i], amtVal);
                continue;
            }
            catch (Exception nex) {
                logger.error((Object)nex);
                String msg = ImportDataUtil.getResource("NumberField_Wrong");
                msg = MessageFormat.format(msg, this.DECIMAL_FIELDS[i]);
                throw new TaskExternalException(msg);
            }
        }
        data = ((DataToken)hsData.get((Object)"FExchangeRate")).data;
        if (data != null) {
            BigDecimal exchangeRate = new BigDecimal(data.toString());
            prepareInfo.setExchangeRate(exchangeRate);
        } else {
            prepareInfo.setExchangeRate(new BigDecimal("0.0"));
        }
        data = ((DataToken)hsData.get((Object)"FPrepareAmount")).data;
        if (data != null) {
            BigDecimal prepareAmount = new BigDecimal(data.toString());
            prepareInfo.setPrepareAmount(prepareAmount);
            prepareInfo.setLastPrepareAmount(prepareAmount);
        } else {
            prepareInfo.setPrepareAmount(new BigDecimal("0.0"));
            prepareInfo.setLastPrepareAmount(new BigDecimal("0.0"));
        }
        data = ((DataToken)hsData.get((Object)"FCustomerNumber")).data;
        if (data != null) {
            prepareInfo.setCustomerNumber(data.toString());
        }
        try {
            CompanyOrgUnitInfo info;
            String companyNumber;
            String customerNumber;
            UserInfo userInfo = null;
            data = ((DataToken)hsData.get((Object)"FCreatorID")).data;
            if (data != null) {
                str = data.toString();
                if (str.length() > 0) {
                    userInfo = this.getUserFromNumber(str);
                    if (userInfo == null) {
                        String msg = ImportDataUtil.getResource("FieldId_Wrong");
                        msg = MessageFormat.format(msg, "FCreatorID");
                        throw new TaskExternalException(msg);
                    }
                    prepareInfo.setCreator(userInfo);
                } else {
                    userInfo = SysContext.getSysContext().getCurrentUserInfo();
                    prepareInfo.setCreator(userInfo);
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FLastUpdateUserID")).data) != null && (userInfo = this.getUserFromNumber(str = data.toString())) != null) {
                prepareInfo.setLastUpdateUser(userInfo);
            }
            String cuNumber = null;
            data = ((DataToken)hsData.get((Object)"FControlUnitID")).data;
            CtrlUnitInfo cuInfo = null;
            if (data != null) {
                cuNumber = str = ((DataToken)hsData.get((Object)"FControlUnitID")).data.toString();
                if (str != null && str.length() > 0 && (cuInfo = this.getCU(str)) != null) {
                    prepareInfo.setCU(cuInfo);
                }
            }
            if (cuInfo == null) {
                prepareInfo.setCU(this.currentCompany.getCU());
                cuNumber = this.currentCompany.getCU().getNumber();
            }
            String currencyNumber = null;
            data = ((DataToken)hsData.get((Object)"FCurrencyID")).data;
            if (data == null) {
                String msg = ImportDataUtil.getResource("FieldEmpty_Wrong");
                msg = MessageFormat.format(msg, "FCurrency");
                throw new TaskExternalException(msg);
            }
            currencyNumber = str = data.toString();
            if (str != null && str.trim().length() > 0) {
                CurrencyInfo info2 = this.getCurrencyFromNumber(str);
                if (info2 == null) {
                    String msg = ImportDataUtil.getResource("FieldId_Wrong");
                    msg = MessageFormat.format(msg, "FCurrency");
                    throw new TaskExternalException(msg);
                }
                prepareInfo.setCurrency(info2);
                customerNumber = null;
                data = ((DataToken)hsData.get((Object)"FCustomerID")).data;
                if (data == null) {
                    String msg = ImportDataUtil.getResource("FieldEmpty_Wrong");
                    msg = MessageFormat.format(msg, "FCustomer");
                    throw new TaskExternalException(msg);
                }
            } else {
                String msg = ImportDataUtil.getResource("FieldEmpty_Wrong");
                msg = MessageFormat.format(msg, "FCurrency");
                throw new TaskExternalException(msg);
            }
            customerNumber = str = data.toString();
            if (str != null && str.trim().length() > 0) {
                CustomerInfo info3 = this.getCustomerFromNumber(str);
                if (info3 == null) {
                    String msg = ImportDataUtil.getResource("FieldId_Wrong");
                    msg = MessageFormat.format(msg, "FCustomer");
                    throw new TaskExternalException(msg);
                }
                prepareInfo.setCustomer(info3);
                data = ((DataToken)hsData.get((Object)"FCompanyID")).data;
                String msg_Company = ImportDataUtil.getResource("FieldEmpty_Wrong");
                msg_Company = MessageFormat.format(msg_Company, "FCompanyID");
                companyNumber = null;
                if (data == null) throw new TaskExternalException(msg_Company);
                companyNumber = str = data.toString();
                if (str == null) throw new TaskExternalException(msg_Company);
                if (str.trim().length() <= 0) throw new TaskExternalException(msg_Company);
                info = this.getCompanyFromNumber(str);
                if (info == null) {
                    String msg = ImportDataUtil.getResource("FieldId_Wrong");
                    msg = MessageFormat.format(msg, "FCompany");
                    throw new TaskExternalException(msg);
                }
            } else {
                String msg = ImportDataUtil.getResource("FieldEmpty_Wrong");
                msg = MessageFormat.format(msg, "FCustomer");
                throw new TaskExternalException(msg);
            }
            prepareInfo.setCompany(info);
            this.checkData(companyNumber, cuNumber, customerNumber, currencyNumber);
            return prepareInfo;
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo) throws TaskExternalException {
        ICoreBase iCustPrepare = this.getController();
        AccountBadDebtCustPrepareInfo parepareInfo = (AccountBadDebtCustPrepareInfo)coreBaseInfo;
        String errMsg = null;
        try {
            if (coreBaseInfo.getId() == null || !iCustPrepare.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                iCustPrepare.save((CoreBaseInfo)parepareInfo);
            } else {
                iCustPrepare.update((IObjectPK)new ObjectUuidPK(parepareInfo.getId()), (CoreBaseInfo)parepareInfo);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            errMsg = ex.getMessage() == null ? ImportDataUtil.getResource("SystemError") : ex.getMessage();
            throw new TaskExternalException(errMsg);
        }
    }

    protected ICoreBase getController() throws TaskExternalException {
        try {
            return AccountBadDebtCustPrepareFactory.getRemoteInstance();
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    private UserInfo getUserFromNumber(String number) throws BOSException, EASBizException {
        UserCollection users;
        IUser iuser = UserFactory.getRemoteInstance();
        UserInfo userInfo = null;
        if (number != null && number.trim().length() > 0 && (users = iuser.getUserCollection("where number='" + number + "'")) != null && users.size() > 0) {
            userInfo = users.get(0);
        }
        return userInfo;
    }

    private CurrencyInfo getCurrencyFromNumber(String number) throws BOSException, EASBizException {
        CurrencyCollection currencyColl;
        ICurrency icurreny = CurrencyFactory.getRemoteInstance();
        CurrencyInfo currencyInfo = null;
        if (number != null && number.trim().length() > 0 && (currencyColl = icurreny.getCurrencyCollection("where number='" + number + "'")) != null && currencyColl.size() > 0) {
            currencyInfo = currencyColl.get(0);
        }
        return currencyInfo;
    }

    private CustomerInfo getCustomerFromNumber(String number) throws BOSException, EASBizException {
        CustomerCollection customerColl;
        ICustomer icustomer = CustomerFactory.getRemoteInstance();
        CustomerInfo customerInfo = null;
        if (number != null && number.trim().length() > 0 && (customerColl = icustomer.getCustomerCollection("where  number='" + number + "'")) != null && customerColl.size() > 0) {
            customerInfo = customerColl.get(0);
        }
        return customerInfo;
    }

    private CompanyOrgUnitInfo getCompanyFromNumber(String number) throws BOSException, EASBizException {
        CompanyOrgUnitCollection companyColl;
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getRemoteInstance();
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        if (number != null && number.trim().length() > 0 && (companyColl = iCompany.getCompanyOrgUnitCollection("where  number='" + number + "'")) != null && companyColl.size() > 0) {
            companyOrgUnitInfo = companyColl.get(0);
        }
        return companyOrgUnitInfo;
    }

    private CtrlUnitInfo getCU(String number) throws BOSException, EASBizException {
        CtrlUnitCollection cuCollection;
        ICtrlUnit ictrlUnit = CtrlUnitFactory.getRemoteInstance();
        CtrlUnitInfo cuinfo = null;
        if (number != null && number.trim().length() > 0 && (cuCollection = ictrlUnit.getCtrlUnitCollection("where number='" + number + "'")) != null && cuCollection.size() > 0) {
            cuinfo = cuCollection.get(0);
        }
        return cuinfo;
    }

    private void checkData(String companyNumber, String CU, String customerNumber, String currencyNumber) throws BOSException, EASBizException {
        ObjectBaseCollection objectBaseCollection;
        IAccountBadDebtCustPrepare iPrepare = AccountBadDebtCustPrepareFactory.getRemoteInstance();
        String companyID = null;
        String CUID = null;
        String customerID = null;
        String currencyID = null;
        CompanyOrgUnitInfo company = this.getCompanyFromNumber(companyNumber);
        CtrlUnitInfo cuInfo = this.getCU(CU);
        CustomerInfo customerInfo = this.getCustomerFromNumber(customerNumber);
        CurrencyInfo currencyInfo = this.getCurrencyFromNumber(currencyNumber);
        if (company != null) {
            companyID = company.getId().toString();
        }
        if (cuInfo != null) {
            CUID = cuInfo.getId().toString();
        }
        if (customerInfo != null) {
            customerID = customerInfo.getId().toString();
        }
        if (currencyInfo != null) {
            currencyID = currencyInfo.getId().toString();
        }
        if ((objectBaseCollection = iPrepare.getObjectBaseCollection("where company='" + companyID + "' and cu='" + CUID + "' and customer='" + customerID + "' and currency='" + currencyID + "'")).size() > 0) {
            iPrepare.delete("where company='" + companyID + "' and cu='" + CUID + "' and customer='" + customerID + "' and currency='" + currencyID + "'");
        }
    }
}

